<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1> <cv:msg key="label.EditContent" bundle="fs"/> </h1>
</div>
<div class="bootstrap-wrapper" >
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="updateSubclientForm" novalidate autocomplete="off" data-cv-submit="oraUpdateSub.updateSubclient()" >
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" data-ng-if="!oraUpdateSub.isOracleRac && !oraUpdateSub.isOracleArchiveLogSubclient">
					<label class="col-xs-12 col-lg-5" for="noOfStreams">
						<cv:msg key="label.noOfStreams" bundle="job" />
					</label>
					<div class="col-xs-12 col-lg-7" >
						<input  type="number" id="noOfStreams" name="noOfStreams" required min="1" max="100" step="1" data-ng-model="oraUpdateSub.subclientInfo.streams" />
						<span class="help-block" data-ng-show="cv.updateSubclientForm.needsAttention(updateSubclientForm.noOfStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!oraUpdateSub.isOracleArchiveLogSubclient">
					<label class="col-xs-12 col-lg-5" for="dataFiles" >
						<cv-help-text help-label="<cv:msg key="label.dataFiles" bundle="oracle" />"
							help-text="'<cv:msg key="label.rmanMultip" bundle="oracle" />'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="number" id="dataFiles" min="1" max="1000" step="1" name="dataFiles" required data-ng-model="oraUpdateSub.subclientInfo.dataFiles"  />
						<span class="help-block" data-ng-show="cv.updateSubclientForm.needsAttention(updateSubclientForm.dataFiles)">
							<cv:msg key="error.dataFiles" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group" >
					<label class="col-xs-12 col-lg-5" for="archiveFiles" >
						<cv-help-text help-label="<cv:msg key="label.archiveFiles" bundle="oracle" />"
							help-text="'<cv:msg key="label.rmanMultip" bundle="oracle" />'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="number" id="archiveFiles"  min="1" max="1000" step="1"  name="archiveFiles" required data-ng-model="oraUpdateSub.subclientInfo.archiveFiles"  />
						<span class="help-block" data-ng-show="cv.updateSubclientForm.needsAttention(updateSubclientForm.archiveFiles)">
							<cv:msg key="error.archiveFiles" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group" >
					<label class="col-xs-12 col-lg-5" for="maxOpenFiles" >
						<cv-help-text help-label="<cv:msg key="label.maxOpenFiles" bundle="oracle" />"
							help-text="'<cv:msg key="label.rmanMultip" bundle="oracle" />'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="number" id="maxOpenFiles" name="maxOpenFiles" required data-ng-model="oraUpdateSub.subclientInfo.maxOpenFiles"  />
						<span class="help-block" data-ng-show="cv.updateSubclientForm.needsAttention(updateSubclientForm.maxOpenFiles)">
							<cv:msg key="error.maxOpenFiles" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!oraUpdateSub.isOracleArchiveLogSubclient">
					<label class="col-xs-12 col-lg-5" for="rmanBackupSetSize" >
						<cv:msg key="label.rmanBackupSetSize" bundle="oracle" />
					</label>
					<div class="col-xs-12 col-lg-3 padding-right-0">
						<select id="sizeType" name="restoreMode"  data-ng-required="true"
							data-ng-model="oraUpdateSub.subclientInfo.sizeType"
							data-ng-change="oraUpdateSub.subclientInfo.updateSelectiveOption()"
							data-ng-options="sizeType as sizeType for sizeType in oraUpdateSub.sizeTypes " >
						</select>
					</div>
					<div class="col-xs-12 col-lg-2">
						<input type="number" id="sizeValue" min="0" max="1024" step="1" name="sizeValue" data-ng-model="oraUpdateSub.subclientInfo.sizeValue"  />
					</div>
					<div class="col-xs-12 col-lg-2">
						<select id="sizeMode" name="restoreMode"  data-ng-required="true"
							data-ng-model="oraUpdateSub.subclientInfo.backupMode"
							data-ng-change="oraUpdateSub.updateSelectiveOption()"
							data-ng-options="sizeMode as sizeMode for sizeMode in oraUpdateSub.sizeModes " >
						</select>
					</div>
				</div>

				<div class="button-container" >
					<button id="oracleUpdateSubclient_bunnntton_Cancel" type="button" class="btn btn-default" data-ng-click="oraUpdateSub.closeModal()"><cv:msg key="Cancel" bundle="messages" /></button>
					<button id="oracleUpdateSubclient_button_Submit" type="submit" class="btn btn-primary" ><cv:msg key="Save" bundle="messages" /></button>
				</div>
			</div>
		</div>
	</form>
</div>