<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="restoreForm" novalidate data-cv-submit="otlRestore.submitRestore()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
			<div class="form-group" >
				<label class="col-xs-12 col-lg-5" for="destinationServer">
					<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-lg-7">
					<cv-isteven-single-select id-name="destinationServer"
						input-model="otlRestore.restoreData.destinationServerList"
						binding-model="otlRestore.restoreData.destinationServer"
						track-field="clientId"
						label="displayName"
						tick-property="selected"
						on-change="otlRestore.destinationServerChanged(otlRestore.restoreData.destinationServer)"
						place-holder='<cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/>'
						help-text='<cv:msg key="error.oracleVmDestinationServer" bundle="restore"/>'
						required = "true">
					</cv-isteven-single-select>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12 col-lg-12">
					<input type="checkbox" id="auxilariyIns" name="auxilariyIns" data-ng-model="otlRestore.restoreData.auxilariyInstance" />
					<label for="auxilariyIns">
						<cv:msg key="label.createAuxiliaryInstance" bundle="oracle"/>
					</label>
				</div>
			</div>
			<div class="form-group" data-ng-if="!otlRestore.restoreData.auxilariyInstance">
				<label class="col-xs-12 col-lg-5" for="destinationInstance">
					<cv:msg key="label.auxiliaryInstance" bundle="oracle"/>
				</label>
				<div class="col-xs-12 col-lg-7">
					<cv-isteven-single-select id-name="destinationInstance"
							input-model="otlRestore.restoreData.destinationInstanceList"
							binding-model="otlRestore.restoreData.destinationInstance"
							track-field="instanceId"
							label="instanceName"
							tick-property="selected"
							disable-property="disabled"
							place-holder='<cv:msg key="error.auxiliaryInstance" bundle="oracle"/>'
							help-text='<cv:msg key="error.auxiliaryInstance" bundle="oracle"/>'
							required = "true">
					</cv-isteven-single-select>
				</div>
			</div>
			<cv-restore-streams streams="otlRestore.restoreData.streams"/>
			<div class="form-group" >
				<label class="col-xs-12 col-lg-5" for="pFile">
					<cv:msg key="label.pFile" bundle="oracle" />
				</label>
				<div  class="col-xs-12 col-lg-7">
					<div class="input-group">
						<input  type="text" id="pFile" name="pFile" data-ng-required="!otlRestore.restoreData.auxilariyInstance" data-ng-model="otlRestore.restoreData.pFile" />
						<div class="input-group-btn" data-ng-disabled="!otlRestore.restoreData.destinationServer.clientId">
							<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{otlRestore.restoreData.destinationServer.clientId}}' result-function="otlRestore.pFileResuleFunction"/>
						</div>
					</div>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.pFile)">
						<cv:msg key="error.oraPfile" bundle="oracle" />
					</span>
				</div>
			</div>
			<div class="form-group" >
				<label class="col-xs-12 col-lg-5" for="stagingPath">
					<cv:msg key="label.stagingPath" bundle="oracle" />
				</label>
				<div  class="col-xs-12 col-lg-7">
					<div class="input-group">
						<input  type="text" id="stagingPath" name="stagingPath" required data-ng-model="otlRestore.restoreData.stagingPath" />
						<div class="input-group-btn" data-ng-disabled="!otlRestore.restoreData.destinationServer.clientId" >
							<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{otlRestore.restoreData.destinationServer.clientId}}' result-function="otlRestore.stagingPathResuleFunction"/>
						</div>
					</div>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.stagingPath)">
						<cv:msg key="error.stagingPath" bundle="oracle" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-12" >
					 <cv:msg key="label.recoverTo" bundle="oracle"/>
				</label>
			</div>
			<div class="form-group">
				<label class="col-xs-1 col-lg-1">
				</label>
				<div class="col-xs-1 col-lg-4">
					<input type="radio" data-ng-model="otlRestore.restoreData.pitType" value="1" id="pitDate1" name="mostRecent" />
					<label for="pitDate1"><cv:msg key="label.pit" bundle="oracle" /></label>
				</div>
				<div class="col-xs-1 col-lg-7" data-ng-disabled="(otlRestore.restoreData.pitType != '1')">
					<cv-date-time-picker date-format="otlRestore.restoreData.pitTimeFormat" date-time-Value="otlRestore.restoreData.pitDate" ></cv-date-time-picker>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dateTimeValue) || pitError">
						<cv:msg key="error.pit" bundle="oracle" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-1 col-lg-1">
				</label>
				<div class="col-xs-11 col-lg-4">
					<input type="radio" data-ng-model="otlRestore.restoreData.pitType" value="2" id="scn" name="mostRecent" />
					<label for="scn"> <cv:msg key="label.scn" bundle="oracle" /> </label>
				</div>
				<div class="col-xs-1 col-lg-7" data-ng-disabled="(otlRestore.restoreData.pitType != '2')">
					<input  type="text" id="pitScn" name="pitScn"  data-ng-pattern="/^\d+$/"
					 data-ng-required="(otlRestore.restoreData.pitType == '2')" data-ng-model="otlRestore.restoreData.pitScn" />
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.pitScn)">
						<cv:msg key="error.pitScn" bundle="oracle"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-5 col-lg-5">
					<input type="checkbox" data-ng-model="otlRestore.restoreData.exportParam" id="exportParam" name="exportParam" />
					<label for="exportParam"> <cv:msg key="label.exportParameters" bundle="oracle"/> </label>
				</div>
				<div class="col-xs-7 col-lg-7" data-ng-disabled="!otlRestore.restoreData.exportParam">
					<input  type="text" id="exportParam" name="exportParamValue" data-ng-required="(otlRestore.restoreData.exportParam === true )" data-ng-model="otlRestore.restoreData.exportParamValue" />
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.exportParamValue)">
						<cv:msg key="error.exportParameters" bundle="oracle"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12 col-lg-12" >
					<input type="checkbox" data-ng-model="otlRestore.restoreData.importOption" id="importOption" name="importOption" />
					<label for="importOption"> <cv:msg key="label.importToSourceInstance" bundle="oracle"/>  </label>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12 col-lg-12" >
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>
			</div>
		</div>
		</div>
		<div class="modal-footer">
			<button id="oracleTableLevelRestoreOptions_button_Cancel" type="button" class="btn" data-ng-click="otlRestore.cancelModel()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="oracleTableLevelRestoreOptions_button_CustomScript" type="button" class="btn" data-ng-click="otlRestore.viewScriptPreview(restoreForm)"><cv:msg key="label.preview" bundle="oracle"/></button>
			<button id="oracleTableLevelRestoreOptions_button_Submit" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button>
		</div>
	</form>
</div>
