<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1> <cv:msg key="label.redirectPathOpt" bundle="oracle"/></h1>
	</div>
	<form name="redirectPath" novalidate cv-hide-api data-cv-submit="rrOptions.savePaths()" autocomplete="off" >
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" >
					<label class="col-xs-12 col-lg-12">
						<cv:msg key="label.redirect" bundle="oracle"/>
					</label>
				</div>
				<div class="form-group" >
					<div class="col-xs-12 col-lg-5 padding-left-50" >
						<input type="radio" id="redirectAllCB" name="redirectAllCB" data-ng-model="rrOptions.data.redirectOption" value="ALL"/>
						<label for="redirectAllCB">
							<cv-help-text help-label="<cv:msg key="label.redirectDatabase" bundle="oracle"/>" help-text="'<cv:msg key="help.redirectDatabase" bundle="oracle"/>'"></cv-help-text>
						</label>
					</div>
					<div class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="redirectAll" name="redirectAll" data-ng-required="rrOptions.data.redirectOption == 'ALL' " data-ng-model="rrOptions.data.redirectAllPath"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									folders-only = true client-id='{{rrOptions.clientEntity.clientId}}' result-function="rrOptions.redirectAllPathResuleFunction" class="upload-button">
								</cv-machine-browse>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.redirectPath.needsAttention(redirectPath.redirectAll)">
							<cv:msg key="error.redirectAll" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-lg-12 padding-left-50" >
						<input type="radio" id="individualTSCB" name="individualTSCB" data-ng-model="rrOptions.data.redirectOption" value="INDIVIDUAL" />
						<label for="individualTSCB">
							<cv-help-text help-label="<cv:msg key="label.individualTables" bundle="oracle"/>" help-text="'<cv:msg key="help.individualTables" bundle="oracle"/>'"></cv-help-text>
						</label>
					</div>
				</div>
			<span data-ng-show=" rrOptions.data.redirectOption == 'INDIVIDUAL' ">
				<div class="form-group">
					<label class="col-xs-12 col-lg-9">

					</label>
					<label class="col-xs-12 col-lg-3 margin-bottom-30">
						<a title="Redirect" data-ng-click="rrOptions.showFinsAndReplaceDialog()">
							<cv:msg key="label.findAndReplace" bundle="oracle"/>
						</a>
					</label>
				</div>
				<div class="panel" data-ng-if="rrOptions.data.isPDBInstance && rrOptions.dataFilesModel">
					<div class="panel-body margin-left-25">
					<uib-accordion close-others="true" class="text-left">
						<div class="form-group" data-ng-repeat="pdb in rrOptions.dataFilesModel track by $index">
					    	<div uib-accordion-group is-open="pdb.status" >
							   	<uib-accordion-heading>
							        {{pdb.database}}
							        <i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': pdb.status, 'glyphicon-chevron-right': !pdb.status}"></i>
							      </uib-accordion-heading>
							      <cv-oracle-tablespace entity="rrOptions.entity" tablespaces="pdb.tableSpace" > </cv-oracle-tablespace>
						     </div>
						</div>
			      	</uib-accordion>
			      	</div>
				</div>
				<div data-ng-if="rrOptions.data.isPDBInstance === false && rrOptions.dataFilesModel">
					<cv-oracle-tablespace entity="rrOptions.entity" tablespaces="rrOptions.dataFilesModel" ></cv-oracle-tablespace>
				</div>
			</span>
			<div class="form-group" >
				<div class="col-xs-12">
					<toggle-control status="rrOptions.data.redoLogs==true?'enabled-activity':'disabled-activity'"
              				data-ng-click="rrOptions.redoLogsSelected()"
              				title="<cv:msg key="label.createNewServer" bundle="saphana"/>">
           			</toggle-control>
					<label for="onlineRedoLogs">
						<span data-ng-show="rrOptions.data.rmanDuplicate">
							<cv:msg key="label.tempTableSpaces" bundle="oracle" />
						</span>
						<span data-ng-hide="rrOptions.data.rmanDuplicate">
							<cv:msg key="label.onlineRedoLogs" bundle="oracle" />
						</span>
					</label>
				</div>
			</div>
			<div class="form-group" data-ng-if="rrOptions.data.redoLogs">
				<div class="col-xs-12 col-lg-5 padding-left-50" >
					<label for="redoLogsPath">
						<cv:msg key="label.header.path" bundle="messages"/>
					</label>
				</div>
				<div class="col-xs-12 col-lg-7">
					<div class="input-group">
						<input type="text" id="redoLogsPath" name="redoLogsPath" required data-ng-model="rrOptions.data.onlineLogDest" />
						<span class="input-group-btn">
							<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
								folders-only = true client-id='{{rrOptions.clientEntity.clientId}}' result-function="rrOptions.redoLogsPathResuleFunction" >
							</cv-machine-browse>
						</span>
					</div>
					<span class="help-block" data-ng-show="cv.redirectPath.needsAttention(redirectPath.redoLogsPath)">
						<span data-ng-show="rrOptions.data.rmanDuplicate">
							<cv:msg key="error.tempTableSpaces" bundle="oracle" />
						</span>
						<span data-ng-hide="rrOptions.data.rmanDuplicate">
							<cv:msg key="error.onlineRedoLogs" bundle="oracle" />
						</span>
					</span>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="oracleRestoreRedirect_button_#0223" type="button" class="btn cvBusyOnAjax" data-ng-click="rrOptions.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="oracleRestoreRedirect_button_#9397" type="submit" class="btn btn-primary cvBusyOnAjax" >
	  			<cv:msg key="Save" bundle="messages"/>
	  		</button>
		</div>
	</form>
</div>

