<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="oracleRestoreTemplate.html">
				<div class="form-group" data-ng-show="tabControls.getCurrentTabId() == 1">
					<label class="col-xs-12 col-lg-5" for="destinationServer">
						<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<!-- <select id="destinationServer" name="destinationServer"  data-ng-required="true"
							data-ng-model="restoreData.globalOptions.destinationServer"
							data-ng-options="ds as ds.displayName for ds in restoreData.globalOptions.destinationServerList | orderBy:'displayName' track by (ds.displayName|lowercase)"
							data-ng-change="destinationServerChanged(restoreData.globalOptions.destinationServer)" >
							<option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
							<cv:msg key="error.oracleVmDestinationServer" bundle="restore"/>
						</span> -->
						<cv-isteven-single-select id-name="destinationServer"
								input-model="restoreData.globalOptions.destinationServerList"
								binding-model="restoreData.globalOptions.destinationServer"
								track-field="clientId"
								label="displayName"
								tick-property="selected"
								on-change="destinationServerChanged(restoreData.globalOptions.destinationServer)"
								place-holder='<cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/>'
								help-text='<cv:msg key="error.oracleVmDestinationServer" bundle="restore"/>'
								required = "true">
						</cv-isteven-single-select>
					</div>
				</div>
				<div class="form-group" data-ng-show="tabControls.getCurrentTabId() == 1">
					<label class="col-xs-12 col-lg-5" for="destinationInstance">
						<cv:msg key="label.destInstance" bundle="oracle"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<!--<select id="destinationInstance" name="destinationInstance"  data-ng-required="true"
							data-ng-model="restoreData.globalOptions.destinationInstance"
							data-ng-options="ins as ins.instanceName disable when shouldDisableInstance(ins.instanceId) for ins in restoreData.globalOptions.destinationInstanceList"  data-ng-change="destinationInstanceChanged()">
							<option value=""><cv:msg key="option.destInstance" bundle="oracle"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationInstance)">
							<cv:msg key="error.destInstance" bundle="oracle"/>
						</span>-->
						<cv-isteven-single-select id-name="destinationInstance"
								input-model="restoreData.globalOptions.destinationInstanceList"
								binding-model="restoreData.globalOptions.destinationInstance"
								track-field="instanceId"
								label="instanceName"
								tick-property="selected"
								disable-property="disabled"
								place-holder='<cv:msg key="option.destInstance" bundle="oracle"/>'
								help-text='<cv:msg key="error.destInstance" bundle="oracle"/>'
								required = "true">
						</cv-isteven-single-select>
					</div>
				</div>
				<span data-ng-if="!isOracleRac">
					<cv-restore-streams streams="restoreData.globalOptions.streams"/>
				</span>
				<div class="form-group" data-ng-if="!isFullDataRestore " >
					<label class="col-xs-12 col-lg-5" for="axuPath">
						<cv:msg key="label.auxPath" bundle="oracle" />
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input  type="text" id="axuPath" name="axuPath"
						 	data-ng-required="(!isFullDataRestore && restoreData.globalOptions.pitType !== '0' && restoreData.globalOptions.pitType !== '3')" data-ng-model="restoreData.globalOptions.axuPath" />
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{restoreData.globalOptions.destinationServer.clientId}}' result-function="axuPathResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.axuPath)">
							<cv:msg key="error.auxPath" bundle="oracle" />
						</span>
					</div>
				</div>

				<div class="form-group" data-ng-if="tabControls.getCurrentTabId() == 1 && !restoreData.globalOptions.rmanDuplicate">
					<div class="col-xs-12 col-lg-12">
						<toggle-control status="restoreData.globalOptions.rmanDuplicate==true?'enabled-activity':'disabled-activity'"
              				data-ng-click="rmanDuplicateSelected()"
              				title="<cv:msg key="label.rmanDuplicate" bundle="oracle" />">
           				</toggle-control>
						<label for="rmanDuplicate">
							<cv:msg key="label.rmanDuplicate" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="tabControls.getCurrentTabId() == 1 && restoreData.globalOptions.rmanDuplicate">
					<div class="col-xs-12 col-lg-5">
						<toggle-control status="restoreData.globalOptions.rmanDuplicate==true?'enabled-activity':'disabled-activity'"
              				data-ng-click="rmanDuplicateSelected()"
              				title="<cv:msg key="label.rmanDuplicate" bundle="oracle" />">
           				</toggle-control>
						<label for="rmanDuplicate">
							<cv:msg key="label.rmanDuplicate" bundle="oracle" />
						</label>
					</div>
					<label  class="col-xs-12 col-lg-7" >
						<a href="" data-ng-click="showRedirectOptionDialog()" data-ng-show="restoreData.globalOptions.rmanDuplicate">
							<cv:msg key="label.redirect" bundle="oracle"/>
						</a>
					</label>
				</div>
			<div class="form-group" data-ng-if="restoreData.globalOptions.rmanDuplicate">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-11">
						<input type="checkbox" id="database" name="database" data-ng-model="restoreData.globalOptions.duplicateStandby" />
						<label for="database"><cv:msg key="label.duplicateStandby" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group" data-ng-if="!restoreData.globalOptions.rmanDuplicate">
					<label class="col-xs-12 col-lg-5">
						<cv:msg key="label.restore" bundle="oracle"/>
					</label>
					<label  class="col-xs-12 col-lg-7">
						<a href="" data-ng-click="showRedirectOptionDialog()" >
							<cv:msg key="label.redirect" bundle="oracle"/>
						</a>
					</label>
				</div>
				<div class="form-group" data-ng-if="!restoreData.globalOptions.rmanDuplicate ">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-11">
						<input type="checkbox" id="database" name="database" data-ng-model="restoreData.globalOptions.database" />
						<label for="database"><cv:msg key="label.database" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group" data-ng-if="!restoreData.globalOptions.rmanDuplicate">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-11">
						<input type="checkbox" id="controlfile" name="controlfile" data-ng-model="restoreData.globalOptions.controlfile" />
						<label for="controlfile"><cv:msg key="label.controlfile" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group" data-ng-if="!restoreData.globalOptions.rmanDuplicate ">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-11">
						<input type="checkbox" id="spfile" name="spfile" data-ng-model="restoreData.globalOptions.spfile" />
						<label for="spfile"><cv:msg key="label.spfile" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-12" for="mostRecent">
						 <cv:msg key="label.recoverTo" bundle="oracle"/>
					</label>
				</div>
				<div class="form-group" >
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-11">
						<input type="radio" data-ng-model="restoreData.globalOptions.pitType" value="3" id="mostRecent" name="mostRecent" />
						<label for="mostRecent"> <cv:msg key="label.mostRecent" bundle="oracle"/></label>
					</div>
				</div>
				<div class="form-group" >
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-11">
						<input type="radio" data-ng-model="restoreData.globalOptions.pitType" value="0" id="currentTime" name="mostRecent" />
						<label for="currentTime"><cv:msg key="label.currentTime" bundle="oracle"/></label>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-1 col-lg-4">
						<input type="radio" data-ng-model="restoreData.globalOptions.pitType" value="1" id="pitDate1" name="mostRecent" />
						<label for="pitDate1"><cv:msg key="label.pit" bundle="oracle" /></label>
					</div>
					<div class="col-xs-1 col-lg-7" data-ng-disabled="(restoreData.globalOptions.pitType != '1')">
						<cv-date-time-picker date-format="restoreData.pitTimeFormat" date-time-Value="restoreData.globalOptions.pitDate" ></cv-date-time-picker>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dateTimeValue) || pitError">
							<cv:msg key="error.pit" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-11 col-lg-4">
						<input type="radio" data-ng-model="restoreData.globalOptions.pitType" value="2" id="scn" name="mostRecent" />
						<label for="scn"> <cv:msg key="label.scn" bundle="oracle" /> </label>
					</div>
					<div class="col-xs-1 col-lg-7" data-ng-disabled="(restoreData.globalOptions.pitType != '2')">
						<input  type="text" id="pitScn" name="pitScn"  data-ng-pattern="/^\d+$/"
						 data-ng-required="(restoreData.globalOptions.pitType == '2')" data-ng-model="restoreData.globalOptions.pitScn" />
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.pitScn)">
							<cv:msg key="error.pitScn" bundle="oracle"/>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="isSnapBackupEnabled ">
					<label class="col-xs-12 col-lg-12">
						<cv:msg key="label.snapRestoreOptions" bundle="oracle"/>
					</label>
				</div>
				<div class="form-group" data-ng-if="isSnapBackupEnabled ">
					<label class="col-xs-1 col-lg-1">
					</label>
					<div class="col-xs-5 col-lg-4">
						<input type="radio" data-ng-model="restoreData.globalOptions.snapRestoreType" value="true" id="rmanRestore" name="snapRestoreType" />
						<label for="rmanRestore"><cv:msg key="label.useRMANRestore" bundle="oracle"/></label>
					</div>
					<div class="col-xs-5 col-lg-7">
						<input type="radio" data-ng-model="restoreData.globalOptions.snapRestoreType" value="false" id="fsRestore" name="snapRestoreType" />
						<label for="fsRestore"><cv:msg key="label.useFSRestore" bundle="oracle"/></label>
					</div>
				</div>
				<cv-data-masking
					left-class="col-xs-12 col-lg-5"
					right-class="col-xs-12 col-lg-7"
					data-ng-if="showDataMasking()"
					instance-id="entity.instanceId"
					is-stand-alone="false"
					masking-options="restoreData.globalOptions.dataMaskingOptions">
				</cv-data-masking>


						<div data-ng-if="isOracleRac && restoreData.globalOptions.destinationInstance && restoreData.globalOptions.destinationInstance.applicationId == AppTypes.ORACLE_RAC" id="streams">

								<uib-accordion  close-others="true" class="text-left" data-ng-init="accordionOpen = false">
								<div uib-accordion-group data-is-open="accordionOpen">
									<uib-accordion-heading>
									<cv:msg key="label.noOfStreams" bundle="job" />
									<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionOpen, 'glyphicon-chevron-right': !accordionOpen}"></i>
									</uib-accordion-heading>
									<div class="row">
							    	<cv-rac-manage-streams hide-title="true" is-restore="true" entity="restoreData.globalOptions.destinationInstance" get-streams-func="getStreamsFunc" refresh-func="refreshFunc">
							    	</cv-rac-manage-streams>
									</div>
							    </div>
							    </uib-accordion>
						</div>

				<div class="form-group">
					<label class="col-xs-12 col-lg-12">
						{{oraInstanceStatus}}
					</label>
				</div>

				<cv-hardware-revert
					snap-backup-enabled="isSnapBackupEnabled"
					is-inplace-restore="restoreData.isInplaceRestore"
					entity="entity"
					proxy-client="restoreData.proxyClient"
					hardware-revert="restoreData.globalOptions.hardwareRevert">
				</cv-hardware-revert>


				<label class="col-sm-12">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</label>
</script>


<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="restoreForm" novalidate data-cv-submit="doRestore()" autocomplete="off">
		<div class="panel">
		<div class="panel-body">
			<div id="modern-tab" class="tab-2">
				<cv-tabset-component control='tabControls' default-tab="'owner'">
					<cv-tab
						tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />'
						help-text='<cv:msg key="label.oracleInPlaceHelp" bundle="oracle" />'
						data-ng-selected="onTabChanged()">

						<div data-ng-if="tabControls.getCurrentTabId() == 0" class="padding-top-10">

							<div class="form-group">
								<label class="col-xs-12 col-lg-5" for="destinationServer">
									<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
								</label>
								<label class="col-xs-12 col-lg-7 label-as-input">
									<a target="_blank" ng-href="#clientDetails/{{entity.clientId}}">{{entity.displayName}}</a>
								</label>
							</div>
							<div class="form-group" class="padding-top-10">
								<label class="col-xs-12 col-lg-5" for="destinationInstance">
									<cv:msg key="label.destInstance" bundle="oracle"/>
								</label>
								<label class="col-xs-12 col-lg-7 label-as-input">
									<a target="_blank" ng-href="#databaseDetails/{{entity.instanceId}}">{{entity.instanceName}}</a>
								</label>
							</div>
							<div data-ng-include="'oracleRestoreTemplate.html'"> </div>
						</div>


					</cv-tab>
					<cv-tab hide-on="hideOutOfPlaceRestore"
						tabname="<cv:msg key="label.OOPRestore" bundle="restore" />"
						help-text='<cv:msg key="label.oracleOutOfPlaceHelp" bundle="oracle" />'
						data-ng-selected="onTabChanged()">
						<div data-ng-if="tabControls.getCurrentTabId() == 1" class="padding-top-10">
							<div data-ng-include="'oracleRestoreTemplate.html'">
							</div>
						</div>
					</cv-tab>
					<div data-ng-init="afterTabInit()"></div>
				</cv-tabset-component>
			</div>
		</div>
		</div>
		<div class="modal-footer">
			<button id="oracleRestoreOptions_button_#6966" type="button" class="btn" data-ng-click="cancelModel()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="oracleRestoreOptions_button_CustomScript" type="button" class="btn" data-ng-click="viewScriptPreview(restoreForm)"><cv:msg key="label.preview" bundle="oracle"/></button>
			<button id="oracleRestoreOptions_button_#5576" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button>
		</div>
	</form>
</div>
