<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="mySqlRestoreTemplate.html">
					<div class="form-group padding-top-20" data-ng-if="mySqlRestore.tabControls.getCurrentTabId() == 0">
						<label class="col-xs-12 col-sm-5">
							<cv:msg key="label.DestinationClient" bundle="saphana" />
						</label>
						<label class="col-xs-12 col-sm-7">
							<a target="_blank" data-ng-href="#clientDetails/{{mySqlRestore.entity.clientId}}">{{mySqlRestore.entity.displayName}}</a>
						</label>
					</div>
					<div class="form-group" data-ng-if="mySqlRestore.tabControls.getCurrentTabId() == 0">
						<label class="col-xs-12 col-sm-5">
							<cv:msg key="label.destinationInstance" bundle="saphana" />
						</label>
						<label class="col-xs-12 col-sm-7">
							<a target="_blank" data-ng-href="#databaseDetails/{{mySqlRestore.entity.instanceId}}">{{mySqlRestore.entity.instanceName}}</a>
						</label>
					</div>
					<div class="form-group padding-top-20" data-ng-show="mySqlRestore.tabControls.getCurrentTabId() !=0">
						<label class="col-xs-12 col-sm-5" for="destinationClient">
							<cv:msg key="label.DestinationClient" bundle="saphana"/>
						</label>
						<div class="col-xs-12 col-sm-7">
							<cv-isteven-single-select id-name="destinationclient"
								input-model="mySqlRestore.restoreData.destinationClients"
								binding-model="mySqlRestore.restoreData.destinationClient"
								track-field="clientId"
								label="displayName"
								tick-property="selected"
								on-change="mySqlRestore.updateInstcesModel(mySqlRestore.restoreData.destinationClient.clientId)"
								place-holder='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
								help-text='<cv:msg key="error.DestinationClient" bundle="restore"/>'
								required = "true">
							</cv-isteven-single-select>
						</div>
				</div>
				<div class="form-group" data-ng-show="mySqlRestore.tabControls.getCurrentTabId() == 1">
					<label class="col-xs-12 col-sm-5" for="destinationDatabase">
						 <cv:msg key="label.destinationInstance" bundle="saphana"/>
					</label>
					<div class="col-xs-12 col-sm-7">
						<select id="destinationDatabase" name="destinationDatabase"  data-ng-required="mySqlRestore.tabControls.getCurrentTabId() == 1"
							data-ng-model="mySqlRestore.restoreData.destinationInstance"
							data-ng-options="ins as ins.instance.instanceName disable when mySqlRestore.shouldDisableInstance(ins.instance.instanceId) for ins in mySqlRestore.restoreData.destinationInstances"  data-ng-change="mySqlRestore.setInstanceInfo(mySqlRestore.restoreData.destinationInstance.instance.instanceId)">
							<option value=""><cv:msg key="placeholder.destinationInstance" bundle="saphana"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationDatabase)">
							<cv:msg key="error.destInstance" bundle="oracle"/>
						</span>
					</div>
				</div>
	             <div data-ng-if="!mySqlRestore.isCloudDB && !mySqlRestore.isMySQLMEBInstance" class="form-group">
					<label class="col-xs-12 col-sm-5">
						 <cv:msg key="label.restoreType" bundle="restore"/>
					</label>
                    <div class="col-xs-3 col-sm-3">
                        <input type="checkbox" id="data" name="data" data-ng-model="mySqlRestore.restoreData.mySqlRstOption.data" data-ng-change="mySqlRestore.updateOption()"/>
                        <label for="data">
                            <cv:msg key="label.DATA" bundle="mySql"/>
                        </label>
                    </div>
					<div class="col-xs-3 col-sm-3">
                        <input type="checkbox" id="log" name="log" data-ng-model="mySqlRestore.restoreData.mySqlRstOption.log" data-ng-change="mySqlRestore.updateOption()"/>
                        <label for="log">
                            <cv:msg key="label.LOG" bundle="mySql"/>
                        </label>
                    </div>
                </div>

				<div class="form-group" data-ng-show="mySqlRestore.tabControls.getCurrentTabId() == 0||mySqlRestore.tabControls.getCurrentTabId() == 1">
					<div data-ng-if="!mySqlRestore.isCloudDB && !mySqlRestore.isMySQLMEBInstance">
						<div class="col-xs-12 col-sm-5">
                        	<label for="StagingLocation">
                            	<cv:msg key="label.StagingLocation" bundle="mySql"/>
                        	</label>
                    	</div>
					<div class="col-xs-12 col-sm-7">
						<div class="input-group" title="{{mySqlRestore.restoreData.mySqlRstOption.temporaryStagingLocation}}">
								<input type="text" name="StagingLocation" id="StagingLocation"
									placeholder="{{mySqlRestore.restoreData.recoverTextPlaceHolder}}"
									data-ng-model="mySqlRestore.restoreData.path"
									data-ng-required="mySqlRestore.restoreData.mySqlRstOption.logRestoreType==0" />
									<span class="input-group-btn" data-ng-disabled="mySqlRestore.isDisableBrowse()">
										<cv-machine-browse
											button-label='<cv:msg key="label.browse" bundle="restore"/>'
											client-id='{{mySqlRestore.restoreData.destinationClient.clientId}}'
											result-function="mySqlRestore.browseResuleFunction" />
									</span>
							</div>
							<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.StagingLocation)">
									<cv:msg key="error.StagingLocation" bundle="mySql" />
							</span>
						</div>
					</div>
				</div>

			<div class="form-group" data-ng-show="mySqlRestore.tabControls.getCurrentTabId() == 2">
				<div class="col-xs-12 col-sm-5">
					<label for="DestinationFolder"> <cv:msg
							key="label.DestinationFolder" bundle="mySql" />
					</label>
				</div>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group"
						title="{{mySqlRestore.restoreData.mySqlRstOption.temporaryStagingLocation}}">
						<input type="text" name="DestinationFolder" id="DestinationFolder"
							placeholder="{{mySqlRestore.restoreData.recoverTextPlaceHolder}}"
							data-ng-model="mySqlRestore.restoreData.path"
							data-ng-required />
						<span class="input-group-btn" data-ng-disabled="mySqlRestore.isDisableBrowse()"> <cv-machine-browse
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{mySqlRestore.restoreData.destinationClient.clientId}}'
								result-function="mySqlRestore.browseResuleFunction" />
						</span>
					</div>
					<span class="help-block"
						data-ng-show="cv.restoreForm.needsAttention(restoreForm.DestinationFolder)">
						<cv:msg key="error.DestinationFolder" bundle="mySql" />
					</span>
				</div>
			</div>
</script>

<script type="text/ng-template"  id="snapTemplate.html">
	<cv-hardware-revert
		snap-backup-enabled="mySqlRestore.snapBackupEnabled"
		is-inplace-restore="mySqlRestore.restoreData.isInplaceRestore"
		entity="mySqlRestore.entity"
		proxy-client="mySqlRestore.restoreData.proxyClient"
		hardware-revert="mySqlRestore.restoreData.hardwareRevert">
	</cv-hardware-revert>
</script>

<div class="modal-header">
	<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
</div>
<form name="restoreForm" class="bootstrap-wrapper form-horizontal modal-margin" novalidate data-cv-submit="mySqlRestore.doRestore()">
		<div id="modern-tab" ng-class="mySqlRestore.tabStyle">
			<cv-tabset-component control='mySqlRestore.tabControls' default-tab="'owner'">
			<!-- TAB 1 : In place -->
			<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />'
				help-text='<cv:msg key="label.mySqlInPlaceHelp" bundle="mySql" />'
				data-ng-selected="mySqlRestore.onTabChanged()">
				<div data-ng-include="'mySqlRestoreTemplate.html'"> </div>
				<div data-ng-include="'snapTemplate.html'"> </div>
				<span data-ng-if="mySqlRestore.tabControls.getCurrentTabId() == 0">
					<cv-hardware-revert snap-backup-enabled="" entity="" hardware-revert="" > </cv-hardware-revert>
				</span>
			</cv-tab>

			<!-- TAB 2 : out of place -->
			<cv-tab tabname='<cv:msg key="label.OOPRestore" bundle="restore" />'
				help-text='<cv:msg key="label.mySqlOutOfPlaceHelp" bundle="mySql" />'
				data-ng-selected="mySqlRestore.onTabChanged()">
					<div data-ng-include="'mySqlRestoreTemplate.html'"> </div>
					<div data-ng-include="'snapTemplate.html'"> </div>
			</cv-tab>

			<!-- TAB 3 : Restore to disk -->
			<cv-tab tabname="<cv:msg key="label.rtdRestore" bundle="restore" />"
				help-text='<cv:msg key="label.RestoreToDiskHelp" bundle="mySql" />'
				data-ng-selected="mySqlRestore.onTabChanged()"
				data-ng-if="mySqlRestore.isRestoreToDiskSupported">
					<div data-ng-include="'mySqlRestoreTemplate.html'"> </div>
			</cv-tab> </cv-tabset-component>
			<div class="padding-top-10">
				<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
			</div>
		</div>
		<div class="modal-footer">
			<button id="mySqlRestoreOptionsModal_button_#6880" class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				type="button" data-ng-click="mySqlRestore.closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="mySqlRestoreOptionsModal_button_#1528" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
</form>
