<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
	<div   data-ng-if="mySqlInstance.addInstance" class="col-xs-12 col-sm-12 clouddb-info-banner">
		<a  href="" data-ng-click="mySqlInstance.openCloudDbDialog()"><cv:msg key="label.clickToAddCloudDB" bundle="dbs" /></a>
	</div>

	<span class="{{mySqlInstance.serverMessage.type}}" data-ng-bind="mySqlInstance.serverMessage.message"></span>
    <form name="addMySQLInstance" novalidate class="form-horizontal" autocomplete="off" data-cv-submit="mySqlInstance.submitData()" data-cv-validate="mySqlInstance.validateInputs(addMySQLInstance)">
        <div class="panel">


            <div class="panel-body">
            	<div class="form-group" data-ng-if="mySqlInstance.addInstance">
					<label class="col-xs-12 col-sm-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-sm-7 text-overflow-allowed" data-ng-disabled="mySqlInstance.editDialog">
						<cv-client-picker selected-clients="mySqlInstance.clientSelection.selectedClients" valide-client-selection="mySqlInstance.clientSelection.valideClientSelection" selection-changed="mySqlInstance.clientSelection.selectionChanged(clientEntity)"  app-id="104" exclude-pseudo-clients="true"></cv-client-picker>
						<span class="help-block" data-ng-show="cv.addMySQLInstance.getAttempted() && !mySqlInstance.clientSelection.valideClientSelection" >
							<cv:msg key="option.clientName" bundle="clients"/>
						</span>
					</div>
				</div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-5" for="databaseName">
                        <cv:msg key="label.DatabaseName" bundle="saphana"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="text" name="databaseName" data-ng-model="mySqlInstance.newInstanceName" required/>
                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.databaseName)">
                            <cv:msg key="error.instanceName" bundle="sqlserver"/>
                        </span>
                    </div>
                </div>

              	<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="plan">
						<cv:msg key="label.profile" bundle="profiles"/>
					</label>
					<div class="col-xs-12 col-sm-7" data-ng-if="mySqlInstance.profileList">
						<cv-plan-summary-dropdown
								id="planSummarySelection"
								input-model="mySqlInstance.profileList"
								output-model="mySqlInstance.selectedProfileList"
								item-label="'name'"
								button-label="'name'"
								tick-property="'selected'"
								translation="mySqlInstance.localLang"
								group-property="'msGroup'"
								helper-elements="'filter'"
								selection-mode="'single'"
								on-close="mySqlInstance.parseIStevenOutput()">
							</cv-plan-summary-dropdown>
						<span class="help-block" data-ng-show="cv.addMySQLInstance.getAttempted() && mySqlInstance.showPlanError"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
					</div>
				</div>

                <uib-accordion close-others="false" class="text-left">
						<div uib-accordion-group data-is-open="mySqlInstance.openAccordian1">
							<uib-accordion-heading>
							<cv:msg key="title.connectionDetails" bundle="cloudStorageApp"/>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': mySqlInstance.openAccordian1, 'glyphicon-chevron-right': !mySqlInstance.openAccordian1}"></i>
							</uib-accordion-heading>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-5" for="dbUsername">
                        <cv:msg key="label.hanaDBUsername" bundle="saphana"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="text" name="dbUsername" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.SAUser.userName" required />
                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.dbUsername)">
                            <cv:msg key="error.DbUsername" bundle="saphana"/>
                        </span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-5" for="dbPassword">
                        <cv:msg key="label.DbPassword" bundle="saphana"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="password" name="dbPassword" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.SAUser.password" data-ng-required="mySqlInstance.isShowPasswordError" />
                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.dbPassword)">
                            <cv:msg key="error.DbPassword" bundle="saphana"/>
                        </span>
                    </div>
                </div>
                <span data-ng-show="!mySqlInstance.isUnixClient">
	                <div class="form-group" >
	                   <label class="col-xs-12 col-sm-5" for="NTUsername">
	                        <cv:msg key="label.NTUsername" bundle="mySql"/>
	                        <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
	                    </label>

	                    <div class="col-xs-12 col-sm-7">
	                        <input type="text" name="NTUsername" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.NTUser.userName"/>
	                    </div>
	                </div>
	                <div class="form-group">
	                   <label class="col-xs-12 col-sm-5" for="NTPassword">
	                        <cv:msg key="label.NTPassword" bundle="mySql"/>
	                        <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
	                    </label>
	                    <div class="col-xs-12 col-sm-7">
	                        <input type="password" name="NTPassword" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.NTUser.password"/>
	                    </div>
	                </div>


	               <div class="form-group">
	                    <label class="col-xs-12 col-sm-5" for="port">
	                        <cv:msg key="label.Port" bundle="mySql"/>
	                    </label>
	                    <div class="col-xs-12 col-sm-7">
	                        <input type="text" name="port" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.port" required/>
	                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.port)">
	                            <cv:msg key="error.Port" bundle="mySql"/>
	                        </span>
	                    </div>
                	</div>
                </span>

                <span data-ng-show="mySqlInstance.isUnixClient">

                	<div class="form-group" >
	                   <label class="col-xs-12 col-sm-5" for="UnixUsername">
	                        <cv:msg key="label.UnixUsername" bundle="mySql"/>
	                        <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
	                    </label>
	                    <div class="col-xs-12 col-sm-7">
	                        <input type="text" name="UnixUsername" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.unixUser.userName"/>
	                    </div>
	                </div>

                	<div class="form-group">
	                    <label class="col-xs-12 col-sm-5" for="SocketFile">
	                        <cv-help-text help-label="<cv:msg key="label.SocketFile" bundle="mySql"/>" help-text="'<cv:msg key="help.SocketFile" bundle="mySql"/>'"></cv-help-text>
	                    </label>
	                    <div class="col-xs-12 col-sm-7">
	                        <div class="input-group" title="mySqlInstance.instanceDetails.mySqlInstance.port">
	                            <input type="text" name="SocketFile" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.port" required/>
	                            <span class="input-group-btn">
	                               <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' folders-only="false" client-id='{{mySqlInstance.instance.clientId}}' result-function="mySqlInstance.socketBrowseResuleFunction" can-create-folder="false"/>
	                            </span>
	                        </div>
	                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.SocketFile)">
	                            <cv:msg key="error.SocketFile" bundle="mySql"/>
	                        </span>
	                    </div>
                	</div>
                </span>
                </div>
                <div uib-accordion-group data-is-open="mySqlInstance.openAccordian2">
							<uib-accordion-heading>
							<cv:msg key="label.MySQLConfiguration" bundle="mySql"/>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': mySqlInstance.openAccordian2, 'glyphicon-chevron-right': !mySqlInstance.openAccordian2}"></i>
							</uib-accordion-heading>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-5" for="BinaryDirectory">
                        <cv:msg key="label.BinaryDirectory" bundle="mySql"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <div class="input-group" title="{{mySqlInstance.instanceDetails.mySqlInstance.BinaryDirectory}}">
                            <input type="text" name="BinaryDirectory" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.BinaryDirectory" required/>
                            <span class="input-group-btn">
                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{mySqlInstance.instance.clientId}}' result-function="mySqlInstance.binBrowseResuleFunction" can-create-folder="false"/>
                            </span>
                        </div>
                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.BinaryDirectory)">
                            <cv:msg key="error.BinaryDirectory" bundle="mySql"/>
                        </span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-5" for="LibDirectory">
                        <cv:msg key="label.LogDirectory" bundle="mySql"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <div class="input-group" title="{{mySqlInstance.instanceDetails.mySqlInstance.LibDirectory}}">
                            <input type="text" name="LibDirectory" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.LogDataDirectory" required/>
                            <span class="input-group-btn">
                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{mySqlInstance.instance.clientId}}' result-function="mySqlInstance.libBrowseResuleFunction" can-create-folder="false"/>
                            </span>
                        </div>
                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.LibDirectory)">
                            <cv:msg key="error.LogDirectory" bundle="mySql"/>
                        </span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-5" for="ConfigFile">
                        <cv:msg key="label.ConfigFile" bundle="mySql"/>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <div class="input-group" title="{{mySqlInstance.instanceDetails.mySqlInstance.ConfigFile}}">
                            <input type="text" name="ConfigFile" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.ConfigFile" required/>
                            <span class="input-group-btn" >
                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' folders-only="false" client-id='{{mySqlInstance.instance.clientId}}' result-function="mySqlInstance.archiveBrowseResuleFunction" can-create-folder="false"/>
                            </span>
                        </div>
                        <span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.ConfigFile)">
                            <cv:msg key="error.ConfigFile" bundle="mySql"/>
                        </span>
                    </div>
                </div>



            </div>
        <div uib-accordion-group data-is-open="mySqlInstance.openAccordian3">
							<uib-accordion-heading>
							<cv:msg key="label.AdvancedOptions" bundle="mySql"/>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': mySqlInstance.openAccordian3, 'glyphicon-chevron-right': !mySqlInstance.openAccordian3}"></i>
							</uib-accordion-heading>

			<div class="form-group">
                 <label class="col-xs-12 col-sm-5" for="SSLCAFile">
                     <cv:msg key="label.SSLCAFile" bundle="mySql"/>
                 </label>
                 <div class="col-xs-12 col-sm-7">
                     <div class="input-group" title="mySqlInstance.instanceDetails.mySqlInstance.sslCa">
                         <input type="text" name="SSLCAFile" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.sslCa"/>
                         <span class="input-group-btn">
                             <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' folders-only="false" client-id='{{mySqlInstance.instance.clientId}}' result-function="mySqlInstance.sslBrowseResuleFunction" can-create-folder="false"/>
                         </span>
                     </div>
                 </div>
            </div>

        <!-- XtraBackup options -->
			<div data-ng-if="mySqlInstance.isUnixClient">
				<div class="form-group" >
					<div class="col-xs-12">
						<toggle-control class="{{backupEnabledStatusInfo}}" status="mySqlInstance.instanceDetails.mySqlInstance.isHotBackupEnabled==true?'enabled-activity':'disabled-activity'" data-ng-click="mySqlInstance.manageXtrabackup()"
							data-title='<cv:msg key="label.hotBackup" bundle="mySql" />'></toggle-control>
							<cv:msg key="label.hotBackup" bundle="mySql" />
							<cv-help-component help-text="<cv:msg key="help.hotBackup" bundle="mySql"/>"></cv-help-component>
					</div>
				</div>
				<div class="form-group" data-ng-if="mySqlInstance.instanceDetails.mySqlInstance.isHotBackupEnabled" >
					<div class="col-xs-12 col-lg-5 padding-left-40">
						<input type="radio" name="backupFull" id="backupFull" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.hotBackupType" value="1">
						<label for="backupFull">
							<cv:msg key="label.xtBackup" bundle="mySql"/>
						</label>
					</div>
					<div class="col-xs-12 col-lg-7">
						<input type="radio" name="enterprise" id="enterprise" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.hotBackupType" value="2">
						<label for="enterprise">
							<cv:msg key="label.enterpriceBackup" bundle="mySql"/>
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="mySqlInstance.instanceDetails.mySqlInstance.isHotBackupEnabled && mySqlInstance.instanceDetails.mySqlInstance.hotBackupType === '1' ">
					<label class="col-xs-12 col-sm-5 padding-left-40" for="XtraBackupPath">
							<cv:msg key="placeholder.XtraBackupPath" bundle="mySql" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<div class="input-group" title="{{mySqlInstance.instanceDetails.mySqlInstance.xtraBackupSettings.xtraBackupBinPath}}">
							<input type="text" name="XtraBackupPath" id="XtraBackupPath"
								data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.xtraBackupSettings.xtraBackupBinPath" data-ng-required=true />
								<span class="input-group-btn">
									<cv-machine-browse
										button-label='<cv:msg key="label.browse" bundle="restore"/>'
										client-id='{{mySqlInstance.instance.clientId}}'
										result-function="mySqlInstance.xtraBackupBrowseResuleFunction"
										can-create-folder="false"/>
								</span>
						</div>
						<span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.XtraBackupPath)">
							<cv:msg key="error.XtraBackupPath" bundle="mySql" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="mySqlInstance.instanceDetails.mySqlInstance.isHotBackupEnabled && mySqlInstance.instanceDetails.mySqlInstance.hotBackupType === '2' ">
					<label class="col-xs-12 col-sm-5 padding-left-40" for="enterprisePath">
							<cv:msg key="label.enterpriseBackupBinPath" bundle="mySql" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<div class="input-group" title="{{mySqlInstance.instanceDetails.mySqlInstance.mebSettings.mebBinPath}}">
							<input type="text" name="enterprisePath"  id="enterprisePath"
								data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.mebSettings.mebBinPath"  data-ng-required=true />
								<span class="input-group-btn">
									<cv-machine-browse
										button-label='<cv:msg key="label.browse" bundle="restore"/>'
										client-id='{{mySqlInstance.instance.clientId}}'
										result-function="mySqlInstance.enterpriseBrowseResuleFunction"
										can-create-folder="false"/>
								</span>
						</div>
						<span class="help-block" data-ng-show="cv.addMySQLInstance.needsAttention(addMySQLInstance.enterprisePath)">
							<cv:msg key="error.enterpriceBackup" bundle="mySql" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="mySqlInstance.instanceDetails.mySqlInstance.isHotBackupEnabled && mySqlInstance.instanceDetails.mySqlInstance.hotBackupType === '2' ">
					<div class="col-xs-12 col-sm-11 padding-left-40">
						<input id="noLock" name="noLock" type="checkbox" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.noLock">
						<label  for="noLock">
							<cv:msg key="label.noLock" bundle="mySql" />
						</label>
					</div>
				</div>
			</div>

        <!-- Standby options -->
			<div data-ng-show="mySqlInstance.isProxyOptionsApplicable()">
					<div class="form-group" data-ng-show="mySqlInstance.isProxyOptionsApplicable()">
						<div class="col-xs-12">
							<toggle-control class="{{backupEnabledStatusInfo}}" status="mySqlInstance.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled==true?'enabled-activity':'disabled-activity'" data-ng-click="mySqlInstance.manageMySqlStandBy()" data-title='<cv:msg key="label.EnableProxyBackup" bundle="mySql" />'></toggle-control>
							<span class="pageDetailColumn"><cv:msg key="label.EnableProxyBackup" bundle="mySql" /></span>
						</div>
					</div>
				    <div class="panel-body">
						   <div class="form-group" data-ng-if="mySqlInstance.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled">

								<label class="col-xs-12 col-sm-5" for="standbyInstance">
									<cv:msg key="label.ProxyInstance" bundle="mySql" />
								</label>

								<div class="col-xs-12 col-sm-7" data-ng-init="mySqlInstance.initAfterLocalization1()">
									<isteven-multi-select id="mySqlCreateInstance_isteven-multi-select_#3213"
										input-model="mySqlInstance.standbyInstances"
										output-model="mySqlInstance.selectedStandbyList"
										button-label="name"
										item-label="name"
										translation="mySqlInstance.localLang1"
										tick-property="selected"
										class="isteven-multi-select user-group-select"
										selection-mode="single"
										helper-elements="filter"
										on-close="mySqlInstance.parseIStevenOutput1()"
										group-property="msGroup">
									</isteven-multi-select>
									<span class="help-block" data-ng-show="cv.addMySQLInstance.getAttempted() && mySqlInstance.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled && mySqlInstance.showStandbyError"><cv:msg key="placeholder.ProxyInstance" bundle="mySql" /></span>
								</div>
							</div>
							<div class="form-group" data-ng-if="mySqlInstance.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled">
								<div class="col-xs-12">
									<input id="runLogBackupsOnSource" class="" type="checkbox" data-ng-model="mySqlInstance.instanceDetails.mySqlInstance.proxySettings.runBackupOnProxy"
									data-ng-disabled="!mySqlInstance.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled"/>
									<label for="runLogBackupsOnSource"><cv:msg key="label.RunLogBackupsOnSource" bundle="mySql" /></label>
								</div>
							</div>
					</div>
				</div>
				</uib-accordion>
				</div>
			</div>

        <div class="modal-footer">
            <button id="mySqlCreateInstance_button_#2256" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="mySqlInstance.closeDialogBox()">
                <cv:msg key="Cancel" bundle="messages"/>
            </button>
            <button id="mySqlCreateInstance_button_#0385" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="!mySqlInstance.edit" >
            	<cv:msg key="Add" bundle="messages" />
            </button>
			<button id="mySqlCreateInstance_button_#1679" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="mySqlInstance.edit" >
				<cv:msg key="Save" bundle="messages" />
			</button>
        </div>
    </form>
