<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.oracle">
<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1>
			<label>
				{{modCtrl.modalOptions.headerText}}
				<cv-help-component help-text="<fmt:message key="help.maskingPolicyEditModal" />"></cv-help-component>
			</label>
		</h1>
	</div>
	<form id="editMaskingPolicyForm" name="editMaskingPolicyForm" class="form-horizontal" novalidate cv-submit="modCtrl.modalOptions.ok()">
		<div class="panel">
		<div class="panel-body">
			<%-- <label for="policyName">
				<fmt:message key="label.maskingPolicyName" />
				<input type="text" name="policyName" maxlength="150" data-ng-model="modCtrl.policy.policy.policyName" required />
				<span class="help-block" data-ng-show="editMaskingPolicyForm.policyName.$error.required && cv.editMaskingPolicyForm.needsAttention(editMaskingPolicyForm.policyName)">
					<fmt:message key="help.no_name" />
				</span>
				<span class="help-block" data-ng-show="modCtrl.isDupePolicyName()">
					<fmt:message key="help.dupe_name" />
				</span>
			</label> --%>
			
			<div class="form-group">
				<label class="col-xs-12 col-lg-5" for="policyName">
					<fmt:message key="label.maskingPolicyName" />
				</label>
				<div class="col-xs-12 col-lg-7">
					<input type="text" name="policyName" maxlength="150" data-ng-model="modCtrl.policy.policy.policyName" required />
					<span class="help-block" data-ng-show="editMaskingPolicyForm.policyName.$error.required && cv.editMaskingPolicyForm.needsAttention(editMaskingPolicyForm.policyName)">
						<fmt:message key="help.no_name" />
					</span>
					<span class="help-block" data-ng-show="modCtrl.isDupePolicyName()">
						<fmt:message key="help.dupe_name" />
					</span>
				</div>
			</div>
			
			<%-- <label data-ng-if="modCtrl.isMultiDatabase()" for="database" class="select-label"><fmt:message key="label.database" />
				<select name="database"
					    data-ng-model="modCtrl.selectedDatabase"
					    data-ng-options="item for item in modCtrl.databaseOptions"
					    data-ng-change="modCtrl.updateSchemas()">
					    <option disabled value="">{{modCtrl.databaseLoading ? "<fmt:message key="Loading" bundle="${common }"/>" : "<fmt:message key="help.database" />"}}</option>
				</select>
			</label> --%>
			
			<div class="form-group" data-ng-if="modCtrl.isMultiDatabase()">
				<label class="col-xs-12 col-lg-5"  for="database">
					<fmt:message key="label.database" />
				</label>
				<div class="col-xs-12 col-lg-7">
					<select name="database"
					    data-ng-model="modCtrl.selectedDatabase"
					    data-ng-options="item for item in modCtrl.databaseOptions"
					    data-ng-change="modCtrl.updateSchemas()">
					    <option disabled value="">{{modCtrl.databaseLoading ? "<fmt:message key="Loading" bundle="${common }"/>" : "<fmt:message key="help.database" />"}}</option>
					</select>
				</div>
			</div>
			
			<%-- <label for="policySchema"  data-ng-if="!modCtrl.schemaLoading"><fmt:message key="label.schema" />
				<select name="policySchema"
					    data-ng-model="modCtrl.selectedSchema"
					    data-ng-options="item.schema for item in modCtrl.schemaOptions"
					    data-ng-disabled="modCtrl.isMultiDatabase() && !modCtrl.selectedDatabase"
					    data-ng-change="modCtrl.updateTables()">
					    <option disabled value="">{{modCtrl.schemaLoading ? "<fmt:message key="Loading" bundle="${common }"/>" : ((!modCtrl.isMultiDatabase() || modCtrl.selectedDatabase) ? "<fmt:message key="help.schema" />" : "")}}</option>
				</select>
			</label> --%>
			
			<div class="form-group" data-ng-if="!modCtrl.schemaLoading">
				<label class="col-xs-12 col-lg-5" for="policySchema">
					<fmt:message key="label.schema" />
				</label>
				<div class="col-xs-12 col-lg-7">
					<cv-isteven-single-select id-name="policySchema"
						binding-model="modCtrl.selectedSchema"
						input-model="modCtrl.schemaOptions"
						track-field="schema"
						label="schema"
						tick-property="selected"
						on-change="modCtrl.updateTables()"
						place-holder='<fmt:message key="help.schema" />'
						>
					</cv-isteven-single-select>
				</div>
			</div>
			
			<%-- <label for="policyTable"  data-ng-if="modCtrl.selectedSchema"><fmt:message key="label.table" /> 
				<select name="policyTable"
					    data-ng-model="modCtrl.selectedTable"
					    data-ng-options="item for item in modCtrl.tableOptions"
					    data-ng-change="modCtrl.updateColumns()"
					    data-ng-disabled="!modCtrl.selectedSchema">
					    <option disabled value="">{{modCtrl.schemaLoading ? "<fmt:message key="Loading" bundle="${common }"/>" : (modCtrl.selectedSchema ? "<fmt:message key="help.table" />" : "")}}</option>
				</select>
				
			</label> --%>
			
			<div class="form-group" data-ng-if="modCtrl.selectedSchema">
				<label class="col-xs-12 col-lg-5" for="policyTable"  >
					<fmt:message key="label.table" /> 
				</label>
				<div class="col-xs-12 col-lg-7">
					
					<cv-isteven-single-select id-name="policyTable"
						binding-model="modCtrl.selectedTable"
						input-model="modCtrl.tableOptionsObjectList"
						binding-field="value"
						track-field="value"
						label="value"
						tick-property="selected"
						on-change="modCtrl.updateColumns()"
						place-holder='<fmt:message key="help.table"/>'
						>
					</cv-isteven-single-select>
				</div>
			</div>
			<div data-ng-show="!modCtrl.columnsLoading && modCtrl.columnOptions.length">
				<%-- <label for="columns">
					<fmt:message key="label.column" />
					<isteven-multi-select
						input-model="modCtrl.columnOptions"
						output-model="modCtrl.selectedColumns"
						item-label="nameTypeTemlate"
						button-label="name"
						tick-property="checked"
						disable-property="disabled"
						helper-elements="all none reset filter"
						class="isteven-multi-select user-group-select"
						name="columns"
						id="columns"
						max-labels="2"
						on-close="modCtrl.updateMaskTypes()"
						translation="modCtrl.columnSelectText">
					</isteven-multi-select>
				</label> --%>
				
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="columns">
						<fmt:message key="label.column" />
					</label>
					<div class="col-xs-12 col-lg-7">
						<isteven-multi-select
							input-model="modCtrl.columnOptions"
							output-model="modCtrl.selectedColumns"
							item-label="nameTypeTemlate"
							button-label="name"
							tick-property="checked"
							disable-property="disabled"
							helper-elements="all none reset filter"
							class="isteven-multi-select user-group-select"
							name="columns"
							id="columns"
							max-labels="2"
							on-close="modCtrl.updateMaskTypes()"
							translation="modCtrl.columnSelectText">
						</isteven-multi-select>
					</div>
				</div>
			
				<%-- <label for="maskType" data-ng-if="modCtrl.selectedColumns.length != 0">
					<fmt:message key="label.dataMaskingType" />
					<select name="maskType"
							data-ng-model="modCtrl.selectedMaskType"
							data-ng-options="item.name for item in modCtrl.maskTypeOptions"
							data-ng-change="modCtrl.updateRequiredParams()"
							data-ng-disabled="modCtrl.selectedColumns.length === 0">
							<option disabled value="">{{modCtrl.selectedColumns.length ? "<fmt:message key="help.masking_type" />" : ""}}</option>
					</select>
				</label> --%>
				
				<div class="form-group" data-ng-if="modCtrl.selectedColumns.length != 0">
					<label class="col-xs-12 col-lg-5" for="maskType" >
						<fmt:message key="label.dataMaskingType" />
					</label>
					<div class="col-xs-12 col-lg-7">
						<cv-isteven-single-select id-name="maskType"
							binding-model="modCtrl.selectedMaskType"
							input-model="modCtrl.maskTypeOptions"
							track-field="name"
							label="name"
							tick-property="selected"
							on-change="modCtrl.updateRequiredParams()"
							place-holder='<fmt:message key="help.masking_type" />'>
					</cv-isteven-single-select>
					</div>
				</div>
				
				<!-- <label data-ng-repeat="param in modCtrl.requiredParams" for="param_{{param.name}}">{{param.name}}
					<input type="{{param.type}}" name="param_{{param.name}}" data-ng-model="param.value" />
				</label> -->
				
				<div data-ng-repeat="param in modCtrl.requiredParams" class="form-group">
					<label class="col-xs-12 col-lg-5" for="param_{{param.name}}" >
						{{param.name}}
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="{{param.type}}" name="param_{{param.name}}" data-ng-model="param.value" />
					</div>
				</div>
				
				<%-- <div class="row modal-mask-edit-buttons">
					<button id="maskingEditModal_button_#8905" type="button" class="btn btn-default" data-ng-click="modCtrl.addMask()" data-ng-disabled="modCtrl.addButtonDisabledReason()"><fmt:message key="Add" bundle="${common }"/></button> 
				</div> --%>
				
				<div class="form-group">
					<label class="col-xs-12 col-lg-5">
					</label>
					<div class="col-xs-12 col-lg-7">
						<button id="maskingEditModal_button_#8883" type="button" class="btn btn-default" data-ng-click="modCtrl.addMask()" data-ng-disabled="modCtrl.addButtonDisabledReason()"><fmt:message key="Add" bundle="${common }"/></button> 
					</div>
				</div>
			</div>
			
			</div>
		</div>
		<!-- class="row policy-config-row" -->
			<div >
				<cv-grid cv-grid-options="modCtrl.policySettingsGridOptions"></cv-grid>
			</div> 
			<div class=modal-footer>
				<button id="maskingEditModal_button_#4696" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="modCtrl.modalOptions.close()"> 
			  		{{modCtrl.modalOptions.closeButtonText}}
		  		</button>
		  		<button id="maskingEditModal_button_#9786" class="btn btn-primary cvBusyOnAjax" type="submit"> 
		  			{{modCtrl.modalOptions.actionButtonText}}
				</button>
			</div>
		
	</form>
</div>
</fmt:bundle>