<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.informix"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="informixRestoreTemplate.html" >
<div class="form-group" data-ng-if="informixRestoreObj.isFullDataRestore">
	<label for="restoreMode" class="col-xs-12 col-lg-5">
		<cv:msg key="label.restoreMode" bundle="informix"/>
	</label>
	<div class="col-xs-12 col-lg-7">
		<select id="restoreMode" name="restoreMode"  data-ng-required="true"
			data-ng-model="informixRestoreObj.restoreData.globalOptions.restoreMode"
			data-ng-options="restoreMode.value as restoreMode.name for restoreMode in informixRestoreObj.restoreData.globalOptions.restoreModeList " >
		</select>
	</div>
</div>
<div class="form-group">
	<div class="col-xs-12 col-lg-12">
		<label for="restoreDatabase">
				<cv:msg key="label.restoreDatabase" bundle="db2"/>
		</label>
	</div>
</div>
<div class="form-group" >
	<div class="col-xs-12 col-lg-1">
	</div>
	<div class="col-xs-12 col-lg-11" >
		<input type="checkbox" data-ng-model="informixRestoreObj.restoreData.globalOptions.physical" id="physical" name="physical" />
		<label for="physical">
			<cv:msg key="label.physical" bundle="informix" />
		</label>
	</div>
</div>
<div class="form-group" >
	<div class="col-xs-12 col-lg-1">
	</div>
	<div class="col-xs-12 col-lg-11" >
		<input type="checkbox" data-ng-model="informixRestoreObj.restoreData.globalOptions.logical" id="logical" name="logical" />
		<label for="logical">
			<cv:msg key="label.logical" bundle="informix" />
		</label>
	</div>
</div>
<div class="form-group" >
	<div class="col-xs-12 col-lg-1">
	</div>
	<div class="col-xs-12 col-lg-11" >
		<input type="checkbox" data-ng-model="informixRestoreObj.restoreData.globalOptions.restoreConfigFile" id="restoreConfigFile" name="restoreConfigFile" />
		<label for="restoreConfigFile">
			<cv:msg key="label.restoreConfigFile" bundle="informix" />
		</label>
	</div>
</div>
<div class="form-group">
	<div class="col-xs-12 col-lg-12">
		<cv:msg key="label.restoreOptions" bundle="informix" />
	</div>
</div>
<div class="form-group">
	<div class="col-xs-1 col-lg-1">
	</div>
	<div class="col-xs-1 col-lg-11">
		<input type="radio" data-ng-model="informixRestoreObj.restoreData.globalOptions.restoreType" value="0" id="mostRecent" name="mostRecent" />
		<label for="mostRecent"><cv:msg key="label.mostRecent" bundle="oracle" /></label>
	</div>
</div>
<div class="form-group">
	<div class="col-xs-1 col-lg-1">
	</div>
	<div class="col-xs-1 col-lg-4">
		<input type="radio" data-ng-model="informixRestoreObj.restoreData.globalOptions.restoreType" value="1" id="restorePIT" name="restorePIT" />
		<label for="restorePIT"><cv:msg key="label.pit" bundle="oracle" /></label>
	</div>
	<div class="col-xs-1 col-lg-7" data-ng-disabled="(informixRestoreObj.restoreData.globalOptions.restoreType != '1')">
		<cv-date-time-picker date-time-Value="informixRestoreObj.restoreData.globalOptions.restorePitDate" ></cv-date-time-picker>
		<span class="help-block" data-ng-show="cv.restoreForm.getAttempted() && informixRestoreObj.pitError">
			<cv:msg key="error.pit" bundle="oracle" />
		</span>
	</div>
</div>
<div class="form-group">
	<div class="col-xs-1 col-lg-1">
	</div>
	<div class="col-xs-1 col-lg-4">
		<input type="radio" data-ng-model="informixRestoreObj.restoreData.globalOptions.restoreType" value="2" id="toLogicalLog" name="toLogicalLog" />
		<label for="toLogicalLog"><cv:msg key="label.toLogicalLog" bundle="informix" /></label>
	</div>
	<div class="col-xs-1 col-lg-7" data-ng-disabled="(informixRestoreObj.restoreData.globalOptions.restoreType != '2')">
		<input  type="number" id="logicalLogValue" name="logicalLogValue" data-ng-model="informixRestoreObj.restoreData.globalOptions.logicalLogNumber">
		<span class="help-block" data-ng-show="cv.restoreForm.getAttempted() && informixRestoreObj.logicalLogValue">
			<cv:msg key="error.toLogicalLog" bundle="informix" />
		</span>
	</div>
</div>

<cv-hardware-revert
		snap-backup-enabled="informixRestoreObj.isSnapBackupEnabled"
		is-inplace-restore="informixRestoreObj.restoreData.isInplaceRestore"
		entity="informixRestoreObj.entity"
		proxy-client="informixRestoreObj.restoreData.proxyClient"
		hardware-revert="informixRestoreObj.restoreData.globalOptions.hardwareRevert">
</cv-hardware-revert>

<div class="col-xs-12 padding-top-10">
	<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
</div>
</script >
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{informixRestoreObj.serverMessage.type}}" data-ng-bind="informixRestoreObj.serverMessage.message"></span>
	<form name="restoreForm" novalidate data-cv-submit="informixRestoreObj.doRestore()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div id="modern-tab" class="tab-2">
					<cv-tabset-component control='informixRestoreObj.tabControls' default-tab="'owner'">
						<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />'
							help-text='<cv:msg key="label.informixInPlaceHelp" bundle="informix" />'
							data-ng-selected="onTabChanged()">
							<div data-ng-if="informixRestoreObj.tabControls.getCurrentTabId() == 0" class="padding-top-10">
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationServer">
										<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
									</label>
									<label class="col-xs-12 col-lg-7 label-as-input">
										<a target="_blank" ng-href="#clientDetails/{{informixRestoreObj.entity.clientId}}">{{informixRestoreObj.entity.displayName}}</a>
									</label>
								</div>
								<div class="form-group" >
									<label class="col-xs-12 col-lg-5" for="destinationInstance">
										<cv:msg key="label.destInstance" bundle="oracle"/>
									</label>
									<label class="col-xs-12 col-lg-7 label-as-input">
										<a target="_blank" ng-href="#databaseDetails/{{informixRestoreObj.entity.instanceId}}">{{informixRestoreObj.entity.instanceName}}</a>
									</label>
								</div>
								<div data-ng-include="'informixRestoreTemplate.html'">
								</div>
							</div>
						</cv-tab>
						<cv-tab tabname="<cv:msg key="label.OOPRestore" bundle="restore" />"
							help-text='<cv:msg key="label.informixOutOfPlaceHelp" bundle="informix" />'
							data-ng-selected="onTabChanged()">
							<div data-ng-if="informixRestoreObj.tabControls.getCurrentTabId() == 1" class="padding-top-10">
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationServer">
										<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
									</label>
									<div class="col-xs-12 col-lg-7">
										<cv-isteven-single-select id-name="destinationServer"
											input-model="informixRestoreObj.restoreData.globalOptions.destinationServerList"
											binding-model="informixRestoreObj.restoreData.globalOptions.destinationServer"
											track-field="clientId"
											label="displayName"
											tick-property="selected"
											on-change="informixRestoreObj.destinationServerChanged(informixRestoreObj.restoreData.globalOptions.destinationServer)"
											place-holder='<cv:msg key="placeholder.destinationServer" bundle="restore"/>'
											help-text='<cv:msg key="error.oracleVmDestinationServer" bundle="restore"/>'
											required = 'true'  >
										</cv-isteven-single-select>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationInstance">
										<cv:msg key="label.destInstance" bundle="oracle"/>
									</label>
									<div class="col-xs-12 col-lg-7">
										<cv-isteven-single-select id-name="destinationDatabase"
											input-model="informixRestoreObj.restoreData.globalOptions.destinationInstanceList"
											binding-model="informixRestoreObj.restoreData.globalOptions.destinationInstance"
											track-field="instanceId"
											label="instanceName"
											tick-property="selected"
											disable-property="disabled"
											place-holder='<cv:msg key="placeholder.destinationInstance" bundle="saphana"/>'
											help-text='<cv:msg key="error.DestinationInstance" bundle="restore"/>'
											required = 'true'  >
										</cv-isteven-single-select>
									</div>
								</div>
								<div data-ng-include="'informixRestoreTemplate.html'">
								</div>
							</div>
						</cv-tab>
					</cv-tabset-component>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="informixRestore_button_Cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="informixRestoreObj.cancelModel()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="informixRestore_button_Submit" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button>
		</div>
	</form>
</div>
