<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1> <cv:msg key="label.redirectStorageGroup" bundle="db2"/></h1>
	</div>
	<form name="redirectPath" novalidate data-cv-submit="rrOptions.savePaths()" autocomplete="off" >
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-lg-8">

					</label>
					<label class="col-xs-12 col-lg-3 margin-bottom-30">
						<a data-ng-click="rrOptions.showFinsAndReplaceDialog()">
							<cv:msg key="label.findAndReplace" bundle="oracle"/>
						</a>
					</label>
				</div>
				<div class="panel" >
					<div class="panel-body margin-left-25" data-ng-if="rrOptions.showStorageGroups">
					<uib-accordion close-others="true" class="text-left">
						<div class="form-group" data-ng-repeat="sg in rrOptions.storageGroup track by $index">
					    	<div uib-accordion-group is-open="sg.status" >
							   	<uib-accordion-heading>
							        {{sg.groupName}}
							        <i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': sg.status, 'glyphicon-chevron-right': !sg.status}"></i>
							      </uib-accordion-heading>
							      <cv-db2-datafiles-table datafiles="sg.stoPaths" ></cv-db2-datafiles-table>
						     </div>
						</div>
			      	</uib-accordion>
			      	</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button type="button" class="btn cvBusyOnAjax" data-ng-click="rrOptions.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button type="submit" class="btn btn-primary cvBusyOnAjax" >
	  			<cv:msg key="Save" bundle="messages"/>
	  		</button>
		</div>
	</form>
</div>



