<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="db2RestoreTemplate.html" >
<div class="form-group">
	<div class="col-xs-12 col-lg-5">
		<input type="checkbox" data-ng-model="db2RestoreObj.restoreData.globalOptions.recoverDB" id="restoreDatabase" name="restoreDatabase" data-ng-change="db2RestoreObj.restoreDatabaseChange('restoreDB')"/>
		<label for="restoreDatabase">
				<cv:msg key="label.restoreDatabase" bundle="db2"/>
		</label>
	</div>
	<div class="form-group margin-left-20" data-ng-if="db2RestoreObj.tabControls.getCurrentTabId() == 0" >
		<div class="col-xs-12 col-lg-7" >
			<input type="checkbox" data-ng-model="db2RestoreObj.restoreData.globalOptions.recoverDatabase" id="recoverDatabase" name="recoverDatabase" data-ng-change="db2RestoreObj.restoreDatabaseChange('recoverDB')" />
			<label for="recoverDatabase">
			 	<cv:msg key="label.recoverDb" bundle="db2"/>
			</label>
		</div>
	</div>
	<label  class="col-xs-12 col-lg-7" data-ng-if="db2RestoreObj.tabControls.getCurrentTabId() == 1">
	</label>
</div>
<div class="form-group margin-left-20" data-ng-hide="db2RestoreObj.restoreData.globalOptions.recoverDatabase" >
	<div class="col-xs-12 col-lg-12" >
		<input type="checkbox" data-ng-model="db2RestoreObj.restoreData.globalOptions.rollFWTypeOption" id="rollFWSelect" name="rollFWSelect" />
		<label for="rollFWSelect">
			 <cv:msg key="label.rollForward" bundle="db2"/>
		</label>
	</div>
</div>
<div data-ng-disabled="(!db2RestoreObj.restoreData.globalOptions.rollFWTypeOption)">
<div class="form-group margin-left-20">
	<div class="col-xs-12 col-lg-1">
	</div>
	<div class="col-xs-12 col-lg-11">
		<input type="radio" data-ng-model="db2RestoreObj.restoreData.globalOptions.rollFWType" value="1" id="rollFWEndOfLogs" name="rollFWEndOfLogs" />
		<label for="rollFWEndOfLogs"><cv:msg key="label.toEndOfLogs" bundle="db2"/></label>
	</div>
</div>
<div class="form-group margin-left-20">
	<div class="col-xs-1 col-lg-1">
	</div>
	<div class="col-xs-1 col-lg-4">
		<input type="radio" data-ng-model="db2RestoreObj.restoreData.globalOptions.rollFWType" value="0" id="rollFWPIT" name="rollFWPIT" />
		<label for="rollFWPIT"><cv:msg key="label.pit" bundle="oracle" /></label>
	</div>
	<div class="col-xs-1 col-lg-7" data-ng-disabled="(db2RestoreObj.restoreData.globalOptions.rollFWType != '0')">
		<cv-date-time-picker date-time-Value="db2RestoreObj.restoreData.globalOptions.rollFWPitDate" ></cv-date-time-picker>
		<span class="help-block" data-ng-show="cv.restoreForm.getAttempted() && db2RestoreObj.rollFWPitError">
			<cv:msg key="error.rollForwardPit" bundle="db2" />
		</span>
	</div>
</div>
</div>
<div class="form-group margin-left-20" data-ng-hide="db2RestoreObj.restoreData.globalOptions.recoverDatabase" >
	<div class="col-xs-12 col-lg-12">
		<input type="checkbox" data-ng-model="db2RestoreObj.restoreData.globalOptions.redirectOption"  id="redirectOption" name="redirectOption" data-ng-click="db2RestoreObj.showRedirectOptionDialog(!db2RestoreObj.restoreData.globalOptions.redirectOption)"/>
		<label for="redirectOption" >
			<a href="" data-ng-click="db2RestoreObj.showRedirectOptionDialog(!db2RestoreObj.restoreData.globalOptions.redirectOption)" >
				<cv:msg key="label.redirect" bundle="oracle"/>
			</a>
		</label>
	</div>
</div>

<div class="form-group">
	<div class="col-xs-12 col-sm-12">
	<uib-accordion close-others="true" class="text-left" data-ng-init="accordionOpen = false">
		<div uib-accordion-group data-is-open="accordionOpen">
			<uib-accordion-heading>
				 <cv:msg key="label.advancedOptions" bundle="vmsJs"/>
				<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionOpen, 'glyphicon-chevron-right': !accordionOpen}"></i>
			</uib-accordion-heading>
			<div class="form-group margin-left-20">
				<div class="col-xs-12 col-lg-12" >
					<input type="checkbox" data-ng-model="db2RestoreObj.restoreData.globalOptions.restoreLogs" id="restoreLogFiles" name="restoreLogFiles" />
					<label for="restoreLogFiles">
						 <cv:msg key="label.db2RestoreLogs" bundle="db2"/>
					</label>
				</div>
			</div>
			<div  data-ng-disabled="(!db2RestoreObj.restoreData.globalOptions.restoreLogs)">
			<div class="form-group margin-left-20-minus">
				<div class="col-xs-1 col-lg-1">
				</div>
				<div class="col-xs-1 col-lg-4">
					<label><cv:msg key="label.fromTime" bundle="messages"/></label>
				</div>
				<div class="col-xs-1 col-lg-7" >
					<cv-date-time-picker date-time-Value="db2RestoreObj.restoreData.globalOptions.restoreLogsFromDate" ></cv-date-time-picker>
					<span class="help-block" data-ng-show="cv.restoreForm.getAttempted() && db2RestoreObj.restoreData.globalOptions.restoreLogs && db2RestoreObj.isRestoreLogFromTimeError">
						<cv:msg key="error.fromTime" bundle="databaseClone" />
					</span>
				</div>
			</div>
			<div class="form-group margin-left-20-minus">
				<div class="col-xs-1 col-lg-1">
				</div>
				<div class="col-xs-1 col-lg-4">
					<label for="restoreLogsToTime"><cv:msg key="label.toTime" bundle="messages"/></label>
				</div>
				<div class="col-xs-1 col-lg-7" >
					<cv-date-time-picker date-time-Value="db2RestoreObj.restoreData.globalOptions.restoreLogsToDate" ></cv-date-time-picker>
					<span class="help-block" data-ng-show="cv.restoreForm.getAttempted() && db2RestoreObj.restoreData.globalOptions.restoreLogs &&  db2RestoreObj.isRestoreLogToTimeError">
						<cv:msg key="error.toTime" bundle="databaseClone" />
					</span>
				</div>
			</div>
			</div>
		</div>
	</div>

	<cv-hardware-revert
		snap-backup-enabled="db2RestoreObj.snapBackupEnabled"
		is-inplace-restore="db2RestoreObj.restoreData.isInplaceRestore"
		entity="db2RestoreObj.entity"
		proxy-client="db2RestoreObj.restoreData.proxyClient"
		hardware-revert="db2RestoreObj.restoreData.globalOptions.hardwareRevert">
	</cv-hardware-revert>

	</uib-accordion>
  </div>
</div>
<div class="col-xs-12 padding-top-10">
	<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
</div>
</script >
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{db2RestoreObj.serverMessage.type}}" data-ng-bind="db2RestoreObj.serverMessage.message"></span>
	<form name="restoreForm" novalidate data-cv-submit="db2RestoreObj.doRestore()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div id="modern-tab" class="{{db2RestoreObj.tabStyle}}">
					<cv-tabset-component control='db2RestoreObj.tabControls' default-tab="'owner'">
						<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />'
							help-text='<cv:msg key="label.db2InPlaceHelp" bundle="db2" />' >
							<div data-ng-if="db2RestoreObj.tabControls.getCurrentTabId() == 0" class="padding-top-10">
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationServer">
										<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
									</label>
									<label class="col-xs-12 col-lg-7 label-as-input">
										<a target="_blank" ng-href="#clientDetails/{{db2RestoreObj.entity.clientId}}">{{db2RestoreObj.entity.displayName}}</a>
									</label>
								</div>
								<div class="form-group" >
									<label class="col-xs-12 col-lg-5" for="destinationInstance">
										<cv:msg key="label.destInstance" bundle="oracle"/>
									</label>
									<label class="col-xs-12 col-lg-7 label-as-input">
										<a target="_blank" ng-href="#databaseDetails/{{db2RestoreObj.entity.instanceId}}">{{db2RestoreObj.entity.instanceName}}</a>
									</label>
								</div>
								<div class="form-group" >
									<label class="col-xs-12 col-lg-5" for="destinationInstance">
										<cv:msg key="label.targetDBName" bundle="db2"/>
									</label>
									<label class="col-xs-12 col-lg-7 label-as-input">
										<a target="_blank" ng-href="#databaseDetails/{{db2RestoreObj.entity.instanceId}}">{{db2RestoreObj.entity.backupsetName}}</a>
									</label>
								</div>
								<div data-ng-include="'db2RestoreTemplate.html'">
								</div>
							</div>
						</cv-tab>
						<cv-tab tabname="<cv:msg key="label.OOPRestore" bundle="restore" />"
							help-text='<cv:msg key="label.db2OutOfPlaceHelp" bundle="db2" />' >
							<div data-ng-if="db2RestoreObj.tabControls.getCurrentTabId() == 1" class="padding-top-10">
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationServer">
										<cv:msg key="label.fsServer" bundle="restore"/>
									</label>
									<div class="col-xs-12 col-lg-7">
										<cv-isteven-single-select id-name="destinationServer"
											input-model="db2RestoreObj.restoreData.globalOptions.destinationServerList"
											binding-model="db2RestoreObj.restoreData.globalOptions.destinationServer"
											track-field="clientId"
											label="displayName"
											tick-property="selected"
											on-change="db2RestoreObj.destinationServerChanged(db2RestoreObj.restoreData.globalOptions.destinationServer)"
											place-holder='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
											help-text='<cv:msg key="error.DestinationClient" bundle="restore"/>'
											required = "true" >
										</cv-isteven-single-select>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationInstance">
										<cv:msg key="label.destInstance" bundle="oracle"/>
									</label>
									<div class="col-xs-12 col-lg-7">
										<cv-isteven-single-select id-name="destinationInstance"
											input-model="db2RestoreObj.restoreData.globalOptions.destinationInstanceList"
											binding-model="db2RestoreObj.restoreData.globalOptions.destinationInstance"
											track-field="instanceId"
											label="instanceName"
											tick-property="selected"
											on-change="db2RestoreObj.destinationInstanceChanged(db2RestoreObj.restoreData.globalOptions.destinationInstance.instanceId)"
											place-holder='<cv:msg key="placeholder.destinationInstance" bundle="saphana"/>'
											help-text='<cv:msg key="error.DestinationInstance" bundle="restore"/>'
											required = "true" >
										</cv-isteven-single-select>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="destinationInstance">
										<cv:msg key="label.targetDBName" bundle="db2"/>
									</label>
									<div class="col-xs-12 col-lg-7">
                                        <input type="text" id="destDB" name="destDB" data-ng-required="true" data-ng-model="db2RestoreObj.restoreData.globalOptions.targetDb" />
										<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destDB)">
											<cv:msg key="error.targetDBName" bundle="db2"/>
										</span>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-5" for="targetDBPath">
										<cv:msg key="label.targetDBPath" bundle="db2"/>
									</label>
									<div class="col-xs-12 col-lg-7">
										<div class="input-group">
											<input type="text" id="targetDBPath" name="targetDBPath" data-ng-model="db2RestoreObj.restoreData.globalOptions.targetPath" />
											<div class="input-group-btn" data-ng-disabled="!db2RestoreObj.restoreData.globalOptions.destinationServer" >
												<cv-machine-browse
													button-label='<cv:msg key="label.browse" bundle="restore"/>'
													pseudo-client={{db2RestoreObj.isMultiNode}}
													physical-client-list="db2RestoreObj.dpfPartitionClientList"
													client-id='{{db2RestoreObj.restoreData.globalOptions.destinationServer.clientId}}'
													result-function="db2RestoreObj.targetPathResuleFunction">
												</cv-machine-browse>
											</div>
										</div>
										<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.targetDBPath)">
											<cv:msg key="error.targetDBPath" bundle="db2"/>
										</span>
									</div>
								</div>
								<div data-ng-include="'db2RestoreTemplate.html'">
								</div>
							</div>
						</cv-tab>
						<!-- TAB 3 : Restore to disk -->
						<cv-tab tabname="<cv:msg key="label.rtdRestore" bundle="restore" />"
							help-text='<cv:msg key="label.db2RestoreToDiskHelp" bundle="db2" />' data-ng-if="db2RestoreObj.isRestoreToDiskSupported">
							<div data-ng-if="db2RestoreObj.tabControls.getCurrentTabId() == 2" class="padding-top-10">
							<div class="form-group">
								<label class="col-xs-12 col-lg-5" for="destinationServer">
									<cv:msg key="label.fsServer" bundle="restore"/>
								</label>
								<div class="col-xs-12 col-lg-7">
									<cv-isteven-single-select id-name="toDiskDestinationServer"
										input-model="db2RestoreObj.restoreData.globalOptions.restoretoDiskServerList"
										binding-model="db2RestoreObj.restoreData.globalOptions.destinationServer"
										track-field="clientId"
										label="displayName"
										tick-property="selected"
										place-holder='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
										help-text='<cv:msg key="error.DestinationClient" bundle="restore"/>'
										required = "true" >
									</cv-isteven-single-select>
								</div>
							</div>
							<div class="form-group">
								<div class="col-xs-12 col-sm-5">
									<label for="destinationFolder"> <cv:msg key="label.DestinationFolder" bundle="mySql" /></label>
								</div>
								<div class="col-xs-12 col-sm-7">
									<div class="input-group" >
										<input type="text" name="destinationFolder" id="destinationFolder"
											data-ng-model="db2RestoreObj.restoreData.globalOptions.destPath" required />
										<span class="input-group-btn" data-ng-disabled="!db2RestoreObj.restoreData.globalOptions.destinationServer.clientId">
											 <cv-machine-browse
												button-label='<cv:msg key="label.browse" bundle="restore"/>'
												client-id='{{db2RestoreObj.restoreData.globalOptions.destinationServer.clientId}}'
												result-function="db2RestoreObj.browseResultFunction" >
											</cv-machine-browse>
										</span>
									</div>
									<span class="help-block"
										data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationFolder)">
										<cv:msg key="error.DestinationFolder" bundle="mySql" />
									</span>
								</div>
							</div>
								<div class="form-group">
									<div class="col-xs-12">
										<toggle-control status="db2RestoreObj.restoreData.globalOptions.useImpersonation ? 'enabled-activity' : 'disabled-activity'" data-ng-click="db2RestoreObj.toggleImpersonation()"></toggle-control>
										<label>	<cv:msg key='label.impersonateUser' bundle='restore'/>
											<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
										</label>
									</div>
								</div>
								<div class="panel-body padding-top-5" data-ng-if="db2RestoreObj.restoreData.globalOptions.useImpersonation">
									<div class="form-group">
										<label class="col-xs-12 col-sm-5"><cv:msg key="label.username" bundle="restore" /> </label>
										<div class="col-xs-12 col-sm-7">
											<input type="text" name="impersonateUserName" id="impersonateUserName"
												data-ng-model="db2RestoreObj.restoreData.globalOptions.impersonateUserName" required />
											<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.impersonateUserName)">
												<cv:msg key="error.userNameRequired" bundle="restore" />
											</span>
										</div>
									</div>
									<div class="form-group">
										<label class="col-xs-12 col-sm-5"><cv:msg key="label.password" bundle="restore" /> </label>
										<div class="col-xs-12 col-sm-7">
											<input type="password" name="impersonatePassword" id="impersonatePassword"
												data-ng-model="db2RestoreObj.restoreData.globalOptions.impersonatePassword" required />
											<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.impersonatePassword)">
													<cv:msg key="error.uncPasswordRequired" bundle="restore" />
											</span>
										</div>
									</div>
								</div>
							</div>
						</cv-tab>
						<div data-ng-init="db2RestoreObj.afterTabInit()"></div>
					</cv-tabset-component>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="db2RestoreOptions_button_#5420" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="db2RestoreObj.cancelModel()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="db2RestoreOptions_button_#4794" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button>
		</div>
	</form>
</div>
