<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1> <cv:msg key="label.redirectPathOpt" bundle="oracle"/></h1>
	</div>
	<form name="redirectOptions" novalidate cv-hide-api data-cv-submit="rrOptions.saveRedirectOptions()" autocomplete="off" >
		<span class="{{rrOptions.serverMessage.type}}" data-ng-bind="rrOptions.serverMessage.message"></span>
		<div class="panel">
			<div class="panel-body">
				<div id="modern-tab" class="tab-2">
					<cv-tabset-component control='rrOptions.tabControls' default-tab="'owner'">
						<cv-tab tabname='<cv:msg key="label.tablespaces" bundle="db2" />'
							help-text='<cv:msg key="label.tablespacesHelp" bundle="db2" />'
							data-ng-selected="onTabChanged()">
							<div data-ng-if="rrOptions.tabControls.getCurrentTabId() == 0" class="padding-top-10">
								<!-- <div class="panel">
								<div class="panel-body"> -->
									<div class="form-group" >
										<div class="col-xs-12">
											<toggle-control status="rrOptions.data.redirectTablespace==true?'enabled-activity':'disabled-activity'"
							           				data-ng-click="rrOptions.redirectTablespaceSelected()"
							           				title="<cv:msg key="label.redirect" bundle="oracle" />">
							       			</toggle-control>
							       			<label for="redirectTablespace">
												<cv:msg key="label.redirect" bundle="oracle" />
											</label>
										</div>
									</div>
									<div class="form-group margin-left-25" data-ng-disabled="!rrOptions.data.redirectTablespace">
										<div class="col-xs-12 col-lg-5" >
											<input type="radio" id="redirectAllCB" name="redirectAllCB" data-ng-model="rrOptions.data.redirectOption" value="ALL"/>
											<label for="redirectAllCB">
												<cv:msg key="label.redirectAll" bundle="oracle"/>
											</label>
										</div>
										<div class="col-xs-12 col-lg-5">
											<input type="text" id="redirectAll" name="redirectAll" data-ng-model="rrOptions.data.redirectAllPath" data-ng-required="rrOptions.data.redirectTablespace && rrOptions.data.redirectOption === 'ALL' " />
											<span class="help-block" data-ng-show="cv.redirectOptions.needsAttention(redirectOptions.redirectAll);" >
												<cv:msg key="error.redirectAllTablespaces" bundle="db2"/>
											</span>
										</div>
										<span class="col-xs-12 col-lg-2">
											<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
												folders-only = true
												pseudo-client={{rrOptions.isMultiNode}}
												physical-client-list="rrOptions.dpfPartitionClientList"
												client-id='{{rrOptions.clientEntity.clientId}}'
												result-function="rrOptions.redirectAllPathResuleFunction" >
											</cv-machine-browse>
										</span>
									</div>
									<div class="form-group margin-left-25" data-ng-disabled="!rrOptions.data.redirectTablespace">
										<div class="col-xs-12 col-lg-12" >
											<input type="radio" id="individualTSCB" name="individualTSCB" data-ng-model="rrOptions.data.redirectOption" value="INDIVIDUAL" />
											<label for="individualTSCB">
												<cv:msg key="label.tablespacesContainers" bundle="db2"/>
											</label>
										</div>
									</div>
									<div class="panel" data-ng-if=" rrOptions.data.redirectOption == 'INDIVIDUAL' ">
										<div class="panel-body">
											<div class="form-group">
												<label class="col-xs-12 col-lg-7">
												</label>
												<label class="col-xs-12 col-lg-4 margin-bottom-30">
													<a data-ng-click="rrOptions.pathsReplace()">
														<cv:msg key="label.findAndReplace" bundle="oracle"/>
													</a>
												</label>
											</div>
											<cv-oracle-tablespace entity="rrOptions.entity" tablespaces="rrOptions.dataFilesModel" ></cv-oracle-tablespace>
										</div>
									</div>
								</div>
							<!-- </div>
							</div> -->
						</cv-tab>
						<cv-tab data-ng-if = "rrOptions.isAutoDB" tabname="<cv:msg key="label.storageGroups" bundle="db2" />"
							help-text='<cv:msg key="label.storageGroupsHelp" bundle="db2" />'
							data-ng-selected="onTabChanged()">
							<div data-ng-if="rrOptions.tabControls.getCurrentTabId() == 1" class="padding-top-10">
								<div class="form-group">
									<label class="col-xs-12 col-lg-8">
									</label>
									<label class="col-xs-12 col-lg-4 margin-bottom-30">
										<a data-ng-click="rrOptions.storageGroupsReplace()">
											<cv:msg key="label.findAndReplace" bundle="oracle"/>
										</a>
									</label>
								</div>
								<div class="panel" >
									<div class="panel-body" >
									<uib-accordion close-others="true" class="text-left">
										<div data-ng-if="rrOptions.showStorgeGroups" class="form-group" data-ng-repeat="sg in rrOptions.storageGroup track by $index">
									    	<div uib-accordion-group is-open="sg.status" >
											   	<uib-accordion-heading>
											        {{sg.groupName}}
											        <i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': sg.status, 'glyphicon-chevron-right': !sg.status}"></i>
											      </uib-accordion-heading>
											      <cv-oracle-datafiles-table entity="rrOptions.entity" storage-group=true datafiles="sg.stoPaths" ></cv-oracle-datafiles-table>
										     </div>
										</div>
							      	</uib-accordion>
							      	</div>
								</div>
							</div>
						</cv-tab>
					</cv-tabset-component>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="db2RedirectOptions_Cancel_Button" type="button" class="btn cvBusyOnAjax" data-ng-click="rrOptions.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="db2RedirectOptions_Save_Button" type="submit" class="btn btn-primary cvBusyOnAjax" >
	  			<cv:msg key="Save" bundle="messages"/>
	  		</button>
		</div>
	</form>
</div>

