<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
		<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browseTree_item_renderer.html">
	<div data-ng-class="{selected: db2CreateSubclient.isNodeSelected(item)}">
		<button id="db2CreateSubclient_button_#3769"  data-ng-class="item.state | lowercase" data-ng-click="db2CreateSubclient.folderDrilledDown(item,$event)"></button>
 		<span data-ng-click="db2CreateSubclient.folderSelected(item)" data-ng-bind="item.label"></span>
	</div>
    <div class="children" data-ng-class="item.state">
         <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'browseTree_item_renderer.html'"></div>
 			<!--<a data-ng-class="{hidePlease :!item.partiallyLoaded}" data-ng-click="db2CreateSubclient.loadMore(item)">More</a>-->
    </div>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1>
			<span data-ng-hide="db2CreateSubclient.editing"> <cv:msg key="action.subclientCreation" bundle="clients" /> </span>
			<span data-ng-show="db2CreateSubclient.editing"> <cv:msg key="label.EditContent" bundle="fs"/></span>
		</h1>
	</div>
	<span class="{{db2CreateSubclient.serverMessage.type}} serverMessage">{{db2CreateSubclient.serverMessage.message}}</span>
	<form name="createSubclientForm" novalidate autocomplete="off" data-cv-submit="db2CreateSubclient.createSubclient()" >
		<div class="panel" >
			<div class="panel-body" >
				<div class="form-group" data-ng-if="!db2CreateSubclient.editing">
					<label class="col-xs-12 col-lg-6">
						<cv:msg key="label.SubclientName" bundle="clients" />
					</label>
					<div class="col-xs-12 col-lg-6" >
						<input type="text" name="subclientName" id="subclientName" data-ng-model="db2CreateSubclient.entity.subclientName" required autofocus />
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.subclientName)">
							<cv:msg key="error.subclientName" bundle="clients" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!db2CreateSubclient.editing">
					<div class="col-xs-12 col-lg-12">
						<cv-entity-plan-policy-select
								data-ng-if="db2CreateSubclient.planPolicyModel"
								data-cv-model="db2CreateSubclient.planPolicyModel"
								data-cv-show-plan="db2CreateSubclient.showPlan"
								data-cv-app-id="db2CreateSubclient.entity.applicationId"
								data-cv-client-id="db2CreateSubclient.entity.clientId"
								data-cv-wrapper-class="'form-group row'"
								data-cv-label-class="'col-xs-12 col-sm-6 col-lg-6 col-md-6'"
								data-cv-select-class="'col-xs-12 col-sm-6 col-lg-6 col-md-6'"
								cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
					</div>
				</div>
				<div class="form-group" data-ng-if="db2CreateSubclient.isStreamsApplicable">
					<label class="col-xs-12 col-lg-6">
						<cv:msg key="label.numberBackupStreams" bundle="oracle" />
					</label>
					<div class="col-xs-12 col-lg-6">
						<input data-ng-class="{'has-error': cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)}" id="numberBackupStreams" name="numberBackupStreams"
								 required type="number" data-ng-model="db2CreateSubclient.subclientInfo.numberBackupStreams" min="1" max="100" data-ng-maxlength="3" />
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-lg-12">
						<input type="checkbox" id="dataBackup" name="dataBackup" data-ng-model="db2CreateSubclient.subclientInfo.dataBackup"
							data-ng-change="db2CreateSubclient.dataBackupSelected()"  />
						<label for="dataBackup">
								<cv:msg key="label.dataBackup" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group margin-left-25">
					<div class="col-xs-12 col-lg-6">
						<input data-ng-disabled="(!db2CreateSubclient.subclientInfo.dataBackup)" type="radio" id="onlineData" value="0"
							data-ng-change="db2CreateSubclient.updateExcludeLogs()"  data-ng-model="db2CreateSubclient.subclientInfo.backupMode" />
						<label for="onlineData">
							<cv:msg key="label.onlineData" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-lg-5">
						<input data-ng-disabled="(!db2CreateSubclient.subclientInfo.dataBackup)" type="radio" id="offlineData" name="offlineData" value="1"
						data-ng-change="db2CreateSubclient.updateExcludeLogs()" data-ng-model="db2CreateSubclient.subclientInfo.backupMode" />
						<label for="offlineData">
								<cv:msg key="label.offlineData" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-disabled="db2CreateSubclient.isSnapBackupEnabled">
					<div class="col-xs-12 col-lg-6 margin-left-25" data-ng-disabled="(!db2CreateSubclient.subclientInfo.dataBackup)">
						<input type="checkbox" id="onlineSubset" data-ng-model="db2CreateSubclient.subclientInfo.onlineSubset" data-ng-change="db2CreateSubclient.updateExcludeLogs()" />
						<label for="onlineSubset">
								<cv:msg key="label.onlineSubset" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-lg-5 "  >
					</div>
				<div class="form-group" data-ng-if="db2CreateSubclient.subclientInfo.onlineSubset">
					<label class="col-xs-2 col-lg-2">
					</label>
					<div class="col-xs-10 col-lg-10 margin-left-50 " >
						 <div  class="browse-tree" data-ng-class="item.state" style="height: 200px;">
							 <div class="browse-item">
								<div data-ng-class="{selected: db2CreateSubclient.isNodeSelected(db2CreateSubclient.tree)}" >
									<button id="db2CreateSubclient_button_#2444" data-ng-class="db2CreateSubclient.tree.state | lowercase" data-ng-click="db2CreateSubclient.folderDrilledDown(db2CreateSubclient.tree,$event)"></button>
									<span data-ng-click="db2CreateSubclient.folderSelected(db2CreateSubclient.tree)" data-ng-bind="db2CreateSubclient.tree.label"></span>
									<div data-ng-repeat="item in db2CreateSubclient.tree.children" class="browse-item" data-ng-include="'browseTree_item_renderer.html'"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group" data-ng-if="db2CreateSubclient.showExcludeLogImage">
					<div class="col-xs-12 col-lg-6 margin-left-25" >
						<input type="checkbox" id="excludeLogImage" name="excludeLogImage" data-ng-model="db2CreateSubclient.subclientInfo.excludeLogImage" />
						<label for="excludeLogImage">
							<cv:msg key="label.exLogsBacku" bundle="db2" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-disabled="db2CreateSubclient.subclientInfo.backupMode == '1' ">
					<div class="col-xs-12 col-lg-12 margin-top-15">
						<input type="checkbox" id="logBackup" name="logBackup" data-ng-model="db2CreateSubclient.subclientInfo.logBackup"
							data-ng-change="db2CreateSubclient.updateLogBackupSelection()"/>
						<label for="logBackup">
							<cv:msg key="label.archLogBackup" bundle="db2" />
						</label>
					</div>
				</div>
				<div class="form-group margin-left-25">
					<div class="col-xs-12 col-lg-12">
						<input data-ng-disabled="(!db2CreateSubclient.subclientInfo.logBackup)" type="checkbox"
								id="deleteArchiveLogs" name="deleteArchiveLogs" data-ng-model="db2CreateSubclient.subclientInfo.archiveDelete" />
						<label for="deleteArchiveLogs">
								<cv:msg key="label.delArchiveLogsAft" bundle="db2" />
						</label>
					</div>
				</div>
			</div>
			<cv-db2dpf-manage-streams data-ng-if="db2CreateSubclient.showStreams" entity="db2CreateSubclient.entity" db2dpfdata="db2CreateSubclient.db2dpfdata"></cv-db2dpf-manage-streams>
		</div>
		<div class="modal-footer" >
			<button id="db2CreateSubclient_button_#4626" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="db2CreateSubclient.closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="db2CreateSubclient_button_#5209" type="submit" class="btn btn-primary cvBusyOnAjax" >
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
</div>