<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-hide="db2NewInstance.editDialog"><cv:msg key="heading.CreateNewInstance" bundle="db2"/></h1>
	<h1 data-ng-show="db2NewInstance.editDialog"><cv:msg key="heading.editInstance" bundle="db2"/> </h1>
</div>
<div class="bootstrap-wrapper form-horizontal" >
	<form name="createInstanceForm" novalidate data-cv-submit="db2NewInstance.createInstance()" autocomplete="off">
		<span class="{{db2NewInstance.serverMessage.type}}" data-ng-bind="db2NewInstance.serverMessage.message"></span>
		<div class="panel panel-default">
			<div class="panel-body">
				<div class="form-group" data-ng-if="db2NewInstance.addInstance">
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7 text-overflow-allowed" data-ng-disabled="editDialog">
						<cv-client-picker select-none-by-default="true" selected-clients="db2NewInstance.clientSelection.selectedClients" valide-client-selection="db2NewInstance.clientSelection.valideClientSelection" selection-changed="db2NewInstance.clientSelection.selectionChanged(clientEntity)" app-id="37,62"  ></cv-client-picker>
						<span class="help-block" data-ng-show="cv.Oracleinstance.getAttempted() && !db2NewInstance.clientSelection.valideClientSelection" >
							<cv:msg key="option.clientName" bundle="clients"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="instanceName">
						<cv:msg key="label.instanceName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="instanceName" name="instanceName"  data-ng-model="db2NewInstance.instanceEntity.instanceName" data-ng-change="db2NewInstance.updateUserName()" required/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.instanceName);" >
							<cv:msg key="error.instanceName" bundle="sqlserver"/>
						</span>
					</div>
				</div>
				<div class="form-group" >
					<label class="col-xs-12 col-lg-5" for="plan"><cv:msg key="label.profile" bundle="profiles" /></label>
					<div class="col-xs-12 col-lg-7" data-ng-if="db2NewInstance.profileList">
						<cv-plan-summary-dropdown
							id="planSummarySelection"
							input-model="db2NewInstance.profileList"
							output-model="db2NewInstance.selectedProfileList"
							item-label="'name'"
							button-label="'name'"
							tick-property="'selected'"
							translation="localLang"
							group-property="'msGroup'"
							helper-elements="'filter'"
							selection-mode="'single'"
							on-close="db2NewInstance.parseIStevenOutput()">
						</cv-plan-summary-dropdown>
						<span class="help-block" data-ng-show="cv.createInstanceForm.getAttempted() && db2NewInstance.showPlanError">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="dbHome">
						<cv:msg key="label.home" bundle="db2"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="dbHome" name="dbHome" data-ng-required="true" data-ng-model="db2NewInstance.instInfo.dbHome"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{db2NewInstance.instanceEntity.clientId}}' result-function="db2NewInstance.dbHomeResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbHome);" >
							<cv:msg key="error.homeLocation" bundle="db2"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" >
						<cv:msg key="label.db2UserAccount" bundle="db2"/>
					</label>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-lg-1">
					</div>
					<label class="col-xs-12 col-lg-4" for="dbUsername">
						<cv:msg key="label.userName" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="dbUsername" name="dbUsername" data-ng-model="db2NewInstance.instInfo.dbUserName" required />
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbUsername);" >
							<cv:msg key="error.userName" bundle="users"/>
						</span>
					</div>
				</div>
				 <div class="form-group" >
				 	<div class="col-xs-12 col-lg-1">
					</div>
					<label class="col-xs-12 col-lg-4" for="dbUserPassword">
						<cv:msg key="label.password" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="password" id="dbUserPassword" name="dbUserPassword" placeholder='{{ db2NewInstance.editDialog ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}'
						data-ng-model="db2NewInstance.instInfo.dbUserPassword" data-ng-required="db2NewInstance.editDialog !== true && db2NewInstance.isUnixClient !== true"/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbUserPassword);" >
							<cv:msg key="error.password" bundle="users"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="db2CreateInstance_button_#1825" type="button" class="btn cvBusyOnAjax" data-ng-click="db2NewInstance.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="db2CreateInstance_button_#8782" type="submit" class="btn btn-primary cvBusyOnAjax" >
	  			<span data-ng-hide="db2NewInstance.editDialog" > <cv:msg key="Add" bundle="messages"/> </span>
	  			<span data-ng-show="db2NewInstance.editDialog" > <cv:msg key="Save" bundle="messages"/> </span>
	  		</button>
		</div>
	</form>
</div>
