<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.migrate"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.regions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<h3 class="float-left margin-top-10 padding-left-20">
	<cv:msg key="label.migrateOpts" bundle="migrate" />
</h3>
<div class="migrate-modal">
	<div class="bootstrap-wrapper form-horizontal mega-modal-wrapper">
		<span class="serverMessage {{ctrl.serverMessage.type}}"
			data-ng-bind="ctrl.serverMessage.message"></span>
		<form name="cloudMigrateForm" novalidate id="cloudMigrateForm"
			cv-submit="ctrl.doMigrate()" autocomplete="off">
			<cv-selected-items selected-items="ctrl.params.sourceItems" />
			<div class="panel panel-default">
				<div class="panel-body">
					<h4>
						<cv:msg key="label.general" bundle="users" />
					</h4>

					<!-- Vendor -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-4" for="vendor">
							<cv:msg key="label.vendorType" bundle="capps" />
						</label>
						<div class="col-xs-12 col-lg-8">
							<cv-isteven-single-select id-name="vendor"
								id="cloudMigrateForm_vendorSingleSelect"
								input-model="ctrl.vendorTypes"
								binding-model="ctrl.model.selectedVendor" track-field="value"
								label="name" tick-property="selected"
								place-holder='<cv:msg key="placeholder.vendorType" bundle="servers"/>'
								on-change='ctrl.vendorTypeChanged()'
								help-text='<cv:msg key="placeholder.vendorType" bundle="servers"/>'
								required="true"> </cv-isteven-single-select>
						</div>
					</div>

					<!-- Cloud Account -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-4" for="cloudAccount">
							<cv:msg key="label.cloudAccount" bundle="postgres" />
						</label>
						<label data-ng-if="!ctrl.clientListLoaded"
							class="col-xs-12 col-sm-7">
							<cv:msg key="Loading" bundle="messages" />
						</label>
						<div class="col-xs-11 col-lg-7" data-ng-if="ctrl.clientListLoaded">
							<cv-isteven-single-select id-name="cloudAccount"
								id="cloudMigrateForm_cloudAccountSingleSelect"
								input-model="ctrl.clientList"
								binding-model="ctrl.model.selectedClient" track-field="clientId"
								label="displayName" tick-property="selected"
								place-holder='<cv:msg key="placeholder.cloudAccount" bundle="capps"/>'
								on-change='ctrl.clientSelectionChanged()'
								help-text='<cv:msg key="placeholder.cloudAccount" bundle="capps"/>'
								required="true"> </cv-isteven-single-select>
							<span class="help-block"
								data-ng-show="ctrl.clientListError && ctrl.clientListError.length > 0"
								data-ng-bind="ctrl.clientListError"> </span>
						</div>

						<div class="col-xs-1 margin-top-10"
							data-ng-disabled="!ctrl.model.selectedVendor">
							<a href="" data-ng-click="ctrl.addCloudAccountDialog()">
								<cv:msg key="Add" bundle="messages" />
							</a>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-body">
					<h4>
						<cv:msg key="label.destination" bundle="dr" />
					</h4>

					<!-- New instance -->
					<div class="form-group">
						<span class="col-xs-12 col-lg-4">
							<label class="radio">
								<input type="radio" id="createNewInstance"
									name="createNewInstance" value="0"
									data-ng-model="ctrl.model.newOrExistingInstance"
									data-ng-change="ctrl.newOrExistingInstanceChanged()">
								<cv:msg key="label.newInstance" bundle="migrate" />
							</label>
						</span>
					</div>

					<!-- Existing instance -->
					<div class="form-group">
						<span class="col-xs-12 col-lg-4">
							<label class="radio">
								<input type="radio" id="useExistingInstance"
									name="useExistingInstance" value="1"
									data-ng-model="ctrl.model.newOrExistingInstance"
									data-ng-change="ctrl.newOrExistingInstanceChanged()">
								<cv:msg key="label.existingInstance" bundle="migrate" />
							</label>
						</span>
					</div>

					<!-- instance -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-4" for="destInstance">
							<cv:msg key="label.name" bundle="capps" />
						</label>
						<div class="col-xs-12 col-lg-8"
							data-ng-if="ctrl.model.newOrExistingInstance == '0'">
							<input type="text" id="destInstance" name="destInstance"
								required="true" data-ng-model="ctrl.model.inputInstance.name"
								placeholder='<cv:msg key="placeholder.enterInstanceName" bundle="migrate"/>'>
							<span class="help-block"
								data-ng-show="!ctrl.model.inputInstance.name && ctrl.attempted">
								<cv:msg key="placeholder.enterInstanceName" bundle="migrate" />
							</span>
							<span class="help-block"
								data-ng-show="cv.cloudMigrateForm.needsAttention(cloudMigrateForm.destInstance)">
								<cv:msg key="placeholder.enterInstanceName" bundle="migrate" />
							</span>
						</div>
						<label
							data-ng-if="ctrl.model.newOrExistingInstance == '1' && !ctrl.instanceListLoaded"
							class="col-xs-12 col-sm-6">
							<cv:msg key="Loading" bundle="messages" />
						</label>
						<div class="col-xs-12 col-lg-6"
							data-ng-if="ctrl.model.newOrExistingInstance == '1' && ctrl.instanceListLoaded"
							data-ng-disabled="!ctrl.model.selectedClient">
							<cv-isteven-single-select id-name="instance"
								id="cloudMigrateForm_instanceSingleSelect"
								input-model="ctrl.instanceList"
								binding-model="ctrl.model.selectedInstance"
								track-field="instanceId" label="instanceName"
								tick-property="selected"
								place-holder='<cv:msg key="label.selectInstance" bundle="sqlserver"/>'
								help-text='<cv:msg key="label.selectInstance" bundle="sqlserver"/>'
								required="true"> </cv-isteven-single-select>
							<span class="help-block"
								data-ng-show="ctrl.instanceErrorMessage && ctrl.instanceErrorMessage.length > 0"
								data-ng-bind="ctrl.instanceErrorMessage"> </span>
						</div>
						<div class="col-xs-2 margin-top-10"
							data-ng-if="ctrl.model.newOrExistingInstance == '1'"
							data-ng-disabled="!ctrl.model.selectedClient">
							<a href="" id="discoverCloudInstanceBtn"
								data-ng-click="ctrl.discoverInstanceDialog()">
								<cv:msg bundle="migrate" key="label.discoverUnregisterInstances" />
							</a>
						</div>
					</div>

					<!-- Region -->
					<div class="form-group"
						data-ng-if="ctrl.model.newOrExistingInstance == '0'">
						<label class="col-xs-12 col-lg-4" for="region">
							<cv:msg key="label.region" bundle="restore" />
						</label>
						<label data-ng-if="!ctrl.regionListLoaded"
							class="col-xs-12 col-sm-8">
							<cv:msg key="Loading" bundle="messages" />
						</label>
						<div class="col-xs-12 col-lg-8" data-ng-if="ctrl.regionListLoaded">
							<cv-isteven-single-select id-name="region"
								id="cloudMigrateForm_regionSingleSelect"
								input-model="ctrl.regionList"
								binding-model="ctrl.model.selectedRegion" track-field="guid"
								label="displayName" tick-property="selected"
								place-holder='<cv:msg key="error.region" bundle="restore"/>'
								help-text='<cv:msg key="error.region" bundle="restore"/>'
								required="ctrl.regionList.length > 0">
							</cv-isteven-single-select>
							<span class="help-block"
								data-ng-show="ctrl.regionErrorMessage && ctrl.regionErrorMessage.length > 0"
								data-ng-bind="ctrl.regionErrorMessage"> </span>
						</div>
					</div>

					<!-- Resource group -->
					<div class="form-group"
						data-ng-if="ctrl.model.newOrExistingInstance == '0'">
						<label class="col-xs-12 col-lg-4" for="resourceGrp">
							<cv:msg key="label.resourceGroup" bundle="restore" />
						</label>
						<label data-ng-if="!ctrl.azureContainerLoaded"
							class="col-xs-12 col-sm-8">
							<cv:msg key="Loading" bundle="messages" />
						</label>
						<div class="col-xs-12 col-lg-8"
							data-ng-if="ctrl.azureContainerLoaded">
							<cv-isteven-single-select id-name="resourceGrp"
								id="cloudMigrateForm_resourceGrpSingleSelect"
								input-model="ctrl.azureContainerList"
								binding-model="ctrl.model.selectedResourceGroup"
								track-field="displayName" label="displayName"
								tick-property="selected"
								place-holder='<cv:msg key="placeholder.resourceGroup" bundle="migrate"/>'
								help-text='<cv:msg key="placeholder.resourceGroup" bundle="migrate"/>'
								required="ctrl.azureContainerList.length > 0">
							</cv-isteven-single-select>
							<span class="help-block"
								data-ng-show="ctrl.resourceGroupError && ctrl.resourceGroupError.length > 0"
								data-ng-bind="ctrl.resourceGroupError"> </span>

						</div>
					</div>
				</div>

				<div class="panel-body"
					data-ng-if="!ctrl.isSQLServer && ctrl.model.newOrExistingInstance == '0'">

					<h4 class="margin-top-20">
						<cv:msg key="salesforce.label.configuration" bundle="capps" />
					</h4>

					<!-- Pricing tiers -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-4" for="pricingTier">
							<cv:msg key="label.pricingTiers" bundle="migrate" />
						</label>
						<div class="col-xs-12 col-lg-8">
							<cv-isteven-single-select id-name="pricingTiers"
								id="cloudMigrateForm_pricingTiersSingleSelect"
								input-model="ctrl.pricingTierList"
								binding-model="ctrl.model.selectedPricingTier" track-field="id"
								label="id" tick-property="selected"
								on-change='ctrl.pricingTierChanged()' required>
							</cv-isteven-single-select>
						</div>
					</div>

					<!-- vCores -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-4" for="vCore">
							<cv:msg key="label.vCore" bundle="migrate" />
						</label>
						<div class="col-xs-12 col-lg-4">
							<cv-isteven-single-select id-name="vCore"
								id="cloudMigrateForm_vCoreSingleSelect"
								input-model="ctrl.vCoreList" prevent-sort="true"
								binding-model="ctrl.model.selectedvCore"
								tick-property="selected" label="id" track-field="id"
								required="ctrl.model.newOrExistingInstance == '0'">
							</cv-isteven-single-select>
						</div>
					</div>

					<!-- Allocated storage -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-4" for="allocStorage">
							<cv:msg key="label.allocatedStorage" bundle="migrate" />
						</label>
						<div class="col-xs-12 col-lg-2">
							<input type="number" id="allocStorage" name="allocStorage"
								required min="{{ctrl.allocStorageRange.min}}"
								max="{{ctrl.allocStorageRange.max}}"
								value="{{ctrl.allocStorageRange.default}}"
								data-ng-model="ctrl.model.selectedAllocatedStorage"
								data-ng-blur="ctrl.checkAllocStorageValue()">
						</div>
						<label class="col-xs-12 col-lg-2" for="allocStorage">
							<cv:msg key="exchangeMailboxBrowse.size.GB"
								bundle="BackupBrowseMessages" />
						</label>
					</div>
				</div>

				<div class="panel-body"
					data-ng-if="ctrl.model.newOrExistingInstance == '0'">
					<h4 class="margin-top-20">
						<cv:msg key="label.administratorAccount" bundle="migrate" />
					</h4>

					<!-- SQL s3Bucket-->
					<div class="form-group" data-ng-if="ctrl.isSQLAmazon">
						<label class="col-xs-12 col-sm-5" for="s3BucketName">
							<cv:msg key="label.s3bucketName" bundle="sqlserver" />
						</label>
						<div class="col-xs-12 col-md-7">
							<input type="text" id="s3BucketName" name="s3BucketName"
								id="cloudMigrateForm_s3BucketName" data-ng-required="true"
								data-ng-model="ctrl.model.s3BucketName"
								placeholder="{{'<cv:msg key="error.s3bucketName" bundle="sqlserver" />'}}" />
							<span class="help-block"
								data-ng-show="!ctrl.model.s3BucketName && ctrl.attempted">
								<cv:msg key="error.s3bucketName" bundle="sqlserver" />
							</span>
							<span class="help-block"
								data-ng-show="cv.cloudMigrateForm.needsAttention(cloudMigrateForm.s3BucketName)">
								<cv:msg key="error.s3bucketName" bundle="sqlserver" />
							</span>
						</div>
					</div>

					<!-- SQL azureStorageConnectionString-->
					<div class="form-group " data-ng-if="ctrl.isSQLAzure">
						<label class="col-xs-12 col-sm-5"
							for="azureStorageConnectionString">
							<cv:msg key="label.azureStorageConnectionString"
								bundle="sqlserver" />
						</label>
						<div class="col-xs-12 col-sm-7">
							<textarea class="textarea" id="azureStorageConnectionString"
								name="azureStorageConnectionString" data-ng-required="true"
								data-ng-model="ctrl.model.azureStorageConnectionString"
								placeholder="{{'<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />'}}"></textarea>
							<span class="help-block"
								data-ng-show="cv.cloudMigrateForm.needsAttention(cloudMigrateForm.azureStorageConnectionString)">
								<cv:msg key="error.azureStorageConnectionString"
									bundle="sqlserver" />
							</span>
						</div>
					</div>
					<!-- SQL END -->

					<!-- user name-->
					<div class="form-group">
						<label class="col-xs-12 col-sm-4" for="dbUser">
							<cv-help-text
								help-label="<cv:msg key='label.adminUserName' bundle='migrate' />"
								help-text="ctrl.userNameHelpText" />
						</label>

						<div class="col-xs-12 col-sm-8">
							<input type="text" name="dbUser" id="dbUser"
								data-ng-model="ctrl.model.dbCredentials.userName"
								data-ng-required="true"
								placeholder="<cv:msg key="error.userName" bundle="users" />" />
							<span class="help-block"
								data-ng-show="cv.cloudMigrateForm.needsAttention(cloudMigrateForm.dbUser)">
								<cv:msg key="error.dbUser" bundle="postgres" />
							</span>
						</div>
					</div>

					<!-- password-->
					<div class="form-group">
						<label class="col-xs-12 col-sm-4" for="dbPassword">
							<cv-help-text
								help-label="<cv:msg key='label.dbPassword' bundle='postgres' />"
								help-text="ctrl.passwordHelpText" />
						</label>
						<div class="col-xs-12 col-sm-8">
							<input type="password" name="dbPassword" id="dbPassword"
								data-ng-model="ctrl.model.dbCredentials.passwordString"
								data-ng-required="true"
								placeholder="<cv:msg key="error.password" bundle="users" />" />
							<span class="help-block"
								data-ng-show="cv.cloudMigrateForm.needsAttention(cloudMigrateForm.dbPassword)">
								<cv:msg key="error.password" bundle="users" />
							</span>
						</div>
					</div>

					<!-- Confirm password-->
					<div class="form-group">
						<label class="col-xs-12 col-sm-4" for="dbConfirmPassword">
							<cv:msg key="label.confirmPassword" bundle="servers" />
						</label>
						<div class="col-xs-12 col-sm-8">
							<input type="password" name="dbConfirmPassword"
								id="dbConfirmPassword" id="dbConfirmPassword"
								data-ng-model="ctrl.model.dbCredentials.confirmPasswordString"
								data-ng-required="true"
								placeholder="<cv:msg key="error.confirmPassword" bundle="users" />" />
							<span class="help-block"
								data-ng-show="cv.cloudMigrateForm.needsAttention(cloudMigrateForm.dbConfirmPassword)">
								<cv:msg key="error.confirmPassword" bundle="users" />
							</span>
							<span class="help-block"
								data-ng-show="ctrl.model.dbCredentials.passwordString != ctrl.model.dbCredentials.confirmPasswordString
								&& ctrl.attempted">
								<cv:msg key="error.mismatchedPassword" bundle="users" />
							</span>
						</div>
					</div>
				</div>

				<div class="panel-body"
					data-ng-if="ctrl.model.newOrExistingInstance == '0'">
					<h4 class="margin-top-20">
						<cv:msg key="label.networking" bundle="migrate" />
						<span class="optional-text">
							<cv:msg key="label.optional" bundle="users" />
						</span>
					</h4>

					<div class="form-group firewallIPPair">
						<label class="col-xs-12 col-sm-4" for="startIP">
							<cv:msg key="label.clientIPAddress" bundle="migrate" />
						</label>
						<div class="col-xs-12 col-sm-3">

							<input type="text" name="startIP" id="startIP"
								placeholder='<cv:msg key="label.startIP" bundle="migrate"/>'
								data-ng-pattern="ctrl.IPPattern"
								data-ng-model="ctrl.model.startIP"
								data-ng-blur="ctrl.validateStartIPAddress(cloudMigrateForm)" />
							<span class="help-block"
								data-ng-if="ctrl.startIPError && ctrl.startIPError.length > 0"
								data-ng-bind="ctrl.startIPError"> </span>
						</div>

						<div class="col-xs-12 col-sm-3">
							<input type="text" name="endIP" id="endIP"
								placeholder='<cv:msg key="label.endIP" bundle="migrate"/>'
								data-ng-pattern="ctrl.IPPattern"
								data-ng-model="ctrl.model.endIP"
								data-ng-blur="ctrl.validateEndIPAddress(cloudMigrateForm)" />
							<span class="help-block"
								data-ng-if="ctrl.endIPError && ctrl.endIPError.length > 0"
								data-ng-bind="ctrl.endIPError"> </span>
						</div>
						<div class="col-xs-1 margin-top-10">
							<a href=""
								data-ng-disabled="ctrl.startIPError.length > 0 || ctrl.endIPError.length > 0 || ctrl.model.startIP.length == 0 || ctrl.model.endIP.length == 0"
								data-ng-click="ctrl.addIPAddress()">
								<cv:msg key="Add" bundle="messages" />
							</a>
						</div>
					</div>

					<div class="form-group"
						data-ng-if="ctrl.IPErrorMsg && ctrl.IPErrorMsg.length > 0">
						<div class="col-xs-12 col-sm-6 col-md-offset-4">
							<span class="help-block" data-ng-bind="ctrl.IPErrorMsg"> </span>
						</div>
					</div>

					<div class="form-group"
						data-ng-if="ctrl.model.firewallRules.length > 0">
						<div class="col-xs-12 col-sm-8 col-md-offset-4"
							id="firewallRulesTable">
							<cv-grid cv-grid-options="ctrl.contentGridOptions"> </cv-grid>
						</div>
					</div>
				</div>

				<div class="button-container">
					<button id="cloudMigrate_button_#8708" type="button"
						class="btn btn-default cvBusyOnAjax" ng-click="ctrl.cancel()">
						<cv:msg key="action.cancel" bundle="users" />
					</button>
					<button id="cloudMigrate_button_#9663" type="submit"
						class="btn btn-primary cvBusyOnAjax"
						ng-disabled="!ctrl.model.selectedVendor || !ctrl.model.selectedClient">
						<cv:msg key="action.submit" bundle="users" />
					</button>
				</div>
		</form>
	</div>
</div>
