<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1 class="width-full">{{title}}<cv-call-out html-template="helpTextTemplate" class="ng-isolate-scope"/></h1>
	</div>
	<span class="serverMessage {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="wizardForm" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="appMi.submit()">
<!-- General -->
	<div>
	<div class="panel panel-default">
		<div class="panel-body">
			<!-- <div class="form-group">
				<div class="col-xs-12" >
					<input type="checkbox"
							id="preRegistore"
							name="preRegistore"
							data-ng-change="registoredServerChanged()"
							data-ng-model="appMigrate.preRegistore" />
					<label for="preRegistore">
						<cv:msg key="label.userPreRegister" bundle="oracle"/>
					</label>
				</div>
			</div> -->
			<div class="form-group" data-ng-if="appMigrate.preRegistore" data-ng-init="populatProxyClients()">
				<label class="col-xs-12 col-sm-5" for="registoredServers"><cv:msg key="label.regServer" bundle="oracle"/></label>
				<div class="col-xs-12 col-sm-7">
					<select name="registoredServers" id="registoredServers"
						data-ng-options="pClient.label as pClient.label for pClient in proxyClients"
						data-ng-model="appMigrate.cloudMachineName"  >
					</select>
					<span class="help-block" data-ng-show="errors.registoredServers">
						 <cv:msg key="error.regServer" bundle="oracle"/>
					</span>
				</div>
			</div>
			<div class="form-group" data-ng-if="!appMigrate.preRegistore">
				<label class="col-xs-12 col-sm-5" class="page-detail-label" for="cloudType"><cv:msg key="label.cloudVendor" bundle="oracle"/></label>
				<div class="col-xs-12 col-sm-7">
					<%-- <select name="cloudType" id="cloudType"
						data-ng-options="cloud.cloudId as cloud.name for cloud in cloudTypes"
						data-ng-change="cloudTypechange(appMigrate.cloudType)"
						data-ng-model="appMigrate.cloudType" >
						<option value=""><cv:msg key="options.cloudVendor" bundle="oracle"/></option>
					</select>
					<span class="help-block" data-ng-show="errors.cloudType">
						<cv:msg key="options.cloudVendor" bundle="oracle"/>
					</span>  --%>
					
					<cv-isteven-single-select id-name="cloudType"
								input-model="cloudTypes"
								binding-model="appMigrate.cloudType"
								binding-field="cloudId"
								track-field="cloudId"
								label="name"
								tick-property="selected"
								on-change="cloudTypechange(appMigrate.cloudType)"
								place-holder='<cv:msg key="options.cloudVendor" bundle="oracle"/>'
								help-text='<cv:msg key="options.cloudVendor" bundle="oracle"/>'
								required = "true">
					</cv-isteven-single-select>
				</div>
			</div>
			<div class="form-group" data-ng-if="!appMigrate.preRegistore && !isOracleAsService && !isAzureCloud" >
					<label class="col-xs-12 col-sm-5" for="selectExistingVm">
						<cv:msg key="label.selectVm" bundle="dbs"/>
					</label>
					<div class="col-xs-12 col-sm-7">
						
						<%-- <select name="selectExistingVm" id="selectExistingVm"
							data-ng-options="vms.vm.vmName for vms in vmsList"
							data-ng-change="updateOptions(appMigrate.selectedExistingVm)"
							data-ng-model="appMigrate.selectedExistingVm">
							<option value=""><cv:msg key="label.createNewVm" bundle="dbs"/></option>
						</select> --%>
						
						<cv-isteven-single-select id-name="selectExistingVm"
								input-model="vmsList"
								binding-model="appMigrate.selectedExistingVm"
								label="flatLabel"
								track-field="vm.vmGUID"
								tick-property="selected"
								on-change="updateOptions(appMigrate.selectedExistingVm)"
								place-holder='<cv:msg key="label.createNewVm" bundle="dbs"/>'
								help-text='<cv:msg key="options.cloudVendor" bundle="oracle"/>'
								>
					  </cv-isteven-single-select>
					
						<!--  
						<div uib-dropdown class="uib-dropdown" on-toggle="toggled(open)" style="position: initial;" >
						      <span class="uib-dropdown-toggle" uib-dropdown-toggle>
						      	<input style="cursor: pointer;" title="" type="text" id="oraHomeText" name="oraHomeText" data-ng-model="appMigrate.vmNameText" ng-change="updateOptions(null, vmsList)" />
						      </span>
						      <ul data-ng-if="vmsList.length" uib-dropdown-menu class="dropdown-menustorage  dropdown-fixed" >
						      	<li data-ng-repeat="vms in vmsList" data-ng-click="updateOptions(vms)"><a title="{{vms.vm.vmName}}" heref="javascript:void(0);">{{vms.vm.vmName}}</a></li>
						      </ul>
						</div>
						<span class="help-block" data-ng-show="errors.instanceName">
							<span ><cv:msg key="error.vmName" bundle="blrJs"/></span>
						</span>
						-->
					</div>
			</div>
			<div class="form-group" data-ng-if="!appMigrate.preRegistore && isOracleAsService">
				<label class="col-xs-12 col-sm-5" for="serviceName">
					<cv:msg key="label.serviceName" bundle="oracle"/>
					<cv-help-component help-text="<cv:msg key="label.serviceNameHint" bundle="oracle" />"></cv-help-component>
				</label>
				<div class="col-xs-12 col-sm-7">
					<input title="" type="text" id="serviceName" name="serviceName" data-ng-model="appMigrate.vmNameText" ng-change="updateOptions(null)" />
					<span class="help-block" data-ng-show="errors.instanceName">
						<span ><cv:msg key="error.serviceName" bundle="oracle"/></span>
					</span>
				</div>
			</div>
			
		</div>
	</div>
	</div>
<!-- END General-->
	<span class="serverMessage error" data-ng-if="validationErrors.contentSelection" data-ng-bind="validationErrors.contentSelection"></span>
	<uib-accordion close-others="true" class="text-left" >
<!-- Content Selection -->
<div data-ng-if="appMi.showContentSelectionSection()">
	<div uib-accordion-group data-is-open="appMi.openContentSelection" > <!-- data-ng-if="appMi.showContentSelectionSection()" > -->
		<uib-accordion-heading>
		<cv:msg key="label.contentSelt" bundle="oracle"/>
		<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openContentSelection, 'glyphicon-chevron-right': !appMi.openContentSelection}"></i>
		</uib-accordion-heading>
		<div class="bootstrap-wrapper modal-margin" >
			<cv-grid class=" col-xs-12" cv-grid-options="gridContentOptions"></cv-grid>
		</div>
	</div>
</div>
<!-- End Content Selection -->
<!-- Cloud Configuration -->
		<div uib-accordion-group data-is-open="appMi.openAccordion1" data-ng-if="appMi.showConfigSection()" data-ng-click="appMi.cloudConfigClicked = true">
			<uib-accordion-heading>
			<cv:msg key="label.computeNodeConfig" bundle="dbs"/>
			<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion1, 'glyphicon-chevron-right': !appMi.openAccordion1}"></i>
			</uib-accordion-heading>
			
			<!-- <form name="computeNodeForm" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="saveConfigPage()" class="add-collection-form">
				<div data-ng-if="vmTeplPolicy" class="bootstrap-wrapper" data-ng-init="computeNode.initData(vmTeplPolicy,migrationType,appMigrate,configPageEdting)">
			</form> -->
			<div data-ng-if="appMi.cloudConfigClicked && isGeneralSectionValid()">

				<div class="form-group"  data-ng-if="!appMigrate.preRegistore">

					<label class="col-xs-12 col-sm-5" class="page-detail-label" for="AllocPolicyId"><cv:msg key="label.lifeCyclePolicy" bundle="vmManagementJs"/></label>
					<div data-ng-class="showAddReplicationTargetButton ? 'col-xs-11 col-sm-6' : 'col-xs-12 col-sm-7'">

						<%-- <select name="AllocPolicyId" id="AllocPolicyId"
							data-ng-options="policy.entity.vmAllocPolicyId as policy.entity.vmAllocPolicyName for policy in policyList | orderBy:'policy.entity.vmAllocPolicyName'"
							data-ng-change="policyChanged()"
							data-ng-model="appMigrate.policyId"  required>
							<option value=""><cv:msg key="options.policyName" bundle="oracle"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.AllocPolicyId)">
							 <cv:msg key="error.policyName" bundle="oracle"/>
						</span> --%>

						<cv-isteven-single-select id-name="AllocPolicyId"
								input-model="filteredPoliciesList"
								binding-model="appMigrate.policyId"
								binding-field="entity.vmAllocPolicyId"
								label="flatLabel"
								track-field="entity.vmAllocPolicyId"
								tick-property="selected"
								on-change="policyChanged()"
								place-holder='<cv:msg key="options.policyName" bundle="oracle"/>'
								help-text='<cv:msg key="error.policyName" bundle="oracle"/>'
								required = 'true'>
					  </cv-isteven-single-select>
					</div>
					<div class="col-xs-1 margin-top-10" data-ng-show="showAddReplicationTargetButton">
						<a href data-ng-click="addReplicationTarget()">
							<cv:msg key="label.add" bundle="vmManagementJs"/>
						</a>
					</div>

				</div>

				<div class="form-group" data-ng-if="!appMigrate.preRegistore && !isOracleAsService && (!appMigrate.selectedExistingVm || !appMigrate.selectedExistingVm.vm.vmGUID)" >
					<label class="col-xs-12 col-sm-5" for="newVmName" data-ng-show="isAzureCloud">
						<cv-help-text help-label="<cv:msg key="label.column.vmName" bundle="job"/>"
						help-text="'<cv:msg key="info.azureVmNameHint" bundle="vmManagementJs"/>'"></cv-help-text>
					</label>
					<label class="col-xs-12 col-sm-5" for="newVmName" data-ng-hide="isAzureCloud">
							<cv:msg key="label.column.vmName" bundle="job"/>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" id="newVmName" name="newVmName" data-ng-model="appMigrate.vmNameText"
							ng-change="updateOptions(null)" 
							data-ng-pattern="vmnameValidation"
							data-ng-maxlength="15"
							required/>
						<div class="help-block" data-ng-if="wizardForm.newVmName.$invalid && wizardForm.newVmName.$touched">
							<span data-ng-show="wizardForm.newVmName.$error.required"><cv:msg key="error.vmName" bundle="vmManagementJs"/></span>
							<span data-ng-show="wizardForm.newVmName.$error.maxlength"><cv:msg key="error.longVmName" bundle="vmManagementJs"/></span>
							<span data-ng-show="wizardForm.newVmName.$error.pattern && !wizardForm.newVmName.$error.minlength && !wizardForm.newVmName.$error.maxlength">
								<cv:msg key="error.azureVmnameRequirement" bundle="vmManagementJs"/>
							</span>
						</div>
					</div>
				</div>
				<!-- For Azure cloud we need to pick machine credentials -->
				<div class="form-group" data-ng-if="isAzureCloud">
					<label class="col-xs-12 col-sm-5">
						<cv-help-text help-label="<cv:msg key="label.userName" bundle="serversJs"/>"
						help-text="'<cv:msg key="info.azureUsernameHint" bundle="vmManagementJs"/>'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input name="username" id="username" type="text" data-ng-model="appMigrate.machineConfig.vmUser.userName"
						 data-ng-pattern="/^(?=.{1,64}$)[a-zA-Z_][a-zA-Z0-9_-]*$/"
						 data-ng-maxlength="64"
						 required/>
					<div class="help-block" data-ng-show="wizardForm.username.$invalid && wizardForm.username.$touched">
							<span data-ng-show="wizardForm.username.$error.required"><cv:msg key="error.userName" bundle="serversJs"/></span>
						<span data-ng-show="wizardForm.username.$error.maxlength"><cv:msg key="error.longUsername" bundle="serversJs"/></span>
						<span data-ng-show="wizardForm.username.$error.pattern && !wizardForm.username.$error.minlength && !wizardForm.username.$error.maxlength">
							<cv:msg key="error.azureUsernameRequirement" bundle="vmManagementJs"/>
						</span>
					</div>
					<span class="help-block" data-ng-show="!isSqlMigration && appMigrate.machineConfig.vmUser.userName == 'root'">
						<cv:msg key="error.noRootUsername" bundle="oracle"/>
					</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="isAzureCloud">
					<label class="col-xs-12 col-sm-5">
						<cv-help-text help-label="<cv:msg key="label.password" bundle="serversJs"/>"
							help-text="'<cv:msg key="info.azurePasswordHint" bundle="vmManagementJs"/>'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input 
						type="password" 
						id="password" 
						name="password" 
						data-ng-model="appMi.password" 
						data-ng-minlength="12"
						data-ng-maxlength="72"
						data-ng-pattern="/^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])[0-9a-zA-Z!@#$%^&*()_+-=]{12,72}$/"
						required/>

						<div class="help-block" data-ng-if="wizardForm.password.$invalid && wizardForm.password.$touched" >
							<span data-ng-show="wizardForm.password.$error.required"><cv:msg key="error.password" bundle="serversJs"/></span>
							<span data-ng-show="wizardForm.password.$error.minlength"><cv:msg key="error.shortPassword" bundle="serversJs"/></span>
							<span data-ng-show="wizardForm.password.$error.maxlength"><cv:msg key="error.longPassword" bundle="serversJs"/></span>
							<span data-ng-show="wizardForm.password.$error.pattern && !wizardForm.password.$error.minlength && !wizardForm.password.$error.maxlength ">
								<cv:msg key="error.azurePasswordRequirement" bundle="vmManagementJs"/>
							</span>
						  </div>
					</div>
				</div>
				<div class="form-group" data-ng-if="isAzureCloud">
					<label class="col-xs-12 col-sm-5">
						<cv:msg key="label.confirmPassword" bundle="serversJs"/>		
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="password" id="confirmPassword" name="confirmPassword" data-ng-model="confirmPassword" data-cv-equals="{{appMi.password}}" required/>
						<div class="help-block" data-ng-if="wizardForm.confirmPassword.$invalid && wizardForm.confirmPassword.$touched" >
							<span data-ng-show="wizardForm.confirmPassword.$error.required"><cv:msg key="error.repeatPassword" bundle="serversJs"/></span>
							<span data-ng-show="!wizardForm.confirmPassword.$error.required && wizardForm.confirmPassword.$error.cvEquals"><cv:msg key="error.confirmPassword" bundle="serversJs"/></span>
						</div>
					</div>
				</div>
				<div data-ng-if="vmTeplPolicy">
					<div data-ng-if="refreshConfigValue">
						<cv-compute-node modal-style="true" policy-data="vmTeplPolicy" node-data="appMigrate" migration-type="migrationType" editing="configPageEdting"></cv-compute-node>
					</div>
					<div data-ng-if="!refreshConfigValue">
						<cv-compute-node modal-style="true" policy-data="vmTeplPolicy" node-data="appMigrate" migration-type="migrationType" editing="configPageEdting"></cv-compute-node>
					</div>
				</div>
			</div>
		</div>
<!-- END Cloud Configuration -->
<!-- Storage Configuration -->
		<div uib-accordion-group data-is-open="appMi.openAccordion1_0" data-ng-if="appMi.showStorageSection()" >
			<uib-accordion-heading>
			<cv:msg key="label.storageConfg" bundle="oracle"/>
			<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion1_0, 'glyphicon-chevron-right': !appMi.openAccordion1_0}"></i>
			</uib-accordion-heading>
			
			<div data-ng-if="refreshConfigValue">
				<data-cv-storage-config for-accordion="true" sorage-model="appMigrate.machineConfig.storageVol_list" config-type="vmTeplPolicy.entity.policyType" ></data-cv-storage-config>
			</div>
			<div data-ng-if="!refreshConfigValue">
				<data-cv-storage-config for-accordion="true" sorage-model="appMigrate.machineConfig.storageVol_list" config-type="vmTeplPolicy.entity.policyType" ></data-cv-storage-config>
			</div>
		</div>
<!-- End of Storage Configuration -->		
<!-- Service Configuration -->
		<div uib-accordion-group data-is-open="appMi.openAccordion1_1" data-ng-if="appMi.showServiceConfigSection()" >
			<uib-accordion-heading>
			<cv:msg key="label.serviceConfg" bundle="oracle"/>
			<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion1_1, 'glyphicon-chevron-right': !appMi.openAccordion1_1}"></i>
			</uib-accordion-heading>
			
			<div class="form-group" data-ng-show="false">
				<label class="col-xs-12 col-sm-5" for="serviceLevel">
					 <cv:msg key="label.serviceLevel" bundle="oracle"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<select name="serviceLevel" id="serviceLevel" data-ng-required="true"
						data-ng-options="serviceLevel.serviceType as serviceLevel.serviceName for serviceLevel in dbBaseServiceLevels"
						data-ng-model="appMigrate.cloudDBService.oraServiceLevel" >
					</select>
					<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.serviceLevel)">
						<cv:msg key="error.serviceLevel" bundle="oracle"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="meterFrequency">
					 <cv:msg key="label.meterFrequency" bundle="oracle"/> 
				</label>
				<div class="col-xs-12 col-sm-7">
					<%-- <select name="meterFrequency" id="meterFrequency" data-ng-required="true"
						data-ng-options="metering.meteringType as metering.meteringName for metering in meteringFrequencys"
						data-ng-model="appMigrate.cloudDBService.mFrequency" >
					</select>
					<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.meterFrequency)">
						<cv:msg key="error.meterFrequency" bundle="oracle"/>
					</span> --%>
					<cv-isteven-single-select id-name="meterFrequency"
								input-model="meteringFrequencys"
								binding-model="appMigrate.cloudDBService.mFrequency"
								binding-field="meteringType"
								label="meteringName"
								track-field="meteringType"
								tick-property="selected"
								help-text='<cv:msg key="error.meterFrequency" bundle="oracle"/>'
								required = 'true'>
					  </cv-isteven-single-select>
				</div>
			</div>
			<div class="form-group"> 
					<label class="col-xs-12 col-sm-5" for="swRelease">
						<cv:msg key="label.swRelease" bundle="oracle"/>
					</label> 
					<div class="col-xs-12 col-sm-7"> 
						<%-- <select name="swRelease" id="swRelease"  
							data-ng-options="release.releaseType as release.releaseName for release in softwareReleases" 
							data-ng-model="appMigrate.cloudDBService.oraSoftwareRelease" >
						</select>
						<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.swRelease)">
							<cv:msg key="error.swRelease" bundle="oracle"/>
						</span> --%>
						<cv-isteven-single-select id-name="swRelease"
								input-model="softwareReleases"
								binding-model="appMigrate.cloudDBService.oraSoftwareRelease"
								binding-field="releaseType"
								label="releaseName"
								track-field="releaseType"
								tick-property="selected"
								help-text='<cv:msg key="error.swRelease" bundle="oracle"/>'>
					  </cv-isteven-single-select> 
					</div> 
			</div>
			<div class="form-group"> 
					<label class="col-xs-12 col-sm-5" for="sEdition">
						<cv:msg key="label.swEdition" bundle="oracle"/>
					</label> 
					<div class="col-xs-12 col-sm-7"> 
						<%-- <select name="swEdition" id="swEdition" data-ng-required="true"
							data-ng-options="edition.editionType as edition.editionName for edition in softwareEditions" 
							data-ng-model="appMigrate.cloudDBService.oraSoftwareEdition" >
						</select>
						<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.swEdition)">
							<cv:msg key="error.swEdition" bundle="oracle"/>
						</span>   --%>
						
						<cv-isteven-single-select id-name="swEdition"
								input-model="softwareEditions"
								binding-model="appMigrate.cloudDBService.oraSoftwareEdition"
								binding-field="editionType"
								label="editionName"
								track-field="editionType"
								tick-property="selected"
								help-text='<cv:msg key="error.swEdition" bundle="oracle"/>'
								required = 'true'>
					  </cv-isteven-single-select>
					</div> 
			</div>
			<div class="form-group"> 
					<label class="col-xs-12 col-sm-5" for="dbType">
						<cv:msg key="label.dbType" bundle="oracle"/>
					</label> 
					<div class="col-xs-12 col-sm-7"> 
						<%-- <select name="dbType" id="dbType" data-ng-required="true"
							data-ng-options="dbType.dbTypeValue as dbType.dbTypeName for dbType in databseTypes"
							data-ng-model="appMigrate.cloudDBService.oraDatabaseType" >
						</select>
						<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.dbType)">
							<cv:msg key="error.dbType" bundle="oracle"/>
						</span> --%>
						
						<cv-isteven-single-select id-name="dbType"
								input-model="databseTypes"
								binding-model="appMigrate.cloudDBService.oraDatabaseType"
								binding-field="dbTypeValue"
								label="dbTypeName"
								track-field="dbTypeValue"
								tick-property="selected"
								help-text='<cv:msg key="error.dbType" bundle="oracle"/>'
								required = 'true'>
					   </cv-isteven-single-select>
					</div> 
			</div>
		</div>
<!-- END Service Configuration -->
<!-- Node Configuration -->
		<div uib-accordion-group data-is-open="appMi.openAccordion1_2" data-ng-if="appMi.showNodeConfigSection()" >
			<uib-accordion-heading>
			<cv:msg key="label.nodeConfg" bundle="oracle"/>
			<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion1_2, 'glyphicon-chevron-right': !appMi.openAccordion1_2}"></i>
			</uib-accordion-heading>
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="dbName">
								<span><cv:msg key="label.dbName" bundle="oracle"/>
									<cv-help-component help-text="<cv:msg key="help.dbName" bundle="oracle" />"></cv-help-component>
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<input type="text" name="dbName" id="dbName" data-ng-required="true" data-ng-pattern="/^[A-Za-z]([a-zA-Z0-9]){1,8}$/"
								data-ng-model="appMigrate.cloudDBService.dbConfig.dbName"/>
							<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.dbName)">
						 		<cv:msg key="error.dbName" bundle="oracle"/>
							</span>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="adminPassword">
								<span ><cv:msg key="label.adminPassword" bundle="oracle"/>
									<cv-help-component help-text="<cv:msg key="help.adminPassword" bundle="oracle" />"></cv-help-component>
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<input type="password" name="adminPassword" id="adminPassword"
							data-ng-model="appMigrate.cloudDBService.dbConfig.dbPasswordValue"
							data-ng-pattern="/^[A-Za-z](?=.*[0-9])([a-zA-Z0-9#_]){7,29}$/"
							data-ng-required="true"/>
							<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.adminPassword)">
								<cv:msg key="error.adminPassword" bundle="oracle"/>
							</span>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="dbSizeGB">
								<span><cv:msg key="label.usableDbStorage" bundle="oracle"/>
									<cv-help-component help-text="<cv:msg key="help.dbSizeGB" bundle="oracle" />"></cv-help-component>
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<input type="number" name="dbSizeGB" id="dbSizeGB"  min="15" max="2048" required
							data-ng-model="appMigrate.cloudDBService.dbConfig.dbSizeGB" />
							<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.dbSizeGB)">
								<cv:msg key="error.usableDbStorage" bundle="oracle"/>
							</span>
						</div>
					</div>
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="dbConfigVmInstType">
								<cv:msg key="label.computeShape" bundle="oracle"/>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<%-- <select name="dbConfigVmInstType" id="dbConfigVmInstType" required
								data-ng-options="instanceType as instanceType.instanceType.vmInstanceTypeName for instanceType in vmTeplPolicy.amazonPolicy.instanceType"
								data-ng-change="isValidComputeShape()"
								data-ng-model="appMigrate.cloudDBService.dbConfig.vmInstType" data-ng-required="true" >
								<option value=""><cv:msg key="options.computeShape" bundle="oracle"/> </option>
							</select>
							<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.dbConfigVmInstType)">
								<cv:msg key="error.computeShape" bundle="oracle"/>
							</span> --%>
							<cv-isteven-single-select id-name="dbConfigVmInstType"
									input-model="vmTeplPolicy.amazonPolicy.instanceType"
									binding-model="appMigrate.cloudDBService.dbConfig.vmInstType"
									label="flatLabel"
									track-field="instanceType.vmInstanceTypeName"
									tick-property="selected"
									place-holder='<cv:msg key="options.computeShape" bundle="oracle"/>'
									help-text='<cv:msg key="error.computeShape" bundle="oracle"/>'
									required = 'true'>
						   </cv-isteven-single-select>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="listenPort">
								<span><cv:msg key="label.listenPort" bundle="oracle"/>
									<cv-help-component help-text="<cv:msg key="help.listenPort" bundle="oracle" />">
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<input type="number" name="listenPort" id="listenPort"  min="1521" max="5499"
							data-ng-model="appMigrate.cloudDBService.dbConfig.listenerPort" required />
							<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.listenPort)">
								<cv:msg key="error.port" bundle="storage"/>
							</span>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="accessRule">
								<cv:msg key="label.accessRule" bundle="oracle"/>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<textarea name="accessRule" id="accessRule"
								data-ng-model="appMigrate.cloudDBService.accessRule"></textarea>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="backupDest">
								<cv:msg key="label.backupDest" bundle="oracle"/>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<%-- <select name="backupDest" id="backupDest"
									data-ng-options="backup.backupType as backup.backupName for backup in backupTypes"
									data-ng-model="appMigrate.cloudDBService.dbBackupConfig.dbBackupDestination" >
									<option value=""><cv:msg key="options.backupDest" bundle="oracle"/></option>
							</select> --%>
							<cv-isteven-single-select id-name="backupDest"
									input-model="backupTypes"
									binding-model="appMigrate.cloudDBService.dbBackupConfig.dbBackupDestination"
									binding-field="backupType"
									label="backupName"
									track-field="backupType"
									tick-property="selected"
									place-holder='<cv:msg key="options.backupDest" bundle="oracle"/>'>
						   </cv-isteven-single-select>
						</div>
					</div>
					
					<div class="form-group" data-ng-hide="appMigrate.cloudDBService.dbBackupConfig.dbBackupDestination==3">
						<div class="col-xs-12 col-sm-5" >
							<label for="cloudStorage">
								<span>
									<cv:msg key="label.cloudStorage" bundle="oracle"/>
									<cv-help-component help-text="<cv:msg key="label.cloudStorageHint" bundle="oracle" />"></cv-help-component>
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<input type="text" title="{{appMigrate.cloudDBService.dbBackupConfig.cloudStorageContainer}}" name="cloudStorage" id="cloudStorage"
							data-ng-change="isValidStorageContainer()"
							data-ng-model="appMigrate.cloudDBService.dbBackupConfig.cloudStorageContainer"  />
							<span class="help-block" data-ng-show="errors.cloudStorageContainer">
						 		<cv:msg key="error.cloudStorage" bundle="oracle"/>
							</span>
						</div>
					</div>
		
		</div>
<!-- END Node Configuration -->
<!-- Software configuration -->
		<div uib-accordion-group data-is-open="appMi.openAccordion2" data-ng-if="appMi.showSoftwareConfigSection()">
			<uib-accordion-heading>
			<cv:msg key="label.swConfig" bundle="oracle"/>
			<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion2, 'glyphicon-chevron-right': !appMi.openAccordion2}"></i>
			</uib-accordion-heading>
				<div class="form-group" >
					<div class="col-xs-12 col-sm-5" >
					<label for="oracleSoftwareConfiguration">
						<cv-help-text
							help-label="<cv:msg key="label.oraSoftwareConfg" bundle="oracle"/>"
							help-text="'<cv:msg key="info.oracleSoftwareConfiguration" bundle="vmManagementJs"/>'"></cv-help-text>
					</label>
				</div>
					<div class="col-xs-12 col-sm-7" >
						<input id="installedOracleHome" type="radio" name="installedOracleHome" value="1" data-ng-model="appMigrate.softwareConfig.softConfigType" />
						<label for="installedOracleHome">
							<cv:msg key="label.useOracleHome" bundle="oracle"/>
						</label>
					</div>
				</div>
				<div class="form-group" >
					<div class="col-sm-offset-5 col-xs-12 col-sm-7" data-ng-disabled="isCrossPlatfrom" >
						<input id="cloneOracleHome" type="radio" name="installedOracleHome" value="0" data-ng-model="appMigrate.softwareConfig.softConfigType" />
						<label for="cloneOracleHome">
							<cv:msg key="label.cloneOracleHome" bundle="oracle"/>
						</label>
					</div>
				</div>
				<div class="form-group" >
					<div class="col-xs-12 col-sm-5" >
						<label >
							<cv:msg key="label.insDirOnCloud" bundle="oracle"/>
						</label>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<input type="text" id="oracleHome" name="oracleHome" data-ng-model="appMigrate.softwareConfig.softwareInstallDir"/>
					</div>
				</div>
		</div>
<!-- END Software configuration -->
<!-- Firewall Configuration -->
	<div data-ng-if="appMi.showFirewallConfigurationSection()">
		<div uib-accordion-group data-is-open="appMi.openAccordion4">
			<uib-accordion-heading>
					<cv:msg key="label.firewallConfg" bundle="sqlserver"/>
					<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion4, 'glyphicon-chevron-right': !appMi.openAccordion4}"></i>
			</uib-accordion-heading>
			<cv-firewall-options data-ng-if="appMi.refreshFirewallConfig" firewall-config="appMigrate.firewallConfig" modal-style="true" hide-connection-type="hideFirewallConnection"> </cv-firewall-options>
			<cv-firewall-options data-ng-if="!appMi.refreshFirewallConfig" firewall-config="appMigrate.firewallConfig" modal-style="true" hide-connection-type="hideFirewallConnection"> </cv-firewall-options>
		</div>
	</div>
 <!-- END Firewall Configuration -->
<!-- Migration options -->
		<div uib-accordion-group data-is-open="appMi.openAccordion3">
			<uib-accordion-heading>
			<cv:msg key="label.migrationOpt" bundle="oracle"/>
			<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': appMi.openAccordion3, 'glyphicon-chevron-right': !appMi.openAccordion3}"></i>
			</uib-accordion-heading>
			
			<div data-ng-if="isGeneralSectionValid()">
			
			<!-- // migration // -->
			<div class="form-group" data-ng-if="isOracleAsService">
				<div class="col-xs-12 col-sm-5" >
					<label for="instanceBackupType">
						<cv:msg key="label.initDataBackup" bundle="oracle"/>
					</label>
				</div>
				
				<div class="col-xs-12 col-sm-7" >
				
						<!-- <select name="instanceBackupType" id="instanceBackupType"
								data-ng-options="instanceBackup.instanceBackupType as instanceBackup.instanceBackupName for instanceBackup in instanceBackupTypes"
								data-ng-change="initDataBackupChanged(appMigrate.instanceBackupType)"
								data-ng-model="appMigrate.instanceBackupType" >
						</select> -->
						
						<cv-isteven-single-select id-name="instanceBackupType"
									input-model="instanceBackupTypes"
									binding-model="appMigrate.instanceBackupType"
									binding-field="instanceBackupType"
									label="instanceBackupName"
									track-field="instanceBackupType"
									on-change="initDataBackupChanged(appMigrate.instanceBackupType)"
									tick-property="selected"
									place-holder='<cv:msg key="options.backupDest" bundle="oracle"/>'>
						   </cv-isteven-single-select>
				</div>
			</div>
			
			
			
			<div data-ng-if="appMigrate.instanceBackupType==2"> 
				<div class="form-group">
					<div class="col-xs-12" >
						<input type="checkbox" id="OnPremesises" name="OnPremesises"
						data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.onPremisesBackup" />
						<label for="OnPremesises">
							<cv:msg key="label.onPremBackup" bundle="oracle"/>
						</label>
					</div>
				</div>
				
				<div class="form-group" data-ng-if="!appMigrate.cloudDBService.dbRecoveryConfig.onPremisesBackup">
					<div class="col-xs-12 col-sm-5" >
						<label for="availService">
							<cv:msg key="label.availService" bundle="oracle"/>
						</label>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<input type="text" name="availService" id="availService"
							data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.cloudStorageContainer"  />
					</div>
				</div>
				<div data-ng-if="appMigrate.cloudDBService.dbRecoveryConfig.onPremisesBackup">
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="cloudStorage">
								<cv:msg key="label.cloudStorage" bundle="oracle"/>
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" >
							<input type="text" name="cloudStorage" id="cloudStorage"
							data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.cloudStorageContainer"  />	
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="storageUserName">
								<cv:msg key="label.userName" bundle="users"/>
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" >
							<input type="text" name="storageUserName" id="storageUserName"
							data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.storageUser.userName" />	
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="storageUserPassword">
								<cv:msg key="label.password" bundle="users"/>
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" >
							<input type="password" name="storageUserPassword" id="storageUserPassword"
							data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.storageUser.userNamePassowrd"  />
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="dbID">
								<cv:msg key="label.databaseId" bundle="oracle"/>
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" >
							<input type="text" name="dbID" id="dbID"
							data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.dbID"  />	
							<span class="help-block" data-ng-show="errors.cloudStorageDBID">
					 			<cv:msg key="error.databaseId" bundle="oracle"/>
							</span>
						</div>
					</div>
				
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label>
								<cv:msg key="label.decrypMehtod" bundle="oracle"/>
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" >
							<input type="radio" id="uploadWallet" name="decrypMehtodOption" value="0" data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.decMethod" />
							<label for="uploadWallet" >
								<cv:msg key="label.uploadWallet" bundle="oracle"/>
							</label>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-xs-12 col-sm-7 col-sm-offset-5" >
							<input type="radio" id="pastRmanKey" name="decrypMehtodOption" value="1" data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.decMethod" />
							<label for="pastRmanKey" >
								<cv:msg key="label.pastRmanKey" bundle="oracle" />
							</label>	
						</div>
					</div>
					<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="">
								<span data-ng-show="appMigrate.cloudDBService.dbRecoveryConfig.decMethod == 0">
									<cv:msg key="label.walletFilePath" bundle="oracle" />
								</span>
								<span data-ng-hide="appMigrate.cloudDBService.dbRecoveryConfig.decMethod == 0">
									<cv:msg key="label.rmanKey" bundle="oracle" />
								</span>
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" data-ng-if="appMigrate.cloudDBService.dbRecoveryConfig.decMethod == 0">
							<input type="text" name="cloudStorageFilePath" id="cloudStorageFilePath"
								data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.walletFilePath"  />	
						</div>
						<div class="col-xs-12 col-sm-7" data-ng-if="appMigrate.cloudDBService.dbRecoveryConfig.decMethod != 0">
							<textarea name="cloudStorageRman" id="cloudStorageRman"
								data-ng-model="appMigrate.cloudDBService.dbRecoveryConfig.rmanKey"></textarea>
						</div>
					</div>
					
				</div>
			</div>
			
			<div data-ng-if="appMigrate.instanceBackupType==1 && !isSqlMigration">
			
				<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label >
								<cv:msg key="label.migration" bundle="oracle" />
							</label>
						</div>
						
						<div class="col-xs-12 col-sm-7" >
							<label for="oneTime">
								<input type="radio" id="oneTime" name="oneTime" data-ng-value="1" data-ng-model="pattern.freq_type" />
								<cv:msg key="label.oneTime" bundle="oracle" />
							</label>
						</div>
				</div>
				<div class="form-group">
						<div class="col-xs-12 col-sm-7 col-sm-offset-5" >
							<label for="continuous">
								<input  name="continuous" type="radio" id="continuous" data-ng-value="4096" data-ng-model="pattern.freq_type" />
								<cv:msg key="label.continuous" bundle="oracle" />
							</label>
						</div>
				</div>
				
				
				<!-- // baseline // -->
				<!--  
				<div class="form-group">
						<div class="col-xs-12 col-lg-6" >
							<label>
								<cv:msg key="label.baselineSync" bundle="oracle" />
							</label>
						</div>
						<div class="col-xs-12 col-lg-6" >
							<input  type="radio" id="runFullBackup" name="runFullBackup" value="1" data-ng-model="restoreOptions.commonOptions.baselineBackup" />
							<label for="runFullBackup">							
								<cv:msg key="label.runFullBackup" bundle="oracle" />
							</label>
						</div>
				</div>
				<div class="form-group">
						<div class="col-xs-12 col-lg-6 col-lg-offset-6" >
							<input type="radio" id="mostRecentBackup" name="runFullBackup" value="0" data-ng-model="restoreOptions.commonOptions.baselineBackup" />
							<label for="mostRecentBackup">
								<cv:msg key="label.mostRecentBackup" bundle="oracle" />
							</label>
						</div>
				</div>
				-->
			</div>
		
		<div data-ng-if="isSqlMigration">
			<div class="form-group" >
					<div class="col-xs-12 col-sm-5" >
						<cv:msg key="label.recoveryTypes" bundle="sqlserver"/>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<label for="recovery">
							<input name="sqlRecoverType" type="radio" id="recovery" value="0" data-ng-model="restoreOptions.sqlServerRstOption.sqlRecoverType" />
							<cv:msg key="label.recovery" bundle="sqlserver"/>
						</label>
					</div>
			</div>
			<div class="form-group">
					<div class="col-xs-12 col-sm-5"></div>
					<div class="col-xs-12 col-sm-5 col-xs-12 col-sm-7" >
						<label for="noRecovery">
							<input name="sqlRecoverType" type="radio" id="noRecovery" value="1" data-ng-model="restoreOptions.sqlServerRstOption.sqlRecoverType" />
							<cv:msg key="label.noRecovery" bundle="sqlserver"/>
						</label>
					</div>
			</div>
			<div class="form-group">
					<div class="col-xs-12 col-sm-5"></div>
					<div class="col-xs-12 col-sm-7" >
						<label for="standBy">
							<input name="sqlRecoverType" type="radio" id="standBy" value="2" data-ng-model="restoreOptions.sqlServerRstOption.sqlRecoverType" />
							<cv:msg key="label.standBy" bundle="sqlserver"/>
						</label>
					</div>
			</div>
			<div class="form-group" data-ng-hide="restoreOptions.sqlServerRstOption.sqlRecoverType != 2">
					<div class="col-xs-12 col-sm-5">
						<cv:msg key="label.undoFilePath" bundle="sqlserver"/>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<input  type="text"
								id="undoFilePath" name="undoFilePath" data-ng-model="restoreOptions.sqlServerRstOption.undoFilePath" />
					</div>
			</div>

			<div class="form-group" data-ng-hide="true">
					<div class="col-xs-12 col-sm-5">
						<cv:msg key="label.destinationInstance" bundle="sqlserver"/>
					</div>
					<div class="col-xs-12 col-sm-7" >
						<input  type="text" id="destInstanceName" name="destInstanceName" data-ng-model="appMigrate.destInstanceName" />
						<span class="help-block" data-ng-if="validationErrors.migrationOptions">
							<cv:msg key="error.dbInstanceName" bundle="dbs"/>
						</span>
					</div>
			</div>
		</div>
		<!--  
		<span ng-if="isSqlMigration">
		
		// Recovery types and undo path
		<label class="block-style-by-pass">
				<span class="page-detail-column left-column">Recovery types and undo path:</span>
				<span class="page-detail-column float-right right-column">
					<input name="sqlRecoverType" type="radio" id="onlineData" value="0" data-ng-model="restoreOptions.sqlServerRstOption.sqlRecoverType" />
					Recovery
				</span>
		</label>
		
		<label class="block-style-by-pass">
				<span class="page-detail-column left-column">&nbsp;</span>
				<span class="page-detail-column float-right right-column">
					<input name="sqlRecoverType" type="radio" id="onlineSubset" value="1" data-ng-model="restoreOptions.sqlServerRstOption.sqlRecoverType" />
					Norecovery
				</span>
		</label>
		
		<label class="block-style-by-pass">
				<span class="page-detail-column left-column">&nbsp;</span>
				<span class="page-detail-column float-right right-column">
					<input name="sqlRecoverType" type="radio" id="onlineSubset" value="2" data-ng-model="restoreOptions.sqlServerRstOption.sqlRecoverType" />
					Stand by
				</span>
		</label>
		
		<label class="block-style-by-pass">
				<span class="page-detail-column margin-top-7">Undo file path</span>
				<span class="page-detail-column float-right">
					<input  data-ng-disabled = " restoreOptions.sqlServerRstOption.sqlRecoverType != 2"  type="text"
									       id="undoFilePath" name="undoFilePath" data-ng-model="restoreOptions.sqlServerRstOption.undoFilePath" />
				</span>
		</label>
		
		<label class="block-style-by-pass">
				<span class="page-detail-column margin-top-7">Destination instance name</span>
				<span class="page-detail-column float-right">
					<input  type="text" id="destInstanceName" name="destInstanceName" data-ng-model="appMigrate.destInstanceName" />
				</span>
		</label>
		
		</span>
		-->
		
			<div data-ng-if="!(isSqlMigration||appMigrate.instanceBackupType!=1)">
				<!--<div class="form-group">
						<div class="col-xs-12" >
							<input data-ng-disabled="isCrossPlatfrom" type="checkbox" id="standByMode"
										name="standByMode" data-ng-model="restoreOptions.oracleOpt.liveSyncOpt.restoreInStandby" />
							<label for="standByMode">
								<cv:msg key="label.restoreStandBy" bundle="oracle" />
							</label>
						</div>
				</div>-->
				
				<div class="form-group">
						<div class="col-xs-12 col-sm-5" >
							<label for="noOfStreams">
								<cv:msg key="label.noOfStreams" bundle="oracle" />
							</label>
						</div>
						<div class="col-xs-12 col-sm-7" >
							<input  type="number" id="noOfStreams" name="noOfStreams" min="1" max="100" data-ng-model="restoreOptions.oracleOpt.restoreStream" data-ng-disabled="restoreOptions.disableMaxNoOfStreams"/>
							
						</div>
				</div>
			</div>
		
			<div data-ng-if="!(!isSqlMigration && appMigrate.instanceBackupType!=1) && pattern.freq_type != 1">
				
				<%-- <div class="form-group">
						<div class="col-xs-12 col-lg-6" >
							<input type="checkbox" id="copyPreceDencSect" name="copyPreceDencSect" data-ng-model="restoreOptions.copyPreceDencSect" />
							<label for="copyPreceDencSect">
								<span>
									<cv:msg key="label.copyPrec" bundle="oracle" />
								</span>
							</label>
						</div>
						<div class="col-xs-12 col-lg-6" >
							<input data-ng-disabled="restoreOptions.copyPreceDencSect === false" type="number" id="copyPreceDenc" name="copyPreceDenc" value="1" data-ng-model="restoreOptions.copyPrecedence" />
						</div>
				</div> --%>
				<cv-copy-precedence data-ng-if="appMi.defaultSubclientId" subclient-id='appMi.defaultSubclientId' copy-precedence-int='restoreOptions.copyPrecedence' label='<cv:msg key="label.restoreFromCopy" bundle="restore" />'></cv-copy-precedence>
			</div>
			
			<div data-ng-if="!isSqlMigration">
				<h4> <cv:msg key="label.postMigrationOptions" bundle="restore"/> </h4>
				<div class="form-group">
					<div class="col-xs-12 col-sm-5" >
						<cv-help-text help-label="<cv:msg key="label.runScript" bundle="restore"/>"
							help-text="'<cv:msg key="info.runScriptHint" bundle="dbs"/>'"></cv-help-text>
					</div>
					<div class="col-xs-10 col-sm-6" >
						<input type="text" id="validationScript" name="validationScript"
						data-ng-model="appMigrate.validationScript"/>
					</div>
					<div class="col-xs-2 col-sm-1">
						<cv-machine-browse class="upload-button" button-label="<cv:msg key='label.browse' bundle='restore'/>"
						client-id='{{entity.clientId}}' result-function="validationScrtResuleFunction" folders-only="false" can-create-folder="false" allowed-file-formats="postMigrationScriptFormats">
						</cv-machine-browse>
					</div>
				</div>
			</div>
		</div>
		
		</div>
<!-- END Migration options -->
	</uib-accordion>
	<div class="modal-footer">
  		<button id="appMigrationModal_button_#9394" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="appMi.cancel()"> 
  			<cv:msg key="Cancel" bundle="messages"/>
 		</button>
  		<button id="appMigrationModal_button_#4179" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="(appMi.showConfigSection() && !appMi.cloudConfigClicked) || wizardForm.$invalid">  
  			<span> <cv:msg key="OK" bundle="messages"/> </span>
  		</button>
	</div>
</form>
</div>