<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1 data-ng-hide="isEditing"> <cv:msg key="label.addStorage" bundle="oracle"/></h1>
		<h1 data-ng-show="isEditing"> <cv:msg key="label.editStorage" bundle="oracle"/></h1>
	</div>
   <form name="addVolume" novalidate autocomplete="off" data-cv-submit="saveModle()" class="add-collection-form">
	<div class="panel">		
	   <div class="panel-body">
		<div class="form-group">
			<label class="col-xs-12 col-lg-6" >
				<cv:msg key="label.mountPoints" bundle="oracle"/>	
			</label>
			<div class="col-xs-12 col-lg-6">
				<input type="text" name="mountPathName" id="mountPathName" 
				   data-ng-model="storage.mntPoint.mountPathName" required />
				<span class="help-block" data-ng-show="cv.addVolume.needsAttention(addVolume.mountPathName)">
					 <cv:msg key="error.mountPoint" bundle="oracle"/> 
				</span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-lg-6" >
				<cv:msg key="label.sizeGB" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-6">
				<input type="number" name="volumeSize" id="volumeSize" 
				  min="1" data-ng-model="storage.volumeSize" required />
				<span class="help-block" data-ng-show="cv.addVolume.needsAttention(addVolume.volumeSize)">
					 <cv:msg key="error.mountPointSize" bundle="oracle"/> 
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="!isOracleCloud && !isAzureCloud">
			<label class="col-xs-12 col-lg-6" >
				<cv:msg key="label.volumeType" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-6">
				<%-- <select id="volumeType" name="volumeType" data-ng-model="storage.amazonVolConfig.volumeType" required
						data-ng-options="volumeType.volumeId as volumeType.name for volumeType in volumeTypes | orderBy: 'name'" >
					<option value=""><cv:msg key="options.volumeType" bundle="oracle"/></option>
				</select>
				<span class="help-block" data-ng-show="cv.addVolume.needsAttention(addVolume.volumeType)">
					<cv:msg key="error.volumeType" bundle="oracle"/>
				</span> --%>
				
				<cv-isteven-single-select id-name="volumeType" 
					input-model="volumeTypes"
					binding-model="storage.amazonVolConfig.volumeType"
					binding-field="volumeId"
					label="name"
					track-field="volumeId"
					tick-property="selected"
					place-holder='<cv:msg key="options.volumeType" bundle="oracle"/>'
					help-text='<cv:msg key="error.volumeType" bundle="oracle"/>'
					required='true'>
				</cv-isteven-single-select>
			</div>
		</div>
					
		<div class="form-group" data-ng-if="!isOracleCloud">
			<label class="col-xs-12 col-lg-6" >
				<cv:msg key="label.iopsLimit" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-6">
				<input type="number" name="iopsLimit" id="iopsLimit" min="0" required
					data-ng-model="storage.amazonVolConfig.iopsLimit"/>
				<span class="help-block" data-ng-show="cv.addVolume.needsAttention(addVolume.iopsLimit)">
					<cv:msg key="error.iopsLimit" bundle="oracle"/>
				</span>	
			</div>	
		</div>
		<div class="form-group"> 
			<label class="col-xs-12 col-lg-6"> 
				<cv:msg key="label.description" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-6"> 
				<input type="text" id="volumeTag" name="volumeTag"  
					data-ng-model="storage.volumeTag" />
			</div> 
		</div>
	   </div>
	</div>
	<div class="modal-footer">
  		<button id="appMigrationAddStorage_button_#6095" type="button" class="btn" data-ng-click="closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
  		<button id="appMigrationAddStorage_button_#0932" type='submit' class='btn btn-primary cvBusyOnAjax'> <cv:msg key="Save" bundle="messages"/></button> 
	</div>
  </form>
 </div>