<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="cloudDBTemplate.html">
	<div data-ng-if="addCloudDB.showAccessNodeConfiguration()">
		<cv-capps-access-nodes instance-type="addCloudDB.cloudAppsType"
			selected-access-nodes-list="addCloudDB.accessNodes"
			submit-attempted="addCloudDB.submitAttempted"
			exclude-client-groups="true"
			selection-change="addCloudDB.onAccessNodeChange(data)">
		</cv-capps-access-nodes>
	</div>

	<cv-entity-plan-policy-select data-ng-if="addCloudDB.entity.applicationId && addCloudDB.clientIdForPlans" data-cv-model="addCloudDB.planPolicyModel"
			data-cv-app-id="addCloudDB.entity.applicationId" data-cv-client-id="addCloudDB.clientIdForPlans" data-cv-wrapper-class="'form-group'"
			no-bootstrap-wrapper-class="true"
			data-cv-label-class="'col-xs-12 col-sm-5'" data-cv-select-class="'col-xs-12 col-sm-7'"
			submit-attempted="addCloudDB.submitAttempted"
			required-field="true"
			cv-hide-policy-toggle-option="true">
	</cv-entity-plan-policy-select>

	<cv-capps-optional-capacity data-ng-if="addCloudDB.showReadCapacity" enable="addCloudDB.model.enableAdjustReadCapacity"
								capacity="addCloudDB.model.adjustReadCapacity" min="1" max="{{addCloudDB.CAPPS_CONSTANTS.AMAZON_DYNAMODB_CONSTANTS.MAX_TEMP_READ_CAPACITY}}"
								label='<cv:msg key="label.adjustReadCapacity" bundle="capps"/>'
								unit-label='<cv:msg key="label.units" bundle="capps"/>'
								tooltip-label='<cv:msg key="label.adjustReadCapactiyHelp" bundle="capps"/>'/>

		<div class="form-group" data-ng-if="!addCloudDB.editContent && addCloudDB.showContent && (addCloudDB.entity.isAccessNodeConfigured || addCloudDB.accessNodes.length)">
			<label for="contentText" class="col-xs-12 col-sm-5">
				<cv:msg key="label.backupContent" bundle="restore"/>
			</label>
			<label class="col-xs-11 col-sm-6 label-as-input">
				{{addCloudDB.getDefaultContentText()}}
			</label>
			<label class="col-xs-1 label-as-input">
				<a href="" data-ng-click="addCloudDB.editContent = true"> <cv:msg key="label.inlineEdit" bundle="messagesJs"/> </a>
			</label>
		</div>
	<div class="row">
		<cv-capps-browse-content data-ng-if="addCloudDB.editContent && addCloudDB.showContent && addCloudDB.enableContentBrowse" show-title="true" select-all-by-default="true" hide-search="true" entity="addCloudDB.entity"  selected-content="addCloudDB.selectedContent" instance-type="addCloudDB.cloudAppsType"
			access-nodes="addCloudDB.accessNodes"/>

		<cv-capps-browse-content data-ng-if="addCloudDB.editContent && addCloudDB.showContent && !addCloudDB.enableContentBrowse" show-title="true" select-all-by-default="true" hide-search="true" entity="addCloudDB.entity"  selected-content="addCloudDB.selectedContent" instance-type="addCloudDB.cloudAppsType"
			access-nodes="addCloudDB.accessNodes"/>
	</div>

	<gcp-spanner-inputs ng-if="addCloudDB.showGCPInputs" input-options="addCloudDB.GCPInputOptions" form-name="addCloudDBForm" />

	<cv-clouddb-create-instance data-ng-if="addCloudDB.useChildDirective"
		data = "addCloudDB.childDirectiveData"
		modal-instance= "addCloudDB.$uibModalInstance"
		is-generic-screen="true"
		submit-attempted="addCloudDB.submitAttempted"
		server-message="addCloudDB.serverMessage"
		client-entity="addCloudDB.entity">
	</cv-clouddb-create-instance>
</script>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 data-ng-bind="addCloudDB.dialogTitle"> </h1>
	</div>
	<span class="{{addCloudDB.serverMessage.type}}" data-ng-bind="addCloudDB.serverMessage.message"></span>
	<form name="addCloudDBForm" class="form-horizontal" novalidate data-cv-submit="addCloudDB.submit()" data-cv-validate="addCloudDB.validateInputs()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" data-ng-if="addCloudDB.showVendorSelection">
					<label class="col-xs-12 col-sm-5" for="vendorType"><cv:msg key="label.vendorType" bundle="servers"/></label>
					<div class="col-xs-12 col-sm-7" data-ng-disabled="addCloudDB.isCreateRDSInstance" >
						<isteven-multi-select id="addServerContent_isteven-multi-select_#8657"
							input-model="addCloudDB.vendorList"
							output-model="addCloudDB._selectedVendors"
							button-label="name"
							item-label="icon name"
							directive-id="vendorType"
							tick-property="selected"
							selection-mode="single"
							prevent-sort="true"
							class="isteven-multi-select user-group-select single-select"
							translation="addCloudDB.vendorLoc"
							is-required="true"
							on-item-click="addCloudDB.onVendorChanged(addCloudDB._selectedVendors[0])">
						</isteven-multi-select>
						<span class="help-block" data-ng-show="cv.addCloudDBForm.needsAttention(addCloudDBForm.vendorType)">
                        	<cv:msg key="error.vendorType" bundle="servers"/>
                       	</span>
					</div>
				</div>

				<div class="form-group" data-ng-if="addCloudDB.selectedVendor && addCloudDB.databaseServiceList.length">

					<label class="col-xs-12 col-sm-5" for="databaseService"><cv:msg key="label.databaseService" bundle="servers"/> </label>

					<div class="col-xs-12 col-sm-7" data-ng-if="addCloudDB.showDatabaseServiceSelection" data-ng-disabled="addCloudDB.isCreateRDSInstance">
						<isteven-multi-select id="databaseServiceSelection"
							input-model="addCloudDB.databaseServiceList"
							output-model="addCloudDB._databaseService"
							button-label="displayName"
							item-label="displayName"
							directive-id="databaseService"
							tick-property="selected"
							selection-mode="single"
							class="isteven-multi-select user-group-select single-select"
							translation="addCloudDB.databaseServiceLoc"
							is-required="true"
							on-item-click="addCloudDB.onDatabaseServiceChanged(addCloudDB._databaseService[0])">
						</isteven-multi-select>
						<span class="help-block" data-ng-show="cv.addCloudDBForm.needsAttention(addCloudDBForm.databaseService)">
                        	<cv:msg key="error.databaseService" bundle="servers"/>
                       	</span>
					</div>
					<label class="col-xs-12 col-sm-7" data-ng-if="!addCloudDB.showDatabaseServiceSelection">
						{{addCloudDB.dbServiceLable}}
					</label>
				</div>

				<div class="form-group" data-ng-if="addCloudDB.showCosmosDbApi">

					<label class="col-xs-12 col-sm-5" for="cosmosDbApi">
					<cv-help-text help-label="{{addCloudDB.cosmosDbApiLabel}}" help-text="addCloudDB.cosmosDbApiHelpText"></cv-help-text></label>
					<div class="col-xs-12 col-sm-7" data-ng-if="addCloudDB.showCosmosDbApiSelection">
						<cv-isteven-single-select id-name="cosmosDbApi"
							input-model="addCloudDB.cosmosDbApis"
							binding-model="addCloudDB.selectedCosmosDbApis"
							track-field="labelName" label="labelName"
							tick-property="selected" disable-property="disabled"
							data-helper-elements="filter"
							on-change="addCloudDB.onChangeCosmosDbApi(addCloudDB.selectedCosmosDbApis)"
							place-holder='<cv:msg key="placeholder.selectApi" bundle="capps"/>'>
						</cv-isteven-single-select>
						<span class="help-block" data-ng-show="cv.addCloudDBForm.needsAttention(addCloudDBForm.cosmosDbApi)">
                        	<cv:msg key="error.api" bundle="capps"/>
                       	</span>
					</div>
					<label class="col-xs-12 col-sm-7" data-ng-if="addCloudDB.selectedCosmosDbApi">
						{{addCloudDB.selectedCosmosDbApi}}
					</label>
				</div>


				<div class="form-group" data-ng-if="addCloudDB.showBackupMethod">
					<label class="col-xs-12 col-sm-5" for="backupMethod"><cv:msg key="label.backupMethod" bundle="servers"/></label>
					<div class="col-xs-12 col-sm-3" data-ng-if="addCloudDB.dbService.cloudAppsType === addCloudDB.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key">
						<input  type="radio" id="snapShot" value="0" data-ng-model="addCloudDB.backupMethod" data-ng-change="addCloudDB.backupMethodChanged(addCloudDB.backupMethod)"/>
						<label for="snapShot" >
							<cv:msg key="label.snapshot" bundle="servers" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-4" data-ng-if="addCloudDB.dbService.cloudAppsType === addCloudDB.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key">
						<input  type="radio" id="snapShot" value="1" data-ng-model="addCloudDB.backupMethod" data-ng-change="addCloudDB.backupMethodChanged(addCloudDB.backupMethod)"/>
						<label for="export">
							<cv:msg key="label.export" bundle="servers" />
						</label>
					</div>
					<label class="col-xs-12 col-sm-7" data-ng-if="addCloudDB.dbService.cloudAppsType !== addCloudDB.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key">
						{{addCloudDB.backupMethodLabel}}
					</label>
				</div>

				<cv-cloud-db-engine-select on-engine-changed="addCloudDB.onEngineChanged(databaseEngine)"></cv-cloud-db-engine-select>

				<div class="form-group" data-ng-if="addCloudDB.showInstanceName" >
					<label for="instanceName" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.dbInstanceName" bundle="dbs" />
					</label>
					<div class="col-xs-11 col-sm-6" >
					 	<input type="text" name="instanceName" data-ng-model="addCloudDB.entity.instanceName"/>
						<span class="help-block" data-ng-show="cv.addCloudDBForm.needsAttention(addCloudDBForm.instanceName)">
                        	<cv:msg key="error.dbInstanceName" bundle="dbs"/>
                       	</span>
					</div>
				</div>

				<div class="form-group" data-ng-if="addCloudDB.showSubclientName" >
					<label for="groupName" class="col-xs-12 col-sm-5" data-ng-bind="addCloudDB.subclientNameLabel">
					</label>
					<div class="col-xs-11 col-sm-6" >
					 	<input type="text" name="groupName" data-ng-model="addCloudDB.subclientName"/>
						<span class="help-block" data-ng-show="cv.addCloudDBForm.needsAttention(addCloudDBForm.instanceName)">
                        	{{addCloudDB.subclientNameLabelError}}
                       	</span>
					</div>
				</div>

				<div class="form-group" data-ng-if="addCloudDB.showCloundAccount && addCloudDB.clientListLoaded">
					<label for="subclientName" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.cloudAccount" bundle="postgres" />
					</label>
					<div class="col-xs-11 col-sm-6" >
					 	<isteven-multi-select id="addCloudDatabase_isteven-multi-select_#5611"
					 			directive-id="accountName"
								input-model="addCloudDB.clientList"
								output-model="addCloudDB._selectedClients"
								button-label="displayName"
								item-label="displayName"
								translation="addCloudDB.clientLoc"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								selection-mode="single"
								on-close="addCloudDB.clientSelectionChanged()"
								is-required = "true"
								helper-elements="filter">
						</isteven-multi-select>
						<span class="help-block" data-ng-show="cv.addCloudDBForm.needsAttention(addCloudDBForm.accountName)">
                        	<cv:msg key="placeholder.cloudAccount" bundle="capps"/>
                       	</span>
					</div>
					<div class="col-xs-1 margin-top-10">
						<a href="" data-ng-click="addCloudDB.addHypervisorDialog()"><cv:msg key="Add" bundle="messages"/></a>
					</div>
				</div>

				<div data-ng-show="addCloudDB.entity.clientId">
					<div data-ng-if="!addCloudDB.engineFlag" data-ng-include="'cloudDBTemplate.html'"></div>
					<div data-ng-if="addCloudDB.engineFlag" data-ng-include="'cloudDBTemplate.html'"></div>
				</div>

				<!-- <gcp-spanner-input -->

			</div>
		</div>
		<div class="modal-footer" data-ng-if="!addCloudDB.useChildDirective">
			<button id="addCloudDatabase_button_#9807" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="addCloudDB.cancel()">
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="addCloudDatabase_button_#7110" class="btn btn-primary cvBusyOnAjax" type="submit"  data-ng-disabled="!addCloudDB.clientListLoaded || addCloudDB.showContent && addCloudDB.editContent && addCloudDB.selectedContent.length === 0">
				<cv:msg key="Add" bundle="messages"/>
			</button>
		</div>
	</form>

</div>
