import 'capps/js/services/cappsClients.svc.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'browse/js/services/browse.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;
app.service('idaService', [
	'AppTypes',
	'$http',
	'$q',
	'$log',
	'cvToaster',
	'cvLoc',
	'CAPPS_CONSTANTS',
	'cappsClientService',
	'AppTypesUtil',
	'associateSchedulePolicy',
	'$cacheFactory',
	'selectionService',
	'distributedClusterType',
	function(
		AppTypes,
		$http,
		$q,
		$log,
		cvToaster,
		cvLoc,
		CAPPS_CONSTANTS,
		cappsClientService,
		AppTypesUtil,
		associateSchedulePolicy,
		$cacheFactory,
		selectionService,
		distributedClusterType
	) {
		var service = this;
		service.sessionId = '';
		service.subclientId = '';
		service.isFindSession = false;

		// we use a regex to trim the session id to the format <timestamp>-<workerid>
		// this is to avoid sending incorrect session ids in the request
		var sessionIdRegex = new RegExp(/^\d+-\d+/);
		var browseCache = $cacheFactory('browseCache' + Math.random()); //to avoid CacheId '{0}' is already taken issue!

		this.getNodeEntity = function(nodeType, entityId) {
			return $http.get('nodeEntity.do?nodeType=' + nodeType + '&entityId=' + entityId);
		};

		this.createInstance = function(instInfo, editing) {
			var url = '';
			if (editing === 'ADD_CLIENT') {
				url = 'createPseudoClient.do';
			} else if (editing) {
				url = 'updateInstance.do';
			} else {
				url = 'createInstance.do';
			}
			return $http.post(url, instInfo);
		};

		this.createBackupSet = function(backupsetInfo, editing) {
			if (editing) {
				backupsetInfo.isDefaultBackupset = backupsetInfo.isDefaultBackupSet;
				return $http.post('updateBackupsetDetails.do', backupsetInfo);
			} else {
				return $http.post('createBackupSet.do', backupsetInfo);
			}
		};

		this.createSubclient = function(params, editing) {
			if (editing) {
				return $http.post('updateSubclient.do', params);
			} else {
				return $http.post('createSubclient.do', params);
			}
		};

		this.updateSubclient = function(params) {
			return $http.post('updateSubclient.do', params);
		};

		this.deleteEntity = function(entityType, entity) {
			var parms = {};
			var urlString = '';
			if (entityType === 'CLIENT_ENTITY') {
				return $http['delete']('deleteClient.do?clientId=' + entity.clientId);
			}
			if (entityType === 'INSTANCE_ENTITY') {
				urlString = 'deleteInstance.do';
				parms = {
					instanceEntity: angular.toJson(entity)
				};
			} else if (entityType === 'BACKUPSET_ENTITY') {
				urlString = 'deleteBackupSet.do';
				parms = {
					genericEntity: angular.toJson(entity)
				};
			} else if (entityType === 'SUBCLIENT_ENTITY') {
				urlString = 'deleteSubclient.do';
				parms = {
					genericEntity: angular.toJson(entity)
				};
			}

			return $http.post(urlString, parms);
		};

		this.getChildranData = function(entityType, entity) {
			var urlString = '';
			if (entityType === 'BACKUPSET_ENTITY') {
				urlString = 'backupSetsByInstance.do?clientId=' + entity.clientId + '&applicationId=' + entity.applicationId;
				if (entity.instanceId) {
					urlString = urlString + '&instanceId=' + entity.instanceId;
				}
				if (AppTypesUtil.isDB2Agent(entity.applicationId)) {
					urlString = urlString + '&excludeHidden=' + true;
				}
			} else if (entityType === 'SUBCLIENT_ENTITY') {
				urlString =
					'subclientsList.do?clientId=' +
					entity.clientId +
					'&applicationId=' +
					entity.applicationId +
					'&instanceId=' +
					entity.instanceId;
				var backupsetId = 0;
				if (entity.backupsetId) {
					backupsetId = entity.backupsetId;
				}
				urlString = urlString + '&backupsetId=' + backupsetId;
			}
			return $http.get(urlString);
		};

		this.submitScriptPreviewJob = function(createTaskReq) {
			return $http.post('scriptPreviewJob.do', { createTask: angular.toJson(createTaskReq) });
		};
		this.submitTask = function(createTaskReq) {
			return $http.post('createTask.do', { inputRequest: angular.toJson(createTaskReq) });
		};

		this.getAgents = function(clientId) {
			return $http.get('agents.do?clientId=' + clientId);
		};

		this.getSubClientDetails = function(subclientId) {
			return $http.get('subclientDetails.do?subclientId=' + subclientId);
		};

		this.getSubClientContent = function(subClientInfo) {
			return $http.post('subclientContent.do', subClientInfo);
		};

		this.getSubClientAlerts = function(subClientId) {
			return $http.get('serverAlerts.do?clientId=0&subClientId=' + subClientId);
		};

		this.getDBClients = function(applicationId) {
			return $http.get('dbClients.do?applicationId=' + applicationId);
		};

		this.getDBInstances = function(clientId, reload) {
			var url = 'dbInstances.do';
			var reloadValue = false;
			if (reload) {
				reloadValue = reload;
			}
			url = url + '?reload=' + reloadValue;
			if (clientId) {
				url = url + '&clientId=' + clientId;
			}
			return $http.get(url);
		};

		this.refreshOraInstance = function(instEntity) {
			return $http.post('refreshOraInstanceStatus.do', instEntity);
		};

		this.discoverHanaDatabases = function(instanceId) {
			return $http.get('discoverHanaDatabases.do?instnaceId=' + instanceId);
		};
		this.submitRestoreJob = function(params) {
			return $http.post('restoreForEntity.do', params);
		};

		this.submitCloneJob = function(params) {
			return $http.post('submitCloneJob.do', params);
		};

		this.getRestoreDestinations = function(clientId, applicationId, instanceName, instanceId, flags = 0) {
			var urlString = 'getRestoreDestinations.do?clientId=' + clientId;
			if (applicationId) {
				urlString = urlString + '&applicationId=' + applicationId;
			}

			if (instanceName) {
				urlString = urlString + '&instanceName=' + instanceName;
			}

			if (instanceId) {
				urlString = urlString + '&instanceId=' + instanceId;
			}

			if (flags) {
				urlString = urlString + '&flag=' + flags;
			}

			return $http.get(urlString);
		};

		this.getRestoreDestinationsForEntity = function(entity) {
			return $http({
				method: 'GET',
				url: 'getRestoreDestinationsForEntity.do',
				params: {
					entity: entity
				}
			});
		};

		this.getClientDetails = function(clientId) {
			return $http.get('clientDetails.do?clientId=' + clientId);
		};
		this.getClientProps = function(clientId) {
			return $http({
				method: 'GET',
				url: 'clientProps.do',
				params: {
					clientId: parseInt(clientId)
				}
			});
		};

		this.getSQLDiscoveredDatabases = function(clientId, instanceId) {
			return $http.get('getSQLUnconfiguredDatabases.do?clientId=' + clientId + '&instanceId=' + instanceId);
		};

		this.getSnapDatabases = function(entity, options, successcallBack, errorCallBack) {
			return $http
				.post('getSnapDatabases.do', {
					entity: angular.toJson(entity),
					options: angular.toJson(options)
				})
				.success(function(data, status, headers, config) {
					if (angular.isDefined(successcallBack)) {
						successcallBack(data);
					} else {
						return data;
					}
				})
				.error(function(error) {
					if (angular.isDefined(errorCallBack)) {
						errorCallBack(error);
					} else {
						return error;
					}
				});
		};

		this.backup = function(entityType, genericEntityJSON, backupType, backupOption) {
			return $http.post('backupEntity.do', {
				entityType: entityType,
				genericEntityJSON: genericEntityJSON,
				backupLevel: backupType,
				backupOption: backupOption
			});
		};

		this.backupSubclient = function(entityType, genericEntity, backupOption) {
			return $http.post('backupSubclient.do', {
				entityType: entityType,
				genericEntity: genericEntity,
				backupOption: backupOption
			});
		};

		this.backupSQLMultiDB = function(backupReq) {
			return $http.post(`proxy/v2/sql/backup`, JSON.stringify(backupReq), httpHeader['jsonDefaultHeader']);
		};

		this.getInstanceDetails = function(instanceId) {
			return $http.get('instanceDetails.do?instanceId=' + instanceId);
		};

		this.getBackupSetDetails = function(backupSetId) {
			return $http.get('backupSetDetails.do?backupsetId=' + backupSetId);
		};

		this.getOracleDatafilesList = function(instanceId, optionId) {
			let url = `getOracleDatafilesList.do?instanceId=${instanceId}`;
			if (optionId) {
				url = `${url}&optionId=${optionId}`;
			}
			return $http.get(url);
		};

		this.getDB2DatafilesList = function(entityId, entityName) {
			let urlString = 'getDB2DatafilesList.do?entityId=' + entityId;
			if (entityName) {
				urlString = urlString + '&entityName=' + entityName;
			}
			return $http.get(urlString);
		};

		this.getDb2StorageGroups = function(backupsetId) {
			return $http.get('getDB2StorageGroups.do?backupsetId=' + backupsetId);
		};

		this.getDbContentList = function(entity) {
			return $http.post('getDbContentList.do', {
				entity: entity
			});
		};

		this.getPgContentList = function(entity) {
			return $http.post('getPgContentList.do', {
				entity: entity
			});
		};

		this.getInstances = function(clientId, applicationId) {
			return $http.get('instances.do?clientId=' + clientId + '&applicationId=' + applicationId);
		};

		this.getDBEntity = function(instanceId) {
			return $http.get('dbInstance.do?instanceId=' + instanceId);
		};

		this.getMysqlBrowseData = function(entityId, entityType, entity, options, httpParams) {
			httpParams = angular.isObject(httpParams) ? httpParams : {};
			var deffered = $q.defer();
			var browseCache = new Object(); //$cacheFactory('browseCache' + Math.random());//to avoid CacheId '{0}' is already taken issue!
			var cacheObj = browseCache;
			/*
			 * caching the object to reduce the extra server calls, if navigable tree(expand/collapse) and/or
			 * navigable table(folder) present in browse page
			 */
			if (!service.sessionId) {
				cacheObj = false;
			}

			var params = {
				entityId: entityId,
				entityType: entityType,
				entity: angular.toJson(entity),
				options: angular.toJson(options)
			};

			$log.log('Calling browse request.');
			var httpSendParams = angular.extend(httpParams, {
				method: 'GET',
				url: 'newIdaBrowse.do',
				params: params,
				cache: cacheObj
			});

			return $http(httpSendParams);
		};

		/**
		 * Some IDAs might need to transform the browse response in this layer such as create object from
		 * JSON.
		 */
		this.transformBrowseResponse = function(data, entityId, entityType, options, httpParams) {
			if (
				Number.parseInt(options.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value &&
				!_.isUndefined(data.browseData)
			) {
				data.browseData.forEach(item => {
					const descJson = _.get(item, 'userObject.advancedData.browseMetaData.dynamoDBMetadata.description');
					if (descJson) {
						item.description = angular.fromJson(descJson);
					}
				});
			} else if (
				Number.parseInt(options.cloudAppType) ===
					CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value &&
				!_.isUndefined(data.browseData)
			) {
				data.browseData.forEach(item => {
					const descJson = _.get(item, 'userObject.advancedData.browseMetaData.cosmosDBMetadata.description');
					if (descJson) {
						item.description = angular.fromJson(descJson);
						item.description.sizeInBytes = _.get(item, 'description.sizeInKB', 0) * 1024;
					}
				});
			}
		};

		this.getIdaBrowseData = function(entityId, entityType, options, httpParams) {
			if (
				options.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value &&
				options.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE
			) {
				return cappsClientService.getSFRecordBrowseData(entityId, entityType, options, httpParams);
			} else if (
				options.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.value ||
				options.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.value ||
				options.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.value
			) {
				return cappsClientService.getRDSBrowseData(entityId, entityType, options);
			} else if (
				options.applicationId == AppTypes.SAP_FOR_ORACLE &&
				options.path.replace(/[\/|\\]/g, '') === '+BROWSE+'
			) {
				//SAP for Oralce has dummy nodes Data and Log under root.
				const deffered = $q.defer();
				const ret = {
					browseData: [
						{
							id: 'Tablespace',
							label: 'Data',
							leafNode: false,
							userObject: {
								path: '/'
							}
						},
						{
							id: 'Logs',
							label: 'Logs',
							leafNode: false,
							userObject: {
								path: '/'
							}
						}
					]
				};
				ret.browseData.totalItems = ret.browseData.length;
				deffered.resolve(ret);
				return deffered.promise;
			}
			httpParams = angular.isObject(httpParams) ? httpParams : {};
			var deffered = $q.defer();
			//var browseCache = new Object(); //$cacheFactory('browseCache' + Math.random());//to avoid CacheId '{0}' is already taken issue!
			var cacheObj = browseCache;
			/*
			 * caching the object to reduce the extra server calls, if navigable tree(expand/collapse) and/or
			 * navigable table(folder) present in browse page
			 */
			if (!service.sessionId) {
				cacheObj = false;
			}

			options.sessionId = service.sessionId;
			if (Number.parseInt(options.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value) {
				let [pageNumber = 0] = _.get(options, 'pagingInfo', '')
					.split(',')
					.map(num => parseInt(num));

				if (sessionIdRegex.test(options.sessionId)) {
					[options.sessionId] = sessionIdRegex.exec(options.sessionId);
				}
				if (!_.isEqual(service.subclientId, options.subclientId)) delete options.sessionId;
				if (pageNumber === 0) delete options.sessionId;
			}

			service.isFindSession = false;
			var isHadoopOrClusterTypeClient =
				AppTypesUtil.isClusterTypeFileSystem(options.applicationId, options.clusterType) ||
				options.clusterType === distributedClusterType.HADOOP;

			if (isHadoopOrClusterTypeClient) {
				service.isFindSession = !!options.keywords;
				if (service.isFindSession) {
					// Clear sessionId if its a find query, so that next browse action requests for a new sessionId
					options.sessionId = '';
					this.clearSessionId();
				}
			}

			//Reset session id for Exchange and SharePoint
			if (
				!_.isUndefined(options.applicationId) &&
				(options.applicationId === AppTypes.EXCHANGE_MAILBOX || options.applicationId === AppTypes.SHAREPOINT_SERVER)
			) {
				options.sessionId = '';
			}

			var params = {
				entityId: entityId,
				entityType: entityType,
				options: angular.toJson(options)
			};

			$log.log('Calling browse request.');
			var httpSendParams = angular.extend(httpParams, {
				method: 'GET',
				url: 'idaBrowse.do',
				params: params,
				cache: cacheObj
			});

			$http(httpSendParams)
				.success(function(data) {
					service.transformBrowseResponse(data, entityId, entityType, options, httpParams);
					if (angular.isObject(data) && data.isPredictionData === true) {
						$log.log('predictionData received, so setting the restoreIndex option as true');
						//display a toaster
						cvToaster.showInfoMessage({
							ttl: '5000', //5 sec
							message: cvLoc('index.restore.message')
						});
						//set the option
						var newOptions = angular.copy(options);
						newOptions.restoreIndex = true;
						httpSendParams.params.options = angular.toJson(newOptions);

						$http(httpSendParams).then(
							function(response) {
								$log.log('Success in calling browse request after dataPrediction');
								if (
									response.data.browseData &&
									response.data.browseData.length > 0 &&
									response.data.browseData[0].sessionId &&
									options.applicationId &&
									(AppTypesUtil.isWindowsFileSystem(options.applicationId) ||
										AppTypesUtil.isUnixFileSystem(options.applicationId) ||
										AppTypesUtil.isNASAgent(options.applicationId) ||
										Number.parseInt(options.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value)
								) {
									service.sessionId = response.data.browseData[0].sessionId;
									service.subclientId = _.get(options, 'subclientId', '');
								}
								deffered.resolve(response.data);
							},
							function(response) {
								deffered.reject(response.e);
							}
						);
					} else {
						$log.log('Success in calling browse request');
						if (
							data.browseData &&
							data.browseData.length > 0 &&
							data.browseData[0].sessionId &&
							options.applicationId &&
							(AppTypesUtil.isWindowsFileSystem(options.applicationId) ||
								AppTypesUtil.isUnixFileSystem(options.applicationId) ||
								AppTypesUtil.isNASAgent(options.applicationId) ||
								AppTypesUtil.isClusterTypeFileSystem(options.applicationId, options.clusterType) ||
								Number.parseInt(options.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value)
						) {
							service.sessionId = data.browseData[0].sessionId;
							service.subclientId = _.get(options, 'subclientId', '');

							if (isHadoopOrClusterTypeClient && service.isFindSession) {
								// If its a find query, do not use sessionId from response
								service.clearSessionId();
							}
						}
						deffered.resolve(data);
					}
				})
				.error(function(ex) {
					deffered.reject(ex);
				});

			return deffered.promise;
		};

		this.getIdaBrowseLogData = function(entityId, entityType, options, httpParams) {
			httpParams = angular.isObject(httpParams) ? httpParams : {};
			var deffered = $q.defer();

			var params = {
				entityId: entityId,
				entityType: entityType,
				options: angular.toJson(options)
			};

			$log.log('Calling browse request.');
			var httpSendParams = angular.extend(httpParams, {
				method: 'GET',
				url: 'idaLogBrowse.do',
				params: params
			});

			$http(httpSendParams)
				.success(function(data) {
					deffered.resolve(data);
				})
				.error(function(ex) {
					deffered.reject(ex);
				});

			return deffered.promise;
		};

		this.clearSessionId = function() {
			this.sessionId = '';
			browseCache.removeAll();
			selectionService.clearSelection();
		};

		this.setAgentDiscoverFlag = function(clientId, appId, discoverFlag) {
			return $http.post('setAgentDiscoverFlag.do', {
				clientId: clientId,
				appId: appId,
				discoverFlag: discoverFlag
			});
		};

		this.discoverInstances = function(entity) {
			return $http.post('discoverInstances.do', entity);
		};

		this.discoverMySqlInstances = function(clientId) {
			return $http.post('discoverMySqlInstances.do', {
				clientId: clientId
			});
		};

		this.getPermissions = function(entityType, entityId) {
			return $http.get(
				`${appUtil.appRoot}/api/Security/${entityType}/${entityId}/Permissions`,
				httpHeader['jsonDefaultHeader']
			);
		};

		this.getVMPSeudoClients = function() {
			return $http.get(appUtil.appRoot + 'api/Client/VMPseudoClient');
		};

		this.getDB2Partitions = function(clientId, db2Home) {
			return $http.get(appUtil.appRoot + 'api/Instance/DB2Partitions?clientId=' + clientId + '&db2Home=' + db2Home);
		};

		this.getDBEngineRDSInstances = function(clientId, appTypeId, cloudDBEngineType) {
			return $http.get(
				appUtil.appRoot +
					'api/Instance/RDSDiscover/0?clientId=' +
					clientId +
					'&appType=' +
					appTypeId +
					'&cloudDBEngineType=' +
					cloudDBEngineType
			);
		};

		this.getRDSInstances = function(clientId, appTypeId) {
			return $http.get(appUtil.appRoot + 'api/Instance/RDSDiscover/0?clientId=' + clientId + '&appType=' + appTypeId);
		};

		this.getPostgreSQLInstances = function() {
			return $http.get(appUtil.appRoot + 'api/postgreSql/instances');
		};

		this.getSybaseRedirectData = function(params) {
			return $http.post('getSybaseRedirectData.do', params);
		};

		this.getSybaseServerStatus = function(params) {
			return $http.post('getSybaseServerStatus.do', params);
		};

		this.getSybaseChains = function(params) {
			return $http.post('getSybaseChains.do', params);
		};

		this.createSubclientWithPlanPolicyModel = function(
			subclientInfo,
			usePlan,
			planPolicyModel,
			successCallBack,
			errorCallBack
		) {
			if (usePlan) {
				subclientInfo.planEntity = {
					planId: planPolicyModel.plan.selected.id
				};
			} else {
				_.set(
					subclientInfo,
					'commonProperties.storageDevice.dataBackupStoragePolicy',
					planPolicyModel.storagePolicy.selected.obj
				);
			}

			var params = {
				subClientEntity: angular.toJson(subclientInfo.subClientEntity),
				content: '',
				subclientInfo: angular.toJson(subclientInfo)
			};
			this.createSubclient(params)
				.success(function(data) {
					if (!usePlan) {
						const entity = {
							appId: subclientInfo.subClientEntity.applicationId,
							clientId: subclientInfo.subClientEntity.clientId,
							subclientId: subclientInfo.subClientEntity.subclientId
						};
						const schedules = planPolicyModel.schedulePolicy;
						if (schedules && schedules.selected) {
							associateSchedulePolicy
								.associateSchedulePolicyToSubClient(entity, schedules.selected)
								.success(function(data) {
									successCallBack(data);
								})
								.error(function(error) {
									errorCallBack(error);
								});
						}
					} else {
						successCallBack(data);
					}
				})
				.error(function(error) {
					errorCallBack(error);
				});
		};

		this.createInstanceAndUpdateSubclient = function(params) {
			return $http.post('createInstanceAndUpdateSubclient.do', params);
		};

		this.getSnapshotProxyList = function(clientId, apptypeId) {
			return $http.get(`snapshotProxyList.do?clientId=${clientId}&apptypeId=${apptypeId}`);
		};
	}
]);

export default app;
