import 'adminConsole/js/services/browseForAgents.svc.js';
import 'browse/js/services/browse.svc.js';

(function() {
	'use strict';

	var browseMod = angular.module('common.allAgents');
	browseMod.pageSize = 25;
	browseMod.pageSizes = [10, 25, 50, 75];
	browseMod.service('browseForAgentsBrowseService', [
		'$http',
		'$q',
		'$rootScope',
		'$log',
		'$stateParams',
		'selectionService',
		'$cacheFactory',
		function($http, $q, $rootScope, $log, $stateParams, selectionService, $cacheFactory) {
			this.sessionId = '';
			this.entity = {};
			this.fromTime = -1;
			this.toTime = -1;
			this.showDeletedItems = false;
			var browseCache = $cacheFactory('browseCache' + Math.random()); //to avoid CacheId '{0}' is already taken issue!
			this.sortOption = {
				fields: ['displayName'],
				directions: ['ASC']
			};

			const service = this;

			this.getBrowseData = function(browseType, path, instanceId, subclientId, currentPage, sortField) {
				var deffered = $q.defer();
				var cacheObj = browseCache;
				/*
				 * caching the object to reduce the extra server calls, if navigable
				 * tree(expand/collapse) and/or navigable table(folder) present in browse
				 * page
				 */
				if (!service.sessionId) {
					cacheObj = false;
				}

				var browseType = 'oracleBrowse';

				switch (browseType) {
					case 'oracleBrowse':
						$log.log('Calling oracleBrowse handler.');
						if (path == null || path === undefined || path === 'undefined') {
							path = '\\';
						}
						$http({
							method: 'GET',
							url: 'oracleBrowse.do',
							params: {
								nodeId: instanceId,
								path: path,
								browseType: browseType,
								pointInTime: $stateParams['toTime']
							},
							cache: cacheObj
						})
							.success(function(data) {
								$log.log('Success in calling oracleBrowse');
								deffered.resolve(data);
							})
							.error(function(ex) {
								deffered.reject(ex);
							});
						break;
					case 'sqlDbBrowse':
						$log.log('Calling sqlDBBrowse handler.');

						$http({
							method: 'GET',
							url: 'sqlDbBrowse.do',
							params: {
								instanceId: instanceId,
								browseType: browseType,
								toTime: $stateParams['toTime'],
								fromTime: $stateParams['fromTime'],
								jobId: $stateParams['jobId']
							}
							//Here there is no navigation. Hence not caching the server call.
						})
							.success(function(data) {
								$log.log('Success in calling sqldbBrowse');
								deffered.resolve(data);
							})
							.error(function(errorMessage) {
								deffered.reject(errorMessage);
							});
						break;

					case 'fsFileBrowse':
						$http({
							method: 'GET',
							url: 'browseVsa.do?browseType=' + browseType + '&subclientId=' + subclientId,
							params: {
								sessionId: service.sessionId,
								path: path,
								page: currentPage - 1,
								limit: $stateParams['limit'] ? parseInt($stateParams['limit']) : browseMod.pageSize,
								showDeletedFiles: _.toLower($stateParams['showDeletedItems']) === 'true',
								fromTime: $stateParams['fromTime'],
								toTime: $stateParams['toTime'],
								mode: 3
								/*
								 * 'sortField' : service.sortOption.fields[0], 'sortDir' :
								 * service.sortOption.directions[0]
								 */
							},
							cache: cacheObj
						})
							.success(function(data) {
								service.sessionId =
									data &&
									data.browseResults &&
									data.browseResults.browseResponses &&
									data.browseResults.browseResponses.length > 0
										? data.browseResults.browseResponses[0].session.sessionId
										: '';
								deffered.resolve(data);
							})
							.error(function(e) {
								deffered.reject(e);
							});
						break;
				}

				return deffered.promise;
			};

			this.clearSessionId = function() {
				this.sessionId = '';
				selectionService.clearSelection();
				browseCache.removeAll();
				selectionService.destory();
			};

			this.getEntity = function(scId) {
				return $http({
					method: 'GET',
					url: 'entity.do?subclientId=' + scId,
					params: {},
					cache: true
				});
			};

			/* breadcrumbs related functions can be further separated out of service */
			this.createBreadCrumbItems = function(actualPath, displayPath, vmname, subclientName, rootPath) {
				if (rootPath == null || rootPath === undefined || rootPath === 'undefined') {
					rootPath = '\\';
				}
				var paths = actualPath.split(rootPath);
				var displayPaths = displayPath.split(rootPath);
				var breadCrumbs = [];
				var currentPath = '';
				breadCrumbs.push({
					path: rootPath,
					display: subclientName,
					vmname: null
				});
				for (var i = 1; i < paths.length; i++) {
					//first one is \ i.e. root level, so skip that
					var pathItem = paths[i];
					if (!pathItem) {
						continue;
					}
					var displayName = displayPaths[i];
					if (currentPath == rootPath) {
						currentPath += pathItem;
					} else {
						currentPath = currentPath + rootPath + pathItem;
					}
					if (i == 1 && vmname) {
						displayName = vmname;
					}
					breadCrumbs.push({
						path: currentPath,
						display: displayName,
						vmname: vmname
					});
				}
				return breadCrumbs;
			};

			this.setSortOption = function(sortOption) {
				this.sortOption = sortOption;
			};

			this.getDisplayPath = function(path, vmname) {
				return path.replace(/[^\\]+/, vmname);
			};

			this.getRestoreDestinations = function(clientId, applicationId) {
				return $http({
					method: 'GET',
					url: 'getRestoreDestinations.do',
					params: {
						clientId: clientId,
						applicationId: applicationId
					}
				});
			};
		}
	]);

	browseMod.service('selectionService', [
		'$q',
		'$rootScope',
		'$log',
		'$stateParams',
		function($q, $rootScope, $log, $stateParams) {
			var selectionService = this;
			this.selectionArray = [];
			this.applicationId;
			//			this.deffered = $q.defer();
			this.clearSelection = function() {
				while (this.selectionArray.length > 0) {
					this.selectionArray.pop().selected = false;
				}
			};
			this.pushSelection = function(entity) {
				if (this.selectionArray.indexOf(entity) == -1) {
					this.selectionArray.push(entity);
				}
				entity.selected = true;
				//				this.deffered.notify();
			};
			this.removeSelection = function(entity) {
				var index = this.selectionArray.indexOf(entity);
				if (index != -1) {
					this.selectionArray.splice(index, 1);
				}
				entity.selected = false;
				//				this.deffered.notify();
			};
			this.getBoundEntityIfSelected = function(entity) {
				for (var i = 0; i < this.selectionArray.length; i++) {
					var e = this.selectionArray[i];
					if (e.path == entity.path) {
						return e;
					}
				}
				return entity;
			};
			//			this.getSelectionChangePromise = function() {
			//				this.thenCalled = true;
			//				return this.deffered.promise;
			//			};
			this.destory = function() {
				//				this.thenCalled = false;
				//				this.deffered.resolve(''); //important to remove notify listeners to avoid potential memory leak
			};
		}
	]);

	browseMod.value('browseParams', {
		//can be used as a placeholder to pass around browse params to restore dialog e.g.
	});
})();
