import { disasterRecoveryModule } from 'common/js/modules';

const ibmiDRWorkFlowName = 'IBM i DR Data Restore';

// Abstract Base Class
class DisasterRecoveryService {
	constructor($http) {
		this.$http = $http;
	}

	startDisasterRecovery() {
		throw new TypeError('Not Implemented');
	}
}

export class IBMIDisasterRecoveryService extends DisasterRecoveryService {
	constructor($http) {
		super($http);
		// pre-defined inputs
		this.workFlowInputs = {
			sDFRID: '*DFT',
			sOBJCNV: '*YES *ALL',
			bALWOBJDIF_PGP: 'true',
			TimeoutForQSECRestore: '300',
			bALWOBJDIF_OWNER: 'true',
			sOUTTYPE: '*OBJ',
			bALWOBJDIF_AUTL: 'true',
			retryAttempts: '3',
			sJOBLOGMemberName: '',
			sALWJOBDIF: '*ALL',
			bALWOBJDIF_FILELVL: 'true',
			sMEMBEROpt: '*REPLACE',
			sJOBLOG: '*NONE',
			delay: '5',
			bPVTAUT: 'false'
		};
	}

	set sourceClient({ clientId, clientName }) {
		this.workFlowInputs.sourceClient = { clientId, clientName };
	}

	set destinationClient({ clientId, clientName }) {
		this.workFlowInputs.oDestinationClient = { clientId, clientName };
	}

	set dvdTargetClient({ clientId, clientName }) {
		this.workFlowInputs.oDVDTargetClient = { clientId, clientName };
	}

	set backupSetName(backupsetName) {
		this.workFlowInputs.backupSetName = backupsetName;
	}

	set oneTouchBackupJob(jobId) {
		this.workFlowInputs.lDRJobId = jobId;
	}

	set dvdImagePath(path) {
		this.workFlowInputs.sDVDImageRestorePath = path;
	}

	set copyPrecedence(copyPrecedence) {
		this.workFlowInputs.nCopyPrecedence = copyPrecedence;
	}

	set logOutput(logPath) {
		this.workFlowInputs.sJOBLOGFileName = logPath;
		this.workFlowInputs.sJOBLOG = '*OUTFILE';
	}

	set splfdta(splfdtaValue) {
		this.workFlowInputs.bSPLFDTA = splfdtaValue;
	}

	_convertJSON2XML(obj) {
		return _.reduce(
			obj,
			(acc, val, key) => {
				const inner = _.isObject(val) ? this._convertJSON2XML(val) : val;
				return acc + `<${key}>${inner}</${key}>`;
			},
			''
		);
	}

	startDisasterRecovery() {
		let inputsString = this._convertJSON2XML({ inputs: this.workFlowInputs });

		return this.$http.post(`${cv.contextPath}/api/wapi/${ibmiDRWorkFlowName}`, inputsString, {
			headers: { 'Content-Type': 'application/xml', Accept: 'application/json' }
		});
	}
}

IBMIDisasterRecoveryService.$inject = ['$http'];
disasterRecoveryModule.service('ibmiDisasterRecoveryService', IBMIDisasterRecoveryService);

export default disasterRecoveryModule;
