import { commonAppMigrationModule } from 'common/js/modules';

var app = commonAppMigrationModule;
app.service('appMigrationService', [
	'$http',
	'$q',
	'$log',
	function($http, $q, $log) {
		this.getPolicies = function(params) {
			return $http.post('getPolicies.do', params);
		};

		this.getVms = function(params) {
			return $http.post('getVms.do', params);
		};

		this.getPolicyDetails = function(params) {
			return $http.post('getPolicyDetails.do', params);
		};

		this.getStorageDetails = function(params) {
			return $http.post('getStorageDetails.do', params);
		};

		this.runAppMigration = function(params) {
			return $http.post('runAppMiagration.do', params);
		};

		this.getInstancefromClientName = function(clientName, applicationId) {
			return $http.get(cv.contextPath + `/api/Instance?clientName=${clientName}&applicationId=${applicationId}`);
		};
	}
]);

export default app;
