import 'modules/genApp/js/directives/cv-compute-node.js';

import { commonAllAgentsModule } from 'common/js/modules';

var allAgentMod = commonAllAgentsModule;
allAgentMod.directive('cvStorageConfig', function() {
	function link($scope) {}
	return {
		restrict: 'E', //E = element
		templateUrl: appUtil.appRoot + 'modules/ida/partials/storageConfigTemplate.jsp',
		scope: {},
		bindToController: {
			sorageModel: '=',
			configType: '=',
			forAccordion: '='
		},
		controller: [
			'cvToaster',
			'$log',
			'$dialogs',
			'$state',
			'cvLoc',
			'cvUtil',
			'cvTableOptions',
			function(cvToaster, $log, $dialogs, $state, cvLoc, cvUtil, cvTableOptions) {
				var self = this;
				this.$onInit = function() {
					var storageList = [];
					if (!self.sorageModel) {
						self.sorageModel = [];
					}
					var isOracleCloud = false;
					if (
						self.configType &&
						(self.configType === 'ORACLE_CLOUD' || self.configType === 'ORACLE_CLOUD_INFRASTRUCTURE')
					) {
						isOracleCloud = true;
					}

					self.storageDetails = storageList;

					self.addVolume = function(volumeObj) {
						var templateUrl = 'modules/ida/partials/appMigrationAddStorage.jsp';
						var controller = [
							'$scope',
							'cvUtil',
							'$rootScope',
							'data',
							'$uibModalInstance',
							'$filter',
							function($scope, cvUtil, $rootScope, data, $modalInstance, $filter) {
								$scope.isEditing = data.isEditing;
								$scope.isOracleCloud =
									data.cloudType === 'ORACLE_CLOUD' || data.cloudType === 'ORACLE_CLOUD_INFRASTRUCTURE';
								$scope.isAzureCloud = data.cloudType === 'AZURE_RESOURCE_MANAGER';
								if (!data.storage) {
									$scope.storage = {
										mntPoint: {
											mountPathName: ''
										},
										volumeSize: 10,
										amazonVolConfig: {
											volumeType: 0,
											iopsLimit: 100
										}
									};
								} else {
									$scope.storage = angular.copy(data.storage);
									$scope.storage.volumeSize = $filter('volumeSize')($scope.storage.volumeSize);
								}
								$scope.volumeTypes = [
									{
										name: cvLoc('label.standard'),
										volumeId: 0
									},
									{
										name: cvLoc('label.provsIOPS'),
										volumeId: 1
									}
								];

								$scope.closeModal = function() {
									$modalInstance.close(null);
								};
								$scope.saveModle = function() {
									$scope.storage.volumeSize = $scope.storage.volumeSize * 1024 * 1024 * 1024;
									$modalInstance.close($scope.storage);
								};
							}
						];
						var opts = new Object();
						var dataMode = {
							storage: volumeObj,
							isEditing: volumeObj ? true : false,
							cloudType: self.configType
						};
						var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataMode, opts);
						modelInsta.result.then(function(dataObject) {
							if (dataObject) {
								//In Edit case volumeObj will not be null, so remove it and add new one.
								if (volumeObj) {
									self.deleteVolume(volumeObj);
								}
								self.sorageModel.push(dataObject);
							}
						});
					};

					var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
					var columnDefs = [];
					columnDefs.push({
						field: 'mntPoint',
						displayName: cvLoc('label.mountPoints'),
						cellTemplate: '<span class="crop" >{{row.entity.mntPoint.mountPathName}}</span>',
						enableHiding: false,
						cellTooltip: true,
						width: '20%'
					});
					columnDefs.push({
						field: 'volumeSize',
						displayName: cvLoc('label.sizeGB'),
						cellTemplate: '<span class="crop">{{row.entity.volumeSize | volumeSize}}</span>',
						width: '16%'
					});

					var columnSize = '48%';
					if (!isOracleCloud) {
						columnSize = '20%';
						columnDefs.push({
							field: 'clientName',
							displayName: cvLoc('label.volumeType'),
							cellTemplate: '<span class="crop" >{{row.entity.amazonVolConfig.volumeType | volumeType}}</span>',
							width: '16%'
						});
						columnDefs.push({
							field: 'amazonVolConfig.iopsLimit',
							displayName: cvLoc('label.iopsLimit'),
							cellTemplate: '<span class="crop" >{{row.entity.amazonVolConfig.iopsLimit}}</span>',
							width: '15%'
						});
					}
					columnDefs.push({
						field: 'volumeTag',
						displayName: cvLoc('label.description'),
						cellTemplate: '<span title="{{row.entity.volumeTag}}" class="crop" >{{row.entity.volumeTag}}</span>',
						width: columnSize
					});

					columnDefs.push({
						field: 'edit',
						displayName: '',
						cellTemplate:
							'<span title="Edit volume"  class="edit-volume" data-ng-click="grid.appScope.editVolume(row.entity)" >&nbsp;</span>',
						width: '5%'
					});
					columnDefs.push({
						field: 'delete',
						displayName: '',
						cellTemplate:
							'<span title="Delete volume"  class="delete-row" data-ng-click="grid.appScope.deleteVolume(row.entity)" > × </span>',
						width: '5%'
					});

					angular.extend(globalGridOptions, {
						data: self.sorageModel,
						enableGridMenu: false,
						paginationPageSize: 5,
						paginationPageSizes: [5, 10, 20, 50],
						columnDefs: columnDefs
					});

					self.gridOptions = {
						cvIsPageTitle: false,
						cvHasTitle: self.forAccordion ? false : true,
						cvGridTitle: cvLoc('label.storageConfg'),
						cvPageLinks: self.forAccordion
							? []
							: [
									{
										label: cvLoc('label.addStorage'),
										id: 'tour_add_server',
										onclick: self.addVolume
									}
							  ],
						cvOnGridEmpty: {
							message: cvLoc('label.noStorageAvail')
						},
						cvHasViews: false,
						cvIsSearchable: false,
						cvTableName: 'addStorgeDivice',
						cvAppScope: self,
						gridOptions: globalGridOptions
					};

					self.deleteVolume = function(volumeObj) {
						var volumeName = volumeObj.mntPoint.mountPathName;
						for (var i = 0; i < self.sorageModel.length; i++) {
							if (self.sorageModel[i].mntPoint.mountPathName == volumeName) {
								self.sorageModel.splice(i, 1);
								return;
							}
						}
					};

					self.editVolume = function(volumeObj) {
						self.addVolume(volumeObj);
					};

					self.addStorage = function() {
						self.addVolume(null);
					};
				};
			}
		],
		controllerAs: 'storageConfigCtrl',
		link: link
	};
});

export default allAgentMod;
