import 'dbs/js/services/server.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/ida/js/services/sqlService.svc.js';

import { acAppDirectivesModule } from 'common/js/modules';
var acAppDirectives = acAppDirectivesModule;
acAppDirectives.directive('cvSqlSubclientSettings', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'adminConsole/partials/sqlSubclientSetting.jsp',
			scope: {
				genericEntity: '=',
				mssqlSubclientProp: '='
			},
			link: function(scope, ele, attr, ctrl) {
				scope.$watch('mssqlSubclientProp.useBlockLevelBackupWithOptimizedRecovery', function(newVal) {
					scope.option.blockLevelStatus = newVal === true ? 'enabled-activity' : 'disabled-activity';
				});

				scope.$watch('mssqlSubclientProp.blockLevelBackup', function(newVal) {
					scope.option.volumeLevelStatus = newVal === 1 ? 'enabled-activity' : 'disabled-activity';
				});

				scope.$watch('mssqlSubclientProp.isRebootNowPermitted', function(newVal) {
					scope.option.installBlockFilterWhen = newVal === 'REBOOT_NOW' ? 1 : 2; //RebootMachineOnQsnapInstallation
				});
			},
			controller: [
				'$scope',
				'$log',
				'cvToaster',
				'cvLoc',
				'cvUtil',
				'dbServerService',
				'idaService',
				'$uibModal',
				'sqlService',
				function($scope, $log, cvToaster, cvLoc, cvUtil, dbServerService, idaService, $modal, sqlService) {
					$scope.option = {};
					$scope.option.showInstallBlockFilterDriver = false;

					var getClientDetails = function() {
						return idaService.getClientDetails($scope.genericEntity.clientId).then(function(data) {
							$scope.clientDetails = data.data;

							if ($scope.clientDetails && $scope.clientDetails.clientProps) {
								var isQsnapInstalled = $scope.clientDetails.clientProps.isQsnapInstalled;

								$scope.blockFilterDriverNotInstalled = isQsnapInstalled === 0 || isQsnapInstalled === 3; //"BLK_FILTER_FOREVER_FULL" refer WinBlockFilterDriverStatus
							}
						});
					};

					//block/volume level options are only applicable to database subclient of database instance on windows client.
					var getInstanceDetails = function() {
						return sqlService.getSQLClientInfo($scope.genericEntity.instanceId).success(function(data) {
							$scope.instanceDetails = data;
						});
					};

					var getSubclientDetails = function() {
						return idaService.getSubClientDetails($scope.genericEntity.subclientId).success(function(data) {
							$scope.subclientDetails = data;
						});
					};

					if (cvConfig.showSqlVolumeLevelOption) {
						$scope.showSqlVolumeLevelOption = true;
						getClientDetails();
					}

					getInstanceDetails()
						.then(function() {
							return getSubclientDetails();
						})
						.then(function() {
							if (
								$scope.instanceDetails &&
								$scope.instanceDetails.osType === 'Windows' &&
								$scope.instanceDetails.SqlInstance &&
								$scope.instanceDetails.SqlInstance[0] &&
								$scope.instanceDetails.SqlInstance[0].sType === 'DataBase Engine' &&
								$scope.subclientDetails &&
								$scope.subclientDetails.mssqlSubClientProp &&
								$scope.subclientDetails.mssqlSubClientProp.sqlSubclientType === 'DATABASE'
							) {
								$scope.showSqlBlockLevelOption = true;

								$scope.option.showInstallBlockFilterDriver =
									cvConfig.showSqlVolumeLevelOption &&
									$scope.blockFilterDriverNotInstalled &&
									$scope.mssqlSubclientProp.blockLevelBackup === 1;
							}
						})
						.catch(function(errorMessage) {
							$scope.serverMessage = cvUtil.errMsg(errorMessage);
							$log.error(error);
						});

					$scope.manageActivityForBlockLevel = function() {
						$scope.option.type = 'blockLevelBackup';
						manageActivityForSubclient();
					};

					$scope.manageActivityForVolumeLevel = function() {
						$scope.option.type = 'volumeLevelBackup';
						manageActivityForSubclient();
					};

					$scope.manageActivityForRebootWhen = function(value) {
						$scope.option.installBlockFilterWhen = value;
						$scope.option.type = 'setInstallWhen';
						manageActivityForSubclient();
					};

					var manageActivityForSubclient = function() {
						var mssqlSubclientProp = angular.copy($scope.mssqlSubclientProp);

						if ($scope.option.type === 'blockLevelBackup') {
							mssqlSubclientProp.useBlockLevelBackupWithOptimizedRecovery =
								$scope.option.blockLevelStatus === 'enabled-activity' ? false : true;
							cvToaster.showWarnMessage({
								ttl: '5000', //5 sec
								message: cvLoc('info.block.level.backup')
							});
						}

						if ($scope.option.type === 'volumeLevelBackup') {
							mssqlSubclientProp.blockLevelBackup = $scope.option.volumeLevelStatus === 'enabled-activity' ? 0 : 1;
							if (mssqlSubclientProp.blockLevelBackup === 1) {
								mssqlSubclientProp.isRebootNowPermitted = 2;
							}
							cvToaster.showWarnMessage({
								ttl: '5000', //5 sec
								message: cvLoc('info.volume.level.backup')
							});
						}

						if ($scope.option.type === 'setInstallWhen') {
							mssqlSubclientProp.isRebootNowPermitted = $scope.option.installBlockFilterWhen;
						}

						sqlService
							.updateSqlSCProps({
								genericEntity: angular.copy($scope.genericEntity),
								mssqlSubclientProp: mssqlSubclientProp
							})
							.success(function(data) {
								if (data) {
									if ($scope.option.type === 'blockLevelBackup') {
										$scope.mssqlSubclientProp.useBlockLevelBackupWithOptimizedRecovery =
											mssqlSubclientProp.useBlockLevelBackupWithOptimizedRecovery;
									}

									if ($scope.option.type === 'volumeLevelBackup') {
										$scope.mssqlSubclientProp.blockLevelBackup = mssqlSubclientProp.blockLevelBackup;

										//when enable volume level, set reboot later as default
										$scope.mssqlSubclientProp.isRebootNowPermitted = 'REBOOT_LATER';

										$scope.option.showInstallBlockFilterDriver =
											$scope.blockFilterDriverNotInstalled && $scope.mssqlSubclientProp.blockLevelBackup === 1;

										if ($scope.option.showInstallBlockFilterDriver) {
											setInstallWhenDropDown();
										}
									}

									if ($scope.option.type === 'setInstallWhen') {
										//server returns enum string of isRebootNowPermitted in response, but except to receive value in request
										$scope.mssqlSubclientProp.isRebootNowPermitted =
											mssqlSubclientProp.isRebootNowPermitted === 1 ? 'REBOOT_NOW' : 'REBOOT_LATER';
										setInstallWhenDropDown();
									}
								} else {
									errorHandling();
								}
							})
							.error(function(e) {
								errorHandling();
							});
					};

					var errorHandling = function() {
						$log.error('sql: Updating toggle for', $scope.option.type, 'failed');
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message:
								$scope.option.type === 'volumeLevelBackup'
									? cvLoc('error.setOptimizeRecoveryMsg', cvLoc('label.optimizeForVolumeRestore'))
									: cvLoc('error.setOptimizeRecoveryMsg', cvLoc('label.optimizeForTableLevelRestore'))
						});
					};

					var setInstallWhenDropDown = function() {
						if ($scope.option.installBlockFilterWhen === 2) {
							$scope.volumeLevelBackupEnableList = [
								{
									label: cvLoc('label.installBlockFilterNow'),
									value: 1 //RebootMachineOnQsnapInstallation.REBOOT_NOW
								}
							];
						} else {
							$scope.volumeLevelBackupEnableList = [
								{
									label: cvLoc('label.installBlockFilterLater'),
									value: 2 //RebootMachineOnQsnapInstallation.REBOOT_LATER
								}
							];
						}
					};

					setInstallWhenDropDown();
				}
			]
		};
	}
]);
