import 'adminConsole/js/services/cloudConfigSettings.svc.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/servers/js/services/servers.svc.js';

import { acAppDirectivesModule } from 'common/js/modules';

var acAppDirectives = acAppDirectivesModule;
acAppDirectives.directive('cvSqlCloudConfigComponent', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'adminConsole/partials/sqlCloudConfigurationTemplate.jsp',
			scope: {
				entityType: '=',
				genericEntity: '=',
				awsSqlInfo: '=?',
				azureSqlInfo: '=?',
				proxies: '=?',
				overwriteHigherLevelSettings: '=?',
				sqlPropLoaded: '=?'
			},
			link: function(scope, ele, attr, ctrl) {
				scope.$watch('overwriteHigherLevelSettings', function(newVal) {
					scope.option.overWriteStatus = newVal === true ? 'enabled-activity' : 'disabled-activity';
				});
			},
			controller: [
				'$scope',
				'$log',
				'cvLoc',
				'cvUtil',
				'ENTITY_TYPES',
				'idaService',
				'$uibModal',
				'sqlService',
				'dragulaService',
				'cloudConfigSettingsService',
				'$state',
				function(
					$scope,
					$log,
					cvLoc,
					cvUtil,
					ENTITY_TYPES,
					idaService,
					$modal,
					sqlService,
					dragulaService,
					cloudConfigSettingsService,
					$state
				) {
					$scope.isAmazon = $scope.genericEntity.vendor === 'AMAZON';
					$scope.isAzure = $scope.genericEntity.vendor === 'AZURE' || $scope.genericEntity.vendor === 'AZURE_V2';
					$scope.option = {};

					$scope.init = function() {
						$scope.proxyClientLimit = 3;

						$scope.showProxy = false;

						if ($scope.isAmazon) {
							$scope.option.isS3BucketConfigured =
								$scope.awsSqlInfo.s3BucketName != null && $scope.awsSqlInfo.s3BucketName.length > 0;
							$scope.option.isAmazonAccountSet =
								$scope.awsSqlInfo.sqlInstanceCredentials.userName != null &&
								$scope.awsSqlInfo.sqlInstanceCredentials.userName.length > 0;
						} else if ($scope.isAzure) {
							$scope.option.isAzureStorageConnectionConfigured =
								$scope.azureSqlInfo.azureStorageConnectionString != null &&
								$scope.azureSqlInfo.azureStorageConnectionString.length > 0;
							$scope.option.isAzureAccountSet =
								$scope.azureSqlInfo.azureSqlInstanceCredentials.userName != null &&
								$scope.azureSqlInfo.azureSqlInstanceCredentials.userName.length > 0;
						}

						if ($scope.entityType == ENTITY_TYPES.APPTYPE_ENTITY) {
							$scope.showProxy = true;
							$scope.option.proxyList = $scope.proxies.memberServers;
						}

						$scope.deactivateReordering();
					};

					var formatProxies = function(memberServers) {
						$scope.formattedProxies = [];
						for (var x = 0; x < memberServers.length; x++) {
							$scope.formattedProxies.push({
								clientName: memberServers[x].client.clientName,
								clientId: memberServers[x].client.clientId
							});
						}
					};

					dragulaService.options($scope, 'bag-two', {
						moves: function(el, source, handle, sibling) {
							return $scope.proxyReorderingEnabled && angular.element(el).hasClass('draggable-proxy');
						}
					});

					$scope.activateReordering = function() {
						$scope.proxyReorderingEnabled = true;
						$scope.reorderHelpText = cvLoc('label.reorderHelpText');

						// cache the original list to preserve order
						$scope.cachedProxyList = $scope.option.proxyList.slice(0);
					};

					$scope.deactivateReordering = function() {
						$scope.proxyReorderingEnabled = false;
						$scope.reorderHelpText = undefined;

						// reset cache
						$scope.cachedProxyList = [];
					};

					$scope.resetOrder = function() {
						$scope.option.proxyList = $scope.cachedProxyList.slice(0);
						$scope.option.proxyList.forEach(function(item, idx) {
							item.pos = idx;
						});
						$scope.deactivateReordering();
					};

					$scope.setOrder = function() {
						var hasChanged = false;
						for (var i = 0; i < $scope.option.proxyList.length; i++) {
							var newProxy = $scope.option.proxyList[i];
							var oldProxy = $scope.cachedProxyList[i];
							if (newProxy.client.clientId !== oldProxy.client.clientId) {
								hasChanged = true;
							}
						}

						if (!hasChanged) {
							$scope.deactivateReordering();
							return;
						}

						$log.debug('reorder proxy for sql agent');

						formatProxies($scope.option.proxyList);

						var cloudInfo = {
							genericEntityJSON: angular.toJson($scope.genericEntity),
							proxyList: angular.toJson($scope.formattedProxies)
						};

						cloudConfigSettingsService
							.updateProxyForSqlCloudAgent(cloudInfo)
							.success(function(successData) {
								$scope.deactivateReordering();
							})
							.error(function(err) {
								$scope.proxyMessage = cvUtil.errMsg(err);
							});
					};

					$scope.enableDisableOverWrite = function(
						awsSqlInfo,
						genericEntity,
						entityType,
						selectedProxies,
						overwriteHigherLevelSettings,
						azureSqlInfo,
						option
					) {
						if ($scope.option.overWriteStatus === 'enabled-activity') {
							//disabling
							$log.debug('Disabling override higher levels settings');

							var cloudInfo = {
								genericEntityJSON: angular.toJson(genericEntity),
								entityType: entityType,
								vendorType: genericEntity.vendor,
								overwriteHigherLevelSettings: false
							};

							cloudConfigSettingsService
								.updateSqlCloudConfigSettings(cloudInfo)
								.success(function(successData) {
									$state.forceReload();
								})
								.error(function(err) {
									$scope.serverMessage = {
										message: err,
										type: 'error'
									};
								});
						} else {
							$scope.editSqlCloud(awsSqlInfo, genericEntity, entityType, selectedProxies, true, azureSqlInfo, option);
						}
					};

					$scope.editSqlCloud = function(
						awsSqlInfo,
						genericEntity,
						entityType,
						selectedProxies,
						overwriteHigherLevelSettings,
						azureSqlInfo,
						option
					) {
						var modalInstance = $modal.open({
							templateUrl: appUtil.appRoot + 'adminConsole/partials/sqlCloudConfigEditing.jsp',
							backdrop: 'static',
							windowClass: entityType === 'INSTANCE_ENTITY' ? 'small-size' : null,
							controller: [
								'$scope',
								'$uibModalInstance',
								'$state',
								'cvLoc',
								'cloudConfigSettingsService',
								'serverService',
								function($scope, $modalInstance, $state, cvLoc, cloudConfigSettingsService, serverService) {
									var MSSQLSPOperationType_GETCLOUDPROXYLIST = '3';

									$scope.localLang = cvUtil.getIStevenLocLabels();

									//console.log($scope.awsSqlInfo.sqlInstanceCredentials.userName);
									$scope.genericEntity = angular.copy(genericEntity);
									$scope.entityType = angular.copy(entityType);
									$scope.model = {};
									if (selectedProxies != null) {
										$scope.model.selectedProxies = angular.copy(selectedProxies.memberServers);
									}

									$scope.option = option;
									$scope.azureSqlInfo = azureSqlInfo;
									$scope.awsSqlInfo = awsSqlInfo;

									$scope.selectedProxies = selectedProxies;

									$scope.serverMessage = {
										message: '',
										type: ''
									};

									$scope.isAmazon = $scope.genericEntity.vendor === 'AMAZON';
									$scope.isAzure =
										$scope.genericEntity.vendor === 'AZURE' || $scope.genericEntity.vendor === 'AZURE_V2';

									if ($scope.isAmazon) {
										$scope.model.userName = angular.copy(awsSqlInfo.sqlInstanceCredentials.userName);
										$scope.model.password = angular.copy(awsSqlInfo.sqlInstanceCredentials.password);
										$scope.model.s3BucketName = angular.copy(awsSqlInfo.s3BucketName);
									}
									if ($scope.isAzure) {
										$scope.model.userName = angular.copy(azureSqlInfo.azureSqlInstanceCredentials.userName);
										$scope.model.password = angular.copy(azureSqlInfo.azureSqlInstanceCredentials.password);
										$scope.model.azureStorageConnectionString = angular.copy(azureSqlInfo.azureStorageConnectionString);
									}

									$scope.inputAlertFlags = {
										userName: !$scope.model.userName || $scope.model.userName.length <= 0,

										password: !$scope.model.userName || $scope.model.userName.length <= 0,

										s3BucketName: $scope.isAmazon
											? !$scope.model.s3BucketName || $scope.model.s3BucketName.length <= 0
											: false,

										proxies:
											$scope.entityType === 'APPTYPE_ENTITY' &&
											(!$scope.model.selectedProxies || $scope.model.selectedProxies.length <= 0),

										azureStorageConnectionString: $scope.isAzure
											? !$scope.model.azureStorageConnectionString ||
											  $scope.model.azureStorageConnectionString.length <= 0
											: false
									};

									$scope.passwordPlaceholder =
										!$scope.model.userName || $scope.model.userName.length == 0
											? ''
											: cvLoc('label.leaveAzureSecretKeyBlank');

									$scope.closeModal = function() {
										$modalInstance.close();
									};

									$scope.cancel = function() {
										$modalInstance.dismiss();
									};

									$scope.$watch(
										'model.selectedProxies.length',
										function(newVal) {
											$scope.inputAlertFlags.proxies = newVal <= 0;
										},
										true
									);

									sqlService.getSQLProxyClientInstance(MSSQLSPOperationType_GETCLOUDPROXYLIST).success(function(data) {
										$scope.proxyList = data.proxyClientsForSQL;
										if ($scope.model.selectedProxies && $scope.model.selectedProxies.length > 0) {
											var selectProxyMap = {};
											angular.forEach($scope.model.selectedProxies, function(proxy) {
												selectProxyMap[proxy.client.clientId] = proxy;
											});

											// loop through server proxy list to mark the selected values
											angular.forEach($scope.proxyList, function(proxy) {
												if (selectProxyMap[proxy.clientId]) {
													proxy.checked = true;
												}
											});
										}
									});

									$scope.cloudUserNameChanged = function() {
										$scope.inputAlertFlags.userName = !$scope.model.userName || $scope.model.userName.length <= 0;
										$scope.inputAlertFlags.password =
											!!$scope.model.userName &&
											$scope.model.userName.length > 0 &&
											(!$scope.model.password || $scope.model.password.length <= 0);
										$scope.model.password = '';
										$scope.passwordPlaceholder = '';
									};

									var inputValid = function() {
										$scope.atLeastOneNoneEmpty = false;
										if ($scope.isAmazon) {
											if (
												$scope.entityType === 'INSTANCE_ENTITY' ||
												!$scope.inputAlertFlags.userName ||
												!$scope.inputAlertFlags.s3BucketName
											) {
												$scope.atLeastOneNoneEmpty = true;
											}
											if (
												$scope.atLeastOneNoneEmpty &&
												($scope.inputAlertFlags.userName ||
													$scope.inputAlertFlags.password ||
													$scope.inputAlertFlags.s3BucketName)
											) {
												return false;
											}
										}
										if ($scope.isAzure) {
											if (
												$scope.entityType === 'INSTANCE_ENTITY' ||
												!$scope.inputAlertFlags.userName ||
												!$scope.inputAlertFlags.azureStorageConnectionString
											) {
												$scope.atLeastOneNoneEmpty = true;
											}
											if (
												$scope.atLeastOneNoneEmpty &&
												($scope.inputAlertFlags.userName ||
													$scope.inputAlertFlags.password ||
													$scope.inputAlertFlags.azureStorageConnectionString)
											) {
												return false;
											}
										}
										return true;
									};

									$scope.updateSqlCloudConfigSettings = function() {
										if (inputValid()) {
											$log.debug('Submitting sql cloud config info');

											var cloudInfo = {
												entityType: $scope.entityType,
												genericEntityJSON: angular.toJson($scope.genericEntity),
												vendorType: $scope.genericEntity.vendor,
												s3BucketName: $scope.model.s3BucketName,
												azureStorageConnectionString: $scope.model.azureStorageConnectionString,
												userName: $scope.model.userName,
												password: $scope.model.password,
												proxyList: angular.toJson($scope.model.selectedProxies),
												overwriteHigherLevelSettings: $scope.entityType === 'INSTANCE_ENTITY'
											};

											cloudConfigSettingsService
												.updateSqlCloudConfigSettings(cloudInfo)
												.success(function(successData) {
													$modalInstance.close();
													$state.forceReload();
												})
												.error(function(errorReason) {
													$scope.serverMessage = {
														message: errorReason,
														type: 'error'
													};
												});
										}
									};
								}
							]
						});
					};
				}
			]
		};
	}
]);
