import { commonAllAgentsModule } from 'common/js/modules';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/ida/js/services/idas.factory.js';
import 'adminConsole/js/services/instances.svc.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';

/***
 * Use this directive for Oracle RAC database instances management.
 */
var app = commonAllAgentsModule;

app.directive('cvRacManageInstances', function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/ida/partials/cv-rac-manage-instances.jsp',
		bindToController: {
			entity: '=',
			instances: '='
		},
		controller: 'racManageInstancesController',
		controllerAs: 'racMI'
	};
});

app.controller('racManageInstancesController', [
	'$timeout',
	'cvUtil',
	'cvToaster',
	'cvLoc',
	'idasFactory',
	'cvTableOptions',
	'$uibModal',
	'instanceService',
	'$dialogs',
	function($timeout, cvUtil, cvToaster, cvLoc, idasFactory, cvTableOptions, $uibModal, instanceService, $dialogs) {
		var self = this;
		this.$onInit = function() {
			/* GRID CONTSTRUCTION */
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

			self.instances = [];
			function fetchData(options) {
				if (self.entity.instanceId) {
					instanceService
						.getInstanceDetails(self.entity.instanceId)
						.success(function(data) {
							self.instances = data.oracleRACInstance.racDBInstance;
						})
						.error(function(err) {
							cvToaster.showErrorMessage({ message: err });
						})
						.then(data => options.success(self.instances))
						.catch(error => options.error(error));
				} else {
					$timeout(e => options.success(self.instances));
				}
			}

			/*Increment sid, e.g.  abc -> abc1, abc1->abc2*/
			function incrementSid(str) {
				if (str.length == 0) return str;
				var lastInt = parseInt(str[str.length - 1]);
				if (isNaN(lastInt)) {
					return str + 1;
				} else {
					return str.substring(0, str.length - 1) + (lastInt < 9 ? lastInt + 1 : 0);
				}
			}

			/* Move up row*/
			self.moveUp = function(rowEntity) {
				var newInstances = [];
				for (var i = 0; i < self.instances.length; ++i) {
					if (i > 0 && self.instances[i] === rowEntity) {
						var last = newInstances.pop();
						newInstances.push(self.instances[i]);
						newInstances.push(last);
					} else {
						newInstances.push(self.instances[i]);
					}
				}
				self.instances = newInstances;
				self.grid.grid.dataSource.read();
			};
			/* Move down row*/
			self.moveDown = function(rowEntity) {
				var newInstances = [];
				for (var i = 0; i < self.instances.length; ++i) {
					if (i < self.instances.length - 1 && self.instances[i] === rowEntity) {
						var next = self.instances[i + 1];
						newInstances.push(next);
						newInstances.push(self.instances[i]);
						++i;
					} else {
						newInstances.push(self.instances[i]);
					}
				}
				self.instances = newInstances;
				self.grid.grid.dataSource.read();
			};

			/* Add/Edit an instance */
			self.addInstance = function(oldInstance, isEdit) {
				//For creating new instance, copy last instance as default value
				if (!isEdit && !oldInstance && self.instances.length != 0) {
					oldInstance = angular.copy(self.instances[self.instances.length - 1]);
					oldInstance.instanceOracleSID = incrementSid(oldInstance.instanceOracleSID);
					oldInstance.connectString.serviceName = oldInstance.instanceOracleSID;
				}
				var modalInstance = $uibModal.open({
					templateUrl: appUtil.appRoot + 'modules/ida/partials/racAddInstance.jsp',
					backdrop: 'static',
					controllerAs: 'racAI',
					controller: [
						'$uibModalInstance',
						'params',
						'mbService',
						'pushInstallSoftwareFactory',
						function($uibModalInstance, params, mbService, pushInstallSoftwareFactory) {
							var modSelf = this;

							initValues();

							/*Init default for add case, copy values for edit case */
							function initValues() {
								modSelf.isEdit = !!params.isEdit;

								/*Params and callbacks for client selection directive */
								modSelf.clientSelection = {
									selectionChanged: function(clientEntity) {
										loadClientOsType(clientEntity.clientId);
									}
								};

								if (params.oldInstance) {
									var oracleRACDBInstance = params.oldInstance;
									modSelf.clientSelection.defaultClientId = oracleRACDBInstance.instancePhysicalClient.clientId;

									if (!oracleRACDBInstance.userAccount) {
										oracleRACDBInstance.userAccount = {};
									}
									if (!oracleRACDBInstance.connectString) {
										oracleRACDBInstance.connectString = {};
									}
									modSelf.model = {
										oracleSid: oracleRACDBInstance.instanceOracleSID,
										osUserName: oracleRACDBInstance.userAccount.userName,
										oracleHome: oracleRACDBInstance.oracleHome,
										userName: oracleRACDBInstance.connectString.userName,
										domainName:
											oracleRACDBInstance.connectString.serviceName || oracleRACDBInstance.connectString.instance,
										tnsAdminFolder: oracleRACDBInstance.tnsAdminFolder
									};
									if (oracleRACDBInstance.userAccount.password) {
										modSelf.model.osUserPassword = String.fromCharCode.apply(
											null,
											oracleRACDBInstance.userAccount.password
										);
									}
									if (oracleRACDBInstance.connectString.password) {
										modSelf.model.passwordTxt = String.fromCharCode.apply(
											null,
											oracleRACDBInstance.connectString.password
										);
									}
								} else {
									modSelf.model = {};
								}
							}

							/*Construct object for xml request*/
							function getOracleRACDBInstance() {
								var oracleRACDBInstance = {
									instancePhysicalClient: angular.copy(modSelf.clientSelection.selectedClients[0]),
									instanceOracleSID: modSelf.model.oracleSid,
									userAccount: {
										userName: modSelf.model.osUserName
									},
									oracleHome: modSelf.model.oracleHome,
									connectString: {
										userName: modSelf.model.userName,
										instance: modSelf.model.domainName,
										serviceName: modSelf.model.domainName
									},
									tnsAdminFolder: modSelf.model.tnsAdminFolder
								};
								if (modSelf.model.osUserPassword) {
									oracleRACDBInstance.userAccount.password = cvUtil.getBytes(modSelf.model.osUserPassword);
								}
								if (modSelf.model.passwordTxt) {
									oracleRACDBInstance.connectString.password = cvUtil.getBytes(modSelf.model.passwordTxt);
								}
								return oracleRACDBInstance;
							}

							modSelf.openAddNewHostDialog = function() {
								var pushInstallParams = {
									useAgent: 'ORACLE',
									dialogTitle: cvLoc('pageHeader.addOracleServer'),
									dialogTitleHelpText: cvLoc('help.addOracleServer'),
									disableInteractiveInstall: true,
									showOsType: true,
									osType: 'UNIX'
								};
								var modalInstance = pushInstallSoftwareFactory.openPushInstallDialog(pushInstallParams);
								modalInstance.result.then(
									function() {
										// on success
									},
									function() {
										// on error
									}
								);
							};
							/*
							 * Catalog string can be /(root) or with userName,password and service name
							 */
							modSelf.validateConnectString = function() {
								modSelf.isConnectInvalidate = true;

								if (
									modSelf.model.userName &&
									(modSelf.model.userName === '/' ||
										((modSelf.model.passwordTxt || modSelf.isEdit) && modSelf.model.domainName))
								) {
									modSelf.isConnectInvalidate = false;
								}
							};

							/* Load OS type for showing/hiding password */
							function loadClientOsType(clientId) {
								mbService
									.getOSType(clientId)
									.success(function(data) {
										modSelf.isUnixClient = data.toLowerCase() == 'unix';
									})
									.error(function(err) {
										cvToaster.showErrorMessage({ ttl: 10000, message: err });
									});
							}

							/*Callbacks for browse */
							modSelf.oraHomeResultFunction = function(data) {
								modSelf.model.oracleHome = data.path;
							};
							modSelf.tnsAdminFolderResultFunction = function(data) {
								modSelf.model.tnsAdminFolder = data.path;
							};

							/* OK clicked */
							modSelf.submit = function() {
								/*Validate connect string*/
								modSelf.validateConnectString();
								if (modSelf.isConnectInvalidate) {
									return;
								}
								/*Validate client selection*/
								if (!modSelf.clientSelection.valideClientSelection) {
									return;
								}
								var newInstance = getOracleRACDBInstance();

								/*Validate if duplicate instances exist*/
								if (!modSelf.isEdit) {
									var duplicateInstance = false;
									self.instances.forEach(function(instance) {
										if (
											instance.instancePhysicalClient.clientId == newInstance.instancePhysicalClient.clientId &&
											instance.instanceOracleSID == newInstance.instanceOracleSID
										) {
											duplicateInstance = true;
										}
									});
									if (duplicateInstance) {
										cvToaster.showErrorMessage({ message: cvLoc('label.instanceAlreadyExists') });
										return;
									}
								}

								//Add/Edit physical node for existing RAC database
								if (self.entity.instanceId) {
									if (modSelf.isEdit) {
										sendRequest('OVERWRITE', newInstance)
											.success(function() {
												$uibModalInstance.close(newInstance);
											})
											.error(function(err) {
												cvToaster.showErrorMessage({ ttl: 10000, message: err });
											});
									} else {
										sendRequest('ADD', newInstance)
											.success(function() {
												$uibModalInstance.close(newInstance);
											})
											.error(function(err) {
												cvToaster.showErrorMessage({ ttl: 10000, message: err });
											});
									}
								} else {
									//Add/Edit physical node during RAC database creation
									$uibModalInstance.close(newInstance);
								}
							};

							/* Cancle clicked */
							modSelf.cancel = function() {
								$uibModalInstance.dismiss();
							};
						}
					],
					resolve: {
						params: function() {
							return {
								oldInstance: oldInstance,
								isEdit: isEdit
							};
						}
					}
				});

				modalInstance.result.then(function(newInstance) {
					if (isEdit) {
						/* for editing, replace old instance with newInstance*/
						var newInstances = [];
						self.instances.forEach(function(instance) {
							if (instance == oldInstance) {
								newInstances.push(newInstance);
							} else {
								newInstances.push(instance);
							}
						});
						self.instances = newInstances;
					} else {
						self.instances.push(newInstance);
					}
					self.grid.grid.dataSource.read();
				});
			};

			/*Send request for Add/Edit/Delete actions if needed*/
			function sendRequest(action, instance) {
				var instanceProps = {
					oracleRACInstance: {
						racDBOperationType: action,
						racDBInstance: [instance]
					}
				};
				var instInfo = {
					instanceEntity: angular.toJson(self.entity),
					instanceProps: angular.toJson(instanceProps)
				};
				return instanceService.updateInstance(instInfo);
			}

			/*Delete an instance */
			self.deleteInstanceHelper = function(oldInstance) {
				var index = self.instances.indexOf(oldInstance);
				self.instances.splice(index, 1);
			};
			self.deleteInstance = function(oldInstance) {
				$dialogs.confirm(cvLoc('label.confirmDelete'), cvLoc('label.confirmDeleteInstance'), {
					yesFunction: function() {
						if (self.entity.instanceId) {
							sendRequest('DELETE', oldInstance)
								.success(function() {
									self.deleteInstanceHelper(oldInstance);
									self.grid.grid.dataSource.read();
								})
								.error(function(err) {
									cvToaster.showErrorMessage({ ttl: 10000, message: err });
								});
						} else {
							self.deleteInstanceHelper(oldInstance);
							self.grid.grid.dataSource.read();
						}
					},
					noFunction: function() {}
				});
			};
			function onGridSelectionChange(e) {
				if (e.rows.length == 1) {
					self.grid.showActionMenuOption('EDIT');
					self.grid.showActionMenuOption('REMOVE');
				} else {
					self.grid.hideActionMenuOption('EDIT');
					self.grid.hideActionMenuOption('REMOVE');
				}
			}

			//Action triggered from cell template
			function actionClicked(e) {
				/*
			// prevent page scroll position change
	        e.preventDefault();
	        // e.target is the DOM element representing the button
	        let tr = $(e.target).closest("tr"); // get the current table row (tr)
	        // get the data bound to the current table row
	        let data = self.grid.grid.dataItem(tr);
	        let id = e.currentTarget.id;
	        */

				let data = e.selectedRowValues[0];
				let oldInstance = null;
				for (var i = 0; i < self.instances.length; ++i) {
					if (
						self.instances[i].instancePhysicalClient.clientName == data.instancePhysicalClient.clientName &&
						self.instances[i].instanceOracleSID == data.instanceOracleSID
					) {
						oldInstance = self.instances[i];
					}
				}

				switch (e.optionId) {
					case 'MoveUp':
						self.moveUp(oldInstance);
						break;
					case 'MoveDown':
						self.moveDown(oldInstance);
						break;
					case 'Edit':
						self.addInstance(oldInstance, true);
						break;
					case 'Delete':
						self.deleteInstance(oldInstance);
						break;
				}
			}

			function addActionHanlder() {
				self.addInstance();
			}

			/* Set cv-grid options */
			//		self.gridOptions = {
			//				cvGridTitle: cvLoc('label.racDatabaseInstances'),
			//				cvAppScope : self,
			//				cvIsPageTitle : false,
			//				cvHasViews: false,
			//				cvOnGridEmpty : {
			//					'message' : cvLoc('label.noInstancesAddedYet'),
			//				},
			//				cvSearchFields: ['instancePhysicalClient.clientName', 'instanceOracleSID'],
			//				gridOptions : globalGridOptions,
			//				cvGridCssClass: {
			//					'users-grid': true
			//				},
			//				cvPageLinks: [{
			//					label: cvLoc('label.addRacInstance'),
			//					onclick: self.addInstance
			//				}]
			//		};

			/* Set ui-grid options */
			//		angular.extend(globalGridOptions, {
			//			data: 'instances',
			//			enableGridMenu: false,
			//			paginationPageSize: 10,
			//			columnDefs: [{
			//				field: 'instancePhysicalClient.clientName',
			//				displayName: cvLoc('label.server'),
			//				cellTemplate: '<span class="crop" title="{{row.entity.instancePhysicalClient.clientName}}">{{row.entity.instancePhysicalClient.clientName}}</span>',
			//				width: '40%',
			//				enableSorting: false,
			//				enableHiding: false
			//			},{
			//				field: 'instanceOracleSID',
			//				displayName: cvLoc('tableHeading.instance'),
			//				cellTemplate: '<span class="crop" title="{{row.entity.instanceOracleSID}}">{{row.entity.instanceOracleSID}}</span>',
			//				width: '30%',
			//				enableSorting: false,
			//				enableHiding: false
			//			},{
			//				name: 'actions',
			//				displayName: cvLoc('header.actions') ,
			//				cellTemplate: '<span ><a data-ng-click="grid.appScope.addInstance(row.entity, true)"><i class="glyphicon glyphicon-pencil"></i></a>'
			//									+'<a class="padding-left-20" data-ng-click="grid.appScope.deleteInstance(row.entity)"><i class="glyphicon glyphicon-remove"></i></a>'
			//									+'<a class="padding-left-20" title="' + cvLoc('label.moveUp') + '" data-ng-click="grid.appScope.moveUp(row.entity)"><i class="glyphicon glyphicon-arrow-up"></i></a>'
			//									+'<a class="padding-left-20" title="' + cvLoc('label.moveDown') + '"  data-ng-click="grid.appScope.moveDown(row.entity)"><i class="glyphicon glyphicon-arrow-down"></i></a></span>',
			//				width: '24%',
			//				enableFiltering: false,
			//				enableSorting: false,
			//			}
			//			]});

			function getColumns() {
				return {
					'instancePhysicalClient.clientName': {
						title: cvLoc('label.server'),
						type: 'string',
						width: '30%',
						template: `<span class="crop" cv-toggle-content="#=instancePhysicalClient.clientName#" cv-toggle="tooltip">#=instancePhysicalClient.clientName#</span>`
					},
					instanceOracleSID: {
						title: cvLoc('tableHeading.instance'),
						type: 'string',
						width: '30%',
						template: `<span class="crop" cv-toggle-content="#=instanceOracleSID#" cv-toggle="tooltip">#=instanceOracleSID#</span>`
					}
					//				  "actions": {
					//					  title: cvLoc('header.actions'),
					//
					//					  width: "40%",
					//					  command: {
					//						  name: "actions",
					//						  template:
					//							  '<span ><a class="k-grid-actions" id="Edit"><i class="glyphicon glyphicon-pencil"></i></a>'
					//							  +'<a class="padding-left-20 k-grid-actions" id="Delete"><i class="glyphicon glyphicon-remove"></i></a>'
					//							  + (self.entity.instanceId? '</span>' :
					//							  ('<a class="padding-left-20 k-grid-actions" title="' + cvLoc('label.moveUp') + '" id="MoveUp"><i class="glyphicon glyphicon-arrow-up"></i></a>'
					//							  +'<a class="padding-left-20 k-grid-actions" title="' + cvLoc('label.moveDown') + '"  id="MoveDown"><i class="glyphicon glyphicon-arrow-down"></i></a></span>')),
					//						  click: actionClicked
					//
					//					  }
					//
					//				  },
				};
			}
			function initGrid() {
				self.gridOptions = {
					enableCheckBoxColumn: false,
					enableColumnResizing: true,
					enableVirtualization: true,
					enableColumnMenu: true,
					enableFiltering: false,
					enableSorting: false,
					searchable: false,

					columns: getColumns(),
					height: self.instances.length < 7 ? undefined : 300,
					//					data: self.instances,
					url: fetchData,
					gridTitle: cvLoc('label.racDatabaseInstances'),
					tableName: 'racManageInstancesTable',
					hasViews: false,
					idField: 'instancePhysicalClient.clientName',
					gridEmptyMessage: ' ', //cvLoc('label.noInstancesAddedYet'),
					gridEmptyLinks: [
						{
							id: 'EmptyLinkAdd',
							label: cvLoc('label.addRacInstance')
						}
					],
					onGridSelectionChange: onGridSelectionChange,
					beforeGridInitialize: ({ grid }) => {
						self.grid = grid;
					},
					afterGridInitialize: ({ grid }) => {
						$('#EmptyLinkAdd').click(addActionHanlder);
					}
				};

				self.gridOptions.actionMenu = [
					{
						id: 'Edit',
						label: cvLoc('label.inlineEdit'),
						onSelect: actionClicked
					},
					{
						id: 'Delete',
						label: cvLoc('Delete'),
						onSelect: actionClicked
					}
				];
				self.gridOptions.gridToolbarMenu = [
					{
						id: 'Add',
						label: cvLoc('label.addRacInstance'),
						onSelect: addActionHanlder
					}
				];
			}
			initGrid();
		};
	}
]);

export default app;
