import { commonAllAgentsModule } from 'common/js/modules';

export class hardwareRevertController {
	constructor(cvLoc, idaService) {
		this.cvLoc = cvLoc;
		this.idaService = idaService;
	}

	$onInit() {
		this.proxyClients = [];
		//default label and select classes
		if (!angular.isDefined(this.labelClass)) {
			this.labelClass = 'col-xs-12 col-sm-5';
		}
		if (!angular.isDefined(this.selectClass)) {
			this.selectClass = 'col-xs-12 col-sm-7';
		}
		this.checkSnapEnabled();
		this.loadProxyServers();
	}

	checkSnapEnabled() {
		this.idaService.getChildranData('SUBCLIENT_ENTITY', this.entity).success(
			function(data) {
				if (data) {
					for (var i = 0; i < data.length; i++) {
						this.snapBackupEnabled = _.get(data[i], 'commonProperties.snapCopyInfo.isSnapBackupEnabled', false);
						if (this.snapBackupEnabled) {
							return;
						}
					}
				}
			}.bind(this)
		);
	}

	loadProxyServers() {
		this.idaService.getSnapshotProxyList(this.entity.clientId, this.entity.applicationId).success(
			function(data) {
				this.proxyClients = data;
			}.bind(this)
		);
	}

	updateProxy() {
		if (this.hardwareRevert) {
			this.proxyClient = {};
		}
	}

	isShowProxy() {
		//For Out-of-place restores hardware revert is not applicable so we should reset the hardware revert option out of place restores
		if (!this.isInplaceRestore()) {
			this.hardwareRevert = false;
		}
		if (this.hardwareRevert) {
			return false;
		}
		return true;
	}
}

hardwareRevertController.$inject = ['cvLoc', 'idaService'];

const directive = function() {
	return {
		restrict: 'E',
		templateUrl: `${appUtil.appRoot}modules/ida/partials/cv-hardware-revert.jsp`,
		bindToController: {
			entity: '=',
			snapBackupEnabled: '=',
			hardwareRevert: '=',
			isInplaceRestore: '=',
			proxyClient: '=',
			labelClass: '=?',
			selectClass: '=?'
		},
		controller: hardwareRevertController,
		controllerAs: 'hardwareRevertCtrl'
	};
};

commonAllAgentsModule.directive('cvHardwareRevert', directive);

export default commonAllAgentsModule;
