import 'modules/ida/js/services/idaService.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('db2PartitionNodesCtrl', [
	'cvLoc',
	'cvTableOptions',
	'$log',
	'idaService',
	'cvUtil',
	'$uibModal',
	function(cvLoc, cvTableOptions, $log, idaService, cvUtil, $uibModal) {
		var self = this;
		this.$onInit = function() {
			let updatePartNumber = function(partitionNodeList) {
				if (partitionNodeList) {
					angular.forEach(partitionNodeList, function(partitionNode) {
						var nodeNumber = 'NODE000';
						var partitionId = partitionNode.nodenum;
						if (partitionId > 9 && partitionId <= 99) {
							nodeNumber = 'NODE00';
						} else if (partitionId > 99 && partitionId <= 999) {
							nodeNumber = 'NODE0';
						} else if (partitionId > 999 && partitionId <= 9999) {
							nodeNumber = 'NODE';
						}
						partitionNode.nodeNumber = nodeNumber + partitionId;
					});
				}
			};

			if (!self.instInfo.partitionNodeList) {
				self.instInfo.partitionNodeList = [];
			} else {
				updatePartNumber(self.instInfo.partitionNodeList);
			}
			let getClientNode = function(clientId) {
				if (self.listOfClients) {
					for (var int = 0; int < self.listOfClients.length; int++) {
						if (self.listOfClients[int].clientId == clientId) {
							return self.listOfClients[int];
						}
					}
				}
			};

			self.addDB2Partition = function() {
				var dataResolve = function() {
					return {
						entity: self.instInfo.instanceEntity,
						db2Home: _.get(self.instInfo, 'dbHome', '')
					};
				};

				var modalData = {
					controller: 'addDB2PartitionNodesCtrl',
					controllerAs: 'addDB2PartitionNodeList',
					backdrop: 'static',
					templateUrl: appUtil.appRoot + 'modules/ida/partials/addDB2PartitionNodes.jsp'
				};
				modalData.resolve = {
					data: dataResolve
				};

				var modelInsta = $uibModal.open(modalData);
				modelInsta.result.then(function(partitionData) {
					if (partitionData) {
						self.instInfo.dbHome = partitionData.db2Home;
						self.listOfClients = partitionData.listOfClients;
						self.instInfo.partitionNodeList = partitionData.partitionList.nodes;
						updatePartNumber(self.instInfo.partitionNodeList);
					}
				});
			};

			var columnDefs = [];

			columnDefs.push({
				field: 'partition',
				displayName: cvLoc('label.db2partition'),
				cellTemplate: '<div class="crop" >{{row.entity.nodeNumber}}</div>',
				sort: {
					direction: 'asc',
					priority: 0
				},
				width: '40%',
				enableHiding: false,
				cellTooltip: true
			});
			columnDefs.push({
				field: 'serverName',
				displayName: cvLoc('label.clientName'),
				cellTemplate: '<div class="crop" >{{row.entity.nodeClient.clientName}}</div>'
				//cellTemplate: '<div class="margin-top-10-minus"><select name="clientName" id="clientName" data-ng-options="client as client.clientName for client in grid.appScope.listOfClients | orderBy:\'clientName\'" ' + '	data-ng-model="row.entity.nodeClient" > </select></div>'
			});

			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			angular.extend(globalGridOptions, {
				data: 'instInfo.partitionNodeList',
				enableGridMenu: false,
				paginationPageSize: 5,
				paginationPageSizes: [5, 10, 20, 50],
				columnDefs: columnDefs
			});

			self.partitionGridOptions = {
				cvIsPageTitle: true,
				cvGridTitle: cvLoc('label.db2PartitionNode'),
				cvTableName: 'db2PartitionNodeList',
				cvPageLinks: [
					{
						label: cvLoc('action.addOrRefresh'),
						id: 'add_PartitionNode',
						onclick: self.addDB2Partition
					}
				],
				cvIsSearchable: false,
				cvSearchFields: ['partition'],
				cvAppScope: self,
				cvHasViews: false,
				gridOptions: globalGridOptions
			};
		};
	}
]);

app.directive('cvDb2PartitionNodes', function() {
	return {
		restrict: 'E',
		bindToController: {
			instInfo: '='
		},
		templateUrl: appUtil.appRoot + 'modules/ida/partials/cv-db2-partition-nodes.jsp',
		controller: 'db2PartitionNodesCtrl',
		controllerAs: 'db2PartNodes'
	};
});
export default app;
