import 'modules/ida/js/services/idaService.svc.js';
import 'jobs/js/services/jobs.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('cvDbRestoreToDiskComponentCtrl', [
	'cvLoc',
	'$log',
	'AppTypes',
	'idaService',
	'jobService',
	'cvUtil',
	'$uibModal',
	function(cvLoc, $log, AppTypes, idaService, jobService, cvUtil, $uibModal) {
		const self = this;
		self.$onInit = function() {
			self.initData();
		};

		self.initData = () => {
			self.dbRestoreToDiskData.jobList = null;
			self.dbRestoreToDiskData.selectedJobs = [];
			self.dbRestoreToDiskData.destinationTargetClients = [];
			self.dbRestoreToDiskData.selectedClient = null;
			self.dbRestoreToDiskData.impersonateEnabledStatus = 'disabled-activity';
			self.dbRestoreToDiskData.useImpersonation = false;
			self.dbRestoreToDiskData.impersonateUserName = '';
			self.dbRestoreToDiskData.impersonatePassword = '';
			self.dbRestoreToDiskData.path = '';
			self.isRestoreToDisk = self.dbRestoreToDiskData.isRestoreToDisk;
			self.localLang = cvUtil.getIStevenLocLabels();
			self.localLang.nothingSelected = cvLoc('placeholder.job');

			self.loadClients();
			self.loadBackupjobs();
		};

		//Load backup jobs
		self.loadBackupjobs = () => {
			const date = new Date();
			jobService.getBackupJobDetails(self.entity, date, true).then(result => {
				let jobs = _.get(result, 'jobs', []);
				let tmpList = [];
				angular.forEach(jobs, function(job) {
					let jobInfo = job.data.jobSummary;
					let startDate = new Date(parseInt(jobInfo.jobStartTime) * 1000);
					let startDateString = cvUtil.convertUTCDateToLocalDate(startDate);
					let endDate = new Date(parseInt(jobInfo.jobEndTime) * 1000);
					let endDateString = cvUtil.convertUTCDateToLocalDate(endDate);
					//template to display job info
					jobInfo.template = `
											<div class="isteven-html-content" title="${_.escape(cvLoc('label.jobId', jobInfo.jobId))}">
												<div>${jobInfo.jobId}</div>
												<div class="description">
													<label>${_.escape(cvLoc('label.jobSummary', jobInfo.backupLevelName, startDateString, endDateString))}</label>
												</div>
											</div>`;
					tmpList.push(jobInfo);
				});
				//sort by jobid in descending order
				tmpList = _.sortBy(tmpList, jobInfo => -jobInfo.jobId);
				self.dbRestoreToDiskData.jobList = tmpList;
			});
		};

		self.loadClients = () => {
			idaService
				.getRestoreDestinations(0, AppTypes.APPTYPE_FILESYSTEM)
				.success(data => {
					if (data) {
						self.dbRestoreToDiskData.destinationTargetClients = angular.copy(_.sortBy(data, 'clientName'));
					}
				})
				.error(error => {
					$log.error(error);
				});
		};

		self.isShowJobError = () => {
			if (self.isRestoreToDisk() && self.dbRestoreToDiskData.selectedJobs.length <= 0) {
				return true;
			}
			return false;
		};

		self.isDisableBrowse = () => {
			let clientId = _.get(self.dbRestoreToDiskData, 'selectedClient.clientId', 0);
			if (clientId > 0) {
				return false;
			}
			return true;
		};

		self.browseResultFunction = result => {
			if (result) {
				self.dbRestoreToDiskData.path = result.path;
			}
		};

		self.toggleImpersonation = () => {
			self.dbRestoreToDiskData.useImpersonation = !self.dbRestoreToDiskData.useImpersonation;
			self.dbRestoreToDiskData.impersonateEnabledStatus = self.dbRestoreToDiskData.impersonateEnabledStatus
				? 'enabled-activity'
				: 'disabled-activity';
		};
	}
]);

app.directive('cvDbRestoreToDiskComponent', function() {
	return {
		restrict: 'E',
		bindToController: {
			dbRestoreToDiskData: '=',
			entity: '='
		},
		templateUrl: appUtil.appRoot + 'modules/ida/partials/dbRestoreToDiskTemplate.jsp',
		controller: 'cvDbRestoreToDiskComponentCtrl',
		controllerAs: 'dbRestoreToDisk'
	};
});
export default app;
