import 'modules/servers/js/services/servers.svc.js';
import 'dlo/js/services/profile.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var allAgentMod = commonAllAgentsModule;

/***
 * This directive is used to show a selection box that shows copy names
 */
export class copyPrecedenceController {
	constructor(AppTypes, cvLoc, idaService, serverService, cvToaster, storageService, profileService) {
		let self = this;
		self.appTypes = AppTypes;
		self.cvLoc = cvLoc;
		self.idaService = idaService;
		self.serverService = serverService;
		self.cvToaster = cvToaster;
		self.storageService = storageService;
		self.profileService = profileService;
		if (!self.label) {
			self.label = this.cvLoc('label.restoreFromCopy');
		}
	}

	$onInit() {
		let self = this;

		var getStoragePolicyId = function(entityDetailsObject) {
			var spAttrName = 'commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId';
			if (self.entityType && self.entityType === 'BACKUPSET_ENTITY') {
				var appId = _.get(entityDetailsObject, 'backupSetEntity.applicationId', 0);
				if (appId === self.appTypes.SAP_HANA) {
					spAttrName = 'sapHanaBackupset.saphanaStorageDevice.commandLineStoragePolicy.storagePolicyId';
				}
			} else if (self.entityType && self.entityType === 'INSTANCE_ENTITY') {
				var appId = _.get(entityDetailsObject, 'instance.applicationId', 0);
				if (appId === self.appTypes.SAP_HANA) {
					spAttrName = 'saphanaInstance.saphanaStorageDevice.commandLineStoragePolicy.storagePolicyId';
				}
			}
			return _.get(entityDetailsObject, spAttrName, null);
		};
		var loadStoreDetails = function(storagePolicyId) {
			self.storageService
				.getStoragePolicyDetails(storagePolicyId)
				.success(function(data) {
					self._setCopyPrecedence(data);
				})
				.error(function(e) {
					self.error(e);
				});
		};

		var loadPlanDetails = function(planId) {
			self.profileService
				.getProfileDetails(planId)
				.success(function(data) {
					if (data.profile && data.profile.storage && data.profile.storage.copy) {
						self._setCopyPrecedence(data.profile.storage);
					} else {
						$log.debug('no storage information returned');
					}
				})
				.error(function(e) {
					self.error(e);
				});
		};
		var loadInstanceStorage = function(instanceId) {
			self.idaService.getInstanceDetails(instanceId).success(function(data) {
				if (data) {
					var planId = _.get(data, 'planEnity.planId', null);
					if (planId) {
						loadPlanDetails(planId);
					} else {
						var storagePolicyId = getStoragePolicyId(data);
						loadStoreDetails(storagePolicyId);
					}
				}
			});
		};

		var loadBackupsetStorage = function(backupsetId) {
			self.idaService.getBackupSetDetails(backupsetId).success(function(data) {
				if (data) {
					var planId = _.get(data, 'planEnity.planId', null);
					if (planId) {
						loadPlanDetails(planId);
					} else {
						var storagePolicyId = getStoragePolicyId(data);
						loadStoreDetails(storagePolicyId);
					}
				}
			});
		};

		var loadSubclientDetails = function(subclientId) {
			self.serverService
				.getCollectionDetails(subclientId)
				.success(function(data) {
					// check if subclient is associated with a plan
					if (data.planEntity && data.planEntity.planId) {
						self.planId = data.planEntity.planId;
						loadPlanDetails(self.planId);
					} else {
						// get storage policy associated to the subclient
						//var storagePolicyId = data.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId;
						var storagePolicyId = getStoragePolicyId(data);
						loadStoreDetails(storagePolicyId);
					}
				})
				.error(function(e) {
					self.error(e);
				});
		};
		if (self.entityType && self.entityType === 'INSTANCE_ENTITY') {
			loadInstanceStorage(self.entityId);
		} else if (self.entityType && self.entityType === 'BACKUPSET_ENTITY') {
			loadBackupsetStorage(self.entityId);
		} else {
			var nodeId = null;
			if (self.subclientId) {
				nodeId = self.subclientId;
			} else if (self.entityId) {
				nodeId = self.entityId;
			}
			if (nodeId) {
				loadSubclientDetails(nodeId);
			}
		}
	}

	error(e) {
		this.cvToaster.showErrorMessage({
			message: e
		});
	}

	_setCopyPrecedence(storageData) {
		this.storage = storageData;
		this.storage.copy.forEach(e => (e.flatLabel = e.StoragePolicyCopy.copyName));

		/* Add automatic(default) option */
		this.storage.copy.splice(0, 0, {
			flatLabel: this.cvLoc('label.defaultCopyPrecedence'),
			copyPrecedence: 0
		});
	}
}

copyPrecedenceController.$inject = [
	'AppTypes',
	'cvLoc',
	'idaService',
	'serverService',
	'cvToaster',
	'storageService',
	'profileService'
];

var directive = function() {
	return {
		restrict: 'E',
		require: ['^^cvSubmit', '^^form'],
		templateUrl: appUtil.appRoot + 'modules/ida/partials/cv-copy-precedence.jsp',
		bindToController: {
			entityType: '=',
			entityId: '=',
			subclientId: '=',
			copyPrecedenceInt: '=',
			label: '@'
		},
		controller: copyPrecedenceController,
		controllerAs: 'copyPreCtrl',
		link: function(scope, elem, attr, controllers) {
			scope.submitController = controllers[0];
			scope.formController = controllers[1];
		}
	};
};

allAgentMod.directive('cvCopyPrecedence', directive);

export default allAgentMod;
