import 'dbs/js/services/dbs.factory.js';
import 'modules/ida/js/services/idaService.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var allAgentMod = commonAllAgentsModule;

/*************************************************************************************************************
 * This directive is used to show a selection a supported cloud DB engines for a given hypervisor vendor.
 */
export class cloudDbEngineSelectController {
	constructor(cvUtil, AppTypes, cvLoc, cvToaster, $scope, CLOUD_DB_VENDOR, CAPPS_CONSTANTS, idaService) {
		this.cvUtil = cvUtil;
		this.AppTypes = AppTypes;
		this.cvLoc = cvLoc;
		this.cvToaster = cvToaster;
		this.$scope = $scope;
		this.CLOUD_DB_VENDOR = CLOUD_DB_VENDOR;
		this.CAPPS_CONSTANTS = CAPPS_CONSTANTS;
		this.idaService = idaService;

		this.engines = {
			DYNAMODB: {
				applicationId: AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key,
				displayName: this.cvLoc('label.dynamodb'),
				key: 'DynamoDB'
			},
			RDS: {
				applicationId: AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key,
				displayName: this.cvLoc('label.rds'),
				tooltip: this.cvLoc('tooltip.engineRDS'),
				key: 'RDS'
			},
			MYSQL: {
				applicationId: AppTypes.MYSQL,
				displayName: this.cvLoc('label.mySql'),
				tooltip: this.cvLoc('tooltip.engineMySQL'),
				key: 'MySQL'
			},
			POSTGRESQL: {
				applicationId: AppTypes.POSTGRESQL,
				displayName: this.cvLoc('label.postgreSQL'),
				tooltip: this.cvLoc('tooltip.eginePostgreSQL'),
				key: 'PostgreSQL'
			},
			REDSHIFT: {
				applicationId: AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.key,
				displayName: this.cvLoc('viewname.dbInstancesTable.redshift'),
				tooltip: this.cvLoc('tooltip.engineRedshift'),
				key: 'Redshift'
			},
			DOCUMENTDB: {
				applicationId: AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.key,
				displayName: this.cvLoc('viewname.dbInstancesTable.documentdb'),
				tooltip: this.cvLoc('tooltip.engineDocumentDB'),
				key: 'DocumentDB'
			},
			TABLE_STORAGE: {
				applicationId: AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.key,
				displayName: this.cvLoc('viewname.dbInstancesTable.tableStorage'),
				key: 'Table storage'
			},
			OracleServer: {
				applicationId: AppTypes.ORACLE,
				displayName: this.cvLoc('label.oracle'),
				key: 'Oracle'
			},
			SQLServer: {
				applicationId: AppTypes.SQL_SERVER,
				displayName: this.cvLoc('label.sqlserver'),
				key: 'SQL Server'
			},
			COSMOS_DB_SQL_API: {
				applicationId: AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key,
				displayName: this.cvLoc('viewname.dbInstancesTable.cosmosDbSQL'),
				key: 'Cosmos DB SQL API'
			},
			AURORA_MYSQL: {
				applicationId: AppTypes.MYSQL,
				displayName: this.cvLoc('label.auroraMySql'),
				tooltip: this.cvLoc('tooltip.engineAuroraMySql'),
				key: 'Aurora MySQL'
			},
			MARIADB: {
				applicationId: AppTypes.MYSQL,
				displayName: this.cvLoc('label.mariaDb'),
				tooltip: this.cvLoc('tooltip.engineMariaDB'),
				key: 'MariaDB'
			},
			AURORA_POSTGRESQL: {
				applicationId: AppTypes.POSTGRESQL,
				displayName: this.cvLoc('label.auroraPostgreSql'),
				tooltip: this.cvLoc('tooltip.engineAuroraPostgreSql'),
				key: 'Aurora PostgreSQL'
			}
		};

		_.each(this.engines, this._initTemplate);
		$scope.$on('vendorChanged', this._init.bind(this));
	}

	_init(event, vendorId) {
		const self = this;
		this.vendorId = vendorId;

		this.engineSelectLoc = this.cvUtil.getIStevenLocLabels();
		this.engineSelectLoc.nothingSelected = this.cvLoc('label.selectEngine');
		this.databaseEngine = undefined;
		this._selectedEngines = [];

		let engineList = [];
		//Update PostgreSQL/MySQL tool tip for Amazon
		if (this.vendorId === this.CLOUD_DB_VENDOR.AMAZON) {
			this.engines.MYSQL.tooltip = this.cvLoc('tooltip.engineAmazonMySQL');
			this.engines.POSTGRESQL.tooltip = this.cvLoc('tooltip.egineAmazonPostgreSQL');
		} else {
			this.engines.MYSQL.tooltip = this.cvLoc('tooltip.engineMySQL');
			this.engines.POSTGRESQL.tooltip = this.cvLoc('tooltip.eginePostgreSQL');
		}
		_.each([this.engines.MYSQL, this.engines.POSTGRESQL], this._initTemplate);

		if (this.vendorId === this.CLOUD_DB_VENDOR.AMAZON) {
			engineList = [
				this.engines.MYSQL,
				this.engines.POSTGRESQL,
				this.engines.MARIADB,
				this.engines.AURORA_MYSQL,
				this.engines.AURORA_POSTGRESQL
			];
			//engineList.push(this.engines.OracleServer); // Need to add this back in SP25
			engineList.push(this.engines.SQLServer);
		} else if (this.vendorId === this.CLOUD_DB_VENDOR.AZURE_V2) {
			// database engines should be hidden for azure
		} else {
			engineList = [this.engines.MYSQL, this.engines.POSTGRESQL];
		}
		if (this.vendorId !== this.CLOUD_DB_VENDOR.AMAZON) {
			engineList.sort((a, b) => {
				return a.displayName.localeCompare(b.displayName);
			});
		}
		this.engineList = angular.copy(engineList);
	}

	_initTemplate(engineEntity) {
		let itemText = _.escape(_.get(engineEntity, 'displayName'));
		let tooltip = _.get(engineEntity, 'tooltip');

		if (!tooltip) {
			tooltip = itemText;
		}
		engineEntity.template = `
				<div class="isteven-html-content" title="${tooltip}">
							<div class="title ">${itemText}</div>
						</div>`;
	}

	error(e) {
		this.cvToaster.showErrorMessage({
			message: e
		});
	}
	engineSelectionChanged() {
		const selected = this._selectedEngines[0] || {};
		const changed = this.databaseEngine !== selected.key;
		this.databaseEngine = selected.key;
		if (changed) {
			this.onEngineChanged({ databaseEngine: selected });
		}
	}
}

cloudDbEngineSelectController.$inject = [
	'cvUtil',
	'AppTypes',
	'cvLoc',
	'cvToaster',
	'$scope',
	'CLOUD_DB_VENDOR',
	'CAPPS_CONSTANTS',
	'idaService'
];

const directive = function() {
	return {
		restrict: 'E',
		require: ['^^cvSubmit', '^^form'],
		templateUrl: appUtil.appRoot + 'modules/ida/partials/cv-cloud-db-engine-select.jsp',
		bindToController: {
			onEngineChanged: '&'
		},
		controller: cloudDbEngineSelectController,
		controllerAs: 'cdbEngine',
		link: function(scope, elem, attr, controllers) {
			scope.submitController = controllers[0];
			scope.formController = controllers[1];
		}
	};
};

allAgentMod.directive('cvCloudDbEngineSelect', directive);

export default allAgentMod;
