import { commonAllAgentsModule } from 'common/js/modules';

import 'modules/ida/js/services/postgresService.svc.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/directives/cv-client-picker.js';
import 'modules/ida/js/directives/cv-db-restore-to-disk-component.js';

var app = commonAllAgentsModule;

app.directive('cvSybaseRedirectPathComponent', [
	function() {
		var controller = [
			'$scope',
			'cvUtil',
			'$rootScope',
			'$uibModal',
			function($scope, cvUtil, $rootScope, $modal) {
				const self = this;
				self.$onInit = function() {
					self.initData = function() {
						if ($scope.deviceList.length > 0) {
							self.selecteDeviceDBItem = $scope.deviceList[0];
							self.selecteDeviceItem = $scope.deviceList[0].sybDevices[0];
						}
					};
					self.displayDbRestoreOptions = function(dbItem) {
						self.selecteDeviceDBItem = dbItem;
						self.selecteDeviceItem = dbItem.sybDevices[0];
					};
					self.displaySqlDeviceRestoreOptions = function(dbItem, deviceItem) {
						self.selecteDeviceDBItem = dbItem;
						self.selecteDeviceItem = deviceItem;
					};

					self.updateDeviceNames = function(deviceName) {
						//update all device names
						angular.forEach($scope.deviceList, function(selectedItem) {
							angular.forEach(selectedItem.sybDevices, function(device) {
								if (device.targetLogName === self.selecteDeviceItem.oldTargetLogName) {
									device.targetLogName = self.selecteDeviceItem.targetLogName;
									device.oldTargetLogName = self.selecteDeviceItem.targetLogName;
								}
							});
						});
						//update old device name with new
						self.selecteDeviceItem.oldTargetLogName = self.selecteDeviceItem.targetLogName;
					};

					self.showFindAndReplaceDialog = function() {
						const findAndReplaceCtrl = [
							'cvLoc',
							'$uibModalInstance',
							'$dialogs',
							function(cvLoc, $modalInstance, $dialogs) {
								const self = this;
								self.$onInit = function() {
									self.data = {
										findStr: '',
										replaceStr: '',
										findStrLabel: cvLoc('label.findSybase'),
										findStrError: cvLoc('error.findSybase')
									};

									self.closeDialogBox = function(result) {
										$modalInstance.close();
									};

									self.save = function() {
										var callBackFunctions = {
											noFunction: function() {},
											yesFunction: function() {
												$modalInstance.close(self.data);
											}
										};
										$dialogs.confirm(
											cvLoc('label.findAndReplace'),
											cvLoc(
												'label.frSybConfirmation',
												'<b>' + self.data.findStr + '</b>',
												'<b>' + self.data.replaceStr + '</b>'
											),
											callBackFunctions
										);
									};
								};
							}
						];

						const modelInsta = $modal.open({
							controller: findAndReplaceCtrl,
							controllerAs: 'fReplace',
							backdrop: 'static',
							templateUrl: appUtil.appRoot + 'modules/ida/partials/oracleRedirectFindAndReplace.jsp'
						});

						modelInsta.result.then(function(replaceOptions) {
							if (replaceOptions && replaceOptions.findStr && replaceOptions.replaceStr) {
								//Special handling to fix windows paths
								let oldPath = replaceOptions.findStr.replace(/\\/g, '\\\\');
								let newPath = replaceOptions.replaceStr;
								let oldPathRe = new RegExp(oldPath, 'g');
								//update all device paths
								angular.forEach($scope.deviceList, function(selectedItem) {
									angular.forEach(selectedItem.sybDevices, function(device) {
										if (device.phyName) {
											device.phyName = device.phyName.replace(oldPathRe, newPath);
										}
									});
								});
							}
						});
					};
				};
			}
		];

		return {
			restrict: 'E',
			scope: true,
			bindToController: {
				deviceList: '='
			},
			templateUrl: appUtil.appRoot + 'modules/ida/partials/sybaseRedirectPathTemplate.jsp',
			controller: controller,
			controllerAs: 'sybaseRedirectPaths'
		};
	}
]);

app.controller('sybaseRestoreController', [
	'$scope',
	'$log',
	'$uibModal',
	'$uibModalInstance',
	'$stateParams',
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'$filter',
	'idaService',
	'data',
	'agentService',
	'cvUtil',
	'mbService',
	'$dialogs',
	'cvTableOptions',
	'instanceService',
	function(
		$scope,
		$log,
		$modal,
		$modalInstance,
		$stateParams,
		cvToaster,
		cvLoc,
		AppTypes,
		$filter,
		idaService,
		data,
		agentService,
		cvUtil,
		mbService,
		$dialogs,
		cvTableOptions,
		instanceService
	) {
		const self = this;
		/** ** Exposed Functions *** */
		self.onTabChanged = onTabChanged;
		self.updateInstcesModel = updateInstcesModel;
		self.refreshServerStatus = refreshServerStatus;
		self.doRestore = doRestore;
		self.isDisableBrowse = () => _.get(self.restoreData, 'destinationClient.clientId', 0) <= 0;
		self.shouldDisableInstance = instanceId => instanceId === self.entity.instanceId;
		self.cancel = () => {
			$modalInstance.dismiss();
		};
		self.closeModal = result => {
			$modalInstance.close();
		};

		initData();

		/** ** Functions *** */
		function initData() {
			self.entity = data.entity;
			self.commCellId = 2;
			self.tabControls = {};
			self.serverStatus = cvLoc('status.DEFAULTMSG');
			self.localLang = cvUtil.getIStevenLocLabels();
			self.isRefreshEnabled = false;
			self.snapBackupEnabled = false;
			self.isSystemDbIncluded = isSystemDbIncluded(data.selectedRows);
			self.restoreData = {
				isRecover: true,
				sourceItem: [],
				pitDate: new Date(),
				pitSelectedDate: '',
				openDatePicker: false,
				hardwareRevert: false,
				destinationClients: [],
				destinationInstancesMap: new Map(),
				destinationInstances: [],
				uiRecoverDatabase: true, //to hold sybaseRecoverType flag
				uiCreateDevices: true, //to hold common option sybase create device flag'
				isRestoreToDisk: () => self.tabControls.getCurrentTabId() === '2',
				isInPlaceRestore: () => self.tabControls.getCurrentTabId() === '0',
				isOutOfPlaceRestore: () => self.tabControls.getCurrentTabId() === '1',
				sybaseRstOption: {
					sybaseDatabase: [],
					sybaseRecoverType: 0, // 0-> Recover       1 -> No recover
					restoreType: 1, // 0-> Step-by-step  1 -> Point-in-time
					renameDatabases: false,
					restoreOptions: false,
					isTableLevel: false,
					instanceRestore: data.isFullDataRestore, //special flag for instance selection
					pointofTime: false,
					refTime: {
						time: 0
					},
					fromTime: {
						time: 0
					},
					pointInTime: {
						time: 0
					},
					destinationServer: {}
				},
				proxyClient: {}
			};
			self.separator = String.fromCharCode(9);

			if (data.jobId && data.jobId > 0) {
				self.jobId = data.jobId;
			}

			if (data.toTime && data.toTime > 0) {
				let dateObject = new Date(parseInt(data.toTime) * 1000);
				self.restoreData.pitDate = cvUtil.convertUTCDateToLocalDate(dateObject);
				self.restoreData.sybaseRstOption.pointofTime = true;
			}

			self.previousTabId = '0';
			let backupSetId = _.get(self.entity, 'backupsetId', 0);
			//set default backupset if it is not present.
			if (backupSetId <= 0) {
				instanceService
					.getBackupsets(self.entity.clientId, self.entity.applicationId, self.entity.instanceId)
					.success(data => {
						if (data.length > 0) {
							_.set(self.entity, 'backupsetId', data[0].backupSetEntity.backupsetId);
							_.set(self.entity, 'backupsetName', data[0].backupSetEntity.backupsetName);
						}
					});
			}
			loadDestinationClientsAndInstances();
			loadDevices();
		}

		// check if source items has system db included for the restore job
		function isSystemDbIncluded(sourceItems) {
			let systemDbs = ['master', 'model', 'tempdb', 'sybsecurity', 'sybsystemdb', 'sybsystemprocs'];

			return sourceItems.filter(item => systemDbs.indexOf(_.get(item, 'label', '').toLowerCase()) > 0).length > 0;
		}

		function onTabChanged() {
			if (self.tabControls.getCurrentTabId() != self.previousTabId) {
				self.previousTabId = self.tabControls.getCurrentTabId();
				if (self.restoreData.isInPlaceRestore()) {
					self.restoreData.destinationClient = self.inplaceDestinationServer;
				} else {
					self.restoreData.destinationInstance = undefined;
				}
			}
		}

		function loadDestinationClientsAndInstances() {
			if (parseInt(data.entity.clientId) <= 0) {
				return;
			}
			self.osType = '';
			mbService.getOSType(data.entity.clientId).then(response => {
				self.osType = response.data;
				let sourceEntity = angular.copy(data.entity);
				let genericEntity = angular.toJson(sourceEntity);
				idaService.getRestoreDestinationsForEntity(genericEntity).then(
					result => {
						let serverList = [];
						let instancesMap = new Map();
						for (let i = 0; i < result.data.length; i++) {
							let client = {
								clientId: result.data[i].clientId,
								clientName: result.data[i].clientName,
								displayName: result.data[i].displayName
							};
							serverList.push(client);
							if (result.data[i].clientId === self.entity.clientId) {
								self.inplaceDestinationServer = client;
							}
						}
						self.restoreData.destinationClients = cvUtil.sortAscending(serverList, 'clientName');
						self.restoreData.destinationInstancesMap = instancesMap;
						//first time loading
						//self.updateInstcesModel(data.entity.clientId);
					},
					e => {
						$log.error(e);
					}
				);
			});
		}

		function loadDevices() {
			$scope.sybaseDevices = [];
			let selectedDatabases = [];
			angular.forEach(data.selectedRows, selectedItem => {
				selectedDatabases.push(selectedItem.userObject);
			});

			let params = {
				entity: angular.toJson(self.entity),
				sybaseDatabases: angular.toJson(selectedDatabases)
			};

			idaService.getSybaseRedirectData(params).then(
				result => {
					if (result.data && result.data.length > 0) {
						$scope.sybaseDevices = result.data;
						angular.forEach($scope.sybaseDevices, sybDBDevice => {
							//set targetDB with sourcedb
							sybDBDevice.dbItem.targetDB = sybDBDevice.dbItem.databaseName;
							angular.forEach(sybDBDevice.sybDevices, device => {
								device.targetLogName = device.logName;
								device.oldTargetLogName = device.logName;
							});
						});
						$scope.deviceList = $scope.sybaseDevices;

						/** For Each database get database chain and update the database with chain details * */
						angular.forEach($scope.sybaseDevices, sybDBDevice => {
							let db = [];
							db.push(sybDBDevice.dbItem);
							let dbParam = {
								entity: params.entity,
								sybaseDatabases: angular.toJson(db)
							};
							idaService.getSybaseChains(dbParam).then(
								dbResult => {
									if (dbResult.data) {
										//logID:type:unixtime
										sybDBDevice.dbItem.databaseChainType =
											dbResult.data.ID + self.separator + dbResult.data.name + self.separator + dbResult.data.unixTime;
										sybDBDevice.dbItem.logId = dbResult.data.ID;
									}
								},
								dbError => {
									$log.error(`Failed to load db chain for the database: ${sybDBDevice.dbItem.databaseName}`);
								}
							);
						});
					}
					self.serverMessage1 = cvUtil.emptyMsg();
				},
				error => {
					$log.error(`Failed to load sybase devices:  ${error}`);
					self.serverMessage1 = cvUtil.errMsg(error);
				}
			);
		}

		function updateInstcesModel(clientId) {
			if (parseInt(clientId) <= 0) {
				return;
			}
			self.restoreData.destinationInstances = [];
			//instance list for the client is already loaded
			if (self.restoreData.destinationInstancesMap.has(clientId)) {
				self.restoreData.destinationInstances = self.restoreData.destinationInstancesMap.get(clientId);
				if (instanceList.length > 0 && !instanceList[0].disabled) {
					self.restoreData.destinationInstance = instanceList[0];
				}
			} else {
				//instance list for the client is not loaded
				agentService
					.getInstances(clientId, AppTypes.CV_APPTYPE_SYBASE)
					.success(result => {
						let clientInstances = [];
						for (let i = 0; i < result.length; i++) {
							if (self.entity.instanceId === result[i].instance.instanceId) {
								result[i].instance.disabled = true;
							}
							clientInstances.push(result[i].instance);
						}
						let instanceList = cvUtil.sortAscending(clientInstances, 'instanceName');
						self.restoreData.destinationInstancesMap.set(clientId, instanceList);
						self.restoreData.destinationInstances = instanceList;
						if (instanceList.length > 0 && !instanceList[0].disabled) {
							self.restoreData.destinationInstance = instanceList[0];
						}
					})
					.error(err => {
						$log.error(e);
						self.restoreData.destinationInstancesMap.set(clientId, []);
					});
			}
		}

		function refreshServerStatus() {
			if (self.isRefreshEnabled) {
				self.serverStatus = cvLoc('Loading');
				let destinationInstance = self.entity;
				if (self.restoreData.isOutOfPlaceRestore() && self.restoreData.destinationInstance) {
					destinationInstance = self.restoreData.destinationInstance;
				}
				idaService
					.getSybaseServerStatus({ entity: angular.toJson(destinationInstance) })
					.success(data => {
						if (data && data.statusMessage) {
							self.serverStatus = data.statusMessage;
						} else {
							self.serverStatus = cvLoc('status.UNKNOWN');
						}
					})
					.error(errorReason => {
						self.serverStatus = cvLoc('status.UNKNOWN');
					});
			}
		}

		/*
		 * Show restore confirmation since data can be overwritten.
		 */
		function confirmRestore(destination, yesFunction) {
			// we include the sybase roles check message only if system db's are included in the restrore job
			let sybaseRolesCheckMessage = self.isSystemDbIncluded ? cvLoc('message.systemDbRestore') : '';
			let message = undefined;
			//For Full database restores or restore to disk we need to display confirmation message
			if (self.restoreData.sybaseRstOption.instanceRestore || self.restoreData.isRestoreToDisk()) {
				//default to in-place restore message
				message = cvLoc(
					'message.confirmSybaseRestoreInPlace',
					self.entity.clientName,
					self.entity.instanceName,
					sybaseRolesCheckMessage
				);
				if (self.restoreData.isOutOfPlaceRestore()) {
					message = cvLoc(
						'message.confirmSybaseRestoreOutOfPlace',
						self.entity.clientName,
						self.entity.instanceName,
						destination.destClient.clientName,
						destination.destinationInstance.instanceName,
						destination.destinationInstance.instanceName,
						sybaseRolesCheckMessage
					);
				}
				if (self.restoreData.isRestoreToDisk()) {
					message = cvLoc(
						'label.confirmRestoreToDisk',
						self.entity.clientName,
						self.entity.instanceName,
						self.restoreData.selectedClient.clientName,
						self.restoreData.path
					);
				}
			} else {
				message = self.isSystemDbIncluded ? sybaseRolesCheckMessage + ' ' + cvLoc('message.continue') : undefined;
			}

			// show confirmation dialog if message is set
			if (message) {
				$dialogs.confirm(cvLoc('label.confirm'), message, {
					yesFunction: yesFunction,
					noFunction: () => {}
				});
			} else {
				//For partial restores, do not show confirmation message
				yesFunction();
			}
		}

		function doRestore() {
			let genericEntity = angular.copy(data.entity);
			let browseOption = composeBrowseOption();
			let destination = composeDestination();
			let commonOptions = composeCommonOptions();
			let agentSpecificOptions = composeAgentSpecificOptions();
			let rdsOption = {};
			let sourceItems = getSourceItems();
			let impersonation = composeImpersonation();

			let params = {
				entityType: data.entityType,
				genericEntity: angular.toJson(genericEntity),
				browseOption: angular.toJson(browseOption),
				destination: angular.toJson(destination),
				commonOptions: angular.toJson(commonOptions),
				sourceItemsToRestore: angular.toJson(sourceItems),
				agentSpecificOptions: angular.toJson(agentSpecificOptions),
				rdsOption: angular.toJson(rdsOption),
				impersonation: angular.toJson(impersonation)
			};

			confirmRestore(destination, () => {
				idaService
					.submitRestoreJob(params)
					.success(result => {
						const msg = cvLoc('notification.restoreRequested', result);
						const viewMsg = cvLoc('notification.viewJobs');
						cvToaster.showInfoMessage({
							ttl: '10000',
							message: msg + ' <br><a href="#/jobs/' + result + '">' + viewMsg + '</a>'
						});
						self.cancel();
					})
					.error(err => {
						cvToaster.showErrorMessage({
							message: err
						});
					});
			});
		}

		function composeCommonOptions() {
			const commonOptions = {};
			if (self.restoreData.isRestoreToDisk()) {
				commonOptions.restoreToDisk = true;
				commonOptions.indexFreeRestore = true;
			} else {
				commonOptions.sybaseCreateDevices = self.restoreData.uiCreateDevices;
			}
			if (self.tabControls && self.tabControls.getCurrentTabId() === '0' && self.snapBackupEnabled) {
				commonOptions.revert = self.restoreData.hardwareRevert;
			}
			return commonOptions;
		}

		function composeImpersonation() {
			const impersonation = {};
			if (self.restoreData.isRestoreToDisk() && self.restoreData.useImpersonation) {
				_.set(impersonation, 'user.userName', self.restoreData.impersonateUserName);
				_.set(impersonation, 'user.password', cvUtil.getBytes(self.restoreData.impersonatePassword));
				_.set(impersonation, 'useImpersonation', true);
			}
			return impersonation;
		}

		function composeBrowseOption() {
			let browseOption = {
				commCellId: self.commCellId,
				timeRange: {
					fromTimeValue: null,
					toTimeValue: data.toTimeValue ? data.toTimeValue : null
				}
			};

			_.set(browseOption, 'backupset.clientId', self.entity.clientId);
			_.set(browseOption, 'backupset.backupsetId', self.entity.backupsetId);

			if (self.restoreData.proxyClient && self.restoreData.proxyClient.id) {
				let proxyForSnapClients = {
					clientId: self.restoreData.proxyClient.id,
					clientName: self.restoreData.proxyClient.name
				};
				_.set(browseOption, 'mediaOption.proxyForSnapClients', proxyForSnapClients);
			}

			return browseOption;
		}

		function composeDestination() {
			let destination = {};
			let destClient = {};
			let destinationInstance = {};

			if (self.restoreData.isInPlaceRestore()) {
				destClient = {
					clientId: self.entity.clientId,
					clientName: self.entity.clientName
				};
				destinationInstance = angular.copy(self.entity);
			} else if (self.restoreData.isOutOfPlaceRestore()) {
				destClient = angular.copy(self.restoreData.destinationClient);
				let selectedInstance = self.restoreData.destinationInstance;
				destinationInstance = {
					clientId: selectedInstance.clientId,
					clientName: selectedInstance.clientName,
					applicationId: selectedInstance.applicationId,
					instanceId: selectedInstance.instanceId,
					instanceName: selectedInstance.instanceName
				};
			} else if (self.restoreData.isRestoreToDisk()) {
				destClient = angular.copy(self.restoreData.selectedClient);
				let destPath = [];
				destPath.push(self.restoreData.path);
				destination.destPath = destPath;
			}
			destination.destClient = destClient;
			destination.destinationInstance = destinationInstance;
			return destination;
		}

		function getSybaseDatabases() {
			//compose sybase devices
			let sybaseDatabases = [];
			angular.forEach($scope.sybaseDevices, selectedItem => {
				let devicesValue = [];
				let devices = [];
				let isTargetDBupdated = false;
				let separator = String.fromCharCode(9);
				if (selectedItem.dbItem.databaseName != selectedItem.dbItem.targetDB) {
					isTargetDBupdated = true;
				}
				angular.forEach(selectedItem.sybDevices, device => {
					let deviceValueString =
						'' +
						selectedItem.dbItem.databaseId +
						separator +
						device.devId +
						separator +
						device.logName +
						separator +
						device.targetLogName +
						separator +
						device.phyName +
						separator +
						device.size +
						separator +
						(isTargetDBupdated ? selectedItem.dbItem.targetDB : '');
					devicesValue.push(deviceValueString);

					//if (isTargetDBupdated) {
					let deviceString =
						'' +
						selectedItem.dbItem.subclientId +
						':' +
						selectedItem.dbItem.databaseId +
						':' +
						device.devId +
						':' +
						device.logName +
						':' +
						device.targetLogName +
						':' +
						device.phyName +
						':' +
						device.size +
						':' +
						selectedItem.dbItem.targetDB;
					devices.push(deviceString);
					//}
				});

				let sybaseDatabase = {
					associatedSubClientId: selectedItem.dbItem.subclientId,
					systemDataBase: selectedItem.dbItem.options ? true : false,
					creationTimeInt: {
						time: selectedItem.dbItem.creationTime
					},
					databaseChain: [
						'' +
							selectedItem.dbItem.subclientId +
							':' +
							selectedItem.dbItem.databaseId +
							':' +
							selectedItem.dbItem.databaseName +
							':' +
							selectedItem.dbItem.logId
					],
					databaseId: {
						id: selectedItem.dbItem.databaseId,
						name: selectedItem.dbItem.databaseName
					},
					devicesValue: devicesValue,
					databaseChainType: selectedItem.dbItem.databaseChainType
				};
				sybaseDatabase.devices = devices;
				if (isTargetDBupdated) {
					//set rename flag
					self.restoreData.sybaseRstOption.renameDatabases = true;
				}

				sybaseDatabases.push(sybaseDatabase);
			});
			return sybaseDatabases;
		}

		function composeAgentSpecificOptions() {
			let agentSpecificOptions = {};

			if (self.restoreData.isInPlaceRestore() || self.restoreData.isOutOfPlaceRestore()) {
				// For in-place restores and For out-of-place restores
				self.restoreData.sybaseRstOption.sybaseDatabase = getSybaseDatabases();
				self.restoreData.sybaseRstOption.destinationServer.id = self.entity.instanceId;
				self.restoreData.sybaseRstOption.destinationServer.name = self.entity.instanceName;
				agentSpecificOptions = angular.copy(self.restoreData.sybaseRstOption);

				if (self.restoreData.sybaseRstOption.pointofTime) {
					const cvDate = new Object();
					const timeValue = cvUtil.formatDate(self.restoreData.pitDate, 'yyyy-MM-ddTHH:mm:ss', 'UTC');
					cvDate.timeValue = timeValue;
					agentSpecificOptions.pointInTime = cvDate;
					agentSpecificOptions.refTime = cvDate;
					agentSpecificOptions.pointOfTime = true;
				} else {
					agentSpecificOptions.pointOfTime = false;
				}
			}
			return agentSpecificOptions;
		}

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		function getSourceItems() {
			let sourceItems = [];
			const pathSeparator = '/'; //using same separator for both WINDOWS and UNIX
			if (
				self.restoreData.isRestoreToDisk() &&
				self.restoreData.selectedJobs &&
				self.restoreData.selectedJobs.length > 0
			) {
				angular.forEach(self.restoreData.selectedJobs, job => {
					sourceItems.push(self.commCellId + ':' + job.jobId);
				});
			} else {
				//populate databases in source items
				const databases = _.uniq(_.map($scope.sybaseDevices, 'dbItem.databaseName'));
				angular.forEach(databases, dbName => {
					sourceItems.push(pathSeparator + dbName);
				});
			}
			return sourceItems;
		}
	}
]);

export default app;
