import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/controllers/mySqlSubclientContent.ctrl.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/directives/cv-client-picker.js';

var app = commonAllAgentsModule;
app.controller('sybaseSubclientController', [
	'$uibModal',
	'$scope',
	'$log',
	'$state',
	'instanceService',
	'storageService',
	'subclientService',
	'cvLoc',
	'createSubclientParams',
	'cvTableOptions',
	'profileService',
	'cvUtil',
	'planPolicyModel',
	'associateSchedulePolicy',
	'idaService',
	function(
		$modal,
		$scope,
		$log,
		$state,
		instanceService,
		storageService,
		subclientService,
		cvLoc,
		createSubclientParams,
		cvTableOptions,
		profileService,
		cvUtil,
		planPolicyModel,
		associateSchedulePolicy,
		idaService
	) {
		var self = this;
		self.subclientInfo = {
			content: [],
			subClientEntity: {},
			storagePoliciesList: [],
			storagePolicy: null,
			agentInfo: {
				applicationId: 5,
				agentType: {
					backupsetSupported: false,
					instanceSupported: true
				}
			},
			numberBackupStreams: 2,
			numberOfTransactionLogStreams: 1,
			subclientTypeFlag: 0
		};
		self.instanceInfo = {};
		$scope.databaseList = [];
		self.subclientInfo.subClientEntity = angular.copy(createSubclientParams.idaEntity);
		self.subclientInfo.subClientEntity.subclientId = -1;
		self.subclientInfo.subClientEntity.subclientName = '';
		//set Default backupset Id
		instanceService
			.getBackupsets(
				self.subclientInfo.subClientEntity.clientId,
				self.subclientInfo.subClientEntity.applicationId,
				self.subclientInfo.subClientEntity.instanceId
			)
			.success(function(data) {
				if (data.length > 0) {
					self.subclientInfo.subClientEntity.backupsetId = data[0].backupSetEntity.backupsetId;
				}
			})
			.error(function(error) {
				cvToaster.showErrorMessage({
					ttl: '5000', //5 sec
					message: error
				});
			});

		self.planPolicyModel = planPolicyModel.get('Default');
		self.planPolicyModel.plan = {
			selected: _.get(createSubclientParams, 'subclientDetails.planEntity', null)
		};

		let genericEntity = {
			instanceId: self.subclientInfo.subClientEntity.instanceId,
			applicationId: self.subclientInfo.subClientEntity.applicationId,
			clientId: self.subclientInfo.subClientEntity.clientId
		};
		self.serverMessage1 = cvUtil.infoMsgLoc('Loading');
		idaService
			.getDbContentList(angular.toJson(genericEntity))
			.success(function(data) {
				if (data && data.length > 0) {
					data.forEach(function(sybaseDbContent) {
						//Add only not assigned databases
						let isAssignedDb = sybaseDbContent.subclientId && sybaseDbContent.subclientId > 0;
						if (!isAssignedDb) {
							$scope.databaseList.push({
								sybaseContent: {
									databaseName: sybaseDbContent.databaseName
								}
							});
						}
					});
				}
				self.serverMessage1 = cvUtil.emptyMsg();
			})
			.error(function(errorReason) {
				$log.debug('Cannot load Discovered Databases: ' + errorReason);
				self.serverMessage1 = cvUtil.errMsg(errorReason);
			});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			cvPageLinks: [],
			data: 'databaseList',
			enableGridMenu: false,
			showGridFooter: true,
			enableRowSelection: true,
			enableSelectAll: true,
			multiSelect: true,
			paginationPageSize: 10,
			selectionRowHeaderWidth: '10%',
			columnDefs: [
				{
					field: 'sybaseContent.databaseName',
					displayName: cvLoc('label.name'),
					enableFiltering: false,
					cellTemplate:
						'<span class="crop" title="{{row.entity.sybaseContent.databaseName}}">{{row.entity.sybaseContent.databaseName}}</span>',
					sort: {
						direction: 'asc',
						priority: 0
					},
					width: '90%'
				}
			],
			onRegisterApi: function(gridApi) {
				gridApi.selection.enableVerticalScrollbar = 0;

				gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
					angular.forEach(rows, function(row) {
						if (row.visible) {
							row.entity.isSelected = row.isSelected;
						}
					});
				});

				gridApi.selection.on.rowSelectionChanged($scope, function(row) {
					row.entity.isSelected = row.isSelected;
				});

				gridApi.grid.registerRowsProcessor(function(renderableRows) {
					renderableRows.forEach(function(row) {
						if (row.entity.isSelected) {
							row.isSelected = true;
						}
					});
					return renderableRows;
				}, 200);
			}
		});

		$scope.gridOptions = {
			cvGridTitle: cvLoc('pageHeader.databases'),
			cvIsPageTitle: false,
			cvTableName: 'addContent',
			cvIsSearchable: true,
			cvSearchFields: ['sybaseContent.databaseName'],
			cvServerMessage: 'addContentMessage',
			cvHasViews: false,
			cvGridDirectives: {
				uiGridSelection: true
			},
			cvGridCssClass: {
				'bottom-border-last-child': true,
				'top-bottom-border': true
			},
			cvOnGridEmpty: cvUtil.errMsg(cvLoc('label.MySqlNoDatabasesDiscovered')),
			gridOptions: globalGridOptions
		};

		self.createSubclient = function() {
			let showPlan = planPolicyModel.getPlanModeState();
			self.serverMessage = {
				message: '',
				type: ''
			};
			$log.log('Creating new subclient.');
			if (showPlan) {
				self.planPolicyModel.plan.showError = false;
			}
			self.planPolicyModel.storagePolicy.showError = false;
			var storageDevice = new Object();
			if (showPlan) {
				if (self.planPolicyModel.plan.selected == null) {
					self.planPolicyModel.plan.showError = true;
					return;
				}
				self.subclientInfo.selectedPlan = self.planPolicyModel.plan.selected.id;
			} else {
				if (self.planPolicyModel.storagePolicy.selected == null) {
					self.planPolicyModel.storagePolicy.showError = true;
					return;
				}
				storageDevice.dataBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
			}

			/** Populate content */
			angular.forEach($scope.databaseList, function(entity) {
				if (entity.isSelected) {
					self.subclientInfo.content.push(entity.sybaseContent);
				}
			});

			var content = self.subclientInfo.content;
			self.contentRequired = false;
			if (content == undefined || content.length == 0) {
				self.contentRequired = true;
				self.serverMessage1 = cvUtil.errMsg(cvLoc('error.subclient_does_not_have_content'));
				return;
			}

			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;
			subPropInfo.content = [];
			subPropInfo.contentOperationType = 1;

			var sybaseSubclientProp = new Object();
			sybaseSubclientProp.numberOfBackupStreams = self.subclientInfo.numberBackupStreams;
			sybaseSubclientProp.numberOfTransactionLogStreams = self.subclientInfo.numberOfTransactionLogStreams;
			subPropInfo.sybaseSubclientProp = sybaseSubclientProp;

			subPropInfo.planEntity = {
				planId: self.subclientInfo.selectedPlan
			};
			var subClientEntity = self.subclientInfo.subClientEntity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			subclientService
				.createSubclient({
					subClientEntity: scEntity,
					subclientInfo: subInfo,
					content: JSON.stringify(content),
					planId: null
				})
				.success(function(data) {
					self.associateScheduleToSubclient(data, showPlan);
					$state.forceReload();
					self.closeModal();
				})
				.error(function(e) {
					self.serverMessage1 = {
						message: e,
						type: 'error'
					};
				});
		};

		self.associateScheduleToSubclient = function(data, showPlan) {
			if (!showPlan) {
				/* association obj */
				let subclientDetails = {
					appId: self.subclientInfo.subClientEntity.applicationId,
					clientId: self.subclientInfo.subClientEntity.clientId,
					subclientId: data
				};
				let schedules = self.planPolicyModel.schedulePolicy;
				if (schedules && schedules.selected) {
					associateSchedulePolicy
						.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
						.success(function(successData) {
							$state.forceReload();
							self.closeModal();
						})
						.error(function(errorMessage) {
							self.serverMessage1 = {
								message: errorMessage,
								type: 'error'
							};
						});
				}
			} else {
				$state.forceReload();
				self.closeModal();
			}
		};

		self.cancel = function() {
			$scope.$close();
		};

		self.closeModal = function(result) {
			$scope.$close();
		};
	}
]);

export default app;
