import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/controllers/sqlAgent.ctrl.js';
import 'modules/ida/js/directives/cv-storage-config.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'ebs/js/controllers/ebsApps.ctrl.js';
import 'modules/ida/js/controllers/appMigration.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';
import 'adminConsole/js/controllers/agents.ctrl.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';
import 'modules/ida/js/directives/cv-client-picker.js';
import 'sql/js/factory/sqlServer.fac.js';

var app = commonAllAgentsModule;

app.directive('cvSqlRedirectPathComponent', [
	function() {
		var controller = [
			'$scope',
			'cvUtil',
			'storageService',
			'sqlService',
			'$rootScope',
			function($scope, cvUtil, storageService, sqlService, $rootScope) {
				var self = this;
				self.initData = function(entity, selectedDBs) {
					loadData(entity, selectedDBs);
				};
				self.displaySqlDeviceRestoreOptions = function(sqlDbdeviceItem) {
					self.selecteDeviceItem = sqlDbdeviceItem;
				};

				self.updateDeviceList = function() {
					var seperator = String.fromCharCode(9);
					var seperator12 = String.fromCharCode(0x12);

					var deviceInfoList = [];
					var deviceList = [];

					for (var i = 0; i < self.sqlDbDeviceItems.length; i++) {
						var temp = self.sqlDbDeviceItems[i];
						var tempOrig = self.sqlDbDeviceItemsOriginal[i];

						var deviceInfoStr =
							temp.sqlDBInfo.databaseId +
							seperator +
							temp.sqlDBInfo.databaseName +
							seperator +
							temp.id +
							seperator +
							' ' +
							seperator + //device name
							temp.physicalFilePath +
							'\\' +
							temp.physicalFileName +
							seperator +
							temp.logicalFileName +
							seperator +
							temp.fileMaxSize +
							seperator +
							tempOrig.sqlDBInfo.databaseName +
							seperator;

						deviceInfoList.push(deviceInfoStr);

						var deviceStr =
							tempOrig.sqlDBInfo.databaseName +
							seperator12 +
							temp.sqlDBInfo.databaseName +
							seperator12 +
							tempOrig.logicalFileName +
							seperator12 +
							temp.physicalFilePath +
							'\\' +
							temp.physicalFileName +
							seperator12 +
							tempOrig.physicalFilePath +
							'\\' +
							tempOrig.physicalFileName;

						deviceList.push(deviceStr);
					}

					var returnData = {
						device: deviceList,
						deviceInfo: deviceInfoList
					};
					return returnData;
				};

				var loadData = function(entity, selectedDBs) {
					var sourceItems = [];
					selectedDBs.forEach(function(entity) {
						if (entity.isSelected) {
							sourceItems.push(entity);
						}
					});
					var params = {
						instanceId: entity.instanceId,
						sourceItems: angular.toJson(sourceItems)
					};

					sqlService.getSQLServerRestoreOptions(params).success(function(sqlRestoreOptions) {
						self.sqlDbDeviceItems = sqlRestoreOptions.sqlDbdeviceItem;
						for (var i = 0; i < self.sqlDbDeviceItems.length; i++) {
							var physicalPath = self.sqlDbDeviceItems[i].fileName;
							var lastIndex = physicalPath.lastIndexOf('\\');
							self.sqlDbDeviceItems[i].physicalFilePath = physicalPath.substr(0, lastIndex);
							self.sqlDbDeviceItems[i].physicalFileName = physicalPath.substr(lastIndex + 1);
						}
						self.selecteDeviceItem = sqlRestoreOptions.sqlDbdeviceItem[0];
						self.sqlDbDeviceItemsOriginal = angular.copy(self.sqlDbDeviceItems);
					});
				};
			}
		];

		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/ida/partials/sqlRedirectPathTemplate.jsp',
			controller: controller,
			controllerAs: 'redPaths'
		};
	}
]);

app.controller('sqlCreateSubclientCtrl', [
	'$scope',
	'$log',
	'storageService',
	'idaService',
	'profileService',
	'$state',
	'cvLoc',
	'cvUtil',
	'data',
	'cvTableOptions',
	'associateSchedulePolicy',
	'planPolicyModel',
	function(
		$scope,
		$log,
		storageService,
		idaService,
		profileService,
		$state,
		cvLoc,
		cvUtil,
		data,
		cvTableOptions,
		associateSchedulePolicy,
		planPolicyModel
	) {
		$scope.subclientInfo = {
			selectedPlan: null,
			content: [],
			commonProperties: {
				description: '',
				enableBackup: true,
				storageDevice: {
					dataBackupStoragePolicy: null,
					logBackupStoragePolicy: null,
					softwareCompression: 0,
					networkAgents: 2,
					applicableReadSize: 2048
				}
			},
			mssqlSubClientProp: {
				sqlSubclientType: 1,
				numberOfBackupStreams: 2,
				numberOfTransactionLogStreams: 2,
				backupRules: 3,
				blockSize: 65536,
				bufferCount: 20,
				maxTransferSize: 2097152
			}
		};

		//$scope.removeFromSubclientContent = sqlServerSubclientContentFactory.removeContentFromList;
		$scope.subclientEntity = angular.copy(data.entity);
		$scope.subclientEntity.subclientName = '';

		$scope.planPolicyModel = planPolicyModel.get('Default');
		$scope.showPlan = cv.sessionContext.showPlans;
		$scope.subclientContentList = [];
		idaService
			.getSQLDiscoveredDatabases($scope.subclientEntity.clientId, $scope.subclientEntity.instanceId)
			.success(function(data) {
				$scope.databases = data;
			})
			.error(function(errorReason) {
				$log.debug('Cannot load Discovered Databases: ' + errorReason);
				$scope.serverMessage = cvUtil.errMsg(errorReason);
				//$timeout(clearServerMessage, errorMessageTimeout);
			});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'databases',
			enableGridMenu: false,
			enableRowSelection: true,
			enableSelectAll: true,
			multiSelect: true,
			selectionRowHeaderWidth: '10%',
			columnDefs: [
				{
					field: 'databaseName',
					displayName: cvLoc('label.DatabaseName'),
					enableFiltering: false,
					cellTemplate: '<div class="crop" title="{{row.entity.databaseName}}">{{row.entity.databaseName}}</div>',
					sort: {
						direction: 'asc',
						priority: 0
					},
					width: '90%'
				}
			],
			onRegisterApi: function(gridApi) {
				gridApi.selection.enableVerticalScrollbar = 0;

				gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
					angular.forEach(rows, function(row) {
						if (row.visible) {
							row.entity.isSelected = row.isSelected;
						}
					});
				});

				gridApi.selection.on.rowSelectionChanged($scope, function(row) {
					row.entity.isSelected = row.isSelected;
				});

				gridApi.grid.registerRowsProcessor(function(renderableRows) {
					renderableRows.forEach(function(row) {
						if (row.entity.isSelected) {
							row.isSelected = true;
						}
					});
					return renderableRows;
				}, 200);
			}
		});

		$scope.gridOptions = {
			cvHasTitle: false,
			cvTableName: 'addContent',
			cvIsSearchable: true,
			cvSearchFields: ['databaseName'],
			cvServerMessage: 'addContentMessage',
			cvHasViews: false,
			cvGridDirectives: {
				uiGridSelection: true,
				uiGridPagination: false
			},
			cvGridCssClass: {
				'bottom-border-last-child': true,
				'full-height': true,
				'top-bottom-border': true
			},
			cvShowSelectedOption: true,
			cvOnGridEmpty: cvUtil.errMsg(cvLoc('label.noDatabasesDiscovered')),
			gridOptions: globalGridOptions
		};

		$scope.createSubclient = function() {
			let showPlan = planPolicyModel.getPlanModeState();
			if ($scope.databases.length > 0) {
				$scope.databases.forEach(function(mssqlDbContent) {
					if (mssqlDbContent.isSelected) {
						$scope.subclientInfo.content.push({
							mssqlDbContent: {
								databaseId: mssqlDbContent.databaseId,
								databaseName: mssqlDbContent.databaseName
							},
							discovered: true
						});
					}
				});
			}
			if (isFormValid(showPlan)) {
				if (showPlan) {
					var selectedPlan = $scope.planPolicyModel.plan.selected;
					if (selectedPlan == null) {
						$scope.planPolicyModel.plan.showError = true;
						return;
					}
					$scope.subclientInfo.planEntity = {
						planId: selectedPlan.id
					};
					$scope.planPolicyModel.plan.showError = false;
				} else {
					$scope.subclientInfo.commonProperties.storageDevice.dataBackupStoragePolicy = {};
					$scope.subclientInfo.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId =
						$scope.planPolicyModel.storagePolicy.selected.id;
					$scope.subclientInfo.commonProperties.storageDevice.logBackupStoragePolicy = {};
					$scope.subclientInfo.commonProperties.storageDevice.logBackupStoragePolicy.storagePolicyId =
						$scope.planPolicyModel.storagePolicy.selected.id;
				}
				$scope.serverMessage = cvUtil.emptyMsg();
				$log.log('Creating new subclient.');
				let subClientRequestObj = {
					subClientEntity: angular.toJson($scope.subclientEntity),
					subclientInfo: angular.toJson($scope.subclientInfo),
					content: ''
				};
				if (showPlan) {
					subClientRequestObj.planId = selectedPlan.id;
				}
				idaService
					.createSubclient(subClientRequestObj)
					.success(function(data) {
						if (!showPlan) {
							/* association obj */
							let subclientDetails = {
								appId: $scope.subclientEntity.applicationId,
								clientId: $scope.subclientEntity.clientId,
								subclientId: data
							};
							let schedules = $scope.planPolicyModel.schedulePolicy;
							if (schedules && schedules.selected) {
								associateSchedulePolicy
									.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
									.success(function(successData) {
										$state.forceReload();
										$scope.closeModal();
										//sqlServerSubclientContentFactory.contentEntityList = [];
									})
									.error(function(errorMessage) {
										$log.error(errorMessage);
									});
							}
						} else {
							$state.forceReload();
							$scope.closeModal();
						}
					})
					.error(function(errorMessage) {
						$scope.serverMessage = cvUtil.errMsg(errorMessage);
					});
			}
		};

		$scope.closeModal = function() {
			$scope.$close();
		};

		var isFormValid = function(showPlan) {
			let schedulePolicy = $scope.planPolicyModel.schedulePolicy;
			let storagePolicy = $scope.planPolicyModel.storagePolicy;
			//assign data storage policy as log storage policy
			//let logStoragePolicy = $scope.planPolicyModel.logStoragePolicy;
			//if (($scope.subclientEntity.subclientName.trim().length == 0) || (!showPlan && (storagePolicy.selected.id == null)) || (!showPlan && (logStoragePolicy.selected.id == null)) || (showPlan && ($scope.planPolicyModel.plan.selected == null || $scope.planPolicyModel.plan.selected.id == null))) {
			if (
				$scope.subclientEntity.subclientName.trim().length == 0 ||
				(!showPlan && storagePolicy.selected.id == null) ||
				(showPlan && ($scope.planPolicyModel.plan.selected == null || $scope.planPolicyModel.plan.selected.id == null))
			) {
				if ($scope.subclientEntity.subclientName.trim().length == 0) {
					$scope.validationStatusFlags.subclientNameRequired = true;
				}
				if (showPlan) {
					if ($scope.planPolicyModel.plan.selected == null || $scope.planPolicyModel.plan.selected.id == null) {
						$scope.planPolicyModel.plan.showError = true;
					}
				} else {
					if (storagePolicy.selected == null || storagePolicy.selected.id == null) {
						storagePolicy.showError = true;
					}
					// if (logStoragePolicy.selected == null || logStoragePolicy.selected.id == null) {
					//     logStoragePolicy.showError = true;
					// }
					if (!schedulePolicy || (schedulePolicy.selected && schedulePolicy.selected.length == 0)) {
						schedulePolicy.showError = true;
					}
				}

				return false;
			}
			if ($scope.subclientInfo.content.length == 0) {
				$scope.serverMessage = cvUtil.errMsg(cvLoc('error.subclient_does_not_have_content'));
				return false;
			}
			return true;
		};

		var clearServerMessage = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
		};

		var clearValidationFlags = function() {
			let showPlan = planPolicyModel.getPlanModeState();
			$scope.validationStatusFlags.subclientNameRequired = false;
			$scope.planPolicyModel.storagePolicy.showError = false;
			//$scope.planPolicyModel.logStoragePolicy.showError = false;
			if (showPlan) {
				$scope.planPolicyModel.plan.showError = false;
			}
		};

		$scope.validationStatusFlags = {
			subclientNameRequired: false,
			dataStoragePolicyRequired: false,
			//'logStoragePolicyRequired': false,
			planRequired: false
		};
	}
]);

app.controller('sqlUpdateSubclientContentCtrl', [
	'$scope',
	'$stateParams',
	'idaService',
	'sqlService',
	'$location',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$log',
	'cvTableOptions',
	'$uibModal',
	'cvUtil',
	'$filter',
	'data',
	'LIST_OPERATION_TYPES',
	'$dialogs',
	'uiGridConstants',
	'$timeout',
	function(
		$scope,
		$stateParams,
		idaService,
		sqlService,
		$location,
		$modalInstance,
		$state,
		cvLoc,
		$log,
		cvTableOptions,
		$modal,
		cvUtil,
		$filter,
		params,
		LIST_OPERATION_TYPES,
		$dialogs,
		uiGridConstants,
		$timeout
	) {
		$scope.forNewSubclientCreation = params.createSubclient;
		$scope.subclientDetails = params.subclientDetails;
		$scope.entity = $scope.subclientDetails.subClientEntity;

		$scope.databaseList = [];
		$scope.excludeContentList = [];
		$scope.showFilterTab = true;
		$scope.tabControls = {};
		$scope.previousTabId = 0;

		const extractSubclientContent = function(contentListFromServer) {
			for (let index = 0; index < contentListFromServer.length; index++) {
				if (contentListFromServer[index].excludePath) {
					$scope.excludeContentList.push(contentListFromServer[index]);
				} else if (contentListFromServer[index].mssqlDbContent) {
					$scope.databaseList.push(contentListFromServer[index]);
				}
			}
		};

		const refresh = function() {
			$timeout(function() {
				$scope.gridOptions.gridOptions.data = $scope.databaseList;
				$scope.exclusionsGridOptions.gridOptions.data = $scope.excludeContentList;
			}, 10);
		};

		$scope.onTabSelected = function() {
			if ($scope.previousTabId != $scope.tabControls.getCurrentTabId()) {
				$scope.previousTabId = $scope.tabControls.getCurrentTabId();
				refresh();
			}
		};

		idaService
			.getSubClientDetails($stateParams.subclientId)
			.success(function(data) {
				if (data.content && data.content.length > 0) {
					$scope.subclientContent = data.content;
					extractSubclientContent($scope.subclientContent);
					refresh();

					$scope.databaseList.map(function(data) {
						data.selected = true;
					});
				}
				$scope.originalDatabaseList = angular.copy($scope.databaseList);
				sqlService
					.getSQLDiscoveredDatabases($scope.entity.clientId, $scope.entity.instanceId)
					.success(function(data) {
						if (data.length > 0) {
							data.forEach(function(mssqlDbContent) {
								$scope.databaseList.push({
									mssqlDbContent: {
										databaseId: mssqlDbContent.databaseId,
										databaseName: mssqlDbContent.databaseName
									}
								});
							});
						}
						$scope.editContentMessage = cvUtil.emptyMsg();
					})
					.error(function(errorReason) {
						$log.debug('Cannot load Discovered Databases: ' + errorReason);
						$scope.editContentMessage = cvUtil.errMsg(errorReason);
					});
			})
			.error(function(data) {
				$log.error('Error loading subclient detail');
			});
		//$scope.databaseList = subclientInfo.content || [];

		$scope.editContentMessage = cvUtil.infoMsgLoc('Loading');

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'databaseList',
			enableGridMenu: false,
			showGridFooter: true,
			enableRowSelection: true,
			enableSelectAll: true,
			multiSelect: true,
			selectionRowHeaderWidth: '10%',
			enableColumnResizing: true,
			columnDefs: [
				{
					field: 'mssqlDbContent.databaseName',
					displayName: cvLoc('label.DatabaseName'),
					enableFiltering: false,
					cellTemplate:
						'<span class="crop" title="{{row.entity.mssqlDbContent.databaseName}}">{{row.entity.mssqlDbContent.databaseName}}</span>',
					sort: {
						direction: 'asc',
						priority: 0
					},
					width: '90%'
				}
			],
			onRegisterApi: function(gridApi) {
				gridApi.selection.enableVerticalScrollbar = 0;

				gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
					angular.forEach(rows, function(row) {
						if (row.visible) {
							row.entity.selected = row.isSelected;
						}
					});
				});
				gridApi.grid.rows.forEach(function(row) {
					if (row.entity.selected) {
						row.isSelected = true;
					}
				});
				gridApi.selection.on.rowSelectionChanged($scope, function(row) {
					row.entity.selected = row.isSelected;
				});
				gridApi.grid.registerRowsProcessor(function(renderableRows) {
					renderableRows.forEach(function(row) {
						if (row.entity.selected) {
							row.isSelected = true;
						}
					});
					return renderableRows;
				}, 200);
			}
		});

		$scope.gridOptions = {
			cvHasTitle: false,
			cvTableName: 'updateSQLSubclientContent',
			cvHasViews: false,
			cvEnableHidingFilters: false,
			cvIsSearchable: true,
			cvGridDirectives: {
				uiGridSelection: true
			},
			cvGridCssClass: {
				'bottom-border-last-child': true,
				'top-bottom-border': true
			},
			cvSearchFields: ['mssqlDbContent.databaseName'],
			cvShowSelectedOption: true,
			gridOptions: globalGridOptions
		};

		$scope.model = {
			excludePattern: ''
		};

		const columns = [
			{
				field: 'excludePath',
				sort: {
					direction: 'asc',
					priority: 0
				},
				displayName: cvLoc('label.sqlFilters'),
				cellTemplate: '<span title="{{row.entity.excludePath}}">{{row.entity.excludePath}}</span>',
				width: '80%'
			},
			{
				name: 'actionMenu',
				enableSorting: false,
				displayName: '',
				cellTemplate:
					'<span title="' +
					cvLoc('label.remove') +
					'"><a data-ng-click="grid.appScope.removeExcludePattern(row.entity)"><i class="glyphicon glyphicon-remove"></i></a></span>',
				width: '20%'
			}
		];

		const excludeGlobalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(excludeGlobalGridOptions, {
			data: 'excludeContentList',
			enableGridMenu: false,
			columnDefs: columns,
			onRegisterApi: function(gridApi) {
				$scope.gridApi = gridApi;

				$scope.refreshExcludeGrid = function() {
					gridApi.core.notifyDataChange(uiGridConstants.dataChange.ALL);
				};
			}
		});

		$scope.exclusionsGridOptions = {
			cvHasTitle: false,
			cvTableName: 'namePatternExclusions',
			cvIsSearchable: false,
			cvHasViews: false,
			cvGridCssClass: {
				'modal-grid': true
			},
			cvOnGridEmpty: {
				message: cvLoc('error.noFiltersAdded')
			},
			gridOptions: excludeGlobalGridOptions
		};

		$scope.removeExcludePattern = function(entity) {
			const index = $scope.excludeContentList.findIndex(obj => obj.excludePath == entity.excludePath);
			$scope.excludeContentList.splice(index, 1);

			$scope.refreshExcludeGrid();
		};

		$scope.addExcludePattern = function() {
			if ($scope.model.excludePattern.length == 0) return;

			const tempExcludeContent = {
				excludePath: $scope.model.excludePattern
			};

			const isDuplicateEntity = $scope.excludeContentList.some(function(curr) {
				return curr.excludePath == tempExcludeContent.excludePath;
			});

			if (!isDuplicateEntity) {
				$scope.excludeContentList.push(tempExcludeContent);
				$scope.refreshExcludeGrid();
			} else {
				$dialogs.notify(cvLoc('heading.warning'), cvLoc('label.duplicateEntry'));
				return;
			}

			$scope.model.excludePattern = '';
		};

		$scope.modifySubclientContent = function() {
			var subclientContent = [];
			var contentOperationType = LIST_OPERATION_TYPES.OVERWRITE;
			var excludeContentOperationType = LIST_OPERATION_TYPES.OVERWRITE;
			$scope.databaseList.map(function(data) {
				if (data.selected) {
					subclientContent.push(data);
				}
			});
			if (subclientContent.length == 0) {
				if ($scope.subclientDetails.commonProperties.isDefaultSubclient) {
					contentOperationType = LIST_OPERATION_TYPES.DELETE;
					$scope.subclientContent = [];
				} else {
					$scope.editContentMessage = cvUtil.errMsg(cvLoc('error.subclient_does_not_have_content'));
					return;
				}
			}
			$scope.excludeContentList.map(function(data) {
				subclientContent.push(data);
			});
			if ($scope.excludeContentList.length == 0) {
				excludeContentOperationType = LIST_OPERATION_TYPES.CLEAR;
				subclientContent = subclientContent || [];
			}
			idaService
				.updateSubclient({
					subClientEntity: angular.toJson($scope.entity),
					contentInJson: '',
					subclientInfo: angular.toJson({
						content: subclientContent,
						contentOperationType: contentOperationType,
						fsExcludeFilterOperationType: excludeContentOperationType
					})
				})
				.success(function(data) {
					if (data) {
						$log.debug('Subclient content modified');
						$state.forceReload();
						$scope.closeModal();
					} else {
						$log.debug('Failure in content modification. No response received');
						$scope.editContentMessage = cvUtil.errMsg(cvLoc('generic_error'));
					}
				})
				.error(function(errorReason) {
					$log.error('update Subclient content operation failed:' + errorReason);
					$scope.editContentMessage = cvUtil.errMsg(errorReason);
				});
		};

		$scope.closeModal = function(subclientContent) {
			$log.debug('manage subclient content modal closed');
			if (subclientContent != null) {
				$modalInstance.close(subclientContent);
			} else {
				$modalInstance.close();
			}
		};
	}
]);
app.controller('sqlCreateInstanceCtrl', [
	'$scope',
	'storageService',
	'idaService',
	'sqlService',
	'$state',
	'$uibModalInstance',
	'$log',
	'cvLoc',
	'cvUtil',
	'data',
	'idasFactory',
	'profileService',
	'AppTypes',
	function(
		$scope,
		storageService,
		idaService,
		sqlService,
		$state,
		$modalInstance,
		$log,
		cvLoc,
		cvUtil,
		data,
		idasFactory,
		profileService,
		AppTypes
	) {
		$scope.serverMessage = {
			message: '',
			type: ''
		};
		const clearServerMessage = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
		};
		$scope.localLang = cvUtil.getIStevenLocLabels();

		$scope.addInstance = false;
		$scope.isAzure = false;
		$scope.isAmazon = false;
		$scope.instanceDetails = data.instanceDetails;
		$scope.selectedProfileList = [];

		if (data.editDialog && data.editDialog === 'Add_Instance') {
			//$scope.addInstance will always be boolean, $scope.editDialog could be string.
			//so use $scope.addInstance instead if want to check if creating a new instance
			$scope.addInstance = true;
			$scope.editDialog = false;
			$scope.clientSelection = {
				selectedClients: [],
				valideClientSelection: false,
				selectionChanged: function(clientEntity) {
					clearServerMessage();
					loadSqlInstances(clientEntity.clientId);
					loadClientProps(clientEntity.clientId);
				}
			};
		} else {
			$scope.editDialog = data.editDialog;
			$scope.instanceDetails = data.instanceDetails;
		}

		$scope.passwordPlaceholder = $scope.addInstance ? '' : cvLoc('label.leaveAzureSecretKeyBlank');

		if ($scope.editDialog) {
			$scope.instancePlanEntity = _.get($scope.instanceDetails, 'planEntity');
			if ($scope.instancePlanEntity && $scope.instancePlanEntity.planId && $scope.instancePlanEntity.planId > 0) {
				$scope.hasInstancePlan = true;
			}
			$scope.openAccordion = true;
		} else {
			$scope.openAccordion = false;
		}

		$scope.tabControls = {}; //will get the references for the functions in cvTabsetComponent directive
		//available functions are: selectTab(), getCurrentTabId(), getTabCount()

		$scope.inputAlertFlags = {
			instanceName: false,
			dataStoragePolicy: false,
			logStoragePolicy: false,
			username: false,
			password: false,
			plan: false
		}; //these flags are required for validation of those inputs

		//data will contain the IdaEntity
		$scope.sqlserverInfo = {
			clientId: data.idaEntity.clientId,
			clientName: data.idaEntity.clientName,
			applicationId: data.idaEntity.applicationId,
			instanceName: '',
			vdiTimeOut: 300,
			useVss: '',
			description: '',
			overrideGlobalAuthentication: false,
			useLocalSystemAccount: '1',
			username: '',
			password: '',
			availableStoragePolicies: {},
			associatedDBStoragePolicyId: null,
			associatedDBStoragePolicyName: null,
			associatedLogStoragePolicyId: null,
			associatedLogStoragePolicyName: null,
			cloudUserName: null,
			selectedPlan: null
		};

		$scope.openCloudDbDialog = function() {
			$modalInstance.close();
			idasFactory.createCloudDatabase();
		};

		$scope.servers = {
			selectedUnconfiguredServer: {}
		};

		if ($scope.editDialog) {
			$scope.sqlserverInfo.instanceName = $scope.instanceDetails.instance.instanceName;
			$scope.sqlserverInfo.username =
				$scope.instanceDetails.mssqlInstance.overrideHigherLevelSettings.userAccount.userName;
			$scope.sqlserverInfo.overrideGlobalAuthentication =
				$scope.instanceDetails.mssqlInstance.overrideHigherLevelSettings.overrideGlobalAuthentication;
			$scope.sqlserverInfo.useLocalSystemAccount =
				$scope.instanceDetails.mssqlInstance.overrideHigherLevelSettings.useLocalSystemAccount === false ? '2' : '1';
			//$scope.sqlserverInfo.
		} else {
			$scope.instanceDetails = {
				instance: data.idaEntity,
				mssqlInstance: {
					overrideHigherLevelSettings: {
						overrideGlobalAuthentication: false,
						userAccount: {}
					}
				}
			};
		}

		storageService.getStoragePoliciesList().success(function(data) {
			$scope.sqlserverInfo.availableStoragePolicies = data;
		});

		$scope.unconfiguredServers;
		$scope.instanceLoaded = false;
		$scope.servers.selectedUnconfiguredServer = '';
		$scope.profileList = [];

		var loadClientProps = function(clientId) {
			idaService.getClientDetails(clientId).then(function(clientDetails) {
				var clientType = _.get(
					clientDetails.data,
					'pseudoClientInfo.virtualServerClientProperties.virtualServerInstanceInfo.vsInstanceType'
				);
				$scope.isAzure = false;
				$scope.isAmazon = false;
				if (clientType && (clientType === 'AZURE' || clientType === 'AZURE_V2')) {
					$scope.isAzure = true;
				} else if (clientType && clientType === 'AMAZON') {
					$scope.isAmazon = true;
				}
			});
		};
		var loadSqlInstances = function(clientId) {
			if ($scope.previousSelectedClientId === clientId) return;
			else {
				$scope.previousSelectedClientId = clientId;
			}
			$scope.serverMessage = cvUtil.emptyMsg();
			$scope.servers.selectedUnconfiguredServer = cvLoc('loading'); //to clear the dropdown
			$scope.unconfiguredServers = null;
			$scope.instanceLoaded = false;
			sqlService
				.getUnconfiguredServers(clientId)
				.success(function(data) {
					$scope.servers.selectedUnconfiguredServer = '';
					$scope.instanceLoaded = true;
					$scope.unconfiguredServers = data;
					if (data.length === 0) {
						$scope.serverMessage = {
							message: cvLoc('error.noInstances'),
							type: 'error'
						};
					}
				})
				.error(function(errorReason) {
					$scope.servers.selectedUnconfiguredServer = '';
					$scope.instanceLoaded = true;
					$scope.serverMessage = {
						message: errorReason,
						type: 'error'
					};
				});
		};

		if (data.editDialog === false && !$scope.addInstance) {
			loadSqlInstances(data.idaEntity.clientId);
			loadClientProps(data.idaEntity.clientId);
			$scope.previousSelectedClientId = data.idaEntity.clientId;
		}

		$scope.loadLibraries = function() {
			profileService
				.getEligiblePlansForApp(AppTypes.SQL_SERVER)
				.success(function(data) {
					$scope.serverMessage = cvUtil.emptyMsg();
					if (data.length > 0) {
						let planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							const planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							if (planListByTypes[planObj.type]) {
								planListByTypes[planObj.type].push(planObj);
							} else {
								planListByTypes[planObj.type] = [planObj];
							}
						});

						for (let planType in planListByTypes) {
							$scope.profileList.push({
								name: planType,
								msGroup: true
							});
							let plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
							$scope.profileList = $scope.profileList.concat(plansByType);
							$scope.profileList.push({
								msGroup: false
							});
						}

						if ($scope.hasInstancePlan) {
							planSelectonUpdate($scope.instancePlanEntity, $scope.profileList);
						}
					}
				})
				.error(function(e) {
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};

		const planSelectonUpdate = function(selectedPlan, profileList) {
			for (let planTypeNode in profileList) {
				let planNode = profileList[planTypeNode];
				if (planNode && planNode.type) {
					if (selectedPlan.planId === planNode.id) {
						planNode.selected = true;
					} else {
						planNode.selected = false;
					}
				}
			}
		};

		$scope.loadLibraries();

		$scope.closeModal = function() {
			$modalInstance.close();
		};

		$scope.getStoragePolicyId = function(StoragePolicyName) {
			var length = $scope.sqlserverInfo.availableStoragePolicies.length;
			for (var i = 0; i < length; i++) {
				if ($scope.sqlserverInfo.availableStoragePolicies[i].storagePolicyName == StoragePolicyName) {
					return $scope.sqlserverInfo.availableStoragePolicies[i].storagePolicyId;
				}
			}
		};

		$scope.planChanged = function() {
			if ($scope.selectedProfileList && $scope.selectedProfileList.length > 0) {
				$scope.sqlserverInfo.selectedPlan = $scope.selectedProfileList[0];
				$scope.inputAlertFlags.plan = false;
			}
		};

		$scope.passwordChanged = function() {
			$scope.inputAlertFlags.password = false;
			$scope.isPasswordChanged = true;
		};

		$scope.userNameChanged = function() {
			$scope.inputAlertFlags.username = false;
			$scope.passwordPlaceholder = '';
			$scope.sqlserverInfo.password = '';
			$scope.isPasswordChanged = true;
		};

		var validateNecessaryInputs = function() {
			$scope.inputAlertFlags.instanceName = false;
			if (
				($scope.editDialog && !$scope.sqlserverInfo.instanceName) ||
				(!$scope.editDialog && !$scope.servers.selectedUnconfiguredServer.servername)
			) {
				$scope.inputAlertFlags.instanceName = true;
				return false;
			}

			if ($scope.addInstance && !$scope.sqlserverInfo.selectedPlan) {
				$scope.inputAlertFlags.plan = true;
				return false;
			}
			if ($scope.sqlserverInfo.useLocalSystemAccount == '2') {
				if (!$scope.sqlserverInfo.username || !$scope.sqlserverInfo.password) {
					if (!$scope.sqlserverInfo.username) {
						$scope.inputAlertFlags.username = true;
						return false;
					}
					if (($scope.addInstance || $scope.isPasswordChanged) && !$scope.sqlserverInfo.password) {
						$scope.inputAlertFlags.password = true;
						return false;
					}
				}
			}
			return true;
		};

		$scope.createSqlServerInstance = function() {
			if (validateNecessaryInputs() == true) {
				$log.debug('Submitting sql server info');
				var instanceDetails = $scope.instanceDetails;
				if (!$scope.editDialog) {
					instanceDetails.instance.instanceName = $scope.servers.selectedUnconfiguredServer.servername;
					instanceDetails.mssqlInstance.serverType = $scope.servers.selectedUnconfiguredServer.serverType;
					instanceDetails.version = $scope.servers.selectedUnconfiguredServer.fullversion;
				}
				var password = null;
				instanceDetails.mssqlInstance.overrideHigherLevelSettings.overrideGlobalAuthentication =
					$scope.sqlserverInfo.overrideGlobalAuthentication;

				if ($scope.sqlserverInfo.overrideGlobalAuthentication) {
					if ($scope.sqlserverInfo.useLocalSystemAccount == '1') {
						instanceDetails.mssqlInstance.overrideHigherLevelSettings.userAccount = {};
						instanceDetails.mssqlInstance.overrideHigherLevelSettings.useLocalSystemAccount = 'true';
					} else {
						instanceDetails.mssqlInstance.overrideHigherLevelSettings.useLocalSystemAccount = 'false';
						if ($scope.sqlserverInfo.password != null) {
							password = $scope.sqlserverInfo.password;
							instanceDetails.mssqlInstance.overrideHigherLevelSettings.userAccount.password = null;
							instanceDetails.mssqlInstance.overrideHigherLevelSettings.userAccount.userName =
								$scope.sqlserverInfo.username;
						}
					}
				}

				if ($scope.sqlserverInfo.selectedPlan) {
					instanceDetails.planEntity = { planId: $scope.sqlserverInfo.selectedPlan.id };
				}

				if ($scope.isAzure) {
					var azureInfo = {
						azureStorageConnectionString: $scope.sqlserverInfo.azureStorageConnectionString,
						azureSqlInstanceCredentials: {
							userName: $scope.sqlserverInfo.cloudUserName,
							password: cvUtil.getBytes($scope.sqlserverInfo.cloudPassword)
						}
					};
					instanceDetails.mssqlInstance.overrideHigherSettings = true;
					instanceDetails.mssqlInstance.azureInfo = azureInfo;
				} else if ($scope.isAmazon) {
					var awsSqlInfo = {
						s3BucketName: $scope.sqlserverInfo.s3BucketName,
						sqlInstanceCredentials: {
							userName: $scope.sqlserverInfo.cloudUserName,
							password: cvUtil.getBytes($scope.sqlserverInfo.cloudPassword)
						}
					};
					instanceDetails.mssqlInstance.overwriteAwsHigherLevelSettings = true;
					instanceDetails.mssqlInstance.awsSqlInfo = awsSqlInfo;
				}

				//In case of add instance dialog check for the client selection validation
				if ($scope.addInstance) {
					if (!$scope.clientSelection.valideClientSelection) {
						return;
					}
					if ($scope.clientSelection.selectedClients) {
						instanceDetails.instance.clientName = $scope.clientSelection.selectedClients[0].clientName;
						instanceDetails.instance.clientId = $scope.clientSelection.selectedClients[0].clientId;
					}
				}

				var instanceInfo = {
					version: instanceDetails.version,
					instanceEntity: angular.toJson(instanceDetails.instance),
					instanceProps: angular.toJson(instanceDetails),
					password: password
				};

				idaService
					.createInstance(instanceInfo, $scope.editDialog)
					.success(function(successData) {
						$modalInstance.close();
						$state.forceReload();
					})
					.error(function(errorReason) {
						$scope.serverMessage = {
							message: errorReason,
							type: 'error'
						};
					});
			}
		};
	}
]);

app.controller('sqlRestoreOptionsCtrl', [
	'$scope',
	'$log',
	'idaService',
	'sqlService',
	'cvToaster',
	'cvLoc',
	'$uibModal',
	'$uibModalInstance',
	'$filter',
	'data',
	'mbService',
	'cvUtil',
	'agentFactory',
	'clientService',
	'sqlServerFactory',
	function(
		$scope,
		$log,
		idaService,
		sqlService,
		cvToaster,
		cvLoc,
		$modal,
		$modalInstance,
		$filter,
		data,
		mbService,
		cvUtil,
		agentFactory,
		clientService,
		sqlServerFactory
	) {
		//we give an option to restore this VM if we have a guid
		$scope.restoreData = {
			globalOptions: {}
		};
		if (!data.toTime || data.toTime == 0) {
			var utcCurrent = cvUtil.getUTCDate(new Date());
			data.toTimeValue = $filter('date')(utcCurrent, 'yyyy-MM-ddTHH:mm:ss');
			data.toTime = utcCurrent.getTime() / 1000;
		}
		//selectedEntity
		$scope.entity = data.entity;
		$scope.entityType = data.entityType;
		$scope.selectedRows = data.selectedRows;
		$scope.serverDetails = {};
		var applicationId;

		$scope.restoreData.globalOptions.sqlDbDeviceItems = [];
		$scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal = [];
		$scope.restoreData.globalOptions.selectedSqlDbdeviceItem = null;
		$scope.restoreData.globalOptions.destinationServerList = [];
		$scope.restoreData.globalOptions.destinationServer = null;
		$scope.restoreData.globalOptions.proxyClientList = [];
		$scope.restoreData.globalOptions.proxyClient = null;
		$scope.restoreData.globalOptions.stagingServerList = [];
		$scope.restoreData.globalOptions.stagingServer = null;
		$scope.restoreData.globalOptions.destinationEntity = null;
		$scope.restoreData.globalOptions.targetDbName = null;
		$scope.restoreData.globalOptions.controlfile = true;
		$scope.restoreData.globalOptions.database = true;
		$scope.restoreData.globalOptions.pitType = '0';

		/*
		 * var loadDestinationServerList = function() {
		 *
		 * idaService.getRestoreDestinations( $scope.entity.clientId,
		 * $scope.entity.applicationId).then(function(data) { for (var i = 0; i <
		 * data.data.length; i++) {
		 * $scope.restoreData.globalOptions.destinationServerList.push(data.data[i]); } },
		 * function(e) { $log.error(e); }); }; loadDestinationServerList();
		 */

		var sourceItems = [];
		angular.forEach($scope.selectedRows, function(selectedItemFromSelectionArray, key) {
			sourceItems.push(selectedItemFromSelectionArray.userObject);
		});
		var params = {
			instanceId: $scope.entity.instanceId,
			sourceItems: angular.toJson(sourceItems)
		};

		$scope.separator = '\\';
		mbService.getOSType($scope.entity.clientId).then(
			function successCallBack(response) {
				if (response && response.data) {
					$scope.separator = response.data.toLowerCase() == 'unix' ? '/' : '\\';
				}
				sqlService.getSQLServerRestoreOptions(params).success(function(sqlRestoreOptions) {
					$scope.restoreData.globalOptions.sqlDbDeviceItems = sqlRestoreOptions.sqlDbdeviceItem;
					for (var i = 0; i < $scope.restoreData.globalOptions.sqlDbDeviceItems.length; i++) {
						var physicalPath = $scope.restoreData.globalOptions.sqlDbDeviceItems[i].fileName;
						var lastIndex = physicalPath.lastIndexOf($scope.separator);
						$scope.restoreData.globalOptions.sqlDbDeviceItems[i].physicalFilePath = physicalPath.substr(0, lastIndex);
						$scope.restoreData.globalOptions.sqlDbDeviceItems[i].physicalFileName = physicalPath.substr(lastIndex + 1);
					}
					//$scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal = sqlRestoreOptions.sqlDbdeviceItem;
					$scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal = angular.copy(sqlRestoreOptions.sqlDbdeviceItem);

					if (
						$scope.restoreData.globalOptions.sqlDbDeviceItems &&
						$scope.restoreData.globalOptions.sqlDbDeviceItems.length > 0
					) {
						$scope.restoreData.globalOptions.selectedSqlDbdeviceItem =
							$scope.restoreData.globalOptions.sqlDbDeviceItems[0];
					}

					for (var i = 0; i < sqlRestoreOptions.sqlDestinationInstances.length; i++) {
						$scope.restoreData.globalOptions.destinationServerList.push(
							sqlRestoreOptions.sqlDestinationInstances[i].genericEntity
						);
						if (sqlRestoreOptions.sqlDestinationInstances[i].genericEntity.instanceId == $scope.entity.instanceId) {
							$scope.restoreData.globalOptions.destinationServer =
								sqlRestoreOptions.sqlDestinationInstances[i].genericEntity;
							$scope.restoreData.globalOptions.destinationEntity = $scope.entity;
						}
					}
					//only now $scope.restoreData.globalOptions.destinationEntity is set and then checkDestClientProp can be called inside checkSrcInstanceProp
					checkSrcInstanceProp($scope.entity.instanceId);
				});
			},
			function(errorReason) {
				cvToaster.showErrorMessage({
					message: errorReason != undefined ? errorReason : cvLoc('generic_error')
				});
			}
		);

		$scope.cancelModel = function() {
			$modalInstance.close();
		};

		$scope.displaySqlDeviceRestoreOptions = function(sqlDbdeviceItem) {
			$scope.restoreData.globalOptions.selectedSqlDbdeviceItem = sqlDbdeviceItem;
		};

		var getBrowseDestinationModal = function() {
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			if (!$scope.restoreData.globalOptions.destinationServer) {
				$scope.serverMessage = {
					message: cvLoc('error.destinationServer'),
					type: 'error'
				};
				return;
			}
			var clientId = $scope.restoreData.globalOptions.destinationServer.clientId;
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							clientId: clientId,
							foldersOnly: true
						};
					}
				}
			});
			return modalInstance;
		};

		$scope.stagingPath = {
			value: '',
			label: cvLoc('label.stagingPathDest'),
			error: cvLoc('error.stagingPathDestClient')
		};

		$scope.isSrcSqlCloudInstance = false;
		$scope.isDestSqlCloudInstance = false;
		$scope.isDestVirtual = false;
		$scope.isSourceSqlAzureInstance = false;
		$scope.isDestSqlAzureInstance = false;

		var checkSrcInstanceProp = function(instanceId) {
			idaService
				.getInstanceDetails(instanceId)
				.success(function(data) {
					if (data) {
						$scope.instanceDetails = data;
						$scope.entity = $scope.instanceDetails.instance;
						$scope.isSourceSqlAzureInstance = sqlServerFactory.isAzureInstance(
							$scope.instanceDetails.mssqlInstance.serverType
						);
						$scope.isSrcSqlCloudInstance = sqlServerFactory.isCloudInstance(
							$scope.instanceDetails.mssqlInstance.serverType
						);
						$scope.isDestSqlCloudInstance = $scope.isSrcSqlCloudInstance;
						if ($scope.isDestSqlCloudInstance) {
							checkDestClientProp(); //actually it's check source client prop since default dest is source
						} else {
							$scope.isDestVirtual = false;
							updateDestServerMessageString();
						}
						if ($scope.isSrcSqlCloudInstance) {
							for (var i = 0; i < $scope.restoreData.globalOptions.sqlDbDeviceItems.length; i++) {
								$scope.restoreData.globalOptions.sqlDbDeviceItems[i].physicalFilePath = '';
							}
						}
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		var formatProxies = function(memberServers) {
			$scope.restoreData.globalOptions.proxyClientList = [];
			for (var x = 0; x < memberServers.length; x++) {
				$scope.restoreData.globalOptions.proxyClientList.push({
					clientName: memberServers[x].client.clientName,
					clientId: memberServers[x].client.clientId,
					_type_: 'CLIENT_ENTITY'
				});
			}
		};

		var checkDestInstanceProp = function(instanceId) {
			$scope.loadingInstanceDetails = true;
			idaService
				.getInstanceDetails(instanceId)
				.success(function(data) {
					if (data) {
						var destInstanceDetails = data;
						$scope.isDestSqlAzureInstance = sqlServerFactory.isAzureInstance(
							destInstanceDetails.mssqlInstance.serverType
						);
						$scope.isDestSqlCloudInstance = sqlServerFactory.isCloudInstance(
							destInstanceDetails.mssqlInstance.serverType
						);
						$scope.restoreData.globalOptions.destinationEntity = destInstanceDetails.instance;
						if ($scope.isDestSqlCloudInstance) {
							checkDestClientProp();
						} else {
							$scope.isDestVirtual = false;
							updateDestServerMessageString();
						}
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				})
				.then(
					function() {
						$scope.loadingInstanceDetails = false;
					},
					function() {
						$scope.loadingInstanceDetails = false;
					}
				);
		};

		var checkDestClientProp = function() {
			clientService
				.getClientDetails($scope.restoreData.globalOptions.destinationEntity.clientId)
				.success(function(data) {
					if (data && data.pseudoClientInfo) {
						var vendorType =
							data.pseudoClientInfo.virtualServerClientProperties.virtualServerInstanceInfo.vsInstanceType;
						$scope.isDestVirtual = vendorType != null && vendorType != '' && vendorType != 'NONE';
						if ($scope.isDestVirtual) {
							agentFactory
								.getAgentDetails(
									$scope.restoreData.globalOptions.destinationEntity.clientId,
									$scope.restoreData.globalOptions.destinationEntity.applicationId
								)
								.then(function() {
									if (
										agentFactory.agentDetail != null &&
										agentFactory.agentDetail.sql61Prop.proxies.memberServers != null
									)
										formatProxies(agentFactory.agentDetail.sql61Prop.proxies.memberServers);
									$scope.restoreData.globalOptions.proxyClient = $scope.restoreData.globalOptions.proxyClientList[0];
									if (!$scope.isSourceSqlAzureInstance && $scope.isDestSqlAzureInstance) {
										populateStagingServers($scope.restoreData.globalOptions.proxyClient.clientId);
									}
								});
						} else {
							if (!$scope.isSourceSqlAzureInstance && $scope.isDestSqlAzureInstance) {
								populateStagingServers($scope.restoreData.globalOptions.destinationEntity.clientId);
							}
						}
					}
					updateDestServerMessageString();
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		var updateDestServerMessageString = function() {
			if ($scope.isDestVirtual) {
				$scope.stagingPath.label = cvLoc('label.stagingPathProxy');
				$scope.stagingPath.error = cvLoc('error.stagingPathProxyClient');
			} else {
				$scope.stagingPath.label = cvLoc('label.stagingPathDest');
				$scope.stagingPath.error = cvLoc('error.stagingPathDestClient');
			}
		};

		$scope.browsePhysicalPath = function(subClientEntity) {
			var modalInstance = getBrowseDestinationModal();
			if (modalInstance) {
				modalInstance.result.then(
					function(result) {
						$log.debug('Destination path selected: ' + result.path);
						$scope.restoreData.globalOptions.selectedSqlDbdeviceItem.physicalFilePath = result.path;
					},
					function() {
						$log.debug('Cancel clicked');
					}
				);
			}
		};

		//--For File System. It will do machine browse for the selected destination client--//
		$scope.openSelectDestinationFolder = function(subClientEntity) {
			var modalInstance = getBrowseDestinationModal();
			if (modalInstance) {
				modalInstance.result.then(
					function(result) {
						$log.debug('Destination path selected: ' + result.path);
						$scope.restoreData.globalOptions.selectedPath = result.path;
					},
					function() {
						$log.debug('Cancel clicked');
					}
				);
			}
		};

		$scope.destinationServerChanged = function(destinationServer) {
			checkDestInstanceProp(destinationServer.instanceId);
			getDestinationOsType(destinationServer.clientId);
		};

		$scope.proxyClientChanged = function(proxyClient) {
			if (!$scope.isSourceSqlAzureInstance && $scope.isDestSqlAzureInstance) {
				populateStagingServers(proxyClient.clientId);
			}
		};

		var populateStagingServers = function(clientId) {
			$scope.restoreData.globalOptions.stagingServerList = [];

			clientService
				.getInstancesForAppType(clientId, 81)
				.success(function(data) {
					if (data && data.length > 0) {
						$scope.restoreData.globalOptions.stagingServerList = data;
						$scope.restoreData.globalOptions.stagingServer = $scope.restoreData.globalOptions.stagingServerList[0];
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		$scope.separatorDest = '\\';
		var getDestinationOsType = function(clientId) {
			mbService.getOSType(clientId).then(
				function successCallBack(response) {
					if (response && response.data) {
						$scope.separatorDest = response.data.toLowerCase() == 'unix' ? '/' : '\\';
					}
				},
				function(errorReason) {
					cvToaster.showErrorMessage({
						message: errorReason != undefined ? errorReason : cvLoc('generic_error')
					});
				}
			);
		};

		$scope.stagingPathResultFunction = function(result) {
			$log.debug('Staging path selected: ' + result.path);
			$scope.stagingPath.value = result.path;
		};

		$scope.changeAllDatabaseNames = function(newDbName) {
			var selectedDataFileLogicalName = $scope.restoreData.globalOptions.selectedSqlDbdeviceItem.logicalFileName;
			var originalDbId;
			for (var i = 0; i < $scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal.length; i++) {
				if (
					selectedDataFileLogicalName === $scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal[i].logicalFileName
				) {
					originalDbId = $scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal[i].sqlDBInfo.databaseId;
					break;
				}
			}
			for (var i = 0; i < $scope.restoreData.globalOptions.sqlDbDeviceItems.length; i++) {
				if ($scope.restoreData.globalOptions.sqlDbDeviceItems[i].sqlDBInfo.databaseId === originalDbId) {
					$scope.restoreData.globalOptions.sqlDbDeviceItems[i].sqlDBInfo.databaseName = newDbName;
				}
			}
		};

		var validateRestoreInputs = function() {
			if ($scope.isDestSqlCloudInstance) {
				return true;
			}
			for (var i = 0; i < $scope.restoreData.globalOptions.sqlDbDeviceItems.length; i++) {
				if (
					!$scope.restoreData.globalOptions.sqlDbDeviceItems[i].physicalFilePath ||
					$scope.restoreData.globalOptions.sqlDbDeviceItems[i].physicalFilePath === ''
				) {
					$scope.displaySqlDeviceRestoreOptions($scope.restoreData.globalOptions.sqlDbDeviceItems[i]);
					return false;
				}
			}
			return true;
		};

		$scope.doRestore = function() {
			if (validateRestoreInputs() == true) {
				var browseOption = composeBrowseOption();
				var destination = composeDestination();
				var commonOptions = {}; //composeCommonOptions();
				var agentSpecificOptions = composeAgentSpecificOptions();
				idaService
					.submitRestoreJob({
						entityType: $scope.entityType,
						genericEntity: angular.toJson($scope.entity),
						browseOption: angular.toJson(browseOption),
						destination: angular.toJson(destination),
						commonOptions: angular.toJson(commonOptions),
						sourceItemsToRestore: angular.toJson(getSourceItems()),
						agentSpecificOptions: angular.toJson(agentSpecificOptions)
					})
					.success(function(data) {
						var msg = cvLoc('notification.restoreRequested', data);
						var viewMsg = cvLoc('notification.viewJobs');
						cvToaster.showInfoMessage({
							ttl: '10000',
							message:
								msg +
								' <br><a href="#/jobs?serverId=' +
								$scope.entity.clientId +
								'&serverName=' +
								$scope.entity.clientName +
								'">' +
								viewMsg +
								'</a>'
						});
						$scope.cancelModel();
					})
					.error(function(err) {
						cvToaster.showErrorMessage({
							message: err
						});
					});
			}
			return;
		};

		var composeBrowseOption = function() {
			var browseOption = {
				commCellId: 2,
				listMedia: false,
				useExactIndex: false,
				noImage: false,
				mediaOption: {
					copyPrecedence: {
						copyPrecedenceApplicable: false
					}
				},
				timeRange: {
					fromTimeValue: data.fromTimeValue ? data.fromTimeValue : null,
					toTimeValue: data.toTimeValue ? data.toTimeValue : null
				},
				backupset: {
					clientId: $scope.entity.clientId,
					backupsetId: $scope.entity.backupsetId
				}
			};

			if (data.jobId) {
				browseOption.browseJobId = data.jobId;
			}

			return browseOption;
		};

		var composeDestination = function() {
			var destination = {};

			//sql restoreToDisk is defined in agentSpecificOptions.restoreToDiskPath
			destination.inPlace = $scope.restoreData.globalOptions.restoreToOriginalPath;

			destination.destClient = {
				clientId: $scope.restoreData.globalOptions.destinationEntity.clientId,
				clientName: $scope.restoreData.globalOptions.destinationEntity.clientName,
				_type_: $scope.restoreData.globalOptions.destinationEntity._type_
			};
			destination.destinationInstance = {
				appName: $scope.restoreData.globalOptions.destinationEntity.appName,
				clientName: $scope.restoreData.globalOptions.destinationEntity.clientName,
				instanceName: $scope.restoreData.globalOptions.destinationEntity.instanceName,
				clientId: $scope.restoreData.globalOptions.destinationEntity.clientId,
				instanceId: $scope.restoreData.globalOptions.destinationEntity.instanceId,
				applicationId: $scope.restoreData.globalOptions.destinationEntity.applicationId
			};

			return destination;
		};

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		var getSourceItems = function() {
			var sourceItems = [];
			angular.forEach($scope.selectedRows, function(selectedItemFromSelectionArray, key) {
				sourceItems.push(selectedItemFromSelectionArray.userObject.databaseName);
			});
			return sourceItems;
		};

		var composeAgentSpecificOptions = function() {
			var agentSpecificOptions = {};

			agentSpecificOptions.overWrite = !!$scope.restoreData.globalOptions.overwrite;
			agentSpecificOptions.dropConnectionsToDatabase = $scope.restoreData.globalOptions.dropConnections;

			if ($scope.stagingPath.value && $scope.stagingPath.value.length > 0) {
				agentSpecificOptions.snapOopStageFolder = $scope.stagingPath.value;
			}

			if ($scope.restoreData.globalOptions.selectedPath && $scope.restoreData.globalOptions.selectedPath.length > 0) {
				agentSpecificOptions.restoreToDisk = true;
				agentSpecificOptions.restoreToDiskPath = $scope.restoreData.globalOptions.selectedPath;
			}

			if ($scope.isDestSqlCloudInstance && $scope.isDestVirtual)
				agentSpecificOptions.proxyClient = $scope.restoreData.globalOptions.proxyClient;

			if (!$scope.isSourceSqlAzureInstance && $scope.isDestSqlAzureInstance)
				agentSpecificOptions.stagingInstance = $scope.restoreData.globalOptions.stagingServer;

			if (
				$scope.restoreData.globalOptions.sqlDbDeviceItems &&
				$scope.restoreData.globalOptions.sqlDbDeviceItems.length > 0
			) {
				var seperator = String.fromCharCode(9);
				var seperator12 = String.fromCharCode(0x12);

				var deviceInfoList = [];
				var deviceList = [];

				for (var i = 0; i < $scope.restoreData.globalOptions.sqlDbDeviceItems.length; i++) {
					var temp = $scope.restoreData.globalOptions.sqlDbDeviceItems[i];
					var tempOrig = $scope.restoreData.globalOptions.sqlDbDeviceItemsOriginal[i];

					let destFilePath = temp.physicalFilePath;
					if (
						$scope.restoreData.globalOptions.selectedPath &&
						$scope.restoreData.globalOptions.selectedPath.length > 0
					) {
						destFilePath = $scope.restoreData.globalOptions.selectedPath;
					}

					var deviceInfoStr =
						temp.sqlDBInfo.databaseId +
						seperator +
						temp.sqlDBInfo.databaseName +
						seperator +
						temp.id +
						seperator +
						' ' +
						seperator + //device name
						destFilePath +
						$scope.separatorDest +
						temp.physicalFileName +
						seperator +
						temp.logicalFileName +
						seperator +
						temp.fileMaxSize +
						seperator +
						tempOrig.sqlDBInfo.databaseName +
						seperator;

					deviceInfoList.push(deviceInfoStr);

					var deviceStr =
						tempOrig.sqlDBInfo.databaseName +
						seperator12 +
						temp.sqlDBInfo.databaseName +
						seperator12 +
						tempOrig.logicalFileName +
						seperator12 +
						destFilePath +
						$scope.separatorDest +
						temp.physicalFileName +
						seperator12 +
						tempOrig.physicalFilePath +
						$scope.separatorDest +
						tempOrig.physicalFileName;

					deviceList.push(deviceStr);
				}

				agentSpecificOptions.device = deviceList;
				agentSpecificOptions.deviceInfo = deviceInfoList;

				return agentSpecificOptions;
			}
		};
	}
]);
app.controller('sqlBackupOptionsCtrl', [
	'$q',
	'$rootScope',
	'$scope',
	'$location',
	'idaService',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$log',
	'$uibModalStack',
	'data',
	'cvToaster',
	function(
		$q,
		$rootScope,
		$scope,
		$location,
		idaService,
		$modalInstance,
		$state,
		cvLoc,
		$log,
		$modalStack,
		data,
		cvToaster
	) {
		$scope.entityType = data.entityType;
		$scope.genericEntity = data.entity;
		$scope.selectedDBsList = _.get(data, 'otherOptions.selectedDBsList', null);
		$scope.isMultiDBBackup = _.get(data, 'otherOptions.isMultiDBBackup', false);
		$scope.isCloudDBSelected = _.get(data, 'otherOptions.isCloudDBSelected', false);
		$scope.isSnapEnabled = _.get(data, 'otherOptions.isSnapEnabled', false);
		$scope.backupType = 'FULL';
		$scope.showTransactionLogOption = false;
		$scope.showDifferentialOption = false;
		$scope.isSyntheticFullSupported = false;
		var deferred = data.deferred;

		var checkSrcInstanceProp = function() {
			return idaService
				.getInstanceDetails($scope.genericEntity.instanceId)
				.success(function(data) {
					if (data && data.mssqlInstance) {
						//serverType is null for AG, have to show TL and diff as well
						if (!data.mssqlInstance.serverType || data.mssqlInstance.serverType === 'DataBase Engine') {
							$scope.showTransactionLogOption = true;
							$scope.showDifferentialOption = true;
						}
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		var getClientDetails = function() {
			return idaService.getClientDetails($scope.genericEntity.clientId).then(function(data) {
				$scope.clientDetails = data.data;
			});
		};

		var getSubclientDetails = function() {
			return idaService.getSubClientDetails($scope.genericEntity.subclientId).success(function(data) {
				$scope.subclientDetails = data;
			});
		};

		if ($scope.isMultiDBBackup) {
			if (!$scope.isCloudDBSelected) {
				$scope.showTransactionLogOption = true;
				if ($scope.isSnapEnabled == 0 || $scope.isSnapEnabled == false) {
					$scope.showDifferentialOption = true;
				}
			}
		} else {
			getClientDetails()
				.then(function() {
					return checkSrcInstanceProp();
				})
				.then(function() {
					return getSubclientDetails();
				})
				.then(function() {
					if ($scope.subclientDetails && $scope.subclientDetails.mssqlSubClientProp) {
						$scope.isSyntheticFullSupported =
							$scope.clientDetails.clientProps.isQsnapInstalled === 2 &&
							$scope.subclientDetails.mssqlSubClientProp.blockLevelBackup === 1;
						//We don't support DIFFERENTIAL job for Snap or Block level
						$scope.showDifferentialOption &=
							!$scope.subclientDetails.commonProperties.snapCopyInfo.isSnapBackupEnabled &&
							!$scope.subclientDetails.mssqlSubClientProp.useBlockLevelBackupWithOptimizedRecovery;
					}
				})
				.catch(function(errorMessage) {
					$scope.serverMessage = cvUtil.errMsg(errorMessage);
					$log.error(error);
				});
		}

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		$scope.closeModal = function(resp) {
			deferred.resolve(resp);
			$modalInstance.dismiss();
		};

		$scope.failAndCloseModal = function(resp) {
			deferred.reject(resp);
		};

		var getBackupOption = function() {
			var backupOptions = {};

			return backupOptions;
		};

		$scope.backupSingleDB = function() {
			var backupOptions = getBackupOption();
			idaService
				.backup(
					$scope.entityType,
					angular.toJson($scope.genericEntity),
					$scope.backupType,
					angular.toJson(backupOptions)
				)
				.success(function(wr) {
					var jobIds = wr.jobIds;
					var jobSummary = {
						jobId: jobIds[0],
						percentComplete: 0,
						status: 'Starting',
						sizeOfMediaOnDisk: 0,
						totalNumOfFiles: 0,
						jobElapsedTime: 0
					};
					var job = {
						jobSummary: jobSummary,
						showProgress: true,
						kill: true,
						suspend: true,
						resume: false
					};
					$scope.backupMsg = cvLoc('notification.backup.started');
					deferred.resolve(job);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						$scope.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						$scope.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		$scope.backupMultiDB = function() {
			var slqDatabaseReq = {
				backupType: $scope.backupType,
				instances: $scope.selectedDBsList
			};
			var backupOptions = getBackupOption();
			idaService
				.backupSQLMultiDB(slqDatabaseReq)
				.success(function(responce) {
					deferred.resolve(responce);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						$scope.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						$scope.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		$scope.backup = function() {
			if ($scope.isMultiDBBackup) {
				return $scope.backupMultiDB();
			} else {
				return $scope.backupSingleDB();
			}
		};

		$scope.goToJob = function() {
			var top = $modalStack.getTop();
			if (top) {
				$modalStack.dismiss(top.key);
				event.preventDefault();
			}
			$location.path('jobs/' + $scope.backupJobId);
		};

		$scope.startBackup = function() {
			var result = {};
			result.backupType = $scope.backupType;
			$scope.loading = true;
			$scope.backup().then(
				function(resp) {
					$scope.loading = false;
					$scope.closeModal(resp);
					$scope.backupJobId = _.get(resp, 'jobSummary.jobId', null);
					if (!$scope.backupJobId) {
						$scope.backupJobId = _.get(resp, 'jobDetail[0].jobs[0].jobId', 0);
					}

					var backupMsg = cvLoc('notification.backup.started') + ' ' + $scope.backupJobId;
					var viewMsg = cvLoc('notification.jobDetails');
					cvToaster.showSuccessMessage({
						ttl: '7000',
						message: backupMsg + ' <br><a href=#/jobs/' + $scope.backupJobId + '>' + viewMsg + '</a>'
					});
				},
				function(resp) {
					$scope.loading = false;
					$scope.backupMsg = resp.data;
					$scope.serverMessage = {
						type: 'error',
						message: resp.data
					};
					$scope.failAndCloseModal(resp);
				}
			);
		};
	}
]);

export default app;
