import 'adminConsole/js/services/instances.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'dbs/js/services/dbs.factory.js';

import { commonAllAgentsModule } from 'common/js/modules';
import 'adminConsole/js/factories/planPolicyModel.factory.js';

export class sapForOracleCreateInstanceController {
	constructor(
		cvLoc,
		cvUtil,
		AppTypes,
		$uibModal,
		$uibModalInstance,
		data,
		cvToaster,
		idaService,
		mbService,
		$state,
		planPolicyModel,
		globalCacheFactory,
		$scope,
		$dialogs
	) {
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.AppTypes = AppTypes;
		this.$uibModal = $uibModal;
		this.$uibModalInstance = $uibModalInstance;
		this.data = data;
		this.cvToaster = cvToaster;
		this.idaService = idaService;
		this.mbService = mbService;
		this.$state = $state;
		this._planPolicyModel = planPolicyModel;
		this.planPolicyModel = angular.copy(planPolicyModel.get('Default'));
		this.globalCacheFactory = globalCacheFactory;
		this.$scope = $scope;
		this.$dialogs = $dialogs;
		this._init();
	}

	_getLocLabels(placeHolder) {
		const labels = this.cvUtil.getIStevenLocLabels();
		labels.nothingSelected = placeHolder;
		return labels;
	}

	_init() {
		this.entity = angular.copy(this.data.idaEntity);
		this.isEdit = this.data.editDialog !== 'Add_Instance';
		this.instanceDetails = angular.copy(this.data.instanceDetails) || {};
		this.isUnixClient = false;
		if (this.isEdit) {
			this.savedPlanId = _.get(this.instanceDetails, 'planEntity.planId');
			_.set(this.planPolicyModel, 'plan.selected.id', this.savedPlanId);
		}
		this.fieldPath = {
			instanceName: 'entity.instanceName',
			userName: 'instanceDetails.sapOracleInstance.sqlConnect.userName',
			password: 'instanceDetails.sapOracleInstance.sqlConnect.password',
			domainName: 'instanceDetails.sapOracleInstance.sqlConnect.domainName',
			oracleHome: 'instanceDetails.sapOracleInstance.oracleHome',
			sapDataHome: 'instanceDetails.sapOracleInstance.sapDataPath',
			sapExePath: 'instanceDetails.sapOracleInstance.sapExeFolder',
			useSapSecureStore: 'instanceDetails.sapOracleInstance.useSAPSecureStore'
		};

		this.model = {};

		Object.keys(this.fieldPath).forEach(key => {
			this.model[key] = this.isEdit ? _.get(this, this.fieldPath[key]) : undefined;
		});

		if (!this.isEdit) {
			this.model.useSapSecureStore = false;
		} else {
			this.savedInstanceName = this.entity.instanceName;
			let osUser = _.get(this, 'instanceDetails.sapOracleInstance.oracleUser');
			if (osUser && osUser.userName) {
				this.model.osUserName = osUser.userName;
				if (osUser.domainName) {
					this.model.osUserName = osUser.domainName + '/' + osUser.userName;
				}
			}
			this.loadClientOsType(this.entity.clientId);
		}

		this.selectedClients = [];
		this.validClientSelection = true;

		this.submitAttempted = false;

		this.$scope.oraHomeResultFunction = this.oraHomeResultFunction.bind(this);
		this.$scope.sapDataHomeResultFunction = this.sapDataHomeResultFunction.bind(this);
		this.$scope.sapExePathResultFunction = this.sapExePathResultFunction.bind(this);

		if (this.isEdit) {
			this.validateConnectString();
		}
	}

	validateConnectString() {
		this.isConnectValidate = false;
		if (
			this.model.userName &&
			(this.model.userName === '/' || ((this.isEdit || this.model.password) && this.model.domainName))
		) {
			this.isConnectValidate = true;
		}
	}

	oraHomeResultFunction(result) {
		if (result) {
			this.model.oracleHome = result.path;
		}
	}

	sapDataHomeResultFunction(result) {
		if (result) {
			this.model.sapDataHome = result.path;
		}
	}
	sapExePathResultFunction(result) {
		if (result) {
			this.model.sapExePath = result.path;
		}
	}

	loadClientOsType(clientId) {
		let self = this;
		self.isUnixClient = false;
		self.mbService.getOSType(clientId).then(function successCallBack(response) {
			self.isUnixClient = response.data.toLowerCase() == 'unix';
		});
	}

	clientSelectionChanged(clientEntity) {
		this.entity.clientId = clientEntity.clientId;
		this.entity.clientName = clientEntity.clientName;
		this.loadClientOsType(clientEntity.clientId);
	}
	cancel() {
		this.$uibModalInstance.dismiss();
	}

	close(data) {
		this.$uibModalInstance.close();
		const detailsState = 'databaseDetails';
		if (detailsState == this.$state.current.name) {
			this.$state.forceReload();
		} else {
			const instanceId = data && data.instanceId ? data.instanceId : this.entity.instanceId;
			this.$state.go(detailsState, { instanceId: instanceId });
		}
	}

	submit() {
		const self = this;
		this.validateConnectString();
		if (!this.isConnectValidate || !this.validClientSelection || !_.get(this.planPolicyModel, 'plan.selected.id')) {
			return;
		}

		const instProps = {
			planEntity: {
				planId: this.planPolicyModel.plan.selected.id
			}
		};
		const tmp = {};
		Object.keys(this.fieldPath).forEach(key => {
			let keyValue = key === 'password' ? this.cvUtil.getBytes(this.model[key]) : this.model[key];
			if (keyValue) {
				_.set(tmp, this.fieldPath[key], keyValue);
			}
		});

		if (this.model.osUserName) {
			let userAccount = {};
			var userName = this.model.osUserName;
			if (userName.indexOf('\\') != -1) {
				var userValues = userName.split('\\');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else if (userName.indexOf('/') != -1) {
				var userValues = userName.split('/');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else {
				userAccount.userName = userName;
			}
			_.set(tmp, 'instanceDetails.sapOracleInstance.oracleUser', userAccount);
		}
		if (this.model.osUserPassword) {
			_.set(
				tmp,
				'instanceDetails.sapOracleInstance.oracleUser.password',
				this.cvUtil.getBytes(this.model.osUserPassword)
			);
		}

		angular.extend(instProps, tmp.instanceDetails);

		const newEntity = angular.copy(this.entity);
		newEntity.instanceName = tmp.entity.instanceName;
		instProps.instance = newEntity;

		const paramsForApi = {
			instanceEntity: angular.toJson(newEntity),
			instanceProps: angular.toJson(instProps)
		};
		if (this.savedInstanceName && newEntity.instanceName !== this.savedInstanceName) {
			paramsForApi.newInstanceName = newEntity.instanceName;
		}

		this.idaService
			.createInstance(paramsForApi, this.isEdit)
			.success(function(data) {
				self.serverMessage = self.cvUtil.emptyMsg();
				if (data.errorCode === 4444) {
					//Connection issue
					self.$dialogs.confirm(self.cvLoc('label.confirm'), data.errorString, {
						yesFunction: function() {
							self.globalCacheFactory.refreshCacheId();
							self.isEdit = true;
							angular.extend(self.entity, data.entity);
							self.savedInstanceName = newEntity.instanceName;
						},
						noFunction: function() {
							self.globalCacheFactory.refreshCacheId();
							self.close(data.entity);
						}
					});
				} else {
					self.globalCacheFactory.refreshCacheId();
					self.close(data.entity);
				}
			})
			.error(function(err) {
				self.serverMessage = self.cvUtil.errMsg(err);
			});
	}
}

sapForOracleCreateInstanceController.$inject = [
	'cvLoc',
	'cvUtil',
	'AppTypes',
	'$uibModal',
	'$uibModalInstance',
	'data',
	'cvToaster',
	'idaService',
	'mbService',
	'$state',
	'planPolicyModel',
	'globalCacheFactory',
	'$scope',
	'$dialogs'
];

commonAllAgentsModule.controller('sapForOracleCreateInstance', sapForOracleCreateInstanceController);
export default commonAllAgentsModule;
