import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';

let app = commonAllAgentsModule;

app.controller('oracleCreateLogicalDumpSubclientCtrl', [
	'$log',
	'idaService',
	'$state',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'dataMaskingService',
	'data',
	'associateSchedulePolicy',
	'planPolicyModel',
	'AppTypes',
	function(
		$log,
		idaService,
		$state,
		cvLoc,
		cvUtil,
		$modalInstance,
		dataMaskingService,
		data,
		associateSchedulePolicy,
		planPolicyModel,
		AppTypes
	) {
		let self = this;
		self.entity = angular.copy(data.entity);
		self.editing = data.editing;
		self.errors = {};
		self.contentList = [];
		self.schemaDatabaseOptions = [];
		self.schemaOptions = [];
		self.selectedSchema = [];
		let loadSchemas = function(instanceId) {
			dataMaskingService.getSchemasForInstance(instanceId, '').then(function(data) {
				self.schemaOptions = data;
				let isSchemaSelected = function(schemaName) {
					let isSelected = false;
					self.selectedSchemaList.forEach(schema => {
						if (schemaName === schema) {
							isSelected = true;
						}
					});
					return isSelected;
				};
				self.schemaOptions.forEach(schema => {
					if (self.editing && isSchemaSelected(schema.schema)) {
						schema.selectedState = 'selected';
					} else {
						schema.selectedState = 'unselected';
					}
				});
			});
		};

		if (self.editing) {
			let oracleSubclientProp = data.subclientDetails.oracleSubclientProp;
			self.subclientInfo = {
				exportMode: _.get(data.subclientDetails, 'commonProperties.dbDumpConfig.fullMode', false) ? '0' : '1',
				numberBackupStreams: oracleSubclientProp.dataThresholdStreams,
				dumpDir: _.get(data.subclientDetails, 'commonProperties.dbDumpConfig.dumpDir', '')
			};
			self.selectedSchemaList = _.get(data.subclientDetails, 'commonProperties.dbDumpConfig.schema', []);
			loadSchemas(self.entity.instanceId);
		} else {
			self.entity.subclientName = '';
			self.entity.subclientId = 0;
			self.subclientInfo = {
				selectedPlan: null,
				content: [],
				exportMode: '0',
				numberBackupStreams: 2
			};

			self.planPolicyModel = planPolicyModel.get('Default');
			self.planPolicyModel.plan = {
				selected: _.get(data, 'subclientDetails.planEntity', null)
			};
		}

		self.updateExportMode = function() {
			if (self.subclientInfo.exportMode === '1') {
				loadSchemas(self.entity.instanceId);
			}
		};

		self.toggleSelectedState = function(item) {
			if (item.selectedState === 'selected') {
				item.selectedState = 'unselected';
			} else {
				item.selectedState = 'selected';
			}
		};
		self.updateSelection = function(selectionState) {
			self.schemaOptions.forEach(schema => {
				schema.selectedState = selectionState ? 'selected' : 'unselected';
			});
		};

		/**
		 * associate schedule policy to sub client param: (wr) subclient id
		 */
		self.associateScheduleToSubclient = function(data, showPlan) {
			if (!showPlan) {
				/* association obj */
				let subclientDetails = {
					appId: self.entity.applicationId,
					clientId: self.entity.clientId,
					subclientId: data
				};
				let schedules = self.planPolicyModel.schedulePolicy;
				if (schedules && schedules.selected) {
					associateSchedulePolicy
						.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
						.success(function(successData) {
							$state.forceReload();
							self.closeModal();
						})
						.error(function(errorMessage) {
							self.serverMessage = {
								message: errorMessage,
								type: 'error'
							};
						});
				}
			} else {
				$state.forceReload();
				self.closeModal();
			}
		};

		let isValideContent = function() {
			for (let i = 0; i < self.schemaOptions.length; i++) {
				if (self.schemaOptions[i].selectedState === 'selected') {
					self.errors.schema = false;
					return true;
				}
			}
			self.errors.schema = true;
			return false;
		};

		self.createSubclient = function() {
			let showPlan = true;
			let storageDevice = new Object();
			if (!self.editing) {
				showPlan = planPolicyModel.getPlanModeState();
				self.serverMessage = {
					message: '',
					type: ''
				};
				$log.log('Creating new subclient.');
				if (showPlan) {
					self.planPolicyModel.plan.showError = false;
				}
				self.planPolicyModel.storagePolicy.showError = false;
				if (showPlan) {
					if (self.planPolicyModel.plan.selected == null) {
						self.planPolicyModel.plan.showError = true;
						return;
					}
					self.subclientInfo.selectedPlan = self.planPolicyModel.plan.selected.id;
				} else {
					if (self.planPolicyModel.storagePolicy.selected == null) {
						self.planPolicyModel.storagePolicy.showError = true;
						return;
					}
					/*
					 * if (self.planPolicyModel.logStoragePolicy.selected == null) {
					 * self.planPolicyModel.logStoragePolicy.showError = true; return; }
					 */
					storageDevice.dataBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
					storageDevice.logBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
				}
			}

			if (!isValideContent()) {
				return;
			}
			let commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			let dbDumpConfig = new Object();
			dbDumpConfig.dumpDir = self.subclientInfo.dumpDir;

			let schemaList = [];
			self.schemaOptions.forEach(schema => {
				if (schema.selectedState === 'selected') {
					schemaList.push(schema.schema);
				}
			});
			dbDumpConfig.schema = schemaList;
			dbDumpConfig.fullMode = self.subclientInfo.exportMode === '0';
			commonProperties.dbDumpConfig = dbDumpConfig;

			let subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;

			//Oracle Option setting
			let oracleSubclientProp = new Object();
			oracleSubclientProp.dbSubclientType = 2;
			oracleSubclientProp.dataThresholdStreams = self.subclientInfo.numberBackupStreams;
			subPropInfo.oracleSubclientProp = oracleSubclientProp;

			if (!self.editing) {
				subPropInfo.planEntity = {
					planId: self.subclientInfo.selectedPlan
				};
			}

			let subClientEntity = self.entity;
			let scEntity = angular.toJson(subClientEntity);
			let subInfo = angular.toJson(subPropInfo);
			let content = [];

			let serverObject = {
				subClientEntity: scEntity,
				subclientInfo: subInfo,
				content: JSON.stringify(content),
				planId: null
			};

			idaService
				.createSubclient(serverObject, self.editing)
				.success(function(data) {
					//associate schedule
					self.associateScheduleToSubclient(data, showPlan);
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		self.closeModal = function() {
			$modalInstance.close();
		};
	}
]);

export default app;
