import 'jobs/js/services/jobs.svc.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/ida/js/services/idas.factory.js';
import 'modules/ida/js/directives/cvDataMasking.js';
import 'modules/ida/js/directives/cv-client-picker.js';
import 'modules/ida/js/controllers/oracleRestoreRedirect.ctrl.js';
import 'adminConsole/js/factories/acBrowseUtils.factory.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-select.js';
import 'modules/ida/js/directives/cvDataMasking.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'modules/ida/js/directives/cv-restore-streams.js';
import 'dbs/js/controllers/dbScriptPreviewModel.ctrl.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.directive('cvOracleContent', [
	'idasFactory',
	function(idasFactory) {
		return {
			restrict: 'AE',
			scope: {
				subclientDetails: '='
			},
			template:
				'<span ><p class="info-place-holder"><cv:msg key="label.noContent" bundle="clients" /></p></span>' +
				'<ul class="list-style__row group " data-ng-repeat="contentEntity in getContentList()">' +
				'<li data-ng-bind="contentEntity.value" />' +
				'</ul>' +
				'<div class="page-details-box-links"><a href="" data-ng-click="updateSubclientContent()">Edit</a></div>',
			link: function(scope, element, attrs) {
				scope.getContentList = function() {
					scope.contentEntityDetails = [];
					if (scope.subclientDetails == null) {
						return scope.contentEntityDetails;
					}
					var oraSubInfo = scope.subclientDetails.oracleSubclientProp;
					if (oraSubInfo.data) {
						scope.contentEntityDetails.push({
							value: 'Data'
						});
					} else if (oraSubInfo.backupArchiveLog) {
						scope.contentEntityDetails.push({
							value: 'Log'
						});
					}

					return scope.contentEntityDetails;
				};
				scope.updateSubclientContent = function() {
					idasFactory.updateSubclientContent(scope.subclientDetails, false, null);
				};
			}
		};
	}
]);

app.controller('oracleCreateSubclientCtrl', [
	'AppTypes',
	'$scope',
	'$log',
	'cvUtil',
	'cvLoc',
	'$state',
	'storageService',
	'acBrowseUtils',
	'idaService',
	'profileService',
	'$dialogs',
	'data',
	'planPolicyModel',
	'associateSchedulePolicy',
	function(
		AppTypes,
		$scope,
		$log,
		cvUtil,
		cvLoc,
		$state,
		storageService,
		acBrowseUtils,
		idaService,
		profileService,
		$dialogs,
		data,
		planPolicyModel,
		associateSchedulePolicy
	) {
		$scope.entity = data.entity;
		$scope.subclientDetails = data.subclientDetails;
		$scope.editing = data.editing;

		$scope.isOracleRac = data.entity.applicationId == AppTypes.ORACLE_RAC;
		if ($scope.isOracleRac) {
			$scope.getStreamsFunc = {};
		}
		$scope.subclientInfo = {
			logBackup: true,
			archiveDelete: true,
			dataBackup: true,
			lightScript: false,
			enableLightScript: true,
			content: [],
			storagePoliciesList: [],
			storagePolicy: null,
			backupMode: 0,
			numberBackupStreams: 2,
			maxOpenFiles: 8,
			agentInfo: {
				applicationId: 0,
				agentType: {
					backupsetSupported: false,
					instanceSupported: false
				}
			},
			selectiveOnlineFull: true
		};
		$scope.separator = '\\';
		$scope.getPath = function(item) {
			if (!item) {
				return '';
			}
			if (!item.parent) {
				return '\\';
			}
			var parentPath = $scope.getPath(item.parent);
			if (parentPath == $scope.separator) {
				//reason for this everywhere is that our browse path starts with a dangling \ instead of a regular item
				return parentPath + item.id;
			}
			return parentPath + $scope.separator + item.id;
		};

		$scope.selectedItems = [];
		$scope.tree = {
			id: $scope.entity.instanceName,
			label: $scope.entity.instanceName,
			parent: '',
			isSelected: false,
			userObject: {},
			state: 'collapsed'
		};

		$scope.onlineSubsetSelected = function() {
			if ($scope.subclientInfo.backupMode == 1) {
				$scope.toggle($scope.tree);
			}
			$scope.offlineDataSelected();
		};

		/**
		 * In case offline data and data backup option is selected then we need to enable light out script option and make default selected
		 */
		$scope.offlineDataSelected = function() {
			if ($scope.subclientInfo.dataBackup && $scope.subclientInfo.backupMode == 2) {
				$scope.subclientInfo.lightScript = true;
				$scope.subclientInfo.enableLightScript = false;
			} else {
				$scope.subclientInfo.lightScript = false;
				$scope.subclientInfo.enableLightScript = true;
			}
		};

		$scope.selectiveOnlineFullChanged = function() {
			if ($scope.subclientInfo.selectiveOnlineFull) {
				$scope.subclientInfo.dataBackup = true;
				$scope.subclientInfo.backupMode = '0';
				$scope.offlineDataSelected();
				$scope.subclientInfo.logBackup = true;
			}
		};
		$scope.selectiveOnlineFullChanged();

		$scope.folderDrilledDown = function(item, event) {
			event.preventDefault();
			$scope.toggle(item);
		};

		$scope.isParentSelected = function(item) {
			if (!item || !item.parent) {
				return false;
			}
			if (item.parent.isSelected) {
				return true;
			} else {
				return $scope.isParentSelected(item.parent);
			}
		};

		$scope.isNodeSelected = function(item) {
			if (item.isSelected) {
				return true;
			} else {
				return false;
			}
		};
		$scope.updateChildrenStatue = function(items, state) {
			angular.forEach(items, function(item) {
				item.isSelected = state;
				if (item.children) {
					$scope.updateChildrenStatue(item.children, state);
				}
			});
		};

		$scope.folderSelected = function(item) {
			var nodeState = false;
			if (item.isSelected == false) {
				nodeState = true;
			} else {
				nodeState = false;
			}
			item.isSelected = nodeState;
			if (item.children) {
				$scope.updateChildrenStatue(item.children, nodeState);
			}
			$scope.updateParentStatus(item.parent);
			$scope.expand(item);
		};

		$scope.updateParentStatus = function(item) {
			if (item) {
				item.isSelected = true;
				angular.forEach(item.children, function(child) {
					if (!child.isSelected) {
						item.isSelected = false;
					}
				});
				$scope.updateParentStatus(item.parent);
			}
		};

		/*
		 */
		$scope.toggle = function(item) {
			if (item.state == 'expanded') {
				item.state = 'collapsed';
			} else {
				$scope.expand(item);
			}
		};
		$scope.expand = function(item) {
			if (!item.loaded) {
				$scope.loadChildren(item);
			}
			item.state = 'expanded';
		};

		//Loading children for the content tree.
		$scope.loadChildren = function(item, refresh) {
			if (item.fileType && item.fileType == 'DATAFILE') {
				item.loaded = true;
				return;
			}
			var pathString = $scope.getPath(item);
			var instanceId = $scope.entity.instanceId;
			var pathString = $scope.getPath(item);
			var options = new Object();
			options['path'] = pathString;
			if (refresh) {
				options['refreshData'] = true;
			} else {
				delete options['refreshData'];
			}
			idaService.getIdaBrowseData(instanceId, 'INSTANCE_ENTITY', options).then(function(data) {
				var subItems = data.browseData; //acBrowseUtils.getBrowswItems('oracleBrowse',data.browseData);
				if (item.id === $scope.entity.instanceName && subItems && subItems.length > 0) {
					// for the root node, in case children's present, then mark it as selected
					item.isSelected = true;
				}
				angular.forEach(subItems, function(browseItem) {
					browseItem.parent = item;
					browseItem.state = 'collapsed';
					if (item.isSelected) {
						browseItem.isSelected = true;
					}
				});

				item.children = subItems;
				item.loaded = true;
			});
		};

		var selectedNodes = function(treeNode) {
			var selectedList = [];
			if (treeNode.isSelected === true) {
				selectedList.push(treeNode);
			} else if (treeNode.children) {
				angular.forEach(treeNode.children, function(childTreeNode) {
					if (childTreeNode.isSelected === true) {
						selectedList.push(childTreeNode);
					} else if (childTreeNode.children) {
						var childSelection = selectedNodes(childTreeNode);
						angular.forEach(childSelection, function(node) {
							selectedList.push(node);
						});
					}
				});
			}
			return selectedList;
		};

		var getSelecteNodes = function(tree) {
			var selectedList = selectedNodes(tree);
			return selectedList;
		};

		$scope.entity.subclientId = -1;

		$scope.planPolicyModel = planPolicyModel.get('Default');
		$scope.createSubclient = function() {
			let showPlan = planPolicyModel.getPlanModeState();
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			$log.log('Creating new subclient.');
			if (showPlan) {
				$scope.planPolicyModel.plan.showError = false;
			}
			$scope.planPolicyModel.storagePolicy.showError = false;
			var storageDevice = new Object();
			if (showPlan) {
				if ($scope.planPolicyModel.plan.selected == null) {
					$scope.planPolicyModel.plan.showError = true;
					return;
				}
				$scope.subclientInfo.selectedPlan = $scope.planPolicyModel.plan.selected.id;
			} else {
				if ($scope.planPolicyModel.storagePolicy.selected == null) {
					$scope.planPolicyModel.storagePolicy.showError = true;
					return;
				}
				if ($scope.planPolicyModel.logStoragePolicy && $scope.planPolicyModel.logStoragePolicy.selected == null) {
					$scope.planPolicyModel.logStoragePolicy.showError = true;
					return;
				}
				storageDevice.dataBackupStoragePolicy = $scope.planPolicyModel.storagePolicy.selected.obj;
				if ($scope.planPolicyModel.logStoragePolicy && $scope.planPolicyModel.logStoragePolicy.selected) {
					storageDevice.logBackupStoragePolicy = $scope.planPolicyModel.logStoragePolicy.selected.obj;
				}
			}

			// if (!isValidContent())
			// 	return;

			var oracleSubclientProp = new Object();
			oracleSubclientProp.data = $scope.subclientInfo.dataBackup;
			oracleSubclientProp.backupArchiveLog = $scope.subclientInfo.logBackup;
			oracleSubclientProp.archiveDelete = $scope.subclientInfo.archiveDelete;
			oracleSubclientProp.dataThresholdStreams = $scope.subclientInfo.numberBackupStreams;
			oracleSubclientProp.archiveDeleteAll = false;
			oracleSubclientProp.enableTableBrowse = $scope.subclientInfo.oraTableMeta;
			oracleSubclientProp.backupMode = $scope.subclientInfo.backupMode;
			oracleSubclientProp.selectiveOnlineFull = $scope.subclientInfo.selectiveOnlineFull;

			if ($scope.isOracleRac) {
				var racStreamsObject = $scope.getStreamsFunc.getRacStreams();
				angular.extend(oracleSubclientProp, racStreamsObject);
			} else {
				oracleSubclientProp.dataThresholdStreams = $scope.subclientInfo.numberBackupStreams;
			}
			oracleSubclientProp.lightsOutScript = $scope.subclientInfo.lightScript;
			if ($scope.subclientInfo.lightScript) {
				oracleSubclientProp.sleepTimeinMin = 1;
				oracleSubclientProp.sleepTimeinSec = 10;
			}

			var selectdList = getSelecteNodes($scope.tree);
			var oracleContentList = [];
			angular.forEach(selectdList, function(nodeData) {
				var oracleContent = new Object();
				var node = nodeData.userObject;
				if (node.database) {
					oracleContent.database = node.database;
				}
				if (node.tableSpace) {
					oracleContent.tableSpace = node.tableSpace;
				}
				if (node.dataFile) {
					oracleContent.dataFile = node.dataFile;
				}
				var fileType = 0;
				if (node.fileType === 'DATABASE') {
					fileType = 1;
				} else if (node.fileType === 'TABLESPACE') {
					fileType = 2;
				} else if (node.fileType === 'DATAFILE') {
					fileType = 3;
				}
				oracleContent.fileType = fileType;
				var content = new Object();
				content.oracleContent = oracleContent;
				oracleContentList.push(content);
			});
			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;
			subPropInfo.oracleSubclientProp = oracleSubclientProp;
			//For online subset only we have to set the content.
			if ($scope.subclientInfo.backupMode == '1') {
				subPropInfo.content = oracleContentList;
				subPropInfo.contentOperationType = 1;
			}

			subPropInfo.planEntity = {
				planId: $scope.subclientInfo.selectedPlan
			};
			var subClientEntity = $scope.entity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			var content = [];
			idaService
				.createSubclient({
					subClientEntity: scEntity,
					subclientInfo: subInfo,
					content: JSON.stringify(content),
					planId: null
				})
				.success(function(data) {
					//associate schedule
					$scope.associateScheduleToSubclient(data, showPlan);
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		/**
    associate schedule policy to sub client
    param: (wr) subclient id
    **/
		$scope.associateScheduleToSubclient = function(data, showPlan) {
			if (!showPlan) {
				/* association obj */
				let subclientDetails = {
					appId: $scope.entity.applicationId,
					clientId: $scope.entity.clientId,
					subclientId: data
				};
				let schedules = $scope.planPolicyModel.schedulePolicy;
				if (schedules && schedules.selected) {
					associateSchedulePolicy
						.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
						.success(function(successData) {
							$scope.closeModal();
							$state.go('dbCollectionDetails', {
								subclientId: data
							});
						})
						.error(function(errorMessage) {
							$scope.serverMessage = {
								message: errorMessage,
								type: 'error'
							};
						});
				}
			} else {
				$scope.closeModal();
				$state.go('dbCollectionDetails', {
					subclientId: data
				});
			}
		};
		$scope.cancel = function() {
			$scope.$close();
		};
		$scope.closeModal = function(result) {
			$scope.$close();
		};
	}
]);

app.controller('oracleUpdateSubclientContentCtrl', [
	'$scope',
	'$log',
	'$state',
	'storageService',
	'acBrowseUtils',
	'idaService',
	'data',
	function($scope, $log, $state, storageService, acBrowseUtils, idaService, data) {
		$scope.entity = data.subclientDetails.subClientEntity;
		$scope.subclientDetails = data.subclientDetails;
		var oraSubInfo = $scope.subclientDetails.oracleSubclientProp;

		var backupMode = '0';
		if (oraSubInfo.backupMode === 'ONLINE_SUBSET_DB') {
			backupMode = '1';
		} else if (oraSubInfo.backupMode === 'OFFLINE_DB') {
			backupMode = '2';
		}

		$scope.subclientInfo = {
			logBackup: oraSubInfo.backupArchiveLog,
			archiveDelete: oraSubInfo.archiveDelete,
			dataBackup: oraSubInfo.data,
			backupMode: backupMode,
			lightScript: false,
			enableLightScript: true,
			contentList: [],
			content: [],
			selectiveOnlineFull: oraSubInfo.selectiveOnlineFull,
			oraTableMeta: _.get(oraSubInfo, 'enableTableBrowse', false)
		};

		const imageCopyEnabled = oraSubInfo.snapImageCopy;
		const useRmanForLogBackup = oraSubInfo.useRmanForLogBackup;
		$scope.isArchiveLogSubclient = data.subclientDetails.status && (data.subclientDetails.status & 0x40000) !== 0;

		if (
			$scope.subclientInfo.selectiveOnlineFull ||
			(!imageCopyEnabled && !useRmanForLogBackup && !$scope.isArchiveLogSubclient)
		) {
			$scope.showSelectiveOnlineFull = true;
		}

		$scope.onlineSubsetSelected = function() {
			if ($scope.subclientInfo.backupMode == 1) {
				$scope.toggle($scope.tree);
			}
			$scope.offlineDataSelected();
		};

		/**
		 * In case offline data and data backup option is selected then we need to enable light out script option and make default selected
		 */
		$scope.offlineDataSelected = function() {
			if ($scope.subclientInfo.dataBackup && $scope.subclientInfo.backupMode == 2) {
				$scope.subclientInfo.lightScript = true;
				$scope.subclientInfo.enableLightScript = false;
			} else {
				$scope.subclientInfo.lightScript = false;
				$scope.subclientInfo.enableLightScript = true;
			}
		};

		$scope.selectiveOnlineFullChanged = function() {
			if ($scope.subclientInfo.selectiveOnlineFull) {
				$scope.subclientInfo.dataBackup = true;
				$scope.subclientInfo.backupMode = '0';
				$scope.offlineDataSelected();
				$scope.subclientInfo.logBackup = true;
			}
		};

		idaService
			.getSubClientContent({
				genericEntity: JSON.stringify($scope.entity)
			})
			.success(function(data) {
				var oraContentList = [];
				if (data.content) {
					angular.forEach(data.content, function(contentNode) {
						if (contentNode.oracleContent) {
							oraContentList.push(contentNode.oracleContent);
						}
					});
				}
				$scope.subclientInfo.contentList = oraContentList;
				if ($scope.subclientInfo.backupMode === 1) {
					$scope.toggle($scope.tree);
				}
				$scope.contentLoaded = true;
			})
			.error(function(e) {
				$scope.serverMessage = {
					message: e,
					type: 'error'
				};
			});
		$scope.separator = '\\';
		$scope.getPath = function(item) {
			if (!item) {
				return '';
			}
			if (!item.parent) {
				return '\\';
			}
			var parentPath = $scope.getPath(item.parent);
			if (parentPath == $scope.separator) {
				//reason for this everywhere is that our browse path starts with a dangling \ instead of a regular item
				return parentPath + item.id;
			}
			return parentPath + $scope.separator + item.id;
		};

		$scope.selectedItems = [];
		var isNodeSelected = true;
		if ($scope.subclientInfo.backupMode == 1) {
			isNodeSelected = false;
		}
		$scope.tree = {
			id: $scope.entity.instanceName,
			label: $scope.entity.instanceName,
			parent: '',
			isSelected: isNodeSelected,
			state: 'collapsed'
		};

		$scope.folderDrilledDown = function(item, event) {
			event.preventDefault();
			$scope.toggle(item);
		};

		$scope.isParentSelected = function(item) {
			if (!item || !item.parent) {
				return false;
			}
			if (item.parent.isSelected) {
				return true;
			} else {
				return $scope.isParentSelected(item.parent);
			}
		};

		$scope.isNodeSelected = function(item) {
			if (item.isSelected) {
				return true;
			} else {
				return false;
			}
		};
		$scope.updateChildrenStatue = function(items, state) {
			angular.forEach(items, function(item) {
				item.isSelected = state;
				if (item.children) {
					$scope.updateChildrenStatue(item.children, state);
				}
			});
		};

		$scope.folderSelected = function(item) {
			var nodeState = false;
			if (item.isSelected == false) {
				nodeState = true;
			} else {
				nodeState = false;
			}
			item.isSelected = nodeState;
			if (item.children) {
				$scope.updateChildrenStatue(item.children, nodeState);
			}
			$scope.updateParentStatus(item.parent);
			$scope.expand(item);
		};

		$scope.updateParentStatus = function(item) {
			if (item) {
				item.isSelected = true;
				angular.forEach(item.children, function(child) {
					if (!child.isSelected) {
						item.isSelected = false;
					}
				});
				$scope.updateParentStatus(item.parent);
			}
		};

		/*
		 */
		$scope.toggle = function(item) {
			if (item.state == 'expanded') {
				item.state = 'collapsed';
			} else {
				$scope.expand(item);
			}
		};
		$scope.expand = function(item) {
			if (!item.loaded) {
				$scope.loadChildren(item);
			}
			item.state = 'expanded';
		};

		var getNodeIdValue = function(contentNode) {
			var fileType = contentNode.fileType;
			if (fileType === 'DATABASE') {
				return contentNode.database;
			} else if (fileType === 'TABLESPACE') {
				return contentNode.tableSpace;
			} else if (fileType === 'DATAFILE') {
				return contentNode.dataFile;
			}
		};

		var getFieldNameForFileType = function(fileType) {
			if (fileType === 'DATABASE') {
				return 'database';
			} else if (fileType === 'TABLESPACE') {
				return 'tableSpace';
			} else if (fileType === 'DATAFILE') {
				return 'dataFile';
			}
		};

		var getFileTypeInt = function(type) {
			var fileType;
			if (type === 'DATABASE') {
				fileType = 1;
			} else if (type === 'TABLESPACE') {
				fileType = 2;
			} else if (type === 'DATAFILE') {
				fileType = 3;
			}
			return fileType;
		};
		var updateNodeSelected = function(browseItem) {
			//In case backup mode is offline db then only we need to process list.
			if ($scope.subclientInfo.backupMode == 1) {
				for (var int = 0; int < $scope.subclientInfo.contentList.length; int++) {
					var contentNode = $scope.subclientInfo.contentList[int];
					var idValue = getNodeIdValue(contentNode);
					if (browseItem.fileType == contentNode.fileType && browseItem.id == idValue) {
						browseItem.isSelected = true;
					}
					//If children is selected previously, toggle the parent node to show the children.
					if (
						contentNode[getFieldNameForFileType(browseItem.fileType)] == browseItem.id &&
						getFileTypeInt(contentNode.fileType) > getFileTypeInt(browseItem.fileType)
					) {
						$scope.expand(browseItem);
					}
				}
			}
		};
		//Loading children for the content tree.
		$scope.loadChildren = function(item, refresh) {
			if (item.fileType && item.fileType == 'DATAFILE') {
				item.loaded = true;
				return;
			}
			var pathString = $scope.getPath(item);
			var instanceId = $scope.entity.instanceId;
			var pathString = $scope.getPath(item);
			var options = new Object();
			options['path'] = pathString;
			if (refresh) {
				options['refreshData'] = true;
			} else {
				delete options['refreshData'];
			}
			idaService.getIdaBrowseData(instanceId, 'INSTANCE_ENTITY', options).then(function(data) {
				item.loaded = true;
				var subItems = data.browseData; //acBrowseUtils.getBrowswItems('oracleBrowse', data.browseData);
				angular.forEach(subItems, function(browseItem) {
					browseItem.parent = item;
					browseItem.state = 'collapsed';
					if (item.isSelected) {
						browseItem.isSelected = true;
					} else {
						updateNodeSelected(browseItem);
					}
				});

				item.children = subItems;
			});
		};

		var selectedNodes = function(treeNode) {
			var selectedList = [];
			if (treeNode.isSelected === true) {
				selectedList.push(treeNode);
			} else if (treeNode.children) {
				angular.forEach(treeNode.children, function(childTreeNode) {
					if (childTreeNode.isSelected === true) {
						selectedList.push(childTreeNode);
					} else if (childTreeNode.children) {
						var childSelection = selectedNodes(childTreeNode);
						angular.forEach(childSelection, function(node) {
							selectedList.push(node);
						});
					}
				});
			}
			return selectedList;
		};

		var getSelecteNodes = function(tree) {
			var selectedList = selectedNodes(tree);
			return selectedList;
		};

		//$scope.entity.subclientId = -1;
		//$scope.entity.subClientName = "";
		var loadStoragePolicy = function() {
			storageService
				.getStoragePoliciesList()
				.success(function(storagePolicies) {
					$scope.subclientInfo.storagePoliciesList = storagePolicies;
				})
				.error(function(error) {
					$log.error(error);
				});
		};
		loadStoragePolicy();

		$scope.createSubclient = function() {
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			$log.log('Creating new subclient.');

			var storageDevice = new Object();
			storageDevice.dataBackupStoragePolicy = $scope.subclientInfo.storagePolicy;

			var oracleSubclientProp = new Object();
			oracleSubclientProp.data = $scope.subclientInfo.dataBackup;
			oracleSubclientProp.backupArchiveLog = $scope.subclientInfo.logBackup;
			oracleSubclientProp.lightsOutScript = $scope.subclientInfo.lightScript;
			oracleSubclientProp.archiveDelete = $scope.subclientInfo.archiveDelete;
			oracleSubclientProp.archiveDeleteAll = false;
			oracleSubclientProp.enableTableBrowse = $scope.subclientInfo.oraTableMeta;
			oracleSubclientProp.backupMode = $scope.subclientInfo.backupMode;
			oracleSubclientProp.dataThresholdStreams = $scope.subclientInfo.numberBackupStreams;
			oracleSubclientProp.selectiveOnlineFull = $scope.subclientInfo.selectiveOnlineFull;

			var selectdList = getSelecteNodes($scope.tree);
			var oracleContentList = [];
			angular.forEach(selectdList, function(nodeData) {
				var oracleContent = new Object();
				var node = nodeData.userObject;
				if (!node) return;
				if (node.database) {
					oracleContent.database = node.database;
				}
				if (node.tableSpace) {
					oracleContent.tableSpace = node.tableSpace;
				}
				if (node.dataFile) {
					oracleContent.dataFile = node.dataFile;
				}
				var fileType = getFileTypeInt(node.fileType);
				oracleContent.fileType = fileType;
				var content = new Object();
				content.oracleContent = oracleContent;
				oracleContentList.push(content);
			});
			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;
			subPropInfo.oracleSubclientProp = oracleSubclientProp;
			//For online subset only we have to set the content.
			if ($scope.subclientInfo.backupMode == '1') {
				subPropInfo.content = oracleContentList;
				subPropInfo.contentOperationType = 1;
			}

			var subClientEntity = $scope.entity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			var content = [];

			idaService
				.updateSubclient({
					subClientEntity: scEntity,
					subclientInfo: subInfo,
					content: JSON.stringify(content)
				})
				.success(function(data) {
					$state.forceReload();
					$scope.closeModal();
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		$scope.cancel = function() {
			$scope.$close();
		};
		$scope.closeModal = function(result) {
			$scope.$close();
		};
		//
	}
]);
app.controller('oracleCreateInstanceCtrl', [
	'AppTypes',
	'profileService',
	'globalCacheFactory',
	'$scope',
	'storageService',
	'$state',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'$log',
	'data',
	'cvToaster',
	'$uibModal',
	'idaService',
	'mbService',
	'clientService',
	function(
		AppTypes,
		profileService,
		globalCacheFactory,
		$scope,
		storageService,
		$state,
		cvLoc,
		cvUtil,
		$modalInstance,
		$log,
		data,
		cvToaster,
		$modal,
		idaService,
		mbService,
		clientService
	) {
		var self = this;
		$scope.isCatalogValidate = false;
		$scope.isConnectValidate = false;
		$scope.addInstance = false;
		$scope.isUnixClient = false;
		$scope.libraries = [];
		//set DB thin client
		$scope.isDbThinClient = false;
		$scope.dataModel = {};
		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.localLang.nothingSelected = cvLoc('placeholder.dbPhysicalClients');
		$scope.locForProxies = cvUtil.getIStevenLocLabels();

		$scope.locForProxies.nothingSelected = cvLoc('label.selectProxies');
		$scope.useCatalogStatus = 'disabled-activity';

		let isThinclientDataLoaded = false;
		$scope.backupDataAccessNodes = [];

		//Load Storage policies
		storageService
			.getStoragePoliciesList()
			.success(function(data) {
				$scope.libraries = data;
			})
			.error(function(errorMessage) {
				$scope.serverMessage = {
					message: errorMessage,
					type: 'error'
				};
			});

		let loadThinClientData = function() {
			if (isThinclientDataLoaded === true) return;
			isThinclientDataLoaded = true;
			//Load Proxy clients
			clientService
				.getClientsForPackage(1101)
				.success(function(data) {
					$scope.physicalClients = data;
					$scope.selectedClients = [];
					$scope.physicalClients.forEach(node => {
						$scope.backupDataAccessNodes.forEach(element => {
							if (element.clientId == node.clientId) {
								node.ticked = true;
							}
						});
					});
				})
				.error(function(errorMessage) {
					$scope.serverMessage = {
						message: errorMessage,
						type: 'error'
					};
				});
		};

		/* Plan initialization */
		//Somehow isteven multi select output-model doesn't work with $scope, use self here
		self.selectedProfileList = [];
		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.initAfterLocalization = function() {
			$scope.localLang.nothingSelected = cvLoc('placeholder.selectPlan');
		};

		$scope.parseIStevenOutput = function() {
			if (self.selectedProfileList && self.selectedProfileList.length == 1) {
				$scope.showPlanError = false;
			} else {
				$scope.showPlanError = true;
			}
		};

		/* load plans */
		var loadPlans = function() {
			profileService
				.getEligiblePlansForApp(AppTypes.ORACLE)
				.success(function(data) {
					if (data.length > 0) {
						var planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							var planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype
							};
							if (planListByTypes[planData.subtype]) {
								planListByTypes[planData.subtype].push(planObj);
							} else {
								planListByTypes[planData.subtype] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						$scope.profileList = tempPlanList;
					} else {
						$scope.profileList = [];
					}

					if ($scope.instancePlanEntity && $scope.instancePlanEntity.planId) {
						planSelectonUpdate($scope.instancePlanEntity, $scope.profileList);
					}
				})
				.error(function(e) {
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};
		loadPlans();

		let planSelectonUpdate = function(selectedPlan, profileList) {
			for (var planTypeNode in profileList) {
				var planNode = profileList[planTypeNode];
				if (planNode && planNode.type && selectedPlan.planId === planNode.id) {
					planNode.selected = true;
					$scope.showPlanError = false;
				}
			}
		};

		let loadClientDetails = function(clientId) {
			if ($scope.instanceEntity) {
				$scope.instanceEntity.clientId = clientId;
			}
			idaService.getClientDetails(clientId).then(function(data) {
				if (data.data && data.data.client) {
					$scope.isUnixClient = data.data.client.osInfo && data.data.client.osInfo.Type === 'Unix' ? true : false;
					$scope.isDbThinClient =
						data.data.pseudoClientInfo &&
						data.data.pseudoClientInfo.clientType &&
						data.data.pseudoClientInfo.clientType == 'DB_THIN_CLIENT';
					if ($scope.isDbThinClient) {
						loadThinClientData();
					}
				}
				if (!$scope.instancePlanEntity || !$scope.instancePlanEntity.planId) {
					$scope.instancePlanEntity = _.get(data.data, 'planEntity');
				}
				$scope.clientDetailsLoaded = true;
			});
		};

		if (data.editDialog && data.editDialog === 'Add_Instance') {
			$scope.addInstance = true;
			$scope.editDialog = false;
			data.idaEntity.appName = 'Oracle';
			$scope.clientSelection = {
				selectedClients: [],
				valideClientSelection: false,
				selectionChanged: function(clientEntity) {
					loadClientDetails(clientEntity.clientId);
				}
			};
			$scope.showPlanError = true;
		} else if (!data.editDialog) {
			data.idaEntity.appName = 'Oracle';
			$scope.editDialog = data.editDialog;
		} else {
			$scope.showPlanError = false;
			$scope.editDialog = data.editDialog;
		}

		if (!$scope.addInstance) {
			loadClientDetails(data.idaEntity.clientId);
		}

		$scope.oraHomeResuleFunction = function(result) {
			if (result) {
				$scope.instInfo.oracleHome = result.path;
			}
		};
		$scope.populateDefaultValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			var sqlConnect = new Object();
			var commandLineStoragePolicy = new Object();
			var logBackupStoragePolicy = new Object();
			var storageDevice = new Object();

			sqlConnect.userName = '';
			sqlConnect.domainName = '';

			instInfo.password = '';
			instInfo.sqlConnect = sqlConnect;
			instInfo.availableStoragePolicies = {};
			instInfo.osUserName = '';
			instInfo.osUserPassword = '';
			instInfo.TNSAdminPath = '';

			$scope.instanceEntity = data.idaEntity;
			$scope.instanceEntity.instanceName = '';
			$scope.instanceEntity.instanceId = -1;
			//Default storage policy values.

			commandLineStoragePolicy.storagePolicyId = null;
			commandLineStoragePolicy.storagePolicyName = null;

			logBackupStoragePolicy.storagePolicyId = null;
			logBackupStoragePolicy.storagePolicyName = null;

			storageDevice.commandLineStoragePolicy = commandLineStoragePolicy;
			storageDevice.logBackupStoragePolicy = logBackupStoragePolicy;
			$scope.storageDev = storageDevice;

			return instInfo;
		};

		$scope.toggleUseCatalog = function() {
			$scope.instInfo.useCatalog = !$scope.instInfo.useCatalog;
			$scope.useCatalogStatus = $scope.instInfo.useCatalog ? 'enabled-activity' : 'disabled-activity';
		};
		$scope.populateInstanceValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			$scope.instanceEntity = angular.copy(serverInstanceInfo.instance);
			$scope.savedInstanceName = angular.copy(serverInstanceInfo.instance.instanceName);
			instInfo.osUserName = serverInstanceInfo.oracleInstance.oracleUser.userName;
			instInfo.TNSAdminPath = serverInstanceInfo.oracleInstance.TNSAdminPath;
			if (serverInstanceInfo.oracleInstance.oracleUser.domainName) {
				instInfo.osUserName = serverInstanceInfo.oracleInstance.oracleUser.domainName + '/' + instInfo.osUserName;
			}
			instInfo.oracleHome = serverInstanceInfo.oracleInstance.oracleHome;
			instInfo.sqlConnect = serverInstanceInfo.oracleInstance.sqlConnect;
			instInfo.useCatalog = serverInstanceInfo.oracleInstance.useCatalogConnect;
			if (instInfo.useCatalog) {
				$scope.useCatalogStatus = 'enabled-activity';
			}
			instInfo.catalogConnect = serverInstanceInfo.oracleInstance.catalogConnect;
			instInfo.availableStoragePolicies = $scope.libraries;

			var storageDevice = new Object();
			var oraStorage = serverInstanceInfo.oracleInstance.oracleStorageDevice;
			storageDevice.commandLineStoragePolicy = angular.copy(oraStorage.commandLineStoragePolicy);
			storageDevice.logBackupStoragePolicy = angular.copy(oraStorage.logBackupStoragePolicy);
			$scope.storageDev = storageDevice;

			if (
				serverInstanceInfo.oracleInstance.proxyClients &&
				serverInstanceInfo.oracleInstance.proxyClients.backupDataAccessNodes
			) {
				$scope.backupDataAccessNodes = serverInstanceInfo.oracleInstance.proxyClients.backupDataAccessNodes;
			}
			$scope.dataModel.storagePolicyId = oraStorage.logBackupStoragePolicy.storagePolicyId;

			$scope.instancePlanEntity = _.get(serverInstanceInfo, 'planEntity');

			return instInfo;
		};

		if ($scope.editDialog && $scope.editDialog == true) {
			$scope.instInfo = $scope.populateInstanceValues(data.instanceDetails);
		} else {
			$scope.instInfo = $scope.populateDefaultValues({});
		}

		$scope.closeDialogBox = function() {
			globalCacheFactory.refreshCacheId();
			$modalInstance.close();
		};

		/**
		 * Catalog string can be /(root) or with userName,password and service name
		 */
		$scope.validateCatalogString = function() {
			$scope.isCatalogValidate = false;
			if ($scope.instInfo.useCatalog) {
				if (
					$scope.instInfo.catalogConnect.userName &&
					($scope.instInfo.catalogConnect.userName === '/' ||
						(($scope.editDialog || $scope.instInfo.catalogConnect.cvPassword) &&
							$scope.instInfo.catalogConnect.domainName))
				) {
					$scope.isCatalogValidate = true;
				}
			} else {
				$scope.isCatalogValidate = true;
			}
		};

		/**
		 * Connect string can be /(root) or with userName,password and service name
		 */
		$scope.validateConnectString = function() {
			$scope.isConnectValidate = false;
			if (
				$scope.instInfo.sqlConnect.userName &&
				($scope.instInfo.sqlConnect.userName === '/' ||
					(($scope.editDialog || $scope.instInfo.password) && $scope.instInfo.sqlConnect.domainName))
			) {
				$scope.isConnectValidate = true;
			}
		};

		$scope.validateClientSelection = function() {
			var isValid = $scope.physicalClients.some(function(curr) {
				return curr['ticked'] === true;
			});

			$scope.showAddServerErrorMessage = !isValid;
			return isValid;
		};

		// method to create the instance.
		$scope.createInstance = function() {
			$scope.validateCatalogString();
			$scope.validateConnectString();
			if (!$scope.isDbThinClient && (!$scope.isConnectValidate || !$scope.isCatalogValidate)) {
				return;
			}

			/*Validate plan selection*/
			if (
				!$scope.isDbThinClient &&
				$scope.editDialog === false &&
				(!self.selectedProfileList || self.selectedProfileList.length < 1)
			) {
				return;
			}

			if ($scope.isDbThinClient && !$scope.validateClientSelection()) return;

			var instanceEntity = $scope.instanceEntity;
			//In case of add instance dialog check for the client selection validation
			if ($scope.addInstance) {
				if (!$scope.clientSelection.valideClientSelection) {
					return;
				}
				if ($scope.clientSelection.selectedClients) {
					instanceEntity.clientName = $scope.clientSelection.selectedClients[0].clientName;
					instanceEntity.clientId = $scope.clientSelection.selectedClients[0].clientId;
				}
			}

			var instanceProperties = new Object();

			$scope.populateOracleProps(instanceProperties);
			var osPassword;
			var password;
			if ($scope.isDbThinClient) {
				osPassword = null;
				password = null;
			} else {
				if ($scope.editDialog && $scope.editDialog == true && $scope.instInfo.osUserPassword === '*****') {
					osPassword = null;
				} else {
					osPassword = $scope.instInfo.osUserPassword;
				}

				if ($scope.editDialog && $scope.editDialog == true && $scope.instInfo.password === '*****') {
					password = null;
				} else {
					password = $scope.instInfo.password;
				}
			}

			const params = {
				instanceEntity: angular.toJson(instanceEntity),
				instanceProps: angular.toJson(instanceProperties),
				password: password,
				osUserPassword: osPassword
			};

			//When updating instance after creation succeed with connection error.
			if ($scope.savedInstanceName && instanceEntity.instanceName !== $scope.savedInstanceName) {
				params.newInstanceName = instanceEntity.instanceName;
			}
			idaService
				.createInstance(params, $scope.editDialog)
				.success(function(data) {
					$scope.savedInstanceName = instanceEntity.instanceName;
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						$scope.serverMessage = {
							message: msgStr,
							type: 'error'
						};
						$scope.instanceEntity.instanceId = data.entity.instanceId;
						$scope.editDialog = true;
						globalCacheFactory.refreshCacheId();
						$state.forceReload();
						return;
					}

					var msg = cvLoc('msg.createInstance');
					if ($scope.editDialog) {
						msg = cvLoc('msg.updateInstance');
					}

					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: msg
					});

					$scope.closeDialogBox();
					$state.forceReload();
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		$scope.tnsAdminFolderResultFunction = function(data) {
			$scope.instInfo.TNSAdminPath = data.path;
		};

		// Utility method to populate oracle specific values.
		$scope.populateOracleProps = function(instanceProperties) {
			var oracleInstance = new Object();
			if ($scope.isDbThinClient) {
				oracleInstance.oracleStorageDevice = $scope.storageDev;
				var storagePolicyEntity = new Object();
				storagePolicyEntity.storagePolicyId = $scope.dataModel.storagePolicyId;
				oracleInstance.oracleStorageDevice.dataBackupStoragePolicy = angular.copy(storagePolicyEntity);
				oracleInstance.oracleStorageDevice.commandLineStoragePolicy = angular.copy(storagePolicyEntity);
				oracleInstance.oracleStorageDevice.logBackupStoragePolicy = angular.copy(storagePolicyEntity);
				oracleInstance.dataArchiveGroup = new Object();
				oracleInstance.dataArchiveGroup = storagePolicyEntity;
				$scope.selectedClients = $scope.physicalClients.filter(function(group) {
					return group.ticked;
				});
				oracleInstance.proxyClients = {
					backupDataAccessNodes: $scope.selectedClients
				};
			} else {
				oracleInstance.crossCheckTimeout = 600;
				oracleInstance.useCatalogConnect = false;
				oracleInstance.oracleHome = $scope.instInfo.oracleHome;
				if ($scope.instInfo.useCatalog) {
					oracleInstance.catalogConnect = $scope.instInfo.catalogConnect;
					if ($scope.instInfo.catalogConnect.cvPassword) {
						oracleInstance.catalogConnect.password = cvUtil.getBytes($scope.instInfo.catalogConnect.cvPassword);
					}
					oracleInstance.useCatalogConnect = true;
				}
				oracleInstance.sqlConnect = $scope.instInfo.sqlConnect;
				if ($scope.instInfo.sqlConnect.userName === null || $scope.instInfo.password === null) {
					oracleInstance.oracleWalletAuthentication = true;
				}
				var oracleUser = new Object();
				var userName = $scope.instInfo.osUserName;
				if (userName.indexOf('\\') != -1) {
					var userValues = userName.split('\\');
					oracleUser.domainName = userValues[0];
					oracleUser.userName = userValues[1];
				} else if (userName.indexOf('/') != -1) {
					var userValues = userName.split('/');
					oracleUser.domainName = userValues[0];
					oracleUser.userName = userValues[1];
				} else {
					oracleUser.userName = $scope.instInfo.osUserName;
				}
				oracleInstance.oracleUser = oracleUser;
				oracleInstance.blockSize = 1048576;
				oracleInstance.oracleStorageDevice = $scope.storageDev;
				oracleInstance.TNSAdminPath = $scope.instInfo.TNSAdminPath;
			}
			instanceProperties.oracleInstance = oracleInstance;
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				instanceProperties.planEntity = { planId: self.selectedProfileList[0].id };
			}
		};
	}
]);

app.controller('oracleBackupOptionsCtrl', [
	'AppTypes',
	'$q',
	'$rootScope',
	'$scope',
	'$location',
	'idaService',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$log',
	'$uibModalStack',
	'dbsFactory',
	'data',
	'cvToaster',
	function(
		AppTypes,
		$q,
		$rootScope,
		$scope,
		$location,
		idaService,
		$modalInstance,
		$state,
		cvLoc,
		$log,
		$modalStack,
		dbsFactory,
		data,
		cvToaster
	) {
		$scope.entityType = data.entityType;
		$scope.genericEntity = data.entity;
		$scope.entity = data.entity;
		var deferred = data.deferred;
		$scope.isSnapBackupEnabled = _.get(data, 'otherOptions.isSnapBackupEnabled');
		$scope.showIncremental = true;
		$scope.showCumulative = true;

		$scope.model = {
			cumulative: false
		};

		$scope.showPreview = true;
		if ($scope.entity.applicationId === AppTypes.SAP_FOR_ORACLE) {
			$scope.showPreview = false;
			$scope.showIncremental = _.get(data, 'otherOptions.sapBackupDevice') === 'RMAN_UTIL';
			$scope.showCumulative = false;
		}

		if (!$scope.showIncremental) {
			$scope.model.backupType = 'FULL';
		} else {
			$scope.model.backupType = 'INCREMENTAL';
		}

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		$scope.closeModal = function(resp) {
			//$modalInstance.dismiss();
			deferred.resolve(resp);
			$modalInstance.dismiss();
		};

		$scope.failAndCloseModal = function(resp) {
			deferred.reject(resp);
		};

		var getBackupOption = function() {
			var backupOptions = {};
			var oracleOptions = {};
			oracleOptions.cumulative = $scope.model.cumulative;
			backupOptions.oracleOptions = oracleOptions;

			return backupOptions;
		};
		$scope.backup = function() {
			var deferred = $q.defer();
			var backupOptions = getBackupOption();
			idaService
				.backup(
					$scope.entityType,
					angular.toJson($scope.genericEntity),
					$scope.model.backupType,
					angular.toJson(backupOptions)
				)
				.success(function(wr) {
					var jobIds = wr.jobIds;
					var jobSummary = {
						jobId: jobIds[0],
						percentComplete: 0,
						status: 'Starting',
						sizeOfMediaOnDisk: 0,
						totalNumOfFiles: 0,
						jobElapsedTime: 0
					};
					var job = {
						jobSummary: jobSummary,
						showProgress: true,
						kill: true,
						suspend: true,
						resume: false
					};
					$scope.backupMsg = cvLoc('notification.backup.started');
					deferred.resolve(job);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						$scope.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						$scope.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		$scope.goToJob = function() {
			var top = $modalStack.getTop();
			if (top) {
				$modalStack.dismiss(top.key);
				event.preventDefault();
			}
			$location.path('jobs/' + $scope.backupJobId);
		};

		$scope.startBackup = function() {
			var result = {};
			result.backupType = $scope.model.backupType;
			$scope.loading = true;
			$scope.backup().then(
				function(resp) {
					$scope.loading = false;
					$scope.backupJobId = resp.jobSummary.jobId;
					$scope.closeModal(resp);
					var backupMsg = cvLoc('notification.backupJob', $scope.backupJobId);
					var viewMsg = cvLoc('notification.jobDetails');
					cvToaster.showSuccessMessage({
						ttl: '7000',
						message: backupMsg + ' <br><a href=#/jobs/' + $scope.backupJobId + '>' + viewMsg + '</a>'
					});
				},
				function(resp) {
					$scope.loading = false;
					$scope.backupMsg = resp.data;
					$scope.serverMessage = {
						type: 'error',
						message: resp.data
					};
					$scope.failAndCloseModal(resp);
				}
			);
		};

		$scope.viewScriptPreview = function(restoreForm) {
			var taskObjet = {};

			taskObjet = {
				task: {
					taskType: 1,
					initiatedFrom: 1
				},
				associations: [$scope.entity],
				subTasks: [
					{
						subTask: {
							subTaskType: 2,
							operationType: 2
						},
						options: {
							backupOpts: {
								backupLevel: $scope.model.backupType === 'FULL' ? 1 : 2,
								oracleOptions: {
									cumulative: $scope.model.cumulative
								}
							}
						}
					}
				]
			};

			var dataMode = {
				task: taskObjet,
				taskType: 'BACKUP',
				isSnapSubclient: $scope.isSnapBackupEnabled
			};
			let modalInstance = dbsFactory.showScriptPreviewDialog(dataMode);
			modalInstance.result.then(function(data) {
				if (data) {
					$scope.cancel();
				}
			});
		};
	}
]);

app.filter('oraInstanceStatusFilter', [
	function() {
		return function(data) {
			var statusString = '';
			switch (parseInt(data)) {
				case 91:
					statusString = 'SHUTDOWN';
					break;
				case 92:
					statusString = 'STARTED';
					break;
				case 93:
					statusString = 'MOUNTED';
					break;
				case 94:
				case 95:
				case 96:
					statusString = 'OPEN';
					break;
				default:
					statusString = 'UNKNOWN';
			}
			return statusString;
		};
	}
]);

app.controller('oracleRestoreOptionsCtrl', [
	'$scope',
	'$log',
	'cvUtil',
	'dbsUtil',
	'dbsFactory',
	'$uibModal',
	'$uibModalInstance',
	'$timeout',
	'$stateParams',
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'$filter',
	'idaService',
	'jobService',
	'data',
	'$dialogs',
	function(
		$scope,
		$log,
		cvUtil,
		dbsUtil,
		dbsFactory,
		$modal,
		$modalInstance,
		$timeout,
		$stateParams,
		cvToaster,
		cvLoc,
		AppTypes,
		$filter,
		idaService,
		jobService,
		data,
		$dialogs
	) {
		//we give an option to restore this VM if we have a guid
		$scope.oraInstanceStatus = '';
		$scope.restoreData = {
			globalOptions: {
				destinationServerList: [],
				dataMaskingOptions: {},
				controlfile: true,
				spfile: false,
				database: true,
				snapRestoreType: 'true',
				pitDate: new Date(),
				pitType: '3',
				streams: 2,
				rmanDuplicate: false,
				duplicateStandby: false
			},
			proxyClient: {},
			isInplaceRestore: () => $scope.tabControls.getCurrentTabId() === '0'
		};
		$scope.tabControls = {};
		//selectedEntity
		$scope.selectedVM = [];
		$scope.entity = data.entity;
		$scope.entityType = data.entityType;
		$scope.selectedRows = data.selectedRows;
		$scope.isFullDataRestore = data.isFullDataRestore;
		$scope.toTime = data.toTime;
		$scope.isOracleRac = $scope.entity.applicationId == AppTypes.ORACLE_RAC;
		$scope.isSnapBackupEnabled;
		$scope.isTableLevelRestore = data.isTableLevelRestore;

		$scope.hideOutOfPlaceRestore = false;
		let isPDBInstance = false;
		//PDB clone feature is moved to SP25
		/*if ($scope.selectedRows) {
			isPDBInstance = _.get($scope.selectedRows[0], 'fileType', '') === 'DATABASE';
		}*/
		if (!isPDBInstance && !$scope.isFullDataRestore) {
			$scope.hideOutOfPlaceRestore = true;
		}

		//For use in JSP
		$scope.AppTypes = AppTypes;
		if ($scope.isOracleRac) {
			//Retrieve data from cv-rac-manage-instances directive
			$scope.getStreamsFunc = {};
			//Refresh data in directive
			$scope.refreshFunc = {};
		}

		$scope.rmanDuplicateSelected = function() {
			$scope.restoreData.globalOptions.rmanDuplicate = !$scope.restoreData.globalOptions.rmanDuplicate;
		};
		$scope.isPITValide = function() {
			if (
				$scope.restoreData.globalOptions.pitType == '1' &&
				(!$scope.restoreData.globalOptions.pitDate ||
					new Date($scope.restoreData.globalOptions.pitDate) == 'Invalid Date')
			)
				return false;
			else return true;
		};

		if ($scope.toTime && $scope.toTime > 0) {
			$scope.restoreData.globalOptions.pitType = '1';
			var dateObject = new Date(parseInt($scope.toTime) * 1000);
			$scope.restoreData.globalOptions.pitDate = cvUtil.convertUTCDateToLocalDate(dateObject);
		}

		let loadJobDetails = function(jobId) {
			jobService.getJobDetail(
				{
					jobId: jobId,
					commcellId: 2
				},
				function(data) {
					let oracleJob = _.get(data, 'jobDetail.detailInfo.xmlJobInfo.bkpJobInfo.oracleJob');
					if (oracleJob) {
						$scope.restoreData.globalOptions.controlFileBackupPiece = oracleJob.controlFileBackupPiece;
						//For the Oracle RAC SCN number will be more than one, we need to get the least number for the string value
						if ($scope.isOracleRac && oracleJob.nextChange) {
							let lsnNumbersStr = oracleJob.nextChange.split(',');
							let lsnNumbers = [];
							lsnNumbersStr.forEach(function(lsnNumberStr) {
								if (lsnNumberStr.indexOf('-') !== -1) {
									lsnNumberStr = lsnNumberStr.substr(3, lsnNumberStr.length).trim();
								}
								lsnNumbers.push(parseInt(lsnNumberStr));
							});
							lsnNumbers = _.sortBy(lsnNumbers);
							$scope.restoreData.globalOptions.pitScn = lsnNumbers[0];
						} else {
							$scope.restoreData.globalOptions.pitScn = oracleJob.nextChange;
						}
						$scope.restoreData.globalOptions.pitType = '2';
					}
				},
				function(data) {
					$log.error('job could not be loaded for Id : ' + $scope.jobId);
				}
			);
		};
		if (data.jobId) {
			loadJobDetails(data.jobId);
		}

		let loadSourceDetails = function(sourceInstance) {
			idaService.getInstanceDetails(sourceInstance.instanceId).success(function(data) {
				if (data) {
					let useCatalogConnecProp = 'oracleInstance.useCatalogConnect';
					let sourceCatalogProp = 'oracleInstance.catalogConnect';
					if ($scope.isOracleRac) {
						useCatalogConnecProp = 'oracleRACInstance.useCatalogConnect';
						sourceCatalogProp = 'oracleRACInstance.connectString';
					}
					let useCatalogConnect = _.get(data, useCatalogConnecProp);
					if (useCatalogConnect) {
						$scope.sourceCatalog = _.get(data, sourceCatalogProp);
					}
				}
			});
		};
		loadSourceDetails($scope.entity);
		var checkSnapEnabled = function() {
			idaService.getChildranData('SUBCLIENT_ENTITY', $scope.entity).success(function(data) {
				if (data) {
					for (var i = 0; i < data.length; i++) {
						$scope.isSnapBackupEnabled = _.get(data[i], 'commonProperties.snapCopyInfo.isSnapBackupEnabled', false);
						if ($scope.isSnapBackupEnabled) {
							return;
						}
					}
				}
			});
		};
		checkSnapEnabled();

		$scope.axuPathResuleFunction = function(result) {
			if (result) {
				$scope.restoreData.globalOptions.axuPath = result.path;
			}
		};

		$scope.showRedirectOptionDialog = function() {
			var clientEntity = $scope.entity;
			if ($scope.restoreData.globalOptions.destinationServer) {
				clientEntity = $scope.restoreData.globalOptions.destinationServer;
			}

			var redirectOption = null;
			var redirectAllPath = null;
			var dataFilesList = null;
			let onlineLogDest = null;
			let redoLogs = false;
			if ($scope.redirectOptions) {
				if ($scope.redirectOptions.redirectAllItemsSelected !== undefined) {
					redirectOption = $scope.redirectOptions.redirectAllItemsSelected ? 'ALL' : 'INDIVIDUAL';
				}
				if ($scope.redirectOptions.renamePathForAllTablespaces) {
					redirectAllPath = $scope.redirectOptions.renamePathForAllTablespaces;
				}
				if ($scope.redirectOptions.dataFilesList) {
					dataFilesList = $scope.redirectOptions.dataFilesList;
				}
				if ($scope.redirectOptions.onlineLogDest) {
					onlineLogDest = $scope.redirectOptions.onlineLogDest;
				}
				if ($scope.redirectOptions.redoLogs) {
					redoLogs = $scope.redirectOptions.redoLogs;
				}
			}

			var dataResolve = function() {
				return {
					entity: data.entity,
					entityType: data.entityType,
					clientEntity: clientEntity,
					selectedRows: data.selectedRows,
					redirectOption: redirectOption,
					redirectAllPath: redirectAllPath,
					dataFilesList: dataFilesList,
					rmanDuplicate: $scope.restoreData.globalOptions.rmanDuplicate,
					onlineLogDest: onlineLogDest,
					redoLogs: redoLogs
				};
			};
			var modelInsta = $modal.open({
				controller: 'oracleRestoreRedirectCtrl',
				controllerAs: 'rrOptions',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/oracleRestoreRedirect.jsp',
				resolve: {
					data: dataResolve
				}
			});
			modelInsta.result.then(function(redirectOptions) {
				if (redirectOptions) {
					$scope.redirectOptions = redirectOptions;
				}
			});
		};

		var loadDestinationServerList = function() {
			idaService
				.getRestoreDestinations(
					$scope.entity.clientId,
					$scope.entity.applicationId,
					$scope.entity.instanceName,
					$scope.entity.instanceId
				)
				.then(
					function(data) {
						var serverList = [];
						data.data.sort((a, b) => {
							return a.clientName.localeCompare(b.clientName);
						});
						for (var i = 0; i < data.data.length; i++) {
							serverList.push(data.data[i]);
							if (data.data[i].clientId == $scope.entity.clientId) {
								//$scope.restoreData.globalOptions.destinationServer = data.data[i];
								$scope.inplaceDestinationServer = data.data[i];
							}
						}
						$scope.restoreData.globalOptions.destinationServerList = serverList;
						//$scope.destinationServerChanged($scope.restoreData.globalOptions.destinationServer);

						//In case partial db restore select the inplace restore and disable out of place restore

						$timeout(function() {
							if (!$scope.hideOutOfPlaceRestore) {
								$scope.tabControls.selectTab(1);
								$scope.restoreData.globalOptions.controlfile = true;
							} else {
								$scope.tabControls.selectTab(0);
								$scope.restoreData.globalOptions.controlfile = false;
							}
						});
					},
					function(e) {
						$log.error(e);
					}
				);
		};
		loadDestinationServerList();

		var pitDate = new Date();

		$scope.destinationServerChanged = function(destClient) {
			// When destination is changed, server-specific options like path become invalid and must be cleared:
			//$scope.oraInstanceStatus = cvLoc('status.GETTINGSTATUS');
			var instanceEntity = new Object();
			instanceEntity.clientId = destClient.clientId;
			instanceEntity.applicationId = destClient.applicationId;
			instanceEntity.instanceId = 0;
			$scope.populateInstanceList(destClient.clientId, destClient.applicationId);
		};

		$scope.importServerChanged = function(destClient, event) {
			//event.preventDefault();
			$scope.restoreData.globalOptions.importInstanceList = [];
			idaService
				.getInstances(destClient.clientId, destClient.applicationId)
				.success(function(data) {
					if (data != null) {
						var instanceList = [];
						angular.forEach(data, function(instance) {
							var isASM =
								instance.instance.instanceName.indexOf('+ASM') == 0 || instance.instance.instanceName == '-MGMTDB';
							if (!isASM && !(instance.oracleInstance && instance.oracleInstance.isOnDemand)) {
								instanceList.push(instance.instance);
							}
						});
						$scope.restoreData.globalOptions.importInstanceList = cvUtil.sortAscending(instanceList, 'instanceName');
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		function refreshRacStreams() {
			if ($scope.isOracleRac && $scope.refreshFunc && $scope.refreshFunc.refresh) {
				$scope.refreshFunc.refresh($scope.restoreData.globalOptions.destinationInstance);
			}
		}

		$scope.destinationInstanceChanged = function() {
			refreshRacStreams();
		};

		/***
		 * When tab is in place restore, destinationserver and destiination instance should be set
		 * to source so that there is no regression issues.
		 */
		$scope.handleTabChange = function() {
			if ($scope.tabControls.getCurrentTabId() == 0) {
				$scope.restoreData.globalOptions.destinationServer = $scope.inplaceDestinationServer;
				$scope.destinationServerChanged($scope.restoreData.globalOptions.destinationServer);
			} else {
				$scope.restoreData.globalOptions.destinationInstance = undefined;
			}
		};

		/***
		 * Tried to use ng-selected on cv-tab, but it's being called infinite times..
		 * For now, use watch since there are no other APIs exposed by cv-tab directive
		 */
		$scope.afterTabInit = function() {
			$scope.$watch($scope.tabControls.getCurrentTabId, $scope.handleTabChange);
		};

		$scope.shouldDisableInstance = function(instanceId) {
			return instanceId === $scope.entity.instanceId;
		};

		$scope.populateInstanceList = function(clientId, applicationId) {
			var sourceInstanceId = 0;
			$scope.restoreData.globalOptions.destinationInstanceList = [];
			idaService
				.getInstances(clientId, applicationId)
				.success(function(data) {
					if (data != null) {
						var instanceList = [];
						data.sort((a, b) => {
							a.instance.instanceName.localeCompare(b.instance.instanceName);
						});
						angular.forEach(data, function(instance) {
							var isASM =
								instance.instance.instanceName.indexOf('+ASM') == 0 || instance.instance.instanceName == '-MGMTDB';
							if (!isASM && !(instance.oracleInstance && instance.oracleInstance.isOnDemand)) {
								//if(instance.instance.instanceId != $scope.entity.instanceId) {
								if (
									(instance.oracleInstance && instance.oracleInstance.useCatalogConnect) ||
									(instance.oracleRACInstance && instance.oracleRACInstance.useCatalogConnect)
								) {
									if (instance.oracleRACInstance) {
										instance.instance.catalogConnect = instance.oracleRACInstance.connectString;
									} else {
										instance.instance.catalogConnect = instance.oracleInstance.catalogConnect;
									}
								} else {
									instance.instance.catalogConnect = null;
								}
								instance.instance.dbname = _.get(instance, 'oracleInstance.dbname');
								instanceList.push(instance.instance);
								//}
								if (instance.instance.instanceId == $scope.entity.instanceId) {
									instance.instance.disabled = true;
									$scope.inplaceDestinationInstance = instance.instance;
									if ($scope.tabControls.getCurrentTabId() == 0) {
										$scope.restoreData.globalOptions.destinationInstance = instance.instance;
										refreshRacStreams();
									}
								}
							}
						});
						$scope.restoreData.globalOptions.destinationInstanceList = cvUtil.sortAscending(
							instanceList,
							'instanceName'
						);
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		$scope.resultFunction = function(result) {
			if (result != null) {
				var strPitDate = cvUtil.formatDate(result.toDateString, 'medium', null);
				$scope.restoreData.globalOptions.pitDate = strPitDate;
			}
		};

		//Only show data masking for out of place restore
		$scope.showDataMasking = function() {
			if (
				!$scope.restoreData.globalOptions.destinationServer ||
				!$scope.restoreData.globalOptions.destinationInstance
			) {
				return false;
			}
			if (
				$scope.entity.clientId != $scope.restoreData.globalOptions.destinationServer.clientId ||
				$scope.entity.instanceId != $scope.restoreData.globalOptions.destinationInstance.instanceId
			) {
				return true;
			}

			return false;
		};

		$scope.refreshOraInstance = function(instanceEntity) {
			instanceFactory
				.refreshOraInstance({
					gnEntity: angular.toJson(instanceEntity)
				})
				.success(function(data) {
					if (data) {
						var statusValue = $filter('oraInstanceStatusFilter')(data);
						var statusString = 'status.' + statusValue;

						$scope.oraInstanceStatus = cvLoc('label.status') + ' : ' + cvLoc(statusString);
					}
				})
				.error(function(e) {
					var msgStr = cvLoc('error.Status');
					cvToaster.showErrorMessage({
						ttl: '15000', //10 sec
						message: msgStr
					});
					$scope.oraInstanceStatus = '';
				});
		};
		//$scope.refreshOraInstance($scope.entity);

		$scope.cancelModel = function() {
			$modalInstance.close();
		};

		/*
		 * Show restore confirmation since data can be overwritten.
		 */
		$scope.confirmRestore = function(destination, yesFunction) {
			var sClient = $scope.entity.clientName;
			var sInstance = $scope.entity.instanceName;
			var dClient = destination.destClient.clientName;
			var dInstance = destination.destinationInstance.instanceName;
			var isInplace = sClient == dClient && sInstance == dInstance;
			var message = isInplace
				? cvLoc('label.confirmOracleRestoreInPlace', sClient, sInstance)
				: cvLoc('label.confirmOracleRestoreOutOfPlace', sClient, sInstance, dClient, dInstance, dInstance);
			$dialogs.confirm(cvLoc('label.confirm'), message, {
				yesFunction: yesFunction,
				noFunction: function() {}
			});
		};

		$scope.viewScriptPreview = function(restoreForm) {
			if (!restoreForm.$valid) {
				angular.forEach(restoreForm.$error.required, function(field) {
					field.$setDirty();
				});
				return;
			}

			$scope.pitError = false;
			if (!$scope.isPITValide()) {
				$scope.pitError = true;
				return;
			}

			var taskObjet = {};
			var browseOption = composeBrowseOption();
			var destination = composeDestination();
			var commonOptions = composeCommonOptions();
			var agentSpecificOptions = composeAgentSpecificOptions();
			if (
				$scope.restoreData.globalOptions.rmanDuplicate &&
				_.get($scope.entity, 'clientId', 0) !== _.get(destination, 'destClient.clientId', 0)
			) {
				//If the source and destination are different set the duplicateNoFileNamecheck flag
				agentSpecificOptions.duplicateNoFileNamecheck = true;
			}
			if (agentSpecificOptions.restoreFrom === '1') {
				let pitTimeValue = Math.round($scope.restoreData.globalOptions.pitDate.getTime() / 1000);
				if (agentSpecificOptions.restoreControlFile) {
					agentSpecificOptions.specifyControlFileTime = true;
					_.set(agentSpecificOptions, 'controlFileTime.time', pitTimeValue);
				}
				if (agentSpecificOptions.restoreSPFile) {
					agentSpecificOptions.specifySPFileTime = true;
					_.set(agentSpecificOptions, 'SPFileTime.time', pitTimeValue);
				}
				_.set(agentSpecificOptions, 'recoverTime.time', pitTimeValue);
				_.set(agentSpecificOptions, 'restoreTime.time', pitTimeValue);
			}
			var sourceItem = getSourceItems();
			taskObjet = {
				task: {
					taskType: 1,
					initiatedFrom: 1
				},
				associations: [$scope.entity],
				subTasks: [
					{
						subTask: {
							subTaskType: 3,
							operationType: 1001
						},
						options: {
							restoreOptions: {
								browseOption: browseOption,
								destination: destination,
								oracleOpt: agentSpecificOptions,
								commonOptions: commonOptions,
								fileOption: {
									sourceItem: sourceItem
								}
							}
						}
					}
				]
			};

			var dataMode = {
				task: taskObjet,
				taskType: 'RESTORE',
				isSnapSubclient: $scope.isSnapBackupEnabled
			};
			let modalInstance = dbsFactory.showScriptPreviewDialog(dataMode);
			modalInstance.result.then(function(data) {
				if (data) {
					$scope.cancelModel();
				}
			});
		};

		$scope.doRestore = function() {
			$scope.pitError = false;
			if (!$scope.isPITValide()) {
				$scope.pitError = true;
				return;
			}
			var genericEntity = angular.copy($scope.entity);

			var browseOption = composeBrowseOption();
			var destination = composeDestination();
			var commonOptions = composeCommonOptions();
			var agentSpecificOptions = composeAgentSpecificOptions();
			if (_.get($scope.entity, 'clientId', 0) !== _.get(destination, 'destClient.clientId', 0)) {
				//If the source and destination are different set the duplicateNoFileNamecheck flag
				agentSpecificOptions.duplicateNoFileNamecheck = true;
			}
			var rdsOption = {};
			var sourceItems = getSourceItems();
			var dataMaskingOptions = composeDataMaskingOptions();

			$scope.confirmRestore(destination, function() {
				idaService
					.submitRestoreJob({
						entityType: $scope.entityType,
						genericEntity: angular.toJson(genericEntity),
						browseOption: angular.toJson(browseOption),
						destination: angular.toJson(destination),
						commonOptions: angular.toJson(commonOptions),
						sourceItemsToRestore: angular.toJson(sourceItems),
						agentSpecificOptions: angular.toJson(agentSpecificOptions),
						dmOptions: $scope.showDataMasking() ? angular.toJson(dataMaskingOptions) : undefined,
						rdsOption: angular.toJson(rdsOption)
					})
					.success(function(data) {
						dbsUtil.showRestoreToaster(data);
						$scope.cancelModel();
					})
					.error(function(err) {
						cvToaster.showErrorMessage({
							message: err
						});
					});
			});
		};

		var composeDataMaskingOptions = function() {
			return $scope.restoreData.globalOptions.dataMaskingOptions;
		};

		var composeCommonOptions = function() {
			var commonOptions = {};
			if ($scope.tabControls && $scope.tabControls.getCurrentTabId() === '0' && $scope.isSnapBackupEnabled) {
				commonOptions.revert = $scope.restoreData.globalOptions.hardwareRevert;
			}
			if ($scope.isSnapBackupEnabled) {
				commonOptions.useRmanRestore = $scope.restoreData.globalOptions.snapRestoreType;
			}
			return commonOptions;
		};

		var composeBrowseOption = function() {
			var browseOption = {
				commCellId: 2,
				timeRange: {
					fromTimeValue: $stateParams['fromTime'] ? $stateParams['fromTime'] : null,
					toTimeValue: $stateParams['toTime'] ? $stateParams['toTime'] : null
				}
			};

			if (data.copyPrecedence) {
				angular.extend(browseOption, {
					mediaOption: {
						copyPrecedence: {
							copyPrecedenceApplicable: true,
							copyPrecedence: data.copyPrecedence
						}
					}
				});
			}
			//set proxy option if set.
			if ($scope.restoreData.proxyClient && $scope.restoreData.proxyClient.id) {
				let proxyForSnapClients = {
					clientId: $scope.restoreData.proxyClient.id,
					clientName: $scope.restoreData.proxyClient.name
				};
				_.set(browseOption, 'mediaOption.proxyForSnapClients', proxyForSnapClients);
			}
			return browseOption;
		};

		var composeDestination = function() {
			var destination = {};

			destination.inPlace = $scope.restoreData.globalOptions.restoreToOriginalPath;
			//In place selected
			if ($scope.tabControls.getCurrentTabId() == 0) {
				destination.destClient = angular.copy($scope.entity);
				destination.destinationInstance = angular.copy($scope.entity);
			} else {
				destination.destClient = {
					clientId: $scope.restoreData.globalOptions.destinationServer.clientId,
					clientName: $scope.restoreData.globalOptions.destinationServer.clientName
				};
				if ($scope.restoreData.globalOptions.destinationInstance) {
					destination.destinationInstance = $scope.restoreData.globalOptions.destinationInstance;
				}
			}
			if (destination.inPlace === false) {
				destination.destPath = [];
				destination.destPath.push($scope.selectedPath);
			}
			return destination;
		};

		var composeRedirectPaths = function(dataFilesList, agentSpecificOptions) {
			var redirectItems = [];
			var redirectItemsValue = [];
			var seperatorVal = String.fromCharCode(9);
			var seperator12 = String.fromCharCode(0x15);

			angular.forEach(dataFilesList, function(dataFileNode) {
				var dataFile = _.get(dataFileNode, 'dataFile');
				var oldDataFile = _.get(dataFileNode, 'oldDataFile');
				if (!dataFileNode.deleted && dataFile != oldDataFile) {
					// check the data file is modified
					var tableSpace = dataFileNode.tableSpace;
					if (dataFileNode.database) {
						tableSpace = dataFileNode.database + ':' + tableSpace;
					}
					var fileVal = tableSpace + seperatorVal + dataFileNode.oldDataFile + seperatorVal + dataFileNode.dataFile;
					redirectItemsValue.push(fileVal);

					var file = '';
					if (dataFileNode.dataFile.indexOf('/') == 0) {
						file = tableSpace + '/' + dataFileNode.oldDataFile + seperator12 + dataFileNode.dataFile;
					} else {
						file = tableSpace + '\\' + dataFileNode.oldDataFile + seperator12 + dataFileNode.dataFile;
					}
					redirectItems.push(file);
				}
			});
			agentSpecificOptions.redirectItems = redirectItems;
			agentSpecificOptions.redirectItemsValue = redirectItemsValue;
		};

		var composeAgentSpecificOptions = function() {
			var agentSpecificOptions = {};

			//property of OracleRstOption
			agentSpecificOptions.restoreData = $scope.restoreData.globalOptions.database;
			agentSpecificOptions.archiveLog = $scope.restoreData.globalOptions.archiveLog;
			agentSpecificOptions.restoreControlFile = $scope.restoreData.globalOptions.controlfile;
			agentSpecificOptions.restoreSPFile = $scope.restoreData.globalOptions.spfile;

			if ($scope.tabControls.getCurrentTabId() == 1) {
				agentSpecificOptions.setDBId = true;
			}
			agentSpecificOptions.restoreStream = $scope.restoreData.globalOptions.streams;
			agentSpecificOptions.switchDatabaseMode = true;
			agentSpecificOptions.noCatalog = true;
			var catalogConnect = $scope.restoreData.globalOptions.destinationInstance.catalogConnect;
			var catalogUser = _.get($scope.restoreData.globalOptions.destinationInstance, 'catalogConnect.userName');
			if (angular.isDefined(catalogUser)) {
				agentSpecificOptions.noCatalog = false;
				agentSpecificOptions.catalogConnect3 = catalogConnect.domainName;
				agentSpecificOptions.catalogConnect1 = catalogConnect.userName;
			}

			agentSpecificOptions.resetLogs = 0;
			if ($scope.restoreData.globalOptions.controlfile || $scope.restoreData.globalOptions.pitType == '3') {
				agentSpecificOptions.resetLogs = 1; // on selecting the control file restore we need to set rest logs to on.
			}
			if ($scope.tabControls && $scope.tabControls.getCurrentTabId() === '1') {
				agentSpecificOptions.crossmachineRestoreOptions = {
					doNidForCrossMachineRestore: true
				};
			}
			agentSpecificOptions.recoverSCN = $scope.restoreData.globalOptions.pitScn;
			agentSpecificOptions.ctrlBackupPiece = $scope.restoreData.globalOptions.controlFileBackupPiece;
			agentSpecificOptions.recoverFrom = $scope.restoreData.globalOptions.pitType;
			agentSpecificOptions.restoreFrom = $scope.restoreData.globalOptions.pitType;
			if ($scope.restoreData.globalOptions.pitType == '1') {
				agentSpecificOptions.restoreFrom = $scope.restoreData.globalOptions.pitType;
				var cvDate = new Object();
				var timeValue = cvUtil.formatDate($scope.restoreData.globalOptions.pitDate, 'yyyy-MM-ddTHH:mm:ss', 'UTC');
				cvDate.timeValue = timeValue;
				agentSpecificOptions.recoverTime = cvDate;
			}
			// Populating default values
			if ($scope.restoreData.globalOptions.database) {
				agentSpecificOptions.recover = true;
			}

			if (!$scope.isFullDataRestore) {
				agentSpecificOptions.partialRestore = true;
				agentSpecificOptions.stagingPath = $scope.restoreData.globalOptions.axuPath;
				agentSpecificOptions.cleanupAuxiliary = true;
			}

			if ($scope.redirectOptions) {
				agentSpecificOptions.redirectAllItemsSelected = $scope.redirectOptions.redirectAllItemsSelected;
				agentSpecificOptions.redirectItemsPresent = true;
				if (agentSpecificOptions.redirectAllItemsSelected) {
					agentSpecificOptions.renamePathForAllTablespaces = $scope.redirectOptions.renamePathForAllTablespaces;
				} else {
					composeRedirectPaths($scope.redirectOptions.dataFilesList, agentSpecificOptions);
				}
				if ($scope.redirectOptions.redoLogs) {
					let redirectPath = 'crossmachineRestoreOptions.onlineLogDest';
					if ($scope.restoreData.globalOptions.rmanDuplicate) {
						redirectPath = 'redirectTempFilesValue';
						agentSpecificOptions.redirectTempFilesSelected = true;
					}
					_.set(agentSpecificOptions, redirectPath, $scope.redirectOptions.onlineLogDest);
				}
			}

			if ($scope.restoreData.globalOptions.rmanDuplicate) {
				agentSpecificOptions.duplicate = true;
				agentSpecificOptions.restoreControlFile = false;

				let dbName = $scope.restoreData.globalOptions.destinationInstance.dbname;
				if (dbName) {
					agentSpecificOptions.duplicateToName = dbName;
				} else {
					agentSpecificOptions.duplicateToName = $scope.restoreData.globalOptions.destinationInstance.instanceName;
				}
				agentSpecificOptions.duplicateStandby = $scope.restoreData.globalOptions.duplicateStandby;
				if ($scope.restoreData.globalOptions.duplicateStandby) {
					agentSpecificOptions.duplicateStandbySID = 'dup';
					agentSpecificOptions.duplicateStandbyDoRecover = false;
				} else {
					agentSpecificOptions.duplicateTo = true;
				}
				// we need to populate source instance catalog connection details
				if ($scope.sourceCatalog) {
					var catalogConnect = $scope.sourceCatalog;
					var catalogUser = _.get($scope.sourceCatalog, 'userName');
					if (catalogUser) {
						agentSpecificOptions.skipTargetConnection = true;
						agentSpecificOptions.noCatalog = false;
						agentSpecificOptions.catalogConnect3 = catalogConnect.domainName;
						agentSpecificOptions.catalogConnect1 = catalogConnect.userName;
					} else {
						agentSpecificOptions.catalogConnect3 = '';
						agentSpecificOptions.catalogConnect1 = '';
					}
				}
			}

			//For restoring to RAC populate streams values
			if (
				$scope.isOracleRac &&
				$scope.restoreData.globalOptions.destinationInstance.applicationId == AppTypes.ORACLE_RAC
			) {
				var racStreamsObject = $scope.getStreamsFunc.getRacStreams();
				angular.extend(agentSpecificOptions, racStreamsObject);
			}
			return agentSpecificOptions;
		};

		var getOracleSourcePath = function(sourceItem) {
			var sourcePath = 'SID:' + ' ' + $scope.entity.instanceName + ' ';
			switch (sourceItem.fileType) {
				case 'TABLESPACE':
					sourcePath = sourcePath + 'Tablespace:' + ' ';
					if (sourceItem.userObject.database) {
						sourcePath = sourcePath + sourceItem.userObject.database + ':';
					}
					sourcePath = sourcePath + sourceItem.userObject.tableSpace;
					break;
				case 'DATABASE':
					sourcePath = sourcePath + 'Tablespace:' + ' ' + sourceItem.userObject.database;
					break;
				case 'DATAFILE':
					sourcePath = sourcePath + 'Tablespace:' + ' ';
					if (sourceItem.userObject.database) {
						sourcePath = sourcePath + sourceItem.userObject.database + ':';
					}
					sourcePath = sourcePath + sourceItem.userObject.tableSpace + ' ';
					sourcePath = sourcePath + 'Datafile:' + ' ' + sourceItem.userObject.dataFile;
					break;
				case 'USER':
				case 'TABLE':
				case 'TABLESPACE':
					sourcePath = sourceItem.pathValue + '/**';
					break;
				default:
					//Whole instance restore
					sourcePath = 'SID:' + ' ' + $scope.entity.instanceName;
					break;
			}
			return sourcePath;
		};

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		var getSourceItems = function() {
			var sourceItems = [];
			angular.forEach($scope.selectedRows, function(selectedItem) {
				sourceItems.push(getOracleSourcePath(selectedItem));
			});
			return sourceItems;
		};
	}
]);

export default app;
