import { commonAllAgentsModule } from 'common/js/modules';

import 'modules/ida/js/services/postgresService.svc.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/directives/cv-client-picker.js';

var app = commonAllAgentsModule;
app.controller('mySqlRestoreController', [
	'$scope',
	'$log',
	'$uibModal',
	'$uibModalInstance',
	'$stateParams',
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'$filter',
	'idaService',
	'data',
	'agentService',
	'cvUtil',
	'mbService',
	'$dialogs',
	function(
		$scope,
		$log,
		$modal,
		$modalInstance,
		$stateParams,
		cvToaster,
		cvLoc,
		AppTypes,
		$filter,
		idaService,
		data,
		agentService,
		cvUtil,
		mbService,
		$dialogs
	) {
		var self = this;
		self.entity = data.entity;
		self.isCloudDB = data.isCloudDBInstance;
		self.tabControls = {};
		self.tabStyle = 'tab-3';
		self.isRestoreToDiskSupported = true;
		self.snapBackupEnabled = false;
		if (self.isCloudDB) {
			self.tabStyle = 'tab-2';
			self.isRestoreToDiskSupported = false;
		}
		self.isMySQLMEBInstance = _.get(data, 'isMySQLMEBInstance', false);

		self.restoreData = {
			isRecover: true,
			recoverTextPlaceHolder: cvLoc('label.StagingLocation'),
			sourceItem: [],
			pitDate: new Date(),
			pitSelectedDate: '',
			openDatePicker: false,
			hardwareRevert: false,
			destinationClients: [],
			destinationInstances: [],
			destinationInstance: {},
			instanceInfo: {},
			path: '',
			inplacePath: '',
			oldPath: '',
			mySqlRstOption: {
				dataStagingLocation: '',
				instanceRestore: false,
				isCloneRestore: false,
				pointofTime: false,
				refTime: {
					time: 0
				},
				fromTime: {
					time: 0
				},
				pointInTime: {
					time: 0
				},
				tableLevelRestore: false,
				destinationServer: {},
				//MySQL Log Restore Options
				mySqlDatabase: [],
				data: true,
				log: true,
				recurringRestore: false,
				logRestoreType: 0, //0 - for Recover ; 1- Do not recover
				//which is on selected destination client ,used to store Logs.
				destinationFolder: '',
				temporaryStagingLocation: ''
			},
			proxyClient: {},
			isInplaceRestore: () => self.tabControls.getCurrentTabId() === '0'
		};

		self.previousTabId = 0;
		self.onTabChanged = function() {
			if (self.tabControls.getCurrentTabId() != self.previousTabId) {
				self.previousTabId = self.tabControls.getCurrentTabId();
				if (self.tabControls.getCurrentTabId() == 0) {
					self.restoreData.oldPath = self.restoreData.path;
					self.restoreData.path = self.restoreData.inplacePath;
					self.restoreData.destinationClient = self.inplaceDestinationServer;
				} else {
					self.restoreData.destinationInstance = undefined;
				}
			}
		};

		if (data.toTime && data.toTime > 0) {
			let dateObject = new Date(parseInt(data.toTime) * 1000);
			self.restoreData.pitDate = cvUtil.convertUTCDateToLocalDate(dateObject);
			self.restoreData.mySqlRstOption.pointofTime = true;
		}
		self.restoreData.sourceItem.push('/');

		self.browseResuleFunction = function(result) {
			if (result) {
				self.restoreData.path = result.path;
			}
		};

		self.updateInstcesModel = function(clientId) {
			if (parseInt(clientId) <= 0) {
				return;
			}
			//update path
			idaService.getClientDetails(clientId).then(function(data) {
				if (data && data.data) {
					self.restoreData.path = _.get(data.data, 'client.jobResulsDir.path');
				}
			});

			agentService
				.getInstances(clientId, AppTypes.MYSQL)
				.success(function(result) {
					if (result.length <= 0) {
						self.restoreData.destinationInstances = [];
						return;
					}
					self.restoreData.destinationInstances = result;
				})
				.error(function(err) {
					self.restoreData.destinationInstances = [];
					$log.error(err);
				});
		};
		self.initUpdateInstcesModel = function(clientId) {
			if (parseInt(clientId) <= 0) {
				return;
			}

			idaService.getClientDetails(clientId).then(function(data) {
				if (data && data.data) {
					self.restoreData.path = _.get(data.data, 'client.jobResulsDir.path');
					self.restoreData.inplacePath = self.restoreData.path;
				}
			});

			agentService
				.getInstances(clientId, AppTypes.MYSQL)
				.success(function(result) {
					if (result.length <= 0) {
						self.restoreData.destinationInstances = [];
						return;
					}
					self.restoreData.destinationInstances = result;
					//self.setInstanceInfo(self.restoreData.destinationInstance.instanceId);
				})
				.error(function(err) {
					self.restoreData.destinationInstances = [];
					$log.error(err);
				});
		};

		self.isDisableBrowse = function() {
			let clientId = _.get(self.restoreData, 'destinationClient.clientId');

			if (clientId && clientId > 0) {
				return false;
			}
			return true;
		};

		var loadDestinationClientsAndInstances = function() {
			if (parseInt(data.entity.clientId) <= 0) return;
			self.osType = '';
			mbService.getOSType(data.entity.clientId).then(function successCallBack(response) {
				self.osType = response.data;
				var sourceEntity = angular.copy(data.entity);
				var genericEntity = angular.toJson(sourceEntity);
				idaService.getRestoreDestinationsForEntity(genericEntity).then(
					function(result) {
						var serverList = [];
						for (var i = 0; i < result.data.length; i++) {
							serverList.push(result.data[i]);
							if (result.data[i].clientId == self.entity.clientId) {
								self.inplaceDestinationServer = result.data[i];
							}
						}
						self.restoreData.destinationClients = serverList;
						self.restoreData.destinationClients.sort(function(a, b) {
							if (a.clientName === '') {
								return -1;
							}
							return a.clientName.localeCompare(b.clientName);
						});

						//first time loading
						self.initUpdateInstcesModel(data.entity.clientId);
					},
					function(e) {
						$log.error(e);
					}
				);
			});
		};
		loadDestinationClientsAndInstances();

		var pitDate = new Date();

		self.setInstanceInfo = function(instanceId) {
			if (parseInt(instanceId) <= 0) {
				return;
			}
			self.restoreData.instanceInfo = self.restoreData.destinationInstances.filter(function(entry) {
				return entry.instance.instanceId == instanceId;
			})[0];
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};
		self.closeModal = function(result) {
			$modalInstance.close();
		};

		self.shouldDisableInstance = function(instanceId) {
			return instanceId === self.entity.instanceId;
		};

		self.inValidMessage = {
			message: cvLoc('error.DataLogError'),
			type: 'error'
		};
		self.isInValid = self.restoreData.mySqlRstOption.data == false && self.restoreData.mySqlRstOption.log == false;
		self.updateOption = function() {
			self.isInValid = self.restoreData.mySqlRstOption.data == false && self.restoreData.mySqlRstOption.log == false;
		};

		/*
		 * Show restore confirmation since data can be overwritten.
		 */
		self.confirmRestore = function(destination, yesFunction) {
			let sClient = self.entity.clientName;
			let sInstance = self.entity.instanceName;
			let dClient = destination.destClient.clientName;
			let dInstance = destination.destinationInstance.instanceName;
			let isInplace = sClient == dClient && sInstance == dInstance;

			let message = cvLoc('label.confirmRestore', dClient + ' / ' + dInstance);
			let isRevert = false; //Currently revert option is not available
			let isDoNotRecover = self.tabControls.getCurrentTabId() == 2; //for Restore to disk DoNotRecover option will be set to true.
			if (!self.isCloudDB && self.restoreData.mySqlRstOption.data && !isDoNotRecover && isRevert) {
				message = cvLoc('label.confirmShutdown', dInstance, dClient);
			}
			//For restore to disk
			if (self.tabControls.getCurrentTabId() == 2) {
				message = cvLoc('label.confirmRestoreToDisk', sClient, sInstance, dClient, self.restoreData.path);
			}
			$dialogs.confirm(cvLoc('label.confirm'), message, {
				yesFunction: yesFunction,
				noFunction: function() {}
			});
		};

		self.doRestore = function() {
			/*		self.pitError = false;
		if (!self.isPITValide()) {
			self.pitError = false;
		}*/
			if (self.isInValid) return;

			var genericEntity = angular.copy(data.entity);

			var browseOption = composeBrowseOption();
			var destination = composeDestination();
			var commonOptions = composeCommonOptions();
			var agentSpecificOptions = composeAgentSpecificOptions();
			var rdsOption = {};
			var sourceItems = getSourceItems();
			self.confirmRestore(destination, function() {
				idaService
					.submitRestoreJob({
						entityType: data.entityType,
						genericEntity: angular.toJson(genericEntity),
						browseOption: angular.toJson(browseOption),
						destination: angular.toJson(destination),
						commonOptions: angular.toJson(commonOptions),
						sourceItemsToRestore: angular.toJson(sourceItems),
						agentSpecificOptions: angular.toJson(agentSpecificOptions),
						rdsOption: angular.toJson(rdsOption)
					})
					.success(function(result) {
						var msg = cvLoc('notification.restoreRequested', result);
						var viewMsg = cvLoc('notification.viewJobs');
						cvToaster.showInfoMessage({
							ttl: '10000',
							message: msg + ' <br><a href="#/jobs/' + result + '">' + viewMsg + '</a>'
						});
						self.cancel();
					})
					.error(function(err) {
						cvToaster.showErrorMessage({
							message: err
						});
					});
			});
		};

		var composeCommonOptions = function() {
			var commonOptions = {};
			if (self.tabControls && self.tabControls.getCurrentTabId() === '0' && self.snapBackupEnabled) {
				commonOptions.revert = self.restoreData.hardwareRevert;
			}
			return commonOptions;
		};

		var composeBrowseOption = function() {
			var browseOption = {
				commCellId: 2,
				timeRange: {
					fromTimeValue: data.fromTimeValue ? data.fromTimeValue : null,
					toTimeValue: data.toTimeValue ? data.toTimeValue : null
				}
			};
			/*		if (self.restoreData.mySqlRstOption.pointofTime) {
			var timeValue = cvUtil.formatDate(self.restoreData.pitDate, 'yyyy-MM-ddTHH:mm:ss', 'UTC');
			browseOption.timeRange.toTimeValue = timeValue;
		} */
			//set copy precedence
			if (data.copyPrecedence) {
				angular.extend(browseOption, {
					mediaOption: {
						copyPrecedence: {
							copyPrecedenceApplicable: true,
							copyPrecedence: data.copyPrecedence
						}
					}
				});
			}

			if (self.restoreData.proxyClient && self.restoreData.proxyClient.id) {
				let proxyForSnapClients = {
					clientId: self.restoreData.proxyClient.id,
					clientName: self.restoreData.proxyClient.name
				};
				_.set(browseOption, 'mediaOption.proxyForSnapClients', proxyForSnapClients);
			}

			return browseOption;
		};

		var composeDestination = function() {
			let destination = {};
			let destClient = {};
			let destinationInstance = {};

			if (self.tabControls.getCurrentTabId() == 0) {
				destClient = {
					clientId: self.entity.clientId,
					clientName: self.entity.clientName
				};
				destinationInstance = angular.copy(self.entity);
			} else if (self.tabControls.getCurrentTabId() == 1) {
				destClient = angular.copy(self.restoreData.destinationClient);
				destinationInstance = angular.copy(self.restoreData.instanceInfo.instance);
			} else if (self.tabControls.getCurrentTabId() == 2) {
				destClient = angular.copy(self.restoreData.destinationClient);
				//assuming client has at least one instance
				if (self.restoreData.destinationInstances.length > 0) {
					let firstInstance = self.restoreData.destinationInstances[0].instance;
					destinationInstance = angular.copy(firstInstance);
				} else {
					// This should not happen
					destinationInstance = angular.copy(self.entity);
					destinationInstance.clientId = self.restoreData.destinationClient.clientId;
					destinationInstance.clientName = self.restoreData.destinationClient.clientName;
					destinationInstance.instanceId = 0;
					destinationInstance.instanceName = '';
				}
			}
			destination.destClient = destClient;
			destination.destinationInstance = destinationInstance;
			return destination;
		};

		var composeAgentSpecificOptions = function() {
			var agentSpecificOptions = {};

			if (self.tabControls.getCurrentTabId() == 0) {
				// For in-place restores
				self.restoreData.mySqlRstOption.destinationServer.id = self.entity.instanceId;
				self.restoreData.mySqlRstOption.destinationServer.name = self.entity.instanceName;
				agentSpecificOptions = angular.copy(self.restoreData.mySqlRstOption);
				agentSpecificOptions.logRestoreType = 0;
				agentSpecificOptions.temporaryStagingLocation = self.restoreData.path;
				agentSpecificOptions.destinationFolder = '';
			} else if (self.tabControls.getCurrentTabId() == 1) {
				// For out-of-place restores
				self.restoreData.mySqlRstOption.destinationServer.id = self.restoreData.instanceInfo.instance.instanceId;
				self.restoreData.mySqlRstOption.destinationServer.name = self.restoreData.instanceInfo.instance.instanceName;
				agentSpecificOptions = angular.copy(self.restoreData.mySqlRstOption);
				agentSpecificOptions.logRestoreType = 0;
				agentSpecificOptions.temporaryStagingLocation = self.restoreData.path;
				agentSpecificOptions.destinationFolder = '';
			} else if (self.tabControls.getCurrentTabId() == 2) {
				// For restore to disk
				self.restoreData.mySqlRstOption.destinationServer.id = 0;
				self.restoreData.mySqlRstOption.destinationServer.name = '';
				agentSpecificOptions = angular.copy(self.restoreData.mySqlRstOption);
				agentSpecificOptions.logRestoreType = 1;
				agentSpecificOptions.destinationFolder = self.restoreData.path;
				agentSpecificOptions.temporaryStagingLocation = '';
			}

			if (self.restoreData.mySqlRstOption.log && self.restoreData.mySqlRstOption.pointofTime) {
				var cvDate = new Object();
				var timeValue = cvUtil.formatDate(self.restoreData.pitDate, 'yyyy-MM-ddTHH:mm:ss', 'UTC');
				cvDate.timeValue = timeValue;
				agentSpecificOptions.pointInTime = cvDate;
				agentSpecificOptions.fromTime = cvDate;
				agentSpecificOptions.refTime = cvDate;
				agentSpecificOptions.pointOfTime = true;
			} else {
				agentSpecificOptions.pointOfTime = false;
			}
			if (self.isMySQLMEBInstance) {
				agentSpecificOptions.temporaryStagingLocation = '';
				agentSpecificOptions.dataStagingLocation = '';
			}

			return agentSpecificOptions;
		};

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		var getSourceItems = function() {
			var sourceItems = [];
			let separator = '/';
			if (self.osType == 'Windows') {
				separator = '\\';
			}
			angular.forEach(data.selectedRows, function(selectedItem) {
				sourceItems.push(separator + selectedItem.userObject.displayName);
			});
			return sourceItems;
		};
	}
]);

export default app;
