import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/controllers/mySqlSubclientContent.ctrl.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/directives/cv-client-picker.js';

var app = commonAllAgentsModule;
app.controller('mySqlSubclientController', [
	'$uibModal',
	'$scope',
	'$log',
	'$state',
	'instanceService',
	'storageService',
	'subclientService',
	'cvLoc',
	'createSubclientParams',
	'cvTableOptions',
	'profileService',
	'cvUtil',
	'planPolicyModel',
	'associateSchedulePolicy',
	'idaService',
	function(
		$modal,
		$scope,
		$log,
		$state,
		instanceService,
		storageService,
		subclientService,
		cvLoc,
		createSubclientParams,
		cvTableOptions,
		profileService,
		cvUtil,
		planPolicyModel,
		associateSchedulePolicy,
		idaService
	) {
		const self = this;
		self.$onInit = () => {
			self.subclientInfo = {
				content: [],
				subClientEntity: {},
				storagePoliciesList: [],
				storagePolicy: null,
				agentInfo: {
					applicationId: 104,
					agentType: {
						backupsetSupported: false,
						instanceSupported: true
					}
				},
				numberOfBackupStreams: 2,
				numberOfTransactionLogStreams: 1,
				subclientTypeFlag: 0
			};
			self.instanceInfo = {};
			self.isStandbyApplicable = false;
			$scope.databaseList = null;
			self.subclientInfo.subClientEntity = angular.copy(createSubclientParams.idaEntity);
			self.subclientInfo.subClientEntity.subclientId = -1;
			self.subclientInfo.subClientEntity.subclientName = '';
			//set Default backupset Id
			instanceService
				.getBackupsets(
					self.subclientInfo.subClientEntity.clientId,
					self.subclientInfo.subClientEntity.applicationId,
					self.subclientInfo.subClientEntity.instanceId
				)
				.success(function(data) {
					if (data.length > 0) {
						self.subclientInfo.subClientEntity.backupsetId = data[0].backupSetEntity.backupsetId;
					}
				})
				.error(function(error) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: error
					});
				});

			//load instance details to check for standby options
			instanceService
				.getInstanceDetails(self.subclientInfo.subClientEntity.instanceId)
				.success(function(data) {
					self.instanceInfo = data;
					let isProxyEnabled = _.get(data, 'mySqlInstance.proxySettings.isProxyEnabled');
					if (isProxyEnabled) {
						let standByInstance = _.get(data, 'mySqlInstance.proxySettings.proxyInstance');
						self.isStandbyApplicable = true;
						self.standByInstanceDispalyValue = standByInstance.clientName + ' / ' + standByInstance.instanceName;
						self.subclientInfo.proxySettings = {
							isProxyEnabled: false, // Use proxy
							proxyInstance: standByInstance,
							isUseSSL: false,
							runBackupOnProxy: false,
							isFailOverToProduction: false // Use source if proxy is unavailable
						};
					}
				})
				.error(function(error) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: error
					});
				});

			self.planPolicyModel = planPolicyModel.get('Default');
			self.planPolicyModel.plan = {
				selected: _.get(createSubclientParams, 'subclientDetails.planEntity', null)
			};

			let genericEntity = {
				instanceId: self.subclientInfo.subClientEntity.instanceId,
				applicationId: self.subclientInfo.subClientEntity.applicationId,
				clientId: self.subclientInfo.subClientEntity.clientId
			};
			idaService
				.getDbContentList(angular.toJson(genericEntity))
				.success(function(data) {
					if (data && data.length > 0) {
						let databaseList = [];
						data.forEach(function(mssqlDbContent) {
							databaseList.push({
								mysqlContent: {
									databaseName: mssqlDbContent.databaseName.substr(1)
								}
							});
						});
						$scope.databaseList = databaseList;
					} else {
						$scope.databaseList = [];
					}
				})
				.error(function(errorReason) {
					$scope.databaseList = [];
					$log.debug('Cannot load Discovered Databases: ' + errorReason);
					self.serverMessage1 = cvUtil.errMsg(errorReason);
				});

			const globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

			angular.extend(globalGridOptions, {
				cvPageLinks: [],
				data: 'databaseList',
				enableGridMenu: false,
				showGridFooter: true,
				enableRowSelection: true,
				enableSelectAll: true,
				multiSelect: true,
				paginationPageSize: 10,
				selectionRowHeaderWidth: '10%',
				columnDefs: [
					{
						field: 'mysqlContent.databaseName',
						displayName: cvLoc('label.name'),
						enableFiltering: false,
						cellTemplate:
							'<span class="crop" title="{{row.entity.mysqlContent.databaseName}}">{{row.entity.mysqlContent.databaseName}}</span>',
						sort: {
							direction: 'asc',
							priority: 0
						},
						width: '90%'
					}
				],
				onRegisterApi: function(gridApi) {
					gridApi.selection.enableVerticalScrollbar = 0;

					gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
						angular.forEach(rows, function(row) {
							if (row.visible) {
								row.entity.isSelected = row.isSelected;
							}
						});
					});

					gridApi.selection.on.rowSelectionChanged($scope, function(row) {
						row.entity.isSelected = row.isSelected;
					});

					gridApi.grid.registerRowsProcessor(function(renderableRows) {
						renderableRows.forEach(function(row) {
							if (row.entity.isSelected) {
								row.isSelected = true;
							}
						});
						return renderableRows;
					}, 200);
				}
			});

			$scope.gridOptions = {
				cvGridTitle: cvLoc('pageHeader.databases'),
				cvIsPageTitle: false,
				cvTableName: 'addContent',
				cvIsSearchable: true,
				cvSearchFields: ['mysqlContent.databaseName'],
				cvServerMessage: 'addContentMessage',
				cvHasViews: false,
				cvGridDirectives: {
					uiGridSelection: true
				},
				cvGridCssClass: {
					'bottom-border-last-child': true,
					'top-bottom-border': true
				},
				cvOnGridEmpty: cvUtil.errMsg(cvLoc('label.MySqlNoDatabasesDiscovered')),
				gridOptions: globalGridOptions
			};

			self.createSubclient = function() {
				let showPlan = planPolicyModel.getPlanModeState();
				self.serverMessage = {
					message: '',
					type: ''
				};
				$log.log('Creating new database group.');
				if (showPlan) {
					self.planPolicyModel.plan.showError = false;
				}
				self.planPolicyModel.storagePolicy.showError = false;
				const storageDevice = new Object();
				if (showPlan) {
					if (self.planPolicyModel.plan.selected == null) {
						self.planPolicyModel.plan.showError = true;
						return;
					}
					self.subclientInfo.selectedPlan = self.planPolicyModel.plan.selected.id;
				} else {
					if (self.planPolicyModel.storagePolicy.selected == null) {
						self.planPolicyModel.storagePolicy.showError = true;
						return;
					}
					storageDevice.dataBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
				}

				/** Populate content */
				angular.forEach($scope.databaseList, function(entity) {
					if (entity.isSelected) {
						self.subclientInfo.content.push(entity.mysqlContent);
					}
				});

				const content = self.subclientInfo.content;
				self.contentRequired = false;
				if (content == undefined || content.length == 0) {
					self.contentRequired = true;
					self.serverMessage1 = cvUtil.errMsg(cvLoc('error.database_group_does_not_have_content'));
					return;
				}

				const commonProperties = new Object();
				commonProperties.storageDevice = storageDevice;

				const subPropInfo = new Object();
				subPropInfo.commonProperties = commonProperties;
				subPropInfo.content = [];
				subPropInfo.contentOperationType = 1;

				const mySqlSubclientProp = new Object();
				mySqlSubclientProp.numberOfBackupStreams = self.subclientInfo.numberOfBackupStreams;
				mySqlSubclientProp.numberOfTransactionLogStreams = self.subclientInfo.numberOfTransactionLogStreams;
				if (self.isStandbyApplicable) {
					mySqlSubclientProp.proxySettings = self.subclientInfo.proxySettings;
				}
				subPropInfo.mySqlSubclientProp = mySqlSubclientProp;

				subPropInfo.planEntity = {
					planId: self.subclientInfo.selectedPlan
				};
				const subClientEntity = self.subclientInfo.subClientEntity;
				const scEntity = angular.toJson(subClientEntity);
				const subInfo = angular.toJson(subPropInfo);

				subclientService
					.createSubclient({
						subClientEntity: scEntity,
						subclientInfo: subInfo,
						content: JSON.stringify(content),
						planId: null
					})
					.success(function(data) {
						self.associateScheduleToSubclient(data, showPlan);
						$state.forceReload();
						self.closeModal();
					})
					.error(function(e) {
						self.serverMessage1 = {
							message: e,
							type: 'error'
						};
					});
			};

			self.associateScheduleToSubclient = function(data, showPlan) {
				if (!showPlan) {
					/* association obj */
					let subclientDetails = {
						appId: self.subclientInfo.subClientEntity.applicationId,
						clientId: self.subclientInfo.subClientEntity.clientId,
						subclientId: data
					};
					let schedules = self.planPolicyModel.schedulePolicy;
					if (schedules && schedules.selected) {
						associateSchedulePolicy
							.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
							.success(function(successData) {
								$state.forceReload();
								self.closeModal();
							})
							.error(function(errorMessage) {
								self.serverMessage1 = {
									message: errorMessage,
									type: 'error'
								};
							});
					}
				} else {
					$state.forceReload();
					self.closeModal();
				}
			};

			self.cancel = function() {
				$scope.$close();
			};

			self.closeModal = function(result) {
				$scope.$close();
			};
		};
	}
]);

export default app;
