import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/directives/cv-client-picker.js';

var app = commonAllAgentsModule;

app.controller('mySqlInstanceController', [
	'globalCacheFactory',
	'$scope',
	'$state',
	'$log',
	'cvToaster',
	'storageService',
	'instanceService',
	'idaService',
	'postgresService',
	'mbService',
	'idasFactory',
	'cvLoc',
	'cvUtil',
	'clientDetailService',
	'profileService',
	'AppTypes',
	function(
		globalCacheFactory,
		$scope,
		$state,
		$log,
		cvToaster,
		storageService,
		instanceService,
		idaService,
		postgresService,
		mbService,
		idasFactory,
		cvLoc,
		cvUtil,
		clientDetailService,
		profileService,
		AppTypes
	) {
		let self = this;
		this.$onInit = function() {
			// Local functions
			let updateStandbySettings = function() {
				if (self.isProxyOptionsApplicable()) {
					loadStandbyInstances();
				}
			};

			let loadStandbyInstances = function() {
				if (self.isStandbyInstanceLoaded) {
					return;
				}
				if (self.isProxyOptionsApplicable()) {
					let sourceEntity = angular.copy(self.instance);
					sourceEntity.osType = 'unix';
					postgresService.getStandbyInstances(sourceEntity).then(
						function(result) {
							self.isStandbyInstanceLoaded = true;
							let serverMap = {};
							for (let i = 0; i < result.data.length; i++) {
								let node = result.data[i];
								node.name = node.instanceName;
								if (serverMap[node.clientName]) {
									serverMap[node.clientName].push(node);
								} else {
									serverMap[node.clientName] = [node];
								}
							}
							let tmpServerList = [];
							for (let clientName in serverMap) {
								tmpServerList.push({
									name: clientName,
									msGroup: true
								});
								let instancesByClient = cvUtil.sortAscending(serverMap[clientName], 'name');
								tmpServerList = tmpServerList.concat(instancesByClient);
								tmpServerList.push({
									msGroup: false
								});
							}
							self.standbyInstances = tmpServerList;

							//self.standbyInstances = serverList;
							// set stand by instance
							if (self.edit && self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled) {
								self.standbyEnabledStatus = 'enabled-activity';
								self.standbyInstances.forEach(function(instance) {
									if (
										instance.instanceId &&
										instance.instanceId === self.instanceDetails.mySqlInstance.proxySettings.proxyInstance.instanceId
									) {
										instance.selected = true;
										self.showStandbyError = false;
									}
								});
							}
						},
						function(e) {
							$log.error(e);
						}
					);
				}
			};

			self.toggleStandbyEnabledStatus = function() {
				self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled = !self.instanceDetails.mySqlInstance
					.proxySettings.isProxyEnabled;
				self.standbyEnabledStatus = self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled
					? 'enabled-activity'
					: 'disabled-activity';
			};

			/* load plans */
			let loadPlans = function() {
				profileService
					.getEligiblePlansForApp(AppTypes.MYSQL)
					.success(function(data) {
						if (data.length > 0) {
							let planListByTypes = {};
							angular.forEach(data, planData => {
								planData = planData.planSummary ? planData.planSummary : planData;
								let planObj = {
									name: planData.plan.planName,
									id: planData.plan.planId,
									type: planData.subtype,
									numAssocEntities: planData.numAssocEntities,
									numCopies: planData.numCopies,
									rpoInMinutes: planData.rpoInMinutes,
									planSummary: _.get(planData, 'plan.planSummary')
								};

								if (planListByTypes[planData.subtype]) {
									planListByTypes[planData.subtype].push(planObj);
								} else {
									planListByTypes[planData.subtype] = [planObj];
								}
							});
							let tempPlanList = [];
							for (let planType in planListByTypes) {
								tempPlanList.push({
									name: planType,
									msGroup: true
								});
								let plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
								tempPlanList = tempPlanList.concat(plansByType);
								tempPlanList.push({
									msGroup: false
								});
							}
							self.profileList = tempPlanList;
						} else {
							self.profileList = [];
						}

						if (self.hasInstancePlan) {
							planSelectonUpdate(self.instancePlanEntity, self.profileList);
						}
					})
					.error(function(e) {
						self.serverMessage = cvUtil.errMsg(e);
					});
			};

			let planSelectonUpdate = function(selectedPlan, profileList) {
				for (let planTypeNode in profileList) {
					let planNode = profileList[planTypeNode];
					if (planNode && planNode.type) {
						if (selectedPlan.planId === planNode.id) {
							planNode.selected = true;
							//Initial plan selection fix
							self.selectedProfileList[0] = planNode;
						} else {
							planNode.selected = false;
						}
					}
				}
			};

			let clearPlanSelection = function() {
				let profileList = self.profileList;
				for (let planTypeNode in profileList) {
					let planNode = profileList[planTypeNode];
					if (planNode && planNode.type && planNode.selected) {
						planNode.selected = false;
					}
				}
			};

			let loadClientPlan = function(clientId) {
				clientDetailService
					.getClientPlan(clientId)
					.success(function(data) {
						let clientPlanEntity = _.get(data, 'summary.plan');
						let hasClientPlan = clientPlanEntity && clientPlanEntity.planId > 0;
						if (self.edit) {
							if (self.hasInstancePlan) {
								planSelectonUpdate(self.instancePlanEntity, self.profileList);
							} else if (hasClientPlan) {
								planSelectonUpdate(clientPlanEntity, self.profileList);
							} else {
								clearPlanSelection();
							}
						} else {
							if (hasClientPlan) {
								planSelectonUpdate(clientPlanEntity, self.profileList);
							} else {
								clearPlanSelection();
							}
						}
					})
					.error(function(e) {});
			};

			let loadClientOsType = function(clientId) {
				mbService.getOSType(clientId).then(function successCallBack(response) {
					self.isUnixClient = response.data.toLowerCase() === 'unix';
					updateStandbySettings();
				});
				loadClientPlan(clientId);
			};

			let setInstanceData = function() {
				self.instanceDetails = {};
				self.hasInstancePlan = false;
				self.addInstance = false;
				if (self.data.editDialog && self.data.editDialog === 'Add_Instance') {
					self.addInstance = true;
					self.edit = false;
					self.clientSelection = {
						selectedClients: [],
						valideClientSelection: false,
						selectionChanged: function(clientEntity) {
							self.instance.clientId = clientEntity.clientId;
							loadClientOsType(clientEntity.clientId);
						}
					};
				} else {
					self.edit = self.data.editDialog;
				}
				self.instance = {
					instanceId: -1,
					instanceName: '',
					applicationId: self.data.idaEntity.applicationId,
					appName: self.data.idaEntity.appName,
					clientId: self.data.idaEntity.clientId,
					clientName: self.data.idaEntity.clientName
				};
				self.instanceDetails.mySqlInstance = {
					BinaryDirectory: '',
					ConfigFile: '',
					LogDataDirectory: '',
					port: '',
					SAUser: {
						userName: '',
						password: ''
					},
					unixUser: {
						userName: ''
					},
					NTUser: {
						userName: '',
						password: ''
					},
					proxySettings: {
						isProxyEnabled: false,
						proxyInstance: {
							instanceId: 0,
							flags: {}
						},
						isUseSSL: false,
						runBackupOnProxy: false
					},
					isHotBackupEnabled: false,
					hotBackupType: '1',
					xtraBackupSettings: {
						enableXtraBackup: false,
						xtraBackupBinPath: ''
					},
					noLock: false,
					sslCa: '',
					EnableAutoDiscovery: true
				};
				self.openAccordian1 = false;
				self.openAccordian2 = false;
				self.openAccordian3 = false;
				if (self.edit) {
					self.instanceDetails = self.data.instanceDetails;
					self.instance = self.data.instanceDetails.instance;
					self.instanceDetails.mySqlInstance.SAUser.password = self.dummypassword;
					self.dbPassword = self.dummypassword;
					self.osPassword = self.dummypassword;
					self.instancePlanEntity = _.get(self.instanceDetails, 'planEntity');
					if (self.instancePlanEntity && self.instancePlanEntity.planId && self.instancePlanEntity.planId > 0) {
						self.hasInstancePlan = true;
					}
					var enableMEB = _.get(self.instanceDetails, 'mySqlInstance.mebSettings.enableMEB', false);
					var enableXtraBackup = _.get(
						self.instanceDetails,
						'mySqlInstance.xtraBackupSettings.enableXtraBackup',
						false
					);
					if (enableMEB || enableXtraBackup) {
						self.instanceDetails.mySqlInstance.isHotBackupEnabled = true;
					}
					self.instanceDetails.mySqlInstance.hotBackupType = enableMEB ? '2' : '1';
					self.instanceDetails.mySqlInstance.noLock = _.get(
						self.instanceDetails,
						'mySqlInstance.EnableNoLocking',
						false
					);
				} else {
					//for create instance we should expand connection details and Configuration tiles opened.
					self.openAccordian1 = true;
					self.openAccordian2 = true;
				}
				self.newInstanceName = self.instance.instanceName;

				self.serverMessage = {
					message: '',
					type: ''
				};
			};

			let isvalidEntry = function(data) {
				if (data === undefined || data === '') {
					return false;
				}
				return true;
			};

			self.validateInputs = function(fromController) {
				let formValid = true;
				if (!fromController.$valid && fromController.$error) {
					angular.forEach(fromController.$error.required, function(field) {
						field.$setDirty();
					});
					formValid = false;
				}

				//check for Accordian1
				if (
					!isvalidEntry(self.instanceDetails.mySqlInstance.SAUser.userName) ||
					(!self.edit && !isvalidEntry(self.instanceDetails.mySqlInstance.SAUser.password)) ||
					!isvalidEntry(self.instanceDetails.mySqlInstance.port)
				) {
					self.openAccordian1 = true;
				}
				//check for Accordian2
				if (
					!isvalidEntry(self.instanceDetails.mySqlInstance.BinaryDirectory) ||
					!isvalidEntry(self.instanceDetails.mySqlInstance.LibDirectory) ||
					!isvalidEntry(self.instanceDetails.mySqlInstance.ConfigFile)
				) {
					self.openAccordian2 = true;
				}
				//check for Accordian3
				if (
					(self.instanceDetails.mySqlInstance.xtraBackupSettings.enableXtraBackup &&
						!isvalidEntry(self.instanceDetails.mySqlInstance.xtraBackupSettings.xtraBackupBinPath)) ||
					(self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled && self.showStandbyError)
				) {
					self.openAccordian3 = true;
				}
				return formValid;
			};

			let updateData = function() {
				if (self.newInstanceName !== self.instance.instanceName) {
					if (self.instance.instanceId <= 0) {
						self.instance.instanceName = self.newInstanceName;
					}
				}
				// set the password as Byte array
				if (
					self.instanceDetails.mySqlInstance.SAUser.password !== undefined &&
					self.instanceDetails.mySqlInstance.SAUser.password !== self.dummypassword
				) {
					if (self.instanceDetails.mySqlInstance.SAUser.password instanceof Array) {
						//Already encrypted
					} else {
						self.dbPassword = self.instanceDetails.mySqlInstance.SAUser.password;
						self.instanceDetails.mySqlInstance.SAUser.password = cvUtil.getBytes(
							self.instanceDetails.mySqlInstance.SAUser.password
						);
					}
				} else {
					self.isShowPasswordError = false;
					self.instanceDetails.mySqlInstance.SAUser.password = null;
				}

				if (self.isUnixClient) {
					self.instanceDetails.mySqlInstance.NTUser = null;
				} else {
					if (
						self.instanceDetails.mySqlInstance.NTUser.password !== undefined &&
						self.instanceDetails.mySqlInstance.NTUser.password !== self.dummypassword
					) {
						if (self.instanceDetails.mySqlInstance.NTUser.password instanceof Array) {
							//Already encrypted
						} else {
							self.osPassword = self.instanceDetails.mySqlInstance.NTUser.password;
							self.instanceDetails.mySqlInstance.NTUser.password = cvUtil.getBytes(
								self.instanceDetails.mySqlInstance.NTUser.password
							);
						}
					} else {
						self.instanceDetails.mySqlInstance.NTUser.password = null;
					}
				}
				//set plan
				if (self.selectedProfileList && self.selectedProfileList.length > 0) {
					self.instanceDetails.planEntity = { planId: self.selectedProfileList[0].id };
					self.showPlanError = false;
				} else {
					//for edit instance plan is optional
					self.showPlanError = !self.edit;
				}

				//set xtrabackup and enterprise backup option
				if (self.instanceDetails.mySqlInstance.isHotBackupEnabled) {
					if (self.instanceDetails.mySqlInstance.hotBackupType === '1') {
						_.set(self.instanceDetails, 'mySqlInstance.mebSettings.enableMEB', false);
						_.set(self.instanceDetails, 'mySqlInstance.xtraBackupSettings.enableXtraBackup', true);
					} else {
						_.set(self.instanceDetails, 'mySqlInstance.mebSettings.enableMEB', true);
						_.set(self.instanceDetails, 'mySqlInstance.xtraBackupSettings.enableXtraBackup', false);
						_.set(self.instanceDetails, 'mySqlInstance.EnableNoLocking', self.instanceDetails.mySqlInstance.noLock);
					}
				} else {
					_.set(self.instanceDetails, 'mySqlInstance.mebSettings.enableMEB', false);
					_.set(self.instanceDetails, 'mySqlInstance.xtraBackupSettings.enableXtraBackup', false);
				}

				//set standby instance
				if (
					self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled &&
					self.selectedStandbyList &&
					self.selectedStandbyList.length > 0
				) {
					let proxyInstance = self.selectedStandbyList[0];
					self.instanceDetails.mySqlInstance.proxySettings.proxyInstance = {
						applicationId: proxyInstance.applicationId,
						clientId: proxyInstance.clientId,
						clientName: proxyInstance.clientName,
						displayName: proxyInstance.displayName,
						instanceId: proxyInstance.instanceId,
						instanceName: proxyInstance.instanceName
					};
				}
			};

			// ----------------Start---------------------
			self.isUnixClient = false;
			self.isStandbyInstanceLoaded = false;
			self.dummypassword = 'dummypassword';
			self.dbPassword = '';
			self.osPassword = '';
			self.isShowPasswordError = true;
			self.standbyInstances = {};
			self.libraries = [];
			self.isStandbySettingApplicable = false;
			self.selectedProfileList = [];
			self.localLang = cvUtil.getIStevenLocLabels();
			self.initAfterLocalization = function() {
				self.localLang.nothingSelected = cvLoc('placeholder.selectPlan');
			};
			self.localLang1 = cvUtil.getIStevenLocLabels();
			self.initAfterLocalization1 = function() {
				self.localLang.nothingSelected = cvLoc('placeholder.ProxyInstance');
			};
			self.showPlanError = !self.edit;
			self.showStandbyError = true;
			self.standbyEnabledStatus = 'disabled-activity';
			setInstanceData();

			if (!self.addInstance) {
				loadClientOsType(self.data.idaEntity.clientId);
			}
			loadPlans();

			// exposed functions
			self.isProxyOptionsApplicable = function() {
				// TODO: Client version (>= 10.0) check is needed
				return self.edit;
			};

			self.isXtraBackupApplicable = function() {
				// TODO: Linux OS, Client version check (>= 11.0) are required
				return self.isUnixClient === true && self.edit;
			};

			self.parseIStevenOutput = function() {
				if (self.selectedProfileList && self.selectedProfileList.length === 1) {
					self.showPlanError = false;
				} else {
					//for edit instance plan is optional
					self.showPlanError = !self.edit;
				}
			};

			self.parseIStevenOutput1 = function() {
				if (self.selectedStandbyList && self.selectedStandbyList.length === 1) {
					self.showStandbyError = false;
				} else {
					if (self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled) {
						self.showStandbyError = true;
					} else {
						self.showStandbyError = false;
					}
				}
			};

			// New function to fix symbolic paths issue
			let getPath = function(result) {
				let path = '';
				if (result && result.path) {
					path = result.path;
					//check for symbolic link
					if (path.includes('->')) {
						path = path.split('->')[0].trim();
					}
				}
				return path;
			};

			// Machine browse functions
			self.binBrowseResuleFunction = function(result) {
				if (result) {
					self.instanceDetails.mySqlInstance.BinaryDirectory = getPath(result);
				}
			};

			self.libBrowseResuleFunction = function(result) {
				if (result) {
					self.instanceDetails.mySqlInstance.LogDataDirectory = getPath(result);
				}
			};

			self.archiveBrowseResuleFunction = function(result) {
				if (result) {
					self.instanceDetails.mySqlInstance.ConfigFile = getPath(result);
				}
			};

			self.socketBrowseResuleFunction = function(result) {
				if (result) {
					self.instanceDetails.mySqlInstance.port = getPath(result);
				}
			};

			self.sslBrowseResuleFunction = function(result) {
				if (result) {
					self.instanceDetails.mySqlInstance.sslCa = getPath(result);
				}
			};

			self.xtraBackupBrowseResuleFunction = function(result) {
				if (result) {
					self.instanceDetails.mySqlInstance.xtraBackupSettings.xtraBackupBinPath = getPath(result);
				}
			};

			self.enterpriseBrowseResuleFunction = function(result) {
				if (result) {
					_.set(self.instanceDetails, 'mySqlInstance.mebSettings.mebBinPath', getPath(result));
				}
			};

			self.manageXtrabackup = function() {
				self.instanceDetails.mySqlInstance.isHotBackupEnabled = !self.instanceDetails.mySqlInstance.isHotBackupEnabled;
			};

			self.manageMySqlStandBy = function() {
				self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled = !self.instanceDetails.mySqlInstance
					.proxySettings.isProxyEnabled;
			};

			self.closeDialogBox = function() {
				self.modalInstance.close();
			};

			self.submitData = function() {
				updateData();
				if (self.showPlanError) {
					return;
				}
				if (self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled && self.showStandbyError) {
					return;
				}
				// In case of add instance dialog check for the client selection
				// validation
				if (self.addInstance) {
					if (!self.clientSelection.valideClientSelection) {
						return;
					}
					if (self.clientSelection.selectedClients) {
						self.instance.clientName = self.clientSelection.selectedClients[0].clientName;
						self.instance.clientId = self.clientSelection.selectedClients[0].clientId;
					}
				}

				let params = {
					instanceEntity: angular.toJson(self.instance),
					instanceProps: angular.toJson(self.instanceDetails),
					password: '',
					osUserPassword: ''
				};
				let isEdit = self.instance.instanceId > 0;
				if (isEdit && self.newInstanceName !== self.instance.instanceName) {
					params.newInstanceName = self.newInstanceName;
				}

				idaService
					.createInstance(params, isEdit)
					.success(function(successData) {
						globalCacheFactory.refreshCacheId();
						if (successData.errorCode && successData.errorCode > 0) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: successData.errorString
							});
						}
						self.modalInstance.close();
						if (isEdit) {
							$state.forceReload();
						} else {
							let instanceId = _.get(successData, 'entity.instanceId');
							if (instanceId && instanceId > 0) {
								$state.go('databaseDetails', { instanceId: successData.entity.instanceId });
							}
						}
					})
					.error(function(errorReason) {
						// On error we need to set password back as it is already encrypted.
						if (self.dbPassword !== '' && self.dbPassword !== self.dummypassword) {
							self.instanceDetails.mySqlInstance.SAUser.password = self.dbPassword;
							self.isShowPasswordError = true;
						}
						if (
							self.instanceDetails.mySqlInstance.NTUser &&
							self.osPassword !== '' &&
							self.osPassword !== self.dummypassword
						) {
							self.instanceDetails.mySqlInstance.NTUser.password = self.osPassword;
						}

						self.serverMessage = {
							message: errorReason,
							type: 'error'
						};
					});
			};

			self.openCloudDbDialog = function() {
				self.modalInstance.close();
				idasFactory.createCloudDatabase();
			};
		};
	}
]);

export default app;
