import 'modules/ida/js/services/idaService.svc.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('informixRestoreOptionsCtrl', [
	'$scope',
	'$log',
	'cvUtil',
	'dbsUtil',
	'$uibModal',
	'$uibModalInstance',
	'$stateParams',
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'$filter',
	'idaService',
	'data',
	function(
		$scope,
		$log,
		cvUtil,
		dbsUtil,
		$modal,
		$modalInstance,
		$stateParams,
		cvToaster,
		cvLoc,
		AppTypes,
		$filter,
		idaService,
		data
	) {
		var self = this;

		let RESTORE_MODES = {
			LATEST: '0',
			TIME: '1',
			UPTOLOGICAL: '2'
		};
		self.restoreData = {
			globalOptions: {
				destinationServerList: [],
				destinationInstanceList: [],
				numRestoreStreams: 4,
				restoreType: RESTORE_MODES.LATEST,
				logicalLogNumber: 1,
				restorePitDate: new Date(),
				physical: true,
				logical: true,
				restoreConfigFile: false,
				restoreMode: 1,
				hardwareRevert: false,
				restoreModeList: [
					{
						name: cvLoc('label.entireInstance'),
						value: 1
					},
					{
						name: cvLoc('label.wholeSystem'),
						value: 2
					}
				]
			},
			proxyClient: {},
			isInplaceRestore: () => self.tabControls.getCurrentTabId() === '0'
		};
		//selectedEntity
		self.tabControls = {};
		self.entity = data.entity;
		self.entityType = data.entityType;
		self.selectedRows = data.selectedRows;
		self.isFullDataRestore = data.isFullDataRestore;
		self.copyPrecedence = data.copyPrecedence;
		self.isSnapBackupEnabled = false;
		self.toTime = data.toTime;
		if (self.toTime && self.toTime > 0) {
			self.restoreData.globalOptions.restoreType = RESTORE_MODES.TIME;
			var dateObject = cvUtil.convertUTCDateToLocalDate(new Date(parseInt(self.toTime) * 1000));
			self.restoreData.globalOptions.restorePitDate = dateObject;
		}

		self.isPITValide = function() {
			if (
				self.restoreData.globalOptions.pitType == '1' &&
				(!self.restoreData.globalOptions.pitDate || new Date(self.restoreData.globalOptions.pitDate) == 'Invalid Date')
			) {
				return false;
			} else {
				return true;
			}
		};

		var loadDestinationServerList = function() {
			idaService
				.getRestoreDestinations(
					self.entity.clientId,
					self.entity.applicationId,
					self.entity.instanceName,
					self.entity.instanceId
				)
				.then(
					function(data) {
						var serverList = [];
						for (var i = 0; i < data.data.length; i++) {
							serverList.push(data.data[i]);
						}
						self.restoreData.globalOptions.destinationServerList = serverList;
					},
					function(e) {
						$log.error(e);
					}
				);
		};
		loadDestinationServerList();

		var pitDate = new Date();

		self.shouldDisableInstance = instanceId => instanceId === self.entity.instanceId;

		self.destinationServerChanged = function(destClient) {
			// When destination is changed, server-specific options like path become invalid and must be cleared:
			//self.oraInstanceStatus = cvLoc('status.GETTINGSTATUS');
			var instanceEntity = new Object();
			instanceEntity.clientId = destClient.clientId;
			instanceEntity.applicationId = destClient.applicationId;
			instanceEntity.instanceId = 0;
			self.populateInstanceList(destClient.clientId, destClient.applicationId);
		};

		self.populateInstanceList = function(clientId, applicationId) {
			var sourceInstanceId = 0;
			idaService
				.getInstances(clientId, applicationId)
				.success(function(data) {
					if (data != null) {
						var instanceList = [];
						angular.forEach(data, function(instance) {
							if (instance.instance.instanceId === self.entity.instanceId) {
								instance.instance.disabled = true;
							}
							instanceList.push(instance.instance);
						});

						self.restoreData.globalOptions.destinationInstanceList = cvUtil.sortAscending(instanceList, 'instanceName');
					}
				})
				.error(function(e) {
					self.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		self.cancelModel = function() {
			$modalInstance.close();
		};

		self.doRestore = function() {
			self.pitError = false;
			if (!self.isPITValide()) {
				self.pitError = true;
				return;
			}

			var genericEntity = angular.copy(self.entity);

			var browseOption = composeBrowseOption();
			var destination = composeDestination();
			var commonOptions = composeCommonOptions();
			var agentSpecificOptions = composeAgentSpecificOptions();
			var rdsOption = {};
			var sourceItems = getSourceItems();
			var dataMaskingOptions = composeDataMaskingOptions();

			idaService
				.submitRestoreJob({
					entityType: self.entityType,
					genericEntity: angular.toJson(genericEntity),
					browseOption: angular.toJson(browseOption),
					destination: angular.toJson(destination),
					commonOptions: angular.toJson(commonOptions),
					sourceItemsToRestore: angular.toJson(sourceItems),
					agentSpecificOptions: angular.toJson(agentSpecificOptions),
					dmOptions: angular.toJson(dataMaskingOptions),
					rdsOption: angular.toJson(rdsOption)
				})
				.success(function(data) {
					dbsUtil.showRestoreToaster(data);
					self.cancelModel();
				})
				.error(function(err) {
					cvToaster.showErrorMessage({
						message: err
					});
				});
			return;
		};

		var composeDataMaskingOptions = function() {
			return self.restoreData.globalOptions.dataMaskingOptions;
		};

		var composeCommonOptions = function() {
			var commonOptions = {};
			if (self.tabControls && self.tabControls.getCurrentTabId() === '0' && self.isSnapBackupEnabled) {
				commonOptions.revert = self.restoreData.globalOptions.hardwareRevert;
			}
			return commonOptions;
		};

		var composeBrowseOption = function() {
			var browseOption = {
				commCellId: 2,
				timeRange: {
					fromTimeValue: $stateParams['fromTime'] ? $stateParams['fromTime'] : null,
					toTimeValue: $stateParams['toTime'] ? $stateParams['toTime'] : null
				}
			};
			if (self.copyPrecedence) {
				_.set(browseOption, 'mediaOption.copyPrecedence.copyPrecedence', self.copyPrecedence);
				_.set(browseOption, 'mediaOption.copyPrecedence.copyPrecedenceApplicable', true);
			}

			if (self.restoreData.proxyClient && self.restoreData.proxyClient.id) {
				let proxyForSnapClients = {
					clientId: self.restoreData.proxyClient.id,
					clientName: self.restoreData.proxyClient.name
				};
				_.set(browseOption, 'mediaOption.proxyForSnapClients', proxyForSnapClients);
			}
			return browseOption;
		};

		var composeDestination = function() {
			var destination = {};

			destination.inPlace = false;
			if (self.tabControls.getCurrentTabId() === '0') {
				destination.inPlace = true;
				destination.destClient = {
					clientId: self.entity.clientId,
					clientName: self.entity.clientName
				};
				destination.destinationInstance = self.entity;
			} else {
				destination.destClient = {
					clientId: self.restoreData.globalOptions.destinationServer.clientId,
					clientName: self.restoreData.globalOptions.destinationServer.clientName
				};
				if (self.restoreData.globalOptions.destinationInstance) {
					destination.destinationInstance = self.restoreData.globalOptions.destinationInstance;
				}
			}
			if (destination.inPlace === false) {
				destination.destPath = [];
				destination.destPath.push(self.selectedPath);
			}
			return destination;
		};

		var composeAgentSpecificOptions = function() {
			var agentSpecificOptions = {};

			agentSpecificOptions.physical = self.restoreData.globalOptions.physical;
			agentSpecificOptions.logical = self.restoreData.globalOptions.logical;
			agentSpecificOptions.numRestoreStreams = self.restoreData.globalOptions.numRestoreStreams;
			agentSpecificOptions.informixRestoreOptionType = self.restoreData.globalOptions.restoreType;

			if (self.restoreData.globalOptions.restoreType === RESTORE_MODES.TIME) {
				var cvDate = new Object();
				cvDate.timeValue = cvUtil.formatDate(
					self.restoreData.globalOptions.restorePitDate,
					'yyyy-MM-ddTHH:mm:ss',
					'UTC'
				);
				agentSpecificOptions.restoreTime = cvDate;
			} else if (self.restoreData.globalOptions.restoreType === RESTORE_MODES.UPTOLOGICAL) {
				agentSpecificOptions.logicalLogNumber = self.restoreData.globalOptions.logicalLogNumber;
			}
			agentSpecificOptions.informixRestoreType = 0;
			if (self.restoreData.globalOptions.restoreConfigFile) {
				agentSpecificOptions.restoreEmergencyBootFile = true;
				agentSpecificOptions.restoreOnConfigFile = true;
			}
			if (self.isFullDataRestore) {
				agentSpecificOptions.informixRestoreType = self.restoreData.globalOptions.restoreMode;
			}

			return agentSpecificOptions;
		};

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		var getSourceItems = function() {
			var sourceItems = [];
			angular.forEach(self.selectedRows, function(selectedItem) {
				if (selectedItem && selectedItem.id) {
					sourceItems.push(selectedItem.id);
				}
			});
			return sourceItems;
		};
	}
]);

export default app;
