import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('createSubclientCtrl', [
	'$scope',
	'$log',
	'$state',
	'cvLoc',
	'storageService',
	'idaService',
	'data',
	function($scope, $log, $state, cvLoc, storageService, idaService, data) {
		$scope.subclientInfo = {
			content: [],
			storagePoliciesList: [],
			storagePolicy: null,
			backupMode: 0,
			numberBackupStreams: 1,
			agentInfo: {
				applicationId: 0,
				agentType: {
					backupsetSupported: false,
					instanceSupported: false
				}
			}
		};

		/*'entity' : entity,
  'subclientDetails' : subclientDetails,
  'editing' : editing*/

		$scope.entity = angular.copy(data.entity);
		$scope.selectedItems = [];

		$scope.entity.subclientId = -1;
		var loadStoragePolicy = function() {
			storageService
				.getStoragePoliciesList()
				.success(function(storagePolicies) {
					$scope.subclientInfo.storagePoliciesList = storagePolicies;
				})
				.error(function(error) {
					$log.error(error);
				});
		};
		loadStoragePolicy();

		$scope.createSubclient = function() {
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			$log.log('Creating new subclient.');

			var storageDevice = new Object();
			storageDevice.dataBackupStoragePolicy = $scope.subclientInfo.storagePolicy;

			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;
			subPropInfo.content = [];
			subPropInfo.contentOperationType = 1;
			subPropInfo.sapHANASubclientProp = new Object();
			var subClientEntity = $scope.entity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			var content = [];

			idaService
				.createSubclient({
					subClientEntity: scEntity,
					subclientInfo: subInfo,
					content: JSON.stringify(content)
				})
				.success(function(data) {
					$state.forceReload();
					$scope.closeModal();
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		$scope.cancel = function() {
			$scope.$close();
		};
		$scope.closeModal = function(result) {
			$scope.$close();
		};
		//
	}
]);

app.controller('createInstanceCtrl', [
	'$scope',
	'storageService',
	'$state',
	'$uibModalInstance',
	'$log',
	'data',
	'idaService',
	'cvToaster',
	'$uibModal',
	'mbService',
	function($scope, storageService, $state, $modalInstance, $log, data, idaService, cvToaster, $modal, mbService) {
		if (!data.editDialog) {
			data.idaEntity.appName = 'Oracle';
		}

		$scope.isUnixClient = false;
		mbService.getOSType(data.idaEntity.clientId).then(function successCallBack(response) {
			$scope.isUnixClient = response.data.toLowerCase() == 'unix';
		});

		$scope.populateDefaultValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			var sqlConnect = new Object();
			var commandLineStoragePolicy = new Object();
			var logBackupStoragePolicy = new Object();
			var storageDevice = new Object();

			sqlConnect.userName = '';
			sqlConnect.domainName = '';

			instInfo.password = '';
			instInfo.sqlConnect = sqlConnect;
			instInfo.availableStoragePolicies = {};
			instInfo.osUserName = '';
			instInfo.osUserPassword = '';

			$scope.instanceEntity = data.idaEntity;
			$scope.instanceEntity.instanceName = '';
			$scope.instanceEntity.instanceId = -1;
			//Default storage policy values.

			commandLineStoragePolicy.storagePolicyId = null;
			commandLineStoragePolicy.storagePolicyName = null;

			logBackupStoragePolicy.storagePolicyId = null;
			logBackupStoragePolicy.storagePolicyName = null;

			storageDevice.commandLineStoragePolicy = commandLineStoragePolicy;
			storageDevice.logBackupStoragePolicy = logBackupStoragePolicy;
			$scope.storageDev = storageDevice;

			return instInfo;
		};

		$scope.populateInstanceValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			$scope.instanceEntity = angular.copy(serverInstanceInfo.instance);
			instInfo.availableStoragePolicies = {};

			/*var storageDevice = new Object();
   var oraStorage = serverInstanceInfo.oracleInstance.oracleStorageDevice;
   storageDevice.commandLineStoragePolicy = angular.copy(oraStorage.commandLineStoragePolicy);
   storageDevice.logBackupStoragePolicy = angular.copy(oraStorage.logBackupStoragePolicy);
   $scope.storageDev = storageDevice;*/

			return instInfo;
		};

		$scope.editDialog = data.editDialog;
		if (data.editDialog && data.editDialog == true) {
			$scope.instInfo = $scope.populateInstanceValues(data.instanceDetails);
		} else {
			$scope.instInfo = $scope.populateDefaultValues({});
		}

		//Populate storage policy list.
		storageService.getStoragePoliciesList().success(function(data) {
			$scope.instInfo.availableStoragePolicies = data;
		});

		$scope.closeDialogBox = function() {
			$modalInstance.close();
		};

		$scope.checkDuplicateName = function(inputName) {
			return false;
		};

		$scope.browse = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							foldersOnly: true,
							clientId: data.idaEntity.clientId
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					$scope.instInfo.oracleHome = result.path;
				},
				function() {
					$log.info('Cancel clicked: ');
				}
			);
		};

		// method to create the instance.
		$scope.createInstance = function() {
			var instanceEntity = $scope.instanceEntity;

			var instanceProperties = new Object();

			$scope.populateOracleProps(instanceProperties);

			var password = '';
			var osPassword = '';
			idaService
				.createInstance(
					{
						instanceEntity: angular.toJson(instanceEntity),
						instanceProps: angular.toJson(instanceProperties),
						password: password,
						osUserPassword: osPassword
					},
					data.editDialog
				)
				.success(function(data) {
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						cvToaster.showErrorMessage({
							ttl: '10000', //10 sec
							message: msgStr
						});
					}
					$state.forceReload();
					$scope.closeDialogBox();
				});
		};

		// Utility method to populate oracle specific values.
		$scope.populateOracleProps = function(instanceProperties) {
			var oracleInstance = new Object();
			oracleInstance.crossCheckTimeout = 600;
			oracleInstance.useCatalogConnect = false;
			oracleInstance.oracleHome = $scope.instInfo.oracleHome;
			oracleInstance.sqlConnect = $scope.instInfo.sqlConnect;
			if ($scope.instInfo.sqlConnect.userName === null || $scope.instInfo.password === null)
				oracleInstance.oracleWalletAuthentication = true;
			var oracleUser = new Object();
			oracleUser.userName = $scope.instInfo.osUserName;
			oracleInstance.oracleUser = oracleUser;
			oracleInstance.blockSize = 1048576;
			oracleInstance.oracleStorageDevice = $scope.storageDev;
			instanceProperties.oracleInstance = oracleInstance;
		};
	}
]);

app.controller('updateSubclientContentCtrl', [
	'$scope',
	'$log',
	'$state',
	'storageService',
	'idaService',
	'params',
	function($scope, $log, $state, storageService, idaService, data) {
		$scope.entity = data.subclientDetails.subClientEntity;
		$scope.subclientDetails = data.subclientDetails;
		var oraSubInfo = $scope.subclientDetails.oracleSubclientProp;

		$scope.subclientInfo = {
			content: []
		};

		idaService
			.getSubClientContent({ genericEntity: JSON.stringify($scope.entity) })
			.success(function(data) {
				$scope.subclientInfo.content = data;
			})
			.error(function(e) {
				$scope.serverMessage = {
					message: e,
					type: 'error'
				};
			});

		$scope.entity.subclientId = -1;
		$scope.entity.subClientName = '';
		var loadStoragePolicy = function() {
			storageService
				.getStoragePoliciesList()
				.success(function(storagePolicies) {
					$scope.subclientInfo.storagePoliciesList = storagePolicies;
				})
				.error(function(error) {
					$log.error(error);
				});
		};
		loadStoragePolicy();

		$scope.createSubclient = function() {
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			$log.log('Creating new subclient.');

			var storageDevice = new Object();
			storageDevice.dataBackupStoragePolicy = $scope.subclientInfo.storagePolicy;
			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;

			var subClientEntity = $scope.entity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			var content = [];

			idaService
				.createSubclient({
					subClientEntity: scEntity,
					subclientInfo: subInfo,
					content: JSON.stringify(content)
				})
				.success(function(data) {
					$state.forceReload();
					$scope.closeModal();
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		$scope.cancel = function() {
			$scope.$close();
		};
		$scope.closeModal = function(result) {
			$scope.$close();
		};
		//
	}
]);
app.controller('backupOptionsCtrl', [
	'$q',
	'$rootScope',
	'$scope',
	'$location',
	'idaService',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$log',
	'$uibModalStack',
	'data',
	function($q, $rootScope, $scope, $location, idaService, $modalInstance, $state, cvLoc, $log, $modalStack, data) {
		$scope.entityType = data.entityType;
		$scope.genericEntity = data.entity;

		$scope.backupType = 'INCREMENTAL';

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		$scope.closeModal = function(resp) {
			$modalInstance.dismiss();
		};

		$scope.failAndCloseModal = function(resp) {
			$modalInstance.dismiss();
		};

		var getBackupOption = function() {
			var backupOptions = {};
			var oracleOptions = {};
			oracleOptions.cumulative = $scope.cumulative;
			backupOptions.oracleOptions = oracleOptions;

			return backupOptions;
		};
		$scope.backup = function() {
			var deferred = $q.defer();
			var backupOptions = getBackupOption();
			idaService
				.backup(
					$scope.entityType,
					angular.toJson($scope.genericEntity),
					$scope.backupType,
					angular.toJson(backupOptions)
				)
				.success(function(wr) {
					var jobIds = wr.jobIds;
					var jobSummary = {
						jobId: jobIds[0],
						percentComplete: 0,
						status: 'Starting',
						sizeOfMediaOnDisk: 0,
						totalNumOfFiles: 0,
						jobElapsedTime: 0
					};
					var job = {
						jobSummary: jobSummary,
						showProgress: true,
						kill: true,
						suspend: true,
						resume: false
					};
					$scope.backupMsg = cvLoc('notification.backup.started');
					deferred.resolve(job);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						$scope.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						$scope.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		$scope.goToJob = function() {
			var top = $modalStack.getTop();
			if (top) {
				$modalStack.dismiss(top.key);
				event.preventDefault();
			}
			$location.path('jobs/' + $scope.backupJobId);
		};

		$scope.startBackup = function() {
			var result = {};
			result.backupType = $scope.backupType;
			$scope.loading = true;
			$scope.backup().then(
				function(resp) {
					$scope.loading = false;
					$scope.backupJobId = resp.jobSummary.jobId;
					$scope.closeModal(resp);
				},
				function(resp) {
					$scope.loading = false;
					$scope.backupMsg = resp.data;
					$scope.serverMessage = {
						type: 'error',
						message: resp.data
					};
					$scope.failAndCloseModal(resp);
				}
			);
		};
	}
]);

export default app;
