import 'modules/ida/js/services/idaService.svc.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/controllers/db2RedirectOptions.ctrl.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('db2RestoreOptionsCtrl', [
	'$scope',
	'$log',
	'cvUtil',
	'dbsUtil',
	'$uibModal',
	'$uibModalInstance',
	'$stateParams',
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'$filter',
	'idaService',
	'data',
	function(
		$scope,
		$log,
		cvUtil,
		dbsUtil,
		$modal,
		$modalInstance,
		$stateParams,
		cvToaster,
		cvLoc,
		AppTypes,
		$filter,
		idaService,
		data
	) {
		var self = this;

		self.restoreData = {
			globalOptions: {
				destinationServerList: [],
				restoretoDiskServerList: [],
				targetDb: '',
				database: true,
				recoverDB: true,
				recoverDatabase: false,
				rollFWTypeOption: true,
				rollFWTypeSelected: true,
				restoreType: '0',
				pitDate: new Date(),
				restoreLogs: false,
				restoreLogsFromDate: null,
				restoreLogsToDate: null,
				pitType: '3',
				rollFWType: '1',
				rollFWTypeSelection: '1',
				rollFWPitDate: new Date(),
				recoverType: 'true',
				useImpersonation: false,
				impersonateUserName: '',
				impersonatePassword: null,
				destPath: null
			},
			proxyClient: {},
			isInplaceRestore: () => self.tabControls.getCurrentTabId() === '0'
		};
		//selectedEntity
		self.commCellId = 2;
		self.tabControls = {};
		self.entity = data.entity;
		self.isMultiNode = data.entity.applicationId === AppTypes.DB2_MultiNode ? true : false;
		self.dpfPartitionClientList = [];
		self.dpfPartitionClientListMap = new Map();
		self.entityType = data.entityType;
		self.selectedRows = data.selectedRows;
		self.isFullDataRestore = data.isFullDataRestore;
		self.copyPrecedence = data.copyPrecedence;
		self.snapBackupEnabled = false;
		self.isAutoDB = true;
		self.tabStyle = 'tab-2';
		if (data.jobId && data.jobId > 0) {
			self.isRestoreToDiskSupported = true;
			self.jobId = data.jobId;
			self.tabStyle = 'tab-3';
		}
		self.toTime = data.toTime;
		if (self.toTime && self.toTime > 0) {
			self.restoreData.globalOptions.rollFWType = '0';
			var dateObject = cvUtil.convertUTCDateToLocalDate(new Date(parseInt(self.toTime) * 1000));
			self.restoreData.globalOptions.rollFWPitDate = dateObject;
			self.restoreData.globalOptions.restoreLogs = false;
		}

		if (self.entity && self.entity.backupsetName) {
			self.restoreData.globalOptions.targetDb = self.entity.backupsetName;
		}
		//self.imagesList = [{imageName : 'image22'},{imageName : 'image33'},{imageName : 'image44'}]
		self.selectedImages = [];
		self.validateClientSelection = function() {};
		//Holds all the labels for the isteven-multi-select component
		self.localLang = cvUtil.getIStevenLocLabels();
		self.localLang.nothingSelected = 'Select a images' /*cvLoc('option.clientName')*/;

		self.toggleImpersonation = function() {
			self.restoreData.globalOptions.useImpersonation = !self.restoreData.globalOptions.useImpersonation;
		};
		self.browseResultFunction = function(result) {
			if (result) {
				self.restoreData.globalOptions.destPath = result.path;
			}
		};
		self.isPITValide = function() {
			if (
				self.restoreData.globalOptions.pitType == '1' &&
				(!self.restoreData.globalOptions.pitDate || new Date(self.restoreData.globalOptions.pitDate) == 'Invalid Date')
			)
				return false;
			else return true;
		};
		self.isRestoreLogValide = function() {
			let retValue = true;
			if (self.restoreData.globalOptions.restoreLogs) {
				self.isRestoreLogFromTimeError = false;
				self.isRestoreLogToTimeError = false;
				if (
					!self.restoreData.globalOptions.restoreLogsFromDate ||
					new Date(self.restoreData.globalOptions.restoreLogsFromDate) == 'Invalid Date'
				) {
					self.isRestoreLogFromTimeError = true;
					retValue = false;
				}
				if (
					!self.restoreData.globalOptions.restoreLogsToDate ||
					new Date(self.restoreData.globalOptions.restoreLogsToDate) == 'Invalid Date'
				) {
					self.isRestoreLogToTimeError = true;
					retValue = false;
				}
			}
			return retValue;
		};

		self.isRollFWPITValide = function() {
			if (
				self.restoreData.globalOptions.rollFWType == '0' &&
				(!self.restoreData.globalOptions.rollFWPitDate ||
					new Date(self.restoreData.globalOptions.rollFWPitDate) == 'Invalid Date')
			)
				return false;
			else return true;
		};

		if (self.toTime && self.toTime > 0) {
			self.restoreData.globalOptions.pitType = '1';
			var dateObject = new Date(parseInt(self.toTime) * 1000);
			self.restoreData.globalOptions.pitDate = cvUtil.convertUTCDateToLocalDate(dateObject);
		}

		var loadBackupsetDetails = function() {
			idaService.getBackupSetDetails(self.entity.backupsetId).success(function(data) {
				if (data) {
					self.isAutoDB = _.get(data, 'db2BackupSet.dB2AutoStorage', false);
				}
			});
		};
		loadBackupsetDetails();

		var loadDestinationServerList = function() {
			idaService
				.getRestoreDestinations(
					self.entity.clientId,
					self.entity.applicationId,
					self.entity.instanceName,
					self.entity.instanceId
				)
				.then(
					function(data) {
						let serverList = [];
						for (let i = 0; i < data.data.length; i++) {
							serverList.push(data.data[i]);
						}
						self.restoreData.globalOptions.destinationServerList = serverList;
					},
					function(e) {
						$log.error(e);
					}
				);

			if (self.isRestoreToDiskSupported) {
				idaService.getRestoreDestinations(0, AppTypes.APPTYPE_FILESYSTEM).then(
					function(data) {
						let serverList = [];
						for (let i = 0; i < data.data.length; i++) {
							serverList.push(data.data[i]);
						}
						self.restoreData.globalOptions.restoretoDiskServerList = serverList;
					},
					function(e) {
						$log.error(e);
					}
				);
			}
		};
		loadDestinationServerList();

		/***
		 * When tab is in place restore, destinationserver and destiination instance should be set
		 * to source so that there is no regression issues.
		 */
		self.handleTabChange = function() {
			if (self.tabControls && self.tabControls.getCurrentTabId() === '1' && !self.restoreData.globalOptions.recoverDB) {
				self.restoreData.globalOptions.recoverDB = true;
				self.restoreDatabaseChange('restoreDB');
			}
		};
		/***
		 * Tried to use ng-selected on cv-tab, but it's being called infinite times..
		 * For now, use watch since there are no other APIs exposed by cv-tab directive
		 */
		self.afterTabInit = function() {
			$scope.$watch(self.tabControls.getCurrentTabId, self.handleTabChange);
		};
		var pitDate = new Date();

		self.destinationServerChanged = function(destClient) {
			// When destination is changed, server-specific options like path become invalid and must be cleared:
			//self.oraInstanceStatus = cvLoc('status.GETTINGSTATUS');
			var instanceEntity = new Object();
			instanceEntity.clientId = destClient.clientId;
			instanceEntity.applicationId = destClient.applicationId;
			instanceEntity.instanceId = 0;
			self.populateInstanceList(destClient.clientId, destClient.applicationId);
		};

		self.populateInstanceList = function(clientId, applicationId) {
			var sourceInstanceId = 0;
			idaService
				.getInstances(clientId, applicationId)
				.success(function(data) {
					if (data != null) {
						var instanceList = [];
						angular.forEach(data, function(instance) {
							instanceList.push(instance.instance);
							//For DB2MultiNode populate partition client list
							if (self.isMultiNode) {
								if (!self.dpfPartitionClientListMap.has(instance.instance.instanceId)) {
									let partitionClients = _.get(instance, 'db2Instance.dpfpartitionclients', []);
									let getClientEntity = function(partitionClient) {
										return {
											clientId: partitionClient.nodeClient.clientId,
											clientName: partitionClient.nodeClient.clientName,
											displayName: partitionClient.nodeClient.displayName
										};
									};
									let partionClientEntityList = _.uniqWith(_.map(partitionClients, getClientEntity), _.isEqual);
									self.dpfPartitionClientListMap.set(instance.instance.instanceId, partionClientEntityList);
								}
								//For in-place set the partition list
								if (clientId === self.entity.clientId && self.dpfPartitionClientListMap.has(self.entity.instanceId)) {
									self.dpfPartitionClientList = self.dpfPartitionClientListMap.get(self.entity.instanceId);
								}
							}
						});

						self.restoreData.globalOptions.destinationInstanceList = cvUtil.sortAscending(instanceList, 'instanceName');
					}
				})
				.error(function(e) {
					self.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		// For in-place redirect we need to populate the partition client list.
		if (self.isMultiNode) {
			self.populateInstanceList(self.entity.clientId, self.entity.applicationId);
		}

		self.destinationInstanceChanged = function(instanceId) {
			if (self.isMultiNode) {
				self.dpfPartitionClientList = self.dpfPartitionClientListMap.get(instanceId);
			}
		};

		self.restoreDatabaseChange = function(selectedOption) {
			if (selectedOption === 'restoreDB') {
				if (self.restoreData.globalOptions.recoverDB && self.restoreData.globalOptions.recoverDatabase) {
					self.restoreData.globalOptions.recoverDatabase = false;
				}
			} else if (selectedOption === 'recoverDB') {
				if (self.restoreData.globalOptions.recoverDB && self.restoreData.globalOptions.recoverDatabase) {
					self.restoreData.globalOptions.recoverDB = false;
				}
			}
		};

		self.cancelModel = function() {
			$modalInstance.close();
		};

		let userSelectionValide = function() {
			self.serverMessage = cvUtil.emptyMsg();
			if (
				!self.restoreData.globalOptions.recoverDB &&
				!self.restoreData.globalOptions.rollFWTypeOption &&
				!self.restoreData.globalOptions.restoreLogs
			) {
				self.serverMessage = cvUtil.errMsg(cvLoc('error.restoreSelection'));
				return false;
			}
			return true;
		};
		self.doRestore = function() {
			if (!userSelectionValide()) {
				return;
			}
			self.pitError = false;
			if (!self.isPITValide()) {
				self.pitError = true;
				return;
			}
			if (!self.isRollFWPITValide()) {
				self.rollFWPitError = true;
				return;
			}

			if (!self.isRestoreLogValide()) {
				return;
			}
			var genericEntity = angular.copy(self.entity);

			var browseOption = composeBrowseOption();
			var destination = composeDestination();
			var commonOptions = composeCommonOptions();
			var agentSpecificOptions = composeAgentSpecificOptions();
			var rdsOption = {};
			var sourceItems = getSourceItems();
			var dataMaskingOptions = composeDataMaskingOptions();
			let impersonation = composeImpersonation();

			idaService
				.submitRestoreJob({
					entityType: self.entityType,
					genericEntity: angular.toJson(genericEntity),
					browseOption: angular.toJson(browseOption),
					destination: angular.toJson(destination),
					commonOptions: angular.toJson(commonOptions),
					sourceItemsToRestore: angular.toJson(sourceItems),
					agentSpecificOptions: angular.toJson(agentSpecificOptions),
					dmOptions: angular.toJson(dataMaskingOptions),
					rdsOption: angular.toJson(rdsOption),
					impersonation: angular.toJson(impersonation)
				})
				.success(function(data) {
					dbsUtil.showRestoreToaster(data);
					self.cancelModel();
				})
				.error(function(err) {
					cvToaster.showErrorMessage({
						message: err
					});
				});
			return;
		};

		var composeDataMaskingOptions = function() {
			return self.restoreData.globalOptions.dataMaskingOptions;
		};

		var composeCommonOptions = function() {
			var commonOptions = {};
			if (self.tabControls && self.tabControls.getCurrentTabId() === '0' && self.snapBackupEnabled) {
				commonOptions.revert = self.restoreData.globalOptions.hardwareRevert;
			} else if (self.tabControls.getCurrentTabId() === '2') {
				commonOptions.restoreToDisk = true;
				commonOptions.indexFreeRestore = true;
			}
			return commonOptions;
		};

		var composeBrowseOption = function() {
			var browseOption = {
				commCellId: self.commCellId,
				timeRange: {
					fromTimeValue: $stateParams['fromTime'] ? $stateParams['fromTime'] : null,
					toTimeValue: $stateParams['toTime'] ? $stateParams['toTime'] : null
				}
			};
			if (self.copyPrecedence) {
				_.set(browseOption, 'mediaOption.copyPrecedence.copyPrecedence', self.copyPrecedence);
				_.set(browseOption, 'mediaOption.copyPrecedence.copyPrecedenceApplicable', true);
			}

			if (self.restoreData.proxyClient && self.restoreData.proxyClient.id) {
				let proxyForSnapClients = {
					clientId: self.restoreData.proxyClient.id,
					clientName: self.restoreData.proxyClient.name
				};
				_.set(browseOption, 'mediaOption.proxyForSnapClients', proxyForSnapClients);
			}

			return browseOption;
		};

		let composeImpersonation = function() {
			let impersonation = {};
			if (self.tabControls.getCurrentTabId() === '2' && self.restoreData.globalOptions.useImpersonation) {
				impersonation = {
					user: {
						userName: self.restoreData.globalOptions.impersonateUserName,
						password: cvUtil.getBytes(self.restoreData.globalOptions.impersonatePassword)
					},
					useImpersonation: true
				};
			}
			return impersonation;
		};

		var composeDestination = function() {
			var destination = {};

			destination.inPlace = self.restoreData.globalOptions.restoreToOriginalPath;
			if (self.tabControls.getCurrentTabId() === '0') {
				destination.destClient = {
					clientId: self.entity.clientId,
					clientName: self.entity.clientName
				};
				destination.destinationInstance = self.entity;
			} else if (self.tabControls.getCurrentTabId() === '2') {
				destination.destClient = {
					clientId: self.restoreData.globalOptions.destinationServer.clientId,
					clientName: self.restoreData.globalOptions.destinationServer.clientName
				};
				destination.destPath = [self.restoreData.globalOptions.destPath];
			} else {
				destination.destClient = {
					clientId: self.restoreData.globalOptions.destinationServer.clientId,
					clientName: self.restoreData.globalOptions.destinationServer.clientName
				};
				if (self.restoreData.globalOptions.destinationInstance) {
					destination.destinationInstance = self.restoreData.globalOptions.destinationInstance;
				}
			}
			if (destination.inPlace === false) {
				destination.destPath = [];
				destination.destPath.push(self.selectedPath);
			}
			return destination;
		};

		self.showRedirectOptionDialog = function(redirectOption) {
			self.redirectCheckBoxSelection = redirectOption;
			if (!redirectOption) {
				self.restoreData.globalOptions.redirectOption = redirectOption;
				return;
			}
			var clientEntity = self.entity;
			if (self.restoreData.globalOptions.destinationServer) {
				clientEntity = self.restoreData.globalOptions.destinationServer;
			}

			var redirectOption = null;
			var redirectAllPath = null;
			var dataFilesList = null;
			var storageGroup = null;
			if (self.redirectOptions) {
				if (self.redirectOptions.redirectAllItemsSelected !== undefined) {
					redirectOption = self.redirectOptions.redirectAllItemsSelected ? 'ALL' : 'INDIVIDUAL';
				}
				if (self.redirectOptions.renamePathForAllTablespaces) {
					redirectAllPath = self.redirectOptions.renamePathForAllTablespaces;
				}
				if (self.redirectOptions.dataFilesList) {
					dataFilesList = self.redirectOptions.dataFilesList;
				}
				if (self.redirectOptions.storageGroup) {
					storageGroup = self.redirectOptions.storageGroup;
				}
			}

			var dataResolve = function() {
				return {
					entity: data.entity,
					entityType: data.entityType,
					clientEntity: clientEntity,
					selectedRows: data.selectedRows,
					redirectOption: redirectOption,
					redirectAllPath: redirectAllPath,
					dataFilesList: dataFilesList,
					storageGroup: storageGroup,
					isMultiNode: self.isMultiNode,
					isAutoDB: self.isAutoDB,
					dpfPartitionClientList: self.dpfPartitionClientList
				};
			};
			var modelInsta = $modal.open({
				controller: 'db2RedirectOptionsCtrl',
				controllerAs: 'rrOptions',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/db2RedirectOptions.jsp',
				resolve: {
					data: dataResolve
				}
			});
			modelInsta.result.then(function(redirectOptions) {
				if (redirectOptions && self.redirectCheckBoxSelection) {
					self.restoreData.globalOptions.redirectOption = self.redirectCheckBoxSelection;
					self.redirectOptions = redirectOptions;
				} else {
					self.redirectOptions = null;
				}
			});
		};

		self.showStorageGroupsDialog = function() {
			var clientEntity = self.entity;
			if (self.restoreData.globalOptions.destinationServer) {
				clientEntity = self.restoreData.globalOptions.destinationServer;
			}

			var redirectOption = null;
			var redirectAllPath = null;
			var dataFilesList = null;
			var storageGroup = null;
			if (self.storageGroup) {
				storageGroup = self.storageGroup;
			}

			var dataResolve = function() {
				return {
					entity: data.entity,
					entityType: data.entityType,
					clientEntity: clientEntity,
					storageGroup: storageGroup
				};
			};
			var modelInsta = $modal.open({
				controller: 'db2StorageGroupsCtrl',
				controllerAs: 'rrOptions',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/db2StorageGroups.jsp',
				resolve: {
					data: dataResolve
				}
			});
			modelInsta.result.then(function(storageGroup) {
				if (storageGroup) {
					self.storageGroup = storageGroup;
				}
			});
		};

		var composeRedirectPaths = function(dataFilesList, agentSpecificOptions) {
			var redirectItems = [];
			var redirectItemsValue = [];
			var seperator12 = String.fromCharCode(9);
			//var seperator12 = String.fromCharCode(21);

			angular.forEach(dataFilesList, function(dataFileNode) {
				var dataFile = _.get(dataFileNode, 'dataFile');
				var oldDataFile = _.get(dataFileNode, 'oldDataFile');
				if (!dataFileNode.deleted && dataFile != oldDataFile) {
					// check the data file is modified
					var tableSpace = dataFileNode.tableSpace;
					var pageSize = 640;
					if (dataFileNode.totalPages) {
						pageSize = dataFileNode.totalPages;
					}
					var dataFileType = 6;
					if (dataFileNode.contType) {
						dataFileType = dataFileNode.contType;
					}
					var underDBDir = 1;
					var isAccessible = 1;
					var file =
						tableSpace +
						seperator12 +
						1 +
						seperator12 +
						dataFileNode.dataFile +
						seperator12 +
						dataFileType +
						seperator12 +
						pageSize +
						seperator12 +
						underDBDir +
						seperator12 +
						isAccessible;
					redirectItems.push(file);
				}
			});
			agentSpecificOptions.redirectInfo = redirectItems;
			agentSpecificOptions.redirectItemsValue = redirectItemsValue;
		};

		self.targetPathResuleFunction = function(result) {
			if (result) {
				self.restoreData.globalOptions.targetPath = result.path;
			}
		};
		var composeAgentSpecificOptions = function() {
			var agentSpecificOptions = {};

			if (self.tabControls.getCurrentTabId() === '2' && self.isAutoDB) {
				return agentSpecificOptions;
			}
			//agentSpecificOptions.rollForwardToEnd = self.restoreData.globalOptions.recoverType === 'true';
			agentSpecificOptions.rollForward = self.restoreData.globalOptions.rollFWTypeOption;
			if (!agentSpecificOptions.rollForward) {
				agentSpecificOptions.rollForwardPending = true;
			}
			if (self.restoreData.globalOptions.rollFWTypeOption) {
				if (self.restoreData.globalOptions.rollFWTypeSelection == '1') {
					agentSpecificOptions.rollForward = self.restoreData.globalOptions.rollFWTypeOption;
					agentSpecificOptions.rollForwardPending = false;
					if (self.restoreData.globalOptions.rollFWType == '0') {
						var cvDate = new Object();
						cvDate.timeValue = cvUtil.formatDate(
							self.restoreData.globalOptions.rollFWPitDate,
							'yyyy-MM-ddTHH:mm:ss',
							'UTC'
						);
						agentSpecificOptions.rollForwardTime = cvDate;
						agentSpecificOptions.rollForwardToEnd = 0;
					} else if (self.restoreData.globalOptions.rollFWType == '1') {
						agentSpecificOptions.rollForwardToEnd = 1;
					} else {
						agentSpecificOptions.rollForwardToEnd = 2;
					}
				} else {
					agentSpecificOptions.rollForwardPending = true;
				}
			}

			agentSpecificOptions.restoreArchiveLogs = false;
			if (self.restoreData.globalOptions.restoreLogs) {
				agentSpecificOptions.restoreArchiveLogs = true;
				agentSpecificOptions.logTimeStart = true;
				agentSpecificOptions.logTimeEnd = true;
				agentSpecificOptions.archiveLogTime = true;
				let fromTime = self.restoreData.globalOptions.restoreLogsFromDate.getTime() / 1000;
				let toTime = self.restoreData.globalOptions.restoreLogsToDate.getTime() / 1000;
				agentSpecificOptions.logTimeRange = {
					fromTime: Math.floor(fromTime),
					toTime: Math.floor(toTime)
				};
			}

			agentSpecificOptions.useLatestImage = true;
			agentSpecificOptions.redirect = false;

			agentSpecificOptions.restoreData = self.restoreData.globalOptions.recoverDB;
			agentSpecificOptions.recoverDb = self.restoreData.globalOptions.recoverDatabase;
			if (agentSpecificOptions.recoverDb) {
				agentSpecificOptions.restoreData = true;
			}
			agentSpecificOptions.useSnapRestore = false;
			agentSpecificOptions.restoreIncremental = false;
			agentSpecificOptions.restoreType = 1; //PARTIALDB
			agentSpecificOptions.restoreOnline = true;
			if (self.isFullDataRestore) {
				agentSpecificOptions.restoreOnline = false;
				agentSpecificOptions.restoreType = 0; //ENTIREDB
			}

			agentSpecificOptions.targetDb = self.restoreData.globalOptions.targetDb;
			agentSpecificOptions.targetPath = self.restoreData.globalOptions.targetPath;

			//For out of place restore we need to send the storagePath flag always
			if (self.tabControls.getCurrentTabId() === '2' && self.isAutoDB) {
				agentSpecificOptions.storagePath = true;
			}

			if (self.redirectOptions) {
				agentSpecificOptions.redirect = true;
				if (self.isAutoDB) {
					agentSpecificOptions.storagePath = true;
				}
				agentSpecificOptions.redirectAllTableSpacesSelected = false;
				agentSpecificOptions.redirectAllItemsSelected = self.redirectOptions.redirectAllItemsSelected;
				agentSpecificOptions.redirectItemsPresent = true;
				if (agentSpecificOptions.redirectAllItemsSelected) {
					agentSpecificOptions.redirectAllTableSpacesSelected = true;
					agentSpecificOptions.redirectAllTableSpacesValue = self.redirectOptions.renamePathForAllTablespaces;
					// For the redirectAllPaths we need to append the / for the unix paths \ for the windows path
					var separator = '/';
					var redirectAllPaths = angular.copy(self.redirectOptions.renamePathForAllTablespaces);
					if (redirectAllPaths.indexOf(separator) === -1) {
						separator = '\\';
					}
					if (!redirectAllPaths.endsWith(separator)) {
						redirectAllPaths = redirectAllPaths + separator;
					}
					agentSpecificOptions.redirectAllPaths = redirectAllPaths;
				} else {
					agentSpecificOptions.redirectAllTableSpacesSelected = false;
					composeRedirectPaths(self.redirectOptions.dataFilesList, agentSpecificOptions);
				}
				if (self.redirectOptions.storageGroup) {
					agentSpecificOptions.redirectStorageGroups = self.redirectOptions.isAutoDB;
					agentSpecificOptions.storageGroupInfo = {
						storageGroup: self.redirectOptions.storageGroup
					};
				}
			}

			return agentSpecificOptions;
		};

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		var getSourceItems = function() {
			var sourceItems = [];
			if (self.tabControls.getCurrentTabId() === '2') {
				sourceItems.push(self.commCellId + ':' + self.jobId);
				return sourceItems;
			}
			if (self.redirectOptions) {
				var seperator12 = String.fromCharCode(21);
				angular.forEach(self.redirectOptions.dataFilesList, function(dataFileNode) {
					if (
						dataFileNode &&
						dataFileNode.dataFile &&
						dataFileNode.oldDataFile &&
						dataFileNode.dataFile != dataFileNode.oldDataFile
					) {
						// check the data file is modified
						var tableSpace = dataFileNode.tableSpace;
						var pageSize = 640;
						if (dataFileNode.totalPages) {
							pageSize = dataFileNode.totalPages;
						}
						var dataFileType = 6;
						if (dataFileNode.contType) {
							dataFileType = dataFileNode.contType;
						}
						var underDBDir = 1;
						var isAccessible = 1;
						var file =
							tableSpace +
							seperator12 +
							dataFileNode.dataFile +
							seperator12 +
							dataFileType +
							seperator12 +
							pageSize +
							seperator12 +
							underDBDir +
							seperator12 +
							isAccessible;
						sourceItems.push(file);
					}
				});
			} else {
				angular.forEach(self.selectedRows, function(selectedItem) {
					if (selectedItem && selectedItem.id) {
						sourceItems.push(selectedItem.id);
					}
				});
			}
			return sourceItems;
		};
	}
]);

export default app;
