import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('db2RedirectOptionsCtrl', [
	'$scope',
	'$log',
	'cvTableOptions',
	'cvLoc',
	'$uibModal',
	'$uibModalInstance',
	'idaService',
	'profileService',
	'$timeout',
	'data',
	function($scope, $log, cvTableOptions, cvLoc, $modal, $modalInstance, idaService, profileService, $timeout, data) {
		var self = this;
		self.tabControls = {};
		self.dataFilesList = [];
		var dataFilesModel = {};
		self.showStorgeGroups = true;

		self.entity = data.entity;
		self.isAutoDB = _.get(data, 'isAutoDB', false);
		self.clientEntity = data.clientEntity;
		self.data = {
			redirectOption: 'ALL',
			redirectAllPath: '',
			isPDBInstance: false,
			redirectTablespace: false
		};
		if (data.redirectOption) {
			self.data.redirectOption = data.redirectOption;
		}
		if (data.redirectAllPath) {
			self.data.redirectAllPath = data.redirectAllPath;
		}

		self.isMultiNode = data.isMultiNode;
		self.dpfPartitionClientList = data.dpfPartitionClientList;

		$timeout(function() {
			self.tabControls.selectTab(0);
		});

		self.redirectTablespaceSelected = function() {
			self.data.redirectTablespace = !self.data.redirectTablespace;
		};

		var createTableSpace = function(dataFilesModel, dataFileNode) {
			var tableSpaceNode = dataFilesModel[dataFileNode.tableSpace];
			if (!tableSpaceNode) {
				tableSpaceNode = {
					tableSpace: dataFileNode.tableSpace,
					datafiles: []
				};
				dataFilesModel[dataFileNode.tableSpace] = tableSpaceNode;
			}
			tableSpaceNode.datafiles.push(dataFileNode);
			return tableSpaceNode;
		};

		var isDatafileSelected = function(dataFileNode) {
			let tableSpaceStorageType = _.get(dataFileNode, 'tableSpaceStorageType', 1);
			if (tableSpaceStorageType == 1) {
				return true;
			}
			return false;
		};

		var populateData = function(data) {
			var firstNode = null;
			self.dataFilesList = [];
			var dataFilesModel = {};
			data.forEach(function(dataFileNode) {
				if (isDatafileSelected(dataFileNode)) {
					if (!firstNode) {
						firstNode = dataFileNode;
					}
					self.dataFilesList.push(dataFileNode);
					createTableSpace(dataFilesModel, dataFileNode);
					if (!dataFileNode.oldDataFile) {
						dataFileNode.oldDataFile = angular.copy(dataFileNode.dataFile);
					}
				}
			});
			self.dataFilesModel = dataFilesModel;
			//Setting one state for the accordion
			if (firstNode && firstNode.database) {
				self.dataFilesModel[firstNode.database].status = true;
				self.dataFilesModel[firstNode.database].tableSpace[firstNode.tableSpace].status = true;
			} else if (firstNode && firstNode.tableSpace) {
				self.dataFilesModel[firstNode.tableSpace].status = true;
			}
		};

		var loadData = function() {
			idaService.getDB2DatafilesList(self.entity.backupsetId, 'BACKUPSET_ENTITY').success(function(data) {
				if (data && data.length > 0) {
					populateData(data);
				}
			});
		};

		if (!data.dataFilesList) {
			loadData();
		} else {
			populateData(data.dataFilesList);
		}

		let updateStorageGroups = function(storageGroup) {
			storageGroup.forEach(function(sGroup) {
				let pathList = [];
				sGroup.stoPaths.forEach(function(sPath) {
					pathList.push({
						dataFile: sPath
					});
				});
				sGroup.stoPaths = pathList;
			});
			storageGroup[0].status = true;
			self.storageGroup = storageGroup;
		};

		var loadStorageGroups = function() {
			idaService.getDb2StorageGroups(self.entity.backupsetId).success(function(data) {
				if (data && data.groupInfo && data.groupInfo.storageGroup && data.groupInfo.storageGroup.length > 0) {
					updateStorageGroups(data.groupInfo.storageGroup);
					/*
					 * self.storageGroup = data.groupInfo.storageGroup; self.storageGroup[0].status = true;
					 */
				}
			});
		};

		if (!data.storageGroup) {
			loadStorageGroups();
		} else {
			self.storageGroup = data.storageGroup;
			updateStorageGroups(self.storageGroup);
		}

		self.redirectAllPathResuleFunction = function(result) {
			if (result) {
				self.data.redirectAllPath = result.path;
			}
		};
		self.closeDialogBox = function(result) {
			//self.$close();
			$modalInstance.close();
		};

		self.showFindAndReplaceDialog = function(replaceFunction) {
			var findAndReplaceCtrl = [
				'cvLoc',
				'$uibModalInstance',
				'$dialogs',
				function(cvLoc, $modalInstance, $dialogs) {
					var self = this;
					self.data = {
						findStr: '',
						replaceStr: ''
					};

					self.closeDialogBox = function(result) {
						$modalInstance.close();
					};

					self.save = function() {
						var callBackFunctions = {
							noFunction: function() {},
							yesFunction: function() {
								$modalInstance.close(self.data);
							}
						};
						$dialogs.confirm(
							cvLoc('label.findAndReplace'),
							cvLoc('label.frConfirmation', '<b>' + self.data.findStr + '</b>', '<b>' + self.data.replaceStr + '</b>'),
							callBackFunctions
						);
					};
				}
			];
			var modelInsta = $modal.open({
				controller: findAndReplaceCtrl,
				controllerAs: 'fReplace',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/oracleRedirectFindAndReplace.jsp'
			});
			modelInsta.result.then(replaceFunction);
		};

		self.storageGroupsReplace = function() {
			let replaceStorageGroups = function(replaceOptions) {
				if (replaceOptions && replaceOptions.findStr && replaceOptions.replaceStr) {
					self.showStorgeGroups = false;
					let oldPathRe = new RegExp(replaceOptions.findStr, 'g');
					self.storageGroup.forEach(function(sGroup) {
						let paths = [];
						sGroup.stoPaths.forEach(function(dataFileNode) {
							dataFileNode.dataFile = dataFileNode.dataFile.replace(oldPathRe, replaceOptions.replaceStr);
							paths.push(dataFileNode);
						});
						sGroup.stoPaths = paths;
					});
					$timeout(function() {
						self.showStorgeGroups = true;
					});
				}
			};
			self.showFindAndReplaceDialog(replaceStorageGroups);
		};

		self.pathsReplace = function() {
			let replaceStorageGroups = function(replaceOptions) {
				if (replaceOptions && replaceOptions.findStr && replaceOptions.replaceStr) {
					self.dataFilesList.forEach(function(dataFileNode) {
						dataFileNode.dataFile = dataFileNode.dataFile.replace(replaceOptions.findStr, replaceOptions.replaceStr);
					});
				}
			};
			self.showFindAndReplaceDialog(replaceStorageGroups);
		};

		var isValidData = function() {
			var isValid = true;
			if (self.dataFilesList) {
				self.dataFilesList.forEach(function(dataFileNode) {
					if (_.isEmpty(dataFileNode.dataFile)) {
						isValid = false;
						dataFileNode.error = true;
						var firstNode = dataFileNode;
						if (firstNode.database) {
							self.dataFilesModel[firstNode.database].status = true;
							self.dataFilesModel[firstNode.database].tableSpace[firstNode.tableSpace].status = true;
						} else if (firstNode.tableSpace) {
							self.dataFilesModel[firstNode.tableSpace].status = true;
						}
					} else {
						dataFileNode.error = false;
					}
				});
			}

			if (self.storageGroup) {
				self.storageGroup.forEach(function(sGroup) {
					sGroup.stoPaths.forEach(function(sPath) {
						if (_.isEmpty(sPath.dataFile)) {
							isValid = false;
							sPath.error = true;
							sGroup.status = true;
							if (!isValid) {
								self.tabControls.selectTab(1);
							}
						} else {
							sPath.error = false;
						}
					});
				});
			}

			return isValid;
		};

		let updateStoregeGroups = function(storageGroup) {
			if (!storageGroup) {
				return null;
			}
			storageGroup.forEach(function(sGroup) {
				let stoPathsList = [];
				sGroup.stoPaths.forEach(function(sPath) {
					if (!sPath.deleted) {
						stoPathsList.push(sPath.dataFile);
					}
				});
				sGroup.stoPaths = stoPathsList;
			});
			return storageGroup;
		};

		self.saveRedirectOptions = function() {
			if (!isValidData()) {
				return;
			}
			let redirectAllItemsSelected = false;
			let dataFilesList = [];
			if (self.data.redirectTablespace) {
				redirectAllItemsSelected = self.data.redirectOption === 'ALL' ? true : false;
				dataFilesList = self.dataFilesList;
			}
			var redirectOptions = {
				redirectAllItemsSelected: redirectAllItemsSelected,
				renamePathForAllTablespaces: self.data.redirectAllPath,
				dataFilesList: dataFilesList,
				storageGroup: updateStoregeGroups(self.storageGroup),
				isAutoDB: self.isAutoDB
			};
			$modalInstance.close(redirectOptions);
		};
		//
	}
]);

export default app;
