import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('db2CreateBackupsetCtrl', [
	'$state',
	'cvLoc',
	'$uibModalInstance',
	'$log',
	'data',
	'cvToaster',
	'idaService',
	'cvUtil',
	'mbService',
	'AppTypes',
	'profileService',
	function(
		$state,
		cvLoc,
		$modalInstance,
		$log,
		data,
		cvToaster,
		idaService,
		cvUtil,
		mbService,
		AppTypes,
		profileService
	) {
		var self = this;
		self.backupsetEntity = data.backupsetEntity;
		self.backupsetEntity.databaseName = _.get(data, 'backupsetEntity.backupsetName', null);
		self.editDialog = data.editDialog;
		self.instancePlan = _.get(data, 'backupsetDetails.planEntity', null);
		self.useSQLConnect = false;
		if (self.editDialog) {
			self.db2SqlConnectInfo = _.get(data, 'backupsetDetails.db2BackupSet.db2SqlConnectInfo', null);
			self.useSQLConnect = _.get(data, 'backupsetDetails.db2BackupSet.useSQLConnect', false);
		} else {
			self.db2SqlConnectInfo = {
				userName: null,
				dbPassword: null
			};
			self.showPlanError = true;
		}
		self.databaseNameError = false;

		self.db2DBNameChrects = cvLoc('error.db2DBNameChrects');
		self.selectedProfileList = [];
		self.parseIStevenOutput = function() {
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.showPlanError = false;
			} else {
				self.showPlanError = true;
			}
		};

		self.useSQLConnectSelected = function() {
			self.useSQLConnect = !self.useSQLConnect;
		};

		self.loadPlans = function() {
			self.profileList = [];
			profileService
				.getEligiblePlansForApp(AppTypes.DB2)
				.success(function(data) {
					self.addServerMessage = cvUtil.emptyMsg();
					if (data.length > 0) {
						var planList = [];
						self.planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							const planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes
							};
							planList.push(planObj);
							if (self.planListByTypes[planObj.type]) {
								self.planListByTypes[planObj.type].push(planObj);
							} else {
								self.planListByTypes[planObj.type] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in self.planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending(self.planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList.push(...tempPlanList);
						if (self.instancePlan && self.instancePlan.planId) {
							let selectedPlans = self.profileList.filter(function(planNode) {
								return planNode.id == self.instancePlan.planId;
							});
							if (selectedPlans) {
								selectedPlans.forEach(function(planNode) {
									planNode.selected = true;
									self.selectedProfileList.push(planNode);
								});
								self.showPlanError = false;
							}
						}
					} else {
						self.showPlan = false;
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		};

		self.loadPlans();

		self.closeDialogBox = function(entity) {
			$modalInstance.close(entity);
		};

		let isValidDatabaseName = function(databaseName) {
			let databaseNameRex = /[|`~!@#$%^&*()+=<>/?,\[\]{}:\\;'\s+]/;
			return !databaseNameRex.test(databaseName);
		};

		// method to create the instance.
		self.createDatabase = function() {
			self.databaseNameError = false;
			if (!isValidDatabaseName(self.backupsetEntity.databaseName)) {
				self.databaseNameError = true;
				return;
			}
			var backupsetEntity = self.backupsetEntity;
			//In case of add instance dialog check for the client selection validation

			var backupsetProperties = new Object();

			if (self.editDialog === false && (!self.selectedProfileList || self.selectedProfileList.length <= 0)) {
				return;
			}

			var backupsetMessageInf = {
				backupSetEntity: backupsetEntity
			};

			let plan = null;
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				plan = self.selectedProfileList[0].id;
			}
			if (self.editDialog) {
				self.db2SqlConnectInfo.password = cvUtil.getBytes(self.db2SqlConnectInfo.dbPassword);
				_.set(backupsetMessageInf, 'db2BackupSet.db2SqlConnectInfo', self.db2SqlConnectInfo);
				if (plan) {
					_.set(backupsetMessageInf, 'planEntity.planId', plan);
				}
				_.set(backupsetMessageInf, 'db2BackupSet.useSQLConnect', self.useSQLConnect);
			} else {
				self.populateDB2Props(backupsetMessageInf);
			}

			let backupsetInfo = {
				clientId: backupsetEntity.clientId,
				appId: backupsetEntity.applicationId,
				backupsetName: self.backupsetEntity.databaseName,
				planId: plan,
				backupSetEntity: angular.toJson(backupsetEntity),
				isDefaultBackupSet: false,
				backupsetInfo: angular.toJson(backupsetMessageInf)
			};
			idaService
				.createBackupSet(backupsetInfo, self.editDialog)
				.success(function(data) {
					var msg = cvLoc('msg.createDatabase');
					if (self.editDialog) {
						msg = cvLoc('msg.updateDatabase');
					}
					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: msg
					});

					self.closeDialogBox(data);
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		// Utility method to populate db2 specific values.
		self.populateDB2Props = function(backupsetProperties) {
			var db2BackupSet = {
				dB2DefaultIndexSP: {
					storagePolicyId: 1
				},
				dB2DefaultCommandSP: {
					storagePolicyId: 1
				}
			};
			backupsetProperties.db2BackupSet = db2BackupSet;
		};
	}
]);

export default app;
