import 'capps/js/services/cappsClients.svc.js';
import 'capps/js/controllers/cappsClients.ctrl.js';
import 'capps/js/services/cappsSubClients.svc.js';
import 'capps/js/services/cappsClientDetails.svc.js';
import 'modules/setup/js/factory/coreSetup.factory.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/ida/js/services/idas.factory.js';
import 'capps/js/cappsUtil.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'capps/js/factories/salesforce.factory.js';

import { commonAllAgentsModule } from 'common/js/modules';

var allAgentMod = commonAllAgentsModule;

var controllers = {};

controllers.commonIdaBrowseController = [
	'cvLoc',
	'$uibModal',
	'$log',
	'cappsClientService',
	'cvUtil',
	'$location',
	'$state',
	'CAPPS_CONSTANTS',
	'cappsUIFactory',
	'cappsSubClientService',
	'cvToaster',
	'AppTypes',
	'clientDetailService',
	'$scope',
	'coreSetup',
	'ENTITY_TYPES',
	'idaService',
	'cvTableOptions',
	'$filter',
	'idasFactory',
	'cvBreadcrumbsTabsFactory',
	'uiGridConstants',
	'BROWSE_NODE_TYPE',
	'$stateParams',
	'cappsUtil',
	'downloadsFactory',
	'salesforceFactory',
	function(
		cvLoc,
		$modal,
		$log,
		cappsClientService,
		cvUtil,
		$location,
		$state,
		CAPPS_CONSTANTS,
		cappsUIFactory,
		cappsSubClientService,
		cvToaster,
		AppTypes,
		clientDetailService,
		$scope,
		coreSetup,
		ENTITY_TYPES,
		idaService,
		cvTableOptions,
		$filter,
		idasFactory,
		cvBreadcrumbsTabsFactory,
		uiGridConstants,
		BROWSE_NODE_TYPE,
		$stateParams,
		cappsUtil,
		downloadsFactory,
		salesforceFactory
	) {
		var self = this;
		const downloadSizeLimitMB =
			cvApp && cvApp.globalParams && cvApp.globalParams.WebconsoleDownloadSizeLimitMB
				? cvApp.globalParams.WebconsoleDownloadSizeLimitMB
				: 1024;
		const recallDownloadSizeLimitMB =
			cvApp && cvApp.globalParams && cvApp.globalParams.WebconsoleRecallDownloadSizeLimitMB
				? cvApp.globalParams.WebconsoleRecallDownloadSizeLimitMB
				: 100;

		self.breadcrumbModel = [];
		self.refreshAdvancedSearch = false;
		self.searchPerformed = false;
		this.$onInit = function() {
			//validate model on first load
			self.validateModel = function() {
				if (angular.isUndefined(self.browseModel)) {
					$log.error('Browse model is not provided');
					self.pageMessage = cvUtil.errMsgLoc('generic_error');
					self.hideLoading = true;
					return false;
				}

				if (angular.isUndefined(self.browseModel.applicationId)) {
					$log.error('Application Id is not provided');
					self.pageMessage = cvUtil.errMsgLoc('generic_error');
					self.hideLoading = true;
					return false;
				}

				if (
					self.browseModel.applicationId == AppTypes.CLOUD_APPS &&
					angular.isUndefined(self.browseModel.cloudAppType)
				) {
					$log.error('CloudApp type is not provided');
					self.pageMessage = cvUtil.errMsgLoc('generic_error');
					self.hideLoading = true;
					return false;
				}

				return true;
			};
			//Set deafult sort, page size, etc options at agent level if it has to be different
			self.populateAgentSpecificBrowseOptions = function(applicationId) {
				if (self.browseModel && self.browseModel.applicationId) {
					var applicationId = self.browseModel.applicationId;

					switch (parseInt(applicationId)) {
						case AppTypes.CLOUD_APPS:
							switch (parseInt(self.browseModel.cloudAppType)) {
								case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value:
								case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value:
									self.browseModel.defaultTreeSize = 15;
									self.browseModel.defaultSortParams = {
										FOLDER: {
											sortOrder: CAPPS_CONSTANTS.SORT_ASC,
											sortParam: 'Flags,FileName'
										}
									};
									break;
								case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value:
									self.browseModel.rootNodeType = CAPPS_CONSTANTS.MAILBOX_NODE.ROOT;
									self.browseModel.defaultSortParams = {
										ROOT: {
											sortOrder: CAPPS_CONSTANTS.SORT_ASC,
											sortParam: 'Flags,FileName'
										},
										MAILBOX: {
											sortOrder: CAPPS_CONSTANTS.SORT_ASC,
											sortParam: 'Flags,FileName'
										},
										MAILBOX_FOLDER: {
											sortOrder: CAPPS_CONSTANTS.SORT_DESC,
											sortParam: 'ModifiedTime',
											localeKey: cvLoc('label.browse.sort.by.date')
										}
									};

									//In case of Gmail and Mailbox, in the mails view, there maybe external sort i.e. sort apart from grid headers in form of drop down.
									//Below values are used to create the external sort dropdown
									self.browseModel.externalSortOptions = [
										{
											localeKey: cvLoc('label.browse.sort.by.date'),
											defaultSortOrder: CAPPS_CONSTANTS.SORT_DESC,
											sortParam: 'ModifiedTime'
										},
										{
											localeKey: cvLoc('label.browse.sort.by.size'),
											defaultSortOrder: CAPPS_CONSTANTS.SORT_ASC,
											sortParam: 'FileSize'
										}
									];
									break;
								case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value:
									self.browseModel.rootNodeType = CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT;
									self.browseModel.paginationPageSizes = [15, 30, 45, 1000];
									self.browseModel.skipCvUtcConversion = true;
									self.browseModel.toTime = self.formatDateForBackend(self.browseModel.toTime);
									self.browseModel.fromTime = self.formatDateForBackend(self.browseModel.fromTime);
									if (self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA) {
										self.browseModel.showIncludeMetadata = false;
										self.browseModel.includeMetadataValue = true;
										self.browseModel.includeMetadataLabels = {
											trueLabel: cvLoc('label.showAllMetadata'),
											trueSelectedLabel: cvLoc('label.showingAllMetadata'),
											falseLabel: cvLoc('label.showRestorableMetadataOnly'),
											falseSelectedLabel: cvLoc('label.showingRestorableMetadataOnly')
										};
										self.browseModel.showShowDeletedFiles = false;
										self.browseModel.showDeletedFilesLabels = {
											trueLabel: cvLoc('label.showDeletedMetadata'),
											trueSelectedLabel: cvLoc('label.showingDeletedMetadata'),
											falseLabel: cvLoc('label.hideDeletedMetadata'),
											falseSelectedLabel: cvLoc('label.hidingDeletedMetadata')
										};
									} else if (self.browseModel.browseType != CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE) {
										if (self.browseModel.isCompare) {
											self.browseModel.rootNodeType = CAPPS_CONSTANTS.SALESFORCE_NODE.OBJECT_VIEW;
										}
										self.browseModel.showShowDeletedFiles = false;
										self.browseModel.showDeletedFilesLabels = {
											trueLabel: cvLoc('label.showDeletedObjectsFiles'),
											trueSelectedLabel: cvLoc('label.showingDeletedObjectsFiles'),
											falseLabel: cvLoc('label.hideDeletedObjectsFiles'),
											falseSelectedLabel: cvLoc('label.hidingDeletedObjectsFiles')
										};
									} else {
										self.browseModel.showQueryOptions = true;
										self.browseModel.queryOptionsValue = 'LATEST';
										self.browseModel.queryOptionsLabels = {
											//Labels for user selection
											LatestLabel: cvLoc('label.showLatestVersion'),
											AllLabel: cvLoc('label.showAllVersions'),
											DeletedLabel: cvLoc('label.showDeletedRecords'),

											//Labels to indicate current value
											LATEST: cvLoc('label.showingLatestVersion'),
											ALL: cvLoc('label.showingAllVersions'),
											DELETED: cvLoc('label.showingDeletedRecords')
										};
										self.browseModel.showWhereCondition = true;
										self.browseModel.whereConditionLabels = {
											//Labels for user selection
											trueLabel: cvLoc('label.setAdvancedFilter'),
											falseLabel: cvLoc('label.clearAdvancedFilter'),

											//Labels to indicte current value
											TRUE: cvLoc('label.advancedFilterSet'),
											FALSE: cvLoc('label.advancedFilterCleared')
										};

										if (self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE) {
											self.browseModel.passUtcTime = true;
										}
									}
									break;
								case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value:
									self.browseModel.defaultTablePageSize = 20;
									self.browseModel.paginationPageSizes = [20, 50, 100, 1000];
									break;
								default:
									$log.error('Browse is not supported for this Cloudapp Type');
									cvUtil.errMsgLoc('generic_error');
							}

							break;
						default:
							$log.error('Browse is not supported for this appType');
							cvUtil.errMsgLoc('generic_error');
					}
				}
			};

			self.initializeAndSetDefaults = function() {
				//initialize
				//for loader
				self.hideLoading = false;
				//If page size is modified pageSizeModified is set to true.
				//If sorting is used sortingInfoModified is set to true
				//if any of these are true, pageData caching is not used. Data is retrieved from server.
				//Pending improvement : try browser level cache and check if that approach is better for caching
				self.pageSizeModified = false;
				self.sortingInfoModified = false;

				//Initialize tree state to show loading message when no api calls are yet complete
				self.tree = {
					id: '',
					label: cvUtil.infoMsgLoc('Loading').message,
					state: 'collapsed',
					entityType: self.rootNodeType
				};
				if (self.browseModel) {
					//Set defaults
					self.browseModel.timerangeBrowseOptions = {
						fromTime: self.browseModel.fromTime ? self.browseModel.fromTime : null,
						toTime: self.browseModel.toTime ? self.browseModel.toTime : null
					};
					self.entityType = self.browseModel.entityType ? self.browseModel.entityType : ENTITY_TYPES.SUBCLIENT_ENTITY;

					self.bTreeOnly = self.browseModel.bTreeOnly && self.browseModel.bTreeOnly === 'true' ? true : false;

					self.defaultTreeSize = self.browseModel.defaultTreeSize ? self.browseModel.defaultTreeSize : 20;

					self.defaultTreeSortingInfo = self.browseModel.defaultTreeSortingInfo
						? self.browseModel.defaultTreeSortingInfo
						: 'asc:Flags,FileName';

					self.defaultTablePageSize = self.browseModel.defaultTablePageSize
						? self.browseModel.defaultTablePageSize
						: 15;

					self.paginationPageSizes = self.browseModel.paginationPageSizes
						? self.browseModel.paginationPageSizes
						: [15, 30, 45];

					//idas that do not have browse tree items of many different types will have the default entity type of "Folder"
					self.rootNodeType = self.browseModel.rootNodeType ? self.browseModel.rootNodeType : BROWSE_NODE_TYPE.FOLDER;

					self.currentSortParameters = self.browseModel.defaultSortParams
						? self.browseModel.defaultSortParams
						: {
								FOLDER: {
									sortOrder: CAPPS_CONSTANTS.SORT_ASC,
									sortParam: 'Flags,FileName'
								}
						  };
				}
			};

			self.load = function() {
				if (self.browseModel) {
					//Get subclient info so that subclient name can be displayed on the screen
					idaService
						.getNodeEntity(self.entityType, parseInt(self.browseModel.entityId))
						.success(function(data) {
							self.entity = data;
							self.entityName = self.entity.subclientName;

							//Getting OSType propery for the client. Based on OS file separator is determined while forming file path
							idaService
								.getClientProps(self.entity.clientId)
								.success(function(data) {
									self.clientProps = data;
									//Salesforce client is pseduo client and it always uses Unix as proxy.
									if (
										self.browseModel.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value ||
										Number.parseInt(self.browseModel.cloudAppType) ===
											CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value
									) {
										self.clientProps['osType'] = 'Unix';
									}
									self.osType = self.clientProps['osType'];
									if (
										Number.parseInt(self.browseModel.cloudAppType) ===
										CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value
									) {
										let rootLabel = '';
										const entityType = _.get(self, 'browseModel.entityType', 'SUBCLIENT_ENTITY');
										if (entityType === 'BACKUPSET_ENTITY') {
											rootLabel = _.get(self, 'entity.clientName', cvLoc('label.clientType.onedrive'));
										} else {
											if (_.isUndefined(self.browseModel.path)) {
												rootLabel = _.get(self, 'entity.subclientName', cvLoc('label.clientType.onedrive'));
											} else {
												//User browse
												rootLabel = _.get(self, 'browseModel.path', cvLoc('label.clientType.onedrive'));
											}
										}
										self.initRootNode(self.osType, rootLabel);
									} else if (
										Number.parseInt(self.browseModel.cloudAppType) ===
										CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value
									) {
										self.initRootNode(self.osType, cvLoc('label.bcGoogleDrive'));
									} else if (
										Number.parseInt(self.browseModel.cloudAppType) ===
										CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value
									) {
										self.initRootNode(self.osType, cvLoc('label.bcGoogleMail'));
									} else {
										self.initRootNode(self.osType, self.entityName);
									}
									self.setupNavBreadcrumbs();
									self.clearItemSelection();
									self.loadTree(self.selectedItem);
									self.setColumnDefs();

									self.loadTable(self.selectedItem);
									self.setAdvancedSearchBoxOptions();
								})
								.error(function() {
									$log.error('Failed to get Client details for client ID' + self.entity.clientId);
									self.hideLoading = true;
									self.pageMessage = cvUtil.errMsgLoc('generic_error');
								});
						})
						.error(function() {
							$log.error('Failed to get SubClient details for subclient ID ' + self.browseModel.entityId);
							self.hideLoading = true;
							self.pageMessage = cvUtil.errMsgLoc('generic_error');
						});
					self.updateTimeRangeLabel();
				}
			};

			self.initRootNode = function(osType, subclientName) {
				var rootPath = self.getFileSeparater(osType);

				if (
					(self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) &&
					self.browseModel.salesforceTable
				) {
					rootPath = self.browseModel.salesforceTable.path;
				} else if (self.isSalesforceObjCompare()) {
					rootPath = '/Objects';
				} else if (
					Number.parseInt(self.browseModel.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value
				) {
					let userPath = _.get(self, 'browseModel.path', '\\');
					if (userPath !== '\\') {
						userPath = `${CAPPS_CONSTANTS.BROWSE_PATH_PREFIX_ONEDRIVE}\\${userPath}`;
					}
					rootPath = userPath;
				}
				//Prepare tree (first item to be browsed) for first browse request.
				self.tree = {
					id: rootPath,
					label: subclientName,
					path: rootPath,
					state: 'collapsed',
					entityType: self.rootNodeType,
					partiallyLoaded: false,
					currentTreePage: 0,
					currentTablePage: 0
				};
				//set root node as selectedItem
				self.selectedItem = self.tree;
			};

			self.getColumnDefsGDrive = function() {
				var columnDefs = [];
				var displayNameColumn = {
					field: 'label',
					displayName: cvLoc('Name'),
					headerTooltip: true,
					cellTemplate:
						'<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.comIdaBrCtl.tableItemSelected(row.entity)">{{row.entity.label}}</a>' +
						'<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
					width: '*',
					enableSorting: true,
					sortParam: 'FileName'
				};
				columnDefs.push(displayNameColumn);

				var fileTypeColumn = {
					field: 'fileType',
					displayName: cvLoc('header.type'),
					headerTooltip: true,
					cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
					width: '*',
					enableSorting: true,
					sortParam: 'Flags'
				};
				columnDefs.push(fileTypeColumn);

				var sizeColumn = {
					field: 'userObject.size',
					displayName: cvLoc('Size'),
					headerTooltip: true,
					cellTemplate:
						'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
					width: '*',
					sortParam: 'MailSize'
				};
				//this is to show up/down arrow in ui for columns that are sortable by clicking column headers
				if (self.currentSortParameters.FOLDER.sortParam === 'MailSize') {
					sizeColumn.sort = new Object();
					if (self.currentSortParameters.FOLDER.sortOrder === CAPPS_CONSTANTS.SORT_DESC) {
						sizeColumn.sort.direction = uiGridConstants.DESC;
					} else if (self.currentSortParameters.FOLDER.sortOrder === CAPPS_CONSTANTS.SORT_ASC) {
						sizeColumn.sort.direction = uiGridConstants.ASC;
					}
				}
				columnDefs.push(sizeColumn);

				var backupTimeColumn = {
					field: 'userObject.advancedData.backupTime',
					displayName: cvLoc('Backup_Time'),
					headerTooltip: true,
					cellTemplate:
						'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
					width: '*',
					enableSorting: true,
					sortParam: 'ModifiedDate'
				};
				columnDefs.push(backupTimeColumn);
				return columnDefs;
			};

			self.getColumnDefsGMail = function() {
				var type = 'root';
				if (self.selectedItem && self.selectedItem.entityType) {
					type = self.selectedItem.entityType;
				}
				var columnDefs = [];
				//defining grid columns when list of users need to be displayed in right panel
				//root has mailboxes/users in it
				// for sortParam, get the correct param from Indexing team Enabling sorting only for those whose params look correct.

				if (type === CAPPS_CONSTANTS.MAILBOX_NODE.ROOT) {
					var displayNameColumn = {
						field: 'label',
						displayName: cvLoc('Name'),
						headerTooltip: true,
						cellTemplate:
							'<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.comIdaBrCtl.tableItemSelected(row.entity)">{{row.entity.label}}</a>' +
							'<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
						width: '*',
						enableSorting: false
					};

					var sizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '*',
						sortParam: 'MailSize'
					};
					//this is to show up/down arrow in ui for columns that are sortable by clicking column headers
					if (self.currentSortParameters.ROOT.sortParam === 'MailSize') {
						sizeColumn.sort = new Object();
						if (self.currentSortParameters.ROOT.sortOrder === CAPPS_CONSTANTS.SORT_DESC) {
							sizeColumn.sort.direction = uiGridConstants.DESC;
						} else if (self.currentSortParameters.ROOT.sortOrder === CAPPS_CONSTANTS.SORT_ASC) {
							sizeColumn.sort.direction = uiGridConstants.ASC;
						}
					}
					//email address is returned in displayName xml tag
					var smtpAddressColumn = {
						field: 'userObject.displayName',
						displayName: cvLoc('label.smtpAddress'),
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.displayName" title="{{row.entity.userObject.displayName}}"></div>',
						width: '*',
						enableSorting: false
					};
					columnDefs.push(displayNameColumn);
					columnDefs.push(sizeColumn);
					columnDefs.push(smtpAddressColumn);
				}
				//Folder has mails
				else if (type === CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX_FOLDER) {
					var mailColumn = {
						field: 'mail',
						displayName: '',
						enableSorting: false,
						headerTooltip: false,
						cellTemplate:
							'<div class="gmailRow">' +
							'<span class="emailFrom">{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailMessageMetadata.from|getGmailFrom}}</span>' +
							'<span class="noAttachment" data-ng-hide="row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailMessageMetadata.attachmentFlag"></span>' +
							'<span class="emailAttachment" data-ng-show="row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailMessageMetadata.attachmentFlag"><span class="attachment">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span>' +
							'<span class="emailDate">{{row.entity.userObject.modificationTime * 1000 | date : "medium"}}</span>' +
							'<br />' +
							'<span class="emailSubject crop" class="grid-tooltip" tooltip="{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailMessageMetadata.subject}}" tooltip-append-to-body="true" tooltip-placement="top" > <span class="ui-grid-cell-contents">{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailMessageMetadata.subject}}</span></span>' +
							'<span class="emailSize">{{row.entity.userObject.size|capacity}}</span>' +
							'</div>',
						width: '*'
					};

					columnDefs.push(mailColumn);
				}
				//mailbox has folders in it
				else if (type == CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX) {
					var displayNameColumn = {
						field: 'label',
						displayName: cvLoc('Name'),
						headerTooltip: true,
						cellTemplate:
							'<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.comIdaBrCtl.tableItemSelected(row.entity)">{{row.entity.label}}</a>' +
							'<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
						width: '*',
						enableSorting: false
					};
					var sizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '*',
						sortParam: 'FileSize'
					};
					//this is to show up/down arrow in ui for columns that are sortable by clicking column headers
					if (self.currentSortParameters.MAILBOX.sortParam === 'FileSize') {
						sizeColumn.sort = new Object();
						if (self.currentSortParameters.MAILBOX.sortOrder === CAPPS_CONSTANTS.SORT_DESC) {
							sizeColumn.sort.direction = uiGridConstants.DESC;
						} else if (self.currentSortParameters.MAILBOX.sortOrder === CAPPS_CONSTANTS.SORT_ASC) {
							sizeColumn.sort.direction = uiGridConstants.ASC;
						}
					}
					columnDefs.push(displayNameColumn);
					columnDefs.push(sizeColumn);
				} else {
					$log.error('Invalid type' + type + 'Column def construction failed');
				}
				return columnDefs;
			};

			self.getColumnDefsSalesforce = function() {
				var type = CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT;
				if (self.selectedItem && self.selectedItem.entityType) {
					type = self.selectedItem.entityType;
				}

				if (self.searchPerformed && self.selectedItem && self.selectedItem.path.startsWith('/Files')) {
					type = CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER;
				}

				var columnDefs = [];
				if (self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) {
					//Unlike other cases, SF record restore gets columns from backend
					var pageData = self.selectedItem.pageData;
					var currentTablePage = self.selectedItem.currentTablePage;
					var cnt = 0;
					//If column is loaded, set columnDefs
					if (self.salesforceColumns) {
						self.salesforceColumns.forEach(function(column) {
							var columnValueEmpty =
								pageData &&
								pageData[currentTablePage] &&
								pageData[currentTablePage].length > 0 &&
								!pageData[currentTablePage][0][column.name];
							columnDefs.push({
								field: column.name,
								sortParam: column.name,
								displayName: cappsUtil.getColumnNameSF(column.name),
								headerTooltip: true,
								cellTemplate:
									'<div><span class="crop" title="{{row.entity[\'' +
									column.name +
									"']}}\">{{row.entity['" +
									column.name +
									"']}}</span></div>",
								//Set first 7 non hidden columns which have non empty values visible.
								visible: cappsUtil.isHiddenColumnSF(column.name) || columnValueEmpty || ++cnt > 7 ? false : true
							});
						});
						self.salesforceColumnLoaded = true;
					}
					return columnDefs;
				}

				var displayNameColumn = {
					field: 'label',
					displayName: type == CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER ? cvLoc('label.ID') : cvLoc('Name'),
					headerTooltip: true,
					cellTemplate:
						'<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.comIdaBrCtl.tableItemSelected(row.entity)">{{row.entity.label}}</a>' +
						'<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
					width: '*'
				};

				var fileTypeColumn = {
					field: 'fileType',
					displayName: cvLoc('header.type'),
					headerTooltip: true,
					cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
					width: '*'
				};

				var sizeColumn = {
					field: 'userObject.size',
					displayName: cvLoc('Size'),
					headerTooltip: true,
					cellTemplate:
						'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
					width: '*'
				};

				var backupTimeColumn = {
					field: 'userObject.advancedData.backupTime',
					displayName: cvLoc('Backup_Time'),
					headerTooltip: true,
					cellTemplate:
						'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
					width: '*'
				};

				var modificationTimeColumn = {
					field:
						'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.metadataInfo.mdlastModifiedDate',
					displayName: cvLoc('label.modified'),
					headerTooltip: true,
					cellTemplate:
						'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.metadataInfo.mdlastModifiedDate? row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.metadataInfo.mdlastModifiedDate/1000: row.entity.userObject.modificationTime}}"></div>',
					width: '*',
					sortField: [
						'userObject.modificationTime',
						'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.metadataInfo.mdlastModifiedDate'
					]
				};

				var sfFileNameColumn = {
					field: 'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName',
					displayName: cvLoc('Name'),
					headerTooltip: true,
					cellTemplate:
						'<span class="crop" title="{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName}}" >{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName}}</span>',
					width: '*'
				};

				var sfTotalRowsColumn = {
					field: 'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.totalRows',
					displayName: cvLoc('label.totalRows'),
					cellTemplate:
						'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.totalRows}}</span>',
					width: '*'
				};
				var sfAddedRowsColumn = {
					field: 'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.addedRows',
					displayName: cvLoc('label.addedRows'),
					cellTemplate:
						'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.addedRows}}</span>',
					width: '*'
				};
				var sfModifiedRowsColumn = {
					field: 'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.modifiedRows',
					displayName: cvLoc('label.modifiedRows'),
					cellTemplate:
						'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.modifiedRows}}</span>',
					width: '*'
				};
				var sfDeletedRowsColumn = {
					field: 'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.deletedRows',
					displayName: cvLoc('label.deletedRows'),
					cellTemplate:
						'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.deletedRows}}</span>',
					width: '*'
				};

				columnDefs.push(displayNameColumn);

				if (type == CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER) {
					columnDefs.push(sfFileNameColumn);
				}

				if (
					type != CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT &&
					type != CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW &&
					type != CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW_PACKAGE
				) {
					columnDefs.push(fileTypeColumn);
				}

				if (type != CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT && type != CAPPS_CONSTANTS.SALESFORCE_NODE.OBJECT_VIEW) {
					columnDefs.push(sizeColumn);
				}

				if (
					(type == CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER ||
						type == CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW_TYPE ||
						type == CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW_FOLDER) &&
					!self.browseModel.isCompare
				) {
					columnDefs.push(modificationTimeColumn);
				}

				if (type == CAPPS_CONSTANTS.SALESFORCE_NODE.OBJECT_VIEW) {
					columnDefs.push(sfTotalRowsColumn);
					if (!self.browseModel.isCompare) {
						columnDefs.push(sfAddedRowsColumn);
						columnDefs.push(sfModifiedRowsColumn);
						columnDefs.push(sfDeletedRowsColumn);
					}
				}

				columnDefs.push(backupTimeColumn);

				return columnDefs;
			};

			self.getColumnDefsDynamoDb = function() {
				//Only two levels: region -> table
				let level = 0;
				if (self.selectedItem && self.selectedItem.entityType) {
					level = self.selectedItem.entityType;
				}

				const columns = [];
				const displayNameColumn = {
					field: 'label',
					displayName: level > 0 ? cvLoc('label.table') : cvLoc('label.region'),
					headerTooltip: true,
					cellTemplate: `<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.comIdaBrCtl.tableItemSelected(row.entity)">{{row.entity.label}}</a>
									<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>`,
					width: '*',
					enableSorting: false
				};
				const sizeColumn = {
					field: 'description.table.TableSizeBytes',
					displayName: cvLoc('Size'),
					headerTooltip: true,
					cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.TableSizeBytes|capacity" title="{{row.entity.description.table.TableSizeBytes|capacity}}"></div>`,
					width: '*',
					enableSorting: false
				};
				const partitionKeyColumn = {
					field: 'description.table.KeySchema[0].AttributeName',
					displayName: cvLoc('label.partitionKey'),
					headerTooltip: true,
					cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.KeySchema[0].AttributeName" title="{{row.entity.description.table.KeySchema[0].AttributeName}}"></div>`,
					width: '*',
					enableSorting: false
				};
				const totalReadColumn = {
					field: 'description.table.ProvisionedThroughput.ReadCapacityUnits',
					displayName: cvLoc('label.totalReadCapacity'),
					headerTooltip: true,
					cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.ProvisionedThroughput.ReadCapacityUnits" title="{{row.entity.description.table.ProvisionedThroughput.ReadCapacityUnits}}"></div>`,
					width: '*',
					enableSorting: false
				};
				const totalWriteColumn = {
					field: 'description.table.ProvisionedThroughput.WriteCapacityUnits',
					displayName: cvLoc('label.totalWriteCapacity'),
					headerTooltip: true,
					cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.ProvisionedThroughput.WriteCapacityUnits" title="{{row.entity.description.table.ProvisionedThroughput.WriteCapacityUnits}}"></div>`,
					width: '*',
					enableSorting: false
				};

				const backupTimeColumn = {
					field: 'userObject.advancedData.backupTime',
					displayName: cvLoc('Backup_Time'),
					headerTooltip: true,
					cellTemplate: `<div class="time" val="{{row.entity.userObject.advancedData.backupTime}}"></div>`,
					width: '*',
					enableSorting: false
				};

				columns.push(displayNameColumn);
				if (level > 0) {
					columns.push(sizeColumn);
					columns.push(partitionKeyColumn);
					columns.push(totalReadColumn);
					columns.push(totalWriteColumn);
				}
				columns.push(backupTimeColumn);
				return columns;
			};

			self.getColumnDefs = function() {
				var columnDefs = [];
				switch (parseInt(self.browseModel.applicationId)) {
					case AppTypes.CLOUD_APPS:
						switch (parseInt(self.browseModel.cloudAppType)) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value:
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value:
								columnDefs = self.getColumnDefsGDrive();
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value:
								columnDefs = self.getColumnDefsGMail();
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value:
								columnDefs = self.getColumnDefsSalesforce();
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value:
								columnDefs = self.getColumnDefsDynamoDb();
								break;
						}
						break;
				}

				return columnDefs;
			};

			self.setColumnDefs = function() {
				if (
					self.bTreeOnly === true ||
					((self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) && self.salesforceColumnLoaded)
				) {
					return;
				}
				if (self.gridOptions) {
					self.gridOptions.columnDefs = self.getColumnDefs();
				}
			};

			self.setAdvancedSearchBoxOptions = function() {
				if (self.searchPerformed) {
					return;
				}

				if (self.showSearchBoxOptions()) {
					let searchBoxOptions = self.getSearchBoxOptions();

					if (searchBoxOptions.fieldDefs.length > 0) {
						self.cvAdvSearchOptions = searchBoxOptions;
						self.cvIsAdvSearch = true;
						self.refreshAdvancedSearch = !self.refreshAdvancedSearch;
					} else {
						self.cvIsAdvSearch = false;
					}
				}
			};

			var getCompareCriteriaField = function(field) {
				let value = field.model.toUpperCase();

				let matchValue = value.match(/(\d+)/); //returns the numbers from the string
				let number = '0';
				if (matchValue) {
					number = matchValue[0];
				}

				let dataOperator = value.substring(0, value.indexOf(number));
				let dataOperatorField = 'EQUALSBLAH';
				if (dataOperator === '') {
					dataOperator = '==';
				}

				let dataOperatorValues = {
					'==': 'EQUALSBLAH',
					'<': 'LT',
					'<=': 'LTE',
					'>': 'GT',
					'>=': 'GTE'
				};

				if (dataOperatorValues.hasOwnProperty(dataOperator)) {
					dataOperatorField = dataOperatorValues[dataOperator];
				}

				let criteria = {
					dataOperator: dataOperatorField,
					field: field.fieldValue,
					val: number
				};

				let unitValueMatch = value.match(/(KB|MB|GB)+$/); // returns the match for units
				if (unitValueMatch) {
					criteria.dataUnit = unitValueMatch[0];
				}

				return criteria;
			};

			var getFormattedDate = function(date) {
				return $filter('date')(date, 'yyyy-MM-ddTHH:mm:ssZ');
			};

			var setModifiedDateField = function(field) {
				if (field.model !== cvLoc('label.timeRange')) {
					// reset from time and to time field values
					self.browseModel.timerangeBrowseOptions.fromTime = undefined;
					self.browseModel.timerangeBrowseOptions.toTime = undefined;

					let previousDaysCount = 0;
					switch (field.model) {
						case cvLoc('label.today'):
							previousDaysCount = 0;
							break;
						case cvLoc('label.yesterday'):
							previousDaysCount = 1;

							// set to time as yesterday 11:59:59
							var today = new Date();
							today.setUTCDate(today.getDate() - 1);
							today.setHours(23, 59, 59, 0);
							self.browseModel.timerangeBrowseOptions.toTime = getFormattedDate(today);
							break;
						case cvLoc('label.thisWeek'):
							previousDaysCount = 7;
							break;
						case cvLoc('label.thisMonth'):
							previousDaysCount = 30;
							break;
						case cvLoc('label.thisYear'):
							previousDaysCount = 365;
							break;
					}

					var date = new Date();
					date.setUTCDate(date.getDate() - previousDaysCount);
					date.setHours(0, 0, 0, 0);

					self.browseModel.timerangeBrowseOptions.fromTime = getFormattedDate(date);
				}
			};

			var setIncludeFolders = function(field) {
				if (field.model) {
					self.browseModel.fileOrFolder = 'FILEFOLDER';
				} else {
					self.browseModel.fileOrFolder = 'FILE';
				}
			};

			self.getCriteriaAndSetSearchField = function(field) {
				let value = field.model;

				if (value === undefined || value === '' || field.fieldValue === undefined) {
					return;
				}

				switch (field.fieldValue) {
					case 'SHOW_DELETED_FILES':
						self.browseModel.showDeletedFilesValue = field.model;
						return;
					case 'SHOW_FOLDERS':
						setIncludeFolders(field);
						return;
					case 'ModifiedDate':
						return setModifiedDateField(field);
					case 'FileSize':
					case 'SFTotalCount':
					case 'SFAddedCount':
					case 'SFModifiedCount':
					case 'SFDeletedCount':
						return getCompareCriteriaField(field);
					default:
						return {
							dataOperator: 'LIKE',
							field: field.fieldValue,
							val: field.model + ''
						};
				}
			};

			self.onSearch = function(query, fields) {
				// reset from time and to time field values before performing browse operation
				self.browseModel.timerangeBrowseOptions.fromTime = undefined;
				self.browseModel.timerangeBrowseOptions.toTime = undefined;

				// setting include folders option by default for meta data restore
				if (self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA) {
					self.browseModel.fileOrFolder = 'FILEFOLDER';
				}

				var includesFromTime = _.includes(query, 'FromTime:'),
					includesToTime = _.includes(query, 'ToTime:'),
					fromTimeField = _.find(fields, { tag: 'FromTime:' }),
					toTimeField = _.find(fields, { tag: 'ToTime:' }),
					fromTime = self.formatDateForBackend(fromTimeField.model),
					toTime = self.formatDateForBackend(toTimeField.model);

				if (includesFromTime) {
					if (fromTimeField) {
						self.browseModel.timerangeBrowseOptions.fromTime = fromTime;
					}

					if (includesToTime) {
						self.browseModel.timerangeBrowseOptions.toTime = toTime;
					}
				} else if (includesToTime) {
					self.browseModel.timerangeBrowseOptions.toTime = toTime;
				}

				let criteriaList = [];
				for (let i = 0; i < fields.length; i++) {
					let criteria = self.getCriteriaAndSetSearchField(fields[i]);
					if (criteria) {
						query = query.replace(fields[i].tag + fields[i].model + ' ', '');
						criteriaList.push(criteria);
					}
				}

				self.searchPerformed = true;
				self.browseModel.criteria = criteriaList;
				self.setColumnDefs();
				self.loadTable(self.selectedItem);
			};

			var getCustomTextFieldTemplate = function() {
				return `<div class="col-xs-12"><div class="form-group">
						<label for="{{field.tag}}" >
						<cv-help-text help-label="{{field.label}}" help-text="field.helpText" ></cv-help-text></label>
						<input id="{{field.tag}}" type="text" ng-model="field.model" ng-model-options="{updateOn: \'blur\'}" ng-change="updateQuery()" />
					</div></div>`;
			};

			var getCustomCountFieldTemplate = function() {
				return `<div class="col-xs-12"><div class="form-group">
						<label for="{{field.tag}}" >
						<cv-help-text help-label="{{field.label}}" help-text="field.helpText" ></cv-help-text></label>
						<input id="{{field.tag}}" data-ng-change="field.regExMatch(field)" type="text" ng-model="field.model" ng-model-options="{updateOn: \'blur\'}" />
						<span class="error" data-ng-if="field.error">{{field.error}}</span>
					</div></div>`;
			};

			var fileSizeValidation = function(data) {
				if (!data) {
					return;
				}

				data.error = undefined;
				if (data.model === undefined || data.model === '') {
					return;
				}

				let value = data.model.toUpperCase();
				var fileSizeReg = new RegExp(/^(>=|==|<=|>|<)+(\d)+(KB|MB|GB)+$/);

				if (!fileSizeReg.test(value)) {
					data.error = cvLoc('capps.salesforce.object.sizeFieldHint');
				}
			};

			var fileCountValidation = function(data) {
				if (!data) {
					return;
				}
				data.error = undefined;
				if (data.model === undefined || data.model === '') {
					return;
				}

				let value = data.model.toUpperCase();
				var fileCountReg = new RegExp(/^(>=|==|<=|>|<)+(\d)+$/);

				if (!fileCountReg.test(value)) {
					data.error = cvLoc('capps.salesforce.object.countFieldHint');
				}
			};

			self.getSearchFields = function() {
				return {
					FILE_NAME: {
						label: cvLoc('capps.salesforce.files.name'),
						tag: cvLoc('capps.salesforce.tag.filename'),
						fieldValue: 'FileName',
						helpText: cvLoc('capps.salesforce.fileNameFieldHint'),
						customTemplate: getCustomTextFieldTemplate()
					},
					METADATA_SIZE: {
						label: cvLoc('capps.salesforce.metadata.size'),
						tag: cvLoc('capps.salesforce.metadata.size'),
						fieldValue: 'FileSize',
						helpText: cvLoc('capps.salesforce.object.sizeFieldHint'),
						regExMatch: fileSizeValidation,
						customTemplate: getCustomCountFieldTemplate()
					},
					FILE_DISPLAY_NAME: {
						label: cvLoc('capps.salesforce.files.name'),
						tag: cvLoc('capps.salesforce.tag.filename'),
						fieldValue: 'SFDisplayFileName',
						helpText: cvLoc('capps.salesforce.fileNameFieldHint'),
						customTemplate: getCustomTextFieldTemplate()
					},
					FILE_ID: {
						label: cvLoc('capps.salesforce.files.id'),
						tag: cvLoc('capps.salesforce.files.id'),
						fieldValue: 'FileName'
					},
					OBJECT_NAME: {
						label: cvLoc('capps.salesforce.object.name'),
						tag: cvLoc('capps.salesforce.tag.objectname'),
						fieldValue: 'FileName',
						helpText: cvLoc('capps.salesforce.objectNameFieldHint'),
						customTemplate: getCustomTextFieldTemplate()
					},
					ADDED_ROWS: {
						label: cvLoc('capps.salesforce.object.addedRows'),
						tag: cvLoc('capps.salesforce.tag.addedCount'),
						fieldValue: 'SFAddedCount',
						helpText: cvLoc('capps.salesforce.object.countFieldHint'),
						regExMatch: fileCountValidation,
						customTemplate: getCustomCountFieldTemplate()
					},
					MODIFIED_ROWS: {
						label: cvLoc('capps.salesforce.object.modifiedRows'),
						tag: cvLoc('capps.salesforce.tag.modifiedCount'),
						fieldValue: 'SFModifiedCount',
						helpText: cvLoc('capps.salesforce.object.countFieldHint'),
						regExMatch: fileCountValidation,
						customTemplate: getCustomCountFieldTemplate()
					},
					DELETED_ROWS: {
						label: cvLoc('capps.salesforce.object.deletedRows'),
						tag: cvLoc('capps.salesforce.tag.deletedCount'),
						fieldValue: 'SFDeletedCount',
						helpText: cvLoc('capps.salesforce.object.countFieldHint'),
						regExMatch: fileCountValidation,
						customTemplate: getCustomCountFieldTemplate()
					},
					MODIFIED_TIME: {
						label: cvLoc('capps.keyword.modTime'),
						tag: cvLoc('fs.keyword.modTime'),
						type: 'select',
						fieldValue: 'ModifiedDate',
						options: [
							{
								label: cvLoc('label.today'),
								value: cvLoc('label.today')
							},
							{
								label: cvLoc('label.yesterday'),
								value: cvLoc('label.yesterday')
							},
							{
								label: cvLoc('label.thisWeek'),
								value: cvLoc('label.thisWeek')
							},
							{
								label: cvLoc('label.thisMonth'),
								value: cvLoc('label.thisMonth')
							},
							{
								label: cvLoc('label.thisYear'),
								value: cvLoc('label.thisYear')
							},
							{
								label: cvLoc('label.timeRange'),
								value: cvLoc('label.timeRange')
							}
						]
					},
					FROM_TIME: {
						label: cvLoc('label.fromTime'),
						tag: 'FromTime:',
						type: 'date',
						options: {
							format: 'MM/dd/yyyy',
							showWeeks: false,
							maxDate: new Date()
						},
						dependsOn: {
							tag: cvLoc('fs.keyword.modTime'),
							model: cvLoc('label.timeRange')
						}
					},
					TO_TIME: {
						label: cvLoc('label.toTime'),
						tag: 'ToTime:',
						type: 'date',
						options: {
							format: 'MM/dd/yyyy',
							showWeeks: false,
							maxDate: new Date()
						},
						dependsOn: {
							tag: cvLoc('fs.keyword.modTime'),
							model: cvLoc('label.timeRange')
						}
					},
					SHOW_DELETED_FILES: {
						label: cvLoc('capps.salesforce.showDeletedFiles'),
						tag: cvLoc('capps.salesforce.showDeletedFilesTrue'),
						type: 'checkbox',
						model: true,
						fieldValue: 'SHOW_DELETED_FILES'
					},
					SHOW_FOLDERS: {
						label: cvLoc('fs.keywords.showFolders'),
						tag: cvLoc('fs.keyword.includeFolders'),
						type: 'checkbox',
						model: true,
						fieldValue: 'SHOW_FOLDERS'
					}
				};
			};

			self.showSearchBoxOptions = function() {
				let showSearchBox = false;
				switch (parseInt(self.browseModel.applicationId)) {
					case AppTypes.CLOUD_APPS:
						switch (parseInt(self.browseModel.cloudAppType)) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value:
								showSearchBox = true;
								break;
						}
				}
				return showSearchBox;
			};

			self.getSearchBoxOptions = function() {
				let searchFields = [];
				switch (parseInt(self.browseModel.applicationId)) {
					case AppTypes.CLOUD_APPS:
						switch (parseInt(self.browseModel.cloudAppType)) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value:
								searchFields = self.getSearchBoxOptionsSalesforce();
								break;
						}
				}

				return {
					fieldDefs: searchFields,
					query: '',
					onSearch: self.onSearch
				};
			};

			self.getSearchBoxOptionsSalesforce = function() {
				let searchFields = [];
				var type = 'root';
				let CAPPS_SEARCH_FIELDS = self.getSearchFields();
				self.searchInputPlaceHolderText = cvLoc('label.searchForFiles');

				if (self.selectedItem && self.selectedItem.entityType) {
					type = self.selectedItem.entityType;
				}

				if (
					self.browseModel.browseType === CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE ||
					self.browseModel.browseType === CAPPS_CONSTANTS.BROWSE_TYPE.SANDBOX_SEEDING
				) {
					// hide advanced search box for record, sandbox and compare restore operations
					return [];
				}

				if (self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA) {
					searchFields = [CAPPS_SEARCH_FIELDS.FILE_NAME, CAPPS_SEARCH_FIELDS.METADATA_SIZE];
				} else if (
					self.browseModel.browseType !== CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE &&
					self.browseModel.browseType !== CAPPS_CONSTANTS.BROWSE_TYPE.SANDBOX_SEEDING
				) {
					if (type === CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT || type === 'root') {
						// hide advanced search box on root page for object restore view
						return [];
					} else if (
						type === CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW ||
						type === CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER
					) {
						searchFields = [CAPPS_SEARCH_FIELDS.FILE_DISPLAY_NAME, CAPPS_SEARCH_FIELDS.FILE_ID];
					} else if (type === CAPPS_CONSTANTS.SALESFORCE_NODE.OBJECT_VIEW) {
						searchFields = [
							CAPPS_SEARCH_FIELDS.OBJECT_NAME,
							CAPPS_SEARCH_FIELDS.ADDED_ROWS,
							CAPPS_SEARCH_FIELDS.MODIFIED_ROWS,
							CAPPS_SEARCH_FIELDS.DELETED_ROWS
						];
						self.searchInputPlaceHolderText = cvLoc('label.searchForObjects');
					}
				} else {
					// default hide the advanced search box
					return [];
				}

				let commonFields = [
					CAPPS_SEARCH_FIELDS.MODIFIED_TIME,
					CAPPS_SEARCH_FIELDS.FROM_TIME,
					CAPPS_SEARCH_FIELDS.TO_TIME,
					CAPPS_SEARCH_FIELDS.SHOW_DELETED_FILES
				];

				return searchFields.concat(commonFields);
			};

			self.isDynamoDb = function() {
				return (
					Number.parseInt(self.browseModel.applicationId) === AppTypes.CLOUD_APPS &&
					Number.parseInt(self.browseModel.cloudAppType) ===
						CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value
				);
			};

			self.isSalesforce = function() {
				return (
					self.browseModel.applicationId == AppTypes.CLOUD_APPS &&
					self.browseModel.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value
				);
			};

			self.isSalesforceObjCompare = function() {
				return (
					self.isSalesforce() &&
					self.browseModel.isCompare &&
					self.browseModel.browseType != CAPPS_CONSTANTS.BROWSE_TYPE.METADATA
				);
			};

			self.hideTree = function() {
				return self.isSalesforceObjCompare() || self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding();
			};

			self.showCustomBreadcrumbs = function() {
				return self.cvGridOptions === undefined || self.cvGridOptions.cvBreadcrumbs === undefined;
			};

			self.hideActions = function() {
				return self.isSalesforceSandboxSeeding();
			};

			self.hideTitle = function() {
				return self.isSalesforceSandboxSeeding();
			};

			self.isSalesforceRecordRestore = function() {
				return self.isSalesforce() && self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE;
			};

			self.isSalesforceSandboxSeeding = function() {
				return self.isSalesforce() && self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.SANDBOX_SEEDING;
			};

			self.useCVGrid = function() {
				return self.isSalesforce();
			};

			self.enableFiltering = function() {
				return self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding();
			};

			self.enableGridMenu = function() {
				return self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding();
			};

			self.enableRestore = function(selectedRows) {
				if (!selectedRows || selectedRows.length <= 0) {
					return false;
				}
				if (self.isDynamoDb()) {
					if (self.getLevel(selectedRows[0]) <= 1) {
						return false;
					}
				}
				return true;
			};

			self.setGridOptions = function() {
				if (self.bTreeOnly === true) {
					return;
				}
				var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
				//gridapi should not be defined in scope. as we will move to a different directive this fix is not required right now.
				angular.extend(globalGridOptions, {
					data: 'browseData',
					enableFiltering: self.enableFiltering(),
					useExternalPagination: true,
					useExternalFiltering: true,
					paginationPageSizes: self.paginationPageSizes,
					paginationPageSize: self.defaultTablePageSize,
					showGridFooter: true,
					useExternalSorting: !self.isSalesforce(),
					rowHeight: 43,
					enableGridMenu: self.enableGridMenu(),
					gridMenuCustomItems: [
						{
							title: cvLoc('label.toggleFilter'),
							action: function() {
								this.grid.appScope.comIdaBrCtl.cvGridOptions.gridOptions.enableFiltering = !this.grid.appScope
									.comIdaBrCtl.cvGridOptions.gridOptions.enableFiltering;
								this.grid.appScope.comIdaBrCtl.gridApi.core.notifyDataChange(uiGridConstants.dataChange.COLUMN);
							}
						}
					],
					onRegisterApi: function(gridApi) {
						$scope.gridApi = gridApi;
						self.gridApi = gridApi;

						gridApi.selection.on.rowSelectionChanged($scope, function(row) {
							self.selectedRows = gridApi.selection.getSelectedRows();
							self.restoreAllowed = self.enableRestore(self.selectedRows);
						});
						gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
							self.selectedRows = gridApi.selection.getSelectedRows();
							self.restoreAllowed = self.enableRestore(self.selectedRows);
						});

						gridApi.pagination.on.paginationChanged($scope, function(newPage, pageSize) {
							if (!self.pageSizeModified && pageSize != self.defaultTablePageSize) {
								self.pageSizeModified = true;
							}

							var item = self.selectedItem;
							item.currentTablePage = newPage - 1; //back end page numbers are starting from 0.

							self.loadTable(item);
						});

						$scope.gridApi.core.on.sortChanged($scope, function(grid, sortColumns) {
							self.sortingInfoModified = true;

							var item = self.selectedItem;
							if (self.isSalesforce()) {
								//Use new function to support sorting on multiple columns
								self.setMultiSortInfo(sortColumns);
							} else {
								self.setCurrentSortingInfo(
									item.entityType,
									sortColumns[0].sort.direction,
									sortColumns[0].colDef.sortParam
								);
							}
							item.currentTablePage = 0; //back end page numbers are starting from 0.
							if ($scope.gridApi.pagination.getPage() > 1) {
								$scope.gridApi.pagination.seek(1);
							}
							self.loadTable(item);
						});

						gridApi.core.on.filterChanged($scope, function() {
							self.filterInfoModified = true;

							if (self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) {
								//Record new filter info, and reload if actually changed
								var filterArray = [];
								this.grid.columns.forEach(function(column) {
									if (column.filters.length > 0 && column.filters[0].term) {
										filterArray.push({
											column: column.name,
											term: column.filters[0].term
										});
									}
								});

								var oldFilterInfo = angular.copy(self.filterInfo);
								self.filterInfo = angular.toJson(filterArray);
								//Only reload if filter actully changed
								if (oldFilterInfo != self.filterInfo && (oldFilterInfo || filterArray.length != 0)) {
									self.loadTable(self.browseModel.salesforceTable);
								}
							}
						});
					}
				});
				self.gridOptions = globalGridOptions;
				//Current code is using ui-grid
				//Other ida can move to cv-grid when ready
				self.cvGridOptions = {
					cvIsSearchable: false,
					cvHasTitle: false,
					cvHasColumnFilter: true,
					cvHasViews: false,
					cvBreadcrumbs: {
						model: self.breadcrumbModel,
						itemTemplate: 'breadcrumbItem'
					},
					cvGridDirectives: {
						uiGridSelection: !self.isSalesforceSandboxSeeding()
					},
					cvGridCssClass: {
						'users-grid toggle-filter-enabled': true
					},
					gridOptions: globalGridOptions
				};
			};
			self.clearItemSelection = function() {
				if (!self.bTreeOnly && $scope.gridApi) {
					$scope.gridApi.selection.clearSelectedRows();
				}
				self.searchPerformed = false;
				self.browseModel.criteria = undefined;
			};

			self.reload = function() {
				self.initRootNode(self.osType, self.entityName);
				if ($scope.gridApi && $scope.gridApi.pagination && $scope.gridApi.pagination.getPage() > 1) {
					$scope.gridApi.pagination.seek(1);
				}
				self.clearItemSelection();
				self.loadTree(self.selectedItem);
				self.setColumnDefs();

				self.loadTable(self.selectedItem);

				self.updateTimeRangeLabel();

				self.setAdvancedSearchBoxOptions();
			};

			self.updateTimeRange = function(result) {
				if (result != null) {
					var fromDateString = result.fromDateString;
					if (fromDateString != null) {
						fromDateString = self.formatDateForBackend(fromDateString);
						self.browseModel.timerangeBrowseOptions.fromTime = fromDateString;
					} else {
						self.browseModel.timerangeBrowseOptions.fromTime = null;
					}
					var toDateString = result.toDateString;
					if (toDateString != null) {
						toDateString = self.formatDateForBackend(toDateString);
						self.browseModel.timerangeBrowseOptions.toTime = toDateString;
					} else {
						self.browseModel.timerangeBrowseOptions.toTime = null;
					}
					self.browseModel.passUtcTime = true;
					self.reload();
				}
			};

			self.formatDateForBackend = function(toUtcDate) {
				//return toUtcDate.getTime() / 1000 + '';
				if (self.browseModel.skipCvUtcConversion) {
					return $filter('date')(toUtcDate, 'yyyy-MM-ddTHH:mm:ssZ', 'UTC');
				}
				return $filter('date')(toUtcDate, 'yyyy-MM-ddTHH:mm:ssZ');
			};

			self.getUserDisplayableDate = function(dt) {
				if (!dt) {
					return '';
				}
				//return $filter('date')(dt, 'yyyy-MM-dd HH:mm');
				//var utcDate = $filter('date')(new Date(dt * 1000), 'yyyy-MM-dd HH:mm:ss');
				if (self.browseModel.skipCvUtcConversion) {
					return new Date(dt).toLocaleString();
				}
				var utcDate = $filter('date')(dt, 'yyyy-MM-dd HH:mm:ss');
				return new Date(utcDate + ' UTC').toLocaleString();
			};

			self.updateTimeRangeLabel = function() {
				if (self.browseModel.timerangeBrowseOptions.fromTime) {
					self.timeRangeLabel = cvLoc(
						'Showing_backups_range',
						self.getUserDisplayableDate(self.browseModel.timerangeBrowseOptions.fromTime),
						self.getUserDisplayableDate(self.browseModel.timerangeBrowseOptions.toTime)
					);
				} else if (self.browseModel.timerangeBrowseOptions.toTime) {
					self.timeRangeLabel = cvLoc(
						'Showing_backups_asof',
						self.getUserDisplayableDate(self.browseModel.timerangeBrowseOptions.toTime)
					);
				} else {
					self.timeRangeLabel = cvLoc('Showing_latest_backups');
				}
				// for record restore we shouldn't reset the passUtcTime flag.
				if (self.browseModel.browseType != CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE) {
					self.browseModel.passUtcTime = false;
				}
			};

			self.toggleSortOrder = function(sortOrder) {
				if (sortOrder == CAPPS_CONSTANTS.SORT_DESC) {
					return CAPPS_CONSTANTS.SORT_ASC;
				} else if (sortOrder == CAPPS_CONSTANTS.SORT_ASC) {
					return CAPPS_CONSTANTS.SORT_DESC;
				} else {
					return CAPPS_CONSTANTS.SORT_ASC;
				}
			};
			//some node types have option of external sort i.e. sort via dropdown instead of grid headers
			self.externalSortClicked = function(newSortOption) {
				self.sortingInfoModified = true;
				var newSortInfo = self.getExternalSortInfo(newSortOption);
				var item = self.selectedItem;
				self.setCurrentSortingInfo(
					item.entityType,
					newSortInfo.sortOrder,
					newSortInfo.sortParam,
					newSortInfo.localeKey
				);
				item.currentTablePage = 0; //back end page numbers are starting from 0.
				if ($scope.gridApi.pagination.getPage() > 1) {
					$scope.gridApi.pagination.seek(1);
				}
				self.loadTable(item);
			};
			//when external sort is clicked. sorting info needs to be prepared.
			//Below func reverses the sort order if present, if not present, defaultSortOrder is returned. DefaultSortOrder may not be always ascending
			//eg for file size default sort order may be desc.
			self.getExternalSortInfo = function(newSortOption) {
				var sortParam = newSortOption.sortParam;

				var sortOrder;
				if (self.currentSortParameters.MAILBOX_FOLDER.sortParam === newSortOption.sortParam) {
					sortOrder = self.toggleSortOrder(self.currentSortParameters.MAILBOX_FOLDER.sortOrder);
				} else {
					sortOrder = newSortOption.defaultSortOrder;
				}
				return {
					sortParam: sortParam,
					sortOrder: sortOrder,
					localeKey: newSortOption.localeKey
				};
			};
			//sorting info is at system level for each node type. it is not at item level.
			//this value is sent to server as part of browse request
			self.getCurrentSortingInfo = function(item) {
				var sortingInfo;
				//expected format of sorting info by backend is asc or desc : comma separated sort by fields
				switch (item.entityType) {
					case BROWSE_NODE_TYPE.FOLDER:
						sortingInfo =
							self.currentSortParameters.FOLDER.sortOrder + ':' + self.currentSortParameters.FOLDER.sortParam;
						break;

					case CAPPS_CONSTANTS.MAILBOX_NODE.ROOT:
						sortingInfo = self.currentSortParameters.ROOT.sortOrder + ':' + self.currentSortParameters.ROOT.sortParam;
						break;

					case CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX:
						sortingInfo =
							self.currentSortParameters.MAILBOX.sortOrder + ':' + self.currentSortParameters.MAILBOX.sortParam;
						break;

					case CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX_FOLDER:
						sortingInfo =
							self.currentSortParameters.MAILBOX_FOLDER.sortOrder +
							':' +
							self.currentSortParameters.MAILBOX_FOLDER.sortParam;
						break;
				}

				return sortingInfo;
			};

			self.setCurrentSortingInfo = function(entityType, sortOrder, sortParam, localeKey) {
				switch (entityType) {
					case BROWSE_NODE_TYPE.FOLDER:
						self.currentSortParameters.FOLDER.sortOrder = sortOrder;
						self.currentSortParameters.FOLDER.sortParam = sortParam;
						break;

					case CAPPS_CONSTANTS.MAILBOX_NODE.ROOT:
						self.currentSortParameters.ROOT.sortOrder = sortOrder;
						self.currentSortParameters.ROOT.sortParam = sortParam;
						break;

					case CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX:
						self.currentSortParameters.MAILBOX.sortOrder = sortOrder;
						self.currentSortParameters.MAILBOX.sortParam = sortParam;
						break;

					case CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX_FOLDER:
						self.currentSortParameters.MAILBOX_FOLDER.sortOrder = sortOrder;
						self.currentSortParameters.MAILBOX_FOLDER.sortParam = sortParam;
						self.currentSortParameters.MAILBOX_FOLDER.localeKey = localeKey;
						break;
				}
			};

			self.getMultiSortInfo = function() {
				var multiSortInfo = [];
				if (self.currentSortColumns) {
					self.currentSortColumns.forEach(function(sortColumn) {
						multiSortInfo.push({ sortParam: sortColumn.colDef.sortParam, direction: sortColumn.sort.direction });
					});
				}
				return angular.toJson(multiSortInfo);
			};

			self.setMultiSortInfo = function(sortColumns) {
				self.currentSortColumns = sortColumns;
			};

			self.clearMultiSortInfo = function() {
				self.currentSortColumns = undefined;
			};

			self.clearFilterInfo = function() {
				self.filterInfo = undefined;
			};

			self.getFileSeparater = function(osType) {
				var rootPath = '\\';
				if (osType === 'Unix') {
					rootPath = '/';
				}
				return rootPath;
			};

			//Some agents have requirement to have browse path prefixed. the value can be set here.
			self.getPathPrefix = function() {
				switch (parseInt(self.browseModel.applicationId)) {
					case AppTypes.CLOUD_APPS:
						//CloudApps clients have a path prefix based on its type.
						switch (parseInt(self.browseModel.cloudAppType)) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value:
								return CAPPS_CONSTANTS.BROWSE_PATH_PREFIX_ONEDRIVE;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value:
								return CAPPS_CONSTANTS.BROWSE_PATH_PREFIX_GMAIL;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value:
								return CAPPS_CONSTANTS.BROWSE_PATH_PREFIX_GDRIVE;
							default:
								return '';
						}
						break;
					default:
						return '';
				}
			};

			self.getParentPath = function(itemPath) {
				var separator = self.getFileSeparater(self.clientProps['osType']);
				var parentPath = '';
				if (itemPath == separator) {
					//Setting parent path when browsing root node with the prefix so atht subsequent paths are formed correctly
					var initialPath = self.getPathPrefix();
					parentPath = initialPath + itemPath;
				} else {
					parentPath = itemPath + separator;
				}
				return parentPath;
			};

			//get browse options that need to be sent as part of browse request
			self.getBrowseRequestOptions = function(item, forTree) {
				var bOptions = {
					applicationId: self.browseModel.applicationId,
					subclientId: self.browseModel.entityId,
					backupsetId: self.entity.backupsetId,
					entityType: self.entityType,
					path: item.path,
					toTime: self.browseModel.timerangeBrowseOptions.toTime,
					fromTime: self.browseModel.timerangeBrowseOptions.fromTime,
					//For Cloudapps agent. For other agents it will be sent as undefined and that should be okay
					cloudAppType: self.browseModel.cloudAppType,
					browseType: self.browseModel.browseType,
					showDeletedFiles: self.browseModel.showDeletedFilesValue,
					showAllMetadata: self.browseModel.includeMetadataValue,
					filterInfo: self.filterInfo,
					whereCondition: self.browseModel.whereConditionValue,
					queryOptions: self.browseModel.queryOptionsValue
				};

				if (self.browseModel.fileOrFolder) {
					bOptions.fileOrFolder = self.browseModel.fileOrFolder;
				}

				if (self.browseModel.criteria) {
					bOptions.criteriaString = JSON.stringify(self.browseModel.criteria);
				}

				if (self.browseModel.passUtcTime) {
					bOptions.passUtcTime = self.browseModel.passUtcTime;
				}

				//Pagind and sorting options differ for tree and table
				if (forTree === true) {
					bOptions.pagingInfo = item.currentTreePage + ',' + self.defaultTreeSize;
					bOptions.sortingInfo = self.defaultTreeSortingInfo;
				} else {
					bOptions.pagingInfo = item.currentTablePage + ',' + self.gridOptions.paginationPageSize;
					if (self.isSalesforce()) {
						bOptions.multiSortInfo = self.getMultiSortInfo();
					} else {
						bOptions.sortingInfo = self.getCurrentSortingInfo(item);
					}
				}

				//Use record restore for sandbox seeding
				if (self.isSalesforceSandboxSeeding()) {
					bOptions.browseType = CAPPS_CONSTANTS.BROWSE_TYPE.RECORD_RESTORE;
					bOptions.seedingOption = self.browseModel.seedingOption;
				}
				return bOptions;
			};

			//get child folders for an item in left nav tree
			self.getBTreeChildren = function(subItems, item) {
				//setting parent path so that child's path can be formed as parentPath + child's Id
				var parentPath = self.getParentPath(item.path);
				var children = [];

				//ASCII Control character synchronize (ASCII code 22)
				var synChar = String.fromCharCode(22);
				var negAck = String.fromCharCode(21);
				angular.forEach(subItems, function(bTreeChild) {
					//Only expandable nodes need to add the tree.
					//Only Users and mail folders should be added to children array - Review
					//Need to check if an option can be sent in browse request itself so that browse response has only leafnode as false items
					if (!bTreeChild.leafNode) {
						bTreeChild['currentTablePage'] = 0;
						bTreeChild['parent'] = item;
						bTreeChild['path'] = parentPath + bTreeChild.id;
						bTreeChild['state'] = 'collapsed';

						//data received from backend has backslash (separator withing path) replaced with ASCII Control character synchronize (ASCII code 22)
						//Hence converting it back to backslash so that UI has right label

						bTreeChild['label'] = bTreeChild['label'].replace(new RegExp(synChar, 'g'), '/');
						bTreeChild['label'] = bTreeChild['label'].replace(new RegExp(negAck, 'g'), '\\');

						//we need to know the item in left nav is root or a mailbox or a folder within a mailbox.
						//Because based on the type contents and format of right panel is determined.
						//Hence finding the type and assigning it as a property to the left nav item
						//entityTYpe is used when browsing an item. Leaf items are not browsed so we dont need to set entity type for leaf items

						bTreeChild['entityType'] = self.getItemType(bTreeChild);
						children.push(bTreeChild);
					}
				});
				return children;
			};

			var getParentTableNode = function(path) {
				if (path === null || path === '' || path === '/') {
					let rootNode = {
						currentTablePage: 0,
						entityType: 'sf_root',
						id: '/',
						label: 'default',
						path: '/',
						leafNode: false
					};
					return rootNode;
				}

				let currentNodeName = path.substring(path.lastIndexOf('/') + 1);

				let entityType = CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW;
				if (
					self.browseModel &&
					self.browseModel.browseType &&
					self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA
				) {
					entityType = CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW;
				} else if (path.startsWith('/Files/')) {
					entityType = CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER;
				}

				var node = {
					currentTablePage: 0,
					entityType: entityType,
					fileType: 'Folder',
					id: currentNodeName,
					label: currentNodeName,
					leafNode: false,
					objectType: 0,
					path: path
				};

				node.parent = getParentTableNode(path.substring(0, path.lastIndexOf('/')));

				return node;
			};

			//get browse data that is bound to to the ui-grid
			self.getBTableData = function(subItems, item) {
				//setting parent path so that child's path can be formed as parentPath + child's Id
				var parentPath = self.getParentPath(item.path);
				var updatedBTableData = [];

				self.searchNode = {
					currentTablePage: 0,
					entityType: 'sf_root',
					fileType: 'Folder',
					id: cvLoc('label.searchResults'),
					label: cvLoc('label.searchResults'),
					leafNode: false,
					objectType: 0,
					parent: item,
					path: item.path
				};

				//ASCII Control character synchronize (ASCII code 22)
				var synChar = String.fromCharCode(22);
				var negAck = String.fromCharCode(21);
				angular.forEach(subItems, function(bTabledataItem) {
					if (self.searchPerformed) {
						let currentNodePath = bTabledataItem.userObject.path;

						if (currentNodePath !== undefined) {
							bTabledataItem['parent'] = getParentTableNode(
								currentNodePath.substring(0, currentNodePath.lastIndexOf('/'))
							);
						}

						bTabledataItem['currentTablePage'] = 0;
						bTabledataItem['path'] = bTabledataItem.userObject.path;
					} else {
						bTabledataItem['currentTablePage'] = 0;
						bTabledataItem['parent'] = item;
						bTabledataItem['path'] = parentPath + bTabledataItem.id;
					}
					//data received from backend has backslash (separator withing path) replaced with ASCII Control character synchronize (ASCII code 22)
					//Hence converting it back to backslash so that UI has right label
					//bTabledataItem['label'] = bTabledataItem['label'].replace('', '/');

					bTabledataItem['label'] = bTabledataItem['label'].replace(new RegExp(synChar, 'g'), '/');
					bTabledataItem['label'] = bTabledataItem['label'].replace(new RegExp(negAck, 'g'), '\\');
					//we need to know the item in left nav is root or a mailbox or a folder within a mailbox.
					//Because based on the type contents and format of right panel is determined.
					//Hence finding the type and assigning it as a property to the left nav item
					//entityTYpe is used when browsing an item. Leaf items are not browsed so we dont need to set entity type for leaf items
					if (!bTabledataItem.leafNode) {
						bTabledataItem['entityType'] = self.getItemType(bTabledataItem);
					}

					//A folder can have folders and mails within it. IN the right panel only Mails should be displayed
					//hence for Mailbox_Folder entity type, only leafnode items are pushed
					//Need to check if an option can be sent in browse request itself so atht browse response has only leafnode as true items
					if (item.entityType === CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX_FOLDER) {
						if (bTabledataItem.leafNode) {
							updatedBTableData.push(bTabledataItem);
						}
					} else {
						updatedBTableData.push(bTabledataItem);
					}
				});
				return updatedBTableData;
			};

			//load left side nav browse tree
			self.loadTree = function(item) {
				if (self.hideTree()) {
					self.treeLoaded = true;
					self.hideLoading = self.treeLoaded && self.tableLoaded;
					return;
				}
				//if the item, for that page, was loaded before, simply expand it. no need for server call.
				if (item && item.treeLoaded && item.treeLoaded[item.currentTreePage]) {
					//for UI
					item.state = 'expanded';
				} else {
					//for loader
					self.treeLoaded = false;
					self.hideLoading = self.treeLoaded && self.tableLoaded;
					self.treeMessage = cvUtil.emptyMsg();

					var bOptions = self.getBrowseRequestOptions(item, true);

					//get browse Data
					idaService.getIdaBrowseData(self.browseModel.entityId, self.entityType, bOptions).then(
						function(data) {
							var subItems = data.browseData;

							//update children property of item. children array populates the drilled down items in left nav
							var children = self.getBTreeChildren(subItems, item);

							//When Load More is clicked, items, already loaded items should be retained.
							if (item.partiallyLoaded) {
								item.children = item.children.concat(children);
							} else {
								item.children = children;
							}

							//update partiallyLoaded property of item
							var itemsRecieved = subItems.length;
							if (item.itemsRecieved) {
								item.itemsRecieved = item.itemsRecieved + subItems.length;
							} else {
								item.itemsRecieved = subItems.length;
							}

							//Do we have still more items that are not loaded yet? In that case set item.partiallyLoaded to true
							if (data.totalItems > item.itemsRecieved && item.children && item.children.length > 0) {
								item.partiallyLoaded = true;
							} else {
								item.partiallyLoaded = false;
							}

							//update treeLoaded property of item. If an item is collapsed and then expanded this property is true so new api call will not be made.
							if (!item.treeLoaded) {
								item.treeLoaded = new Object();
							}
							item.treeLoaded[item.currentTreePage] = true;

							//for UI
							item.state = 'expanded';

							//for loader
							self.treeLoaded = true;
							self.hideLoading = self.treeLoaded && self.tableLoaded;

							// on successful update of table data we need to update the advanced search options
							self.setAdvancedSearchBoxOptions();
						},
						function(errorMessage) {
							//for loader
							self.treeLoaded = true;
							self.hideLoading = self.treeLoaded && self.tableLoaded;

							$log.error(errorMessage);
							self.treeMessage = cvUtil.errMsg(errorMessage);
						}
					);
				}
			};

			//load the uiGrid browse table
			self.loadTable = function(item) {
				//Dont load table if only tree is required or if required input is not selected yet (e.g. Salesforce Record level restore)
				if (
					self.bTreeOnly === true ||
					((self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) && !self.browseModel.salesforceTable)
				) {
					self.tableLoaded = true;
					self.hideLoading = self.treeLoaded && self.tableLoaded;
					return;
				}

				//for loader
				self.tableLoaded = false;
				self.hideLoading = self.treeLoaded && self.tableLoaded;

				//if item was loaded before, dont make server call instead use Pagedata.
				//If pageSize is modified or sort is performed even once, dont read from PageData. Just make server call and get the right data
				if (
					item &&
					item.pageData &&
					item.pageData[item.currentTablePage] &&
					!self.pageSizeModified &&
					!self.sortingInfoModified &&
					!self.filterInfoModified
				) {
					$scope.browseData = item.pageData[item.currentTablePage];
					self.gridOptions.totalItems = item.totalItems; //gridoptions.totalItems is required to be set manually for server side pagination
					self.updateBrowseBreadcrumbs(item);
					//for loader
					self.tableLoaded = true;
					self.hideLoading = self.treeLoaded && self.tableLoaded;
				} else {
					//server call

					self.tableMessage = cvUtil.emptyMsg();

					var bOptions = self.getBrowseRequestOptions(item, false);

					//get browse Data
					idaService.getIdaBrowseData(self.browseModel.entityId, self.entityType, bOptions).then(
						function(data) {
							var subItems = data.browseData;

							if (!item.pageData) {
								item.pageData = new Object();
							}
							item.pageData[item.currentTablePage] = self.getBTableData(subItems, item);
							item.totalItems = data.totalItems;
							if (self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) {
								self.salesforceColumns = data.columns;
								//For Salesforce record restore, column defs are dynamically loaded
								self.setColumnDefs();
							}

							$scope.browseData = item.pageData[item.currentTablePage];
							self.gridOptions.totalItems = data.totalItems; //gridoptions.totalItems is required to be set manually for server side pagination

							if (self.searchPerformed) {
								self.updateBrowseBreadcrumbs(self.searchNode);
							} else {
								self.updateBrowseBreadcrumbs(item);
							}

							//for loader
							self.tableLoaded = true;
							self.hideLoading = self.treeLoaded && self.tableLoaded;

							// on successful update of table data we need to update the advanced search options
							self.setAdvancedSearchBoxOptions();
						},
						function(errorMessage) {
							//when browseData = false, cv-grid will have issues later
							if (!self.useCVGrid()) {
								$scope.browseData = false;
							}

							//for loader
							self.tableLoaded = true;
							self.hideLoading = self.treeLoaded && self.tableLoaded;

							$log.error(errorMessage);
							self.tableMessage = cvUtil.errMsg(errorMessage);
						}
					);
					self.updateTimeRangeLabel();
				}
			};
			self.getUnixTime = function(utcDateTime) {
				if (utcDateTime == null) {
					return null;
				}
				if (self.browseModel.skipCvUtcConversion) {
					return new Date(utcDateTime).getTime() / 1000;
				}
				var dateTime = $filter('date')(utcDateTime, 'yyyy-MM-dd HH:mm:ss');
				return new Date(dateTime + ' UTC').getTime() / 1000;
			};
			//when one or more items are selected in the grid, restore button is enabled. Below func is called to bring up the modal popup on click of restore
			self.doShowRestoreDialog = function() {
				var params = {
					entity: self.entity,
					entityType: self.entityType,
					selectedRows: self.selectedRows,
					//cloudAppType has to be passed to showRestoreOptions() because based on cloudAppType the jsp for popup and its controller is defined.
					cloudAppType: self.browseModel.cloudAppType,
					toTime: self.browseModel.timerangeBrowseOptions.toTime
						? self.getUnixTime(self.browseModel.timerangeBrowseOptions.toTime)
						: null,
					fromTime: self.browseModel.timerangeBrowseOptions.fromTime
						? self.getUnixTime(self.browseModel.timerangeBrowseOptions.fromTime)
						: null,
					browseType: self.browseModel.browseType,
					noImage: self.browseModel.showDeletedFilesValue,
					includeMetaData: self.browseModel.includeMetadataValue,
					table: self.browseModel.salesforceTable ? self.browseModel.salesforceTable.id : undefined
				};
				idasFactory.showRestoreOptions(params);
			};

			self.isCompareAllowed = function() {
				if (self.isSalesforce()) {
					//For SP11 limit selected rows to 15 so request url is not exceding max length,
					//For SP12, POST api will be ready, and the limitation can be removed
					if (self.selectedRows && self.selectedRows.length > 0 && self.selectedRows.length <= 15) {
						if (self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA) {
							var leaves = self.selectedRows.filter(function(row) {
								return row.leafNode;
							});
							return self.selectedRows.length == leaves.length;
						} else {
							return true;
						}
					}
				}
				return false;
			};

			self.doShowCompareDialog = function() {
				if (self.isSalesforce()) {
					var objects = [];
					self.selectedRows.forEach(function(row) {
						if (self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA) {
							objects.push(row.path);
						} else {
							objects.push(row.id);
						}
					});
					var params = {
						selectedRows: objects,
						sourceDate: self.browseModel.timerangeBrowseOptions.toTime
							? self.browseModel.timerangeBrowseOptions.toTime
							: null,
						entity: self.entity,
						browseType: self.browseModel.browseType
					};
					cappsUtil.showCompareOptionsSF(params);
				}
			};
			self.addParentBreadcrumb = function(item, breadcrumbModel) {
				if (item.parent != null) {
					self.addParentBreadcrumb(item.parent, breadcrumbModel);
				}

				breadcrumbModel.push({
					display: item.label,
					node: item,
					browseEntity: self.breadcrumbItemSelected
				});
			};

			self.updateBrowseBreadcrumbs = function(item) {
				if (self.cvGridOptions && self.cvGridOptions.cvBreadcrumbs) {
					self.cvGridOptions.cvBreadcrumbs.model = [];
					self.addParentBreadcrumb(item, self.cvGridOptions.cvBreadcrumbs.model);
				}
			};

			self.loadMore = function(item) {
				item.currentTreePage = item.currentTreePage + 1;
				self.loadTree(item);
			};

			self.treeItemSelected = function(item) {
				self.clearItemSelection();
				self.selectedItem = item;
				self.setColumnDefs();

				item.currentTablePage = 0;
				if ($scope.gridApi.pagination.getPage() > 1) {
					$scope.gridApi.pagination.seek(1);
				}
				self.loadTable(item);

				self.treeItemToggle(item, true);
			};
			self.breadcrumbItemSelected = function(item) {
				self.clearItemSelection();
				self.selectedItem = item;
				self.setColumnDefs();

				item.currentTablePage = 0;
				if ($scope.gridApi.pagination.getPage() > 1) {
					$scope.gridApi.pagination.seek(1);
				}
				self.loadTable(item);
			};
			self.tableItemSelected = function(item) {
				self.clearMultiSortInfo();
				self.clearFilterInfo();
				self.clearItemSelection();
				self.selectedItem = item;
				if (self.isSalesforceRecordRestore() || self.isSalesforceSandboxSeeding()) {
					self.salesforceColumnLoaded = false;
					self.salesforceColumns = undefined;
				} else {
					//No need to set column defs because Salesforce record restore column comes from backend,
					//There is no column info before loading
					self.setColumnDefs();
				}

				item.currentTablePage = 0;
				//gridApi might not have been initiated for some applications, etc. Salesforce record restore
				if ($scope.gridApi && $scope.gridApi.pagination.getPage() > 1) {
					$scope.gridApi.pagination.seek(1);
				}
				self.loadTable(item);
			};

			self.treeItemToggle = function(item, alwaysExpand) {
				if (item.state == 'expanded' && !alwaysExpand) {
					item.state = 'collapsed';
				} else {
					if (!item.currentTreePage) {
						item.currentTreePage = 0;
					}

					self.loadTree(item);
				}
			};

			self.getGmailItemType = function(item) {
				var itemType;
				if (!item.userObject) {
					itemType = CAPPS_CONSTANTS.MAILBOX_NODE.ROOT;
				} else if (
					item.userObject.advancedData.browseMetaData.cloudconnectorData &&
					item.userObject.advancedData.browseMetaData.cloudconnectorData.googleData &&
					item.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailFolderMetadata &&
					item.userObject.advancedData.browseMetaData.cloudconnectorData.googleData.mailFolderMetadata
						.mailboxDisplayName
				) {
					itemType = CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX;
				} else {
					itemType = CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX_FOLDER;
				}
				return itemType;
			};

			self.getLevel = function(item) {
				const nLevel = item.path.split(self.getFileSeparater(self.clientProps.osType)).filter(a => a.length !== 0)
					.length;
				return nLevel;
			};

			//for different Salesforce item types, the browse table will have diferent columns.
			self.getSalesforceItemType = function(item) {
				var itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT;
				if (!item.userObject) {
					itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT;
				} else {
					var path = item.userObject.path;
					if (path == '/') {
						itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.ROOT;
					} else if (path == '/Files') {
						itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW;
					} else if (path == '/Objects') {
						itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.OBJECT_VIEW;
					} else if (path == '/Metadata') {
						itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW;
					} else if (path.indexOf('/Files/') == 0) {
						itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER;
					} else if (path.indexOf('/Metadata/') == 0) {
						var nLevel = path.split('/').length;
						if (nLevel == 3) {
							itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW_PACKAGE;
						} else if (nLevel == 4) {
							itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW_TYPE;
						} else {
							itemType = CAPPS_CONSTANTS.SALESFORCE_NODE.METADATA_VIEW_FOLDER;
						}
					}
				}
				return itemType;
			};

			self.getItemType = function(item) {
				var itemType = BROWSE_NODE_TYPE.FOLDER;

				switch (parseInt(self.browseModel.applicationId)) {
					case AppTypes.CLOUD_APPS:
						switch (parseInt(self.browseModel.cloudAppType)) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value:
								itemType = self.getGmailItemType(item);
								break;
							//case for salesforce or gdrive, if required
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value:
								itemType = self.getSalesforceItemType(item);
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value:
								itemType = self.getLevel(item);
						}
						break;
					//case for another agent
				}
				return itemType;
			};

			// Advanced browse options (show deleted files / show deleted items / show deleted objects/files)

			self.toggleShowDeletedFiles = function(value) {
				self.browseModel.showDeletedFilesValue = value;
				self.reload();
			};

			self.showDeletedFilesLabel = function() {
				if (self.browseModel.showDeletedFilesValue) {
					return self.browseModel.showDeletedFilesLabels.trueSelectedLabel;
				} else {
					return self.browseModel.showDeletedFilesLabels.falseSelectedLabel;
				}
			};

			// Advanced browse option (include metadata / show trouble shooting folders / show all metadata)

			self.toggleIncludeMetadata = function(value) {
				self.browseModel.includeMetadataValue = value;
				self.reload();
			};

			self.includeMetadataLabel = function() {
				if (self.browseModel.includeMetadataValue) {
					return self.browseModel.includeMetadataLabels.trueSelectedLabel;
				} else {
					return self.browseModel.includeMetadataLabels.falseSelectedLabel;
				}
			};

			//Set query option and reload
			self.toggleQueryOptions = function(queryOptionsValue) {
				self.browseModel.queryOptionsValue = queryOptionsValue;
				self.reload();
			};

			//Show label for current query option value
			self.queryOptionsLabel = function() {
				return self.browseModel.queryOptionsLabels[self.browseModel.queryOptionsValue];
			};

			//Pop up a dialog to enter where condition if it is set action, reload when closing dialog
			//Clear where conditon and reload directly if it is clear atcion
			self.toggleWhereCondition = function(isSetAction) {
				if (isSetAction) {
					//Pop up dialog and reload when ok clicked
					var modalInstance = cappsUtil.openWhereConditionModalSF(self.browseModel.whereConditionValue);
					modalInstance.result.then(function(result) {
						self.browseModel.whereConditionValue = result;
						self.reload();
					});
				} else {
					//Clear value and reload
					self.browseModel.whereConditionValue = undefined;
					self.reload();
				}
			};

			//Show label to indicate weather where condition is set currently
			self.whereConditionLabel = function() {
				var isConditionSet = !!self.browseModel.whereConditionValue;
				return self.browseModel.whereConditionLabels[isConditionSet.toString().toUpperCase()];
			};

			self.getNavBreadCrumbsCapps = function(urlText, label) {
				var breadCrumbs = [];
				var appsNode = {
					title: cvLoc('label.accounts'),
					link: '#/gsuiteApps'
				};

				var clientNode = {
					title: self.entity.clientName,
					link: `#/${urlText}/${self.entity.clientName}/${self.entity.clientId}/content`
				};

				breadCrumbs.push(appsNode);
				breadCrumbs.push(clientNode);

				return breadCrumbs;
			};

			self.getOneDriveNavBreadCrumbs = function() {
				const subclientId = _.get(self, 'entity.subclientId', 0);
				const backupsetId = _.get(self, 'entity.backupsetId', 0);
				const breadCrumbs = [
					{
						title: cvLoc('label.office365.root'),
						link: '#/office365V2'
					},
					{
						title: self.entity.clientName,
						link: `#/office365/clientDetails/${self.entity.clientName}/${self.entity.clientId}/${subclientId}/content?backupsetId=${backupsetId}`
					}
				];
				return breadCrumbs;
			};

			self.setupNavBreadcrumbs = function() {
				if (self.bTreeOnly === true) {
					return;
				}
				var breadCrumbSet = false;
				cvBreadcrumbsTabsFactory.clearBc();
				var breadCrumbs = [];
				switch (parseInt(self.browseModel.applicationId)) {
					case AppTypes.CLOUD_APPS:
						switch (parseInt(self.browseModel.cloudAppType)) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value:
								breadCrumbs = self.getOneDriveNavBreadCrumbs();
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value:
								breadCrumbs = self.getNavBreadCrumbsCapps(CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.urlText);
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value:
								breadCrumbs = self.getNavBreadCrumbsCapps(CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.urlText);
								break;
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value:
								breadCrumbs = cappsUtil.setBreadCrumbsSF(self.entity);
								breadCrumbSet = true;
								break;
							default:
								cappsUtil.setBreadCrumbs(self.entity);
								breadCrumbSet = true;
						}
						break;
				}
				if (!breadCrumbSet) {
					cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
				}
			};

			// Export the selected records to a csv file
			self.doExport = function() {
				return salesforceFactory.exportGridDataToCsv(
					self.gridOptions.columnDefs,
					self.selectedRows,
					_.get(self, 'browseModel.salesforceTable.label', '')
				);
			};

			// Show download option only for salesforce files & metadata views
			self.showDownloadOption = function() {
				return (
					!self.browseModel.isCompare &&
					!self.isSalesforceRecordRestore() &&
					(self.browseModel.browseType == CAPPS_CONSTANTS.BROWSE_TYPE.METADATA ||
						(self.selectedItem &&
							(self.selectedItem.entityType == CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW ||
								self.selectedItem.entityType == CAPPS_CONSTANTS.SALESFORCE_NODE.FILE_VIEW_FOLDER)))
				);
			};

			/*
			 * Checks whether the specified item, or the current selections if no object is passed in, is
			 * larger than the maximum allowed download size.
			 */
			var isTooLargeForDownload = function(selectionInfo) {
				var selectionSize = selectionInfo.totalSize;
				if (selectionSize === null) {
					return true; // unknown size--assume it's too big
				}
				return selectionSize > downloadSizeLimitMB * 1024 * 1024;
			};

			var showDownloadSizeLimitErrorMessage = function() {
				var sizeLimitBytes = downloadSizeLimitMB * 1024 * 1024;
				var sizeLimitString = formatSize(sizeLimitBytes);

				if (!self.browseOptions.disableRestore) {
					self.doShowRestoreDialog();
					showErrorMessage(cvLoc('error.downloadSizeExceeded', sizeLimitString));
				} else {
					showErrorMessage(cvLoc('error.downloadSizeExceededNoRestore', sizeLimitString));
				}
			};

			var getSelectionInfo = function() {
				var data = {
					itemCount: self.selectedRows.length,
					folderCount: 0,
					totalSize: 0
				};
				angular.forEach(self.selectedRows, function(item) {
					if (item.fileType == 'Folder') {
						data.folderCount++;
					}
					data.totalSize += item.userObject.size;
				});
				return data;
			};

			/*
			 * Checks whether the specified item (or the current selected item if no value is passed in) is
			 * too large to be downloaded using a recall. The caller may choose to fall back to a standard
			 * download.
			 */
			var isTooLargeForRecall = function(size) {
				if (typeof size === 'undefined' || size === null) {
					return true; // unknown size--assume it's too big
				}
				// Compare item size to the recall download size limit, if set
				if (recallDownloadSizeLimitMB !== 0 && size > recallDownloadSizeLimitMB * 1024 * 1024) {
					return true;
				}
				return false;
			};

			/**
			 * perform download of selected file/folder
			 */
			self.doDownload = function() {
				var selectedPaths = [];
				angular.forEach(self.selectedRows, function(item) {
					selectedPaths.push(item.userObject);
				});
				var selectionInfo = getSelectionInfo();
				if (isTooLargeForDownload(selectionInfo)) {
					showDownloadSizeLimitErrorMessage();
					return;
				}

				let appType = $stateParams['applicationId'];

				if (
					selectedPaths.length == 1 &&
					self.selectedRows[0].fileType != 'Folder' &&
					!isTooLargeForRecall(selectedPaths[0].size)
				) {
					var selectedFile = selectedPaths[0];
					var downloadSingleFileObj = {
						CommcellNumber: selectedFile.advancedData.advConfig.browseAdvancedConfigResp.commcellNumber,
						ApplicationId: selectedFile.advancedData.subclient.applicationId,
						FilePath: selectedFile.path,
						FileName: _.get(
							selectedFile,
							'advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName',
							selectedFile.name
						),
						isVersionItem: selectedFile.version > 0 ? true : false,
						version: selectedFile.version,
						AchiveFileId: selectedFile.advancedData.archiveFileId,
						ArchiveFileOffset: selectedFile.advancedData.offset,
						AppType: appType,
						CVTurboGUID: selectedFile.advancedData.browseMetaData.dmStubData.guid
					};
					downloadsFactory.processDownloadRequest(downloadSingleFileObj);
				} else {
					console.debug('Selections do not qualify for recall download--falling back to standard download');
					var downloadParam = {
						dataResultSet: selectedPaths,
						clientId: _.get(self, 'entity.clientId'),
						clientName: _.get(self, 'entity.clientName'),
						backupsetId: _.get(self, 'entity.backupsetId'),
						fromTime: _.get(self, 'browseModel.timerangeBrowseOptions.fromTime'),
						toTime: _.get(self, 'browseModel.timerangeBrowseOptions.toTime'),
						copyPrecedence: 0, // default
						appType: appType,
						downloadDeletedFiles: self.browseModel.showDeletedFilesValue
					};
					downloadsFactory.initiateDownload(downloadParam);
				}
			};

			//this is used in partial to show or not show external sort for mails only
			self.node_mail_folder = CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX_FOLDER;

			//this is used in partial to show Mailbox icon in browse tree for items taht are of type mailbox
			self.node_mailbox = CAPPS_CONSTANTS.MAILBOX_NODE.MAILBOX;

			if (self.validateModel()) {
				self.populateAgentSpecificBrowseOptions();
				self.initializeAndSetDefaults();
				self.setGridOptions();

				if (self.isSalesforceRecordRestore()) {
					//Table is an input for record level browse, get tables before browse
					cappsClientService.getSalesforceTables(self.browseModel.entityId).then(
						function(data) {
							self.browseModel.salesforceTables = data.browseData;
							//Select the default table if it's present
							self.browseModel.salesforceTables.forEach(function(salesforceTable) {
								if (salesforceTable.id == CAPPS_CONSTANTS.SALESFORCE_DEFAULT_TABLE) {
									self.browseModel.salesforceTable = salesforceTable;
								}
							});
							self.load();
						},
						function(e) {
							self.pageMessage = cvUtil.errMsg(e);
						}
					);
				} else {
					//For normal case, load directly
					self.load();
				}
			}
		};
	}
];
allAgentMod.controller(controllers);

//From xml tag is returned in format <from name>|<from email address>
//we need to show only from name in the right panel
//Below func gets from name
allAgentMod.filter('getGmailFrom', function() {
	return function(input) {
		if (input) {
			var result = input.split('|');
			if (result && result.length > 0) {
				return result[0];
			}
		}
		return '';
	};
});

export default allAgentMod;
