import 'adminConsole/js/directives/acDirectives.js';
import 'adminConsole/js/services/clientGroups.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'dbs/js/services/server.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'modules/ida/js/controllers/sqlAgent.ctrl.js';
import 'modules/ida/js/services/appMigration.svc.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/ida/js/directives/cv-copy-precedence.js';
import 'modules/ida/js/directives/cv-storage-config.js';
import 'modules/genApp/js/directives/cv-compute-node.js';
import 'modules/genApp/js/directives/cv-firewall-options.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';
import { commonAppMigrationModule } from 'common/js/modules';

var appMigration = commonAppMigrationModule;

/*************************************************************************************************************
 * This controller is based on appMigrationCtrl, with code added to handle modal instead of whole page.
 */
appMigration.controller('appMigrationModalCtrl', [
	'dbServerService',
	'data',
	'$uibModalInstance',
	'$scope',
	'cvToaster',
	'$log',
	'idaService',
	'sqlService',
	'$dialogs',
	'appMigrationService',
	'profileService',
	'$state',
	'cvLoc',
	'$timeout',
	'cvUtil',
	'cvTableOptions',
	'clientGroupService',
	'serverService',
	'replicationFactory',
	'VM_POLICY_APP_TYPE',
	'VSA_VENDOR',
	function(
		dbServerService,
		data,
		$uibModalInstance,
		$scope,
		cvToaster,
		$log,
		idaService,
		sqlService,
		$dialogs,
		appMigrationService,
		profileService,
		$state,
		cvLoc,
		$timeout,
		cvUtil,
		cvTableOptions,
		clientGroupService,
		serverService,
		replicationFactory,
		VM_POLICY_APP_TYPE,
		VSA_VENDOR
	) {
		var self = this;
		$scope.instanceId = data.entity.instanceId;
		$scope.applicationId = data.entity.applicationId;
		$scope.entity = null;
		$scope.isCrossPlatfrom = false;
		$scope.isOracleCloudPolicy = false;
		$scope.hideFirewallConnection = [];
		self.password = '';
		$scope.appMigrate = {
			destInstanceName: '',
			cloudType: 'AMAZON',
			policyId: 0,
			oracleHomePath: 0,
			createNewMachine: false,
			srcInst: {},
			stagingPath: '',
			validationScript: '',
			cloudAllocationPolicy: {},
			machineConfig: {
				vmTemplate: {},
				vmInstType: {},
				storageVol_list: {},
				vmUser: {
					userName: '',
					password: null
				},
				advVMProperties: {
					networkCards: null
				}
			},
			targetCloudMachine: {},
			softwareConfig: {
				softwareInstallDir: '',
				softConfigType: 0
			},
			osCredentials: {
				user: {}
			}
		};

		$scope.tileState = {
			dataConfigState: true,
			backupConfigState: false
		};
		$scope.restoreOptions = {
			copyPrecedence: 0,
			disableMaxNoOfStreams: false,
			commonOptions: {
				baselineBackup: 0,
				syncRestore: true
			},
			oracleOpt: {
				restoreStream: 2,
				ctrlFileBackupType: 0,
				cloneEnv: false,
				ctrlRestoreFrom: true,
				partialRestore: false,
				recoverFrom: 3,
				restoreControlFile: true,
				noCatalog: true,
				liveSyncOpt: {
					restoreInStandby: false
				}
			},
			sqlServerRstOption: {
				restoreSource: null,
				database: null,
				sqlRecoverType: 0
			},
			destination: {
				destinationInstance: {
					instanceName: null
				}
			}
		};
		$scope.pattern = {
			freq_type: 1
		};
		$scope.validationErrors = {};
		$scope.errors = {};
		$scope.showAddReplicationTargetButton = false;
		var hasAzureHypervisors = function() {
			serverService
				.getServersByVendor('AZURE_V2')
				.success(function(data) {
					if (data.length) {
						$scope.showAddReplicationTargetButton = true;
					}
				})
				.error(function(err) {
					$log.error(err);
				});
		};
		var setPostMigrationScriptFormat = function() {
			// Selecting post migration script should be based on the OS type of the recovery target template
			//using if else temporarily

			if ($scope.isAzureCloud) {
				if ($scope.isSqlMigration) {
					$scope.postMigrationScriptFormats = ['bat'];
				} else {
					$scope.postMigrationScriptFormats = ['sh'];
				}
			} else {
				$scope.postMigrationScriptFormats = null;
			}
		};
		var generalPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationGeneralPage.jsp',
			name: cvLoc('label.appInfo')
		};

		var configPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationConfigPage.jsp',
			name: cvLoc('label.machineConfig')
		};
		var swPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationSoftwareConfiPage.jsp',
			name: cvLoc('label.swConfig')
		};

		var fConfigPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationFirewallOptionsPage.jsp',
			name: cvLoc('label.firewallConfg')
		};

		var restorePage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationRestoreOptionsPage.jsp',
			name: cvLoc('label.migrationOpt')
		};

		$scope.documentationUrl =
			$scope.applicationId == 81
				? 'https://documentation.commvault.com/commvault/v11/article?p=18283.htm'
				: 'https://documentation.commvault.com/commvault/v11/article?p=87345.htm';
		$scope.helpTextTemplate =
			'<span class="font-primary-color font-size-16">' +
			cvLoc('info.databaseMigrationHelpText', '<a href="' + $scope.documentationUrl + '" target="_blank" >', '</a>') +
			'</span>';

		var steps = [];
		steps.push(generalPage);
		$scope.isSqlMigration = false;
		if ($scope.applicationId == 81) {
			$scope.isSqlMigration = true;
			$scope.hideFirewallConnection.push(0);
			var contentPage = {
				completed: false,
				template: appUtil.appRoot + 'modules/ida/partials/appMigrationContentPage.jsp',
				name: cvLoc('label.contentSelt')
			};
			steps.push(contentPage);
			steps.push(configPage);
		} else {
			steps.push(configPage);
			steps.push(swPage);
		}
		steps.push(fConfigPage);
		steps.push(restorePage);

		$scope.steps = steps;

		$scope.getCurrentStep = function() {
			return $scope.step;
		};

		$scope.step = 0;

		$scope.title = cvLoc('pageHeader.migrateToCloud');

		var cloudTypes = [];
		cloudTypes.push({
			name: cvLoc('label.amazon'),
			cloudId: 'AMAZON'
		});
		//		cloudTypes.push({
		//			name: cvLoc('label.oralceCloud'),
		//			cloudId: 'ORACLE_CLOUD'
		//		});

		if ($scope.applicationId == 22) {
			cloudTypes.push({
				name: cvLoc('label.oralceDbaas'),
				cloudId: 'ORACLE_AS_SERVICE'
			});
			cloudTypes.push({
				name: cvLoc('label.oracleCI'),
				cloudId: 'ORACLE_CLOUD_INFRASTRUCTURE'
			});
			cloudTypes.push({
				name: cvLoc('label.azure'),
				cloudId: 'AZURE_RESOURCE_MANAGER'
			});
		}

		if ($scope.applicationId == 81) {
			cloudTypes.push({
				name: cvLoc('label.oracleCI'),
				cloudId: 'ORACLE_CLOUD_INFRASTRUCTURE'
			});
			cloudTypes.push({
				name: cvLoc('label.azure'),
				cloudId: 'AZURE_RESOURCE_MANAGER'
			});
		}

		$scope.cloudTypes = cloudTypes;

		var removeCloudType = function(cloudId) {
			var removeIndex = -1;
			for (var int = 0; int < $scope.cloudTypes.length; int++) {
				if ($scope.cloudTypes[int].cloudId == cloudId) {
					removeIndex = int;
				}
			}
			if (removeIndex >= 0) {
				$scope.cloudTypes.splice(removeIndex, 1);
			}
		};

		var createTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];
			columnDefs.push({
				field: 'mntPoint',
				displayName: cvLoc('label.mountPoints'),
				cellTemplate: '<span class="crop" >{{row.entity.mntPoint.mountPathName}}</span>',
				enableHiding: false,
				cellTooltip: true,
				width: '20%'
			});
			columnDefs.push({
				field: 'volumeSize',
				displayName: cvLoc('label.sizeGB'),
				cellTemplate: '<span class="crop">{{row.entity.volumeSize | volumeSize}}</span>',
				width: '15%'
			});

			if (!$scope.isOracleCloudPolicy) {
				columnDefs.push({
					field: 'clientName',
					displayName: cvLoc('label.volumeType'),
					cellTemplate: '<span class="crop" >{{row.entity.amazonVolConfig.volumeType | volumeType}}</span>',
					width: '20%'
				});
				columnDefs.push({
					field: 'amazonVolConfig.iopsLimit',
					displayName: cvLoc('label.iopsLimit'),
					cellTemplate: '<span class="crop" >{{row.entity.amazonVolConfig.iopsLimit}}</span>',
					width: '15%'
				});
			}
			columnDefs.push({
				field: 'volumeTag',
				displayName: cvLoc('label.description'),
				cellTemplate: '<span title="{{row.entity.volumeTag}}" class="crop" >{{row.entity.volumeTag}}</span>',
				width: '20%'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="Edit volume"  class="edit-volume" data-ng-click="grid.appScope.editVolume(row.entity)" >&nbsp;<//span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span title="Delete volume"  class="delete-row" data-ng-click="grid.appScope.deleteVolume(row.entity)" > � </span>',
				width: '5%'
			});

			angular.extend(globalGridOptions, {
				data: 'storageDetails',
				columnDefs: columnDefs
			});

			$scope.gridOptions = globalGridOptions;
		};

		$scope.deleteVolume = function(volumeObj) {
			var volumeName = volumeObj.mntPoint.mountPathName;
			for (var i = 0; i < $scope.storageDetails.length; i++) {
				if ($scope.storageDetails[i].mntPoint.mountPathName == volumeName) {
					$scope.storageDetails.splice(i, 1);
					return;
				}
			}
		};

		$scope.editVolume = function(volumeObj) {
			$scope.addVolume(volumeObj);
		};

		$scope.addStorage = function() {
			$scope.addVolume(null);
		};
		$scope.addVolume = function(volumeObj) {
			var templateUrl = 'modules/ida/partials/appMigrationAddStorage.jsp';
			var controller = [
				'$scope',
				'cvUtil',
				'$rootScope',
				'data',
				'$uibModalInstance',
				function($scope, cvUtil, $rootScope, data, $modalInstance) {
					if (!data) {
						$scope.isEditing = false;
						$scope.storage = {
							mntPoint: {
								mountPathName: ''
							},
							volumeSize: 10,
							amazonVolConfig: {
								volumeType: 0,
								iopsLimit: 100
							}
						};
					} else {
						$scope.isEditing = true;
						$scope.storage = angular.copy(data);
					}
					$scope.volumeTypes = [
						{
							name: cvLoc('label.standard'),
							volumeId: 0
						},
						{
							name: cvLoc('label.provsIOPS'),
							volumeId: 1
						}
					];

					$scope.closeModal = function() {
						$modalInstance.close(null);
					};
					$scope.saveModle = function() {
						$modalInstance.close($scope.storage);
					};
				}
			];
			var opts = new Object();

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, volumeObj, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					//In Edit case volumeObj will not be null, so remove it and add new one.
					if (volumeObj) {
						$scope.deleteVolume(volumeObj);
					}
					$scope.storageDetails.push(dataObject);
				}
			});
		};
		$scope.getDestOsType = function() {
			var appId = $scope.applicationId;
			var osType = '';
			if (appId == 22 || appId == 134) {
				osType = 'Linux';
			} else if (appId == 81) {
				osType = 'Windows';
			}
			return osType;
		};

		$scope.showRedirctPathDialog = function() {
			var templateUrl = 'modules/ida/partials/sqlRedirectPathsModel.jsp';
			var controller = [
				'$scope',
				'cvUtil',
				'$rootScope',
				'$uibModalInstance',
				'data',
				function($scope, cvUtil, $rootScope, $modalInstance, data) {
					$scope.entity = data.entity;
					$scope.databases = data.selectedDBs;

					$scope.cancelModel = function() {
						$modalInstance.close(null);
					};
					$scope.saveModle = function(sqlDbDeviceItemInfo) {
						$modalInstance.close(sqlDbDeviceItemInfo);
					};
				}
			];
			var opts = new Object();
			var dataModel = {
				entity: $scope.entity,
				selectedDBs: $scope.databases
			};
			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataModel, opts);
			modelInsta.result.then(function(sqlDbDeviceItemInfo) {
				if (sqlDbDeviceItemInfo) {
					if ($scope.restoreOptions.sqlServerRstOption) {
						$scope.restoreOptions.sqlServerRstOption.device = sqlDbDeviceItemInfo.device;
						$scope.restoreOptions.sqlServerRstOption.deviceInfo = sqlDbDeviceItemInfo.deviceInfo;
					}
				}
			});
		};

		var createContentTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];

			columnDefs.push({
				field: 'id',
				displayName: cvLoc('label.DatabaseName'),
				cellTemplate: '<div class="crop" title="{{row.entity.databaseName}}">{{row.entity.databaseName}}</div>',
				enableHiding: false,
				cellTooltip: true,
				width: '60%'
			});
			columnDefs.push({
				field: 'userObject.version',
				displayName: cvLoc('label.version') /* cvLoc('label.sizeGB') */,
				cellTemplate: '<div class="crop" title="{{row.entity.version}}">{{row.entity.version}}</div>',
				enableHiding: false,
				width: '15%'
			});

			angular.extend(globalGridOptions, {
				data: 'databases',
				columnDefs: columnDefs,
				paginationPageSize: 5,
				selectionRowHeaderWidth: '10%',
				paginationPageSizes: [5, 10, 20, 50],
				onRegisterApi: function(gridApi) {
					//$scope.gridApi = gridApi;
					gridApi.selection.enableVerticalScrollbar = 0;

					gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
						var isSelectAll = gridApi.selection.getSelectAllState();

						$scope.databases.forEach(function(entity) {
							entity.isSelected = !isSelectAll;
						});
					});

					gridApi.selection.on.rowSelectionChanged($scope, function(row) {
						row.entity.isSelected = row.isSelected;
					});

					gridApi.grid.registerRowsProcessor(function(renderableRows) {
						// default select all the rows
						renderableRows.forEach(function(row, index) {
							row.entity.isSelected = _.isUndefined(row.entity.isSelected) ? true : row.entity.isSelected;
							row.isSelected = _.isUndefined(row.entity.isSelected) ? true : row.entity.isSelected;
						});

						return renderableRows;
					}, 200);
					//					$timeout(function () {
					//						gridApi.selection.selectAllRows();
					//					});
				}
			});

			$scope.gridContentOptions = {
				cvHasTitle: false,
				cvTableName: 'dbContentTable',
				cvSearchFields: ['databaseName', 'version'],
				cvHasViews: false,
				cvGridDirectives: {
					uiGridSelection: true,
					uiGridPagination: true
				},
				cvShowSelectedOption: true,
				cvOnGridEmpty: cvUtil.errMsgLoc('label.noDBBackup'),
				gridOptions: globalGridOptions
			};
		};

		$scope.instanceDetails;

		var getClientDetails = function(clientId) {
			idaService.getClientDetails(clientId).success(function(data) {
				$scope.clientDetails = data;
				$scope.osInfo = data.client.osInfo;
				if ($scope.osInfo.osId == 83) {
					$scope.isCrossPlatfrom = true;
					$scope.appMigrate.softwareConfig.softConfigType = 1;
				} else if ($scope.osInfo.osId == 210) {
					$scope.osInfo.SubType = $scope.osInfo.Type; // For Windows server os SubType is comming as server, updated to Windows
				}

				if ($scope.osInfo.osId == 83 || $scope.osInfo.osId == 47 || $scope.osInfo.osId == 97) {
					removeCloudType('ORACLE_AS_SERVICE');
				}
			});
		};

		self.getSeparator = function() {
			if ($scope.osInfo.Type.toLowerCase() === 'windows') {
				return '\\';
			}

			return '/';
		};

		var getSqlDbRestoreStrings = function(sourceItems) {
			let params = {
				instanceId: $scope.instanceId,
				sourceItems: angular.toJson(sourceItems)
			};

			sqlService.getSQLServerRestoreOptions(params).success(function(sqlRestoreOptions) {
				let seperator = String.fromCharCode(9);
				let seperator12 = String.fromCharCode(0x12);

				let osSeperator = self.getSeparator();
				let destOsSeperator = osSeperator; // windows destination only supported

				self.dbToItemsMap = new Map();

				for (let i = 0; i < sqlRestoreOptions.sqlDbdeviceItem.length; i++) {
					let databaseItem = sqlRestoreOptions.sqlDbdeviceItem[i];

					if (!self.dbToItemsMap.has(databaseItem.sqlDBInfo.databaseId)) {
						let itemNode = {
							deviceInfoStrList: [],
							deviceStrList: []
						};
						self.dbToItemsMap.set(databaseItem.sqlDBInfo.databaseId, itemNode);
					}

					let deviceInfoStr =
						databaseItem.sqlDBInfo.databaseId +
						seperator +
						databaseItem.sqlDBInfo.databaseName + // new database name
						seperator +
						databaseItem.id +
						seperator +
						' ' +
						seperator +
						databaseItem.fileName + // destination machine path
						seperator +
						databaseItem.logicalFileName +
						seperator +
						databaseItem.fileMaxSize +
						seperator +
						databaseItem.sqlDBInfo.databaseName +
						seperator;

					self.dbToItemsMap.get(databaseItem.sqlDBInfo.databaseId).deviceInfoStrList.push(deviceInfoStr);

					let deviceStr =
						databaseItem.sqlDBInfo.databaseName +
						seperator12 +
						databaseItem.sqlDBInfo.databaseName + // new database name
						seperator12 +
						databaseItem.logicalFileName +
						seperator12 +
						databaseItem.fileName + // destination machine path
						seperator12 +
						databaseItem.fileName;

					self.dbToItemsMap.get(databaseItem.sqlDBInfo.databaseId).deviceStrList.push(deviceStr);
				}
			});
		};

		var getDatabases = function(instanceId) {
			var options = new Object();
			idaService.getIdaBrowseData(instanceId, 'INSTANCE_ENTITY', options).then(function(data) {
				if (data && data.browseData) {
					var databases = [];
					let selectedDbsToBrowse = [];
					data.browseData.forEach(function(entity) {
						var dbName = entity.userObject.databaseName;
						//System databases need to filter
						if (!(dbName === 'master' || dbName === 'model' || dbName === 'msdb')) {
							databases.push(entity.userObject);

							selectedDbsToBrowse.push({
								databaseName: dbName
							});
						}
					});
					$scope.databases = databases;
					if ($scope.isSqlMigration) {
						getSqlDbRestoreStrings(selectedDbsToBrowse);
					}
					$scope.getStorageDetails($scope.entity, $scope.databases);
				} else {
					$scope.databases = [];
				}
			});
		};

		var getDefaultSubclientId = function(entity) {
			dbServerService
				.getSubClients(entity.clientId, entity.applicationId, entity.instanceId)
				.success(function(data) {
					data.forEach(subClinetNode => {
						if (subClinetNode.commonProperties.isDefaultSubclient) {
							self.defaultSubclientId = subClinetNode.subClientEntity.subclientId;
						}
					});
				})
				.error(function(e) {
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};
		var getInstanceDetails = function(instanceId) {
			idaService
				.getInstanceDetails(instanceId)
				.success(function(data) {
					if (data) {
						$scope.instanceDetails = data;
						$scope.entity = $scope.instanceDetails.instance;

						$scope.appMigrate.srcInst = $scope.entity;
						getClientDetails($scope.entity.clientId);
						getDefaultSubclientId($scope.entity);
						if ($scope.entity.applicationId == 22 || $scope.entity.applicationId == 81) {
							if (!$scope.isCrossPlatfrom) {
								$scope.appMigrate.softwareConfig.softwareInstallDir = $scope.instanceDetails.oracleInstance.oracleHome;
							}

							if ($scope.instanceDetails.version) {
								var srcVersion = $scope.instanceDetails.version;
								var versionNumber = 0;
								if (srcVersion.startsWith('12.1')) {
									versionNumber = 1;
								} else if (srcVersion.startsWith('12.2')) {
									versionNumber = 2;
								}
								$scope.appMigrate.cloudDBService.oraSoftwareRelease = versionNumber;
								/*
								 * if (srcVersion.startsWith("11.2")) { removeCloudType('ORACLE_AS_SERVICE'); }
								 */
							}
							if ($scope.entity.applicationId == 22) {
								$scope.getStorageDetails($scope.entity, null);
							}
						}
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		getInstanceDetails(parseInt($scope.instanceId));
		getDatabases(parseInt($scope.instanceId));
		if ($scope.isSqlMigration) {
			createContentTable();
		}
		createTable();

		$scope.networkNameSelection = function() {
			if ($scope.appMigrate.machineConfig.advVMProperties.networkCards.length) {
				$scope.subnetList = $scope.appMigrate.machineConfig.advVMProperties.networkCards[0].subnetNames;
				if ($scope.subnetList) {
					$scope.subnetList.forEach(function(subNet) {
						subNet.ticked = false;
					});
					if ($scope.subnetList.length) {
						$scope.subnetList[0].ticked = true;
						if ($scope.appMigrate.machineConfig.advVMProperties.subnetList) {
							$scope.appMigrate.machineConfig.advVMProperties.subnetList = [];
						}
						$scope.appMigrate.machineConfig.advVMProperties.subnetList.push($scope.subnetList[0]);
					}
				}
			} else {
				$scope.subnetList = [];
			}
		};

		var loadAzureInstanceTypes = function(hostname, serverId, serverName) {
			serverService.getAzureVmSizes(serverId, serverName, 'AZURE_V2', hostname).success(function(data) {
				let instanceTypes = [];
				for (let i = 0; i < data.length; i++) {
					instanceTypes.push({
						cpuCores: data[i].numOfCpu,
						cpuUnits: 'N/A',
						memory: data[i].memoryInMB / 1024,
						instanceType: {
							vmInstanceTypeName: data[i].name
						}
					});
				}

				$scope.vmTeplPolicy.amazonPolicy.instanceType = instanceTypes;

				refreshConfig();
			});
		};

		var getPolicyDetails = function(policyId) {
			appMigrationService
				.getPolicyDetails({
					policyId: policyId
				})
				.success(function(data) {
					if (data) {
						$scope.vmTeplPolicy = data;
						self.isInstanceTypeProvided = false;
						if ($scope.vmTeplPolicy.amazonPolicy && $scope.vmTeplPolicy.amazonPolicy.instanceType) {
							$scope.vmTeplPolicy.amazonPolicy.instanceType.forEach(function(e) {
								if ($scope.vmTeplPolicy.amazonPolicy.vmInstanceTypes && $scope.isAzureCloud) {
									e.instanceType = {};
									e.instanceType.vmInstanceTypeName =
										$scope.vmTeplPolicy.amazonPolicy.vmInstanceTypes[0].vmInstanceTypeName;
								}
								if (e.instanceType && e.instanceType.vmInstanceTypeName) {
									e.flatLabel = e.instanceType.vmInstanceTypeName;
									self.isInstanceTypeProvided = true;
								}
								if (e.memory) {
									let value = parseInt(e.memory);
									e.memory = $scope.isAzureCloud ? value / 1024 : value;
								}
							});
						}

						if (!self.isInstanceTypeProvided && $scope.isAzureCloud) {
							loadAzureInstanceTypes(
								$scope.vmTeplPolicy.esxServers[0].esxServerName,
								$scope.vmTeplPolicy.destinationHyperV.clientId,
								$scope.vmTeplPolicy.destinationHyperV.clientName
							);
						}

						$scope.appMigrate.cloudAllocationPolicy = data;
						$scope.migrationType = 'appMigration';
						$scope.configPageEdting = false;
					}
					refreshConfig();
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		function refreshConfig() {
			if ($scope.appMigrate.machineConfig) {
				if ($scope.appMigrate.machineConfig.vmInstType) {
					$scope.appMigrate.machineConfig.vmInstType = undefined;
				}
				if ($scope.appMigrate.machineConfig.vmTemplate) {
					$scope.appMigrate.machineConfig.vmTemplate.vm = undefined;
				}
				if ($scope.appMigrate.machineConfig.storageVol_list) {
					$scope.appMigrate.machineConfig.storageVol_list = angular.copy($scope.storageDetails);
				}
			}
			$scope.refreshConfigValue = !$scope.refreshConfigValue;
		}

		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.networkSettingsList = [];

		var loadNetworkSettings = function(clientId) {
			var dummyHostName = 'dummy';
			var serverDetailsInfo = {
				clientId: clientId,
				serverName: '',
				username: null,
				password: null
			};
			//load network info
			serverService
				.getNetworkInfo(serverDetailsInfo, dummyHostName)
				.success(function(data) {
					$scope.networkSettingsList = data;
					$scope.networkSettingsList.forEach(function(networkSetting) {
						networkSetting.ticked = false;
					});
				})
				.error(function(err) {
					$log.error(err);
				});
		};

		$scope.isNetworkSettingsListAvailable = function() {
			return true;
			/*
			 * if ($scope.appMigrate.machineConfig.advVMProperties.networkCards &&
			 * $scope.appMigrate.machineConfig.advVMProperties.networkCards.length > 0) return true; else
			 * return false;
			 */
		};

		/**
		 * firewall related code Start
		 */
		$scope.appMigrate.firewallConfig = {
			enableFirewallConfig: true,
			firewallConnectionType: 1,
			httpProxyConfigurationType: 0,
			proxyClientName: '',
			portNumber: 443 //8603,
		};
		$scope.proxyClients = null;
		$scope.populatProxyClients = function() {
			var firewallConnectionType = 0;
			if ($scope.isOracleAsService) {
				firewallConnectionType = 1;
			}
			if ($scope.appMigrate.firewallConfig) {
				$scope.appMigrate.firewallConfig.firewallConnectionType = firewallConnectionType;
			}
			if ($scope.proxyClients == null) {
				$scope.updateTunnerlPortSelection(firewallConnectionType);
				// client group id is 0 means all the clients
				clientGroupService
					.getClientsForClientGroup(0)
					.success(function(data) {
						$scope.serverMessage = cvUtil.emptyMsg();
						if (data.length) {
							$scope.proxyClients = data.map(function(obj) {
								return {
									value: obj.client.clientEntity.clientId + '',
									label: obj.client.clientEntity.clientName
								};
							});
							$scope.proxyClients.sort(function(a, b) {
								return (
									+(a.label.toLowerCase() > b.label.toLowerCase()) ||
									+(a.label.toLowerCase() === b.label.toLowerCase()) - 1
								);
							});
						}
					})
					.error(function(data) {
						$scope.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			}
		};

		$scope.updateTunnerlPortSelection = function(connectionType) {
			var labelString = cvLoc('label.noteFirewallConnectionType2');
			var portNumber = 0;
			if (connectionType == 0) {
				labelString = cvLoc('label.noteFirewallConnectionType0');
				portNumber = 8603;
			} else if (connectionType == 1) {
				labelString = cvLoc('label.noteFirewallConnectionType1');
				portNumber = 8403;
			}
			$scope.appMigrate.firewallConfig.portNumber = portNumber;
			$scope.firewallConnetionLabel = labelString;
		};
		/**
		 * firewall related code End
		 */

		/**
		 * Oracle cloud database service related code start
		 */
		$scope.appMigrate.instanceBackupType = 1;
		$scope.resetInstanceBackupType = function() {
			if (!$scope.isOracleAsService) {
				$scope.appMigrate.instanceBackupType = 1;
			}
		};
		$scope.appMigrate.cloudDBService = {
			serviceName: '',
			oraServiceLevel: 1,
			mFrequency: 0,
			oraSoftwareRelease: 0,
			oraSoftwareEdition: 0,
			oraDatabaseType: 0,
			dbConfig: {
				dbSizeGB: 15,
				totalDataStorageGB: 1,
				listenerPort: 1521
			},
			dbBackupConfig: {
				dbBackupDestination: 3,
				createInstanceFromBackup: true,
				cloudStorageContainer: 'https://??.storage.oraclecloud.com/v1/Storage-/??'
			},
			dbRecoveryConfig: {
				onPremisesBackup: true,
				decMethod: 1
			},
			accessRule:
				'{  ' +
				'	"ruleName": "CV-Conn-Rule", ' +
				'	"description": "CV Connection Rule", ' +
				'	"source": "PUBLIC-INTERNET", ' +
				'	"destination": "DB", ' +
				'	"ports": "443", ' +
				'	"status": "enabled" ' +
				'} '

			//Service levels
		};
		$scope.dbBaseServiceLevels = [
			{
				serviceType: 1,
				serviceName: cvLoc('label.oralceDdCloud')
			}
		];

		$scope.meteringFrequencys = [
			{
				meteringType: 0,
				meteringName: 'Monthly'
			},
			{
				meteringType: 1,
				meteringName: 'Hourly'
			}
		];

		$scope.softwareReleases = [
			{
				releaseType: 0,
				releaseName: cvLoc('label.oracleDb11gRel')
			},
			{
				releaseType: 1,
				releaseName: cvLoc('label.oracleDb12cRel1')
			},
			{
				releaseType: 2,
				releaseName: cvLoc('label.oracleDb12cRel2')
			}
		];

		$scope.softwareEditions = [
			{
				editionType: 0,
				editionName: cvLoc('label.standardEdition')
			},
			{
				editionType: 1,
				editionName: cvLoc('label.enterpriseEdition')
			},
			{
				editionType: 2,
				editionName: cvLoc('label.enterpriseEditionExper')
			},
			{
				editionType: 2,
				editionName: cvLoc('label.enterpriseEditionHigper')
			}
		];

		$scope.databseTypes = [
			{
				dbTypeValue: 0,
				dbTypeName: cvLoc('label.singleInst')
				/*
				 * ,{ dbTypeValue : 1, dbTypeName : cvLoc('label.dbClusterWthRac') }
				 */
			}
		];

		$scope.backupTypes = [
			/*
			 * { backupType : 1, backupName : cvLoc('label.bothCloudStorege') },
			 */ {
				backupType: 2,
				backupName: cvLoc('label.cloudStoreOnly')
			},
			{
				backupType: 3,
				backupName: cvLoc('label.none')
			}
		];

		$scope.instanceBackupTypes = [
			{
				instanceBackupType: 1,
				instanceBackupName: cvLoc('label.commvault')
			},
			{
				instanceBackupType: 2,
				instanceBackupName: cvLoc('label.oracleAsCloud')
			}
		];

		/**
		 * Oracle cloud database service related code end
		 */

		$scope.saveContentPage = function() {
			var sourceItems = [];
			$scope.databases.forEach(function(entity) {
				if (entity.isSelected) {
					sourceItems.push(entity);
				}
			});
			$scope.getStorageDetails($scope.entity, sourceItems);
			//$scope.getDiviceList(sourceItems);

			$scope.steps[$scope.step].completed = true;
			$scope.step++;
		};

		$scope.initDataBackupChanged = function(dataBackupFrom) {
			var createInstanceFromBackup = false;
			if (dataBackupFrom && dataBackupFrom === 2) {
				createInstanceFromBackup = true;
			}
			if ($scope.appMigrate.cloudDBService && $scope.appMigrate.cloudDBService.dbRecoveryConfig) {
				$scope.appMigrate.cloudDBService.dbRecoveryConfig.createInstanceFromBackup = createInstanceFromBackup;
			}
		};

		$scope.isValidAdminPassword = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var passwordPatternRegex = /^[A-Za-z](?=.*[0-9])([a-zA-Z0-9#_]){7,29}$/;
				var password = $scope.appMigrate.cloudDBService.dbConfig.dbPasswordValue;
				if (password != undefined && passwordPatternRegex.test(password)) {
					$scope.errors.adminPassword = false;
				} else {
					$scope.errors.adminPassword = true;
					isValid = false;
				}
			}
			return isValid;
		};

		$scope.isValidStorageContainer = function() {
			var isValid = true;
			if ($scope.isOracleAsService && $scope.appMigrate.cloudDBService.dbBackupConfig.dbBackupDestination != 3) {
				if (
					$scope.appMigrate.cloudDBService.dbBackupConfig.cloudStorageContainer ==
					'https://??.storage.oraclecloud.com/v1/Storage-/??'
				) {
					$scope.errors.cloudStorageContainer = true;
					isValid = false;
				} else {
					$scope.errors.cloudStorageContainer = false;
				}
			}
			return isValid;
		};

		$scope.isValidDatabaseName = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				if (!$scope.appMigrate.cloudDBService.dbConfig.dbName) {
					$scope.errors.dbName = true;
					isValid = false;
				} else {
					$scope.errors.dbName = false;
				}
			}
			return isValid;
		};
		$scope.isValidDBSize = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var dbSize = $scope.appMigrate.cloudDBService.dbConfig.dbSizeGB;
				if (!dbSize || (dbSize < 15 && dbSize > 2048)) {
					isValid = false;
				}
			}
			return isValid;
		};

		$scope.isValidListenerPort = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var listenerPort = $scope.appMigrate.cloudDBService.dbConfig.listenerPort;
				if (!listenerPort || (listenerPort < 1521 && listenerPort > 5499)) {
					isValid = false;
				}
			}
			return isValid;
		};

		$scope.isValidComputeShape = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var vmInstType = $scope.appMigrate.cloudDBService.dbConfig.vmInstType;
				if (!vmInstType) {
					$scope.errors.vmInstType = true;
					isValid = false;
				} else {
					$scope.errors.vmInstType = false;
				}
			}
			return isValid;
		};

		$scope.validateNodePage = function() {
			if (
				$scope.isValidDatabaseName() &&
				$scope.isValidAdminPassword() &&
				$scope.isValidStorageContainer() &&
				$scope.isValidDBSize() &&
				$scope.isValidListenerPort() &&
				$scope.isValidComputeShape()
			) {
				$scope.goNextPage();
			}
			if ($scope.appMigrate.cloudDBService.oraSoftwareEdition == 0) {
				$scope.restoreOptions.disableMaxNoOfStreams = true;
				$scope.restoreOptions.oracleOpt.restoreStream = 1;
			} else {
				$scope.restoreOptions.disableMaxNoOfStreams = false;
			}
			if (!$scope.tileState.dataConfigState) {
				$scope.tileState.dataConfigState = true;
				$scope.tileState.backupConfigState = false;
			}
		};

		$scope.isRestoreStepValid = function() {
			var isValid = true;
			if ($scope.isOracleAsService && $scope.appMigrate.instanceBackupType == 2) {
				if ($scope.appMigrate.cloudDBService.dbRecoveryConfig.onPremisesBackup) {
					var dbidPatternRegex = /^[0-9]{0,15}$/;
					var dbidValue = $scope.appMigrate.cloudDBService.dbRecoveryConfig.dbID;
					if (dbidValue && dbidPatternRegex.test(dbidValue)) {
						$scope.errors.cloudStorageDBID = false;
					} else {
						$scope.errors.cloudStorageDBID = true;
						isValid = false;
					}
				}
			}

			return isValid;
		};

		$scope.isGeneralSectionValid = function() {
			var errors = {};

			if ($scope.appMigrate.preRegistore) {
				$scope.errors = errors;
				if (!$scope.appMigrate.cloudMachineName) {
					errors.registoredServers = true;
					return false;
				} else {
					errors.registoredServers = false;
				}
			} else {
				if ($scope.appMigrate.cloudType == null) {
					errors.cloudType = true;
				} else {
					errors.cloudType = false;
				}

				if ($scope.isOracleAsService) {
					var namePatternRegex = /^[A-Za-z][A-Za-z0-9\-]{6,48}[A-Za-z0-9]$/;
					var instanceNameValue = $scope.appMigrate.vmNameText;
					if (instanceNameValue != undefined && namePatternRegex.test(instanceNameValue)) {
						errors.instanceName = false;
					} else {
						errors.instanceName = true;
					}
				}
				//				else if (!$scope.appMigrate.targetCloudMachine || !$scope.appMigrate.targetCloudMachine.vm || !$scope.appMigrate.targetCloudMachine.vm.vmName) {
				//					errors.instanceName = true;
				//				}
				else {
					errors.instanceName = false;
				}

				$scope.errors = errors;
				if (errors.cloudType || errors.instanceName) {
					return false;
				}
			}

			return true;
		};

		//		$scope.saveGeneralPage = function () {
		//			getPolicyDetails($scope.appMigrate.policyId);
		//			if ($scope.isSqlMigration) {
		//				createContentTable();
		//			}
		//			createTable();

		//		};

		$scope.setCurrentStep = function(stepNumber) {
			$scope.step = stepNumber;
		};

		$scope.saveConfigPage = function() {
			$scope.serverMessage = cvUtil.emptyMsg();

			$scope.configPageEdting = true;
			if (
				$scope.appMigrate &&
				$scope.appMigrate.machineConfig &&
				$scope.appMigrate.machineConfig.advVMProperties &&
				$scope.appMigrate.machineConfig.advVMProperties.networkCards &&
				$scope.appMigrate.machineConfig.advVMProperties.networkCards.length > 0 &&
				$scope.appMigrate.machineConfig.advVMProperties.subnetList
			) {
				$scope.appMigrate.machineConfig.advVMProperties.networkCards[0].subnetNames =
					$scope.appMigrate.machineConfig.advVMProperties.subnetList;
			}

			return true;
		};

		self.isStorageSectionValid = function() {
			//Storage configuration validation
			if (_.get($scope.appMigrate.selectedExistingVm, 'vm.vmGUID')) {
				return true;
			}
			if (
				!$scope.appMigrate ||
				!$scope.appMigrate.machineConfig ||
				!$scope.appMigrate.machineConfig.storageVol_list ||
				$scope.appMigrate.machineConfig.storageVol_list.length <= 0
			) {
				cvToaster.showErrorMessage({
					message: cvLoc('error.storageDevices')
				});
				self.openAccordion1_0 = true;
				return false;
			}
			return true;
		};

		$scope.goNextPage = function() {
			$scope.steps[$scope.step].completed = true;
			$scope.step++;
		};

		$scope.goConfigPreviousStep = function() {
			$scope.step--;
			if ($scope.appMigrate.preRegistore) {
				$scope.step--;
			}
		};

		$scope.goPreviousStep = function() {
			if ($scope.step == 1) {
				$scope.configPageEdting = true;
			}
			$scope.step--;
		};

		var filterPolicies = cloudType => {
			$scope.filteredPoliciesList = $scope.policies.filter(policy => policy.entity.policyType == cloudType);

			// show only regular recovery targets for azure & oci cloud vendors
			if ($scope.isOCIPolicy || $scope.isAzureCloud) {
				$scope.filteredPoliciesList = $scope.policies.filter(
					policy => policy.isResourceGroupPolicy && policy.vmPolicyAppType == VM_POLICY_APP_TYPE.REGULAR.type
				);
			}

			if ($scope.filteredPoliciesList.length) {
				$scope.appMigrate.policyId = $scope.filteredPoliciesList[0].entity.vmAllocPolicyId;
				$scope.policyChanged();
			} else {
				$scope.vmTeplPolicy = null;
			}
		};

		$scope.cloudTypechange = function(cloudType) {
			$scope.isOracleAsService = false;
			$scope.isOracleCloudPolicy = false;
			$scope.isOCIPolicy = false;
			$scope.isAzureCloud = false;
			$scope.restoreOptions.disableMaxNoOfStreams = false;

			configPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationConfigPage.jsp';
			configPage.name = cvLoc('label.machineConfig');

			swPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationSoftwareConfiPage.jsp';
			swPage.name = cvLoc('label.swConfig');

			if (cloudType === 'ORACLE_CLOUD_INFRASTRUCTURE') {
				$scope.isOCIPolicy = true;
			} else if (cloudType === 'ORACLE_AS_SERVICE') {
				cloudType = 'ORACLE_CLOUD';
				$scope.isOracleAsService = true;
				configPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationServiceConfiPage.jsp';
				configPage.name = cvLoc('label.serviceConfg');

				swPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationNodeConfiPage.jsp';
				swPage.name = cvLoc('label.nodeConfg');
			} else if (cloudType === 'ORACLE_CLOUD') {
				$scope.isOracleCloudPolicy = true;
			} else if (cloudType === 'AZURE_RESOURCE_MANAGER') {
				hasAzureHypervisors();
				$scope.isAzureCloud = true;
				$scope.appMigrate.machineConfig.vmUser.userName = undefined;
				$scope.appMi.password = undefined;
				$scope.hideFirewallConnection.push(0);
				self.refreshFirewallConfig = !self.refreshFirewallConfig;
			}
			setPostMigrationScriptFormat();
			filterPolicies(cloudType);
			clearVmName();
			$scope.loadVms(cloudType);
			$scope.resetInstanceBackupType();
		};

		$scope.policyChanged = function() {
			if ($scope.appMigrate.policyId) {
				$scope.errors.policyName = false;
				getPolicyDetails($scope.appMigrate.policyId);
			} else {
				$scope.errors.policyName = true;
			}
		};

		function clearVmName() {
			$scope.appMigrate.vmNameText = '';
			$scope.wizardForm.$setUntouched();
			$scope.appMigrate.selectedExistingVm = '';
			$scope.updateOptions(null);
			$scope.errors.instanceName = false;
		}

		$scope.isDummyInstance = true;
		$scope.updateOptions = function(targetVm, vmList) {
			//			if(targetVm == null && vmList) {
			//				vmList.forEach(function(vm){
			//					if(vm.vm.vmName === $scope.appMigrate.vmNameText) {
			//						targetVm = vm;
			//					}
			//				});
			//			}

			if (targetVm === '') {
				targetVm = null;
			}

			var vmName;
			if (targetVm != null && targetVm.vm.vmGUID != null) {
				$scope.appMigrate.targetCloudMachine = targetVm;
				$scope.appMigrate.vmNameText = targetVm.vm.vmName;
				vmName = targetVm.vm.vmName;
				if ($scope.appMigrate.createNewMachine) {
					refreshConfig();
				}
				$scope.appMigrate.createNewMachine = false;
			} else {
				if (!$scope.appMigrate.createNewMachine) {
					$scope.appMigrate.vmNameText = '';
				}
				targetVm = {
					vm: {
						vmName: $scope.appMigrate.vmNameText
					}
				};
				vmName = $scope.appMigrate.vmNameText;
				$scope.appMigrate.targetCloudMachine = targetVm;
				if (!$scope.appMigrate.createNewMachine) {
					refreshConfig();
				}
				$scope.appMigrate.createNewMachine = true;
			}

			if (vmName && vmName !== '') {
				$scope.errors.instanceName = false;
			} else {
				$scope.errors.instanceName = true;
			}
		};

		$scope.policyList = [];
		var loadPolicies = function() {
			//load Policies
			appMigrationService
				.getPolicies({
					vender: 'vender'
				})
				.success(function(data) {
					if (data.length > 0) {
						data.forEach(e => {
							e.flatLabel = e.entity.vmAllocPolicyName;
						});
						$scope.policies = data;
						$scope.cloudTypechange($scope.appMigrate.cloudType);
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		loadPolicies();

		$scope.vmsMap = {};
		var dummyVmForCreateNew = {
			flatLabel: cvLoc('label.createNewVm'),
			vm: { vmGUID: null }
		};
		$scope.vmsList = [dummyVmForCreateNew];
		$scope.loadVms = function(cloudType) {
			// on the server for Azure RM, we match it with AZURE_V2
			if (cloudType === 'AZURE_RESOURCE_MANAGER') {
				cloudType = 'AZURE_V2';
			}

			if (!cloudType || $scope.isOracleAsService) {
				$scope.vmsList = [dummyVmForCreateNew];
				return;
			}
			//load libraries only if cvConfig showPlan property is false
			$scope.vmsList = $scope.vmsMap[cloudType];
			if (!$scope.vmsList) {
				$scope.vmsList = [dummyVmForCreateNew];
			}
			if ($scope.vmsList.length == 1 && $scope.vmsList[0] === dummyVmForCreateNew) {
				var policyId = $scope.appMigrate.policyId;
				appMigrationService
					.getVms({
						cloudType: cloudType,
						policyID: policyId
					})
					.success(function(data) {
						if (data.length > 0) {
							var vmsList = [dummyVmForCreateNew];
							angular.forEach(data, function(vmInfo) {
								if (vmInfo && vmInfo.vm && vmInfo.vm.vmName) {
									vmInfo.flatLabel = vmInfo.vm.vmName;
									vmsList.push(vmInfo);
								}
							});
							$scope.vmsList = vmsList;
							$scope.vmsMap[cloudType] = $scope.vmsList;
						}
					})
					.error(function(e) {
						$scope.serverMessage = {
							message: e,
							type: 'error'
						};
					});
			}
		};

		$scope.stagingPathResuleFunction = function(result) {
			//$log.info('path : ' + result.path);
			$scope.appMigrate.stagingPath = result.path;
		};
		$scope.validationScrtResuleFunction = function(result) {
			//$log.info('path : ' + result.path);
			$scope.appMigrate.validationScript = result.path;
		};

		$scope.getStorageDetails = function(instanceEntity, sourceItems) {
			appMigrationService
				.getStorageDetails({
					instance: angular.toJson(instanceEntity),
					sourceItems: angular.toJson(sourceItems)
				})
				.success(function(data) {
					if (data) {
						if (data.totalAppSize) {
							var maxValu = Math.max(15, data.totalAppSize);
							$scope.appMigrate.cloudDBService.dbConfig.dbSizeGB = maxValu;
						}
						$scope.storageDetails = []; //data.volume_list;
						for (let i = 0; i < data.volume_list.length; i++) {
							if (
								!(
									(data.volume_list[i].mntPoint &&
										data.volume_list[i].mntPoint.mountPathName &&
										data.volume_list[i].mntPoint.mountPathName.toLowerCase() === 'c') ||
									data.volume_list[i].mntPoint.mountPathName.toLowerCase() === '/root'
								)
							) {
								$scope.storageDetails.push(data.volume_list[i]);
							}
						}

						$scope.appMigrate.machineConfig.storageVol_list = $scope.storageDetails;
						$scope.appMigrate.appMetaData_list = data.metaData_list;

						$scope.refreshConfigValue = !$scope.refreshConfigValue;
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		var updateUserInputs = function() {
			if ($scope.isOracleAsService) {
				$scope.appMigrate.cloudDBService.serviceName = $scope.appMigrate.vmNameText;
				if ($scope.appMigrate.cloudDBService.dbRecoveryConfig.decMethod == '1') {
					delete $scope.appMigrate.cloudDBService.dbRecoveryConfig.walletFilePath;
				} else {
					delete $scope.appMigrate.cloudDBService.dbRecoveryConfig.rmanKey;
				}
				$scope.appMigrate.cloudType = 'ORACLE_CLOUD';
				var bytPassowrd = cvUtil.getBytes($scope.appMigrate.cloudDBService.dbConfig.dbPasswordValue);
				$scope.appMigrate.cloudDBService.dbConfig.dbPassword = bytPassowrd;

				if (
					$scope.appMigrate.cloudDBService.dbRecoveryConfig &&
					$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser &&
					$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser.userNamePassowrd
				) {
					var userBytPassowrd = cvUtil.getBytes(
						$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser.userNamePassowrd
					);
					$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser.password = userBytPassowrd;
				}

				if (
					$scope.appMigrate.cloudDBService.dbBackupConfig &&
					$scope.appMigrate.cloudDBService.dbBackupConfig.storageUser &&
					$scope.appMigrate.cloudDBService.dbBackupConfig.storageUser.userNamePassowrd
				) {
					var passValue = cvUtil.getBytes($scope.appMigrate.cloudDBService.dbBackupConfig.storageUser.userNamePassowrd);
					$scope.appMigrate.cloudDBService.dbBackupConfig.storageUser.password = passValue;
				}
			} else if ($scope.isOCIPolicy) {
				if (
					$scope.appMigrate.machineConfig &&
					$scope.appMigrate.machineConfig.advVMProperties &&
					$scope.appMigrate.machineConfig.advVMProperties.networkCards &&
					$scope.appMigrate.machineConfig.advVMProperties.networkCards.length > 0
				) {
					$scope.appMigrate.machineConfig.advVMProperties.networkCards[0].subnetNames =
						$scope.appMigrate.machineConfig.advVMProperties.subnetList;
				}
			} else {
				delete $scope.appMigrate.cloudDBService;
			}

			// if user choice network info is available check that and update network info
			if ($scope.appMigrate.cloudType === 'AZURE_RESOURCE_MANAGER') {
				let networkInfo = {
					networkName: '',
					subnetNames: [
						{
							subnetId: '',
							name: ''
						}
					]
				};
				if (!_.isEmpty(_.get($scope, 'appMigrate.cloudAllocationPolicy.networkList[0].networkName', ''))) {
					let subnetName = _.get($scope, 'appMigrate.cloudAllocationPolicy.networkList[0].networkDisplayName', '');
					if (subnetName.lastIndexOf('\\') > 0) {
						subnetName = subnetName.substring(subnetName.lastIndexOf('\\') + 1);
					}
					networkInfo = {
						networkName: _.get($scope, 'appMigrate.cloudAllocationPolicy.networkList[0].networkName', ''),
						subnetNames: [
							{
								subnetId: _.get($scope, 'appMigrate.cloudAllocationPolicy.networkList[0].subnetId', ''),
								name: subnetName
							}
						]
					};
				} else if (
					$scope.appMigrate.cloudAllocationPolicy &&
					$scope.appMigrate.cloudAllocationPolicy.networkNames &&
					$scope.appMigrate.cloudAllocationPolicy.networkNames.length > 0
				) {
					for (let i = 0; i < $scope.appMigrate.cloudAllocationPolicy.networkInfo.length; i++) {
						if (
							$scope.appMigrate.cloudAllocationPolicy.networkNames[0] ===
							$scope.appMigrate.cloudAllocationPolicy.networkInfo[i].networkName
						) {
							networkInfo = $scope.appMigrate.cloudAllocationPolicy.networkInfo[i];
							if (!_.has(networkInfo, 'subnetNames[0].name')) {
								_.set(networkInfo, 'subnetNames[0].name', '');
							}
							break;
						}
					}
				}

				_.set($scope, 'appMigrate.machineConfig.advVMProperties.networkCards[0]', networkInfo);
				_.set($scope, 'appMigrate.machineConfig.advVMProperties.subnetList[0]', networkInfo.subnetNames[0]);

				var bytPassowrd = cvUtil.getBytes(self.password);

				$scope.appMigrate.osCredentials.user.userName = $scope.appMigrate.machineConfig.vmUser.userName;
				$scope.appMigrate.osCredentials.password = bytPassowrd;
			}

			var browseOption = {
				mediaOption: {
					copyPrecedence: {
						copyPrecedence: $scope.pattern.freq_type == 1 ? 0 : $scope.restoreOptions.copyPrecedence,
						copyPrecedenceApplicable: $scope.restoreOptions.copyPrecedence != 0
					}
				}
			};
			$scope.restoreOptions.browseOption = browseOption;

			if ($scope.isCrossPlatfrom) {
				var appMetaData_list = $scope.appMigrate.appMetaData_list;
				if (appMetaData_list == null) {
					appMetaData_list = [];
				}

				var crossMach = new Object();
				crossMach.value = 'Y';
				crossMach.name = 'CROSS_PLATFORM';
				appMetaData_list.push(crossMach);

				var mData = new Object();
				mData.value = $scope.appMigrate.stagingPath;
				mData.name = 'STAGING_PATH';
				appMetaData_list.push(mData);
			}
			if ($scope.applicationId == 81) {
				$scope.restoreOptions.oracleOpt = null;
				updateSQLOptions();
			} else {
				$scope.restoreOptions.destination.destinationInstance.instanceName = $scope.entity.instanceName;
				$scope.restoreOptions.destination.noOfStreams = $scope.restoreOptions.oracleOpt.restoreStream;
			}

			if ($scope.appMigrate.preRegistore) {
				var appMetaData_list = $scope.appMigrate.appMetaData_list;
				if (appMetaData_list == null) {
					appMetaData_list = [];
					$scope.appMigrate.appMetaData_list = appMetaData_list;
				}

				var crossMach = new Object();
				crossMach.value = 'YES';
				crossMach.name = 'USE_PRE_CONFIGURE_SERVER';
				appMetaData_list.push(crossMach);
			}

			if (
				($scope.appMigrate.cloudType == 'AMAZON' || $scope.isOCIPolicy) &&
				_.get($scope.appMigrate.selectedExistingVm, 'vm.vmGUID')
			) {
				$scope.appMigrate.cloudAllocationPolicy = {
					entity: {
						vmAllocPolicyId: $scope.appMigrate.selectedExistingVm.vmAllocPolicyId
					}
				};
			}
		};

		$scope.runAppMigration = function() {
			if (!areInputsValid()) {
				return;
			}

			updateUserInputs();
			var appMgrconfig = $scope.appMigrate;

			var job = {
				options: {
					restoreOptions: $scope.restoreOptions
				},
				pattern: $scope.pattern
			};

			if ($scope.pattern.freq_type == 1) {
				$scope.restoreOptions.commonOptions.syncRestore = false;
			}

			var firewallConfig = $scope.appMigrate.firewallConfig;
			if (firewallConfig.proxyClientName) {
				firewallConfig.proxyInfo = [
					{
						clientName: firewallConfig.proxyClientName
					}
				];
			}

			var liveSyncXML = angular.toJson(job);
			appMgrconfig.liveSyncOptionsXML = liveSyncXML;
			delete appMgrconfig.cloudAllocationPolicy.templates;
			if (
				appMgrconfig.cloudAllocationPolicy.amazonPolicy &&
				appMgrconfig.cloudAllocationPolicy.amazonPolicy.instanceType
			) {
				delete appMgrconfig.cloudAllocationPolicy.amazonPolicy.instanceType;
			}
			appMigrationService
				.runAppMigration({
					appMgrconfig: angular.toJson(appMgrconfig),
					firewallConfig: angular.toJson($scope.appMigrate.firewallConfig)
				})
				.success(function(successData) {
					if (successData) {
						var jobUrl = '#/jobs/' + successData;
						var responseContent =
							' <a target="_blank" href="' + jobUrl + '">' + cvLoc('label.redirectMsg') + ' ' + successData + '</a>';
						cvToaster.showSuccessMessage({
							ttl: '15000',
							message: responseContent
						});
						self.close();
					}
				})
				.error(function(errorReason) {
					$scope.serverMessage = {
						message: errorReason ? errorReason : cvLoc('error.sunmitAppMigration'),
						type: 'error'
					};
				});
		};

		/* SQL migration query details */

		var updateSQLOptions = function() {
			$scope.appMigrate.appMetaData_list = $scope.appMigrate.appMetaData_list || [];

			$scope.restoreOptions.destination.destinationInstance.instanceName = $scope.appMigrate.destInstanceName;
			$scope.pattern.freq_type = 1;
		};

		var validateDB = function() {
			if (!$scope.isSqlMigration) {
				return true;
			}
			let selectedDB = [];
			let deviceInfoList = [];
			let deviceList = [];
			$scope.databases.forEach(function(database) {
				if (database.isSelected) {
					selectedDB.push(database.databaseName);
					deviceInfoList = deviceInfoList.concat(self.dbToItemsMap.get(database.databaseId).deviceInfoStrList);
					deviceList = deviceList.concat(self.dbToItemsMap.get(database.databaseId).deviceStrList);
				}
			});

			if (selectedDB.length) {
				$scope.getStorageDetails($scope.appMigrate.srcInst, selectedDB);
				if ($scope.restoreOptions.sqlServerRstOption) {
					$scope.restoreOptions.sqlServerRstOption.database = selectedDB;
					$scope.restoreOptions.sqlServerRstOption.restoreSource = selectedDB;
					$scope.restoreOptions.sqlServerRstOption.device = deviceList;
					$scope.restoreOptions.sqlServerRstOption.deviceInfo = deviceInfoList;
				}
			} else {
				$scope.validationErrors.contentSelection = cvLoc('error.noDbsSelection');
				self.openContentSelection = true;
				return false;
			}
			return true;
		};

		$scope.addReplicationTarget = function() {
			return replicationFactory
				.showAddReplicationTarget(null, null, null, VM_POLICY_APP_TYPE.REGULAR.type, VSA_VENDOR.AZURERM, null, null)
				.result.then(function() {
					loadPolicies();
				});
		};

		var validateMigrationOptions = function() {
			if ($scope.isSqlMigration && $scope.appMigrate.destInstanceName.length === 0) {
				$scope.validationErrors.migrationOptions = true;
				self.openAccordion3 = true;
				return false;
			}

			return true;
		};

		var areInputsValid = function() {
			$scope.validationErrors.contentSelection = undefined;
			$scope.validationErrors.migrationOptions = undefined;

			return validateDB();
		};

		self.cancel = function() {
			$uibModalInstance.dismiss();
		};

		self.close = function() {
			$uibModalInstance.close();
		};

		self.showConfigSection = function() {
			return (
				!$scope.isOracleAsService &&
				!$scope.appMigrate.preRegistore &&
				!_.get($scope.appMigrate.selectedExistingVm, 'vm.vmGUID')
			);
		};

		self.showStorageSection = function() {
			return !$scope.isOracleAsService && !$scope.appMigrate.preRegistore;
		};

		self.showSoftwareConfigSection = function() {
			return !$scope.isOracleAsService && !$scope.isSqlMigration;
		};

		self.showServiceConfigSection = function() {
			return $scope.isOracleAsService;
		};

		self.showNodeConfigSection = function() {
			return $scope.isOracleAsService;
		};

		self.showFirewallConfigurationSection = function() {
			// show firewall config for all the cloud types
			// return $scope.isSqlMigration;
			return true;
		};

		self.showContentSelectionSection = function() {
			return $scope.isSqlMigration;
		};

		self.submit = function() {
			if (!$scope.isGeneralSectionValid()) {
				return;
			}

			if (self.showConfigSection() && !$scope.saveConfigPage()) {
				return;
			}

			if (!$scope.isRestoreStepValid()) {
				return;
			}
			$scope.runAppMigration();
		};

		$scope.vmnameValidation = (function() {
			var vmname_regexp = new RegExp(/^(?=.{1,15}$)[a-zA-Z0-9][a-zA-Z0-9.-]*[a-zA-Z0-9]$/);
			return {
				test: function(value) {
					if (!$scope.isAzureCloud) {
						return true;
					}
					return vmname_regexp.test(value);
				}
			};
		})();
	}
]);

export default appMigration;
