import 'modules/ida/js/services/idaService.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('addDB2PartitionNodesCtrl', [
	'cvLoc',
	'$uibModalInstance',
	'$log',
	'data',
	'idaService',
	'cvUtil',
	'cvToaster',
	function(cvLoc, $modalInstance, $log, data, idaService, cvUtil, cvToaster) {
		var self = this;
		self.entity = data.entity;
		//self.selectedClient = data.entity;
		self.partitionInfo = {
			db2Home: data.db2Home,
			selectedClient: null,
			listOfClients: null
		};
		self.clientSelection = {
			selectedClients: [],
			valideClientSelection: false,
			clientLoaded: function(listOfClients) {
				if (listOfClients) {
					self.partitionInfo.listOfClients = listOfClients;
				}
			},
			selectionChanged: function(clientEntity) {
				self.partitionInfo.selectedClient = clientEntity;
			}
		};
		/*
		 * if (!data.editDialog) { data.idaEntity.appName = 'DB2'; }
		 */
		self.loading = false;
		self.addPartitionNode = function() {
			let nodeList = null;
			self.loading = true;
			idaService
				.getDB2Partitions(self.partitionInfo.selectedClient.clientId, self.partitionInfo.db2Home)
				.success(function(data) {
					if (data) {
						if (data.error && data.error.errorMessage) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: data.error.errorMessage
							});
							//for retain the old selected values
							let dataObject = {
								db2Home: self.partitionInfo.db2Home,
								partitionList: {
									nodes: []
								},
								listOfClients: self.partitionInfo.listOfClients
							};
							$modalInstance.close(dataObject);
						} else {
							let partitionData = data;
							//filter out partition >127
							if (data.nodes) {
								partitionData.nodes = _.filter(data.nodes, node => node.nodenum <= 127);
							}
							let dataObject = {
								db2Home: self.partitionInfo.db2Home,
								partitionList: partitionData,
								listOfClients: self.partitionInfo.listOfClients
							};
							$modalInstance.close(dataObject);
						}
					}
				})
				.error(function(data) {
					self.serverMessage = cvUtil.errMsgLoc('error.getServers');
					$modalInstance.close(null);
				});
		};

		self.closeDialogBox = function() {
			$modalInstance.close();
		};

		self.db2HomeResuleFunction = function(result) {
			if (result) {
				self.partitionInfo.db2Home = result.path;
			}
		};
	}
]);

export default app;
