import 'modules/ida/js/services/idaService.svc.js';

import { acAppInstanceModule } from 'common/js/modules';

var app = acAppInstanceModule;

export class FsCloneModalController {
	//-------- Start of constructor -----
	constructor($log, $modal, $modalInstance, $stateParams, AppTypesUtil, cvToaster, cvLoc, idaService, data, cvUtil) {
		this.$log = $log;
		this.$modal = $modal;
		this.$modalInstance = $modalInstance;
		this.$stateParams = $stateParams;
		this.AppTypesUtil = AppTypesUtil;
		this.cvToaster = cvToaster;
		this.cvLoc = cvLoc;
		this.idaService = idaService;
		this.data = data;
		this.entity = data.entity;
		this.cvUtil = cvUtil;
		this.restoreData = {
			cloneMountPath: '',
			postCloneScript: '',
			cloneCleanupScript: '',
			rsvTPDays: 0,
			rsvTPHours: 1,
			clientsList: [],
			destClient: {},
			overwriteExistingClone: false
		};
		this.errors = {
			rsvTPDays: false,
			isCloneMountPathValid: true
		};

		this.CLONE_MOUNT_PATH = 'cloneMountPath';
		this.POST_CLONE_SCRIPT = 'postCloneScript';
		this.CLONE_CLEANUP_SCRIPT = 'cloneCleanupScript';

		this._fetchData();
	}

	_fetchData() {
		this._loadDestinationServers();
	}

	_loadDestinationServers() {
		this.restoreData.clientsList = [];
		this.restoreData.destClient = {};
		this.serverMessage = this.cvUtil.emptyMsg();
		this.idaService
			.getRestoreDestinations(this.entity.clientId, this.entity.applicationId)
			.success(data => {
				let clientsList = [];
				if (!!data) {
					clientsList = data.filter(client => client.applicationId === this.entity.applicationId);
					clientsList = angular.copy(_.sortBy(clientsList, 'clientName'));
					this.restoreData.clientsList = clientsList;
					let selectedDestClient = undefined;
					let clientId = this.entity.clientId;
					angular.forEach(this.restoreData.clientsList, function(client) {
						if (client.clientId === clientId) {
							client.selected = true;
							selectedDestClient = client;
						}
					});
					if (!selectedDestClient && !!clientsList && clientsList.length > 0) {
						this.restoreData.clientsList[0].selected = true;
						this.restoreData.destClient = this.restoreData.clientsList[0];
					} else {
						this.restoreData.destClient = selectedDestClient;
					}
				}
				this.serverMessage = {
					message: this.cvLoc('error.oracleVmDestinationServer'),
					type: 'error'
				};
			})
			.error(error => {
				//this.serverMessage = cvUtil.errMsgLoc('generic_error');
				this.restoreData.clientsList = [];
				this.restoreData.destClient = {};
				this.$log.error('Destination server is not selected');
				this.serverMessage = {
					message: this.cvLoc('error.oracleVmDestinationServer'),
					type: 'error'
				};
				this.$log.error(error);
			});
	}

	destinationChanged() {
		this.restoreData.cloneMountPath = '';
		this.restoreData.postCloneScript = '';
		this.restoreData.cloneCleanupScript = '';
		this.browseAttempted = false;
		this.restoreAttempted = false;
	}

	getDestinationModal(browseModelType) {
		let clientId = _.get(this.restoreData, 'destClient.clientId');
		let foldersOnly = this.CLONE_MOUNT_PATH === browseModelType ? true : false;
		let epicServerState = false;

		if (this.data && this.data.epicServerState) {
			epicServerState = true;
		}

		var modalInstance = this.$modal.open({
			templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
			controller: 'mbController',
			resolve: {
				browseParams: function() {
					let otherOptions = undefined;
					if (epicServerState) {
						otherOptions = {
							browseType: 'OS_BASED_BROWSE'
						};
					}
					return {
						clientId: clientId,
						foldersOnly: foldersOnly,
						epicServerState: epicServerState,
						otherOptions: otherOptions
					};
				}
			}
		});

		return modalInstance;
	}

	openBrowseModel(browseModelType) {
		if (this.isDisableBrowse()) {
			this.browseAttempted = true;
			return;
		} else {
			this.browseAttempted = false;
		}
		var modalInstance = this.getDestinationModal(browseModelType);
		if (modalInstance) {
			modalInstance.result.then(
				result => {
					switch (browseModelType) {
						case this.CLONE_MOUNT_PATH:
							this.errors.isCloneMountPathValid = this.validatePath(result.path);
							if (this.AppTypesUtil.isUnixFileSystem(this.restoreData.destClient.applicationId)) {
								this.errors.isCloneMountPathValid = !this.validateSelectedPath(result.path);
							}
							this.restoreData.cloneMountPath = result.path;
							break;
						case this.POST_CLONE_SCRIPT:
							this.restoreData.postCloneScript = result.path;
							break;
						case this.CLONE_CLEANUP_SCRIPT:
							this.restoreData.cloneCleanupScript = result.path;
							break;
					}
				},
				() => {
					this.$log.debug('Cancel clicked');
				}
			);
		}
	}

	browseResuleFunction(result) {
		if (result) {
			this.restoreData.path = result.path;
		}
	}

	isDisableBrowse() {
		let clientId = _.get(this.restoreData, 'destClient.clientId');

		if (clientId && clientId > 0) {
			return false;
		}

		return true;
	}

	validateSelectedPath(path) {
		let linuxCloneMountPath = /[ ~.#?\[\];&<>|!$]/;
		return linuxCloneMountPath.test(path);
	}
	validateReservationTime() {
		let rsvTime = this.restoreData.rsvTPDays + this.restoreData.rsvTPHours;
		if (!rsvTime || rsvTime < 1) {
			this.errors.rsvTPDays = true;
			return false;
		}
		this.errors.rsvTPDays = false;
		return true;
	}

	toggleOverwriteClone() {
		this.restoreData.overwriteExistingClone = !this.restoreData.overwriteExistingClone;
	}

	validatePath(path) {
		if (this.AppTypesUtil.isUnixFileSystem(this.restoreData.destClient.applicationId)) {
			this.errors.isCloneMountPathValid = !this.validateSelectedPath(path);
		} else {
			this.errors.isCloneMountPathValid = true;
		}
		return this.errors.isCloneMountPathValid;
	}
	validateInputs() {
		if (
			!!this.restoreData.destClient &&
			!!this.restoreData.cloneMountPath &&
			this.validatePath(this.restoreData.cloneMountPath) &&
			this.validateReservationTime() &&
			this.errors.isCloneMountPathValid
		) {
			return true;
		}

		return false;
	}

	composeDestination() {
		var destination = new Object();
		destination.noOfStreams = 10; //setting default to > 1 as per backend requirement.
		destination.destClient = this.restoreData.destClient;
		destination.destinationInstance = angular.extend({}, destination.destClient, {
			instanceId: this.entity.instanceId,
			instanceName: this.entity.instanceName
		});
		destination.destPath = [];
		destination.destPath.push(this.restoreData.cloneMountPath); // copying clonemountpath to destPath to avoid some issues in backend, this need to be removed once backend handles properly.
		return destination;
	}

	composeBrowseOption() {
		var browseOption = {
			commCellId: 2,
			timeRange: {
				fromTimeValue: this.$stateParams['fromTime'] ? this.$stateParams['fromTime'] : null,
				toTimeValue: this.$stateParams['toTime'] ? this.$stateParams['toTime'] : null
			},
			browseJobId: this.$stateParams['jobId'] ? this.$stateParams['jobId'] : null,
			backupset: {
				clientId: this.entity.clientId,
				clientName: this.entity.clientName,
				backupsetName: this.entity.backupsetName,
				backupsetId: this.entity.backupsetId
			}
		};

		return browseOption;
	}

	composeCommonOptions() {
		let commonOptions = {
			prePostCloneOption: {}
		};

		if (!!this.restoreData.postCloneScript) {
			commonOptions.prePostCloneOption = {
				postCloneCmd: this.restoreData.postCloneScript
			};
		}

		return commonOptions;
	}

	componsefileOptions() {
		let resrTime = this.restoreData.rsvTPDays * 24 * 60 * 60 + this.restoreData.rsvTPHours * 60 * 60;

		let fileOption = {
			fsCloneOptions: {
				reservationTime: resrTime,
				cloneMountPath: this.restoreData.cloneMountPath,
				cloneCleanupOptions: {},
				overwriteExistingClone: this.restoreData.overwriteExistingClone
			}
		};

		if (!!this.restoreData.cloneCleanupScript) {
			fileOption.fsCloneOptions.cloneCleanupOptions = {
				cleanupScriptPath: this.restoreData.cloneCleanupScript
			};
		}

		return fileOption;
	}

	getSourceItems() {
		let sourceItems = [];
		angular.forEach(this.data.selectedRows, function(selectedItem) {
			sourceItems.push(encodeURIComponent(selectedItem.userObject.path));
		});
		return sourceItems;
	}

	cancelModal() {
		this.$modalInstance.dismiss();
	}

	submitFsClone() {
		this.instantCloneAttempted = true;
		if (!this.validateInputs()) {
			this.$log.error('Sone inputs are invalid');
			return;
		}

		let entityType = 'SUBCLIENT_ENTITY';
		let genericEntity = angular.copy(this.entity);
		let sourceItems = this.getSourceItems();

		let browseOption = this.composeBrowseOption();
		let destination = this.composeDestination();
		let commonOptions = this.composeCommonOptions();
		let agentSpecificOptions = this.componsefileOptions();

		this.idaService
			.submitRestoreJob({
				entityType: entityType,
				genericEntity: angular.toJson(genericEntity),
				browseOption: angular.toJson(browseOption),
				destination: angular.toJson(destination),
				commonOptions: angular.toJson(commonOptions),
				sourceItemsToRestore: angular.toJson(sourceItems),
				agentSpecificOptions: angular.toJson(agentSpecificOptions),
				isDecodePath: true
			})
			.success(successData => {
				if (successData) {
					let restoreMsg = this.cvLoc('notification.restore.started', successData);
					let viewMsg = this.cvLoc('notification.jobDetails');

					let jobUrl = '#/jobs/' + successData;
					let responseContent =
						this.cvLoc('label.cloneRedirectMsg', successData) +
						' <br> <a href="' +
						jobUrl +
						'">' +
						this.cvLoc('notification.jobDetails') +
						'</a>';
					this.cvToaster.showSuccessMessage({
						ttl: '15000',
						message: responseContent
					});
					this.cancelModal();
				}
			})
			.error(function(err) {
				cvToaster.showErrorMessage({
					message: err
				});
			});
	}
}

FsCloneModalController.$inject = [
	'$log',
	'$uibModal',
	'$uibModalInstance',
	'$stateParams',
	'AppTypesUtil',
	'cvToaster',
	'cvLoc',
	'idaService',
	'data',
	'cvUtil'
];

app.controller('fsCloneModalController', FsCloneModalController);
export default app;
