<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.databaseClone"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<form name="wizardForm" novalidate autocomplete="off"
		data-cv-submit="dbClone.submit()">
		<div class="modal-header">
			<h1>
				<cv:msg key="label.instantClone" bundle="databaseClone" />
			</h1>
		</div>
		<span class="serverMessage {{dbClone.serverMessage.type}}"
			data-ng-bind="dbClone.serverMessage.message"></span>

		<!-- Source details shown when coming from a generic context instead of an instance -->
		<div class="panel panel-default"
			data-ng-if="dbClone.showSourceSelection">
			<div class="panel-body">
				<h4>
					<cv:msg key="label.sourDetails" bundle="oracle" />
				</h4>
				<!-- //Source client name // -->
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-sm-5" for="sourceClient"
							id="sourceClientLb">
							<cv:msg key="label.sourceServer" bundle="sqlserver" />
						</label>

						<div class="col-xs-12 col-sm-7">

							<cv-isteven-single-select id-name="sourceClient"
								input-model="dbClone.sourceClientList"
								binding-model="dbClone.sourceData.sourceClient"
								track-field="clientId" label="{{dbClone.srcLabel}}"
								tick-property="selected"
								place-holder='<cv:msg key="placeholder.sourceServer" bundle="restore"/>'
								on-change='dbClone.sourceClientChanged()'
								help-text='<cv:msg key="placeholder.sourceServer" bundle="restore"/>'
								required="true"> </cv-isteven-single-select>
						</div>
					</div>
					<!-- Source instance name -->
					<div class="form-group">

						<label class="col-xs-12 col-sm-5" for="sourceInstance"
							id="sourceInstanceLb">
							<cv:msg key="label.sourceInst" bundle="oracle" />
						</label>

						<div class="col-xs-12 col-sm-7"
							data-ng-disabled="!(dbClone.sourceInstanceList && dbClone.sourceInstanceList.length > 0)">
							<cv-isteven-single-select id-name="sourceInstance"
								input-model="dbClone.sourceInstanceList"
								binding-model="dbClone.sourceData.sourceInstance"
								track-field="instanceId" label="instanceName"
								tick-property="selected"
								on-change='dbClone.sourceInstanceChanged()'
								help-text='<cv:msg key="placeholder.sourceInstance" bundle="restore"/>'
								place-holder='<cv:msg key="placeholder.sourceInstance" bundle="restore"/>'
								required="true"> </cv-isteven-single-select>
						</div>
					</div>
					<!-- Source backupset name -->
					<div class="form-group" data-ng-if="dbClone.showSourceDB">

						<label class="col-xs-12 col-sm-5" for="sourceBackupset"
							id="showSourceDB:)Lb">
							<cv:msg key="label.sourceDb" bundle="oracle" />
						</label>

						<div class="col-xs-12 col-sm-7" data-ng-if="!dbClone.isSqlClone"
							data-ng-disabled="!(dbClone.sourceDbList && dbClone.sourceDbList.length > 0)">
							<cv-isteven-single-select id-name="sourceBackupset"
								input-model="dbClone.sourceDbList"
								binding-model="dbClone.sourceData.sourceDb"
								track-field="backupsetId" label="backupsetName"
								disable-property="itemDisable" tick-property="selected"
								on-change='dbClone.sourceDBChanged()'
								help-text='<cv:msg key="placeholder.sourceDb" bundle="oracle"/>'
								place-holder='<cv:msg key="placeholder.sourceDb" bundle="oracle"/>'
								required="true"> </cv-isteven-single-select>
						</div>

						<div class="col-xs-12 col-sm-7" data-ng-if="dbClone.isSqlClone"
							data-ng-disabled="!(dbClone.sourceDbList && dbClone.sourceDbList.length > 0)">
							<cv-isteven-single-select id-name="sourceDatabase"
								input-model="dbClone.sourceDbList"
								binding-model="dbClone.sourceData.sourceDb"
								track-field="databaseId" label="databaseName"
								tick-property="selected" on-change='dbClone.sourceDBChanged()'
								help-text='<cv:msg key="placeholder.sourceDb" bundle="oracle"/>'
								place-holder='<cv:msg key="placeholder.sourceDb" bundle="oracle"/>'
								required="true"> </cv-isteven-single-select>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div data-ng-if="dbClone.sourceSelected">
			<!-- Destination details section -->
			<div class="panel panel-default">
				<div class="panel-body">
					<h4>
						<cv:msg key="label.destDetails" bundle="oracle" />
					</h4>
					<!-- // client name // -->
					<div class="panel-body">
						<div class="form-group" title='{{dbClone.data.destClientLb}}'
							data-ng-if="!dbClone.isSqlClone">
							<label class="col-xs-12 col-sm-5" for="destClient"
								id="destClientLb">
								<cv:msg key="label.oracleVmDestinationServer" bundle="restore" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<!-- <select data-ng-model="dbClone.data.destClient" name="destClient" id="destClient"
						data-ng-change="dbClone.destClientChanged(dbClone.data.destClient)"
						data-ng-options="client as client.clientName for client in dbClone.clientsList | orderBy:'clientName'">
					</select> -->
								<cv-isteven-single-select id-name="destClient"
									input-model="dbClone.clientsList"
									binding-model="dbClone.data.destClient" track-field="clientId"
									label="displayName" tick-property="selected"
									place-holder='<cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/>'
									on-change='dbClone.destClientChanged(dbClone.data.destClient)'
									help-text='<cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/>'
									required="true"> </cv-isteven-single-select>
							</div>
						</div>
						<!-- // instance name // -->
						<div class="form-group" title='{{dbClone.data.instanceLb}}'
							data-ng-if="!dbClone.isSqlClone">
							<label class="col-xs-12 col-sm-5" for="destInstance"
								id="destClientLb"> {{dbClone.data.instanceLb}} </label>
							<div class="col-xs-12 col-sm-7">
								<div data-ng-if="!dbClone.isOracleClone">
									<cv-isteven-single-select id-name="destInstance"
										input-model="dbClone.instanceList"
										binding-model="dbClone.data.instance" track-field="instanceId"
										label="instanceName" tick-property="selected"
										on-change='dbClone.updateOptions(dbClone.data.instance)'
										help-text='<cv:msg key="error.DestinationInstance" bundle="restore"/>'
										required="true"> </cv-isteven-single-select>
								</div>
								<div data-ng-if="dbClone.isOracleClone">
									<input type="text" id="destInstance" name="destInstance"
										required data-ng-maxlength="{{dbClone.instanceNameSize}}"
										data-ng-model="dbClone.data.instanceNameText"
										data-ng-change="dbClone.updateOptions(dbClone.dummyInstance)" />
								</div>
								<span class="help-block"
									data-ng-show="dbClone.isOracleClone && cv.wizardForm.needsAttention(wizardForm.destInstance);">
									<cv:msg key="error.instanceName" bundle="oracle" />
								</span>
							</div>
						</div>
						<div data-ng-if="dbClone.readyToLoadSqlDestination">
							<cv-sql-select-dest-client-instance entity="dbClone.entity"
								restore-opts="dbClone.sqlRestoreOpts" usecase="clone"
								restore-operation-type="RECOVERY_POINT">
							</cv-sql-select-dest-client-instance>
						</div>
						<!-- // target database  // -->
						<div class="form-group" data-ng-if="dbClone.isSqlClone"
							title="<cv:msg key='label.targetDbName' bundle='sqlserver' />">
							<label class="col-xs-12 col-sm-5" for="cloneDbName"
								id="targetDbNameLb">
								<cv:msg key="label.targetDbName" bundle="sqlserver" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="text" id="cloneDbName" name="cloneDbName"
									id="targetDbName" required
									data-ng-model="dbClone.sqlRestoreOpts.destinationDatabase.databaseName" />
							</div>
						</div>
						<div class="form-group"
							data-ng-if="dbClone.isSAPHANAClone && dbClone.saphanaMultiNode">
							<label class="col-xs-12 col-sm-5" for="destinationDatabase"
								id="destinationDatabaseLb">
								<cv:msg key="label.destinationDatabase" bundle="saphana" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<cv-isteven-single-select id-name="destinationDatabase"
									input-model="dbClone.backupsetDataList"
									binding-model="dbClone.data.destBackupset"
									track-field="backupsetId" label="backupsetName"
									tick-property="selected"
									place-holder='<cv:msg key="placeholder.DestinationDatabase" bundle="saphana" />'
									help-text='<cv:msg key="placeholder.DestinationDatabase" bundle="saphana" />'
									required="true"> </cv-isteven-single-select>
							</div>
						</div>
						<!-- // oracle home // -->
						<div data-ng-if="dbClone.isOracleClone" class="form-group"
							title='<cv:msg key="label.oracleHome" bundle="oracle"/>'>
							<label class="col-xs-12 col-sm-5" for="oraHome" id="oraHomeLb">
								<cv:msg key="label.oracleHome" bundle="oracle" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input
										data-ng-disabled="!dbClone.data.instance.isDummyInstance"
										type="text" id="oraHome" name="oraHome" required
										data-ng-model="dbClone.data.cloneEnv.oraHome" />
									<span class="input-group-btn">
										<cv-machine-browse class="upload-button"
											title="<cv:msg key='label.browse' bundle='restore' />"
											id="oracleHomeBrowse" type="button"
											class="btn btn-default setup-btn--hidden float-right"
											client-id='{{dbClone.data.destClient.clientId}}'
											result-function="dbClone.oracleHomeResuleFunction"
											data-ng-click="dbClone.browse('oraHome')"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'>
										</cv-machine-browse>
									</span>
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.oraHome);">
										<cv:msg key="error.oracleHome" bundle="oracle" />
									</span>
								</div>
							</div>
						</div>

						<!-- Access node -->
						<div data-ng-if="dbClone.isOracleClone" class="form-group"
							data-ng-init="dbClone.getAccessNode()">
							<label class="col-xs-12 col-sm-5" for="accessNode"
								id="accessNodeLb">
								<cv:msg key="label.accessNode" bundle="restore" />
								<span class="optional-text">
									<cv:msg key="label.optional" bundle="restore" />
								</span>
							</label>
							<div class="col-xs-12 col-sm-7">
								<cv-isteven-single-select id-name="accessNode"
									input-model="dbClone.linuxMediaAgents"
									binding-model="dbClone.data.accessNode"
									track-field="mediaAgentId" label="displayName"
									tick-property="selected" required="true">
								</cv-isteven-single-select>
							</div>
						</div>
						<div data-ng-if="dbClone.isDB2Clone" class="form-group"
							title='<cv:msg key="label.db2Home" bundle="db2" />'>
							<label class="col-xs-12 col-sm-5" for="db2Home" id="db2HomeLb">
								<cv-help-text help-label="<cv:msg key="label.db2Home" bundle="db2" />" help-text="'<cv:msg key='help.db2Home' bundle='db2' />'"></cv-help-text>
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input type="text" id="db2Home" name="db2Home" required
										data-ng-model="dbClone.data.cloneEnv.db2Home" />
									<span class="input-group-btn">
										<cv-machine-browse class="upload-button"
											title="<cv:msg key='label.browse' bundle='restore' />"
											id="db2HomeBrowse" type="button"
											class="btn btn-default float-right"
											client-id='{{dbClone.data.destClient.clientId}}'
											result-function="dbClone.db2HomeResuleFunction"
											data-ng-click="dbClone.browse('db2Home')"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'>
										</cv-machine-browse>
									</span>
								</div>
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.db2Home);">
									<cv:msg key="error.db2Home" bundle="db2" />
								</span>
							</div>
						</div>
						<!-- // staging path  // -->
						<div class="form-group" data-ng-if="dbClone.isDB2Clone"
							title='{{dbClone.data.cloneEnv.stagingPathLb}}'>
							<label class="col-xs-12 col-sm-5" for="stagingPath" id="stagingPathLb" data-ng-if="dbClone.data.cloneEnv.stagingPathLb" >
								<cv-help-text help-label="{{dbClone.data.cloneEnv.stagingPathLb}}" help-text="'<cv:msg key='help.stagingPath' bundle='db2' />'"></cv-help-text>
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input title="" type="text" id="stagingPath" name="stagingPath"
										required data-ng-model="dbClone.data.cloneEnv.stagingPath" />
									<span class="input-group-btn">
										<cv-machine-browse class="upload-button"
											title="<cv:msg key='label.browse' bundle='restore' />"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'
											client-id='{{dbClone.data.destClient.clientId}}'
											result-function="dbClone.stagingPathResuleFunction">
										</cv-machine-browse>
									</span>
								</div>
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.stagingPath)">
									<cv:msg key="error.snapMountPath" bundle="sqlserver" />
								</span>
							</div>
						</div>
						<!-- // DB2 target database  // -->
						<div class="form-group" data-ng-if="dbClone.isDB2Clone"
							title="<cv:msg key='label.targetDbName' bundle='sqlserver' />">
							<label class="col-xs-12 col-sm-5" for="cloneDbName"
								id="cloneDbNameLb">
								<cv:msg key="label.targetDBName" bundle="db2"/>
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="text" id="cloneDbName" name="cloneDbName" required
									data-ng-model="dbClone.cloneDbName" />
							</div>
						</div>
						<!-- // DB2 user account  // -->
						<div class="form-group" data-ng-if="dbClone.isDB2Clone">
							<label class="col-xs-12 col-sm-12" id="db2UserAccountLb">
								<cv-help-text help-label="<cv:msg key="label.db2UserAccount" bundle="db2" />" help-text="'<cv:msg key="help.db2UserAccount" bundle="db2" />'"></cv-help-text>
							</label>
						</div>
						<div class="form-group" data-ng-if="dbClone.isDB2Clone">
							<div class="col-xs-12 col-sm-5 padding-left-30">
								<input
									placeholder="<cv:msg key="label.userName" bundle="users" />"
									type="text" id="db2Username" name="db2Username" required
									data-ng-model="dbClone.data.db2Username" />
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.db2Username);">
									<cv:msg key="error.userName" bundle="users" />
								</span>
							</div>
							<div class="col-xs-12 col-sm-7">
								<input
									placeholder="<cv:msg key="label.password" bundle="users" />"
									type="password" id="db2UserPassword" name="db2UserPassword"
									required data-ng-model="dbClone.data.db2UserPassword" />
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.db2UserPassword);">
									<cv:msg key="error.password" bundle="users" />
								</span>
							</div>
						</div>
					</div>
					<!-- --End of Destination details-->
					<!-- Destination details options section -->
					<uib-accordion close-others="true" class="text-left">
					<div uib-accordion-group data-is-open="dbClone.openAccordion0">
						<uib-accordion-heading> <span
							data-ng-show="dbClone.isDB2Clone" id="dbCloneLb">
							<cv:msg key="label.rollForward" bundle="db2" />
						</span> <span data-ng-hide="dbClone.isDB2Clone" id="recoverOptionsLb">
							<cv:msg key="label.recoverOptions" bundle="databaseClone" />
						</span> <i class="float-right glyphicon"
							data-ng-class="{'glyphicon-chevron-down': dbClone.openAccordion0, 'glyphicon-chevron-right': !dbClone.openAccordion0}"></i>
						</uib-accordion-heading>
						<div class="form-group"
							data-ng-if="dbClone.isDB2Clone || dbClone.isSqlClone || dbClone.isOracleClone || dbClone.isPostgresClone || dbClone.isMySqlClone">
							<div class="col-xs-12">
								<input type="radio"
									data-ng-model="dbClone.data.cloneEnv.pitType"
									data-ng-click="dbClone.timeSelectionChange(dbClone.data.cloneEnv.pitType)"
									value="0" id="mostRecent" name="mostRecent" />
								<label for="mostRecent" id="mostRecentLb">
									<span data-ng-show="dbClone.isDB2Clone">
										<cv:msg key="label.toEndOfLogs" bundle="db2" />
									</span>
									<span data-ng-hide="dbClone.isDB2Clone">
										<cv:msg key="label.mostRecent" bundle="oracle" />
									</span>
								</label>
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12 col-sm-5">
								<input type="radio" id="pitDateBtn"
									data-ng-model="dbClone.data.cloneEnv.pitType"
									data-ng-click="dbClone.timeSelectionChange(dbClone.data.cloneEnv.pitType)"
									value="1" id="pitDate" name="pitDate" />
								<label for="pitDate" id="pitDateLb">
									<cv:msg key="label.pit" bundle="oracle" />
								</label>
							</div>
							<div class="col-xs-12 col-sm-7"
								data-ng-disabled="dbClone.data.cloneEnv.pitType == '0'">
								<cv-date-time-picker
									date-time-Value="dbClone.data.cloneEnv.toTime"
									max-date="dbClone.data.cloneEnv.maxPit"></cv-date-time-picker>
								<span class="help-block" data-ng-if="dbClone.pitInvalid"
									data-ng-bind="dbClone.pitErrorMsg"> </span>
							</div>
						</div>

						<div class="form-group" data-ng-if="dbClone.showSnapJobCheckError">
							<div class="col-xs-12 col-sm-12 help-block">
								<cv:msg key="error.no.valid.backupJob.for.instant.clone"
									bundle="sqlserver" />
							</div>
						</div>

						<div class="form-group" data-ng-if="dbClone.isSAPHANAClone">
							<div class="col-xs-12 col-sm-5">
								<input type="radio" id="useBackupPrefix"
									data-ng-model="dbClone.data.cloneEnv.pitType"
									data-ng-click="dbClone.timeSelectionChange(dbClone.data.cloneEnv.pitType)"
									value="3" id="pitBackupPrefix" name="mostRecent" />
								<label for="pitBackupPrefix" id="useBackupPrefixLb">
									<cv:msg key="label.useBackupPrefix" bundle="saphana" />
								</label>
							</div>
							<div class="col-xs-12 col-sm-7">
								<input type="text"
									data-ng-model="dbClone.data.cloneEnv.useBackupPrefix"
									data-ng-required="dbClone.data.cloneEnv.pitType == '3' "
									id="useBackupPrefix" name="useBackupPrefix" />
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.useBackupPrefix);">
									<cv:msg key="error.BackupPrefix" bundle="saphana" />
								</span>
							</div>
						</div>
						<div class="form-group" data-ng-if="dbClone.isSAPHANAClone">
							<div class="col-xs-12 col-sm-5">
								<input type="radio"
									data-ng-model="dbClone.data.cloneEnv.pitType" value="4"
									id="pitInternalId" name="mostRecent" />
								<label for="pitInternalId" id="pitInternalId">
									<cv:msg key="label.useingInternalId" bundle="saphana" />
								</label>
							</div>
							<div class="col-xs-12 col-sm-7">
								<input type="text"
									data-ng-model="dbClone.data.cloneEnv.useInternalId"
									data-ng-required="dbClone.data.cloneEnv.pitType == '4' "
									id="useInternalId" name="useInternalId" />
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.useInternalId);">
									<cv:msg key="error.BackupId" bundle="saphana" />
								</span>
							</div>
						</div>
						<div class="form-group" data-ng-if="dbClone.isSAPHANAClone">
							<div class="col-xs-12">
								<toggle-control
									status="dbClone.data.restoreCatalog==true?'enabled-activity':'disabled-activity'"
									data-ng-click="dbClone.restoreCatalogSelected()"
									id="restoreCatalog" name="restoreCatalog"
									title="<cv:msg key="label.restoreCatalogTime" bundle="saphana"/>">
								</toggle-control>
								<label for="restoreCatalog"
									title="<cv:msg key="label.restoreCatalogTime" bundle="saphana"/>">
									<cv:msg key="label.restoreCatalogTime" bundle="saphana" />
								</label>
							</div>
						</div>
						<div class="form-group" data-ng-if="dbClone.data.restoreCatalog">
							<div class="col-xs-12 col-sm-6 padding-left-50">
								<input type="radio" id="rcPointInTime" name="rcPointInTime"
									data-ng-model="dbClone.data.restoreCatalogType" value="1" />
								<label for="rcPointInTime"
									title="<cv:msg key="label.PointInTime" bundle="saphana"/>">
									<cv:msg key="label.PointInTime" bundle="saphana" />
								</label>
							</div>
							<div class="col-xs-12 col-sm-6"
								data-ng-disabled="dbClone.data.restoreCatalogType!=1">
								<cv-date-time-picker picker-id="RestoreCtl"
									max-date="dbClone.data.maxPit"
									date-time-Value="dbClone.data.restoreCatalogTime"></cv-date-time-picker>
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.dateTimeValueRestoreCtl) || pitRestoreCtlError">
									<cv:msg key="error.pit" bundle="oracle" />
								</span>
							</div>
						</div>
						<div class="form-group" data-ng-if="dbClone.data.restoreCatalog">
							<div class="col-xs-12 col-sm-6 padding-left-50">
								<input id="relativeToSysdate" name="relativeToSysdate"
									type="radio" data-ng-model="dbClone.data.restoreCatalogType"
									value="0" />
								<label for="relativeToSysdate">
									<cv:msg key="label.relativeToSysdate" bundle="saphana" />
								</label>
							</div>
							<div class="col-xs-12 col-sm-2"
								data-ng-disabled="dbClone.data.restoreCatalogType!=0">
								<input type="number" id="relativeToSysdateValue"
									name="relativeToSysdateValue" max="1000" min="1"
									data-ng-model="dbClone.data.relativeToSysdateValue"
									data-ng-required="dbClone.data.restoreCatalogType==0 " />
							</div>
							<div class="col-xs-12 col-sm-3"
								data-ng-disabled="dbClone.data.restoreCatalogType!=0">
								<select id="relativeToSysdateDays" name="relativeToSysdateDays"
									data-ng-model="dbClone.data.relativeToSysdateDays"
									data-ng-options="dayNode as dayNode for dayNode in dbClone.dayTypeList">
								</select>
							</div>
							<span class="help-block"
								data-ng-show="cv.wizardForm.needsAttention(wizardForm.relativeToSysdate)">
								<cv:msg key="error.BackupPrefix" bundle="saphana" />
							</span>
						</div>
					</div>
					<div uib-accordion-group data-is-open="dbClone.openAccordion1"
						data-ng-hide="dbClone.isSAPHANAClone || dbClone.isDB2Clone || dbClone.isSqlClone">
						<uib-accordion-heading id="destOptionsLb">
						<cv:msg key="label.destOptions" bundle="databaseClone" /> <i
							class="float-right glyphicon"
							data-ng-class="{'glyphicon-chevron-down': dbClone.openAccordion1, 'glyphicon-chevron-right': !dbClone.openAccordion1}"></i>
						</uib-accordion-heading>
						<!-- ------------------------------------ -->
						<!-- Start of advanced options for Oracle -->
						<!-- ------------------------------------ -->
						<!-- // PFile  // -->
						<div data-ng-if="dbClone.isOracleClone" class="form-group"
							id="pFileTitleLb"
							title='<cv:msg key="label.pFile" bundle="oracle"/>'>
							<label class="col-xs-12 col-sm-5" for="oraPfile" id="pFileLb">
								<cv:msg key="label.pFile" bundle="oracle" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input type="text" id="oraPfile" name="oraPfile"
										data-ng-model="dbClone.data.cloneEnv.oraPfile"
										placeholder="<cv:msg key="label.optional" bundle="oracle"/>" />
									<span class="input-group-btn" id="upLoadBtn">
										<cv-machine-browse class="upload-button"
											title="<cv:msg key='label.browse' bundle='restore' />"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'
											client-id='{{dbClone.data.destClient.clientId}}'
											folders-only="false"
											result-function="dbClone.oraPfileResuleFunction">
										</cv-machine-browse>
									</span>
								</div>
							</div>
						</div>
						<!-- // staging path for Oracle  // -->
						<div data-ng-if="dbClone.isOracleClone" class="form-group"
							id="stagingPathTitleLb"
							title='<cv:msg key="label.stagingPath" bundle="oracle"/>'>
							<label class="col-xs-12 col-sm-5" for="stagingPath"
								id="stagingPathLb">
								<span title='<cv:msg key="label.stagingPath" bundle="oracle"/>'>
									<cv:msg key="label.stagingPath" bundle="oracle" />
								</span>
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input type="text" id="stagingPath" name="stagingPath"
										data-ng-model="dbClone.data.cloneEnv.stagingPath"
										placeholder="<cv:msg key="label.optional" bundle="oracle"/>" />
									<span class="input-group-btn" id="uploadBtn2">
										<cv-machine-browse class="upload-button"
											title="<cv:msg key='label.browse' bundle='restore' />"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'
											client-id='{{dbClone.data.destClient.clientId}}'
											result-function="dbClone.stagingPathResuleFunction">
										</cv-machine-browse>
									</span>
								</div>
							</div>
						</div>
						<!-- // PGA SGA size // -->
						<div data-ng-if="dbClone.isOracleClone" class="form-group"
							id="pgaSgaSizeLb"
							title='<cv:msg key="label.pgaSgaSize" bundle="oracle"/>'>
							<label class="col-xs-12 col-sm-5" for="pgaSgaSize">
								<cv:msg key="label.pgaSgaSize" bundle="oracle" />
								<cv-help-component
									help-text="<cv:msg key="help.pgaSgaSize" bundle="oracle"/>"></cv-help-component>
							</label>
							<div class="col-xs-12 col-sm-7">
								<input class="form-group" type="number" id="pgaSgaSize"
									name="pgaSgaSize" min="1" max="1000000"
									data-ng-model="dbClone.data.cloneEnv.pgaSgaSize"
									placeholder="<cv:msg key="label.optional" bundle="oracle"/>" />
								<span class="help">
									<cv:msg key="size.mb" bundle="facets" />
								</span>
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.pgaSgaSize)">
									<cv:msg key="error.invalidNumber" bundle="oracle" />
								</span>
							</div>
						</div>
						<!-- // REDO log size // -->
						<div data-ng-if="dbClone.isOracleClone" class="form-group"
							id="redoLogSizeTitleLb"
							title='<cv:msg key="label.redoLogSize" bundle="oracle"/>'>
							<label class="col-xs-12 col-sm-5" for="redoLogSize"
								id="redoLogSizeLb">
								<cv:msg key="label.redoLogSize" bundle="oracle" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<input class="form-group" type="number" id="redoLogSize"
									name="redoLogSize" min="1" max="1000000"
									data-ng-model="dbClone.data.cloneEnv.redoLogSize"
									placeholder="<cv:msg key="label.optional" bundle="oracle"/>" />
								<span class="help">
									<cv:msg key="size.mb" bundle="facets" />
								</span>
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.redoLogSize)">
									<cv:msg key="error.invalidNumber" bundle="oracle" />
								</span>
							</div>
						</div>
						<!-- // Migrate DB to production storage // -->
						<div
							data-ng-if="dbClone.isOracleClone && dbClone.isASMStorageType"
							class="form-group" id="migrateDbToProdStorageTitleLb"
							title='<cv:msg key="label.migrateDbToProdStorage" bundle="oracle"/>'>
							<div class="col-xs-12">
								<input type="checkbox" id="migrateDbToProdStorage"
									data-ng-model="dbClone.data.cloneEnv.migrateToProdStorage"></input>
								<label for="migrateDbToProdStorage"
									id="migrateDbToProdStorageLb">
									<cv:msg key="label.migrateDbToProdStorage" bundle="oracle" />
								</label>
							</div>
						</div>
						<!-- // Disk mapping file // -->
						<div
							data-ng-if="dbClone.isOracleClone && dbClone.data.cloneEnv.migrateToProdStorage"
							class="form-group" id="diskMappingFileTitleLb"
							title='<cv:msg key="label.diskMappingFile" bundle="oracle"/>'>
							<label class="col-xs-12 col-sm-5" for="diskMappingFile"
								id="diskMappingFileLb">
								<span>
									<cv:msg key="label.diskMappingFile" bundle="oracle" />
									<cv-help-component
										help-text="<cv:msg key="help.diskMappingFile" bundle="oracle"/>"></cv-help-component>
								</span>
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input type="text" id="diskMappingFile" name="diskMappingFile"
										data-ng-model="dbClone.data.cloneEnv.diskMappingFile" required />
									<span class="input-group-btn" id="uploadBtn3">
										<cv-machine-browse class="upload-button"
											title="<cv:msg key='label.browse' bundle='restore' />"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'
											client-id='{{dbClone.data.destClient.clientId}}'
											result-function="dbClone.diskMappingFileResultFunction">
										</cv-machine-browse>
									</span>
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.diskMappingFile)">
										<cv:msg key="error.diskMappingFile" bundle="oracle" />
									</span>
								</div>
							</div>
						</div>
						<!-- ------------------------------------ -->
						<!-- End of advanced options for Oracle   -->
						<!-- ------------------------------------ -->
						<!-- PostgreSQL and MYSQL options START -->
						<span data-ng-if="dbClone.isPostgresClone || dbClone.isMySqlClone">
							<div class="form-group" id="cloneDirTitleLb"
								title='<cv:msg key="label.cloneDir" bundle="oracle" />'>
								<label class="col-xs-12 col-sm-5" for="cloneDir" id="cloneDirLb">
									<cv:msg key="label.cloneDir" bundle="oracle" />
								</label>
								<div class="col-xs-12 col-sm-7">
									<div class="input-group"
										title="{{dbClone.data.cloneEnv.stagingPath}}">
										<input type="text" name="cloneDir" id="cloneDir"
											data-ng-model="dbClone.data.cloneEnv.stagingPath"
											data-ng-required="true" />
										<span class="input-group-btn">
											<cv-machine-browse
												button-label='<cv:msg key="label.browse" bundle="restore"/>'
												client-id='{{dbClone.data.destClient.clientId}}'
												result-function="dbClone.pgCloneBrowseFunction">
											</cv-machine-browse>
										</span>
									</div>
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.cloneDir)">
										<cv:msg key="error.CloneworkingDir" bundle="postgres" />
									</span>
								</div>
							</div>
							<div class="form-group" id="BinaryDirectoryTitleLb"
								title='<cv:msg key="label.BinaryDirectory" bundle="postgres" />'>
								<label class="col-xs-12 col-sm-5" for="pgBinDir"
									id="BinaryDirectoryLb">
									<cv:msg key="label.BinaryDirectory" bundle="postgres" />
								</label>
								<div class="col-xs-12 col-sm-7"
									data-ng-disabled="!dbClone.data.instance.isDummyInstance">
									<div class="input-group"
										title="{{dbClone.data.instance.BinaryDirectory}}">
										<input type="text" name="pgBinDir" id="BinaryDirectoryLb"
											data-ng-model="dbClone.data.instance.BinaryDirectory"
											data-ng-required="true" />
										<span class="input-group-btn" id="browseBtn">
											<cv-machine-browse
												button-label='<cv:msg key="label.browse" bundle="restore"/>'
												client-id='{{dbClone.data.destClient.clientId}}'
												result-function="dbClone.pgBinBrowseFunction"
												can-create-folder="false"> </cv-machine-browse>
										</span>
									</div>
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.pgBinDir)">
										<cv:msg key="error.BinaryDirectory1" bundle="postgres" />
									</span>
								</div>
							</div>
							<div class="form-group" data-ng-if="dbClone.isPostgresClone"
								id="LibDirectoryTitleLb"
								title='<cv:msg key="label.LibDirectory" bundle="postgres" />'>
								<label class="col-xs-12 col-sm-5" for="pgLibDir"
									id="LibDirectoryLb">
									<cv:msg key="label.LibDirectory" bundle="postgres" />
								</label>
								<div class="col-xs-12 col-sm-7"
									data-ng-disabled="!dbClone.data.instance.isDummyInstance">
									<div class="input-group" id="pgLibDirTitleLb"
										title="{{dbClone.data.instance.LibDirectory}}">
										<input type="text" name="pgLibDir" id="pgLibDir"
											data-ng-model="dbClone.data.instance.LibDirectory"
											data-ng-required="true" />
										<span class="input-group-btn" id="browseBtn2">
											<cv-machine-browse
												button-label='<cv:msg key="label.browse" bundle="restore"/>'
												client-id='{{dbClone.data.destClient.clientId}}'
												result-function="dbClone.pgLibBrowseFunction"
												can-create-folder="false"> </cv-machine-browse>
										</span>
									</div>
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.pgLibDir)">
										<cv:msg key="error.LibDirectory" bundle="postgres" />
									</span>
								</div>
							</div>
							<div class="form-group" id="hanaDBUsernameTitle"
								title='<cv:msg key="label.hanaDBUsername" bundle="saphana" />'>
								<label class="col-xs-12 col-sm-5" for="userName"
									id="hanaDBUsernameLb">
									<cv:msg key="label.hanaDBUsername" bundle="saphana" />
								</label>
								<div class="col-xs-12 col-sm-7"
									data-ng-disabled="!dbClone.data.instance.isDummyInstance">
									<input type="text" name="userName" id="userName"
										data-ng-model="dbClone.data.instance.userName"
										data-ng-required="true" />
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.userName)">
										<cv:msg key="error.DbUsername" bundle="saphana" />
									</span>
								</div>
							</div>
							<div class="form-group" id="portTitle"
								title='<cv:msg key="label.Port" bundle="postgres" />'>
								<label class="col-xs-12 col-sm-5" for="port" id="portLb">
									<cv:msg key="label.Port" bundle="postgres" />
								</label>
								<div class="col-xs-12 col-sm-7">
									<input type="text" name="port" data-ng-model="dbClone.pgPort"
										data-ng-required="true" id="pgPort" />
									<span class="help-block"
										data-ng-show="cv.wizardForm.needsAttention(wizardForm.port)">
										<cv:msg key="error.Port1" bundle="postgres" />
									</span>
								</div>
							</div>
						</span>
						<!-- PostgreSQL and MYSQL options END -->
					</div>
					<!-- --End of Destination details options section --> <!-- Clone options section -->
					<div uib-accordion-group data-is-open="dbClone.openAccordion2">
						<uib-accordion-heading id="cloneOptionsTitle">
						<cv:msg key="label.cloneOptions" bundle="databaseClone" /> <i
							class="float-right glyphicon"
							data-ng-class="{'glyphicon-chevron-down': dbClone.openAccordion2, 'glyphicon-chevron-right': !dbClone.openAccordion2}"></i>
						</uib-accordion-heading>
						<!-- // staging path  // -->
						<div class="form-group" data-ng-if="dbClone.isSAPHANAClone"
							id="snapMountLocationTitle"
							title='<cv:msg key="label.snapMountLocation" bundle="databaseClone" />'>
							<div class="col-xs-12 col-sm-5" for="stagingPath"
								id="snapMountLocationLb">
								<cv:msg key="label.snapMountLocation" bundle="databaseClone" />
								<span class="optional-text">
									<cv:msg key="label.optional" bundle="oracle" />
								</span>
							</div>
							<div class="col-xs-12 col-sm-6">
								<input title="" type="text" id="stagingPath" name="stagingPath"
									data-ng-model="dbClone.data.cloneEnv.stagingPath" />
								<span class="help-block"
									data-ng-show="cv.wizardForm.needsAttention(wizardForm.stagingPath)">
									<span>
										<cv:msg key="error.snapMountPath" bundle="sqlserver" />
									</span>
								</span>
							</div>
							<div class="col-xs-12 col-sm-1">
								<cv-machine-browse id="upLoadBtn4"
									data-ng-disabled="dbClone.data.instance == null || dbClone.data.instance.physicalClient.clientId == null"
									class="upload-button"
									title="<cv:msg key='label.browse' bundle='restore' />"
									button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{dbClone.data.instance.physicalClient.clientId}}'
									result-function="dbClone.stagingPathResuleFunction">
								</cv-machine-browse>
							</div>
						</div>
						<!--  Clone reservation  -->
						<div class="form-group">
							<label class="col-xs-12 col-sm-5" for="rsvTPDays"
								id="cloneReservationLb">
								<cv:msg key="label.cloneReservation" bundle="oracle" />
							</label>
							<div class="col-xs-12 col-sm-4">
								<input type="number" id="rsvTPDays" min="0" name="rsvTPDays"
									data-ng-model="dbClone.data.cloneEnv.rsvTPDays"
									data-ng-change="dbClone.validateValue()" />
								<label for="rsvTPDays" class="inline-block" id="rsvTPDaysLb">
									<cv:msg key="days" bundle="messagesJs" />
								</label>
							</div>
							<div class="col-xs-12 col-sm-3" data-ng-if="!dbClone.isSqlClone">
								<input type="number" id="rsvTPHours" min="0" name="rsvTPHours"
									data-ng-model="dbClone.data.cloneEnv.rsvTPHours"
									data-ng-change="dbClone.validateValue()" />
								<label for="rsvTPHours" class="inline-block" id="rsvTPHoursLb">
									<cv:msg key="hours" bundle="messagesJs" />
								</label>
							</div>
							<span class="help-block"
								data-ng-show="cv.wizardForm.needsAttention(wizardForm.rsvTPDays) || (!dbClone.isSqlClone && cv.wizardForm.needsAttention(wizardForm.rsvTPHours)) || dbClone.errors.rsvTPDays">
								<cv:msg key="error.rsvTime" bundle="databaseClone" />
							</span>
						</div>
						<!--  Copy precedence
			<div data-ng-hide="dbClone.isSqlClone" class="form-group ">
				<label class="col-xs-12 col-lg-4" for="copyPrec">
					<cv:msg key="label.copyPrec" bundle="oracle"/>
				</label>
				<div class="col-xs-12 col-lg-3">
					<input  type="number" id="copyPrec" name="copyPrec" data-ng-model="dbClone.data.cloneEnv.copyPrec" min="0" />
				</div>
			</div>
			-->
						<cv-copy-precedence data-ng-if="dbClone.showCopyPrecedence"
							entity-type='dbClone.entityType' entity-id='dbClone.entityId'
							label='<cv:msg key="label.cloneFromCopy" bundle="restore"/>'
							copy-precedence-int='dbClone.data.cloneEnv.copyPrec'></cv-copy-precedence>
						<!-- toggleButton  -->
						<div data-ng-if="dbClone.showISCSIServer" class="form-group"
							data-ng-init="dbClone.loadMediaAgents()">
							<label class="col-xs-12 col-sm-5" for="accessNode"
								id="accessNodeLb">
								<cv-help-text help-label="<cv:msg key="label.useiSCSIServer" bundle="databaseClone" />" help-text="'<cv:msg key="help.useiSCSIServer" bundle="db2" />'"></cv-help-text>
								<span class="optional-text">
									<cv:msg key="label.optional" bundle="restore" />
								</span>
							</label>
							<div class="col-xs-12 col-sm-7">
								<cv-isteven-single-select id-name="iSCSIServerList"
									input-model="dbClone.mediaAgents"
									binding-model="dbClone.data.iSCSIServer"
									track-field="mediaAgentId" label="displayName"
									prevent-sort="true" tick-property="selected">
								</cv-isteven-single-select>
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12">
								<toggle-control id="forceCleanupToggle" id="databaseClone_unconditionOverrideToggle"
									status="dbClone.data.cloneEnv.forceCleanup==true?'enabled-activity':'disabled-activity'"
									data-ng-click="dbClone.data.cloneEnv.forceCleanup = !dbClone.data.cloneEnv.forceCleanup"
									title="{{dbClone.forceCleanupLabel}}"> </toggle-control>
								<span data-ng-bind="dbClone.forceCleanupLabel"></span>
							</div>
						</div>
						</br>
						<div class="form-group" data-ng-if="dbClone.isSqlClone">
							<div class="col-xs-12 col-md-5 col-lg-12">
								<toggle-control id="databaseClone_enableLogReplayToggle"
									status="dbClone.data.cloneEnv.enableLogReplay==true?'enabled-activity':'disabled-activity'"
									data-ng-click="dbClone.data.cloneEnv.enableLogReplay = !dbClone.data.cloneEnv.enableLogReplay"
									title="<cv:msg key="label.applyLogPlay" bundle="databaseClone" />">
								</toggle-control>
								<cv:msg key="label.applyLogPlay" bundle="databaseClone" />
							</div>
						</div>
						<cv-data-masking
							data-ng-if="dbClone.showDataMasking() && dbClone.instanceDetails"
							instance-id="dbClone.instanceId" is-stand-alone="false"
							masking-options="dbClone.data.dataMaskingOptions">
						</cv-data-masking>
					</div>
					<div uib-accordion-group data-is-open="dbClone.openAccordion3"
						data-ng-hide="dbClone.isSAPHANAClone || dbClone.isSqlClone">
						<uib-accordion-heading id="postCloneOperTitle">
						<cv:msg key="label.postCloneOper" bundle="databaseClone" /> <i
							class="float-right glyphicon"
							data-ng-class="{'glyphicon-chevron-down': dbClone.openAccordion3, 'glyphicon-chevron-right': !dbClone.openAccordion3}"></i>
						</uib-accordion-heading>
						<div class="form-group ">
							<label class="col-xs-12 col-sm-5" for="commondFilePath"
								id="cmdFilePathLb">
								<cv:msg key="label.cmdFilePath" bundle="databaseClone" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<div class="input-group">
									<input type="text" id="commondFilePath" name="commondFilePath"
										data-ng-model="dbClone.data.commondFilePath" />
									<span class="input-group-btn">
										<cv-machine-browse id="browseBtn3"
											button-label='<cv:msg key="label.browse" bundle="restore"/>'
											folders-only="false"
											client-id='{{dbClone.data.destClient.clientId}}'
											result-function="dbClone.commondFilePathResuleFunction"
											class="upload-button"> </cv-machine-browse>
									</span>
								</div>
							</div>
						</div>
					</div>
					</uib-accordion>
				</div>
				<!-- --End of Clone options section -->
			</div>
		</div>
		<div data-ng-show="dbClone.sourceSelected">
			<div class="modal-footer">
				<button id="databaseCloneModal_button_#7835" type="button"
					class="btn btn-default cvBusyOnAjax"
					data-ng-click="dbClone.cancel()">
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="databaseCloneModal_button_#1507" type="submit"
					class="btn btn-primary cvBusyOnAjax">
					<span>
						<cv:msg key="OK" bundle="messages" />
					</span>
				</button>
			</div>
		</div>
	</form>
</div>
