import 'adminConsole/js/filters/clients.filters.js';
import 'vsa/js/controllers/collections.ctrl.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'jobs/js/services/jobs.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/services/restore.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'modules/ida/js/directives/cvDataMasking.js';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'sql/js/services/sqlRecoveryPoints.svc.js';
import 'sql/js/factory/sqlServer.fac.js';

import { acAppInstanceModule } from 'common/js/modules';
var app = acAppInstanceModule;

app.controller('dbCloneModalController', [
	'storageService',
	'mbService',
	'dbServerService',
	'data',
	'$uibModalInstance',
	'$log',
	'agentService',
	'cvLoc',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'$scope',
	'$state',
	'restoreForAgents',
	'$timeout',
	'cvTableOptions',
	'idaService',
	'cvUtil',
	'jobService',
	'$filter',
	'sqlService',
	'AppTypes',
	'sqlRecoveryPointsService',
	'sqlServerFactory',
	'instanceService',
	function(
		storageService,
		mbService,
		dbServerService,
		data,
		$uibModalInstance,
		$log,
		agentService,
		cvLoc,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		$scope,
		$state,
		restoreForAgents,
		$timeout,
		cvTableOptions,
		idaService,
		cvUtil,
		jobService,
		$filter,
		sqlService,
		AppTypes,
		sqlRecoveryPointsService,
		sqlServerFactory,
		instanceService
	) {
		var self = this;
		var PIT = '1';
		var LATEST_SCN_NUMBER = 4;

		self.showSourceSelection = !data.entity.clientId;
		self.sourceSelected = false;

		function init() {
			/* If source is given go as the orginal flow */
			if (!self.showSourceSelection) {
				initAfterSourceSelected();
			} else {
				/* else need to show source selection first */
				self.sourceData = {
					sourceClient: {},
					sourceInstance: {}
				};

				self.sourceClientList = [];
				self.sourceInstanceList = [];
				self.sourceDbList = [];
				self.isDB2Clone =
					data.entity.applicationId === AppTypes.DB2 || data.entity.applicationId === AppTypes.DB2_On_Unix;
				self.isSqlClone = data.entity.applicationId === AppTypes.SQL_SERVER;
				self.showSourceDB = self.isDB2Clone || self.isSqlClone;
				self.isMySqlClone = data.entity.applicationId === AppTypes.MYSQL;
				self.isPostgresClone = data.entity.applicationId === AppTypes.POSTGRESQL;
				//For Oracle, RAC, SAP HANA, DB2 source client name is display name
				self.srcLabel = 'clientName';

				//For PostgreSQL and MySQL clone is supported for Unix Clients
				if (self.isMySqlClone || self.isPostgresClone) {
					self.srcLabel = 'displayName';
					setPgClientList(false);
				} else {
					/* Get list of all applicable/restorable clients */
					let isSnapEnabled = true;
					if (data.entity.applicationId === AppTypes.ORACLE || data.entity.applicationId === AppTypes.ORACLE_RAC) {
						isSnapEnabled = false;
					}
					dbServerService
						.getSourceClientsForRestore(data.entity.applicationId, isSnapEnabled)
						.success(function(data) {
							self.sourceClientList = data.records;
						})
						.error(function(e) {
							$scope.serverMessage = cvUtil.errMsg(e);
						});
				}

				/* Use instances listing page to get the clients and instances */
				self.sourceClientChanged = function() {
					self.sourceData.sourceInstance = undefined;
					self.sourceSelected = false;
					self.sourceInstanceList = undefined;

					if (self.sourceData.sourceClient && self.sourceData.sourceClient.clientId > 0) {
						/* Get list of all applicable/restorable instances */
						dbServerService
							.getSourceInstancesForRestore(self.sourceData.sourceClient.clientId, data.entity.applicationId, true)
							.success(function(data) {
								self.sourceInstanceList = data.records;
								if (self.sourceInstanceList.length === 1) {
									self.sourceData.sourceInstance = self.sourceInstanceList[0];
									self.sourceInstanceChanged();
								}
							})
							.error(function(e) {
								$scope.serverMessage = cvUtil.errMsg(e);
							});
					}
				};

				self.sourceInstanceChanged = function() {
					if (self.sourceData.sourceInstance && self.sourceData.sourceInstance.instanceId > 0) {
						self.sourceDbList = undefined;
						if (
							(data.entity.applicationId === AppTypes.SAP_HANA && self.sourceData.sourceInstance.clientType === 1) ||
							self.isSqlClone
						) {
							self.showSourceDB = true;
						}
						if (self.showSourceDB) {
							if (self.isSqlClone) {
								dbServerService.getSqlServerBackedUpDatabases(
									self.sourceData.sourceInstance.instanceId,
									this.loadSqlBackedUpDatabases.bind(this),
									this.onRetrieveSqlBackedUpDatabasesError.bind(this)
								);
							} else {
								idaService
									.getChildranData('BACKUPSET_ENTITY', self.sourceData.sourceInstance)
									.success(this.loadSourceBackupsets.bind(this));
							}
						} else {
							data.entity = angular.copy(self.sourceData.sourceInstance);
							initAfterSourceSelected();
						}
					}
				};
				self.loadSourceBackupsets = function(data) {
					if (data) {
						let backupsetList = [];
						data.forEach(backupsetNode => {
							var backupSetEntity = backupsetNode.backupSetEntity;
							backupSetEntity.itemDisable = false;
							if (backupSetEntity.applicationId === AppTypes.SAP_HANA && backupSetEntity.backupsetName === 'SYSTEMDB') {
								backupSetEntity.itemDisable = true;
							}
							backupsetList.push(backupSetEntity);
						});
						self.sourceDbList = backupsetList;
					}
				};
				self.loadSqlBackedUpDatabases = function(data) {
					if (data && data.SqlDatabase) {
						let databaseList = [];
						data.SqlDatabase.forEach(db => {
							databaseList.push({
								applicationId: AppTypes.SQL_SERVER,
								databaseId: db.dbId,
								databaseName: db.dbName,
								clientId: db.cId,
								clientName: db.cName,
								instanceId: db.insId,
								instanceName: db.insName
							});
						});
						self.sourceDbList = databaseList;
					}
				};
				self.onRetrieveSqlBackedUpDatabasesError = function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				};
				self.sourceDBChanged = function() {
					self.showSnapJobCheckError = false;
					data.entity = angular.copy(self.sourceData.sourceDb);

					if (self.isSqlClone) {
						self.sqlRestoreOpts = {
							sourceItems: [self.sourceData.sourceDb],
							destinationInstance: null,
							destinationClient: null,
							destinationDatabase: null,
							sqlClientInstanceMap: new Map(),
							sqlDbDeviceItems: null,
							phyfileRename: [], //used by clone only
							logfileRename: [],
							instance: null,
							serverMessage: null
						};

						self.sqlRestoreOpts.destinationDatabase = angular.copy(self.sqlRestoreOpts.sourceItems[0]);

						const date = new Date();
						const month = date.getMonth() + 1;

						self.sqlRestoreOpts.destinationDatabase.databaseName =
							self.sqlRestoreOpts.destinationDatabase.databaseName +
							'-' +
							month +
							'-' +
							date.getDate() +
							'-' +
							date.getFullYear() +
							'-' +
							date.getMilliseconds();

						self.readyToLoadSqlDestination = true;
					}
					initAfterSourceSelected();
				};
			}
		}

		function setPgClientList(isDestination) {
			let entity = {
				applicationId: data.entity.applicationId,
				osType: 'Unix'
			};
			let genericEntity = angular.toJson(entity);
			idaService.getRestoreDestinationsForEntity(genericEntity).then(
				function(result) {
					let serverList = [];
					for (let i = 0; i < result.data.length; i++) {
						let dispalyName1 = _.get(result.data[i], 'displayName', result.data[i].clientName);
						let client = {
							clientId: result.data[i].clientId,
							clientName: result.data[i].clientName,
							displayName: dispalyName1,
							applicationId: result.data[i].applicationId
						};
						serverList.push(client);
					}
					//Remove duplicate entries from client list
					serverList = _.uniqWith(serverList, _.isEqual);
					//sort by client name
					serverList = cvUtil.sortAscending(serverList, 'displayName');
					if (isDestination) {
						self.clientsList = angular.copy(serverList);
						for (let i = 0; i < self.clientsList.length; i++) {
							if (self.clientId == self.clientsList[i].clientId) {
								self.data.destClient = self.clientsList[i];
								break;
							}
						}
						if (self.data.destClient == null) {
							self.data.destClient = self.clientsList[0];
						}
						self.destClientChanged(self.data.destClient);
					} else {
						self.sourceClientList = angular.copy(serverList);
					}
				},
				function(e) {
					$log.error(e);
				}
			);
		}

		function setsubclientInfo() {
			//Load subclient data for MySQL
			if (self.isMySqlClone || self.isPostgresClone) {
				//if source subclient is already set then skip subclients loading
				let subclientId = _.get(self.sourceEntity, 'subclientId', 0);
				if (subclientId > 0) return;
				idaService.getChildranData('SUBCLIENT_ENTITY', self.entity).success(function(data) {
					if (data.length > 0) {
						//default we are setting first subcient as source entity
						self.sourceEntity = data[0].subClientEntity;
						let subclientFlag = 0;
						let isSnapSubclient = false;
						for (let i = 0; i < data.length; i++) {
							subclientFlag = _.get(data[i], 'postgreSQLSubclientProp.subclientTypeFlag', 0);
							isSnapSubclient = _.get(data[i], 'commonProperties.snapCopyInfo.isSnapBackupEnabled', false);
							if (subclientFlag > 0 || isSnapSubclient) {
								self.sourceEntity = data[i].subClientEntity;
								break;
							}
						}
					}
				});
			}
		}

		function initAfterSourceSelected() {
			self.sourceSelected = true;
			self.dayTypeList = [cvLoc('label.day'), cvLoc('label.hours')];
			self.data = {
				destClient: null,
				instanceNameText: null,
				commondFilePath: null,
				databases: null,
				jobsPage: null,
				selectedJob: null,
				orclInstance: {},
				restoreCatalog: false,
				relativeToSysdateValue: 2,
				relativeToSysdateDays: self.dayTypeList[0],
				restoreCatalogType: '1',
				dataMaskingOptions: {},
				iSCSIServer: null,
				cloneEnv: {
					cloneType: 'INSTANCESNAP',
					instanceId: undefined,
					oraHome: undefined,
					oraUser: undefined,
					oraPfile: undefined,
					forceCleanup: false,
					enableLogReplay: false,
					resrvTimePeriod: 0,
					rsvTPDays: 7,
					rsvTPHours: 0,
					stagingPath: undefined,
					copyPrec: 0,
					pitType: '0',
					fromTime: null,
					toTime: null
				}
			};

			self.forceCleanupLabel = self.isSqlClone ? cvLoc('label.unconditionOver') : cvLoc('label.overfideExists');

			self.title = cvLoc('label.dbClone');
			self.entity = data.entity;
			self.sourceEntity = angular.copy(self.entity);
			self.clientId = data.entity.clientId;
			self.instanceId = data.entity.instanceId;
			self.applicationId = data.entity.applicationId;
			self.showCopyPrecedence = false;
			self.entityType = 'INSTANCE_ENTITY';
			self.entityId = 0;
			self.instanceNameSize = 8;
			self.showISCSIServer = false;

			if (
				self.sourceEntity.applicationId === AppTypes.MYSQL ||
				self.sourceEntity.applicationId === AppTypes.POSTGRESQL
			) {
				setsubclientInfo();
			}
			if (self.applicationId == AppTypes.SQL_SERVER) {
				self.isSqlClone = true;
			} else if (self.applicationId == AppTypes.ORACLE || self.applicationId == AppTypes.ORACLE_RAC) {
				self.isOracleClone = true;
				self.data.cloneEnv.maxPit = moment()
					.add(1, 'hr')
					.toDate();
			} else if (self.applicationId === AppTypes.SAP_HANA) {
				self.isSAPHANAClone = true;
				self.data.cloneEnv.rsvTPDays = 0;
				self.data.cloneEnv.rsvTPHours = 1;
				self.data.cloneEnv.pitType = PIT;
				self.data.cloneEnv.toTime = moment().toDate();
				self.data.cloneEnv.maxPit = moment()
					.add(1, 'day')
					.toDate();
				self.data.restoreCatalogTime = angular.copy(self.data.cloneEnv.toTime);
			} else if (self.applicationId === AppTypes.POSTGRESQL) {
				self.isPostgresClone = true;
				self.data.cloneEnv.rsvTPDays = 1;
				self.data.cloneEnv.rsvTPHours = 0;
				self.data.cloneEnv.maxPit = moment()
					.add(1, 'hr')
					.toDate();
			} else if (self.applicationId === AppTypes.MYSQL) {
				self.isMySqlClone = true;
				self.data.cloneEnv.rsvTPDays = 1;
				self.data.cloneEnv.rsvTPHours = 0;
				self.data.cloneEnv.maxPit = moment()
					.add(1, 'hr')
					.toDate();
			} else if (self.applicationId === AppTypes.DB2 || self.applicationId === AppTypes.DB2_On_Unix) {
				self.isDB2Clone = true;
				self.showISCSIServer = true;
				self.data.cloneEnv.rsvTPDays = 1;
				self.data.cloneEnv.rsvTPHours = 0;
				self.data.cloneEnv.toTime = new Date();
				self.data.cloneEnv.maxPit = moment()
					.add(1, 'hours')
					.toDate();
			}
			self.openAccordion0 = true;
			self.errors = {};
			self.step = 0;
			$scope.database = {};

			if (data.toTime) {
				self.data.cloneEnv.pitType = PIT;
				self.data.cloneEnv.toTime = new Date(`${data.toTime}.000Z`);
			}

			self.sqlClientInstanceMap = new Map();

			self.backupsetDataList = [];

			self.defaultSubclientId = undefined;
			self.instanceDetails = undefined;
			getInstanceDetails(parseInt(self.instanceId));
		}
		$scope.$watch('dbClone.data.cloneEnv.toTime', function(newVal) {
			if ($scope.dbClone.previousToTime != newVal) {
				$scope.dbClone.previousToTime = newVal;
				$scope.dbClone.pitInvalid = false;
				$scope.dbClone.showSnapJobCheckError = false;
			}
		});

		var generalPageValidate = function() {
			//self.data.cloneEnv.fromTime & self.data.cloneEnv.toTime are browse time used for display;
			if (self.data.cloneEnv.pitType === PIT) {
				if ((self.isSqlClone && !self.data.cloneEnv.toTime) || new Date(self.data.cloneEnv.toTime) == 'Invalid Date') {
					self.pitErrorMsg = cvLoc('error.toTime');
					self.pitInvalid = true;
					return false;
				}
				if (
					(self.isDB2Clone || self.isOracleClone || self.isSAPHANAClone || self.isPostgresClone || self.isMySqlClone) &&
					(!self.data.cloneEnv.toTime || new Date(self.data.cloneEnv.toTime) == 'Invalid Date')
				) {
					self.pitErrorMsg = cvLoc('error.pit');
					self.pitInvalid = true;
					return false;
				}
			}
			self.previousToTime = self.data.cloneEnv.toTime;
			return true;
		};

		self.restoreCatalogSelected = function() {
			self.data.restoreCatalog = !self.data.restoreCatalog;
		};

		/**
		 * Validation method for the clone options page. Clone reservation days or hrs should be non zero
		 * value
		 */
		self.validateValue = function() {
			var rsvTime = self.data.cloneEnv.rsvTPDays + self.data.cloneEnv.rsvTPHours;
			if (!rsvTime || rsvTime < 1) {
				self.errors.rsvTPDays = true;
				self.openAccordion2 = true;
				return false;
			}
			self.errors.rsvTPDays = false;
			return true;
		};

		var validateCloneOptoins = function() {
			var isValid = self.validateValue();
			if (!isValid) return false;
			self.forceCleanup = 'No';
			if (self.data.cloneEnv.forceCleanup) {
				self.forceCleanup = 'Yes';
			}
			return true;
		};

		self.dummyInstance;
		self.destClientName;
		self.updateOptions = function(instanceSelected) {
			if (self.isOracleClone) {
				if (instanceSelected && instanceSelected.isDummyInstance) {
					instanceSelected.instanceName = self.data.instanceNameText;
					instanceSelected.oracleHome = self.data.cloneEnv.oraHome;
					instanceSelected.oracleUser = self.data.cloneEnv.oraUser;
				} else if (instanceSelected) {
					self.data.instanceNameText = instanceSelected.instanceName;
					self.data.instanceId = instanceSelected.instanceId;
					self.data.cloneEnv.oraHome = instanceSelected.oracleHome;
					self.data.cloneEnv.oraUser = instanceSelected.oracleUser;
				}
			} else if (self.isDB2Clone) {
				self.data.cloneEnv.db2Home = instanceSelected.db2Home;
				self.data.db2Username = instanceSelected.db2UserName;
			}
			self.data.instance = instanceSelected;
			if (self.isSAPHANAClone && self.saphanaMultiNode && instanceSelected.instanceId && instanceSelected.isMultiNode) {
				getBackupsetList(instanceSelected);
			}
			//for PostgreSQL and MYSQL
			setsubclientInfo();
		};

		self.pgBinBrowseFunction = function(result) {
			if (result) {
				self.data.instance.BinaryDirectory = result.path;
			}
		};

		self.pgLibBrowseFunction = function(result) {
			if (result) {
				self.data.instance.LibDirectory = result.path;
			}
		};

		self.pgCloneBrowseFunction = function(result) {
			if (result) {
				self.data.cloneEnv.stagingPath = result.path;
			}
		};

		//timeValue is already in UTC
		var fromatDateForServer = function(timeValue) {
			var dateString = timeValue.toDateString;
			return $filter('date')(dateString, 'yyyy-MM-ddTHH:mm:ss');
		};

		const getDefaultSubclientId = function(entity) {
			dbServerService
				.getSubClients(entity.clientId, entity.applicationId, entity.instanceId)
				.success(function(data) {
					data.forEach(subClinetNode => {
						if (subClinetNode.commonProperties.isDefaultSubclient) {
							self.defaultSubclientId = subClinetNode.subClientEntity.subclientId;
						}
					});
					if (self.defaultSubclientId) {
						self.showCopyPrecedence = true;
						self.entityType = 'SUBCLIENT_ENTITY';
						self.entityId = self.defaultSubclientId;
					}
				})
				.error(function(e) {
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};
		var getBackupsetList = function(entity) {
			idaService
				.getChildranData('BACKUPSET_ENTITY', entity)
				.success(function(data) {
					let backupsetList = [];
					if (data) {
						data.forEach(function(backupsetDetails) {
							if (
								self.applicationId === AppTypes.SAP_HANA &&
								backupsetDetails.backupSetEntity.backupsetName === 'SYSTEMDB'
							) {
								return;
							}
							backupsetList.push(backupsetDetails.backupSetEntity);
						});
					}
					self.backupsetDataList = backupsetList;
				})
				.error(function(e) {
					$log.error(e);
				});
		};
		function getInstanceDetails(instanceId) {
			idaService
				.getInstanceDetails(instanceId)
				.success(function(data) {
					if (data) {
						self.instanceDetails = data;
						//self.entity = self.instanceDetails.instance;
						self.clientId = self.entity.clientId;
						self.saphanaMultiNode = false;
						if (self.isSAPHANAClone) {
							var containerMode = _.get(self.instanceDetails, 'saphanaInstance.containerMode');
							self.saphanaMultiNode = containerMode === 1;
						}
						//RAC don't support clone to RAC, so default destination to source doesn't make sence
						if (self.applicationId != AppTypes.ORACLE_RAC) {
							self.data.destClient = {
								clientId: self.entity.clientId,
								clientName: self.entity.clientName,
								applicationId: self.entity.applicationId
							};
						}
						self.destClientName = self.entity.clientName;

						//Check if is ASM storage type for Oracle.
						if (self.entity.applicationId == AppTypes.ORACLE || self.entity.applicationId == AppTypes.ORACLE_RAC) {
							var ORA_ASM_DEVICE = 2;
							var ORA_IMAGE_ASM_DEVICE = 4;
							var storageType = self.instanceDetails.oracleInstance.storageType;
							self.isASMStorageType = storageType & ORA_ASM_DEVICE || storageType & ORA_IMAGE_ASM_DEVICE;
						}
						//sql currenlty doesn't have copy precedence support, so hide it for now
						if (!self.isSqlClone) {
							if (self.isSAPHANAClone) {
								self.showCopyPrecedence = true;
								if (self.saphanaMultiNode) {
									self.entityType = 'BACKUPSET_ENTITY';
									self.entityId = self.entity.backupsetId;
								} else {
									self.entityType = 'INSTANCE_ENTITY';
									self.entityId = self.instanceId;
								}
							} else if (self.isMySqlClone || self.isPostgresClone) {
								setsubclientInfo();
							} else {
								getDefaultSubclientId(self.entity);
							}
						}

						self.loadDestinationPage();
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
				});
		}

		self.loadDestinationPage = function() {
			if (self.clientsList == null && !self.isSqlClone) {
				self.populateClientList();
			}
			self.data.destClientLb = self.isSqlClone ? cvLoc('label.destinationClient') : cvLoc('label.clientName');
			self.data.cloneEnv.stagingPathLb = self.isSqlClone ? cvLoc('label.snapMountPath') : cvLoc('label.stagingPath');
			self.data.instanceLb = self.isSqlClone ? cvLoc('label.destinationInstance') : cvLoc('label.instanceName');
		};

		self.getAccessNode = function() {
			if (self.isOracleClone) {
				self.data.accessNode = {
					mediaAgentId: 0
				};
				self.linuxMediaAgents = [
					{
						mediaAgentId: 0,
						mediaAgentName: cvLoc('placeholder.accessNode'),
						displayName: cvLoc('placeholder.accessNode')
					}
				];
				storageService
					.getLinuxMediaAgents()
					.success(data => {
						data.forEach(ma => {
							self.linuxMediaAgents.push(ma);
						});
					})
					.error(e => {
						$scope.serverMessage = cvUtil.errMsg(e);
					});
			}
		};

		self.destClientChanged = function(client) {
			if (!self.isSqlClone) {
				self.populateInstanceDetails(client.clientId, client.applicationId);
			} else {
				self.instanceList = [];
				if (self.sqlClientInstanceMap.has(client.clientId) && self.sqlClientInstanceMap.get(client.clientId).length > 0)
					self.instanceList = cvUtil.sortAscending(self.sqlClientInstanceMap.get(client.clientId), 'instanceName');
				self.updateOptions(self.instanceList[0]);
			}
		};

		self.populateClientList = function() {
			if (self.isMySqlClone || self.isPostgresClone) {
				setPgClientList(true);
			} else {
				idaService.getRestoreDestinations(self.clientId, self.applicationId).then(
					function(data) {
						if (data != null) {
							var clientsList = [];
							/* For PostgreSQL and MySQL receives instance generic entities* */
							if (self.applicationId === AppTypes.POSTGRESQL || self.applicationId === AppTypes.MYSQL) {
								let serverList = [];
								let instancesMap = new Map();
								for (let i = 0; i < data.data.length; i++) {
									if (instancesMap.has(data.data[i].clientId)) {
										instancesMap.get(data.data[i].clientId).push(data.data[i]);
									} else {
										instancesMap.set(data.data[i].clientId, []);
										instancesMap.get(data.data[i].clientId).push(data.data[i]);
										let client = {
											clientId: data.data[i].clientId,
											clientName: data.data[i].clientName,
											applicationId: data.data[i].applicationId
										};
										serverList.push(client);
										if (self.clientId == client.clientId) self.data.destClient = client;
									}
								}
								self.clientsList = cvUtil.sortAscending(serverList, 'clientName');
								if (self.data.destClient == null) self.data.destClient = clientsList[0];
								self.destClientChanged(self.data.destClient);
							} else {
								data.data.sort((a, b) => {
									return a.clientName.localeCompare(b.clientName);
								});
								angular.forEach(data.data, function(clietnInfo) {
									//We don't support RAC to RAC clone. Only RAC to ORACLE single instance
									if (self.applicationId == AppTypes.ORACLE_RAC && clietnInfo.applicationId == AppTypes.ORACLE_RAC) {
										return;
									} else if (self.applicationId === AppTypes.SAP_HANA && self.clientId === clietnInfo.clientId) {
										// For SAP HANA Source client should be filter out
										return;
									}
									clientsList.push(clietnInfo);
									if (self.clientId == clietnInfo.clientId) self.data.destClient = clietnInfo;
								});
								self.clientsList = clientsList;
								if (self.data.destClient == null) self.data.destClient = clientsList[0];
								self.destClientChanged(self.data.destClient);
							}
						}
					},
					function(e) {
						$scope.serverMessage = {
							message: e.data,
							type: 'error'
						};
						$log.error('Error loading client groups');
					}
				);
			}
		};

		/**
		 * Find which destination instance to use for populating Oracle home with below criteria 1. Non ASM,
		 * (ASM instance name starts with + or -) 2. Find the first instance that matches source version 3. If
		 * no instance with matched version found, use first instance which has greater version than source 4.
		 * return {} otherwise
		 */
		function getInstanceForOracleHome() {
			var matchedVerInst;
			var greaterVerInst;

			var sourceVersion = self.instanceDetails.version ? self.instanceDetails.version.split('.') : undefined;
			self.instanceList.forEach(function(instance) {
				if (!instance.instanceName.startsWith('+') && !instance.instanceName.startsWith('-')) {
					//if same as source, no need to version
					if (instance.instanceId === self.instanceDetails.instance.instanceId) {
						matchedVerInst = instance;
					}

					if (sourceVersion && instance.version) {
						var version = instance.version.split('.');

						var cmp = 0;
						//compare major minor version in left to right order. Oracle version example: 11.5.1.2.0
						for (var i = 0, j = 0; i < sourceVersion.length || j < version.length; i++, j++) {
							var sV = i < sourceVersion.length ? parseInt(sourceVersion[i]) : 0;
							var v = j < version.length ? parseInt(version[j]) : 0;
							if (v != sV) {
								cmp = v - sV;
								break;
							}
						}

						if (cmp == 0 && !matchedVerInst) {
							matchedVerInst = instance;
						} else if (cmp > 0 && !greaterVerInst) {
							greaterVerInst = instance;
						}
					}
				}
			});
			return matchedVerInst ? matchedVerInst : greaterVerInst ? greaterVerInst : {};
		}

		self.populateInstanceDetails = function(clientId, applicationId) {
			var sourceInstanceId = self.instanceId;
			agentService
				.getInstances(clientId, applicationId)
				.success(function(data) {
					if (data != null) {
						var instanceList = [];
						angular.forEach(data, function(instance) {
							var instanceProps = new Object();
							instanceProps = instance.instance;
							var isOnDemandInstance = false;
							if (instance.oracleInstance) {
								instanceProps.version = instance.version;
								instanceProps.oracleHome = instance.oracleInstance.oracleHome;
								instanceProps.oracleUser = instance.oracleInstance.oracleUser.userName;
								isOnDemandInstance = instance.oracleInstance.isOnDemand;
							} else if (instance.postGreSQLInstance) {
								instanceProps.BinaryDirectory = instance.postGreSQLInstance.BinaryDirectory;
								instanceProps.LibDirectory = instance.postGreSQLInstance.LibDirectory;
								instanceProps.userName = instance.postGreSQLInstance.SAUser.userName;
								instanceProps.isDummyInstance = false;
							} else if (instance.mySqlInstance) {
								instanceProps.BinaryDirectory = instance.mySqlInstance.BinaryDirectory;
								instanceProps.userName = instance.mySqlInstance.SAUser.userName;
								instanceProps.isDummyInstance = false;
							} else if (instance.saphanaInstance && instance.saphanaInstance.DBInstances) {
								instanceProps.physicalClient = instance.saphanaInstance.DBInstances[0];
								var containerMode = _.get(instance, 'saphanaInstance.containerMode');
								instanceProps.isMultiNode = containerMode === 1;
							} else if (instance.db2Instance) {
								instanceProps.version = instance.version;
								instanceProps.db2Home = instance.db2Instance.homeDirectory;
								var userName = instance.db2Instance.userAccount.userName;
								if (instance.db2Instance.userAccount.domainName) {
									userName = instance.db2Instance.userAccount.domainName + '/' + userName;
								}
								instanceProps.db2UserName = userName;
								isOnDemandInstance = instance.db2Instance.isOnDemand;
								if (instance.instance.instanceId === sourceInstanceId) {
									isOnDemandInstance = true;
								}
							}
							if (!isOnDemandInstance) {
								instanceList.push(instanceProps);
							}
						});

						self.instanceList = cvUtil.sortAscending(instanceList, 'instanceName');

						var instance = new Object();
						if (self.isPostgresClone || self.isMySqlClone) {
							if (self.instanceList.length > 0) {
								instance = angular.copy(self.instanceList[0]);
								delete instance.instanceId;
							} else {
								instance.clientId = data.entity.clientId;
								instance.clientName = data.entity.clientName;
								instance.applicationId = data.entity.applicationId;
								instance.applicationName = data.entity.applicationName;
							}
							instance.instanceName = cvLoc('label.Custom');
							instance.isDummyInstance = true;
							self.instanceList.unshift(instance);
							instance.BinaryDirectory = '';
							if (self.isPostgresClone) {
								instance.LibDirectory = '';
							}
							instance.userName = '';
						} else {
							if (self.instanceList.length > 0) {
								var instanceForOracleHome = getInstanceForOracleHome();
								instance = angular.copy(instanceForOracleHome);
								delete instance.instanceId;
								self.data.cloneEnv.oraHome = instance.oracleHome;
								self.data.cloneEnv.oraUser = instance.oracleUser;
							} else {
								self.data.cloneEnv.oraHome = undefined;
								self.data.cloneEnv.oraUser = undefined;
							}
						}

						instance.isDummyInstance = true;
						self.dummyInstance = instance;
						self.updateOptions(instance);
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		self.showDataMasking = function() {
			return self.isOracleClone;
		};

		self.timeSelectionChange = function(pitType) {
			self.showSnapJobCheckError = false;
			self.pitInvalid = false;

			if (self.data.cloneEnv.pitType === PIT && self.isSqlClone) {
				self.data.cloneEnv.toTime = null;
			}
		};

		self.oraPfileResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.oraPfile = result.path;
		};

		self.stagingPathResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.stagingPath = result.path;
		};

		self.oracleHomeResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.oraHome = result.path;
		};

		self.db2HomeResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.db2Home = result.path;
		};

		self.commondFilePathResuleFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.commondFilePath = result.path;
		};

		self.diskMappingFileResultFunction = function(result) {
			$log.info('path : ' + result.path);
			self.data.cloneEnv.diskMappingFile = result.path;
		};

		self.composeCreateRecoveryObj = function() {
			var cloneData = self.data.cloneEnv;

			var timeRange = {
				fromTime: 0,
				toTime: 0
			};

			if (self.data.cloneEnv.pitType === PIT) {
				timeRange.toTime = getUnixTimestamp(self.data.cloneEnv.toTime);

				timeRange.fromTime = getUnixTimestamp(self.data.cloneEnv.fromTime);
			} else {
			}

			var miningJobs = [];
			if (self.sourceData.sourceDb.fullJobDetails) miningJobs.push(self.sourceData.sourceDb.fullJobDetails.jobId);

			var createRPObj = {
				//map to SQLRecoveryPointCreationObj.java
				maClientId: self.sqlRestoreOpts.destinationClient ? self.sqlRestoreOpts.destinationClient.clientId : 0,
				expireDays: self.data.cloneEnv.rsvTPDays,
				//back end doesn't support hours currently
				//expireHours: self.data.cloneEnv.rsvTPHours,
				database: self.sourceData.sourceDb ? self.sourceData.sourceDb.databaseName : '',
				destDatabase: self.sqlRestoreOpts.destinationDatabase
					? self.sqlRestoreOpts.destinationDatabase.databaseName
					: '',
				miningJobs: miningJobs,
				fromTimeRange: timeRange.fromTime ? timeRange.fromTime : 0,
				toTimeRange: timeRange.toTime ? timeRange.toTime : 0,
				clientId: self.sourceData && self.sourceData.sourceInstance ? self.sourceData.sourceInstance.clientId : 0,
				iscsiMountHostId: self.sqlRestoreOpts.proxyClient ? self.sqlRestoreOpts.proxyClient.clientId : 0,
				sourceInstance: self.sourceData ? self.sourceData.sourceInstance : 0,
				mountInstance: self.sqlRestoreOpts.destinationInstance,
				subclientId: self.sourceData.sourceDb.fullJobDetails ? self.sourceData.sourceDb.fullJobDetails.subclientId : 0,
				phyfileRename: self.sqlRestoreOpts.phyfileRename,
				logfileRename: self.sqlRestoreOpts.logfileRename,
				backupMethod: self.sourceData.sourceDb.fullJobDetails
					? self.sourceData.sourceDb.fullJobDetails.backupMethod
					: null,
				backupFinishTime: self.sourceData.sourceDb.fullJobDetails
					? self.sourceData.sourceDb.fullJobDetails.backupFinishTime
					: null,
				bOverwrite: self.data.cloneEnv.forceCleanup,
				enableLogReplay: self.data.cloneEnv.enableLogReplay
			};
			return createRPObj;
		};

		self.loadMediaAgents = function() {
			mbService.getOSType(self.sourceEntity.clientId).then(function successCallBack(response) {
				self.isUnixClient = response.data.toLowerCase() == 'unix';
				storageService.getMediaAgentForOSType(response.data.toLowerCase()).success(function(data) {
					let mediaAgentList = [];
					let nonMaNode = {
						displayName: cvLoc('label.selectNone'),
						mediaAgentId: -1,
						mediaAgentName: cvLoc('label.selectNone')
					};
					mediaAgentList.push(nonMaNode);
					data.forEach(ma => {
						let maNode = {
							displayName: ma.displayName,
							mediaAgentId: ma.mediaAgentId,
							mediaAgentName: ma.mediaAgentName
						};
						mediaAgentList.push(maNode);
					});
					self.mediaAgents = mediaAgentList;
				});
			});
		};

		self.createRecoveryPointJob = function() {
			sqlRecoveryPointsService
				.createRecoveryPointObject({
					createRecoveryPointObj: angular.toJson(self.composeCreateRecoveryObj())
				})
				.success(function(successData) {
					if (successData > 0 && successData.length > 0) {
						var jobUrl = '#/jobs/' + successData;
						var responseContent =
							' <a target="_self" href="' + jobUrl + '">' + cvLoc('label.cloneRedirectMsg', successData) + '</a>';
						cvToaster.showSuccessMessage({
							ttl: '15000',
							message: responseContent
						});
						self.close();
					} else {
						self.serverMessage = cvUtil.errMsgLoc('error.start.rp.job');
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsgLoc('generic_error');
					$log.error(e);
				});
			return;
		};

		function getUnixTimestamp(timeText) {
			return Math.floor(new Date(timeText).getTime() / 1000);
		}

		function formatDateForBackend(date) {
			return moment(moment(date).utc()).format('YYYY-MM-DDTHH:mm:ss');
		}

		self.submitCloneSnap = function() {
			var entityType = 'INSTANCE_ENTITY';
			var genericEntity = angular.copy(self.entity);
			if (self.isPostgresClone || self.isMySqlClone) {
				entityType = 'SUBCLIENT_ENTITY';
				genericEntity = angular.copy(self.sourceEntity);
			}

			var composeAgentSpecificOptions = function() {
				var agentSpecificOptions = new Object();
				var cloneData = self.data.cloneEnv;
				var resrTime = cloneData.rsvTPDays * 24 * 60 * 60 + cloneData.rsvTPHours * 60 * 60;

				if (self.isOracleClone) {
					var userConnect = new Object();
					agentSpecificOptions.noCatalog = true;
					agentSpecificOptions.cloneEnv = true;
					agentSpecificOptions.resetLogs = 0;
					agentSpecificOptions.restoreData = true;

					agentSpecificOptions.recover = true;

					agentSpecificOptions.cloneEnvParameters = self.data.cloneEnv;

					agentSpecificOptions.cloneEnvParameters.resrvTimePeriod = resrTime;
					agentSpecificOptions.cloneEnvParameters.instanceId = self.data.instance.instanceId;
					agentSpecificOptions.cloneEnvParameters.overfideExists = self.data.cloneEnv.forceCleanup;
					agentSpecificOptions.cloneEnvParameters.oraSID = self.data.instance.instanceName;

					//Set redoLogSize in format same as Java GUI
					if (self.data.cloneEnv.redoLogSize) {
						agentSpecificOptions.duplicateToLogFile = true;
						agentSpecificOptions.logFileGroup = true;
						agentSpecificOptions.duplicateToLogFilesList =
							"LOGFILE&#10;GROUP 1&#10;(&#10;'redo' &#10;)  SIZE " + self.data.cloneEnv.redoLogSize + 'M&#10;';
						agentSpecificOptions.duplicateToLogFilesListValue = [
							'1\t' + self.data.cloneEnv.redoLogSize + '\tM\tno&#10;redo'
						];
					}
					//Set Username to empty for Oracle.
					agentSpecificOptions.cloneEnvParameters.oraUser = undefined;

					//Set restore and recover time
					agentSpecificOptions.restoreFrom = PIT;
					agentSpecificOptions.restoreTime = {
						time: 0
					};
					agentSpecificOptions.recoverFrom = LATEST_SCN_NUMBER;
					if (self.data.cloneEnv.pitType === PIT) {
						var unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
						agentSpecificOptions.restoreTime.time = unixTime;
						agentSpecificOptions.recoverFrom = PIT;
						agentSpecificOptions.recoverTime = {
							time: unixTime
						};
					}
				} else if (self.isSAPHANAClone) {
					agentSpecificOptions.checkAccess = true;
					agentSpecificOptions.initializeLogArea = true;
					agentSpecificOptions.ignoreDeltaBackups = false;
					agentSpecificOptions.cloneEnv = true;
					agentSpecificOptions.destPseudoClientName = self.data.destClient.clientName;
					//agentSpecificOptions.destinationInstanceDir = self.data.cloneEnv.stagingPath
					if (self.saphanaMultiNode) {
						agentSpecificOptions.destDbName = self.data.destBackupset.backupsetName;
						let databases = [];
						databases.push(self.entity.instanceName);
						agentSpecificOptions.databases = databases;
					} else {
						agentSpecificOptions.destDbName = self.data.instance.instanceName;
					}

					agentSpecificOptions.cloneEnvParameters = {} /* self.data.cloneEnv */;
					agentSpecificOptions.cloneEnvParameters.resrvTimePeriod = resrTime;
					agentSpecificOptions.cloneEnvParameters.forceCleanup = self.data.cloneEnv.forceCleanup;
					agentSpecificOptions.cloneEnvParameters.stagingPath = self.data.cloneEnv.stagingPath;
					if (self.data.cloneEnv.pitType == 1) {
						var unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
						agentSpecificOptions.recoverTime = 1;
						agentSpecificOptions.pointInTime = {
							time: unixTime
						};
					} else {
						agentSpecificOptions.recoverTime = 0;
						if (self.data.cloneEnv.pitType == 3) {
							agentSpecificOptions.backupPrefix = self.data.cloneEnv.useBackupPrefix;
						} else {
							agentSpecificOptions.sapInternalBackupId = self.data.cloneEnv.useInternalId;
						}
					}
					//catalogPointInTime
					if (self.data.restoreCatalog) {
						if (self.data.restoreCatalogType === '1') {
							agentSpecificOptions.catalogRecoverTime = 1;
							agentSpecificOptions.catalogPointInTime = {
								time: _.toInteger(self.data.restoreCatalogTime.getTime() / 1000)
							};
						} else {
							agentSpecificOptions.catalogRecoverTime = 2;
							let catRecoverTime = self.data.relativeToSysdateValue;
							if (self.data.relativeToSysdateDays == self.dayTypeList[0]) {
								catRecoverTime = catRecoverTime * 24 * 60;
							} else {
								catRecoverTime = catRecoverTime * 60;
							}
							agentSpecificOptions.recoverTime = catRecoverTime;
						}
					}
				} else if (self.isPostgresClone) {
					agentSpecificOptions.fsBackupSetRestore = true;
					agentSpecificOptions.isCloneRestore = true;
					agentSpecificOptions.tableLevelRestore = false;
					agentSpecificOptions.instanceRestore = false;
					agentSpecificOptions.cloneOptions = {};
					agentSpecificOptions.cloneOptions.binaryDirectory = self.data.instance.BinaryDirectory;
					agentSpecificOptions.cloneOptions.libDirectory = self.data.instance.LibDirectory;
					agentSpecificOptions.cloneOptions.user = self.data.instance.userName;
					agentSpecificOptions.cloneOptions.port = self.pgPort;
					agentSpecificOptions.cloneOptions.stagingLocaion = self.data.cloneEnv.stagingPath;
					agentSpecificOptions.cloneOptions.forceCleanup = self.data.cloneEnv.forceCleanup;
					agentSpecificOptions.cloneOptions.isInstanceSelected = self.data.instance.isDummyInstance ? false : true;
					agentSpecificOptions.cloneOptions.reservationPeriodS = resrTime;

					if (self.data.cloneEnv.pitType === PIT) {
						let unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
						agentSpecificOptions.fromTime = {
							time: unixTime
						};
						agentSpecificOptions.refTime = {
							time: unixTime
						};
						agentSpecificOptions.pointOfTime = {
							time: unixTime
						};
					} else {
						let unixTime = 0;
						agentSpecificOptions.fromTime = {
							time: unixTime
						};
						agentSpecificOptions.refTime = {
							time: unixTime
						};
					}
				} else if (self.isMySqlClone) {
					agentSpecificOptions.isCloneRestore = true;
					agentSpecificOptions.cloneOptions = {};
					agentSpecificOptions.cloneOptions.binaryDirectory = self.data.instance.BinaryDirectory;
					agentSpecificOptions.cloneOptions.user = self.data.instance.userName;
					agentSpecificOptions.cloneOptions.port = self.pgPort;
					agentSpecificOptions.cloneOptions.stagingLocaion = self.data.cloneEnv.stagingPath;
					agentSpecificOptions.cloneOptions.forceCleanup = self.data.cloneEnv.forceCleanup;
					agentSpecificOptions.cloneOptions.isInstanceSelected = self.data.instance.isDummyInstance ? false : true;
					agentSpecificOptions.cloneOptions.reservationPeriodS = resrTime;
					if (self.data.cloneEnv.pitType === PIT) {
						let unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
						agentSpecificOptions.fromTime = {
							time: unixTime
						};
						agentSpecificOptions.refTime = {
							time: unixTime
						};
						agentSpecificOptions.pointOfTime = {
							time: unixTime
						};
					} else {
						let unixTime = 0;
						agentSpecificOptions.fromTime = {
							time: unixTime
						};
						agentSpecificOptions.refTime = {
							time: unixTime
						};
					}
				} else if (self.isDB2Clone) {
					agentSpecificOptions.cloneRecovery = true;
					agentSpecificOptions.redirect = true;
					agentSpecificOptions.storagePath = true;
					agentSpecificOptions.restoreType = 0;
					agentSpecificOptions.targetPath = self.data.cloneEnv.stagingPath;
					agentSpecificOptions.redirectAllPaths = self.data.cloneEnv.stagingPath;
					agentSpecificOptions.storagePaths = [self.data.cloneEnv.stagingPath];
					agentSpecificOptions.targetDb = self.sourceEntity.backupsetName;
					agentSpecificOptions.cloneOptions = {};
					agentSpecificOptions.cloneOptions.forceCleanup = self.data.cloneEnv.forceCleanup;
					agentSpecificOptions.cloneOptions.homeDir = self.data.cloneEnv.db2Home;
					agentSpecificOptions.cloneOptions.reservationTime = resrTime;
					var cloneUser = new Object();
					var userName = self.data.db2Username;
					if (userName.indexOf('\\') != -1) {
						var userValues = userName.split('\\');
						cloneUser.domainName = userValues[0];
						cloneUser.userName = userValues[1];
					} else if (userName.indexOf('/') != -1) {
						var userValues = userName.split('/');
						cloneUser.domainName = userValues[0];
						cloneUser.userName = userValues[1];
					} else {
						cloneUser.userName = self.data.db2Username;
					}

					cloneUser.password = cvUtil.getBytes(self.data.db2UserPassword);
					agentSpecificOptions.cloneOptions.cloneUser = cloneUser;
					agentSpecificOptions.cloneOptions.targetDBName = self.cloneDbName;
					agentSpecificOptions.cloneOptions.targetDbPath = self.data.cloneEnv.stagingPath;

					agentSpecificOptions.redirectStorageGroups = false;
					agentSpecificOptions.useSnapRestore = false;
					agentSpecificOptions.recoverDb = true;
					agentSpecificOptions.useAlternateLogFile = false;
					agentSpecificOptions.rollForward = true;
					if (self.data.cloneEnv.pitType === '0') {
						agentSpecificOptions.rollForwardToEnd = 1;
					} else {
						agentSpecificOptions.rollForwardToEnd = 0;
						let pitTime = self.data.cloneEnv.toTime.getTime() / 1000;
						agentSpecificOptions.rollForwardTime = {
							time: Math.floor(pitTime)
						};
					}
					agentSpecificOptions.rollForwardPending = false;
				}
				return agentSpecificOptions;
			};

			var agentSpecificOptions = composeAgentSpecificOptions();

			var composeDestination = function() {
				var destination = new Object();
				destination.destClient = self.data.destClient;
				//reset custom instance name
				if ((self.isPostgresClone || self.isMySqlClone) && self.data.instance.isDummyInstance) {
					self.data.instance.instanceName = '';
				}

				//Need to populate appId if user enters a new destination instance instead of selecting existing instance.
				destination.destinationInstance = angular.extend({}, destination.destClient, {
					//RAC restores to Oracle instead of RAC
					applicationId: self.applicationId == AppTypes.ORACLE_RAC ? AppTypes.ORACLE : self.entity.applicationId,
					appName: self.applicationId == AppTypes.ORACLE_RAC ? 'Oracle' : self.entity.appName,
					instanceId: self.data.instance.instanceId,
					instanceName: self.data.instance.instanceName
				});

				if (self.isSAPHANAClone && self.saphanaMultiNode) {
					destination.destinationBackupset = self.data.destBackupset;
				}

				return destination;
			};

			var browseOption = {
				commCellId: 2,
				browseJobId: null,
				timeRange: {
					fromTimeValue: null,
					toTimeValue: null
				},
				mediaOption: {
					copyPrecedence: {
						copyPrecedenceApplicable: true,
						copyPrecedence: self.data.cloneEnv.copyPrec
					}
				}
			};

			if (self.showISCSIServer && self.data.iSCSIServer && self.data.iSCSIServer.mediaAgentId > 0) {
				browseOption.mediaOption.useISCSIMount = true;
				browseOption.mediaOption.proxyForSnapClients = {
					clientId: self.data.iSCSIServer.mediaAgentId,
					clientName: self.data.iSCSIServer.mediaAgentName
				};
			}

			if (self.isOracleClone) {
				browseOption.timeRange.fromTime = 0;
				browseOption.timeRange.toTime = 0;
				if (self.data.cloneEnv.pitType === PIT) {
					var unixTime = getUnixTimestamp(self.data.cloneEnv.toTime);
					browseOption.timeRange.toTime = unixTime;
				}
			}

			if (self.data.accessNode && self.data.accessNode.mediaAgentId) {
				browseOption.mediaOption.useISCSIMount = true;
				browseOption.mediaOption.proxyForSnapClients = {
					clientId: self.data.accessNode.mediaAgentId,
					clientName: self.data.accessNode.mediaAgentName
				};
			}

			if (self.isPostgresClone || self.isMySqlClone) {
				browseOption.listMedia = false;
				browseOption.useExactIndex = false;
				browseOption.noImage = false;
				browseOption.backupset = {
					backupsetId: self.sourceEntity.backupsetId,
					clientId: self.sourceEntity.clientId
				};
				browseOption.mediaOption.copyPrecedence = {
					copyPrecedenceApplicable: false
				};
			}

			var destination = composeDestination();

			var commonOptions = new Object();
			if (self.data.commondFilePath) {
				commonOptions.prePostOpts = {
					postRecoveryCommand: self.data.commondFilePath,
					impersonation: {
						level: 1
					}
				};
			}

			var composeDataMaskingOptions = function() {
				if (self.showDataMasking()) {
					return self.data.dataMaskingOptions;
				}
				return undefined;
			};
			var dataMaskingOptions = composeDataMaskingOptions();

			idaService
				.submitCloneJob({
					entityType: entityType,
					genericEntity: angular.toJson(genericEntity),
					browseOption: angular.toJson(browseOption),
					destination: angular.toJson(destination),
					commonOptions: angular.toJson(commonOptions),
					agentSpecificOptions: angular.toJson(agentSpecificOptions),
					dmOptions: angular.toJson(dataMaskingOptions),
					passwordsInfo: null
				})
				.success(function(successData) {
					if (successData) {
						var jobUrl = '#/jobs/' + successData;
						var responseContent =
							cvLoc('label.cloneRedirectMsg', successData) +
							' <br> <a href="' +
							jobUrl +
							'">' +
							cvLoc('notification.jobDetails') +
							'</a>';
						cvToaster.showSuccessMessage({
							ttl: '15000',
							message: responseContent
						});
						self.close();
					}
				})
				.error(function(err) {
					cvToaster.showErrorMessage({
						message: err
					});
				});
			return;
		};

		self.cancel = function() {
			console.log(wizardForm);
			$uibModalInstance.dismiss();
		};

		self.close = function() {
			$uibModalInstance.close();
		};

		const checkSQLDBSnapJob = function() {
			const options = new Object();

			let toTime = self.data.cloneEnv.toTime;
			if (self.data.cloneEnv.pitType != PIT) {
				toTime = new Date();
			}
			options.toTime = formatDateForBackend(toTime); // in format "2020-04-30T05:21:38"

			options['applicationId'] = AppTypes.SQL_SERVER;
			options['entityId'] = data.entity.instanceId;
			options['entityType'] = 'INSTANCE_ENTITY';
			options['path'] = '\\';
			options['pageSize'] = 15;
			options['currentPage'] = 0;
			options['sortingInfo'] = 'asc:Flags,FileName';
			options['pagingInfo'] = '0,15';
			options['sqlMergeRPToClone'] = true;

			idaService.getSnapDatabases(
				{
					applicationId: data.entity.applicationId,
					clientId: data.entity.clientId,
					instanceId: data.entity.instanceId,
					entityType: 5
				},
				options,
				getSnapDatabasesSuccess,
				getSnapDatabasesError
			);
		};

		const getSnapDatabasesSuccess = function(data) {
			var backupMethod = -1;

			if (data && data.length > 0) {
				const dbName = self.sourceData.sourceDb.databaseName.toUpperCase();
				angular.forEach(data, function(db) {
					if (backupMethod === -1) {
						if (db.databaseName.toUpperCase() === dbName && db.fullJobDetails) {
							//we cannot use dbId here, as they are using different set of IDs

							backupMethod = db.fullJobDetails.backupMethod;
							self.sourceData.sourceDb.fullJobDetails = db.fullJobDetails;
							self.createRecoveryPointJob();
						}
					}
				});
			}

			if (backupMethod === -1) {
				getSnapDatabasesError();
			}
		};

		const getSnapDatabasesError = function() {
			self.showSnapJobCheckError = true;
			self.openAccordion0 = true;
		};

		self.submit = function() {
			let validateMethods = [generalPageValidate, validateCloneOptoins];

			for (var i in validateMethods) {
				let valid = validateMethods[i]();

				if (!valid) {
					return;
				}
			}

			if (self.isSqlClone) {
				checkSQLDBSnapJob();
			} else {
				self.submitCloneSnap();
			}
		};

		init();
	}
]);

export default app;
